/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.AuditBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.VoucherBaseAuditValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;

public class AuditVoucherService
extends AuditBaseVoucherService {
    public AuditVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected String getVoucherTable() {
        return "t_gl_voucher";
    }

    @Override
    protected void validate(Context ctx, BaseVoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException, EASBizException {
        VoucherValidator validator = this.getValidator(this.sysParam, auditorId.toString());
        if (validator != null) {
            validator.validate(ctx, (VoucherInfo)voucherInfo);
        }
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected SelectorItemCollection getAuditSelector() {
        return VoucherInfo.getAuditVoucherSelector();
    }

    protected VoucherValidator getValidator(GlParam sysParam, String auditorId) throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBaseAuditValidator(sysParam, auditorId));
        return validator;
    }

    @Override
    protected void clearAuditBack(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean useWorkflow = sysParam.getBoolean("GL_032");
        boolean ishandAuditBack = sysParam.getBoolean("GL_099");
        if (!useWorkflow && ishandAuditBack && voucherInfo.getId().toString() != null) {
            DbUtil.execute((Context)ctx, (String)" update T_GL_Voucher set FIsAuditBack=0  where FID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
            DbUtil.execute((Context)ctx, (String)" delete from T_GL_AuditOpinion  where FVoucherID = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    @Override
    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (VoucherInfo)voucherInfo, VoucherStatusEnum.AUDITTED);
    }

    @Override
    protected void afterAudit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, BgCtrlException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        VoucherUtil.requestBudgetSubstract(ctx, voucherInfo, this.sysParam, 8);
        this.sendACNotice(ctx, voucherInfo, this.sysParam);
        this.synVoucher2Books(ctx, voucherInfo, this.sysParam);
        this.invokeVoucherAuditPostProcessor(ctx, voucherInfo);
    }

    private void sendACNotice(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean isNoticeByAudit = sysParam.getInt("GLG01_2") == 0;
        boolean useACNotice = sysParam.getBoolean("GLG01");
        if (isNoticeByAudit && useACNotice) {
            AcNoticeUtil.dealAcNotice(ctx, null, voucherInfo, voucherInfo.getCompany().getId().toString());
        }
    }

    private void synVoucher2Books(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean isCanCreateBook = sysParam.getBoolean("G012");
        if (isCanCreateBook && this.isMasterBook(ctx, voucherInfo.getCompany().getId().toString())) {
            boolean useReport = sysParam.getBoolean("G001");
            boolean allowCussent = sysParam.getBoolean("GL_028");
            boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
            BookUtil._transferVoucher(ctx, 0, voucherInfo.getId().toString(), voucherInfo.getCompany().getId().toString(), useReport, allowCussent, isInTimeVerify);
        }
    }

    private boolean isMasterBook(Context ctx, String companyId) {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            Boolean isMaster;
            if (cache.getMasterBookMap().containsKey(companyId)) {
                isMaster = (Boolean)cache.getMasterBookMap().get(companyId);
            } else {
                isMaster = BooksUtil.isMasterBook((Context)ctx);
                cache.setMasterBook(companyId, isMaster);
            }
            return isMaster;
        }
        return BooksUtil.isMasterBook((Context)ctx);
    }

    private void invokeVoucherAuditPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherPostProcessorInvokeFactory.invokeVoucherAuditPostProcessor(ctx, voucherInfo);
    }

    @Override
    protected void updateAuditStatus(Context ctx, BaseVoucherInfo voucherInfo, BOSUuid auditorId) throws BOSException {
        VoucherOprateSharer.updateVoucherStatus(ctx, voucherInfo.getId().toString(), auditorId.toString(), VoucherStatusEnum.AUDITTED.getValue(), "FAuditorId");
        UserInfo auditor = new UserInfo();
        auditor.setId(auditorId);
        voucherInfo.setAuditor(auditor);
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherAudit", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherAudit", "After");
    }
}

