/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.IAccountCurrency;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryInfo;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.GLVerifyTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VerifyManualAutoEnum;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.GLAcctAgeUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.voucher.IAutoVerifyService;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoVerifyService
implements IAutoVerifyService {
    protected static final Logger logger = Logger.getLogger(AutoVerifyService.class);
    private final BigDecimal ZERO = new BigDecimal("0");
    private int count = 100000;
    private int maxCount = 1000000;
    private int batchCount = 2000;
    private int fetchSize = 500;
    private long maxTxTime = 2400000L;
    private long txTime = 0L;
    private long txStartTime = 0L;
    private String actTemp = null;
    private String verTemp = null;
    private boolean completeTX = true;
    private Connection conn = null;
    private Map<String, List> srcPositive = new HashMap<String, List>();
    private Map<String, List> desPositive = new HashMap<String, List>();
    private Map<String, List> srcNegative = new HashMap<String, List>();
    private Map<String, List> desNegative = new HashMap<String, List>();
    private List<String> hgIdSrcList = new ArrayList<String>();
    private List<String> hgIdDesList = new ArrayList<String>();
    private PreparedStatement sqlUpdateRecordStatus = null;
    private PreparedStatement sqlUpdateActStatus = null;
    private PreparedStatement sqlUpdateActAmt = null;
    private PreparedStatement sqlUpdateVerAmt = null;
    private int record = 0;
    private int actCnt = 0;
    private int actAmt = 0;
    private int verAmt = 0;
    private String asstKey = "FAssIDsTmp";
    private String hgKey = "FAssGrpID";
    private java.util.Date sysStartDate = new java.util.Date(0L);

    @Override
    public Map autoVerify(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (param.get("isTask") != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            this.txStartTime = System.currentTimeMillis();
            if (company == null) {
                company = ContextUtil.getCurrentFIUnit((Context)ctx);
                param.put("company", company);
            }
            String number = this.getAcctcussentHistoryNumber(ctx, null, company);
            param.put("hisNumber", number);
            this.autoVerifyByAccountAsTask(ctx, param);
            result.put("completeTX", this.completeTX);
        } else if (param.get("isAgeVerify") != null) {
            this.autoVerifyForAgeAccount(ctx, param);
        } else {
            this.autoVerifyByAccounts(ctx, param);
        }
        return result;
    }

    private void autoVerifyByAccounts(Context ctx, Map param) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("COMPANY");
        param.put("company", company);
        java.util.Date dateTo = (java.util.Date)param.get("bizDateTo");
        if (dateTo != null) {
            param.put("dateTo", dateTo);
        }
        String number = this.getAcctcussentHistoryNumber(ctx, null, company);
        param.put("hisNumber", number);
        this.autoVerifyByAccountAsTask(ctx, param);
    }

    private void autoVerifyForAgeAccount(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        ArrayList<Map<String, Object>> verifyDesData = new ArrayList();
        boolean isNegative = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NEGATIVEVERIFY);
        boolean isRptQuery = false;
        if (param.containsKey("isRptQuery")) {
            isRptQuery = (Boolean)param.get("isRptQuery");
        }
        if (!isRptQuery) {
            boolean queryByBal;
            List<Map<String, Object>> verifySrcData = this._getVerifySrcData(ctx, param);
            logger.error((Object)("verifySrcData.size-->" + verifySrcData.size()));
            boolean bl = queryByBal = param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.QUERYBYBAL) != null;
            if (queryByBal) {
                verifyDesData = this._getVerifyObjData(ctx, param);
                logger.error((Object)("verifyDesData.size-->" + verifyDesData.size()));
            }
            this.autoVerifyForAccountCal(ctx, param, isNegative, queryByBal, verifySrcData, verifyDesData);
        } else {
            this.autoVerifyAccountAgeForRptQuery(ctx, param, isNegative);
        }
    }

    private void autoVerifyAccountAgeForRptQuery(Context ctx, Map<String, Object> param, boolean isNegative) throws BOSException, EASBizException {
        String accountIdStr = (String)param.get("accountIdStrForRpt");
        if (accountIdStr == null || "".equals(accountIdStr)) {
            return;
        }
        Map accountDateType = (Map)param.get("accountDateTypeForRptQuery");
        String[] accountIds = accountIdStr.split(",");
        List<Map<String, Object>> verifySrcData = this._getVerifySrcData(ctx, param);
        logger.error((Object)("verifySrcData.size-->" + verifySrcData.size()));
        boolean queryByBal = param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.QUERYBYBAL) != null;
        List verifyDesData = new ArrayList();
        if (queryByBal) {
            verifyDesData = this._getVerifyObjData(ctx, param);
            logger.error((Object)("verifyDesData.size-->" + verifyDesData.size()));
        }
        for (String accountId : accountIds) {
            int dateType = (Integer)accountDateType.get(accountId);
            accountId = accountId.substring(1, accountId.length() - 1);
            ArrayList<Map<String, Object>> verifySrcDataForAccount = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> verifyDesDataForAccount = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> vefifySrcDataMap : verifySrcData) {
                if (!accountId.equals(vefifySrcDataMap.get("faccountid"))) continue;
                verifySrcDataForAccount.add(vefifySrcDataMap);
            }
            for (Map<String, Object> verifyDesDataMap : verifyDesData) {
                if (!accountId.equals(verifyDesDataMap.get("faccountid"))) continue;
                verifyDesDataForAccount.add(verifyDesDataMap);
            }
            if (dateType == 1) {
                this.verifydataSortByEndDate(verifySrcDataForAccount);
                this.verifydataSortByEndDate(verifyDesDataForAccount);
            }
            this.autoVerifyForAccountCal(ctx, param, isNegative, queryByBal, verifySrcDataForAccount, verifyDesDataForAccount);
        }
    }

    private void verifydataSortByEndDate(List<Map<String, Object>> verifyDataForAccount) {
        Collections.sort(verifyDataForAccount, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map o11 = (Map)o1;
                Map o22 = (Map)o2;
                java.util.Date endDate1 = (java.util.Date)o11.get("fendDate");
                java.util.Date endDate2 = (java.util.Date)o22.get("fendDate");
                return endDate1.compareTo(endDate2);
            }
        });
    }

    private void autoVerifyForAccountCal(Context ctx, Map<String, Object> param, boolean isNegative, boolean queryByBal, List<Map<String, Object>> verifySrcDataForAccount, List<Map<String, Object>> verifyDesDataForAccount) throws BOSException, EASBizException {
        ArrayList<Map> verifiedData = new ArrayList();
        if (queryByBal) {
            HashMap<String, List> srcPositive = new HashMap<String, List>();
            HashMap<String, List> desPositive = new HashMap<String, List>();
            HashMap<String, List> srcNegative = new HashMap<String, List>();
            HashMap<String, List> desNegative = new HashMap<String, List>();
            if (isNegative) {
                this._sameVerify_Age_New(ctx, verifySrcDataForAccount, param, srcPositive, srcNegative, true);
                this._sameVerify_Age_New(ctx, verifyDesDataForAccount, param, desPositive, desNegative, false);
            } else {
                this.getPositiveAndNegativeMap(verifySrcDataForAccount, param, srcPositive, srcNegative);
                this.getPositiveAndNegativeMap(verifyDesDataForAccount, param, desPositive, desNegative);
            }
            verifiedData.addAll(this.autoVerify_Age_New(ctx, param, srcNegative, desNegative, true));
            verifiedData.addAll(this.autoVerify_Age_New(ctx, param, srcPositive, desPositive, false));
        } else {
            verifiedData = verifySrcDataForAccount;
        }
        if (param.containsKey("noTempTable")) {
            param.put("acData", verifiedData);
        } else {
            this.insetDataAfterVerify(ctx, param, verifiedData);
        }
    }

    private void insetDataAfterVerify(Context ctx, Map<String, Object> param, List<Map> verifiedData) throws BOSException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            String tempTable = (String)param.get("tempTable");
            String selector = (String)param.get("selector");
            String[] keys = selector.split(",");
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(this.getInsertTempSQL(tempTable, keys));
            int k = 1;
            int c = 0;
            Map item = null;
            for (int i = 0; i < verifiedData.size(); ++i) {
                item = verifiedData.get(i);
                if (item == null) continue;
                for (String key : keys) {
                    ps.setObject(k++, item.get(key));
                }
                ps.addBatch();
                k = 1;
                if (++c % 2000 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
                c = 0;
            }
            if (c > 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private String getInsertTempSQL(String tempTable, String[] keys) {
        StringBuilder insert = new StringBuilder();
        StringBuilder values = new StringBuilder(" values(");
        insert.append(" insert into ").append(tempTable).append(" (");
        for (String key : keys) {
            insert.append(key).append(",");
            values.append("?,");
        }
        insert.deleteCharAt(insert.length() - 1);
        values.deleteCharAt(values.length() - 1);
        values.append(")");
        insert.append(") ").append((CharSequence)values);
        return insert.toString();
    }

    private void autoVerifyByAccount(Context ctx, AccountViewInfo acct, CompanyOrgUnitInfo company, Map<String, Object> param) throws EASBizException, BOSException {
        List<CurrencyInfo> currencys = this.getCurrencyListFromParam(ctx, param, acct);
        CurrencyInfo cyInfo = null;
        for (int i = 0; i < currencys.size(); ++i) {
            cyInfo = currencys.get(i);
            if (i == currencys.size() - 1) {
                param.put("lastCurrency", "1");
            }
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.CURRENCY, cyInfo);
            this.delVerifyTaskSrcData(ctx, param);
        }
    }

    private void autoVerifyByAccountAsTask(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        try {
            this.conn = EJBFactory.getConnection((Context)ctx);
            this.initPrepareStatment(this.conn);
            this.delVerifyTaskSrcData(ctx, param);
            this.commitLastData();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)this.sqlUpdateRecordStatus);
            SQLUtils.cleanup((Statement)this.sqlUpdateActStatus);
            SQLUtils.cleanup((Statement)this.sqlUpdateActAmt);
            SQLUtils.cleanup((Statement)this.sqlUpdateVerAmt, (Connection)this.conn);
        }
    }

    private void initPrepareStatment(Connection con) throws SQLException {
        this.sqlUpdateRecordStatus = this.conn.prepareStatement("update T_GL_VoucherAssistRecord set FIsVierified = 1 where fid = ? ");
        this.sqlUpdateActStatus = this.conn.prepareStatement("update t_gl_acctcussent set FIsVierified = 1 where fvchassistrecordid = ? ");
        this.sqlUpdateActAmt = this.conn.prepareStatement("update T_GL_AcctCussent set FUnVerifiedAmtFor = ?, FUnverifiedAmtLocal=? , FUnverifiedAmtRpt=? , FUnverifiedQty=? where fid = ? ");
        this.sqlUpdateVerAmt = this.conn.prepareStatement("update T_GL_AcctVerify set FUnVerifiedAmtFor = ?, FUnverifiedAmtLocal=? , FUnverifiedAmtRpt=? , FUnverifiedQty=? where FVchAssistRecordID = ? ");
    }

    private void executeTask(Context ctx, Map<String, Object> param, List<Map<String, Object>> verifySrcData, List<Map<String, Object>> verifyDesData) throws EASBizException, BOSException {
        boolean isNegative = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NEGATIVEVERIFY);
        boolean veifySameByAmt = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYSAMEBYAMT);
        if (veifySameByAmt) {
            if (isNegative) {
                this.sameAmtVerify(ctx, param, this.srcPositive, this.srcNegative, VerifyType.SAMEVERIFY);
                this.sameAmtVerify(ctx, param, this.desPositive, this.desNegative, VerifyType.VERIFYPANDN);
            }
            this.sameAmtVerify(ctx, param, this.srcNegative, this.desNegative, VerifyType.NEGATIVEVERIFY);
            this.sameAmtVerify(ctx, param, this.srcPositive, this.desPositive, VerifyType.COMMONVERIFY);
        }
        if (isNegative) {
            this._sameVerify_New(ctx, param, this.srcPositive, this.srcNegative, true);
            this._sameVerify_New(ctx, param, this.desPositive, this.desNegative, false);
        }
        this.autoVerify_New(ctx, param, this.srcNegative, this.desNegative, true);
        this.autoVerify_New(ctx, param, this.srcPositive, this.desPositive, false);
        boolean exeManualLogic = false;
        if (exeManualLogic) {
            this.srcPositive = this.resetKey(this.srcPositive, this.asstKey);
            this.srcNegative = this.resetKey(this.srcNegative, this.asstKey);
            this.desPositive = this.resetKey(this.desPositive, this.asstKey);
            this.desNegative = this.resetKey(this.desNegative, this.asstKey);
            if (isNegative) {
                this._sameVerify_New(ctx, param, this.srcPositive, this.srcNegative, true);
                this._sameVerify_New(ctx, param, this.desPositive, this.desNegative, false);
            }
            this.autoVerify_New(ctx, param, this.srcNegative, this.desNegative, true);
            this.autoVerify_New(ctx, param, this.srcPositive, this.desPositive, false);
            this.srcPositive = this.resetKey(this.srcPositive, this.hgKey);
            this.srcNegative = this.resetKey(this.srcNegative, this.hgKey);
            this.desPositive = this.resetKey(this.desPositive, this.hgKey);
            this.desNegative = this.resetKey(this.desNegative, this.hgKey);
        }
        this.dealVerifiedData();
    }

    private void sameAmtVerify(Context ctx, Map<String, Object> param, Map<String, List> src, Map<String, List> obj, VerifyType verifyType) throws BOSException, EASBizException {
        for (Map.Entry<String, List> entry : src.entrySet()) {
            String key = entry.getKey();
            List srcList = entry.getValue();
            List objList = obj.get(key);
            if (srcList == null || srcList.size() <= 0 || objList == null || objList.size() <= 0) continue;
            this.sameAmtVerify(ctx, param, verifyType, key, srcList, objList);
        }
    }

    private void sameAmtVerify(Context ctx, Map<String, Object> param, VerifyType verifyType, String key, List srcList, List objList) throws BOSException, EASBizException {
        HashMap<String, List> sameAmtSrc = new HashMap<String, List>();
        HashMap<String, List> sameAmtObj = new HashMap<String, List>();
        Iterator srcIterator = srcList.iterator();
        block0: while (srcIterator.hasNext()) {
            Map srcMap = (Map)srcIterator.next();
            BigDecimal srcAmt = (BigDecimal)srcMap.get("FUnVerifiedAmtFor");
            Iterator objIterator = objList.iterator();
            while (objIterator.hasNext()) {
                boolean isVerify;
                Map objMap = (Map)objIterator.next();
                BigDecimal objAmt = (BigDecimal)objMap.get("FUnVerifiedAmtFor");
                if (srcAmt.abs().compareTo(objAmt.abs()) != 0 || !(isVerify = this.sameAmtVerify(ctx, param, verifyType, key, sameAmtSrc, sameAmtObj, srcIterator, srcMap, objIterator, objMap))) continue;
                continue block0;
            }
        }
    }

    private boolean sameAmtVerify(Context ctx, Map<String, Object> param, VerifyType verifyType, String key, Map<String, List> sameAmtSrc, Map<String, List> sameAmtObj, Iterator srcIterator, Map srcMap, Iterator objIterator, Map objMap) throws BOSException, EASBizException {
        boolean isVerify = false;
        ArrayList<Map> srcMapList = new ArrayList<Map>(1);
        srcMapList.add(srcMap);
        sameAmtSrc.put(key, srcMapList);
        ArrayList<Map> objMapList = new ArrayList<Map>(1);
        objMapList.add(objMap);
        sameAmtObj.put(key, objMapList);
        if (verifyType == VerifyType.SAMEVERIFY) {
            this._sameVerify_New(ctx, param, sameAmtSrc, sameAmtObj, true);
        } else if (verifyType == VerifyType.VERIFYPANDN) {
            this._sameVerify_New(ctx, param, sameAmtSrc, sameAmtObj, false);
        } else if (verifyType == VerifyType.NEGATIVEVERIFY) {
            this.autoVerify_New(ctx, param, sameAmtSrc, sameAmtObj, true);
        } else if (verifyType == VerifyType.COMMONVERIFY) {
            this.autoVerify_New(ctx, param, sameAmtSrc, sameAmtObj, false);
        }
        if (srcMapList.get(0) == null && objMapList.get(0) == null) {
            srcIterator.remove();
            objIterator.remove();
            isVerify = true;
        }
        sameAmtSrc.clear();
        sameAmtObj.clear();
        return isVerify;
    }

    private Map<String, List> resetKey(Map<String, List> map, String keyStr) {
        Iterator<List> it = map.values().iterator();
        HashMap<String, List> srcPositiveM = new HashMap<String, List>();
        List itemList = null;
        String key = "";
        ArrayList<Map> list = null;
        while (it.hasNext()) {
            itemList = it.next();
            for (Map item : itemList) {
                key = (String)item.get(keyStr);
                if (srcPositiveM.containsKey(key)) {
                    ((List)srcPositiveM.get(key)).add(item);
                    continue;
                }
                list = new ArrayList<Map>();
                list.add(item);
                srcPositiveM.put(key, list);
            }
        }
        return srcPositiveM;
    }

    private void dealVerifiedData() {
        String tmpHgId = "";
        int ks = 0;
        for (int i = 0; i < this.hgIdSrcList.size() - 1; ++i) {
            tmpHgId = this.hgIdSrcList.get(i);
            if (!this.hgIdDesList.isEmpty()) {
                if (tmpHgId.compareTo(this.hgIdDesList.get(this.hgIdDesList.size() - 1)) >= 0) continue;
                this.srcPositive.remove(tmpHgId);
                this.srcNegative.remove(tmpHgId);
                ks = i + 1;
                continue;
            }
            ks = this.hgIdSrcList.size() - 1;
        }
        int kd = 0;
        for (int i = 0; i < this.hgIdDesList.size() - 1; ++i) {
            tmpHgId = this.hgIdDesList.get(i);
            if (!this.hgIdSrcList.isEmpty()) {
                if (tmpHgId.compareTo(this.hgIdSrcList.get(this.hgIdSrcList.size() - 1)) >= 0) continue;
                this.desPositive.remove(tmpHgId);
                this.desNegative.remove(tmpHgId);
                kd = i + 1;
                continue;
            }
            kd = this.hgIdDesList.size() - 1;
        }
        this.hgIdSrcList = this.hgIdSrcList.subList(ks, this.hgIdSrcList.size());
        this.hgIdDesList = this.hgIdDesList.subList(kd, this.hgIdDesList.size());
    }

    /*
     * Unable to fully structure code
     */
    private int commonVerify_New(Context ctx, List<Map> srcItems, List<Map> desItems, boolean isNegative, List verifiedSrc, PreparedStatement sqlInsert, Counter counter, Map param, VerifyManualAutoEnum verifyManualAuto) throws BOSException, EASBizException, SQLException {
        state = 0;
        originalAmount = null;
        localAmount = null;
        reportingAmount = null;
        qty = null;
        unverifiedAmtFor = null;
        unverifiedAmtLocal = null;
        unverifiedAmtRpt = null;
        unverifiedAmtQty = null;
        flag = false;
        mustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
        unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        verifyType = isNegative != false ? GLVerifyTypeEnum.NEGATIVE_VERIFY : GLVerifyTypeEnum.COMMON_VERIFY;
        verifyDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        company = (CompanyOrgUnitInfo)param.get("company");
        verifyNumber = (String)param.get("hisNumber");
        Seq = 1;
        srcId = null;
        desId = null;
        srcMap = null;
        j = 0;
        block0: for (i = 0; i < desItems.size() && !flag; ++i) {
            desMap = desItems.get(i);
            if (desMap == null) continue;
            desId = (String)desMap.get("voucherAssistRecordId");
            tempO = (BigDecimal)desMap.get("FUnVerifiedAmtFor");
            tempL = (BigDecimal)desMap.get("FUnverifiedAmtLocal");
            tempR = (BigDecimal)desMap.get("FUnverifiedAmtRpt");
            tempQ = (BigDecimal)desMap.get("FUnverifiedQty");
            v0 = desBizNumber = desMap.get("FBizNumber") == null ? "" : (String)desMap.get("FBizNumber");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            if (originalAmount == null || originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative) {
                originalAmount = tempO;
                localAmount = tempL;
                reportingAmount = tempR;
                qty = tempQ;
                if (originalAmount.compareTo(this.ZERO) < 0 && !isNegative || originalAmount.compareTo(this.ZERO) > 0 && isNegative) {
                    continue;
                }
            } else if (mustSame || !unCheckBizNum) {
                originalAmount = tempO;
                localAmount = tempL;
                reportingAmount = tempR;
                qty = tempQ;
                j = 0;
            }
            while (j < srcItems.size()) {
                block23: {
                    block24: {
                        srcMap = srcItems.get(j);
                        if (srcMap == null) break block23;
                        srcId = (String)srcMap.get("acctCussentId");
                        if (originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative) continue block0;
                        if (verifiedSrc.contains(srcId)) break block23;
                        tempU = (BigDecimal)srcMap.get("FUnVerifiedAmtFor");
                        tempUL = (BigDecimal)srcMap.get("FUnverifiedAmtLocal");
                        tempUR = (BigDecimal)srcMap.get("FUnverifiedAmtRpt");
                        tempUQ = (BigDecimal)srcMap.get("FUnverifiedQty");
                        v1 = srcBizNumber = srcMap.get("FBizNumber") == null ? "" : (String)srcMap.get("FBizNumber");
                        if (tempU.compareTo(this.ZERO) != 0) break block24;
                        verifiedSrc.add(srcId);
                        break block23;
                    }
                    if (unverifiedAmtFor != null && (unverifiedAmtFor.compareTo(this.ZERO) > 0 || isNegative) && (unverifiedAmtFor.compareTo(this.ZERO) < 0 || !isNegative)) ** GOTO lbl-1000
                    unverifiedAmtFor = tempU;
                    unverifiedAmtLocal = tempUL;
                    unverifiedAmtRpt = tempUR;
                    unverifiedAmtQty = tempUQ;
                    if (tempU.compareTo(this.ZERO) < 0 && !isNegative || tempU.compareTo(this.ZERO) > 0 && isNegative) {
                        verifiedSrc.add(srcId);
                    } else if (unCheckBizNum || srcBizNumber.equals(desBizNumber)) {
                        srcMap.put("FNumber", verifyNumber);
                        srcMap.put("FVerifyDate", verifyDate);
                        srcMap.put("FSeq", new Integer(Seq++));
                        acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, srcMap, srcId, desId, verifyType, company, desMap);
                        if (!mustSame && (originalAmount.compareTo(unverifiedAmtFor) > 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) < 0 && isNegative)) {
                            acctCussentHistoryInfo.setOroginalAmount(unverifiedAmtFor);
                            acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
                            originalAmount = originalAmount.subtract(unverifiedAmtFor);
                            if (unverifiedAmtLocal.compareTo(localAmount) <= 0) {
                                acctCussentHistoryInfo.setLocalAmount(unverifiedAmtLocal);
                                acctCussentHistoryInfo.setLocalBalance(GlUtils.zero);
                                localAmount = localAmount.subtract(unverifiedAmtLocal);
                            } else {
                                acctCussentHistoryInfo.setLocalAmount(localAmount);
                                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                                localAmount = GlUtils.zero;
                            }
                            if (unverifiedAmtRpt.compareTo(reportingAmount) <= 0) {
                                acctCussentHistoryInfo.setReportAmount(unverifiedAmtRpt);
                                acctCussentHistoryInfo.setReportBanlance(GlUtils.zero);
                                reportingAmount = reportingAmount.subtract(unverifiedAmtRpt);
                            } else {
                                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                                reportingAmount = GlUtils.zero;
                            }
                            if (unverifiedAmtQty.compareTo(qty) <= 0) {
                                acctCussentHistoryInfo.setQty(unverifiedAmtQty);
                                acctCussentHistoryInfo.setQtyBalance(GlUtils.zero);
                                qty = qty.subtract(unverifiedAmtQty);
                            } else {
                                acctCussentHistoryInfo.setQty(qty);
                                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                                qty = GlUtils.zero;
                            }
                            this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter);
                            this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfo, true);
                            unverifiedAmtFor = GlUtils.zero;
                            unverifiedAmtLocal = GlUtils.zero;
                            unverifiedAmtRpt = GlUtils.zero;
                            unverifiedAmtQty = GlUtils.zero;
                            srcItems.set(j, null);
                            desMap.put("FUnVerifiedAmtFor", originalAmount);
                            desMap.put("FUnverifiedAmtLocal", localAmount);
                            desMap.put("FUnverifiedAmtRpt", reportingAmount);
                            desMap.put("FUnverifiedAmtQty", qty);
                            verifiedSrc.add(srcId);
                            this.batchUpdateVerAmt(desId, new BigDecimal[]{originalAmount, localAmount, reportingAmount, qty});
                            if (j >= srcItems.size() - 1) {
                                state = 1;
                                flag = true;
                                continue block0;
                            }
                        } else {
                            if (!mustSame && (originalAmount.compareTo(unverifiedAmtFor) < 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) > 0 && isNegative)) {
                                acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                                acctCussentHistoryInfo.setLocalAmount(localAmount);
                                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                                acctCussentHistoryInfo.setQty(qty);
                                if (unverifiedAmtQty == null || qty == null) {
                                    System.out.println("");
                                }
                                acctCussentHistoryInfo.setOriginalBalance(unverifiedAmtFor.subtract(originalAmount));
                                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                                this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter);
                                this.changeVerifiedStatus(ctx, desId);
                                this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfo, true);
                                unverifiedAmtFor = unverifiedAmtFor.subtract(originalAmount);
                                unverifiedAmtLocal = unverifiedAmtLocal.subtract(localAmount);
                                unverifiedAmtRpt = unverifiedAmtRpt.subtract(reportingAmount);
                                unverifiedAmtQty = unverifiedAmtQty.subtract(qty);
                                originalAmount = GlUtils.zero;
                                localAmount = GlUtils.zero;
                                reportingAmount = GlUtils.zero;
                                qty = GlUtils.zero;
                                desItems.set(i, null);
                                srcMap.put("FUnVerifiedAmtFor", unverifiedAmtFor);
                                srcMap.put("FUnverifiedAmtLocal", unverifiedAmtLocal);
                                srcMap.put("FUnverifiedAmtRpt", unverifiedAmtRpt);
                                srcMap.put("FUnverifiedQty", unverifiedAmtQty);
                                this.batchUpdateVerAmt(desId, new BigDecimal[]{originalAmount, localAmount, reportingAmount, qty});
                                if (i < desItems.size() - 1) {
                                    if (j < srcItems.size() - 1) continue block0;
                                    state = 1;
                                    continue block0;
                                }
                                state = 2;
                                flag = true;
                                continue block0;
                            }
                            if (!mustSame || unverifiedAmtFor.compareTo(originalAmount) == 0) {
                                acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                                acctCussentHistoryInfo.setLocalAmount(localAmount);
                                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                                acctCussentHistoryInfo.setQty(qty);
                                acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
                                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                                this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter);
                                this.changeVerifiedStatus(ctx, desId);
                                this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfo, true);
                                unverifiedAmtFor = GlUtils.zero;
                                unverifiedAmtLocal = GlUtils.zero;
                                unverifiedAmtRpt = GlUtils.zero;
                                unverifiedAmtQty = GlUtils.zero;
                                originalAmount = GlUtils.zero;
                                localAmount = GlUtils.zero;
                                reportingAmount = GlUtils.zero;
                                qty = GlUtils.zero;
                                srcItems.set(j, null);
                                desItems.set(i, null);
                                this.batchUpdateVerAmt(desId, new BigDecimal[]{originalAmount, localAmount, reportingAmount, qty});
                                verifiedSrc.add(srcId);
                                if (i < desItems.size() - 1) {
                                    if (j < srcItems.size() - 1) continue block0;
                                    state = 2;
                                    flag = true;
                                    continue block0;
                                }
                                state = 1;
                                flag = true;
                                continue block0;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        return state;
    }

    private List commonVerify_Age_New(Context ctx, List<Map> srcItems, List<Map> desItems, boolean isNegative, Map param) throws BOSException, EASBizException {
        boolean state = false;
        BigDecimal originalAmount = null;
        BigDecimal unverifiedAmtFor = null;
        ArrayList<Map> result = new ArrayList();
        String amountField = "FUnVerifiedAmtFor";
        if (param.get("amountField") != null) {
            amountField = (String)param.get("amountField");
        }
        boolean mustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
        Map srcMap = null;
        block0: for (int i = 0; i < desItems.size() && !state; ++i) {
            BigDecimal tempO;
            Map desMap = desItems.get(i);
            if (desMap == null || (tempO = (BigDecimal)desMap.get(amountField)).compareTo(this.ZERO) == 0 || (originalAmount == null || originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative) && ((originalAmount = tempO).compareTo(this.ZERO) < 0 && !isNegative || originalAmount.compareTo(this.ZERO) > 0 && isNegative)) continue;
            for (int j = 0; j < srcItems.size(); ++j) {
                srcMap = srcItems.get(j);
                if (srcMap == null) continue;
                if (originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative) continue block0;
                BigDecimal tempU = (BigDecimal)srcMap.get(amountField);
                if (tempU.compareTo(this.ZERO) == 0) continue;
                if (unverifiedAmtFor == null || unverifiedAmtFor.compareTo(this.ZERO) <= 0 && !isNegative || unverifiedAmtFor.compareTo(this.ZERO) >= 0 && isNegative) {
                    unverifiedAmtFor = tempU;
                    if (tempU.compareTo(this.ZERO) < 0 && !isNegative || tempU.compareTo(this.ZERO) > 0 && isNegative) continue;
                }
                if (!mustSame && (originalAmount.compareTo(unverifiedAmtFor) > 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) < 0 && isNegative)) {
                    originalAmount = originalAmount.subtract(unverifiedAmtFor);
                    unverifiedAmtFor = GlUtils.zero;
                    srcItems.set(j, null);
                    desMap.put(amountField, originalAmount);
                    if (j != srcItems.size() - 1) continue;
                    result = desItems.subList(i, desItems.size());
                    this.verifyNegativeAge(result, amountField);
                    return result;
                }
                if (!mustSame && (originalAmount.compareTo(unverifiedAmtFor) < 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) > 0 && isNegative)) {
                    unverifiedAmtFor = unverifiedAmtFor.subtract(originalAmount);
                    originalAmount = GlUtils.zero;
                    desItems.set(i, null);
                    srcMap.put(amountField, unverifiedAmtFor);
                    if (i != desItems.size() - 1) continue;
                    return srcItems.subList(j, srcItems.size());
                }
                if (mustSame && unverifiedAmtFor.compareTo(originalAmount) != 0) continue;
                unverifiedAmtFor = GlUtils.zero;
                originalAmount = GlUtils.zero;
                srcItems.set(j, null);
                desItems.set(i, null);
                if (i == desItems.size() - 1 && j < srcItems.size() - 1) {
                    return srcItems.subList(j + 1, srcItems.size());
                }
                if (j != srcItems.size() - 1 || i >= desItems.size() - 1) continue;
                result = desItems.subList(i + 1, desItems.size());
                this.verifyNegativeAge(result, amountField);
                return result;
            }
        }
        return new ArrayList();
    }

    private void changeVerifiedStatus(Context ctx, String objID) throws BOSException, SQLException {
        this.sqlUpdateRecordStatus.setString(1, objID);
        this.sqlUpdateRecordStatus.addBatch();
        ++this.record;
        if (this.record == this.batchCount) {
            long s = System.currentTimeMillis();
            this.sqlUpdateRecordStatus.executeBatch();
            this.sqlUpdateRecordStatus.clearBatch();
            this.record = 0;
        }
        this.sqlUpdateActStatus.setString(1, objID);
        this.sqlUpdateActStatus.addBatch();
        ++this.actCnt;
        if (this.actCnt == this.batchCount) {
            this.sqlUpdateActStatus.executeBatch();
            this.sqlUpdateActStatus.clearBatch();
            this.actCnt = 0;
        }
    }

    private void commitLastData() throws SQLException {
        if (this.record > 0) {
            this.sqlUpdateRecordStatus.executeBatch();
            this.sqlUpdateRecordStatus.clearBatch();
            this.record = 0;
        }
        if (this.actCnt > 0) {
            this.sqlUpdateActStatus.executeBatch();
            this.sqlUpdateActStatus.clearBatch();
            this.actCnt = 0;
        }
        if (this.actAmt > 0) {
            this.sqlUpdateActAmt.executeBatch();
            this.sqlUpdateActAmt.clearBatch();
            this.actAmt = 0;
        }
        if (this.verAmt > 0) {
            this.sqlUpdateVerAmt.executeBatch();
            this.sqlUpdateVerAmt.clearBatch();
            this.verAmt = 0;
        }
    }

    public Map autoVerify_New(Context ctx, Map param, Map<String, List> srcNegativeMap, Map<String, List> desNegativeMap, boolean isNegative) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement sqlInsert = null;
        HashMap result = new HashMap();
        try {
            con = EJBFactory.getConnection((Context)ctx);
            sqlInsert = con.prepareStatement(this.getInsertSQL());
            Counter counterInsert = new Counter();
            String acctId2 = null;
            List srcList = null;
            List desList = null;
            ArrayList verifiedSrc = new ArrayList();
            for (String acctId2 : srcNegativeMap.keySet()) {
                srcList = srcNegativeMap.get(acctId2);
                if (srcList == null || srcList.size() <= 0 || !desNegativeMap.containsKey(acctId2) || (desList = desNegativeMap.get(acctId2)) == null || desList.size() <= 0) continue;
                this.commonVerify_New(ctx, srcList, desList, isNegative, verifiedSrc, sqlInsert, counterInsert, param, VerifyManualAutoEnum.Auto);
            }
            if (counterInsert.getValue() > 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counterInsert.clear();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sqlInsert, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
        return result;
    }

    public List autoVerify_Age_New(Context ctx, Map param, Map<String, List> srcNegativeMap, Map<String, List> desNegativeMap, boolean isNegative) throws BOSException, EASBizException {
        String amountField = "FUnVerifiedAmtFor";
        if (param.get("amountField") != null) {
            amountField = (String)param.get("amountField");
        }
        String acctId2 = null;
        List srcList = null;
        List desList = null;
        ArrayList verifiedData = new ArrayList();
        ArrayList<String> acidList = new ArrayList<String>();
        for (String acctId2 : srcNegativeMap.keySet()) {
            srcList = srcNegativeMap.get(acctId2);
            if (desNegativeMap.containsKey(acctId2)) {
                desList = desNegativeMap.get(acctId2);
                if (srcList.size() > 0 && desList.size() > 0) {
                    verifiedData.addAll(this.commonVerify_Age_New(ctx, srcList, desList, isNegative, param));
                } else if (srcList.size() > 0) {
                    verifiedData.addAll(srcList);
                } else {
                    this.verifyNegativeAge(desList, amountField);
                    verifiedData.addAll(desList);
                }
                acidList.add(acctId2);
                desList = null;
                continue;
            }
            verifiedData.addAll(srcList);
        }
        for (String acctId2 : desNegativeMap.keySet()) {
            if (acidList.contains(acctId2)) continue;
            desList = desNegativeMap.get(acctId2);
            this.verifyNegativeAge(desList, amountField);
            verifiedData.addAll(desList);
        }
        return verifiedData;
    }

    private void verifyNegativeAge(List<Map> desList, String amountField) {
        BigDecimal amtFor = null;
        for (Map item : desList) {
            if (item == null) continue;
            amtFor = (BigDecimal)item.get(amountField);
            item.put(amountField, amtFor.negate());
        }
    }

    protected void _sameVerify_New(Context ctx, Map param, Map<String, List> positiveMap, Map<String, List> negativeMap, boolean isCuss) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement sqlInsert = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            sqlInsert = con.prepareStatement(this.getInsertSQL());
            Counter counterInsert = new Counter();
            String acctId2 = null;
            List positive = null;
            List negative = null;
            ArrayList temp = null;
            boolean mustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
            int state = 0;
            Set<String> keys = positiveMap.keySet();
            for (String acctId2 : keys) {
                positive = positiveMap.get(acctId2);
                negative = negativeMap.get(acctId2);
                if (positive == null || positive.size() <= 0 || negative == null || negative.size() <= 0) continue;
                if (mustSame) {
                    this.sameVerify_New_ForSameAmt(ctx, param, positive, negative, sqlInsert, counterInsert, isCuss, mustSame);
                } else {
                    state = this.sameVerify_New(ctx, param, positive, negative, sqlInsert, counterInsert, isCuss, mustSame);
                }
                temp = new ArrayList();
                if (state == 1 || negative.isEmpty()) {
                    for (int i = 0; i < positive.size(); ++i) {
                        if (positive.get(i) == null) continue;
                        temp.add(positive.get(i));
                    }
                    positiveMap.put(acctId2, temp);
                    continue;
                }
                if (state == 2 || positive.isEmpty()) {
                    for (int i = 0; i < negative.size(); ++i) {
                        if (negative.get(i) == null) continue;
                        temp.add(negative.get(i));
                    }
                    negativeMap.put(acctId2, temp);
                    continue;
                }
                if (state != 3) continue;
                ArrayList temp1 = new ArrayList();
                for (int i = 0; i < positive.size(); ++i) {
                    if (positive.get(i) == null) continue;
                    temp.add(positive.get(i));
                }
                positiveMap.put(acctId2, temp1);
                ArrayList temp2 = new ArrayList();
                for (int i = 0; i < negative.size(); ++i) {
                    if (negative.get(i) == null) continue;
                    temp.add(negative.get(i));
                }
                negativeMap.put(acctId2, temp2);
            }
            if (counterInsert.getValue() > 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counterInsert.clear();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sqlInsert, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
    }

    protected void _sameVerify_New(Context ctx, List objList, Map param, Map positiveMap, Map negativeMap, boolean isCuss) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement sqlInsert = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            sqlInsert = con.prepareStatement(this.getInsertSQL());
            Counter counterInsert = new Counter();
            String acctId2 = null;
            List positive = null;
            List negative = null;
            ArrayList temp = null;
            Map acctMapList = null;
            boolean mustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
            int state = 0;
            Map acctMaps = this.getHgMap(objList, param);
            Set keys = acctMaps.keySet();
            for (String acctId2 : keys) {
                int i;
                acctMapList = (Map)acctMaps.get(acctId2);
                positive = (List)acctMapList.get("positive");
                negative = (List)acctMapList.get("negative");
                if (positive.size() > 0 && negative.size() > 0) {
                    state = this.sameVerify_New(ctx, param, positive, negative, sqlInsert, counterInsert, isCuss, mustSame);
                }
                temp = new ArrayList();
                if (state == 1 || negative.isEmpty()) {
                    for (i = 0; i < positive.size(); ++i) {
                        if (positive.get(i) == null) continue;
                        temp.add(positive.get(i));
                    }
                    positiveMap.put(acctId2, temp);
                    continue;
                }
                if (state != 2 && !positive.isEmpty()) continue;
                for (i = 0; i < negative.size(); ++i) {
                    if (negative.get(i) == null) continue;
                    temp.add(negative.get(i));
                }
                negativeMap.put(acctId2, temp);
            }
            if (counterInsert.getValue() > 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counterInsert.clear();
            }
            objList = null;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                objList = null;
                SQLUtils.cleanup(sqlInsert, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
    }

    protected void _sameVerify_Age_New(Context ctx, List objList, Map param, Map positiveMap, Map negativeMap, boolean isCuss) throws BOSException, EASBizException {
        String acctId2 = null;
        List positive = null;
        List negative = null;
        ArrayList temp = null;
        Map acctMapList = null;
        boolean mustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
        int state = 0;
        Map acctMaps = this.getHgMap(objList, param);
        Set keys = acctMaps.keySet();
        for (String acctId2 : keys) {
            int i;
            acctMapList = (Map)acctMaps.get(acctId2);
            positive = (List)acctMapList.get("positive");
            negative = (List)acctMapList.get("negative");
            state = 0;
            if (positive.size() > 0 && negative.size() > 0) {
                state = this.sameVerify_Age_New(ctx, param, positive, negative, isCuss, mustSame);
            }
            temp = new ArrayList();
            if (state == 1 || negative.isEmpty()) {
                for (i = 0; i < positive.size(); ++i) {
                    if (positive.get(i) == null) continue;
                    temp.add(positive.get(i));
                }
                positiveMap.put(acctId2, temp);
                continue;
            }
            if (state != 2 && !positive.isEmpty()) continue;
            for (i = 0; i < negative.size(); ++i) {
                if (negative.get(i) == null) continue;
                temp.add(negative.get(i));
            }
            negativeMap.put(acctId2, temp);
        }
    }

    private int sameVerify_New(Context ctx, Map param, List<Map> positive, List<Map> negative, PreparedStatement sqlInsert, Counter counter, boolean isCuss, boolean mustSame) throws BOSException, EASBizException, SQLException {
        int verifyState = 0;
        BigDecimal unverifiedAmtForI = null;
        BigDecimal unverifiedAmtLocalI = null;
        BigDecimal unverifiedAmtRptI = null;
        BigDecimal unverifiedAmtQtyI = null;
        BigDecimal unverifiedAmtForJ = null;
        BigDecimal unverifiedAmtLocalJ = null;
        BigDecimal unverifiedAmtRptJ = null;
        BigDecimal unverifiedAmtQtyJ = null;
        BigDecimal zeroBigDecimal = new BigDecimal("0");
        java.util.Date verifyDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        String number = (String)param.get("hisNumber");
        int Seq = 1;
        Map amountGzMap = null;
        String srcId = null;
        Map amountGzMap2 = null;
        String desId = null;
        String key = isCuss ? "acctCussentId" : "voucherAssistRecordId";
        GLVerifyTypeEnum type = isCuss ? GLVerifyTypeEnum.SAME_VERIFY : GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY;
        int j = 0;
        boolean unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        block0: for (int i = 0; i < positive.size() && verifyState == 0; ++i) {
            String bizNumber1;
            amountGzMap = positive.get(i);
            if (amountGzMap == null) continue;
            srcId = (String)amountGzMap.get(key);
            BigDecimal tempO = (BigDecimal)amountGzMap.get("FUnVerifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountGzMap.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountGzMap.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountGzMap.get("FUnverifiedQty");
            String string = bizNumber1 = amountGzMap.get("FBizNumber") == null ? "" : (String)amountGzMap.get("FBizNumber");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            if (unverifiedAmtForI == null || unverifiedAmtForI.compareTo(this.ZERO) == 0) {
                unverifiedAmtForI = tempO;
                unverifiedAmtLocalI = tempL;
                unverifiedAmtRptI = tempR;
                unverifiedAmtQtyI = tempQ;
            } else if (!unCheckBizNum) {
                unverifiedAmtForI = tempO;
                unverifiedAmtLocalI = tempL;
                unverifiedAmtRptI = tempR;
                unverifiedAmtQtyI = tempQ;
                j = 0;
            }
            while (j < negative.size()) {
                amountGzMap2 = negative.get(j);
                if (amountGzMap2 != null) {
                    String bizNumber2;
                    desId = (String)amountGzMap2.get(key);
                    unverifiedAmtForJ = (BigDecimal)amountGzMap2.get("FUnVerifiedAmtFor");
                    unverifiedAmtLocalJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtLocal");
                    unverifiedAmtRptJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtRpt");
                    unverifiedAmtQtyJ = (BigDecimal)amountGzMap2.get("FUnverifiedQty");
                    String string2 = bizNumber2 = amountGzMap2.get("FBizNumber") == null ? "" : (String)amountGzMap2.get("FBizNumber");
                    if (unverifiedAmtForJ.compareTo(this.ZERO) != 0 && (unCheckBizNum || bizNumber1.equals(bizNumber2))) {
                        AcctCussentHistoryInfo acctCussentHistoryInfoJ;
                        AcctCussentHistoryInfo acctCussentHistoryInfoI;
                        amountGzMap.put("FNumber", number);
                        amountGzMap.put("FVerifyDate", verifyDate);
                        amountGzMap.put("FSeq", new Integer(Seq++));
                        amountGzMap2.put("FNumber", number);
                        amountGzMap2.put("FVerifyDate", verifyDate);
                        amountGzMap2.put("FSeq", new Integer(Seq++));
                        if (isCuss) {
                            acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMap, srcId, desId, type, company, amountGzMap2);
                            acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMap2, desId, srcId, type, company, amountGzMap);
                        } else {
                            acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMap, srcId, desId, type, company, amountGzMap2);
                            acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMap2, desId, srcId, type, company, amountGzMap);
                        }
                        if (!mustSame && unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) > 0) {
                            acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI.subtract(unverifiedAmtForI.add(unverifiedAmtForJ)));
                            acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI.subtract(unverifiedAmtLocalI.add(unverifiedAmtLocalJ)));
                            acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI.subtract(unverifiedAmtRptI.add(unverifiedAmtRptJ)));
                            acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI.subtract(unverifiedAmtQtyI.add(unverifiedAmtQtyJ)));
                            acctCussentHistoryInfoI.setOriginalBalance(unverifiedAmtForI.add(unverifiedAmtForJ));
                            acctCussentHistoryInfoI.setLocalBalance(unverifiedAmtLocalI.add(unverifiedAmtLocalJ));
                            acctCussentHistoryInfoI.setReportBanlance(unverifiedAmtRptI.add(unverifiedAmtRptJ));
                            acctCussentHistoryInfoI.setQtyBalance(unverifiedAmtQtyI.add(unverifiedAmtQtyJ));
                            acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                            acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                            acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                            acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                            acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                            acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                            acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                            acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                            this.insertHistory(ctx, acctCussentHistoryInfoI, type, sqlInsert, counter);
                            this.insertHistory(ctx, acctCussentHistoryInfoJ, type, sqlInsert, counter);
                            unverifiedAmtForI = unverifiedAmtForI.add(unverifiedAmtForJ);
                            unverifiedAmtLocalI = unverifiedAmtLocalI.add(unverifiedAmtLocalJ);
                            unverifiedAmtRptI = unverifiedAmtRptI.add(unverifiedAmtRptJ);
                            unverifiedAmtQtyI = unverifiedAmtQtyI.add(unverifiedAmtQtyJ);
                            unverifiedAmtForJ = zeroBigDecimal;
                            negative.set(j, null);
                            if (!isCuss) {
                                this.changeVerifiedStatus(ctx, desId);
                            }
                            this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI, isCuss);
                            this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ, isCuss);
                            amountGzMap.put("FUnVerifiedAmtFor", acctCussentHistoryInfoI.getOriginalBalance());
                            amountGzMap.put("FUnverifiedAmtLocal", acctCussentHistoryInfoI.getLocalBalance());
                            amountGzMap.put("FUnverifiedAmtRpt", acctCussentHistoryInfoI.getReportBanlance());
                            amountGzMap.put("FUnverifiedQty", acctCussentHistoryInfoI.getQtyBalance());
                            if (j == negative.size() - 1) {
                                verifyState = 1;
                            }
                        } else {
                            if (!mustSame && unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) < 0) {
                                acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                                acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                                acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                                acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                                acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                                acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                                acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                                acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                                acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ.subtract(unverifiedAmtForJ.add(unverifiedAmtForI)));
                                acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ.subtract(unverifiedAmtLocalJ.add(unverifiedAmtLocalI)));
                                acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ.subtract(unverifiedAmtRptJ.add(unverifiedAmtRptI)));
                                acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ.subtract(unverifiedAmtQtyJ.add(unverifiedAmtQtyI)));
                                acctCussentHistoryInfoJ.setOriginalBalance(unverifiedAmtForJ.add(unverifiedAmtForI));
                                acctCussentHistoryInfoJ.setLocalBalance(unverifiedAmtLocalJ.add(unverifiedAmtLocalI));
                                acctCussentHistoryInfoJ.setReportBanlance(unverifiedAmtRptJ.add(unverifiedAmtRptI));
                                acctCussentHistoryInfoJ.setQtyBalance(unverifiedAmtQtyJ.add(unverifiedAmtQtyI));
                                this.insertHistory(ctx, acctCussentHistoryInfoI, type, sqlInsert, counter);
                                this.insertHistory(ctx, acctCussentHistoryInfoJ, type, sqlInsert, counter);
                                unverifiedAmtForJ = unverifiedAmtForI.add(unverifiedAmtForJ);
                                unverifiedAmtLocalJ = unverifiedAmtLocalJ.add(unverifiedAmtLocalI);
                                unverifiedAmtRptJ = unverifiedAmtRptJ.add(unverifiedAmtRptI);
                                unverifiedAmtQtyJ = unverifiedAmtQtyJ.add(unverifiedAmtQtyI);
                                unverifiedAmtForI = zeroBigDecimal;
                                if (!isCuss) {
                                    this.changeVerifiedStatus(ctx, srcId);
                                }
                                this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI, isCuss);
                                this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ, isCuss);
                                positive.set(i, null);
                                amountGzMap2.put("FUnVerifiedAmtFor", acctCussentHistoryInfoJ.getOriginalBalance());
                                amountGzMap2.put("FUnverifiedAmtLocal", acctCussentHistoryInfoJ.getLocalBalance());
                                amountGzMap2.put("FUnverifiedAmtRpt", acctCussentHistoryInfoJ.getReportBanlance());
                                amountGzMap2.put("FUnverifiedQty", acctCussentHistoryInfoJ.getQtyBalance());
                                if (i != positive.size() - 1) continue block0;
                                verifyState = 2;
                                continue block0;
                            }
                            if (!mustSame || unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) == 0) {
                                acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                                acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                                acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                                acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                                acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                                acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                                acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                                acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                                acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                                acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                                acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                                acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                                acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                                acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                                acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                                acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                                this.insertHistory(ctx, acctCussentHistoryInfoI, type, sqlInsert, counter);
                                this.insertHistory(ctx, acctCussentHistoryInfoJ, type, sqlInsert, counter);
                                unverifiedAmtForI = zeroBigDecimal;
                                unverifiedAmtForJ = zeroBigDecimal;
                                if (!isCuss) {
                                    this.changeVerifiedStatus(ctx, srcId);
                                    this.changeVerifiedStatus(ctx, desId);
                                }
                                this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI, isCuss);
                                this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ, isCuss);
                                positive.set(i, null);
                                negative.set(j, null);
                                if (j == negative.size() - 1 && i < positive.size() - 1) {
                                    verifyState = 1;
                                }
                                if (j >= negative.size() - 1 || i != positive.size() - 1) continue block0;
                                verifyState = 2;
                                continue block0;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        return verifyState;
    }

    private int sameVerify_New_ForSameAmt(Context ctx, Map param, List<Map> positive, List<Map> negative, PreparedStatement sqlInsert, Counter counter, boolean isCuss, boolean mustSame) throws BOSException, EASBizException, SQLException {
        int verifyState = 0;
        BigDecimal unverifiedAmtForI = null;
        BigDecimal unverifiedAmtLocalI = null;
        BigDecimal unverifiedAmtRptI = null;
        BigDecimal unverifiedAmtQtyI = null;
        BigDecimal unverifiedAmtForJ = null;
        BigDecimal unverifiedAmtLocalJ = null;
        BigDecimal unverifiedAmtRptJ = null;
        BigDecimal unverifiedAmtQtyJ = null;
        BigDecimal zeroBigDecimal = new BigDecimal("0");
        java.util.Date verifyDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        String number = (String)param.get("hisNumber");
        int Seq = 1;
        Map amountGzMap = null;
        String srcId = null;
        Map amountGzMap2 = null;
        String desId = null;
        String key = isCuss ? "acctCussentId" : "voucherAssistRecordId";
        GLVerifyTypeEnum type = isCuss ? GLVerifyTypeEnum.SAME_VERIFY : GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY;
        boolean unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        int positiveSize = positive.size();
        int negativeSize = negative.size();
        for (int i = 0; i < positive.size() && verifyState == 0; ++i) {
            String bizNumber1;
            amountGzMap = positive.get(i);
            if (amountGzMap == null) continue;
            srcId = (String)amountGzMap.get(key);
            BigDecimal tempO = (BigDecimal)amountGzMap.get("FUnVerifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountGzMap.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountGzMap.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountGzMap.get("FUnverifiedQty");
            String string = bizNumber1 = amountGzMap.get("FBizNumber") == null ? "" : (String)amountGzMap.get("FBizNumber");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            unverifiedAmtForI = tempO;
            unverifiedAmtLocalI = tempL;
            unverifiedAmtRptI = tempR;
            unverifiedAmtQtyI = tempQ;
            for (int j = 0; j < negative.size(); ++j) {
                AcctCussentHistoryInfo acctCussentHistoryInfoJ;
                AcctCussentHistoryInfo acctCussentHistoryInfoI;
                String bizNumber2;
                amountGzMap2 = negative.get(j);
                if (amountGzMap2 == null) continue;
                desId = (String)amountGzMap2.get(key);
                unverifiedAmtForJ = (BigDecimal)amountGzMap2.get("FUnVerifiedAmtFor");
                unverifiedAmtLocalJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtLocal");
                unverifiedAmtRptJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtRpt");
                unverifiedAmtQtyJ = (BigDecimal)amountGzMap2.get("FUnverifiedQty");
                String string2 = bizNumber2 = amountGzMap2.get("FBizNumber") == null ? "" : (String)amountGzMap2.get("FBizNumber");
                if (unverifiedAmtForJ.compareTo(this.ZERO) == 0 || !unCheckBizNum && !bizNumber1.equals(bizNumber2)) continue;
                amountGzMap.put("FNumber", number);
                amountGzMap.put("FVerifyDate", verifyDate);
                amountGzMap.put("FSeq", new Integer(Seq++));
                amountGzMap2.put("FNumber", number);
                amountGzMap2.put("FVerifyDate", verifyDate);
                amountGzMap2.put("FSeq", new Integer(Seq++));
                if (isCuss) {
                    acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMap, srcId, desId, type, company, amountGzMap2);
                    acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMap2, desId, srcId, type, company, amountGzMap);
                } else {
                    acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMap, srcId, desId, type, company, amountGzMap2);
                    acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMap2, desId, srcId, type, company, amountGzMap);
                }
                if (mustSame && unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) != 0) continue;
                acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, acctCussentHistoryInfoI, type, sqlInsert, counter);
                this.insertHistory(ctx, acctCussentHistoryInfoJ, type, sqlInsert, counter);
                unverifiedAmtForI = zeroBigDecimal;
                unverifiedAmtForJ = zeroBigDecimal;
                if (!isCuss) {
                    this.changeVerifiedStatus(ctx, srcId);
                    this.changeVerifiedStatus(ctx, desId);
                }
                this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI, isCuss);
                this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ, isCuss);
                positive.set(i, null);
                negative.set(j, null);
                --negativeSize;
                --positiveSize;
            }
        }
        verifyState = negativeSize == 0 && positiveSize == 0 ? 0 : (negativeSize == 0 && positiveSize > 0 ? 1 : (positiveSize == 0 && negativeSize > 0 ? 2 : 3));
        return verifyState;
    }

    private int sameVerify_Age_New(Context ctx, Map param, List<Map> positive, List<Map> negative, boolean isCuss, boolean mustSame) throws BOSException, EASBizException {
        int verifyState = 0;
        BigDecimal unverifiedAmtForI = null;
        BigDecimal unverifiedAmtForJ = null;
        String amountField = "FUnVerifiedAmtFor";
        if (param.get("amountField") != null) {
            amountField = (String)param.get("amountField");
        }
        BigDecimal zeroBigDecimal = new BigDecimal("0");
        Map amountGzMap = null;
        Map amountGzMap2 = null;
        int j = 0;
        block0: for (int i = 0; i < positive.size() && verifyState == 0; ++i) {
            BigDecimal tempO;
            amountGzMap = positive.get(i);
            if (amountGzMap == null || (tempO = (BigDecimal)amountGzMap.get(amountField)).compareTo(this.ZERO) == 0) continue;
            if (unverifiedAmtForI == null || unverifiedAmtForI.compareTo(this.ZERO) == 0) {
                unverifiedAmtForI = tempO;
            }
            while (j < negative.size()) {
                amountGzMap2 = negative.get(j);
                if (amountGzMap2 != null && (unverifiedAmtForJ = (BigDecimal)amountGzMap2.get(amountField)).compareTo(this.ZERO) != 0) {
                    if (!mustSame && unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) > 0) {
                        unverifiedAmtForI = unverifiedAmtForI.add(unverifiedAmtForJ);
                        unverifiedAmtForJ = zeroBigDecimal;
                        amountGzMap.put(amountField, unverifiedAmtForI);
                        negative.set(j, null);
                        if (j == negative.size() - 1) {
                            verifyState = 1;
                        }
                    } else {
                        if (!mustSame && unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) < 0) {
                            unverifiedAmtForJ = unverifiedAmtForI.add(unverifiedAmtForJ);
                            unverifiedAmtForI = zeroBigDecimal;
                            positive.set(i, null);
                            amountGzMap2.put(amountField, unverifiedAmtForJ);
                            if (i != positive.size() - 1) continue block0;
                            verifyState = 2;
                            continue block0;
                        }
                        if (!mustSame || unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) == 0) {
                            unverifiedAmtForI = zeroBigDecimal;
                            unverifiedAmtForJ = zeroBigDecimal;
                            positive.set(i, null);
                            negative.set(j, null);
                            if (j == negative.size() - 1 && i < positive.size() - 1) {
                                verifyState = 1;
                            }
                            if (j >= negative.size() - 1 || i != positive.size() - 1) continue block0;
                            verifyState = 2;
                            continue block0;
                        }
                    }
                }
                ++j;
            }
        }
        return verifyState;
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, CompanyOrgUnitInfo company, String[] strVeriVchEntryIds) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = new AcctCussentHistoryInfo();
        acctCussentHistoryInfo.setNumber((String)temp.get("FNumber"));
        acctCussentHistoryInfo.setSeq((Integer)temp.get("FSeq"));
        acctCussentHistoryInfo.setVerifyDate((java.util.Date)temp.get("FVerifyDate"));
        AcctCussentInfo acctCussentInfo = new AcctCussentInfo();
        acctCussentInfo.setId(BOSUuid.read((String)srcID));
        acctCussentHistoryInfo.setCussentid(acctCussentInfo);
        acctCussentHistoryInfo.setId(BOSUuid.create((BOSObjectType)acctCussentHistoryInfo.getBOSType()));
        acctCussentHistoryInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        acctCussentHistoryInfo.setCompany(company);
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)((String)temp.get("FAccountID"))));
        acctCussentHistoryInfo.setAccount(account);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)((String)temp.get("FCurrencyID"))));
        acctCussentHistoryInfo.setCurrency(currency);
        AssistantHGInfo assgrp = new AssistantHGInfo();
        assgrp.setId(BOSUuid.read((String)((String)temp.get("FAssGrpID"))));
        acctCussentHistoryInfo.setAssgrp(assgrp);
        acctCussentHistoryInfo.setVchNumber((String)temp.get("FVchNumber"));
        acctCussentHistoryInfo.setVchDate((java.util.Date)temp.get("FBookedDate"));
        acctCussentHistoryInfo.setBizDate((java.util.Date)temp.get("FBizDate"));
        acctCussentHistoryInfo.setBizNumber((String)temp.get("FBizNumber"));
        acctCussentHistoryInfo.setDescription((String)temp.get("FDescription"));
        acctCussentHistoryInfo.setCussOriginalAmount((BigDecimal)temp.get("FOriginalAmount"));
        acctCussentHistoryInfo.setCussLocalAmount((BigDecimal)temp.get("FLocalAmount"));
        acctCussentHistoryInfo.setCussReportAmount((BigDecimal)temp.get("FReportingAmount"));
        acctCussentHistoryInfo.setCussQty((BigDecimal)temp.get("FQuantity"));
        VoucherInfo cussVchInfo = null;
        VoucherEntryInfo cussEntryInfo = null;
        if (temp.get("fvoucherid") != null) {
            cussVchInfo = new VoucherInfo();
            cussVchInfo.setId(BOSUuid.read((String)temp.get("fvoucherid").toString()));
            cussEntryInfo = new VoucherEntryInfo();
            cussEntryInfo.setId(BOSUuid.read((String)temp.get("fentryid").toString()));
        }
        acctCussentHistoryInfo.setCussVch(cussVchInfo);
        acctCussentHistoryInfo.setCussEntry(cussEntryInfo);
        if (objID != null) {
            VoucherAssistRecordInfo voucherAssistRecordInfo = new VoucherAssistRecordInfo();
            voucherAssistRecordInfo.setId(BOSUuid.read((String)objID));
            acctCussentHistoryInfo.setVoucherAsstID(voucherAssistRecordInfo);
        }
        if (temp.get("periodNumber") != null) {
            acctCussentHistoryInfo.setCussPeriod(Integer.parseInt(temp.get("periodNumber").toString()));
        }
        acctCussentHistoryInfo.setDc(verifyType);
        return acctCussentHistoryInfo;
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, CompanyOrgUnitInfo company, Map mapVeriVch) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, temp, srcID, objID, verifyType, company, new String[0]);
        VoucherInfo cussVchInfo = null;
        VoucherEntryInfo cussEntryInfo = null;
        if (mapVeriVch.get("fvoucherid") != null) {
            cussVchInfo = new VoucherInfo();
            cussVchInfo.setId(BOSUuid.read((String)mapVeriVch.get("fvoucherid").toString()));
            cussEntryInfo = new VoucherEntryInfo();
            cussEntryInfo.setId(BOSUuid.read((String)mapVeriVch.get("fentryid").toString()));
        }
        acctCussentHistoryInfo.setVeriVch(cussVchInfo);
        acctCussentHistoryInfo.setVeriEntry(cussEntryInfo);
        if (mapVeriVch.get("periodNumber") != null) {
            acctCussentHistoryInfo.setVeriPeriod(Integer.parseInt(mapVeriVch.get("periodNumber").toString()));
        }
        if (mapVeriVch.get("FBookedDate") == null) {
            acctCussentHistoryInfo.setVerVchDate(this.sysStartDate);
        } else {
            acctCussentHistoryInfo.setVerVchDate((java.util.Date)mapVeriVch.get("FBookedDate"));
        }
        acctCussentHistoryInfo.setVerifyManualAuto(VerifyManualAutoEnum.Auto);
        return acctCussentHistoryInfo;
    }

    private String getAcctcussentHistoryNumber(Context ctx, java.util.Date date, CompanyOrgUnitInfo company) throws BOSException {
        String number = null;
        String sql = "select max(TO_INTEGER(fnumber)) FNumber from T_GL_AcctCussentHistory where  FcompanyID=? and  FVerifyDate = ?";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), new Date(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()).getTime())});
        try {
            if (row != null && row.next()) {
                number = row.getString("FNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (number == null) {
            number = "1";
        } else {
            int value = new BigDecimal(number).intValue();
            number = String.valueOf(value + 1);
        }
        return StringUtils.fixNumber((int)Integer.parseInt(number), (int)8);
    }

    private Map getHgMap(List<Map> objList, Map param) {
        HashMap result = new HashMap();
        Map item = null;
        String key = null;
        String pnKey = null;
        HashMap<String, ArrayList<Map>> assgrpListMap = null;
        ArrayList<Map> positive = null;
        ArrayList<Map> negative = null;
        BigDecimal oriAmount = null;
        String amountField = "FUnVerifiedAmtFor";
        if (param.get("amountField") != null) {
            amountField = (String)param.get("amountField");
        }
        boolean checkBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        boolean nullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        boolean isSumDC = param.containsKey("isSumDC") ? (Boolean)param.get("isSumDC") : false;
        boolean isActKey = param.get("isActKey") != null;
        boolean isAccountList = param.get("isAccountList") != null;
        String hgstr = "hgid";
        if (isAccountList) {
            String selector = (String)param.get("selector");
            hgstr = selector.substring(0, selector.indexOf(","));
        }
        for (int i = 0; i < objList.size(); ++i) {
            item = objList.get(i);
            key = (String)item.get(hgstr) + item.get("fcurrid");
            if (isSumDC) {
                key = key + item.get("hgid");
            }
            if (nullBizNumIsNotSame) {
                Object bizNum = item.get("FBizNumber");
                if (bizNum == null) {
                    bizNum = "";
                }
                key = key + bizNum;
            }
            if (isActKey) {
                key = key + item.get("accountid");
                Object companyid = item.get("fsumcompanyid");
                if (companyid != null) {
                    key = key + companyid;
                }
            }
            pnKey = (oriAmount = (BigDecimal)item.get(amountField)).compareTo(this.ZERO) > 0 ? "positive" : "negative";
            if (result.containsKey(key)) {
                ((List)((Map)result.get(key)).get(pnKey)).add(item);
                continue;
            }
            positive = new ArrayList<Map>();
            negative = new ArrayList<Map>();
            if (oriAmount.compareTo(this.ZERO) > 0) {
                positive.add(item);
            } else {
                negative.add(item);
            }
            assgrpListMap = new HashMap<String, ArrayList<Map>>();
            assgrpListMap.put("positive", positive);
            assgrpListMap.put("negative", negative);
            result.put(key, assgrpListMap);
        }
        return result;
    }

    private void dealListToMap(List<Map<String, Object>> objList, Map param, Map<String, List> positiveMap, Map<String, List> negativeMap) {
        String amountField = "FUnVerifiedAmtFor";
        if (param.get("amountField") != null) {
            amountField = (String)param.get("amountField");
        }
        Map<String, Object> item = null;
        String key = null;
        ArrayList<Map<String, Object>> itemList = null;
        BigDecimal oriAmount = null;
        boolean checkBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        for (int i = 0; i < objList.size(); ++i) {
            item = objList.get(i);
            key = (String)item.get("hgId");
            oriAmount = (BigDecimal)item.get(amountField);
            if (oriAmount.compareTo(this.ZERO) > 0) {
                if (positiveMap.containsKey(key)) {
                    positiveMap.get(key).add(item);
                    continue;
                }
                itemList = new ArrayList<Map<String, Object>>();
                itemList.add(item);
                positiveMap.put(key, itemList);
                continue;
            }
            if (negativeMap.containsKey(key)) {
                negativeMap.get(key).add(item);
                continue;
            }
            itemList = new ArrayList();
            itemList.add(item);
            negativeMap.put(key, itemList);
        }
    }

    private void getPositiveAndNegativeMap(List<Map<String, Object>> objList, Map param, Map<String, List> positiveMap, Map<String, List> negativeMap) {
        String amountField = "FUnVerifiedAmtFor";
        if (param.get("amountField") != null) {
            amountField = (String)param.get("amountField");
        }
        Map<String, Object> item = null;
        String key = null;
        ArrayList<Map<String, Object>> itemList = null;
        BigDecimal oriAmount = null;
        boolean checkBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        for (int i = 0; i < objList.size(); ++i) {
            item = objList.get(i);
            if (checkBizNum) {
                key = (String)item.get("FAssGrpID");
            } else {
                Object bizNum = item.get("FBizNumber");
                if (bizNum == null) {
                    bizNum = "";
                }
                key = (String)item.get("FAssGrpID") + bizNum;
            }
            oriAmount = (BigDecimal)item.get(amountField);
            if (oriAmount.compareTo(this.ZERO) > 0) {
                if (positiveMap.containsKey(key)) {
                    positiveMap.get(key).add(item);
                    continue;
                }
                itemList = new ArrayList<Map<String, Object>>();
                itemList.add(item);
                positiveMap.put(key, itemList);
                continue;
            }
            if (negativeMap.containsKey(key)) {
                negativeMap.get(key).add(item);
                continue;
            }
            itemList = new ArrayList();
            itemList.add(item);
            negativeMap.put(key, itemList);
        }
    }

    private String getInsertSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_GL_AcctCussentHistory (\t\t\t\t\t\t\t\t\r\n");
        sql.append("FID,FOroginalAmount,FLocalAmount,FReportAmount,FQty,\t\t\t\r\n");
        sql.append("ForiginalBalance,FlocalBalance,FreportBanlance,FqtyBalance,\t\r\n");
        sql.append("FCussentidID,FVoucherAsstIDID,FDC,FVerifyDate,FAccountID,\t\t\r\n");
        sql.append("FAssGrpID,FCurrencyID,FCreatorID,FCompanyId,\t\t\t\t\t\t\r\n");
        sql.append("FNumber,FSeq,FBalType,FVchNumber,FVchDate,FVerVchDate,FBizDate,FbizNumber,FDescription, \r\n");
        sql.append("FVerifyManualAuto,FVeriVchID,FVeriEntryID,                                 \r\n");
        sql.append(" FCussVchID,FCussEntryID,         \r\n");
        sql.append(" FCussPeriod,FVeriPeriod,         \r\n");
        sql.append(" FCussOriginalAmount,             \r\n");
        sql.append(" FCussLocalAmount,                \r\n");
        sql.append(" FCussReportAmount,               \r\n");
        sql.append(" FCussQty )                        \r\n");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
        sql.append(" ?,?,?,?,?,?,?,?)                   \r\n");
        return sql.toString();
    }

    private String getUpdateSQL(Map param) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(param.get("tempTable")).append(" set ");
        sql.append(" set FUnVerifiedAmtFor = ?, deleteFlg = 0\t\r\n");
        sql.append(" where fid = ? ");
        return sql.toString();
    }

    private boolean initSrcSqlAndParam(Context ctx, Map param, StringBuilder selectSql, StringBuilder selectCountSql, StringBuilder lockSql, List params, List lockParams) throws EASBizException, BOSException {
        String bizNumber;
        AccountViewInfo accountViewInfo = (AccountViewInfo)param.get("account");
        if (accountViewInfo == null || param.get("currency") == null || param.get("company") == null) {
            return false;
        }
        String companyID = ((CompanyOrgUnitInfo)param.get("company")).getId().toString();
        String currencyID = ((CurrencyInfo)param.get("currency")).getId().toString();
        String accountID = accountViewInfo.getId().toString();
        java.util.Date dateTo = (java.util.Date)param.get("dateTo");
        Date end = null;
        if (dateTo != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateTo);
            dateTo = cal.getTime();
            end = new Date(dateTo.getTime());
        }
        StringBuffer sqlAssistJoin = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid fid, null fvoucherid, null fentryid,N' ' FNumber, a.fvarbizdate FBizDate,a.FBizNumber FBizNumber, ");
        if (SQLUtil.isPG(ctx)) {
            sql.append(" to_date(a.FBookedDate) FBookedDate, \r\n");
        } else {
            sql.append(" a.FBookedDate FBookedDate, \r\n");
        }
        sql.append(" a.FDescription FDescription,v.FDC FDC,  \r\n");
        sql.append(" a.FAssGrpID FAssGrpID,a.fvchassistrecordid voucherAssistRecordID, \r\n");
        sql.append(" a.FAccountId FAccountID, a.FCurrencyID , pd.fnumber periodNumber, \r\n");
        sql.append(" a.FOriginalAmount FOriginalAmount,\t \r\n");
        sql.append(" a.FUnVerifiedAmtFor FUnVerifiedAmtFor,  \r\n");
        sql.append(" a.FUnverifiedAmtLocal, \r\n");
        sql.append(" a.FUnverifiedAmtRpt, \r\n");
        sql.append(" a.FUnverifiedQty, \r\n");
        sql.append(" a.FLocalAmount, \r\n");
        sql.append(" a.FReportingAmount, \r\n");
        sql.append(" a.FQuantity \r\n");
        sql.append(" from T_GL_AcctCussent a  \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid \r\n");
        sql.append(" left join t_bd_period pd on pd.fid = a.fperiodid   \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId =hg.fid  \r\n");
        sql.append(sqlAssistJoin);
        sql.append(" \r\n where  a.FUnVerifiedAmtFor <> 0 and a.FIsInit=1 and a.FISINITCLOSED=1 \r\n");
        sql.append(" and a.FCompanyID = ? and a.FCurrencyID = ? and a.FAccountID = ? \r\n");
        params.add(companyID);
        params.add(currencyID);
        params.add(accountID);
        if (dateTo != null) {
            sql.append(" and a.FBookedDate <= ?  ");
            params.add(end);
        }
        if ((bizNumber = (String)param.get("bizNumber")) != null) {
            sql.append(" and a.FBizNumber like ?  ");
            params.add(bizNumber);
        }
        boolean unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        boolean nullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        if (nullBizNumIsNotSame) {
            sql.append(" and a.FBizNumber is not null  ");
        }
        sql.append(" \r\n");
        sql.append(" union all \r\n");
        StringBuffer sqlNotInit = new StringBuffer();
        sqlNotInit.append("select a.fid fid,a.fvoucherid fvoucherid,a.fentryid fentryid,a.FVchNumber FNumber,  \r\n");
        sqlNotInit.append(" a.fvarbizdate FBizDate,a.FBizNumber FBizNumber, \r\n");
        if (SQLUtil.isPG(ctx)) {
            sqlNotInit.append(" to_date(a.FBookedDate) FBookedDate, \r\n");
        } else {
            sqlNotInit.append(" a.FBookedDate FBookedDate, \r\n");
        }
        sqlNotInit.append(" a.FDescription FDescription,v.FDC FDC, \r\n");
        sqlNotInit.append(" a.FAssGrpID FAssGrpID,a.fvchassistrecordid voucherAssistRecordID, \r\n");
        sqlNotInit.append(" a.FAccountId FAccountID, a.FCurrencyID FCurrencyID, pd.fnumber periodNumber, \r\n");
        sqlNotInit.append(" a.FOriginalAmount FOriginalAmount, \r\n");
        sqlNotInit.append(" a.FUnVerifiedAmtFor FUnVerifiedAmtFor,   \r\n");
        sqlNotInit.append(" a.FUnverifiedAmtLocal, \r\n");
        sqlNotInit.append(" a.FUnverifiedAmtRpt, \r\n");
        sqlNotInit.append(" a.FUnverifiedQty, \r\n");
        sqlNotInit.append(" a.FLocalAmount, \r\n");
        sqlNotInit.append(" a.FReportingAmount, \r\n");
        sqlNotInit.append(" a.FQuantity \r\n");
        sqlNotInit.append(" from T_GL_AcctCussent a   \r\n");
        sqlNotInit.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid  \r\n");
        sqlNotInit.append(" inner join t_bd_period pd on pd.fid = a.fperiodid   \r\n");
        sqlNotInit.append(" inner join v_gl_acperiod acp on acp.fperiodid=a.fperiodid \r\n");
        sqlNotInit.append(" inner join T_bd_assistanthg hg on a.FassgrpId = hg.fid  \r\n");
        sqlNotInit.append(sqlAssistJoin);
        sqlNotInit.append(" \r\n where a.FUnVerifiedAmtFor <> 0 and a.FIsInit=0 \r\n");
        sqlNotInit.append(" and a.FCompanyID = ?  and a.FCurrencyID = ? and a.FAccountID = ? \r\n");
        params.add(companyID);
        params.add(currencyID);
        params.add(accountID);
        lockParams.add(companyID);
        lockParams.add(currencyID);
        lockParams.add(accountID);
        int verifyMode = GlUtils.getVerifyMode(ctx, companyID);
        if (verifyMode == 1) {
            sqlNotInit.append("and a.fispost = 1 ");
        } else {
            sqlNotInit.append("and a.fispost > -1 ");
        }
        sqlNotInit.append(" and acp.fcompanyid = ? \r\n");
        params.add(companyID);
        lockParams.add(companyID);
        if (dateTo != null) {
            sqlNotInit.append(" and a.FBookedDate <= ?  ");
            params.add(end);
            lockParams.add(end);
        }
        if (bizNumber != null) {
            sqlNotInit.append(" and a.FBizNumber like ?  ");
            params.add(bizNumber);
            lockParams.add(bizNumber);
        }
        if (nullBizNumIsNotSame) {
            sqlNotInit.append(" and a.FBizNumber is not null  ");
        }
        sqlNotInit.append(" \r\n");
        sql.append(sqlNotInit);
        selectSql.append(sql);
        lockSql.append(" update t_gl_voucher set  FCancellerID = FCancellerID where fid in ( select distinct t.fvoucherid from (").append(sqlNotInit).append(" )t ) ");
        return true;
    }

    protected List<Map<String, Object>> _getVerifySrcData(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuilder selectSql = new StringBuilder();
        List params = new ArrayList();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map acMap = (Map)param.get("acMap");
        selectSql.append("select * from(");
        selectSql.append(acMap.get("srcSql"));
        String sql = (String)acMap.get("hisSql");
        if (!StringUtils.isEmpty((String)sql)) {
            selectSql.append(" union all \r\n");
            selectSql.append(sql);
        }
        if (param.containsKey("isDetail")) {
            selectSql.append(")t order by t.").append(param.get("verifyField")).append(",t.FBizNumber");
        } else {
            selectSql.append(")t order by t.fbizDate,t.FBizNumber");
        }
        params = (List)acMap.get("srcParams");
        Connection con = null;
        PreparedStatement psSrc = null;
        ResultSet rsSrc = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            psSrc = con.prepareStatement(selectSql.toString());
            for (int i = 0; i < params.size(); ++i) {
                psSrc.setObject(i + 1, params.get(i));
            }
            psSrc.setFetchSize(this.fetchSize);
            rsSrc = psSrc.executeQuery();
            result.addAll(this.rowSetToListByKey(rsSrc, (String)acMap.get("acSelector")));
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsSrc, psSrc, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsSrc, (Statement)psSrc, (Connection)con);
        return result;
    }

    private String createTempTable(Context ctx, String table) throws EASBizException, BOSException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("(fid VARCHAR(44), ");
        createSql.append("fvoucherid VARCHAR(44), ");
        createSql.append("fentryid VARCHAR(44), ");
        createSql.append("FNumber VARCHAR(120), ");
        createSql.append("FBizDate datetime, ");
        createSql.append("FBizNumber NVARCHAR(300), ");
        createSql.append("FBookedDate datetime, ");
        createSql.append("FDescription NVARCHAR(500), ");
        createSql.append("FDC int, ");
        createSql.append("FAssGrpID VARCHAR(44), ");
        createSql.append("voucherAssistRecordID VARCHAR(44), ");
        createSql.append("FAccountID VARCHAR(44), ");
        createSql.append("FCurrencyID VARCHAR(44), ");
        createSql.append("periodNumber int, ");
        createSql.append("FOriginalAmount numeric(28,10), ");
        createSql.append("FUnVerifiedAmtFor numeric(28,10), ");
        createSql.append("FUnverifiedAmtLocal numeric(28,10), ");
        createSql.append("FUnverifiedAmtRpt numeric(28,10), ");
        createSql.append("FUnverifiedQty numeric(28,10), ");
        createSql.append("FLocalAmount numeric(28,10), ");
        createSql.append("FReportingAmount numeric(28,10), ");
        createSql.append("FQuantity numeric(28,10) ");
        createSql.append(")");
        return GLAcctAgeUtils.createTempTableByDDL(ctx, table, createSql);
    }

    protected void delVerifyTaskSrcData(Context ctx, Map param) throws BOSException, EASBizException {
        ResultSet rsDes;
        ResultSet rsSrc;
        PreparedStatement psDes;
        PreparedStatement psSrc;
        Connection con;
        block18: {
            StringBuilder selectSrcSql = new StringBuilder();
            StringBuilder selectDesSql = new StringBuilder();
            StringBuilder lockSql = new StringBuilder();
            ArrayList paramSrc = new ArrayList();
            ArrayList paramDes = new ArrayList();
            ArrayList lockParams = new ArrayList();
            if (param.get("isTask") != null) {
                int rowMult;
                int n = rowMult = param.get("rowMult") == null ? 1 : (Integer)param.get("rowMult");
                if (rowMult > 0) {
                    this.count *= rowMult;
                    if (this.count > this.maxCount) {
                        this.count = this.maxCount;
                    }
                }
            } else {
                this.count = this.maxCount;
            }
            long s = System.currentTimeMillis();
            long et = 1L;
            con = null;
            psSrc = null;
            psDes = null;
            rsSrc = null;
            rsDes = null;
            try {
                this.actTemp = this.createTempTable(ctx, "gl_act_cussent_tmp");
                this.verTemp = this.createTempTable(ctx, "gl_act_verify_tmp");
                if (!this.initSrcSqlAndParam(ctx, param, selectSrcSql, null, lockSql, paramSrc, lockParams)) {
                    return;
                }
                StringBuilder sql = new StringBuilder();
                boolean unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
                if (!unCheckBizNum) {
                    sql.append(" insert into ").append(this.actTemp).append(" select t.* from (").append((CharSequence)selectSrcSql).append(") t ").append(" order by FBizNumber ");
                } else {
                    sql.append(" insert into ").append(this.actTemp).append(" select t.* from (").append((CharSequence)selectSrcSql).append(") t ");
                }
                DbUtil.execute((Context)ctx, (String)lockSql.toString(), (Object[])lockParams.toArray());
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramSrc.toArray());
                lockParams = new ArrayList();
                lockSql.setLength(0);
                if (!this.initDesSqlAndParam(ctx, param, selectDesSql, lockSql, paramDes, lockParams)) {
                    return;
                }
                sql.setLength(0);
                sql.append(" insert into ").append(this.verTemp).append(" ").append((CharSequence)selectDesSql);
                DbUtil.execute((Context)ctx, (String)lockSql.toString(), (Object[])lockParams.toArray());
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramDes.toArray());
                et = System.currentTimeMillis();
                logger.error((Object)("insert-tmp-time->" + (et - s)));
                con = EJBFactory.getConnection((Context)ctx);
                String querySql = "select top " + this.count + " * from " + this.actTemp + " order by FAssGrpID, FBizDate,FBizNumber,fnumber";
                psSrc = con.prepareStatement(querySql, 1003, 1007);
                psSrc.setFetchSize(this.fetchSize);
                querySql = "select top " + this.count + " * from " + this.verTemp + " order by FAssGrpID, FBizDate,FBizNumber,fnumber";
                psDes = con.prepareStatement(querySql, 1003, 1007);
                psDes.setFetchSize(this.fetchSize);
                s = System.currentTimeMillis();
                logger.error((Object)("query-time->" + (s - et)));
                this.dealTaskData(ctx, param, psSrc, psDes);
                et = System.currentTimeMillis();
                logger.error((Object)("dealTaskData-time->" + (et - s)));
                if (this.actTemp == null) break block18;
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.actTemp != null) {
                    InitHelp.dropTempTable(ctx, this.actTemp);
                }
                if (this.verTemp != null) {
                    InitHelp.dropTempTable(ctx, this.verTemp);
                }
                SQLUtils.cleanup(rsSrc, psSrc);
                SQLUtils.cleanup(rsDes, psDes, con);
            }
            InitHelp.dropTempTable(ctx, this.actTemp);
        }
        if (this.verTemp != null) {
            InitHelp.dropTempTable(ctx, this.verTemp);
        }
        SQLUtils.cleanup(rsSrc, (Statement)psSrc);
        SQLUtils.cleanup(rsDes, (Statement)psDes, (Connection)con);
    }

    private void dealTaskData(Context ctx, Map<String, Object> param, PreparedStatement psSrc, PreparedStatement psDes) throws EASBizException, BOSException {
        long s = System.currentTimeMillis();
        int c = 0;
        int d = 0;
        boolean unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        boolean nullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        ResultSet rsSrc = null;
        ResultSet rsDes = null;
        try {
            rsSrc = psSrc.executeQuery();
            while (rsSrc.next()) {
                this.delSrcOrDesList(rsSrc, null, this.hgIdSrcList, unCheckBizNum, nullBizNumIsNotSame, true);
                ++c;
            }
            rsDes = psDes.executeQuery();
            while (rsDes.next()) {
                this.delSrcOrDesList(rsDes, null, this.hgIdDesList, unCheckBizNum, nullBizNumIsNotSame, false);
                ++d;
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rsSrc);
                SQLUtils.cleanup(rsDes);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsSrc);
        SQLUtils.cleanup((ResultSet)rsDes);
        long e = System.currentTimeMillis();
        logger.error((Object)("query-data-time->" + (e - s) + "-->data.size-->" + c + "-->" + d));
        if (c > 0 || d > 0) {
            this.executeTask(ctx, param, null, null);
            DbUtil.execute((Context)ctx, (String)("delete from " + this.actTemp + " where fid in (select top " + this.count + " fid from " + this.actTemp + " order by FAssGrpID, FBizDate,FBizNumber,fnumber)"));
            DbUtil.execute((Context)ctx, (String)("delete from " + this.verTemp + " where fid in (select top " + this.count + " fid from " + this.verTemp + " order by FAssGrpID, FBizDate,FBizNumber,fnumber)"));
            this.txTime = System.currentTimeMillis() - this.txStartTime;
            if (this.txTime > this.maxTxTime) {
                this.completeTX = false;
                return;
            }
            this.dealTaskData(ctx, param, psSrc, psDes);
        }
    }

    private void delSrcOrDesList(ResultSet rs, List result, List<String> hgIdList, boolean unCheckBizNum, boolean nullBizNumIsNotSame, boolean isSrc) throws SQLException {
        HashMap<String, Object> item = new HashMap<String, Object>();
        String FAccountID = rs.getString("FAccountID");
        String FAssGrpID = rs.getString("FAssGrpID");
        String bizNum = rs.getString("FBizNumber");
        String curId = rs.getString("FCurrencyID");
        String hgId = curId + FAssGrpID;
        if (!unCheckBizNum) {
            if (nullBizNumIsNotSame && StringUtils.isEmpty((String)bizNum)) {
                return;
            }
            bizNum = bizNum == null ? "" : bizNum;
            hgId = hgId + bizNum;
        }
        if (!hgIdList.contains(hgId)) {
            hgIdList.add(hgId);
        }
        String FAssIDsTmp = "";
        item.put("hgId", hgId);
        item.put("FAccountID", FAccountID);
        item.put(this.hgKey, FAssGrpID);
        item.put(this.asstKey, FAssIDsTmp);
        item.put("FBizNumber", bizNum);
        String id = rs.getString("fid");
        BigDecimal oriAmount = rs.getBigDecimal("FUnVerifiedAmtFor");
        item.put("acctCussentId", id);
        item.put("voucherAssistRecordId", rs.getString("voucherAssistRecordID"));
        item.put("fvoucherid", rs.getString("fvoucherid"));
        item.put("fentryid", rs.getString("fentryid"));
        item.put("FNumber", rs.getString("FNumber"));
        item.put("FBizDate", rs.getDate("FBizDate"));
        item.put("FBookedDate", rs.getDate("FBookedDate"));
        item.put("FDescription", rs.getString("FDescription"));
        item.put("FDC", new Integer(rs.getInt("FDC")));
        item.put("FOriginalAmount", rs.getBigDecimal("FOriginalAmount"));
        item.put("FUnVerifiedAmtFor", oriAmount);
        item.put("FCurrencyID", rs.getString("FCurrencyID"));
        item.put("FUnverifiedAmtLocal", rs.getBigDecimal("FUnverifiedAmtLocal"));
        item.put("FUnverifiedAmtRpt", rs.getBigDecimal("FUnverifiedAmtRpt"));
        item.put("FUnverifiedQty", rs.getBigDecimal("FUnverifiedQty"));
        item.put("FLocalAmount", rs.getBigDecimal("FLocalAmount"));
        item.put("FReportingAmount", rs.getBigDecimal("FReportingAmount"));
        item.put("FQuantity", rs.getBigDecimal("FQuantity"));
        item.put("FVerifiedAmtFor", rs.getBigDecimal("FOriginalAmount").subtract(rs.getBigDecimal("FUnVerifiedAmtFor")));
        item.put("periodNumber", rs.getString("periodNumber"));
        if (isSrc) {
            this.cutListToMap(item, this.srcPositive, this.srcNegative, hgId, oriAmount);
        } else {
            this.cutListToMap(item, this.desPositive, this.desNegative, hgId, oriAmount);
        }
    }

    private void cutListToMap(Map item, Map<String, List> positiveMap, Map<String, List> negativeMap, String key, BigDecimal oriAmount) {
        ArrayList<Map> itemList = null;
        if (oriAmount.compareTo(this.ZERO) > 0) {
            if (positiveMap.containsKey(key)) {
                positiveMap.get(key).add(item);
            } else {
                itemList = new ArrayList<Map>();
                itemList.add(item);
                positiveMap.put(key, itemList);
            }
        } else if (negativeMap.containsKey(key)) {
            negativeMap.get(key).add(item);
        } else {
            itemList = new ArrayList();
            itemList.add(item);
            negativeMap.put(key, itemList);
        }
    }

    private List rowSetToListByKey(ResultSet rs, String selector) throws BOSException {
        ArrayList result = new ArrayList();
        String[] keys = selector.split(",");
        try {
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                for (String key : keys) {
                    item.put(key, rs.getObject(key));
                }
                result.add(item);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private StringBuffer transSortSelfDefineToSQL(EntityViewInfo mainQuery, String loc, boolean isSrc) {
        StringBuffer orderby = new StringBuffer();
        String strOrder = "";
        if (mainQuery == null) {
            return orderby;
        }
        strOrder = mainQuery.toString();
        if (strOrder.indexOf("VARBizDate") != -1) {
            strOrder = strOrder.replaceAll("VARBizDate", "FBizDate");
        }
        if (strOrder.indexOf("endDate") != -1) {
            strOrder = strOrder.replaceAll("endDate", "FBookedDate");
        }
        if (strOrder.indexOf("bizNumber") != -1) {
            strOrder = strOrder.replaceAll("bizNumber", "fbizNumber");
        }
        if (strOrder.indexOf("originalAmount") != -1) {
            strOrder = strOrder.replaceAll("originalAmount", "foriginalAmount");
        }
        if (strOrder.indexOf("unVerifiedAmtFor") != -1) {
            if (isSrc) {
                strOrder = strOrder.replaceAll("unVerifiedAmtFor", "FUnVerifiedAmtFor");
            } else {
                if (strOrder.indexOf("unVerifiedAmtFor ASC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor ASC,", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor DESC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor DESC,", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor ASC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor ASC", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor DESC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor DESC", "");
                }
            }
        }
        if (strOrder.indexOf("voucherType.name") != -1) {
            strOrder = strOrder.replaceAll("voucherType.name", "FvoucherType");
        }
        if (strOrder.indexOf("voucher.number") != -1) {
            strOrder = strOrder.replaceAll("voucher.number", "FNumber");
        }
        if ((strOrder = strOrder.trim()).endsWith(",")) {
            strOrder = strOrder.substring(0, strOrder.length() - 1);
        }
        if (!(strOrder = strOrder.trim()).equalsIgnoreCase("order by")) {
            orderby.append(strOrder).append("  \r\n");
        }
        return orderby;
    }

    protected List _getVerifyObjData(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        StringBuilder selectSql = new StringBuilder();
        List params = new ArrayList();
        Map acMap = (Map)param.get("acMap");
        selectSql.append("select t.* from(");
        selectSql.append(acMap.get("desSql"));
        selectSql.append(" union all \r\n");
        selectSql.append(acMap.get("hisDesSql"));
        if (param.containsKey("isDetail")) {
            selectSql.append(")t order by t.FEndDate").append(",t.FBizNumber");
        } else {
            selectSql.append(")t order by t.fbizDate,t.FBizNumber");
        }
        params = (List)acMap.get("desParams");
        params.addAll((List)acMap.get("initParams"));
        Connection con = null;
        PreparedStatement psSrc = null;
        ResultSet rsSrc = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            psSrc = con.prepareStatement(selectSql.toString(), 1003, 1007);
            for (int i = 0; i < params.size(); ++i) {
                psSrc.setObject(i + 1, params.get(i));
            }
            psSrc.setFetchSize(this.fetchSize);
            rsSrc = psSrc.executeQuery();
            result.addAll(this.rowSetToListByKey(rsSrc, (String)acMap.get("desSelector")));
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsSrc, psSrc, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsSrc, (Statement)psSrc, (Connection)con);
        return result;
    }

    private boolean initDesSqlAndParam(Context ctx, Map param, StringBuilder selectSql, StringBuilder lockSql, List params, List lockParams) {
        String bizNumber;
        AccountViewInfo accountViewInfo = (AccountViewInfo)param.get("account");
        if (accountViewInfo == null || param.get("currency") == null || param.get("company") == null) {
            return false;
        }
        String companyID = ((CompanyOrgUnitInfo)param.get("company")).getId().toString();
        String currencyID = ((CurrencyInfo)param.get("currency")).getId().toString();
        String accountID = accountViewInfo.getId().toString();
        boolean exclueUnpostVch = Boolean.TRUE.equals(param.get("notIncludeUnpostVch"));
        params.add(companyID);
        params.add(companyID);
        params.add(accountID);
        params.add(currencyID);
        java.util.Date dateTo = (java.util.Date)param.get("dateTo");
        if (dateTo != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateTo);
            dateTo = cal.getTime();
            Date end = new Date(dateTo.getTime());
            params.add(end);
        }
        if ((bizNumber = (String)param.get("bizNumber")) != null) {
            params.add(bizNumber);
        }
        StringBuffer select = new StringBuffer("select ");
        StringBuffer sql = new StringBuffer();
        sql.append(" c.fid fid,c.FVoucherID fvoucherid,c.FEntryID fentryid,c.FVchNumber FNumber,  \r\n \t  ");
        sql.append(" c.FVarBizDate FBizDate,c.FBizNumber FBizNumber, \r\n");
        if (SQLUtil.isPG(ctx)) {
            sql.append(" to_date(c.FBookedDate) FBookedDate, \r\n");
        } else {
            sql.append(" c.FBookedDate FBookedDate, \r\n");
        }
        sql.append(" c.FDescription FDescription,c.FEntrydc FDC, \r\n \t  ");
        sql.append(" c.FAssGrpID FAssGrpID, c.FVchAssistRecordID voucherAssistRecordID,  \r\n");
        sql.append(" c.FAccountID FAccountID, c.FCurrencyID FCurrencyID,  pd.fnumber periodNumber, \r\n");
        sql.append(" isnull(c.FOriginalAmount, 0) FOriginalAmount,  \r\n");
        sql.append(" isnull(c.FUnVerifiedAmtFor, 0) FUnVerifiedAmtFor,  \r\n");
        sql.append(" isnull(c.FUnverifiedAmtLocal, 0) FUnverifiedAmtLocal, \r\n");
        sql.append(" isnull(c.FUnverifiedAmtRpt, 0) FUnverifiedAmtRpt, \r\n");
        sql.append(" isnull(c.FUnverifiedQty, 0) FUnverifiedQty, \r\n");
        sql.append(" isnull(c.FLocalAmount,0) FLocalAmount, \r\n");
        sql.append(" isnull(c.FReportingAmount, 0) FReportingAmount, \r\n");
        sql.append(" isnull(c.FQuantity, 0) FQuantity \r\n");
        StringBuffer fromSql = new StringBuffer();
        fromSql.append(" from T_GL_AcctVerify c  \r\n");
        fromSql.append(" inner join t_bd_period pd on pd.fid = c.fperiodid   \r\n");
        fromSql.append(" inner join v_gl_acperiod acp  on acp.fperiodid=c.fperiodid\t \r\n");
        fromSql.append(" where c.FUnVerifiedAmtFor <> 0  \r\n ");
        if (exclueUnpostVch) {
            fromSql.append("and c.FIsPost = 1 \r\n");
        } else {
            fromSql.append("and c.FIsPost > -1 \r\n");
        }
        fromSql.append("and acp.fcompanyid = ? \r\n");
        fromSql.append("and c.FCompanyID = ? and c.Faccountid=? and c.FCurrencyID = ? \r\n");
        if (dateTo != null) {
            fromSql.append(" and c.FBookedDate <= ?  ");
        }
        if (bizNumber != null) {
            fromSql.append(" and c.FBizNumber like ?   \r\n");
        }
        boolean unCheckBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
        boolean nullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        if (nullBizNumIsNotSame) {
            fromSql.append(" and c.FBizNumber is not null  ");
        }
        String orderBySql = "";
        if (!unCheckBizNum) {
            orderBySql = " order by FBizNumber ";
            fromSql.append(orderBySql);
        }
        sql.append(fromSql);
        select.append(sql);
        selectSql.append(select);
        lockSql.append(" update t_gl_voucher set  FCancellerID = FCancellerID where fid in ( select distinct t.fvoucherid from (").append(select).append(" )t )");
        String lockSqlStr = lockSql.toString().replace(orderBySql, "");
        lockSql.setLength(0);
        lockSql.append(lockSqlStr);
        lockParams.addAll(params);
        return true;
    }

    public List<CurrencyInfo> getCurrencyListFromParam(Context ctx, Map<String, Object> param, AccountViewInfo acct) throws EASBizException, BOSException {
        ArrayList<CurrencyInfo> listCurrencyID = new ArrayList<CurrencyInfo>();
        if (param.get("currency") instanceof CurrencyInfo && ((CurrencyInfo)param.get("currency")).getNumber().compareToIgnoreCase("all") == 0) {
            AccountingCurrencyEnum acctCy = AccountingCurrencyEnum.ALLCURRENCY;
            if (acct != null) {
                acctCy = acct.getAccountingcurrency();
            }
            if (acctCy == AccountingCurrencyEnum.NOCURRENCY) {
                listCurrencyID.add((CurrencyInfo)param.get("LOCALCURRENCY"));
            } else if (acctCy == AccountingCurrencyEnum.ONECURRENCY) {
                CurrencyCollection cyColl = this.getAcctCyColl(ctx, acct);
                Iterator it = cyColl.iterator();
                while (it.hasNext()) {
                    listCurrencyID.add((CurrencyInfo)it.next());
                }
            } else if (acctCy == AccountingCurrencyEnum.ALLCURRENCY) {
                CurrencyCollection cyColl = this.getAllCyColl(ctx);
                Iterator it = cyColl.iterator();
                while (it.hasNext()) {
                    listCurrencyID.add((CurrencyInfo)it.next());
                }
            }
        } else {
            listCurrencyID.add((CurrencyInfo)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.CURRENCY));
        }
        return listCurrencyID;
    }

    private void updateUnverifiedAmtFor(Context ctx, String srcID, AcctCussentHistoryInfo acctCussentHistoryInfo, boolean isCuss) throws BOSException, SQLException {
        BigDecimal unverifiedAmtFor = acctCussentHistoryInfo.getOriginalBalance();
        BigDecimal unverifiedAmtLocal = acctCussentHistoryInfo.getLocalBalance();
        BigDecimal unverifiedAmtRpt = acctCussentHistoryInfo.getReportBanlance();
        BigDecimal unverifiedAmtQty = acctCussentHistoryInfo.getQtyBalance();
        if (isCuss) {
            this.batchUpdateActAmt(srcID, new BigDecimal[]{unverifiedAmtFor, unverifiedAmtLocal, unverifiedAmtRpt, unverifiedAmtQty});
        } else {
            this.batchUpdateVerAmt(srcID, new BigDecimal[]{unverifiedAmtFor, unverifiedAmtLocal, unverifiedAmtRpt, unverifiedAmtQty});
        }
    }

    private void updateVerifyUnverifiedAmtFor(Context ctx, String srcID, BigDecimal[] vals) throws BOSException {
        String sql = "update T_GL_AcctVerify set FUnVerifiedAmtFor = ?, FUnverifiedAmtLocal=? , FUnverifiedAmtRpt=? , FUnverifiedQty=? where FVchAssistRecordID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{vals[0], vals[1], vals[2], vals[3], srcID});
    }

    private void batchUpdateVerAmt(String srcID, BigDecimal[] vals) throws BOSException, SQLException {
        this.sqlUpdateVerAmt.setBigDecimal(1, vals[0]);
        this.sqlUpdateVerAmt.setBigDecimal(2, vals[1]);
        this.sqlUpdateVerAmt.setBigDecimal(3, vals[2]);
        this.sqlUpdateVerAmt.setBigDecimal(4, vals[3]);
        this.sqlUpdateVerAmt.setString(5, srcID);
        this.sqlUpdateVerAmt.addBatch();
        ++this.verAmt;
        if (this.verAmt == this.batchCount) {
            long s = System.currentTimeMillis();
            this.sqlUpdateVerAmt.executeBatch();
            this.sqlUpdateVerAmt.clearBatch();
            logger.error((Object)("sqlUpdateVerAmt-batchtime-->" + (System.currentTimeMillis() - s)));
            this.verAmt = 0;
        }
    }

    private void batchUpdateActAmt(String srcID, BigDecimal[] vals) throws BOSException, SQLException {
        this.sqlUpdateActAmt.setBigDecimal(1, vals[0]);
        this.sqlUpdateActAmt.setBigDecimal(2, vals[1]);
        this.sqlUpdateActAmt.setBigDecimal(3, vals[2]);
        this.sqlUpdateActAmt.setBigDecimal(4, vals[3]);
        this.sqlUpdateActAmt.setString(5, srcID);
        this.sqlUpdateActAmt.addBatch();
        ++this.actAmt;
        if (this.actAmt == this.batchCount) {
            long s = System.currentTimeMillis();
            this.sqlUpdateActAmt.executeBatch();
            this.sqlUpdateActAmt.clearBatch();
            this.actAmt = 0;
        }
    }

    protected void _deleteAcctCussHistory(Context ctx, String asstID) throws BOSException {
        String sql = "delete from T_GL_AcctCussentHistory where FVoucherAsstIDID=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{asstID});
    }

    private void insertHistory(Context ctx, AcctCussentHistoryInfo info, GLVerifyTypeEnum verifyType, PreparedStatement sqlInsert, Counter counter) throws BOSException, EASBizException, SQLException {
        if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
            this._deleteAcctCussHistory(ctx, info.getVoucherAsstID().getId().toString());
        }
        int index = 1;
        sqlInsert.setString(index++, info.getId().toString());
        sqlInsert.setBigDecimal(index++, info.getOroginalAmount());
        sqlInsert.setBigDecimal(index++, info.getLocalAmount());
        sqlInsert.setBigDecimal(index++, info.getReportAmount());
        sqlInsert.setBigDecimal(index++, info.getQty());
        sqlInsert.setBigDecimal(index++, info.getOriginalBalance());
        sqlInsert.setBigDecimal(index++, info.getLocalBalance());
        sqlInsert.setBigDecimal(index++, info.getReportBanlance());
        sqlInsert.setBigDecimal(index++, info.getQtyBalance());
        sqlInsert.setString(index++, info.getCussentid().getId().toString());
        sqlInsert.setString(index++, info.getVoucherAsstID().getId().toString());
        if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
            if (info.getOroginalAmount().signum() < 0) {
                sqlInsert.setInt(index++, 2);
            } else {
                sqlInsert.setInt(index++, 0);
            }
        } else {
            sqlInsert.setInt(index++, verifyType.getValue());
        }
        sqlInsert.setDate(index++, new Date(info.getVerifyDate().getTime()));
        sqlInsert.setString(index++, info.getAccount().getId().toString());
        sqlInsert.setString(index++, info.getAssgrp().getId().toString());
        sqlInsert.setString(index++, info.getCurrency().getId().toString());
        sqlInsert.setString(index++, info.getCreator().getId().toString());
        sqlInsert.setString(index++, info.getCompany().getId().toString());
        sqlInsert.setString(index++, info.getNumber());
        sqlInsert.setInt(index++, info.getSeq());
        sqlInsert.setInt(index++, 5);
        if (info.getVchNumber() != null) {
            sqlInsert.setString(index++, info.getVchNumber());
        } else {
            sqlInsert.setString(index++, null);
        }
        if (info.getVchDate() != null) {
            sqlInsert.setDate(index++, new Date(info.getVchDate().getTime()));
        } else {
            sqlInsert.setDate(index++, null);
        }
        if (info.getVerVchDate() != null) {
            sqlInsert.setDate(index++, new Date(info.getVerVchDate().getTime()));
        } else {
            sqlInsert.setDate(index++, null);
        }
        if (info.getBizDate() != null) {
            sqlInsert.setDate(index++, new Date(info.getBizDate().getTime()));
        } else {
            sqlInsert.setDate(index++, null);
        }
        if (info.getBizNumber() != null) {
            sqlInsert.setString(index++, info.getBizNumber());
        } else {
            sqlInsert.setString(index++, null);
        }
        if (info.getDescription() != null) {
            sqlInsert.setString(index++, info.getDescription());
        } else {
            sqlInsert.setString(index++, null);
        }
        if (info.getVerifyManualAuto() == null) {
            info.setVerifyManualAuto(VerifyManualAutoEnum.Manual);
        }
        sqlInsert.setInt(index++, info.getVerifyManualAuto().getValue());
        if (info.getVeriVch() != null) {
            sqlInsert.setString(index++, info.getVeriVch().getId().toString());
            sqlInsert.setString(index++, info.getVeriEntry().getId().toString());
        } else {
            sqlInsert.setString(index++, null);
            sqlInsert.setString(index++, null);
        }
        if (info.getCussVch() != null) {
            sqlInsert.setString(index++, info.getCussVch().getId().toString());
            sqlInsert.setString(index++, info.getCussEntry().getId().toString());
        } else {
            sqlInsert.setString(index++, null);
            sqlInsert.setString(index++, null);
        }
        sqlInsert.setInt(index++, info.getCussPeriod());
        sqlInsert.setInt(index++, info.getVeriPeriod());
        sqlInsert.setBigDecimal(index++, info.getCussOriginalAmount());
        sqlInsert.setBigDecimal(index++, info.getCussLocalAmount());
        sqlInsert.setBigDecimal(index++, info.getCussReportAmount());
        sqlInsert.setBigDecimal(index++, info.getCussQty() == null ? new BigDecimal(0) : info.getCussQty());
        sqlInsert.addBatch();
        counter.add();
        if (counter.getValue() % this.batchCount == 0) {
            sqlInsert.executeBatch();
            sqlInsert.clearBatch();
            counter.clear();
        }
    }

    private CurrencyCollection getAcctCyColl(Context ctx, AccountViewInfo acct) throws BOSException, EASBizException {
        CurrencyCollection CyColl = new CurrencyCollection();
        IAccountCurrency iac = AccountCurrencyFactory.getLocalInstance((Context)ctx);
        AccountCurrencyCollection acColl = iac.getAccountCurrencyCollection("select currency.id where accountView.id = '" + acct.getId().toString() + "'");
        AccountCurrencyInfo acInfo = null;
        CurrencyInfo cyInfo = null;
        for (int i = 0; i < acColl.size(); ++i) {
            acInfo = acColl.get(i);
            cyInfo = new CurrencyInfo();
            cyInfo.setId(acInfo.getCurrency().getId());
            CyColl.add(cyInfo);
        }
        return CyColl;
    }

    private CurrencyCollection getAllCyColl(Context ctx) throws BOSException, EASBizException {
        CurrencyCollection CyColl = new CurrencyCollection();
        ICurrency icy = CurrencyFactory.getLocalInstance((Context)ctx);
        CyColl = icy.getCurrencyCollection(true);
        return CyColl;
    }

    public static enum VerifyType {
        SAMEVERIFY,
        VERIFYPANDN,
        NEGATIVEVERIFY,
        COMMONVERIFY;

    }

    static class Counter {
        private int counter = 0;

        Counter() {
        }

        public void add() {
            ++this.counter;
        }

        public void clear() {
            this.counter = 0;
        }

        public int getValue() {
            return this.counter;
        }
    }
}

