/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistory;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractCancelBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CancelVoucherService
extends AbstractCancelBaseVoucherService {
    public CancelVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected SelectorItemCollection getCancelSelector() {
        return VoucherInfo.getDefaultProcessSelector();
    }

    protected void updateCancelStatus(Context ctx, String voucherId) throws BOSException {
        VoucherOprateSharer.updateVoucherStatus(ctx, voucherId, null, VoucherStatusEnum.SUBMITTED.getValue(), "FAuditorid");
    }

    @Override
    protected void logVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber, Exception ex) throws BOSException, EASBizException {
        VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber((VoucherInfo)voucherInfo, voucherNumber, "recycleNumber", ex);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected HashMap getParamMap(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return GlUtils.getDefaultGLParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    @Override
    protected void beforeCancel(Context ctx, BaseVoucherInfo voucherInfo, Map hmAllParam) throws EASBizException, BOSException {
        boolean isInTimeVerify;
        super.beforeCancel(ctx, voucherInfo, hmAllParam);
        boolean useACNotice = Boolean.valueOf(hmAllParam.get("GLG01").toString());
        boolean removeDAP_void = Boolean.valueOf(hmAllParam.get("GL_019_1").toString());
        if (useACNotice) {
            AcNoticeUtil.checkACNoticeCorrelation(ctx, voucherInfo.getId().toString());
        }
        this.checkVerifiedStatus(ctx, voucherInfo, hmAllParam, VoucherOperateStatusEnum.CANCLE);
        this.dealAmortWithvrh(ctx, (VoucherInfo)voucherInfo);
        boolean allowcuss = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        boolean updateAcct = false;
        boolean bl = isInTimeVerify = Integer.parseInt(hmAllParam.get("GL_052").toString()) == 0;
        if (allowcuss && voucherInfo.isIsAC() && isInTimeVerify) {
            updateAcct = true;
        }
        if (allowcuss && voucherInfo.isIsAC()) {
            AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).updateCussents(voucherInfo.getId().toString(), -1);
        }
        if (useACNotice) {
            IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance(ctx);
            reqCtrl.clearReqRelation("'" + voucherInfo.getId().toString() + "'", true);
        }
        if (updateAcct) {
            VoucherUtil.updateAcctCussentBalance(ctx, voucherInfo.getId().toString(), true);
        }
        if (isInTimeVerify) {
            try {
                if (voucherInfo.isIsReverseVoucher()) {
                    String sql = "delete t_gl_acctcussenthistory where FCussVchID = ? or FVeriVchID = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{voucherInfo.getId().toString(), voucherInfo.getId().toString()});
                } else {
                    VoucherEntryCollection voucherEntryCollection = (VoucherEntryCollection)voucherInfo.getEntries();
                    for (int i = 0; i < voucherEntryCollection.size(); ++i) {
                        VoucherEntryInfo voucherEntryInfo = voucherEntryCollection.get(i);
                        String entryId = voucherEntryInfo.getId().toString();
                        List AssistRecordList = this.getAssistRecordByEntryId(ctx, entryId);
                        for (String AssistRecordID : AssistRecordList) {
                            IAcctCussentHistory iAcctCussentHistory = AcctCussentHistoryFactory.getLocalInstance(ctx);
                            iAcctCussentHistory.deleteAcctCussHistory(AssistRecordID);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        boolean isFzz = Boolean.valueOf(hmAllParam.get("GL_060").toString());
        this.checkPiaoJu(ctx, voucherInfo.getId().toString(), isFzz, false);
    }

    private void dealAmortWithvrh(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (VoucherUtil.isAmortVoucher(voucherInfo)) {
            String id = voucherInfo.getSourceBillId().toString();
            String sqlAmortLog = "select vlog.FID,vlog.FAmortSchemeID,vlog.FPeriodID,vs.FAmortAmount,policy.famount FPolicyAmount  from t_gl_vchamortlog vlog inner join t_gl_vchamortscheme vs on vlog.famortschemeid=vs.fid  inner join t_gl_vchamortpolicy policy on policy.famortschemeid=vs.fid and policy.fperiodid=vlog.fperiodid  where vlog.FVoucherID=?";
            IRowSet rsAmortLog = DbUtil.executeQuery((Context)ctx, (String)sqlAmortLog, (Object[])new Object[]{voucherInfo.getId().toString()});
            try {
                if (rsAmortLog.next()) {
                    String amortSchemeId = rsAmortLog.getString("FAmortSchemeID");
                    String periodId = rsAmortLog.getString("FPeriodID");
                    String logId = rsAmortLog.getString("FID");
                    BigDecimal amortAmount = rsAmortLog.getBigDecimal("FAmortAmount");
                    BigDecimal policyAmount = rsAmortLog.getBigDecimal("FPolicyAmount");
                    BigDecimal leftAmortAmount = amortAmount.subtract(policyAmount);
                    String status = "1";
                    if (leftAmortAmount.signum() != 0) {
                        status = "2";
                    }
                    String updateScheme = "update t_gl_vchamortscheme set famortamount=?,fstatus=? where fid=?";
                    DbUtil.execute((Context)ctx, (String)updateScheme, (Object[])new Object[]{leftAmortAmount, new Integer(status), amortSchemeId});
                    String updatePolicy = "update t_gl_vchamortpolicy set fisvouchered=0 where famortschemeid=? and fperiodid=?";
                    DbUtil.execute((Context)ctx, (String)updatePolicy, (Object[])new Object[]{amortSchemeId, periodId});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void processDap(Context ctx, BaseVoucherInfo voucherInfo, boolean removeDAP_void) throws BOSException, EASBizException {
        if (removeDAP_void && (SourceType.NONE.equals((Object)voucherInfo.getSourceType()) || voucherInfo.getSourceBillId() != null)) {
            IDAPTransformer iDAPTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            iDAPTransformer.undoTransformFromVoucher((BaseVoucherInfo)((VoucherInfo)voucherInfo));
        }
    }

    @Override
    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (VoucherInfo)voucherInfo, voucherInfo.getBizStatus());
    }

    @Override
    protected boolean isFromOtherSystem(BaseVoucherInfo voucherInfo) {
        return !SystemEnum.GENERALLEDGER.equals((Object)voucherInfo.getSourceSys());
    }

    @Override
    protected void afterCancel(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance(ctx);
        iCFReq.clearRequisition((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
        this.invokeVoucherCancelPostProcessor(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected BaseVoucherInfo newInfo() {
        return new VoucherInfo();
    }

    private void checkVerifiedStatus(Context ctx, BaseVoucherInfo voucherInfo, Map sysParam, VoucherOperateStatusEnum status) throws BOSException, VoucherException {
        boolean hasVerified;
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = Integer.parseInt(sysParam.get("GL_052").toString()) == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit() && voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    private List getAssistRecordByEntryId(Context ctx, String entryId) throws BOSException, SQLException {
        ArrayList<String> assistAssistRecoreList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("select Assist.FID as assistID ");
        sql.append("\r\n from  ");
        sql.append("\r\n T_GL_VoucherAssistRecord Assist ");
        StringBuffer whereSql = new StringBuffer("\r\n  where");
        StringBuffer causeSQL = new StringBuffer();
        StringBuffer groupBySQL = new StringBuffer();
        causeSQL.append(" \r\n Assist.FEntryID=?");
        sql.append(whereSql).append(causeSQL).append(groupBySQL);
        Object[] params = new Object[]{entryId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        while (rs.next()) {
            assistAssistRecoreList.add(rs.getString("assistID"));
        }
        return assistAssistRecoreList;
    }

    protected void checkPiaoJu(Context ctx, String id, boolean isFzz, boolean isSubmit) throws BOSException, EASBizException {
        if (!isFzz) {
            return;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("  select a.fnumber,a.fcompanyid,b.fcurrencyid,sum(c.foriginalamount) famount, c.fsettlementcode,d.fbankaccountid,f.fnttypeid  \r\n");
        sql.append("\tfrom  \t\r\n");
        sql.append("\tt_gl_voucher a,t_gl_voucherentry b ,t_gl_voucherassistrecord c, \t\t\r\n");
        sql.append("\tt_bd_assistanthg d ,t_bd_accountview e\t,t_bd_settlementtype f,T_NT_NTType g\t\t\t\r\n");
        sql.append(" where a.fid=b.fbillid \t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.fid=c.fentryid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.faccountid=e.fid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and c.fassgrpid=d.fid\tand d.fbankaccountid is not null\t\t\t\t\t\r\n");
        sql.append("  and c.fsettlementtypeid=f.fid\t\t\t\t\t\t\t\t\r\n");
        sql.append("  and f.fnttypeid=g.fid and g.fgroup=1 \t\t\t\t\t\t\t\r\n");
        sql.append(" and a.fsourcetype=0 and e.fisbank=1 and b.fentrydc=0\t\t\r\n");
        sql.append(" and a.fid=?\tgroup by a.fnumber,a.fcompanyid,b.fcurrencyid,c.fsettlementcode,d.fbankaccountid,f.fnttypeid\t\t\t\r\n");
        StringBuffer sqlCheck = new StringBuffer("");
        sqlCheck.append(" select f.fid,f.fstate,f.famount,h.fceiling,f.fpaymentbillnum \t from  \t\t\r\n");
        sqlCheck.append(" t_nt_cheque f,T_NT_NTType g ,T_NT_ChequeAppRec h \t\t\t\t\t\t\t\r\n");
        sqlCheck.append("  where f.fapplyrecid=h.fid and g.fid=f.fnttypeid and g.fgroup=1 \t\t\t\r\n");
        sqlCheck.append(" \tand f.fcompanyid=?\tand f.fbankacctid=?  \t\t\t\t\t\t\t\t\r\n");
        sqlCheck.append(" \tand f.fcurrencyid=?\tand f.fnumber=?\tand g.fid=? \t\t\t\t\t\t\r\n");
        String update = "update t_nt_cheque set fPaymentBillNum=? where fid=? ";
        String updateFalse = "update t_nt_cheque set fPaymentBillNum=null where fid=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        if (set != null) {
            try {
                while (set.next()) {
                    String number = set.getString("fnumber");
                    String comid = set.getString("fcompanyid");
                    String bankAccid = set.getString("fbankaccountid");
                    String curid = set.getString("fcurrencyid");
                    String settlementcode = set.getString("fsettlementcode");
                    String nttype = set.getString("fnttypeid");
                    BigDecimal amount = set.getBigDecimal("famount");
                    if (isSubmit && settlementcode == null) {
                        throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                    }
                    IRowSet checkset = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString(), (Object[])new Object[]{comid, bankAccid, curid, settlementcode, nttype});
                    if (checkset != null && checkset.next()) {
                        String chequeid = checkset.getString("fid");
                        BigDecimal checkamount = checkset.getBigDecimal("famount");
                        BigDecimal ceiling = checkset.getBigDecimal("fceiling");
                        int state = checkset.getInt("fstate");
                        String paymentbillnum = checkset.getString("fpaymentbillnum");
                        if (isSubmit) {
                            if (paymentbillnum != null) {
                                throw new VoucherException(VoucherException.TICKEDHASRELATED);
                            }
                            if (checkamount != null && ChequeStatusEnum.WRITTEN_OFF.getValue() == state && checkamount.compareTo(amount) != 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT2);
                            }
                            if (ceiling != null && ceiling.compareTo(amount) < 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT3);
                            }
                            DbUtil.execute((Context)ctx, (String)update, (Object[])new Object[]{number, chequeid});
                            continue;
                        }
                        DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{chequeid});
                        continue;
                    }
                    if (!isSubmit) continue;
                    throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected String getVoucherTable() {
        return "t_gl_voucher";
    }

    private void invokeVoucherCancelPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherPostProcessorInvokeFactory.invokeVoucherCancelPostProcessor(ctx, voucherInfo);
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_cancelVoucher";
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherCancel", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherCancel", "After");
    }
}

