/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VchAmortSchemeFactory;
import com.kingdee.eas.fi.gl.VchAmortSchemeInfo;
import com.kingdee.eas.fi.gl.VchAmortSchemeStatusEnum;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.DeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DeleteAmortizationVoucherService
extends DeleteVoucherService
implements IDeleteVoucherService {
    public DeleteAmortizationVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    public void deleteVoucher(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        this.deleteAmortLog(ctx, (VoucherInfo)voucherInfo);
        super.deleteVoucher(ctx, voucherInfo, isFromGL);
    }

    public void deleteAmortLog(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        StringBuffer sqlAmortLog = new StringBuffer();
        sqlAmortLog.append(" select vlog.FID,vlog.FAmortSchemeID,vlog.FPeriodID,vs.FAmortAmount,policy.famount FPolicyAmount,v.FbizStatus \r\t");
        sqlAmortLog.append(" from t_gl_vchamortlog vlog inner join t_gl_vchamortscheme vs on vlog.famortschemeid=vs.fid \r\t");
        sqlAmortLog.append(" inner join t_gl_vchamortpolicy policy on policy.famortschemeid = vs.fid and policy.fperiodid=vlog.fperiodid \r\t");
        sqlAmortLog.append(" inner join t_gl_voucher v on v.fid = vlog.fVoucherID  \r\t");
        sqlAmortLog.append(" where vlog.FVoucherID= ? \r\t");
        IRowSet rsAmortLog = DbUtil.executeQuery((Context)ctx, (String)sqlAmortLog.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            while (rsAmortLog.next()) {
                VchAmortSchemeInfo vchAmortSchemeInfo;
                String amortSchemeId = rsAmortLog.getString("FAmortSchemeID");
                String periodId = rsAmortLog.getString("FPeriodID");
                String logId = rsAmortLog.getString("FID");
                BigDecimal amortAmount = rsAmortLog.getBigDecimal("FAmortAmount");
                BigDecimal policyAmount = rsAmortLog.getBigDecimal("FPolicyAmount");
                int vStatus = rsAmortLog.getInt("FbizStatus");
                if (vStatus == 2) {
                    String delLog = "delete from t_gl_vchamortlog where fid=?";
                    DbUtil.execute((Context)ctx, (String)delLog, (Object[])new Object[]{logId});
                    continue;
                }
                BigDecimal leftAmortAmount = amortAmount.subtract(policyAmount);
                String status = "1";
                if (leftAmortAmount.signum() != 0) {
                    status = "2";
                }
                if ((vchAmortSchemeInfo = VchAmortSchemeFactory.getLocalInstance(ctx).getVchAmortSchemeInfo((IObjectPK)new ObjectUuidPK(amortSchemeId))).getStatus() == VchAmortSchemeStatusEnum.Closed) {
                    status = "4";
                }
                String updateScheme = "update t_gl_vchamortscheme set famortamount=?,fstatus=? where fid=?";
                DbUtil.execute((Context)ctx, (String)updateScheme, (Object[])new Object[]{leftAmortAmount, new Integer(status), amortSchemeId});
                String updatePolicy = "update t_gl_vchamortpolicy set fisvouchered=0 where famortschemeid=? and fperiodid=?";
                DbUtil.execute((Context)ctx, (String)updatePolicy, (Object[])new Object[]{amortSchemeId, periodId});
                String delLog = "delete from t_gl_vchamortlog where fid=?";
                DbUtil.execute((Context)ctx, (String)delLog, (Object[])new Object[]{logId});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

