/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.DeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.framework.CoreBaseInfo;

public class DeleteReverseVoucherService
extends DeleteVoucherService
implements IDeleteVoucherService {
    public DeleteReverseVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    public void deleteVoucher(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        super.deleteVoucher(ctx, voucherInfo, isFromGL);
        this.clearReverseRelation(ctx, (VoucherInfo)voucherInfo);
    }

    private void clearReverseRelation(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        BOTRelationCollection relationCol;
        ObjectUuidPK pk = new ObjectUuidPK(voucherInfo.getId().toString());
        String srcVchId = voucherInfo.getSourceBillId();
        if (srcVchId != null) {
            this.removeRelation(ctx, srcVchId, (IObjectPK)pk);
        }
        if ((relationCol = VoucherUtil._getBotRelation(ctx, pk.toString(), voucherInfo.getBOSType())) != null) {
            int n = relationCol.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = relationCol.get(i);
                this.removeRelation(ctx, bot.getSrcObjectID(), (IObjectPK)pk);
            }
        }
    }

    private void removeRelation(Context ctx, String srcVchId, IObjectPK pk) throws BOSException, EASBizException {
        VoucherInfo srcVch = new VoucherInfo();
        BOSUuid id = BOSUuid.read((String)srcVchId);
        srcVch.setId(id);
        if (this.operateSharer.isVoucherExisted(ctx, (BaseVoucherInfo)srcVch)) {
            VoucherInfo reverVch = (VoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(srcVchId), VoucherInfo.getReverseSelector());
            srcVch.setDescription(null);
            String strIndex = "(" + reverVch.getPeriod().getPeriodYear() + "." + reverVch.getPeriod().getPeriodNumber() + ")";
            String des = reverVch.getDescription();
            if (des != null) {
                if (des.indexOf("_") > 0) {
                    if (des.substring(0, des.lastIndexOf("_")).contains(strIndex)) {
                        srcVch.setDescription(des.substring(des.indexOf(strIndex) + strIndex.length() + 1));
                    } else if (des.contains(strIndex)) {
                        String bStr = des.substring(0, des.indexOf(strIndex));
                        String eStr = des.substring(des.indexOf(strIndex));
                        bStr = bStr.substring(bStr.indexOf("_") + 1);
                        eStr = eStr.substring(eStr.indexOf(strIndex) + strIndex.length());
                        srcVch.setDescription(bStr + eStr);
                    } else {
                        srcVch.setDescription(des);
                    }
                } else if (des.indexOf(strIndex) > 0) {
                    srcVch.setDescription(des.substring(des.indexOf(strIndex) + strIndex.length()));
                } else {
                    srcVch.setDescription(des);
                }
            }
            srcVch.setId(id);
            srcVch.setHasReversed(false);
            VoucherUtil._removeBotRelation(ctx, srcVchId, pk.toString(), srcVch.getBOSType());
            this.iVoucher.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)srcVch);
        }
    }
}

