/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistory;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.DeleteBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fi.gl.validator.VoucherBaseDeleteValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DeleteVoucherService
extends DeleteBaseVoucherService {
    private VoucherValidator validator = null;

    public DeleteVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected void beforeDelete(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException, GLException {
        this.checkAsstAccountChange(ctx, voucherInfo);
        if (voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            this.returnBudget(ctx, voucherInfo);
            this.clearReqRelation(ctx, voucherInfo, this.sysParam);
        }
        this.clearactAcctcussent(ctx, voucherInfo, this.sysParam);
        this.updateAcctCussentBalance(ctx, voucherInfo, this.sysParam, true);
        this.deleteVerfiyRecordInTimeVerify(ctx, voucherInfo, this.sysParam);
        this.deleteDiffItemRecord(ctx, voucherInfo, this.sysParam);
    }

    @Override
    protected void afterDelete(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException, GLException {
        this.deleteBksVoucherMessage(ctx, voucherInfo, this.sysParam);
        this.deleteAdjustExchangeRateHistory(ctx, voucherInfo);
        this.deleteAutoTransVoucherRef(ctx, voucherInfo);
        this.deleteTransPLHistory(ctx, voucherInfo);
        this.deleteImportKey(ctx, voucherInfo);
        this.deleteFileVoucher(ctx, voucherInfo);
        this.deleteComparisonDetail(ctx, voucherInfo);
    }

    private void deleteComparisonDetail(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        GlUtils.deleteComparisonDetailById(ctx, voucherInfo.getId().toString());
    }

    private void deleteFileVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        boolean isFiled = false;
        StringBuffer sb = new StringBuffer();
        sb.append("select filed from T_GL_FileVoucher where fvoucherid = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            while (rs.next()) {
                if (!rs.getBoolean("filed")) continue;
                isFiled = true;
                break;
            }
            if (isFiled) {
                throw new VoucherException(VoucherException.VOUCHER_IS_FILED);
            }
            sb = new StringBuffer();
            sb.append("delete T_GL_FileVoucher where fvoucherid = ?");
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_remove";
    }

    @Override
    protected void validate(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        this.initVoucherValidator(ctx, voucherInfo, isFromGL);
        this.validateVoucher(ctx, voucherInfo);
    }

    protected void initVoucherValidator(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam, isFromGL);
        if (this.validator == null) {
            this.validator = new VoucherValidator();
        }
        VoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        VoucherValidatorFactory.getVoucherValidator(ctx, this.getClass().getName(), this.validator);
    }

    protected VoucherValidator getAdditionalValidator() throws BOSException {
        return null;
    }

    private VoucherValidator getValidator(GlParam sysParam, boolean isFromGL) throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBaseDeleteValidator(sysParam, isFromGL));
        return validator;
    }

    protected void validateVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.validator != null) {
            this.validator.validate(ctx, (VoucherInfo)voucherInfo);
        }
    }

    @Override
    protected void recycleVoucherNumber(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, voucherInfo.getBizStatus())) {
            this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
        }
    }

    protected void updateAcctCussentBalance(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, boolean isUnpost) throws EASBizException, BOSException {
        boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
        boolean allowCussent = sysParam.getBoolean("GL_028");
        boolean updateAcct = false;
        if (allowCussent && voucherInfo.isIsAC() && voucherInfo.getId() != null && isInTimeVerify) {
            updateAcct = true;
        }
        if (updateAcct && voucherInfo.getBizStatus() == VoucherStatusEnum.SUBMITTED) {
            VoucherOprateSharer.updateAcctCussentUnHoldedBalance(ctx, voucherInfo.getId().toString(), isUnpost);
        }
    }

    protected void deleteVerfiyRecordInTimeVerify(Context ctx, BaseVoucherInfo baseVoucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean isInTimeVerify;
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (isInTimeVerify) {
            try {
                if (baseVoucherInfo.isIsReverseVoucher()) {
                    String sql = "delete t_gl_acctcussenthistory where FCussVchID = ? or FVeriVchID = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{baseVoucherInfo.getId().toString(), baseVoucherInfo.getId().toString()});
                } else {
                    VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
                    for (int i = 0; i < voucherEntryCollection.size(); ++i) {
                        VoucherEntryInfo voucherEntryInfo = voucherEntryCollection.get(i);
                        String entryId = voucherEntryInfo.getId().toString();
                        List AssistRecordList = this.getAssistRecordByEntryId(ctx, entryId);
                        for (String AssistRecordID : AssistRecordList) {
                            IAcctCussentHistory iAcctCussentHistory = AcctCussentHistoryFactory.getLocalInstance(ctx);
                            iAcctCussentHistory.deleteAcctCussHistory(AssistRecordID);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private List getAssistRecordByEntryId(Context ctx, String entryId) throws BOSException, SQLException {
        ArrayList<String> assistAssistRecoreList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("select Assist.FID as assistID ");
        sql.append("\r\n from  ");
        sql.append("\r\n T_GL_VoucherAssistRecord Assist ");
        StringBuffer whereSql = new StringBuffer("\r\n  where");
        StringBuffer causeSQL = new StringBuffer();
        StringBuffer groupBySQL = new StringBuffer();
        causeSQL.append(" \r\n Assist.FEntryID=?");
        sql.append(whereSql).append(causeSQL).append(groupBySQL);
        Object[] params = new Object[]{entryId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        while (rs.next()) {
            assistAssistRecoreList.add(rs.getString("assistID"));
        }
        return assistAssistRecoreList;
    }

    @Override
    protected void delete(Context ctx, BaseVoucherInfo baseVoucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.clearCFRequisition(ctx, (BaseVoucherInfo)voucherInfo);
        VoucherUtil._deleteAllCashflowRecords(ctx, voucherInfo);
        VoucherUtil._deleteAllCashflowSplitRecords(ctx, voucherInfo);
        VoucherUtil._deleteAllAssistRecords(ctx, voucherInfo);
        VoucherUtil._deleteAllEntries(ctx, voucherInfo);
        VoucherUtil._deleteVoucher(ctx, voucherInfo);
        if (voucherInfo.getId() != null) {
            BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(voucherInfo.getId().toString());
        }
    }

    @Override
    protected void undoTransformFromVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (!SourceType.OTHER_ACCOUNT.equals((Object)voucherInfo.getSourceType()) || voucherInfo.getSourceBillId() != null) {
            IDAPTransformer iDAPTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            iDAPTransformer.undoTransformFromVoucher((BaseVoucherInfo)voucherInfo);
        }
    }

    @Override
    protected void insertVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (voucherInfo.getBizStatus().equals((Object)VoucherStatusEnum.SUBMITTED)) {
            this.operateSharer.insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 7, true, false);
        }
    }

    @Override
    protected void invokeVoucherDeletePostProcessor(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        VoucherPostProcessorInvokeFactory.invokeVoucherDeletePostProcessor(ctx, voucherInfo);
    }

    private void clearReqRelation(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        boolean useAC = sysParam.getBoolean("GLG01");
        if (useAC) {
            IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance(ctx);
            reqCtrl.clearReqRelation("'" + voucherInfo.getId().toString() + "'", true);
        }
    }

    private void clearactAcctcussent(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws GLException, BOSException {
        if (voucherInfo.getId() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
            sql.setLength(0);
            sql.append("delete from t_gl_acctverify where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void clearCFRequisition(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance(ctx);
        iCFReq.clearRequisition((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
    }

    private void deleteBksVoucherMessage(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean canModifyVoucherFromMain = sysParam.getBoolean("GL015");
        if (!BooksUtil.isMasterBook((Context)ctx) && voucherInfo.isIsAccountCopy()) {
            String sql = "delete  from T_BKS_VoucherMessage where FTagVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    private void deleteImportKey(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        String sql = "delete from T_GL_VoucherImportKey where FVoucherID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    protected void deleteDiffItemRecord(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        String sql = "delete from T_GL_DiffItemRecord where FVoucherID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{voucherInfo.getId().toString()});
    }

    protected void checkAsstAccountChange(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException {
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"act_change_delete", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherDelete", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherDelete", "After");
    }
}

