/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.voucher.AbstractPostBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fi.gl.validator.VoucherBasePostValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PostStandardVoucherService
extends AbstractPostBaseVoucherService {
    protected VoucherValidator validator = null;

    public PostStandardVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected void post(Context ctx, BaseVoucherInfo baseVoucherInfo, GlParam sysParam, Map checkViews) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.createAcctCussent(ctx, voucherInfo, sysParam);
        this.clearAcNotice(ctx, voucherInfo, sysParam);
        this.updateAcctCussentBalance(ctx, voucherInfo, sysParam, false);
        this.sendAcNotice(ctx, voucherInfo, checkViews, sysParam);
    }

    private void createAcctCussent(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        boolean isInTimeVerify;
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return;
        }
        boolean allowCussent = sysParam.getBoolean("GL_028");
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (allowCussent && voucherInfo.isIsAC()) {
            if (isInTimeVerify) {
                if (!voucherInfo.isIsReverseVoucher()) {
                    AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertCussent(voucherInfo.getId().toString());
                }
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertVerify(voucherInfo.getId().toString(), true);
            }
            AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).updateCussents(voucherInfo.getId().toString(), 1);
        }
    }

    private void clearAcNotice(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean sendNoticeOnPost;
        boolean useACNotice = sysParam.getBoolean("GLG01");
        boolean bl = sendNoticeOnPost = sysParam.getInt("GLG01_2") == 1;
        if (useACNotice && sendNoticeOnPost) {
            IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance(ctx);
            reqCtrl.clearReqRelation("'" + voucherInfo.getId().toString() + "'", false);
        }
    }

    private void updateAcctCussentBalance(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, boolean isPositiveSign) throws EASBizException, BOSException {
        boolean isInTimeVerify;
        boolean allowCussent = sysParam.getBoolean("GL_028");
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (allowCussent && voucherInfo.isIsAC() && voucherInfo.getId() != null && isInTimeVerify) {
            VoucherOprateSharer.updateAcctCussentUnVerifiedBalance(ctx, voucherInfo.getId().toString(), isPositiveSign);
        }
    }

    private void sendAcNotice(Context ctx, VoucherInfo voucherInfo, Map checkViews, GlParam sysParam) throws BOSException, EASBizException {
        boolean sendNoticeOnPost;
        boolean useACNotice = sysParam.getBoolean("GLG01");
        boolean bl = sendNoticeOnPost = sysParam.getInt("GLG01_2") == 1;
        if (useACNotice && sendNoticeOnPost && voucherInfo.isIsACNotice()) {
            String companyId = voucherInfo.getCompany().getId().toString();
            AcNoticeUtil.checkAndRepairReqCheckStatus(ctx, voucherInfo.getId().toString());
            IRowSet rs = AcNoticeUtil.getAcNoticeData(ctx, companyId, voucherInfo.getId().toString());
            if (checkViews != null) {
                Object o = checkViews.get("checkview.source");
                if (o != null && o instanceof Collection) {
                    Collection srcVCH = (Collection)o;
                    Collection srcACNotice = AcNoticeUtil.sendACNotice(ctx, rs, companyId, srcVCH, false);
                    if (srcACNotice != null) {
                        checkViews.put("checkview.source", srcACNotice);
                        IRequisitionCheck iRequisitionCheck = RequisitionCheckFactory.getLocalInstance(ctx);
                        iRequisitionCheck.check(checkViews);
                    }
                } else {
                    if (checkViews.get("requisition.id") != null) {
                        ctx.put((Object)"requisition.id", checkViews.get("requisition.id"));
                    }
                    AcNoticeUtil.sendACNotice(ctx, rs, companyId, null, true);
                }
            } else {
                AcNoticeUtil.sendACNotice(ctx, rs, companyId, null, false);
            }
        }
    }

    @Override
    protected void invokeVoucherPostPostProcessor(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherPostProcessorInvokeFactory.invokeVoucherPostPostProcessor(ctx, (VoucherInfo)voucherInfo);
    }

    private VoucherValidator getValidator(GlParam sysParam) throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBasePostValidator(sysParam));
        return validator;
    }

    @Override
    protected void initVoucherValidator(Context ctx) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam);
        if (this.validator == null) {
            this.validator = new VoucherValidator();
        }
        VoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        VoucherValidatorFactory.getVoucherValidator(ctx, this.getClass().getName(), this.validator);
    }

    @Override
    protected void validatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.validator != null) {
            this.validator.validate(ctx, (VoucherInfo)voucherInfo);
        }
    }

    @Override
    protected void updateVoucherPostedStatus(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("Update t_GL_Voucher                                      \r\n");
        sqlUpdate.append("Set FBizStatus = 5 ,FPosterID = ?, FLastUpdateTime = ?   \r\n");
        sqlUpdate.append("Where FCompanyID = ? and FBizStatus =3 and fid = ? ");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])new Object[]{user.getId().toString(), GlUtils.getTime(), voucherInfo.getCompany().getId().toString(), voucherInfo.getId().toString()});
    }

    protected VoucherValidator getAdditionalValidator() throws BOSException {
        return null;
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherPost", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherPost", "After");
    }
}

