/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractTransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.TransactVoucherColParameter;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PostVoucherCollectionService
extends AbstractTransactVoucherColService {
    @Override
    protected void beforeTransactVoucherNewTrans(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void catchTransactException(Context ctx, VoucherInfo voucherInfo, String oldNumber, Exception ex) {
        String oldVchType = voucherInfo.getVoucherType() == null ? "" : (voucherInfo.getVoucherType().getName() == null ? "" : voucherInfo.getVoucherType().getName());
        this.commonErrors.put(voucherInfo.getId().toString(), voucherInfo.getCompany().getName() + " " + oldVchType + oldNumber + " " + ex.getMessage());
    }

    @Override
    protected EntityViewInfo getEntityView(Set idSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(VoucherInfo.getPostVoucherSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection soter = new SorterItemCollection();
        soter.add(new SorterItemInfo("number"));
        view.setSorter(soter);
        return view;
    }

    @Override
    protected void machiningVoucherCollection(Context ctx, Set idSet, VoucherCollection voucherCollection) throws BOSException, EASBizException {
        this.matchVoucherStatus(ctx, idSet, voucherCollection);
        this.checkInitState(ctx, idSet, voucherCollection);
    }

    private void checkInitState(Context ctx, Set idSet, VoucherCollection voucherCollection) throws EASBizException, BOSException {
        if (idSet.size() == 0) {
            return;
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
            int size = voucherCollection.size();
            for (int i = 0; i < size; ++i) {
                VoucherInfo vch = voucherCollection.get(i);
                CompanyOrgUnitInfo company = vch.getCompany();
                String companyID = company.getId().toString();
                if (companyMap.get(companyID) != null) continue;
                companyMap.put(companyID, company);
            }
            Iterator iter = companyMap.keySet().iterator();
            while (iter.hasNext()) {
                String companyID = iter.next().toString();
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyMap.get(companyID);
                boolean isGlSystemStarted = VoucherProcessCache.isCloseInited(ctx, company);
                if (!isGlSystemStarted) {
                    VoucherProcessCache.isAccountInited(ctx, company);
                }
                if (isGlSystemStarted) continue;
                cache.setAssistInitStateMap(this.checkAssistInited(ctx, idSet, companyID));
                GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_028"}, (String)companyID);
                if (!glParam.getBoolean("GL_028")) continue;
                cache.setCussentInitStateMap(this.checkCussentInited(ctx, idSet, companyID));
            }
        }
    }

    @Override
    String getPermItemName() {
        return "gl_voucher092_post";
    }

    @Override
    protected void transactVoucherNewTrans(Context ctx, TransactVoucherColParameter parameterObject, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(voucherInfo.getId().toString());
        Map checkViews = parameterObject.getCheckViews();
        if (SourceType.ACCOUNTADJUST.equals((Object)voucherInfo.getSourceType()) || SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            VoucherFactory.getLocalInstance((Context)ctx).post((IObjectPK)pk, checkViews);
        } else {
            this.getVoucherServiceFacade(ctx).postVoucherNewTrans((IObjectPK)pk, checkViews);
        }
    }

    private void matchVoucherStatus(Context ctx, Set idSet, VoucherCollection voucherCollection) {
        for (int i = voucherCollection.size() - 1; i >= 0; --i) {
            VoucherInfo voucherInfo = voucherCollection.get(i);
            if (VoucherStatusEnum.AUDITTED.equals((Object)voucherInfo.getBizStatus())) continue;
            if (idSet.contains(voucherInfo.getId().toString())) {
                idSet.remove(voucherInfo.getId().toString());
            }
            voucherCollection.removeObject(i);
        }
    }

    private boolean isAccountInited(Context ctx, CompanyOrgUnitInfo curCompany) throws EASBizException, BOSException {
        return VoucherUtil.isAccountInited(ctx, curCompany.getId().toString());
    }

    private Map checkAssistInited(Context ctx, Set idSet, String companyId) throws EASBizException, BOSException {
        return VoucherUtil.checkAssitInited(ctx, this.idSetToList(idSet), companyId);
    }

    private Map checkCussentInited(Context ctx, Set idSet, String companyId) throws EASBizException, BOSException {
        return VoucherUtil.checkCussentInited(ctx, this.idSetToList(idSet), companyId);
    }

    private String idSetToList(Set idSet) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(it.next()).append("'");
        }
        return ids.toString();
    }

    @Override
    protected VoucherException getVoucherException(String errMsg) {
        return new VoucherException(VoucherException.POST_FAIL, new Object[]{errMsg});
    }

    @Override
    protected void batchVoucherCollection(TransactVoucherColParameter parameterObject) throws BOSException, EASBizException {
        if (parameterObject.getCtx() == null || parameterObject.getIdSet() == null) {
            return;
        }
        Context ctx = parameterObject.getCtx();
        IVoucher iVoucher = this.getVoucherService(ctx);
        VoucherCollection allVoucherColl = iVoucher.getVoucherCollection(this.getEntityView(parameterObject.getIdSet()));
        VoucherCollection hasPermissionVoucherColl = this.getHasPermissionVoucherCollection(ctx, allVoucherColl);
        this.machiningVoucherCollection(ctx, parameterObject.getIdSet(), hasPermissionVoucherColl);
        VoucherInfo voucherInfo = null;
        Iterator idIter = allVoucherColl.iterator();
        while (idIter.hasNext()) {
            String voucherid = ((VoucherInfo)idIter.next()).getId().toString();
            voucherInfo = hasPermissionVoucherColl.get((Object)BOSUuid.read((String)voucherid));
            String oldNumber = "";
            try {
                if (voucherInfo == null) {
                    voucherInfo = allVoucherColl.get((Object)BOSUuid.read((String)voucherid));
                    if (!iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherid))) continue;
                    if (voucherInfo.getBizStatus().getValue() != 3) {
                        oldNumber = voucherInfo.getNumber();
                        throw new VoucherException(VoucherException.VCH_CAN_NOT_POST);
                    }
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getPermItemName());
                    Object[] object = new Object[]{voucherInfo.getCompany().getName(), permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_DATA_PERMISSION, object);
                    throw pe;
                }
                oldNumber = voucherInfo.getNumber();
                this.beforeTransactVoucherNewTrans(ctx, voucherInfo);
                this.checkPermission(ctx, voucherInfo);
                this.disablePermission();
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                this.transactVoucherNewTrans(ctx, parameterObject, voucherInfo);
            }
            catch (Exception e) {
                log.error((Object)"ERROR", (Throwable)e);
                if (voucherInfo != null && SourceType.ACCOUNTADJUST.equals((Object)voucherInfo.getSourceType()) && voucherInfo.getPeriod() != null && voucherInfo.getPeriod().getPeriodNumber() == 13) {
                    throw e;
                }
                if (e instanceof PermissionException) {
                    this.noPermErrors.put(voucherid, e.getMessage());
                    continue;
                }
                this.catchTransactException(ctx, voucherInfo, oldNumber, e);
            }
        }
    }

    @Override
    public String getMutexActionResName() {
        return "GL_VoucherPost";
    }
}

