/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.app.voucher.PreViewBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherPersistence;
import com.kingdee.eas.fi.gl.validator.VoucherBaseSaveValidator;
import com.kingdee.eas.fi.gl.validator.VoucherEntrySaveValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorFactory;
import java.util.HashMap;
import java.util.Iterator;

public class PreViewVoucherService
extends PreViewBaseVoucherService {
    public PreViewVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IVoucherPersistence getVoucherPersistence() throws BOSException {
        return new VoucherPersistence(this.sysParam);
    }

    @Override
    protected boolean exist(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return GlUtils.isExisted(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected boolean numberValid(Context ctx, BaseVoucherInfo voucherInfo, boolean isHandNumber) throws EASBizException, BOSException {
        return GlUtils.chechNumberValid((VoucherInfo)voucherInfo, VoucherStatusEnum.TEMP, ctx, isHandNumber);
    }

    @Override
    protected boolean existCodingRule(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        return VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, voucherInfo.getBizStatus());
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected void loadProperties(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo vchInfo = (VoucherInfo)voucherInfo;
        if (!vchInfo.isPostedByUI()) {
            VoucherUtil.lazyLoad(ctx, vchInfo, BaseVoucherInfo.fullSelector(null), this.sysParam, false);
        } else {
            GlUtils.setVoucherCategory(vchInfo);
            VoucherUtil.computeVoucherAttribute(vchInfo, this.sysParam, false, false, ctx);
        }
    }

    @Override
    protected void validate(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo old;
        VoucherValidator vaildator = this.getValidator();
        if (vaildator != null) {
            VoucherValidatorFactory.getVoucherValidator(ctx, this.getClass().getName(), vaildator);
            vaildator.validate(ctx, (VoucherInfo)voucherInfo);
        }
        if (SourceType.AUTO_AMORTIZE.equals((Object)voucherInfo.getSourceType()) && this.exist(ctx, voucherInfo) && ((old = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()))).getLocalCreditAmount().compareTo(voucherInfo.getLocalCreditAmount()) != 0 || old.getLocalDebitAmount().compareTo(voucherInfo.getLocalDebitAmount()) != 0)) {
            throw new VoucherException(VoucherException.AMORTZIEVOUCHERAMOUNTFIXED);
        }
    }

    protected VoucherValidator getValidator() throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBaseSaveValidator(this.sysParam));
        validator.addVoucherEntryValidator(new VoucherEntrySaveValidator(this.sysParam));
        return validator;
    }

    @Override
    protected void dealSaveCashflow(Context ctx, IObjectPK voucherPK, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getSourceType() == SourceType.ACCOUNTADJUST) {
            return;
        }
        CashflowRecordCollection cashflowRecordColl = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        if (cashflowRecordColl == null || cashflowRecordColl.size() == 0) {
            return;
        }
        VoucherEntryCollection entryColl = (VoucherEntryCollection)voucherInfo.getEntries();
        if (entryColl == null) {
            return;
        }
        HashMap<BOSUuid, VoucherEntryInfo> voucherEntryMap = new HashMap<BOSUuid, VoucherEntryInfo>();
        Iterator itEntry = entryColl.iterator();
        VoucherEntryInfo voucherEntryInfo = null;
        while (itEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)itEntry.next();
            voucherEntryMap.put(voucherEntryInfo.getId(), voucherEntryInfo);
        }
        Iterator iteratorCF = cashflowRecordColl.iterator();
        boolean hasPrimaryRecord = false;
        while (iteratorCF.hasNext()) {
            CashflowRecordInfo cashflowRecordInfo = (CashflowRecordInfo)iteratorCF.next();
            if (cashflowRecordInfo.getEntry() == null || cashflowRecordInfo.getEntry().getId() == null || cashflowRecordInfo.getOpposingAccountEntry() == null || cashflowRecordInfo.getOpposingAccountEntry().getId() == null) {
                iteratorCF.remove();
                continue;
            }
            if (voucherEntryMap.containsKey(cashflowRecordInfo.getEntry().getId()) && voucherEntryMap.containsKey(cashflowRecordInfo.getOpposingAccountEntry().getId())) continue;
            iteratorCF.remove();
        }
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }
}

