/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.SubmitStandradVoucherService;
import com.kingdee.eas.fi.gl.validator.ReverseVoucherBaseSubmitValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Locale;

public class SubmitReverseVoucherService
extends SubmitStandradVoucherService {
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";
    public static final String VOUCHER_EXISTS = "voucherExists";

    public SubmitReverseVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IObjectPK submit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        IObjectPK pk = super.submit(ctx, voucherInfo);
        this.updateSrcVoucher(ctx, voucherInfo);
        if (voucherInfo.getId() == null) {
            this.saveReverseRelation(ctx, (VoucherInfo)voucherInfo);
        }
        return pk;
    }

    protected void updateSrcVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        BaseVoucherInfo srcVch = voucherInfo.getSrcVoucherInfo();
        boolean voucherExists = (Boolean)voucherInfo.get(VOUCHER_EXISTS);
        String des = srcVch.getDescription();
        if (null == des || des.length() == 0 || !voucherExists || voucherInfo.get("old_bizStatus") != null && ((VoucherStatusEnum)voucherInfo.get("old_bizStatus")).getValue() == 0) {
            String select = ResourceBase.getString((String)resource, (String)"HASREVERSED", (Locale)ctx.getLocale());
            select = select + "(" + srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber() + ")";
            if (des != null) {
                select = select + "_" + des;
            }
            srcVch.setDescription(srcVch.getNumber() + select);
            if (srcVch.getDescription().length() > 255) {
                srcVch.setDescription(srcVch.getDescription().substring(0, 255));
            }
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            iVoucher.update((IObjectPK)new ObjectUuidPK(srcVch.getId()), (CoreBaseInfo)srcVch);
        } else {
            DbUtil.execute((Context)ctx, (String)"update t_gl_voucher set FHasReversed = ? where fid = ?", (Object[])new Object[]{srcVch.isHasReversed(), srcVch.getId().toString()});
        }
    }

    private void saveReverseRelation(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        VoucherUtil.saveBOTRelationInfo(ctx, voucherInfo.getSrcVoucherInfo().getId().toString(), (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), voucherInfo.getBOSType());
    }

    @Override
    protected VoucherValidator getAdditionalValidator() {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new ReverseVoucherBaseSubmitValidator());
        return validator;
    }
}

