/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryCollection;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryFactory;
import com.kingdee.eas.fi.gl.AdjExchRateHistoryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.DiffItemRecordCollection;
import com.kingdee.eas.fi.gl.DiffItemRecordFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAdjExchRateHistory;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherNumberOperator;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherEntryAutoBalance;
import com.kingdee.eas.fi.gl.app.VoucherHelpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractSubmitBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.app.voucher.SubmitVoucherServiceHelper;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherPersistence;
import com.kingdee.eas.fi.gl.validator.VoucherAssistRecordSubmitValidator;
import com.kingdee.eas.fi.gl.validator.VoucherBaseSubmitProfitCenterBalanceValidator;
import com.kingdee.eas.fi.gl.validator.VoucherBaseSubmitValidator;
import com.kingdee.eas.fi.gl.validator.VoucherEntrySubmitValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SubmitStandradVoucherService
extends AbstractSubmitBaseVoucherService {
    protected static final Logger logger = Logger.getLogger(SubmitStandradVoucherService.class);
    private VoucherValidator validator = null;
    private String oldNumber = null;
    private String oldTypeName = null;
    private String oldPeriodId = null;
    protected SubmitVoucherServiceHelper helper = new SubmitVoucherServiceHelper();

    public SubmitStandradVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    public IObjectPK submitVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return super.submitVoucher(ctx, voucherInfo);
    }

    @Override
    protected boolean exist(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return GlUtils.isExisted(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected void initVoucherValidator(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam);
        if (this.validator == null) {
            this.validator = new VoucherValidator();
        }
        VoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        VoucherValidatorFactory.getVoucherValidator(ctx, this.getClass().getName(), this.validator);
    }

    @Override
    protected void transactExistVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.setVchPropFromExistVch(ctx, voucherInfo);
        this.updateVchAcctCussentBalance(ctx, voucherInfo, this.sysParam);
        this.clearAuditBack(ctx, voucherInfo, this.sysParam);
        this.operateSharer.loadCashflowRecord(ctx, (BaseVoucherInfo)voucherInfo);
        this.clearAcNotice(ctx, voucherInfo, this.sysParam);
        this.clearCashflow(ctx, voucherInfo, this.sysParam);
    }

    @Override
    protected void afterValidatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        this.clearAcctCussent(ctx, voucherInfo, this.sysParam);
        this.delBookDatePeriod(ctx, voucherInfo);
    }

    private void delBookDatePeriod(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        Date date = voucherInfo.getBookedDate();
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        PeriodCollection col = PeriodTransFacadeFactory.getLocalInstance(ctx).fetchPeriod(company.getAccountPeriodType().getId().toString(), date);
        if (col.size() == 0) {
            throw new VoucherException(VoucherException.BOOKEDDATENOTPERIOD);
        }
        for (PeriodInfo period : col) {
            if (!period.get("id").equals(voucherInfo.getPeriod().get("id"))) continue;
            return;
        }
        voucherInfo.setPeriod(col.get(0));
    }

    @Override
    protected IObjectPK submit(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        String srcVchId;
        this.handleSubmitVoucherNumber(ctx, (VoucherInfo)voucherInfo, this.sysParam);
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        IObjectPK voucherPK = this.saveVoucher(ctx, voucherInfo, this.sysParam);
        if (voucherInfo instanceof VoucherInfo) {
            VoucherCollection col = new VoucherCollection();
            col.add((VoucherInfo)voucherInfo);
            VoucherHelpFacadeControllerBean.botpRewriteStatic(ctx, col);
        }
        if ((srcVchId = voucherInfo.getSourceBillId()) != null && (voucherInfo.isIsReverseVoucher() || SourceType.ADJUST.equals((Object)voucherInfo.getSourceType()))) {
            VoucherUtil.saveBOTRelationInfo(ctx, srcVchId, voucherPK, voucherInfo.getBOSType());
        }
        return voucherPK;
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_submit";
    }

    @Override
    protected void dealAfterSubmit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        ObjectUuidPK voucherPK = new ObjectUuidPK(voucherInfo.getId().toString());
        this.checkAmountBalance(ctx, (IObjectPK)voucherPK, this.sysParam);
        this.dealAcctCussentBalance(ctx, voucherInfo, this.sysParam);
        this.sendReqRelation(ctx, voucherInfo, this.sysParam);
        this.dealSubmitCashflow(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), voucherInfo, this.sysParam);
        this.saveDiffItemRecord(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), voucherInfo);
        if (!voucherInfo.isFromSaveSubmit() && voucherInfo.isIsACNotice()) {
            this.handleACNoticeAfterSubmit(ctx, voucherInfo, this.oldNumber, this.oldTypeName, this.oldPeriodId, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
        this.updateAdjustRateHistory(ctx, voucherInfo);
        this.dealAcctCussent(ctx, voucherInfo, this.sysParam);
        this.invokeVoucherSubmitPostProcessor(ctx, voucherInfo);
        VoucherOprateSharer.requestBudgetSubstract(ctx, voucherInfo, this.sysParam, 2);
    }

    private void updateAdjustRateHistory(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType())) {
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("account.id"));
            selector.add(new SelectorItemInfo("account.caa"));
            selector.add(new SelectorItemInfo("assistHG.id"));
            selector.add(new SelectorItemInfo("currency.id"));
            selector.add(new SelectorItemInfo("balanceBefore"));
            selector.add(new SelectorItemInfo("AdjExchRateType"));
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherInfo.getId().toString()));
            IAdjExchRateHistory adjHisInstance = AdjExchRateHistoryFactory.getLocalInstance(ctx);
            AdjExchRateHistoryCollection coll = adjHisInstance.getAdjExchRateHistoryCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null));
            VoucherEntryCollection voucherEntryColl = voucherInfo.getEntries();
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                AdjExchRateHistoryInfo adjInfo = coll.get(i);
                for (int k = 0; k < voucherEntryColl.size(); ++k) {
                    VoucherEntryInfo voucherEntryInfo = voucherEntryColl.get(k);
                    if (!adjInfo.getAccount().getId().toString().equals(voucherEntryInfo.getAccount().getId().toString()) || !adjInfo.getCurrency().getId().toString().equals(voucherEntryInfo.getCurrency().getId().toString())) continue;
                    if (adjInfo.getAdjExchRateType().getValue() == 1) {
                        adjInfo.setExchRateAfter(voucherEntryInfo.getLocalExchangeRate());
                    } else {
                        adjInfo.setExchRateAfter(voucherEntryInfo.getReportingExchangeRate());
                    }
                    if (adjInfo.getAccount().getCAA() != null && voucherEntryInfo.getAccount().getCAA() != null) {
                        VoucherAssistRecordCollection var = voucherEntryInfo.getAssistRecords();
                        int size = var.size();
                        for (int p = 0; p < size; ++p) {
                            VoucherAssistRecordInfo varInfo = var.get(p);
                            if (!adjInfo.getAssistHG().getId().toString().equals(varInfo.getAssGrp().getId().toString())) continue;
                            if (adjInfo.getAdjExchRateType().getValue() == 1) {
                                adjInfo.setBalanceAdjust(varInfo.getLocalAmount());
                            } else {
                                adjInfo.setBalanceAdjust(varInfo.getReportingAmount());
                            }
                            if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                                if (adjInfo.getAdjExchRateType().getValue() == 1) {
                                    adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(varInfo.getLocalAmount()));
                                    continue;
                                }
                                adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(varInfo.getReportingAmount()));
                                continue;
                            }
                            if (adjInfo.getAdjExchRateType().getValue() == 1) {
                                adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(varInfo.getLocalAmount()));
                                continue;
                            }
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(varInfo.getReportingAmount()));
                        }
                    } else {
                        adjInfo.setBalanceAdjust(voucherEntryInfo.getLocalAmount());
                        if (voucherEntryInfo.getEntryDC().getValue() == 1) {
                            if (adjInfo.getAdjExchRateType().getValue() == 1) {
                                adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(voucherEntryInfo.getLocalAmount()));
                            } else {
                                adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().add(voucherEntryInfo.getReportingAmount()));
                            }
                        } else if (adjInfo.getAdjExchRateType().getValue() == 1) {
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(voucherEntryInfo.getLocalAmount()));
                        } else {
                            adjInfo.setBalanceAfter(adjInfo.getBalanceBefore().subtract(voucherEntryInfo.getReportingAmount()));
                        }
                    }
                    adjHisInstance.update((IObjectPK)new ObjectUuidPK(adjInfo.getId()), (CoreBaseInfo)adjInfo);
                }
            }
        }
    }

    private void checkNumberRepeated(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.operateSharer.checkNumber(ctx, (BaseVoucherInfo)voucherInfo, voucherInfo.getNumber());
    }

    private void invokeVoucherSubmitPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherPostProcessorInvokeFactory.invokeVoucherSubmitPostProcessor(ctx, voucherInfo);
    }

    private IObjectPK saveVoucher(Context ctx, BaseVoucherInfo voucherInfo, GlParam glParam) throws EASBizException, BOSException {
        return this.getVoucherPersistence(this.sysParam).persistVoucher(ctx, voucherInfo);
    }

    @Override
    protected void validatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (this.validator != null) {
            this.validator.validate(ctx, (VoucherInfo)voucherInfo);
        }
    }

    private void setVchPropFromExistVch(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean handleACNotice;
        boolean bl = handleACNotice = !voucherInfo.isFromSaveSubmit() && voucherInfo.isIsACNotice();
        if (handleACNotice) {
            VoucherInfo vch = (VoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), VoucherInfo.getNumberTypePeriodSelector());
            this.oldNumber = vch.getNumber();
            this.oldTypeName = vch.getVoucherType().getName(ctx.getLocale());
            this.oldPeriodId = vch.getPeriod().getId().toString();
        }
        if (VoucherStatusEnum.TEMP == voucherInfo.getBizStatus()) {
            voucherInfo.setFromSaveSubmit(VoucherStatusEnum.TEMP == voucherInfo.getBizStatus());
        }
    }

    private void clearAcctCussent(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        this.helper.clearAcctCussent(ctx, voucherInfo, sysParam);
    }

    private void updateVchAcctCussentBalance(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean updateAcct = this.isUpdateAcct(voucherInfo, sysParam);
        if (updateAcct && this.checkHasAcctBal(ctx, voucherInfo)) {
            VoucherOprateSharer.updateAcctCussentUnHoldedBalance(ctx, voucherInfo.getId().toString(), true);
        }
    }

    private void clearAuditBack(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherInfo.setIsAuditBack(false);
    }

    private void clearAcNotice(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        if (voucherInfo == null) {
            return;
        }
        boolean useACNotice = sysParam.getBoolean("GLG01");
        if (useACNotice) {
            boolean isNoticeBySubmit;
            boolean bl = isNoticeBySubmit = sysParam.getInt("GLG01_2") == 2;
            if (!isNoticeBySubmit && !voucherInfo.isFromSaveSubmit()) {
                AcNoticeUtil.clearAcNotice(ctx, voucherInfo.getId().toString());
            }
        }
    }

    private void clearCashflow(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        this.helper.clearCashflow(ctx, voucherInfo, sysParam);
    }

    private void handleACNoticeAfterSubmit(Context ctx, VoucherInfo voucherInfo, String oldNumber, String oldTypeName, String oldPeriodId, IObjectPK voucherPK) throws BOSException, EASBizException {
        this.helper.handleACNoticeAfterSubmit(ctx, voucherInfo, oldNumber, oldTypeName, oldPeriodId, voucherPK);
    }

    protected IVoucherPersistence getVoucherPersistence(GlParam sysParam) throws BOSException {
        return new VoucherPersistence(sysParam);
    }

    private void dealAcctCussentBalance(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean updateAcct = this.isUpdateAcct(voucherInfo, sysParam);
        ObjectUuidPK voucherPK = new ObjectUuidPK(voucherInfo.getId().toString());
        if (updateAcct) {
            if (!voucherInfo.isIsReverseVoucher() || sysParam.getInt("GL_052") == 0) {
                this.checkCussent(ctx, voucherPK.toString(), sysParam);
            }
            VoucherOprateSharer.updateAcctCussentUnHoldedBalance(ctx, voucherPK.toString(), false);
        }
    }

    private void dealAcctCussent(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        this.helper.dealAcctCussent(ctx, voucherInfo, sysParam);
    }

    @Override
    protected void loadVoucherInfoForSubmit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (voucherInfo.get("isAutoBalance") == null) {
            VoucherEntryAutoBalance autoBalance = new VoucherEntryAutoBalance();
            autoBalance.setSysParam(this.sysParam);
            autoBalance.setVoucherInfo(voucherInfo);
            autoBalance.setCtx(ctx);
            autoBalance.autoBalanceVoucherEntry();
        }
        if (!voucherInfo.isPostedByUI()) {
            VoucherUtil.lazyLoad(ctx, voucherInfo, VoucherInfo.getDefaultSelector(), this.sysParam, true);
        } else {
            GlUtils.setVoucherCategory(voucherInfo);
            VoucherUtil.fixAsstAccount(ctx, (BaseVoucherInfo)voucherInfo);
            VoucherUtil.computeVoucherAttribute(voucherInfo, this.sysParam, true, true, ctx);
        }
        if (this.sysParam.getBoolean("GL_100") && voucherInfo.getLocalCreditAmount().equals(voucherInfo.getLocalDebitAmount())) {
            voucherInfo.setNotChanged(false);
        }
        VoucherOprateSharer.computeCashflowFlag(voucherInfo);
        boolean useGovAccSystem = this.sysParam.getBoolean(AccountConstant.GovermentAccountingSystem);
        if (useGovAccSystem) {
            VoucherOprateSharer.computeDiffItemFlag(voucherInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleSubmitVoucherNumber(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException, VoucherException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        VoucherNumberOperator numberOperator = VoucherNumberOperator.build(ctx);
        int MAX_GET_COUNT = numberOperator.getNumberMaxCount((BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
        boolean isHandNumber = sysParam.getBoolean("GL_031");
        if (isHandNumber && voucherInfo.getNumber() != null) {
            boolean isNumberValid = GlUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber);
            if (isNumberValid) {
                boolean isExitCodingRule = VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.SUBMITTED);
                if (isExitCodingRule) {
                    String preViewNumber = VoucherUtil.preViewNumber(ctx, voucherInfo.getCompany().getId().toString(), (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                    if (preViewNumber.equals(voucherInfo.getNumber())) {
                        voucherInfo.setNumber(VoucherUtil.getNextNumber(ctx, voucherInfo.getCompany().getId().toString(), (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                    }
                    if (this.exist(ctx, (BaseVoucherInfo)voucherInfo)) {
                        String oldNumber = voucherInfo.getNumber();
                        BaseVoucherInfo previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), BaseVoucherInfo.getNumberSelector());
                        if (previousVoucher.getNumber() != null && !oldNumber.equals(previousVoucher.getNumber())) {
                            this.operateSharer.recycleVoucherId(ctx, (BaseVoucherInfo)voucherInfo, previousVoucher.getNumber());
                        }
                    }
                }
            } else {
                int count;
                if (GlUtils.isExisted(ctx, voucherInfo)) throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                boolean isExitCodingRule = VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, VoucherStatusEnum.SUBMITTED);
                if (!isExitCodingRule) throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                for (count = 1; !GlUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < MAX_GET_COUNT; ++count) {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                }
                if (count >= MAX_GET_COUNT) {
                    throw new VoucherException(VoucherException.CODING_RULE_SN_OUT);
                }
            }
        } else if (!isHandNumber || voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) {
            if (GlUtils.isExisted(ctx, voucherInfo)) {
                int count;
                this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                for (count = 1; !GlUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < MAX_GET_COUNT; ++count) {
                    voucherInfo.setNumber(null);
                    this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
                }
                if (count >= MAX_GET_COUNT) {
                    throw new VoucherException(VoucherException.CODING_RULE_SN_OUT);
                }
            } else {
                int count;
                voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                for (count = 1; !GlUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, isHandNumber) && count < MAX_GET_COUNT; ++count) {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED));
                }
                if (count >= MAX_GET_COUNT) {
                    throw new VoucherException(VoucherException.CODING_RULE_SN_OUT);
                }
            }
        }
        voucherInfo.setBizStatus(oldStatus);
    }

    private boolean checkHasAcctBal(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        return this.helper.checkHasAcctBal(ctx, voucherInfo);
    }

    protected void checkCussent(Context ctx, String vchID, GlParam sysParam) throws BOSException, EASBizException {
        this.helper.checkCussent(ctx, vchID, sysParam);
    }

    private boolean isUpdateAcct(VoucherInfo voucherInfo, GlParam sysParam) throws GLException, BOSException {
        boolean allowCussent = sysParam.getBoolean("GL_028");
        boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
        boolean updateAcct = false;
        if (allowCussent && isInTimeVerify && !voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT) && !voucherInfo.getSourceType().equals((Object)SourceType.PROFIT_AND_LOSS)) {
            updateAcct = true;
        }
        return updateAcct;
    }

    private void sendReqRelation(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        if (voucherInfo == null) {
            return;
        }
        boolean useACNotice = sysParam.getBoolean("GLG01");
        if (useACNotice) {
            boolean isNoticeBySubmit;
            boolean bl = isNoticeBySubmit = sysParam.getInt("GLG01_2") == 2;
            if (isNoticeBySubmit) {
                boolean disableWorkFlow;
                if (voucherInfo.get("botrelation") != null) {
                    ctx.put((Object)"botrelation", voucherInfo.get("botrelation"));
                }
                boolean bl2 = disableWorkFlow = voucherInfo.get("disable_workflow") != null && (Boolean)voucherInfo.get("disable_workflow") != false;
                if (disableWorkFlow) {
                    WfEventListenerStateManager.getInstance().enableEventListener();
                }
                AcNoticeUtil.dealAcNotice(ctx, null, voucherInfo, voucherInfo.getCompany().getId().toString());
                if (disableWorkFlow) {
                    WfEventListenerStateManager.getInstance().disableEventListener();
                }
            } else if (!voucherInfo.isFromSaveSubmit()) {
                AcNoticeUtil.clearAcNotice(ctx, voucherInfo.getId().toString());
            }
        }
        voucherInfo.remove("disable_workflow");
    }

    private VoucherValidator getValidator(GlParam sysParam) throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBaseSubmitValidator(sysParam));
        validator.addVoucherBaseValidator(new VoucherBaseSubmitProfitCenterBalanceValidator(sysParam));
        validator.addVoucherEntryValidator(new VoucherEntrySubmitValidator(sysParam));
        validator.addVoucherAssistRecordValidator(new VoucherAssistRecordSubmitValidator(sysParam));
        return validator;
    }

    protected VoucherValidator getAdditionalValidator() {
        return null;
    }

    protected void checkAmountBalance(Context ctx, IObjectPK voucherPK, GlParam sysParam) throws BOSException, EASBizException {
        this.helper.checkAmountBalance(ctx, voucherPK, sysParam);
    }

    protected void dealSubmitCashflow(Context ctx, IObjectPK voucherPK, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        SubmitVoucherServiceHelper.dealSubmitCashflow(ctx, voucherPK, voucherInfo, sysParam);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    private void saveDiffItemRecord(Context ctx, IObjectPK voucherPK, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        DiffItemRecordCollection diRecords = (DiffItemRecordCollection)((Object)voucherInfo.get("diRecords"));
        if (diRecords != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherPK.toString()));
            DiffItemRecordFactory.getLocalInstance(ctx).delete(filter);
            CoreBaseCollection coll = new CoreBaseCollection();
            Iterator it = diRecords.iterator();
            while (it.hasNext()) {
                coll.add((CoreBaseInfo)it.next());
            }
            if (coll.size() > 0) {
                DiffItemRecordFactory.getLocalInstance(ctx).addnew(coll);
            }
        }
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherSubmit", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherSubmit", "After");
    }
}

