/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.AbstractVoucherBaseValidator;
import com.kingdee.eas.util.app.ContextUtil;

public class VoucherBaseAuditValidator
extends AbstractVoucherBaseValidator {
    protected GlParam sysParam;
    protected String auditorId;

    protected VoucherBaseAuditValidator(GlParam sysParam, String auditorId) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
        this.auditorId = auditorId;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.checkMutex(ctx, voucherInfo);
        this.checkStatusAndOperate(ctx, voucherInfo, VoucherOperateStatusEnum.AUDIT);
        this.checkVoucherPeriodForAudit(ctx, voucherInfo);
        this.checkAuditBack(ctx, voucherInfo);
        this.checkChecked(ctx, voucherInfo);
        this.checkAuditor(ctx, voucherInfo);
    }

    protected void checkMutex(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (GlUtils.isExisted(ctx, voucherInfo)) {
            this.checkMutex(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    private void checkMutex(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ObjectUpdateLock lock = mutexService.getObjectUpdateLock(pk.toString());
        if (lock != null) {
            String mutexUserName = lock.getUserName();
            String curUserName = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
            if (!curUserName.equalsIgnoreCase(mutexUserName)) {
                throw new VoucherException(VoucherException.VOUCHER_IN_EDITING);
            }
        }
    }

    private void checkAuditor(Context ctx, VoucherInfo voucherInfo) throws VoucherException, GLException, BOSException {
        boolean ceatorNotAudit = this.sysParam.getBoolean("GL_0491");
        boolean runningWorkflow = GlUtils.isRunningWorkflow(ctx, voucherInfo.getId().toString());
        if (!runningWorkflow && ceatorNotAudit && !SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            if (this.auditorId == null) {
                this.auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            }
            if (this.auditorId.equals(voucherInfo.getCreator().getId().toString())) {
                throw new VoucherException(VoucherException.CEATORNOTAUDIT);
            }
        }
    }

    private void checkChecked(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException, VoucherException {
        boolean useWorkflow = this.sysParam.getBoolean("GL_032");
        int isCheckAfterAudit = this.sysParam.getInt("GL_047");
        if (!useWorkflow && isCheckAfterAudit == 1 && !voucherInfo.isIsCheck() && this.existsCashOrBankAccount(ctx, voucherInfo.getId().toString())) {
            throw new VoucherException(VoucherException.VOUCHERCHECKBFAUD);
        }
    }

    private void checkAuditBack(Context ctx, VoucherInfo voucherInfo) throws VoucherException, GLException, BOSException {
        boolean useWorkflow = this.sysParam.getBoolean("GL_032");
        boolean ishandAuditBack = this.sysParam.getBoolean("GL_099");
        if (!useWorkflow && ishandAuditBack && voucherInfo.isIsAuditBack()) {
            throw new VoucherException(VoucherException.ISAUDITBACK);
        }
    }

    protected void checkVoucherPeriodForAudit(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getNumber() < currPeriod.getNumber()) {
            throw new VoucherException(VoucherException.AUDIT_CUR_PERIOD);
        }
    }
}

