/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.AbstractVoucherBaseValidator;
import com.kingdee.eas.fi.gl.cache.PostVoucherCache;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VoucherBasePostValidator
extends AbstractVoucherBaseValidator {
    protected Map sysParam;

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.checkStatusAndOperate(ctx, voucherInfo, VoucherOperateStatusEnum.AUDIT);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVoucherCheck(ctx, voucherInfo);
    }

    private void checkReverseVoucher(Context ctx, VoucherInfo voucherInfo) throws VoucherException {
        boolean isReverseVoucher = voucherInfo.isIsReverseVoucher();
        String sourceBillId = voucherInfo.getSourceBillId();
        if (isReverseVoucher && !StringUtils.isEmpty((CharSequence)sourceBillId)) {
            String verifyHistorySql = "select 1 from t_gl_acctcussenthistory where FCussVchID=? or FVeriVchID = ?";
            try {
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)verifyHistorySql, (Object[])new Object[]{sourceBillId, sourceBillId});
                if (result.next()) {
                    throw new VoucherException(VoucherException.VERIFYVCHCANNOTREVERSE);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map getAsstNotInitedAccount(Context ctx, String voucherIds) throws BOSException, EASBizException {
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" select v.fid voucherId, ve.FAccountID,av.FNumber FAccountNumber,av.FName").append(loc).append(" FAccountName ");
        sql.append(" from t_gl_VoucherEntry ve ");
        sql.append(" inner join t_gl_Voucher v on v.fid = ve.fbillid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and v.fcompanyid = av.fcompanyid ");
        sql.append(" left outer join t_GL_Flag fg on fg.FOrgUnitID = v.fcompanyid and fg.fkey = ve.faccountid and fg.FName = 'astinit' and fg.FValue = 'true' ");
        sql.append(" where v.FID in (" + voucherIds + ") ");
        sql.append(" and ve.FBillID = v.FID ");
        sql.append(" and ve.FAccountID = av.FID ");
        sql.append(" and av.FCAA is not null ");
        sql.append(" and fg.FKey is null ");
        sql.append(" order by v.fid,ve.FAccountID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, AccountViewCollection> vchAccMap = new HashMap<String, AccountViewCollection>();
        try {
            while (rs.next()) {
                BOSUuid accountId;
                String vchId = rs.getString("voucherId");
                AccountViewCollection accountColl = (AccountViewCollection)vchAccMap.get(vchId);
                if (accountColl == null) {
                    accountColl = new AccountViewCollection();
                    vchAccMap.put(vchId, accountColl);
                }
                if (accountColl.containsKey((Object)(accountId = BOSUuid.read((String)rs.getString("FAccountID"))))) continue;
                AccountViewInfo accountInfo = new AccountViewInfo();
                accountInfo.setId(accountId);
                accountInfo.setNumber("FAccountNumber");
                accountInfo.setName("FAccountName");
                accountColl.add(accountInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return vchAccMap;
    }

    private Map getCussentNotInitedAccount(Context ctx, String voucherIds) throws BOSException, EASBizException {
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" select v.fid voucherId, ve.FAccountID,av.FNumber FAccountNumber,av.FName").append(loc).append(" FAccountName ");
        sql.append(" from t_gl_VoucherEntry ve ");
        sql.append(" inner join t_gl_Voucher v on v.fid = ve.fbillid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and v.fcompanyid = av.fcompanyid ");
        sql.append(" left outer join t_GL_Flag fg on fg.FOrgUnitID = v.fcompanyid and fg.fkey = ve.faccountid and fg.FName = 'cussentinit' and fg.FValue = 'true' ");
        sql.append(" where v.FID in (" + voucherIds + ") ");
        sql.append(" and ve.FBillID = v.FID ");
        sql.append(" and ve.FAccountID = av.FID ");
        sql.append(" and av.FCAA is not null and av.FAC = 1 ");
        sql.append(" and fg.FKey is null ");
        sql.append(" order by v.fid,ve.FAccountID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, AccountViewCollection> vchAccMap = new HashMap<String, AccountViewCollection>();
        try {
            while (rs.next()) {
                BOSUuid accountId;
                String vchId = rs.getString("voucherId");
                AccountViewCollection accountColl = (AccountViewCollection)vchAccMap.get(vchId);
                if (accountColl == null) {
                    accountColl = new AccountViewCollection();
                    vchAccMap.put(vchId, accountColl);
                }
                if (accountColl.containsKey((Object)(accountId = BOSUuid.read((String)rs.getString("FAccountID"))))) continue;
                AccountViewInfo accountInfo = new AccountViewInfo();
                accountInfo.setId(accountId);
                accountInfo.setNumber("FAccountNumber");
                accountInfo.setName("FAccountName");
                accountColl.add(accountInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return vchAccMap;
    }

    private void checkAccountBalanceInited(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, companyId);
        PeriodInfo startPeriod = aryPrd[0];
        PeriodInfo currPeriod = aryPrd[1];
        if (startPeriod.getId().equals((Object)currPeriod.getId()) && !this.isInitedAccountBalance(ctx, companyId)) {
            throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
        }
    }

    private void checkAssistBalanceInited(Context ctx, String voucherId) throws BOSException, EASBizException {
        if (voucherId == null) {
            return;
        }
        AccountViewCollection accountColl = null;
        PostVoucherCache cache = (PostVoucherCache)VoucherProcessCache.getCache(ctx);
        accountColl = cache != null && cache.getNotInitedAsstVoucherMap() != null ? (AccountViewCollection)cache.getNotInitedAsstVoucherMap().get(voucherId) : (AccountViewCollection)this.getAsstNotInitedAccount(ctx, "'" + voucherId + "'").get(voucherId);
        if (accountColl != null && accountColl.size() > 0) {
            Iterator it = accountColl.iterator();
            StringBuffer errMsg = new StringBuffer();
            int index = 0;
            while (it.hasNext()) {
                AccountViewInfo accountInfo = (AccountViewInfo)it.next();
                errMsg.append(accountInfo.getNumber());
                errMsg.append(" ");
                errMsg.append(accountInfo.getName());
                ++index;
                if (!it.hasNext()) continue;
                errMsg.append(";");
            }
            throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_NOT_CLOSED, new String[]{errMsg.toString()});
        }
    }

    private void checkCussentBalanceInited(Context ctx, String voucherId) throws BOSException, EASBizException {
        if (voucherId == null) {
            return;
        }
        boolean isGLAcctCussent = false;
        if (this.sysParam.get("GL_028") != null) {
            isGLAcctCussent = Boolean.valueOf(this.sysParam.get("GL_028").toString());
        }
        if (!isGLAcctCussent) {
            return;
        }
        AccountViewCollection accountColl = null;
        PostVoucherCache cache = (PostVoucherCache)VoucherProcessCache.getCache(ctx);
        accountColl = cache != null && cache.getNotInitedCussentVoucherMap() != null ? (AccountViewCollection)cache.getNotInitedCussentVoucherMap().get(voucherId) : (AccountViewCollection)this.getCussentNotInitedAccount(ctx, "'" + voucherId + "'").get(voucherId);
        if (accountColl != null && accountColl.size() > 0) {
            Iterator it = accountColl.iterator();
            StringBuffer errMsg = new StringBuffer();
            int index = 0;
            while (it.hasNext()) {
                AccountViewInfo accountInfo = (AccountViewInfo)it.next();
                errMsg.append(accountInfo.getNumber());
                errMsg.append(" ");
                errMsg.append(accountInfo.getName());
                ++index;
                if (!it.hasNext()) continue;
                errMsg.append(";");
            }
            throw new GLPeriodEndException(GLPeriodEndException.CUSSENT_INIT_NOT_CLOSED, new String[]{errMsg.toString()});
        }
    }

    private boolean isInitedAccountBalance(Context ctx, String companyId) throws BOSException {
        Boolean isInited;
        PostVoucherCache cache = (PostVoucherCache)VoucherProcessCache.getCache(ctx);
        if (cache != null && (isInited = (Boolean)cache.getIsInitAccountBalanceMap().get(companyId)) != null) {
            return isInited;
        }
        boolean isInited2 = false;
        String sql = "select 1 where exists (select 1 from t_GL_Flag where FOrgUnitID = ? and FName = 'glinit' and FValue = 'true')";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
            if (rs.next()) {
                isInited2 = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        if (cache != null) {
            cache.getIsInitAccountBalanceMap().put(companyId, isInited2);
        }
        return isInited2;
    }

    private void checkVoucherCheck(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean useWorkflow = Boolean.valueOf(this.sysParam.get("GL_032").toString());
        if (!useWorkflow && !voucherInfo.isIsCheck() && this.existsCashOrBankAccount(ctx, voucherInfo.getId().toString())) {
            String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"VOUCHERNOTCHECK", (Locale)ctx.getLocale());
            throw new VoucherException(VoucherException.NO_MSG, new String[]{errMsg});
        }
    }
}

