/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.codingrule.AbstractCodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.SeqSegmentInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.DiffItemFlag;
import com.kingdee.eas.fi.gl.DiffItemUtils;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherOprateSharer
implements IVoucherOprateSharer {
    protected static final Logger logger = Logger.getLogger(VoucherOprateSharer.class);
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";
    public static final String NEW_VOUCHER_NUMBER = "newVoucherNumber";
    protected Context ctx;
    protected IVoucher iVoucher;

    public VoucherOprateSharer(Context ctx) throws BOSException {
        this.ctx = ctx;
        this.iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    public void managerVoucherId(Context ctx, BaseVoucherInfo baseVoucherInfo, VoucherStatusEnum status) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (voucherInfo.getId() == null || voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) {
            if (voucherInfo.getSourceType() != SourceType.OTHER_IMPORT || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && (voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0)) {
                voucherInfo.setNumber(this.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, status));
            }
        } else {
            VoucherInfo previousVoucher = null;
            String[] value = null;
            if (voucherInfo.isExist() && voucherInfo.isNotChanged()) {
                previousVoucher = voucherInfo;
            } else {
                SelectorItemCollection sic;
                VoucherStatusEnum preStatus = voucherInfo.getBizStatus();
                voucherInfo.setBizStatus(status);
                value = this.getCodingRuleProperties(ctx, voucherInfo);
                voucherInfo.setBizStatus(preStatus);
                if (value != null && value.length > 0) {
                    sic = new SelectorItemCollection();
                    for (int i = 0; i < value.length; ++i) {
                        sic.add(new SelectorItemInfo(value[i]));
                    }
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("bizStatus"));
                    sic.add(new SelectorItemInfo("sourceBillId"));
                    sic.add(new SelectorItemInfo("sourceType"));
                    previousVoucher = (VoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                } else if (voucherInfo.getNumber() != null) {
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("bizStatus"));
                    sic.add(new SelectorItemInfo("sourceBillId"));
                    sic.add(new SelectorItemInfo("sourceType"));
                    previousVoucher = (VoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                }
            }
            if (status != null && previousVoucher != null && !status.equals((Object)previousVoucher.getBizStatus())) {
                if (!VoucherStatusEnum.TEMP.equals((Object)previousVoucher.getBizStatus())) {
                    this.recycleVoucherId(ctx, (BaseVoucherInfo)previousVoucher, previousVoucher.getNumber());
                }
                voucherInfo.setNumber(this.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, status));
            } else if (previousVoucher != voucherInfo) {
                boolean voucherEqual = true;
                if (value == null) {
                    value = this.getCodingRuleProperties(ctx, voucherInfo);
                }
                if (value != null) {
                    for (int i = 0; i < value.length; ++i) {
                        if (GlUtils.CompareWithSelector((PropertyContainer)previousVoucher, (PropertyContainer)voucherInfo, value[i])) continue;
                        voucherEqual = false;
                        break;
                    }
                    if (!voucherEqual && previousVoucher != null) {
                        this.recycleVoucherId(ctx, (BaseVoucherInfo)previousVoucher, previousVoucher.getNumber());
                        voucherInfo.setNumber(this.genVoucherId(ctx, (BaseVoucherInfo)voucherInfo, status));
                    }
                }
            }
        }
    }

    private String[] getCodingRuleProperties(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        int size;
        CodingRuleInfo codingRuleInfo;
        SeqSegmentInfo seqInfo;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String[] value = codingRuleManager.getProperties((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus");
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                list.add(value[i]);
            }
        }
        if ((seqInfo = ((AbstractCodingRuleInfo)(codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)voucherInfo, voucherInfo.getCompany().getId().toString(), "bizStatus"))).getSeqSegment()) != null && seqInfo.size() > 0) {
            list.add(seqInfo.getAttrName());
        }
        if ((size = list.size()) > 0) {
            String[] returnValue = new String[size];
            for (int i = 0; i < size; ++i) {
                returnValue[i] = list.get(i).toString();
            }
            return returnValue;
        }
        return null;
    }

    @Override
    public String genVoucherId(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum bizStatus) throws BOSException, EASBizException {
        VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
        voucherInfo.setBizStatus(bizStatus);
        String voucherNumber = this.iVoucher.getVoucherNumber((BaseVoucherInfo)((VoucherInfo)voucherInfo));
        voucherInfo.put(NEW_VOUCHER_NUMBER, (Object)voucherNumber);
        voucherInfo.setBizStatus(oldStatus);
        return voucherNumber;
    }

    @Override
    public void recycleVoucherId(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber) throws BOSException, EASBizException {
        if (voucherNumber != null) {
            boolean isFromDAP;
            boolean bl = isFromDAP = SourceType.NONE == voucherInfo.getSourceType() || voucherInfo.getSourceBillId() != null;
            if (isFromDAP) {
                ctx.put((Object)"isRequiredTransaction", (Object)"false");
            }
            VoucherFactory.getLocalInstance((Context)ctx).recycleVoucherNumber(voucherInfo, voucherNumber);
            if (isFromDAP) {
                ctx.remove((Object)"isRequiredTransaction");
            }
        } else {
            VoucherInfo previousVoucher = null;
            String[] value = this.getCodingRuleProperties(ctx, (VoucherInfo)voucherInfo);
            if (value != null && value.length > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                for (int i = 0; i < value.length; ++i) {
                    sic.add(new SelectorItemInfo(value[i]));
                }
                previousVoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), sic);
                previousVoucher.setNumber(voucherInfo.getNumber());
                previousVoucher.setBizStatus(voucherInfo.getBizStatus());
                this.recycleVoucherId(ctx, (BaseVoucherInfo)previousVoucher, previousVoucher.getNumber());
            }
        }
    }

    private static void updateAcctCussentBalance(Context ctx, String voucherId, boolean isUnVerified, boolean isUnpost) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement stmtUpdate = null;
        ResultSet rs = null;
        String coef = isUnpost ? "-1*" : "";
        String field = isUnVerified ? "FUnVerified" : "FUnHolded";
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql.append("select vast.FVerifiedCussentID FVerifiedCussentID,vch.FIsReverseVoucher, \r\n");
            sql.append(coef).append("sum(vast.FOriginalAmount) FAmtFor, \r\n");
            sql.append(coef).append("sum(vast.FLocalAmount) FAmtLocal, \r\n");
            sql.append(coef).append("sum(vast.FReportingAmount) FAmtRpt, \r\n");
            sql.append(coef).append("sum(vast.FQuantity) FQty, \r\n");
            sql.append(coef).append("sum(vast.FStandardQuantity) FStdQty \r\n");
            sql.append("from T_GL_Voucher vch \r\n");
            sql.append("inner join T_GL_VoucherEntry ve on vch.FID = ve.FBillID \r\n");
            sql.append("inner join T_GL_VoucherAssistRecord vast on ve.FID = vast.FEntryID \r\n");
            sql.append("inner join T_GL_FLAG f on f.FKey = ve.FAccountID and f.FOrgUnitID = vch.FCompanyID and f.FName = 'cussentinit' \r\n");
            sql.append("inner join T_BD_PERIOD pi on pi.FID = f.FInitPeriodID \r\n");
            sql.append("inner join T_BD_PERIOD pv on pv.FID = vch.FPeriodID \r\n");
            sql.append("where (ve.FIsVerify = 1 or  vch.FIsReverseVoucher =1 ) \r\n");
            sql.append("and (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)");
            sql.append("and vast.FVerifiedCussentID is not null \r\n");
            sql.append("and vch.FID = ?");
            sql.append(" and pi.FNumber <= pv.FNUMBER \r\n");
            sql.append(" group by vast.FVerifiedCussentID,vch.FIsReverseVoucher");
            sqlUpdate.append("update T_GL_AcctCussent set \r\n");
            sqlUpdate.append(field).append("AmtFor = ").append(field).append("AmtFor - ?, \r\n");
            sqlUpdate.append(field).append("AmtLocal = ").append(field).append("AmtLocal - ?, \r\n");
            sqlUpdate.append(field).append("AmtRpt = ").append(field).append("AmtRpt - ?, \r\n");
            sqlUpdate.append(field).append("Qty = ").append(field).append("Qty - ?, \r\n");
            sqlUpdate.append(field).append("StdQty = ").append(field).append("StdQty - ? \r\n");
            sqlUpdate.append("where FID = ? ");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, voucherId);
            rs = stmt.executeQuery();
            stmtUpdate = conn.prepareStatement(sqlUpdate.toString());
            int count = 0;
            BigDecimal one = new BigDecimal("1");
            BigDecimal negOne = new BigDecimal("-1");
            while (rs.next()) {
                BigDecimal cofe = rs.getBoolean(2) ? negOne : one;
                stmtUpdate.setBigDecimal(1, rs.getBigDecimal(3).multiply(cofe));
                stmtUpdate.setBigDecimal(2, rs.getBigDecimal(4).multiply(cofe));
                stmtUpdate.setBigDecimal(3, rs.getBigDecimal(5).multiply(cofe));
                stmtUpdate.setBigDecimal(4, rs.getBigDecimal(6).multiply(cofe));
                stmtUpdate.setBigDecimal(5, rs.getBigDecimal(7).multiply(cofe));
                DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)6, (String)rs.getString(1));
                stmtUpdate.addBatch();
                if (++count < 2000) continue;
                count = 0;
                stmtUpdate.executeBatch();
                stmtUpdate.clearBatch();
            }
            if (count > 0) {
                stmtUpdate.executeBatch();
            }
            SQLUtils.cleanup((Statement)stmtUpdate);
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            stmt = null;
            stmtUpdate = null;
            rs = null;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate, (Connection)conn);
                SQLUtils.cleanup(rs, stmt);
                stmt = null;
                stmtUpdate = null;
                rs = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate, (Connection)conn);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        stmt = null;
        stmtUpdate = null;
        rs = null;
    }

    public static void updateAcctCussentUnVerifiedBalance(Context ctx, String voucherId, boolean isUnpost) throws BOSException, EASBizException {
        VoucherOprateSharer.updateAcctCussentBalance(ctx, voucherId, true, isUnpost);
    }

    public static void updateAcctCussentUnHoldedBalance(Context ctx, String voucherId, boolean isUnpost) throws BOSException, EASBizException {
        VoucherOprateSharer.updateAcctCussentBalance(ctx, voucherId, false, isUnpost);
    }

    public static void requestBudgetSubstract(Context ctx, VoucherInfo voucherInfo, GlParam sysParams, int voucherAction) throws BOSException, BgCtrlException, EASBizException {
        VoucherUtil.requestBudgetSubstract(ctx, voucherInfo, sysParams, voucherAction);
    }

    @Override
    public void checkNumber(Context ctx, BaseVoucherInfo voucherInfo, String number) throws BOSException, EASBizException {
        if (voucherInfo.get(NEW_VOUCHER_NUMBER) == null) {
            return;
        }
        Map<String, String> param = new HashMap<String, String>();
        if (voucherInfo.getId() != null) {
            param.put("voucherid", voucherInfo.getId().toString());
        }
        param.put("vouchertypeid", voucherInfo.getVoucherType().getId().toString());
        param.put("period", (String)voucherInfo.getPeriod());
        param.put("number", number);
        param.put("companyid", voucherInfo.getCompany().getId().toString());
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getLocalInstance(ctx);
        param = facade.dealTask("getPreNumberRepeated", param);
        if (param != null) {
            throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
        }
    }

    public static void computeCashflowFlag(VoucherInfo voucherInfo) {
        if (voucherInfo.getCashflowFlag() != CashflowFlag.FINISHED) {
            voucherInfo.setCashflowFlag(CashFlowUtils.computeCashflowFlag(voucherInfo));
        }
    }

    public static void computeDiffItemFlag(VoucherInfo voucherInfo) throws BOSException {
        if (DiffItemFlag.UNSPECIFIED.equals((Object)voucherInfo.getDiffItemFlag())) {
            if (SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
                voucherInfo.setDiffItemFlag(DiffItemFlag.NONEED);
                return;
            }
            Map<String, Object> analysis = DiffItemUtils.analysis(voucherInfo);
            List diffEntries = (List)analysis.get("diffEntries");
            BigDecimal inDiffAmt = (BigDecimal)analysis.get("inDiffAmt");
            BigDecimal exDiffAmt = (BigDecimal)analysis.get("exDiffAmt");
            if (diffEntries.size() == 0 || inDiffAmt.compareTo(GlUtils.zero) == 0 && exDiffAmt.compareTo(GlUtils.zero) == 0) {
                voucherInfo.setDiffItemFlag(DiffItemFlag.NONEED);
            }
        }
    }

    @Override
    public void recycleNumberWhenFail(Context ctx, BaseVoucherInfo voucherInfo, Exception e) throws BOSException, EASBizException {
        if (voucherInfo.get(NEW_VOUCHER_NUMBER) != null) {
            try {
                this.recycleVoucherId(ctx, (BaseVoucherInfo)((VoucherInfo)voucherInfo), (String)voucherInfo.get(NEW_VOUCHER_NUMBER));
            }
            catch (Exception ex) {
                logger.error((Object)"Recycle voucher number error when save voucher!", (Throwable)ex);
            }
        }
        if (e instanceof BOSException) {
            throw (BOSException)((Object)e);
        }
        if (e instanceof EASBizException) {
            throw (EASBizException)((Object)e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new BOSException((Throwable)e);
    }

    @Override
    public void lockVoucher(Context ctx, String voucherId) throws BOSException {
        String sql = "update t_gl_voucher set  FCancellerID = FCancellerID where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherId});
    }

    @Override
    public void lockVoucher(Context ctx, List pkList) throws BOSException {
        if (pkList.size() == 0) {
            return;
        }
        if (pkList.size() == 1) {
            this.lockVoucher(ctx, pkList.get(0).toString());
            return;
        }
        String voucherIDs = SQLUtil.collection2InList(pkList);
        String sql = "update t_gl_voucher set  FCancellerID = FCancellerID where fid in " + voucherIDs + " ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void updateVoucherStatus(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setBizStatus(this.getVoucherStatus(ctx, (BaseVoucherInfo)voucherInfo));
    }

    public static void updateVoucherStatus(Context ctx, String id, String userid, int status, String userFild) throws BOSException {
        if (userFild != null) {
            if (userid != null) {
                String sql = "update t_gl_voucher set " + userFild + "=?, fbizstatus=?, FLastUpdateTime = ? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, new Integer(status), GlUtils.getTime(), id});
            } else {
                String sql = "update t_gl_voucher set " + userFild + "=null, fbizstatus=?, FLastUpdateTime = ? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
            }
        } else {
            String sql = "update t_gl_voucher set fbizstatus=?, FLastUpdateTime = ? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(status), GlUtils.getTime(), id});
        }
    }

    protected void checkCloseInit(Context ctx, Collection vchIdColl) throws BOSException, EASBizException {
        if (vchIdColl == null || vchIdColl.size() == 0) {
            return;
        }
        StringBuffer voucherids = new StringBuffer();
        int count = 0;
        Iterator it = vchIdColl.iterator();
        while (it.hasNext()) {
            String vchid = it.next().toString();
            if (count > 0) {
                voucherids.append(",");
            }
            voucherids.append("'").append(vchid).append("'");
            ++count;
        }
        String curCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_028", new ObjectUuidPK(curCompanyID));
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean bParam = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        boolean isGLAcctCussent = bParam;
        this.checkAccountInited(ctx, curCompanyID);
        this.checkAssitInited(ctx, voucherids, curCompanyID);
        this.checkCussentInited(ctx, voucherids, curCompanyID, isGLAcctCussent);
    }

    private void checkCussentInited(Context ctx, StringBuffer voucherids, String curCompanyID, boolean isGLAcctCussent) throws BOSException, EASBizException {
        if (isGLAcctCussent) {
            String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            StringBuffer sql = new StringBuffer();
            sql.append("select v1.*\t\t\t\t\t\t\t\r\n");
            sql.append("from                                \r\n");
            sql.append("(                                   \r\n");
            sql.append("select distinct ve.FAccountID,      \r\n");
            sql.append("\tacct.FNumber as FAccountNumber, \r\n");
            sql.append("\tacct.FName");
            sql.append(loc);
            sql.append(" as FAccountName\t\t\t\t\t\r\n");
            sql.append("from t_gl_VoucherEntry ve,          \r\n");
            sql.append("\tt_gl_Voucher vch,               \r\n");
            sql.append("\tt_bd_accountview acct           \r\n");
            sql.append("where ve.FBillID = vch.FID    \t\t\r\n");
            sql.append("\tand ve.FAccountID = acct.FID    \r\n");
            sql.append("\tand acct.FCAA is not null       \r\n");
            sql.append("    and acct.FAC = 1                \r\n");
            sql.append("\tand vch.FID  in (" + voucherids.toString() + ")              \t\t\r\n");
            sql.append(")v1                                 \r\n");
            sql.append("left join                           \r\n");
            sql.append("(                                   \r\n");
            sql.append("select FKey from t_GL_Flag          \r\n");
            sql.append("where FOrgUnitID = ?                \r\n");
            sql.append("    and FName = 'cussentinit'       \r\n");
            sql.append("\tand FValue = 'true'            \t\r\n");
            sql.append(")v2                                 \r\n");
            sql.append("on v1.FAccountID = v2.FKey          \r\n");
            sql.append("                                    \r\n");
            sql.append("where v2.FKey is null               \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyID});
            StringBuffer errMsg = new StringBuffer();
            try {
                while (rs.next()) {
                    errMsg.append(rs.getString("FAccountNumber"));
                    errMsg.append(" ");
                    errMsg.append(rs.getString("FAccountName"));
                    errMsg.append(";");
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            if (errMsg.length() > 0) {
                errMsg.delete(errMsg.length() - 1, errMsg.length());
                Object[] info = new String[]{errMsg.toString()};
                throw new GLPeriodEndException(GLPeriodEndException.CUSSENT_INIT_NOT_CLOSED, info);
            }
        }
    }

    private void checkAccountInited(Context ctx, String curCompanyID) throws BOSException, EASBizException, EASBizException {
        PeriodInfo period;
        String curPeriodID;
        PeriodInfo[] aryPrd = GlUtils.getStartCurrentPeriod(ctx, curCompanyID);
        PeriodInfo startPeriod = aryPrd[0];
        String startPeriodID = startPeriod.getId().toString();
        if (startPeriodID.equals(curPeriodID = (period = aryPrd[1]).getId().toString())) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 1 where exists          \t\t\r\n");
            sql.append("(select 1 from t_GL_Flag          \t\r\n");
            sql.append("where FOrgUnitID = ?                \r\n");
            sql.append("    and FName = 'glinit'            \r\n");
            sql.append("\tand FValue = 'true'            \t\r\n");
            sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyID});
            try {
                if (!rs.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
        }
    }

    private void checkAssitInited(Context ctx, StringBuffer voucherids, String curCompanyID) throws BOSException, EASBizException {
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select v1.*\t\t\t\t\t\t\t\r\n");
        sql.append("from                                \r\n");
        sql.append("(                                   \r\n");
        sql.append("select distinct ve.FAccountID,      \r\n");
        sql.append("\tacct.FNumber as FAccountNumber, \r\n");
        sql.append("\tacct.FName");
        sql.append(loc);
        sql.append(" as FAccountName\t\t\t\t\t\r\n");
        sql.append("from t_gl_VoucherEntry ve,          \r\n");
        sql.append("\tt_gl_Voucher vch,               \r\n");
        sql.append("\tt_bd_accountview acct           \r\n");
        sql.append("where ve.FBillID = vch.FID    \t\t\r\n");
        sql.append("\tand ve.FAccountID = acct.FID    \r\n");
        sql.append("\tand acct.FCAA is not null       \r\n");
        sql.append("\tand vch.FID in (" + voucherids.toString() + ")           \t\t\r\n");
        sql.append(")v1                                 \r\n");
        sql.append("left join                           \r\n");
        sql.append("(                                   \r\n");
        sql.append("select FKey from t_GL_Flag          \r\n");
        sql.append("where FOrgUnitID = ?                \r\n");
        sql.append("    and FName = 'astinit'           \r\n");
        sql.append("\tand FValue = 'true'            \t\r\n");
        sql.append(")v2                                 \r\n");
        sql.append("on v1.FAccountID = v2.FKey          \r\n");
        sql.append("                                    \r\n");
        sql.append("where v2.FKey is null               \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{curCompanyID});
        StringBuffer errMsg = new StringBuffer();
        try {
            while (rs.next()) {
                errMsg.append(rs.getString("FAccountNumber"));
                errMsg.append(" ");
                errMsg.append(rs.getString("FAccountName"));
                errMsg.append(";");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        if (errMsg.length() > 0) {
            errMsg.delete(errMsg.length() - 1, errMsg.length());
            Object[] info = new String[]{errMsg.toString()};
            throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_NOT_CLOSED, info);
        }
    }

    protected String idList2Str(Collection voucherIDColl) {
        if (voucherIDColl == null || voucherIDColl.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = voucherIDColl.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (index != 0) {
                sb.append("','");
            }
            sb.append(it.next().toString());
            ++index;
        }
        return sb.toString();
    }

    @Override
    public void loadCashflowRecord(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getId() == null) {
            return;
        }
        if (!voucherInfo.getCashflowFetched()) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
            SorterItemCollection sorters = view.getSorter();
            sorters.add(new SorterItemInfo("seq"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("voucher.id", (Object)voucherInfo.getId()));
            voucherInfo.setCashflowRecords((AbstractObjectCollection)CashflowRecordFactory.getLocalInstance(ctx).getCashflowRecordCollection(view));
        }
    }

    @Override
    public void insertVoucherLog(String[] voucherIds, int action, boolean isDeduct, boolean isPost) throws BOSException {
        GLBalanceFacadeFactory.getLocalInstance(this.ctx).insertVoucherLog(voucherIds, action, isDeduct, isPost);
    }

    @Override
    public VoucherStatusEnum getVoucherStatus(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bizStatus"));
        VoucherInfo vch = (VoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), sic);
        return vch.getBizStatus();
    }

    @Override
    public boolean isVoucherExisted(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        boolean exist;
        boolean bl = exist = voucherInfo.isExist() && voucherInfo.getId() != null;
        if (!exist && voucherInfo.getId() != null && this.iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()))) {
            exist = true;
            voucherInfo.setExist(true);
        }
        return exist;
    }

    public static void mergeVoucherValidator(VoucherValidator validator, VoucherValidator additionalValidator) {
        if (validator == null || additionalValidator == null) {
            return;
        }
        if (additionalValidator.getVoucherBaseValidatorList().size() > 0) {
            validator.addVoucherBaseValidatorList(additionalValidator.getVoucherBaseValidatorList());
        }
        if (additionalValidator.getVoucherEntryValidatorList().size() > 0) {
            validator.addVoucherEntryValidatorList(additionalValidator.getVoucherEntryValidatorList());
        }
        if (additionalValidator.getVoucherAssistRecordValidatorList().size() > 0) {
            validator.addVoucherAssistRecordValidatorList(additionalValidator.getVoucherAssistRecordValidatorList());
        }
    }

    @Override
    public IObjectPK updateVoucherStatus(Context ctx, BaseVoucherInfo voucherInfo, VoucherStatusEnum status) throws BOSException, EASBizException {
        if (voucherInfo.getId() != null && this.iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherInfo.getId()))) {
            if (status != null) {
                voucherInfo.setBizStatus(status);
            }
            ObjectUuidPK retValue = new ObjectUuidPK(voucherInfo.getId());
            this.iVoucher.update((IObjectPK)retValue, (CoreBaseInfo)voucherInfo);
            return retValue;
        }
        throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
    }
}

