/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.FileState;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.WebCashflowUtils;
import com.kingdee.eas.fi.gl.app.voucher.WebUtils;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WebVoucherUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.web.voucher.handler.VoucherInfoTransfer");
    private static String resClassName = "com.kingdee.eas.fi.gl.GLWebResource";
    private static boolean cache = false;
    private static Font SystemFont;
    private static String DEFAULT_FONT_PATH;

    public static VoucherInfo getVoucherInfo(String id, SelectorItemCollection selector) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id), VoucherInfo.fullSelector((SelectorItemCollection)selector));
        return VoucherFacadeFactory.getRemoteInstance().toWebVoucherInfo(voucherInfo);
    }

    public static boolean isCanEditVoucher(Context ctx, String voucherId) throws EASBizException, BOSException {
        String modifyVoucherObj;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("sourceSys"));
        selector.add(new SelectorItemInfo("sourceType"));
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("isCheck"));
        VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(voucherId), selector);
        if (voucherInfo.getBizStatus().getValue() > 1 || voucherInfo.isIsCheck()) {
            return false;
        }
        ObjectUuidPK comapnyPK = new ObjectUuidPK(voucherInfo.getCompany().getId());
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        ObjectUuidPK curUserPK = new ObjectUuidPK(userInfo.getId());
        if (!PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)curUserPK, (IObjectPK)comapnyPK, "gl_voucher02_edit")) {
            return false;
        }
        if (voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && ((modifyVoucherObj = ParamControlFactory.getRemoteInstance().getParamValue(null, "G003")) == null || Boolean.valueOf(modifyVoucherObj.toString()).booleanValue())) {
            return false;
        }
        return WebVoucherUtils.canEdit(voucherInfo, comapnyPK) && MutexServiceControlFactory.getRemoteInstance().requestObjIDForUpdate(voucherId, userInfo.getNumber());
    }

    public static void checkEditVoucher(Context ctx, String voucherId) throws EASBizException, BOSException {
        String modifyVoucherObj;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("sourceSys"));
        selector.add(new SelectorItemInfo("sourceType"));
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("isCheck"));
        VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(voucherId), selector);
        if (voucherInfo.getBizStatus().getValue() > 1 || voucherInfo.isIsCheck()) {
            String editStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource.EDIT", (Locale)ctx.getLocale());
            Object[] info = new String[]{editStr, voucherInfo.getBizStatus().toString()};
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, info);
        }
        ObjectUuidPK comapnyPK = new ObjectUuidPK(voucherInfo.getCompany().getId());
        ObjectUuidPK curUserPK = new ObjectUuidPK(((UserInfo)ctx.get((Object)"UserInfo")).getId());
        if (!PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)curUserPK, (IObjectPK)comapnyPK, "gl_voucher02_edit")) {
            throw new VoucherException(VoucherException.NOT_PERM_EDIT_VOUCHER);
        }
        if (voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && (modifyVoucherObj = ParamControlFactory.getRemoteInstance().getParamValue(null, "G003")) != null && Boolean.valueOf(modifyVoucherObj.toString()).booleanValue()) {
            throw new VoucherException(VoucherException.CAN_NOT_EDIT_IMP_VOUCHER);
        }
        if (!WebVoucherUtils.canEdit(voucherInfo, comapnyPK)) {
            throw new VoucherException(VoucherException.CAN_NOT_EDIT_DAP_VOUCHER, new String[]{voucherInfo.getSourceSys().getAlias()});
        }
        if (!MutexServiceControlFactory.getRemoteInstance().requestObjIDForUpdate(voucherId)) {
            throw new VoucherException(VoucherException.VOUCHER_IN_EDITING);
        }
    }

    public static boolean canEdit(VoucherInfo voucherInfo, ObjectUuidPK comapnyPK) throws BOSException, EASBizException {
        if (voucherInfo.getSourceSys() == SystemEnum.GENERALLEDGER) {
            return true;
        }
        String[] paramNumbers = new String[]{"GL_033", "GL_034", "GL_035", "GL_036", "GL_037", "GL_039", "GL_040", "GL_041", "GL_042"};
        HashMap orgParams = ParamControlFactory.getRemoteInstance().getParamHashMap(paramNumbers, comapnyPK.toString());
        if (voucherInfo.getSourceSys() == SystemEnum.ACCOUNTSRECEIVABLE && orgParams.get("GL_033") != null && Boolean.valueOf(orgParams.get("GL_033").toString()).booleanValue()) {
            return true;
        }
        if (voucherInfo.getSourceSys() == SystemEnum.ACCOUNTSPAYABLE && orgParams.get("GL_034") != null && Boolean.valueOf(orgParams.get("GL_034").toString()).booleanValue()) {
            return true;
        }
        if (voucherInfo.getSourceSys() == SystemEnum.FIXEDASSETS && orgParams.get("GL_035") != null && Boolean.valueOf(orgParams.get("GL_035").toString()).booleanValue()) {
            return true;
        }
        if (voucherInfo.getSourceSys() == SystemEnum.FINANCEMANAGE && orgParams.get("GL_036") != null && Boolean.valueOf(orgParams.get("GL_036").toString()).booleanValue()) {
            return true;
        }
        if (voucherInfo.getSourceSys() == SystemEnum.CASHMANAGEMENT && orgParams.get("GL_037") != null && Boolean.valueOf(orgParams.get("GL_037").toString()).booleanValue()) {
            return true;
        }
        if ((voucherInfo.getSourceSys() == SystemEnum.PURCHASINGMANAGEMENT || voucherInfo.getSourceSys() == SystemEnum.INVENTORYMANAGEMENT || voucherInfo.getSourceSys() == SystemEnum.SALESMANAGEMENT) && orgParams.get("GL_039") != null && Boolean.valueOf(orgParams.get("GL_039").toString()).booleanValue()) {
            return true;
        }
        if (voucherInfo.getSourceSys() == SystemEnum.COMPENSATION && orgParams.get("GL_040") != null && Boolean.valueOf(orgParams.get("GL_040").toString()).booleanValue()) {
            return true;
        }
        if (voucherInfo.getSourceSys() == SystemEnum.BUSINESS_COLLABORATION && orgParams.get("GL_041") != null && Boolean.valueOf(orgParams.get("GL_041").toString()).booleanValue()) {
            return true;
        }
        return voucherInfo.getSourceSys() != SystemEnum.ACCOUNTSRECEIVABLE && voucherInfo.getSourceSys() != SystemEnum.ACCOUNTSPAYABLE && voucherInfo.getSourceSys() != SystemEnum.FIXEDASSETS && voucherInfo.getSourceSys() != SystemEnum.FINANCEMANAGE && voucherInfo.getSourceSys() != SystemEnum.CASHMANAGEMENT && voucherInfo.getSourceSys() != SystemEnum.PURCHASINGMANAGEMENT && voucherInfo.getSourceSys() != SystemEnum.COMPENSATION && voucherInfo.getSourceSys() != SystemEnum.BUSINESS_COLLABORATION && orgParams.get("GL_042") != null && Boolean.valueOf(orgParams.get("GL_042").toString()) != false;
    }

    public static VoucherInfo toVoucherInfo(Context ctx, VoucherInfo webVoucherInfo) throws BOSException, EASBizException {
        WebVoucherUtils.removeNull((CoreBaseInfo)webVoucherInfo);
        String voucherTypeId = (String)webVoucherInfo.get("vouchertypeid");
        if (voucherTypeId != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            VoucherTypeInfo voucherType = (VoucherTypeInfo)VoucherTypeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(voucherTypeId), selector);
            webVoucherInfo.setVoucherType(voucherType);
        }
        String periodStr = (String)webVoucherInfo.get("periodstr");
        webVoucherInfo.setPeriod(WebUtils.toPeriodInfo(periodStr));
        webVoucherInfo.setBizStatus(webVoucherInfo.getBizStatus());
        VoucherEntryCollection entryColl = new VoucherEntryCollection();
        Object curs = webVoucherInfo.get("currencies");
        List currencies = null;
        if (curs instanceof String) {
            String currenciesStr = (String)webVoucherInfo.get("currencies");
            currencies = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)currenciesStr, ArrayList.class);
        } else if (curs instanceof List) {
            currencies = (List)curs;
        }
        boolean isAsstQty = WebVoucherUtils.isAsstQty();
        HashMap<String, AsstActTypeCollection> atMap = new HashMap<String, AsstActTypeCollection>();
        for (int i = 0; i < webVoucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entryInfo = webVoucherInfo.getEntries().get(i);
            WebVoucherUtils.removeNull((CoreBaseInfo)entryInfo);
            if (entryInfo.getDescription() == null && entryInfo.getAccount() == null && entryInfo.getOriginalAmount() == null && entryInfo.get("localdebitamount") == null && entryInfo.get("localcreditamount") == null && entryInfo.get("rptdebitamount") == null && entryInfo.get("rptcreditamount") == null) continue;
            VoucherEntryInfo newEntryInfo = WebVoucherUtils.getVoucherEntryInfo(ctx, entryInfo, entryColl, currencies, atMap, isAsstQty);
            newEntryInfo.put("bill", (Object)JSONUtils.convertObjectToJson((Context)ctx, (Object)newEntryInfo.getBill()));
            entryColl.add(newEntryInfo);
        }
        webVoucherInfo.setEntries((AbstractObjectCollection)entryColl);
        WebVoucherUtils.calVoucherAmount(webVoucherInfo);
        String cashflow = (String)webVoucherInfo.get("cashflow");
        if (!StringUtils.isEmpty((String)cashflow) && !"[]".equals(cashflow)) {
            List cf = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)cashflow, ArrayList.class);
            webVoucherInfo.setCashflowFlag(CashflowFlag.FINISHED);
            webVoucherInfo.setCashflowRecords((AbstractObjectCollection)WebCashflowUtils.toCashflowRecordCollection(ctx, webVoucherInfo, cf));
        }
        WebVoucherUtils.mergeSameEntry(webVoucherInfo, isAsstQty);
        return webVoucherInfo;
    }

    public static Map getVoucherListPageParams(String[] companyIds) throws BOSException, EASBizException {
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            companyIdSet.add(companyIds[i]);
        }
        ArrayList companyList = new ArrayList(companyIdSet);
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("GL_099");
        paramNumberList.add("GL_111");
        paramNumberList.add("GL_0302");
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        ArrayList paramList = iParamControl.getParamHashMapBatch(paramNumberList, companyList);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String paramEnableHandworkAuditback = null;
        String paramCommonVoucherProcess = null;
        String modefy_attach = null;
        for (int i = 0; i < paramList.size(); ++i) {
            ParamSimpleInfo paramSimpleInfo = (ParamSimpleInfo)paramList.get(i);
            if (paramEnableHandworkAuditback == null && "GL_099".equals(paramSimpleInfo.getParamNumber()) && "true".equals(paramSimpleInfo.getParamValue())) {
                paramEnableHandworkAuditback = "true";
                paramMap.put("GL_099", "true");
            }
            if (paramCommonVoucherProcess == null && "GL_111".equals(paramSimpleInfo.getParamNumber()) && "true".equals(paramSimpleInfo.getParamValue())) {
                paramCommonVoucherProcess = "true";
                paramMap.put("GL_111", "true");
            }
            if (modefy_attach == null && "GL_111".equals(paramSimpleInfo.getParamNumber()) && "true".equals(paramSimpleInfo.getParamValue())) {
                modefy_attach = "true";
                paramMap.put("GL_0302", true);
            }
            if (paramEnableHandworkAuditback != null && paramCommonVoucherProcess != null) break;
        }
        if (paramMap.get("GL_099") == null) {
            paramMap.put("GL_099", "false");
        }
        if (paramMap.get("GL_111") == null) {
            paramMap.put("GL_111", "false");
        }
        if (paramMap.get("GL_0302") == null) {
            paramMap.put("GL_0302", false);
        }
        String value = iParamControl.getParamValue(null, "GL_VCH_POST_CONTROL");
        paramMap.put("GL_VCH_POST_CONTROL", value);
        return paramMap;
    }

    private static void mergeSameEntry(VoucherInfo webVoucherInfo, boolean isAsstQty) {
        VoucherEntryCollection entries = new VoucherEntryCollection();
        for (int i = 0; i < webVoucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entryInfo = webVoucherInfo.getEntries().get(i);
            String entryId = (String)entryInfo.get("entryId");
            VoucherEntryInfo entry = null;
            if (!StringUtils.isEmpty((String)entryId)) {
                entry = entries.get((Object)BOSUuid.read((String)entryId));
            }
            if (entry != null) {
                if (WebVoucherUtils.equals(entry.getAccount(), entryInfo.getAccount()) && WebVoucherUtils.equals(entry.getCurrency(), entryInfo.getCurrency()) && WebVoucherUtils.equals(entry.getProfitCenter(), entryInfo.getProfitCenter()) && WebVoucherUtils.equals(entry.getEntryDC(), entryInfo.getEntryDC()) && (isAsstQty || !isAsstQty && WebVoucherUtils.equals(entry.getMeasureUnit(), entryInfo.getMeasureUnit()) && WebVoucherUtils.equals(entry.getPrice(), entryInfo.getPrice())) && WebVoucherUtils.equals(entry.getLocalExchangeRate(), entryInfo.getLocalExchangeRate()) && WebVoucherUtils.equals(entry.getReportingExchangeRate(), entryInfo.getReportingExchangeRate())) {
                    entry.setOriginalAmount(entry.getOriginalAmount().add(entryInfo.getOriginalAmount()));
                    entry.setLocalAmount(entry.getLocalAmount().add(entryInfo.getLocalAmount()));
                    entry.setReportingAmount(entry.getReportingAmount().add(entryInfo.getReportingAmount()));
                    if (entryInfo.getAssistRecords().isEmpty()) continue;
                    VoucherAssistRecordInfo record = entryInfo.getAssistRecords().get(0);
                    record.setEntry(entry);
                    entry.getAssistRecords().add(record);
                    continue;
                }
                entryInfo.setId(null);
                entries.add(entryInfo);
                continue;
            }
            entries.add(entryInfo);
        }
        webVoucherInfo.setEntries((AbstractObjectCollection)entries);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 instanceof CoreBaseInfo) {
            return obj1 != null && ((CoreBaseInfo)obj1).getId() != null && obj2 != null && ((CoreBaseInfo)obj2).getId() != null && ((CoreBaseInfo)obj1).getId().equals((Object)((CoreBaseInfo)obj2).getId());
        }
        return obj1 != null && obj1.equals(obj2);
    }

    public static List getCashFlowList(Context ctx, VoucherInfo voucherInfo, List cfAccountDiffs) throws EASBizException, BOSException {
        String cashflowJson = (String)voucherInfo.get("cashflow");
        List cashflowList = null;
        cashflowList = cashflowJson != null ? (List)JSONUtils.convertJsonToObject((Context)ctx, (String)cashflowJson, ArrayList.class) : WebVoucherUtils.getCashflowList(voucherInfo);
        return WebVoucherUtils.clearUpCashflow(voucherInfo, cashflowList, cfAccountDiffs);
    }

    private static List getCashflowList(VoucherInfo webVoucherInfo) throws EASBizException, BOSException {
        ArrayList newCashflows = new ArrayList();
        if (webVoucherInfo.getId() == null) {
            return newCashflows;
        }
        CashflowRecordCollection cfColl = WebVoucherUtils.getCashflowRecordCollection(webVoucherInfo.getId().toString());
        WebVoucherUtils.initDisposeRecord(webVoucherInfo, cfColl);
        WebVoucherUtils.initCashRecord(webVoucherInfo, cfColl);
        for (int i = 0; i < cfColl.size(); ++i) {
            HashMap<String, Object> cfMap = new HashMap<String, Object>();
            CashflowRecordInfo cfInfo = cfColl.get(i);
            cfMap.put("itemFlag", cfInfo.getItemFlag().getValue());
            if (cfInfo.getType() != null) {
                cfMap.put("type", cfInfo.getType().getValue());
            }
            cfMap.put("originalAmount", cfInfo.getOriginalAmount());
            cfMap.put("localAmount", cfInfo.getLocalAmount());
            cfMap.put("reportingAmount", cfInfo.getReportingAmount());
            cfMap.put("ownAccount", cfInfo.get("ownAccount"));
            cfMap.put("oppAccount", cfInfo.get("oppAccount"));
            if (cfInfo.getPrimaryItem() != null) {
                CashFlowItemInfo primaryItem = cfInfo.getPrimaryItem();
                AssistantHGInfo hgInfo = cfInfo.getAssGrp();
                if (hgInfo != null) {
                    String displayNameGroup = hgInfo.getDisplayNameGroup();
                    String[] displayNames = displayNameGroup.split(";");
                    StringBuffer displayName = new StringBuffer();
                    for (int n = 0; n < displayNames.length; ++n) {
                        String[] name = displayNames[n].split("_!", 2);
                        if ("".equals(name[1])) continue;
                        if (displayName.length() > 0) {
                            displayName.append("|");
                        }
                        displayName.append(name[1]);
                    }
                    hgInfo.put("displayname", (Object)displayName.toString());
                    primaryItem.put("assgrp", (Object)hgInfo);
                }
                cfMap.put("primaryItem", primaryItem);
            }
            if (cfInfo.getSupplementaryItem() != null) {
                cfMap.put("supplementaryItem", cfInfo.getSupplementaryItem());
            }
            if (cfInfo.getFullInfoItem() != null) {
                cfMap.put("fullInfoItem", cfInfo.getFullInfoItem());
            }
            newCashflows.add(cfMap);
        }
        return newCashflows;
    }

    private static void initDisposeRecord(VoucherInfo voucherInfo, CashflowRecordCollection cfs) {
        boolean useRptCurrency = (Boolean)((Map)voucherInfo.getCompany().get("sysparam")).get("G001");
        CashflowRecordCollection cashflowRecords = new CashflowRecordCollection();
        block0: for (int i = 0; i < cfs.size(); ++i) {
            CashflowRecordInfo cfInfo = cfs.get(i);
            if (cfInfo.getItemFlag() != ItemFlag.DISPOSE) continue;
            List<VoucherEntryInfo> entrys = WebVoucherUtils.getVoucherEntrys(voucherInfo, cfInfo.getEntry().getId().toString(), null);
            BigDecimal originalAmount = cfInfo.getOriginalAmount();
            BigDecimal localAmount = cfInfo.getLocalAmount();
            BigDecimal reportingAmount = cfInfo.getReportingAmount();
            for (int j = 0; j < entrys.size(); ++j) {
                BigDecimal entryReportingAmount;
                VoucherEntryInfo entry = entrys.get(j);
                if (j > 0) {
                    cfInfo = (CashflowRecordInfo)cfInfo.clone();
                    cfInfo.setId(null);
                    cashflowRecords.add(cfInfo);
                }
                cfInfo.put("ownAccount", (Object)entry.getSeq());
                cfInfo.put("oppAccount", (Object)entry.getSeq());
                Object localAmObj = entry.get("localcreditamount") != null ? entry.get("localcreditamount") : entry.get("localdebitamount");
                Object reportingAmObj = entry.get("localcreditamount") != null ? entry.get("rptcreditamount") : entry.get("rptdebitamount");
                BigDecimal entryLocalAmount = localAmObj != null ? new BigDecimal(localAmObj.toString()) : GlUtils.zero;
                BigDecimal bigDecimal = entryReportingAmount = reportingAmObj != null ? new BigDecimal(reportingAmObj.toString()) : GlUtils.zero;
                if (localAmount.compareTo(entryLocalAmount) == 0 || j + 1 == entrys.size()) {
                    cfInfo.setOriginalAmount(originalAmount);
                    cfInfo.setLocalAmount(localAmount);
                    cfInfo.setReportingAmount(useRptCurrency ? reportingAmount : GlUtils.zero);
                    continue block0;
                }
                Map original = (Map)entry.get("original");
                Object originalAmObj = original.get("originalamount");
                BigDecimal originalAm = originalAmObj != null ? new BigDecimal(originalAmObj.toString()) : GlUtils.zero;
                originalAmount = originalAmount.subtract(originalAm);
                localAmount = localAmount.subtract(entryLocalAmount);
                reportingAmount = reportingAmount.subtract(entryReportingAmount);
                cfInfo.setOriginalAmount(originalAm);
                cfInfo.setLocalAmount(entryLocalAmount);
                cfInfo.setReportingAmount(entryReportingAmount);
            }
        }
        cfs.addCollection(cashflowRecords);
    }

    private static void initCashRecord(VoucherInfo voucherInfo, CashflowRecordCollection cfs) {
        boolean useRptCurrency = (Boolean)((Map)voucherInfo.getCompany().get("sysparam")).get("G001");
        CashflowRecordCollection cashflowRecords = new CashflowRecordCollection();
        block0: for (int i = 0; i < cfs.size(); ++i) {
            CashflowRecordInfo cfInfo = cfs.get(i);
            if (cfInfo.getItemFlag() == ItemFlag.DISPOSE) continue;
            List<VoucherEntryInfo> entrys = WebVoucherUtils.getVoucherEntrys(voucherInfo, cfInfo.getEntry().getId().toString(), null);
            BigDecimal coef = null;
            if (cfInfo != null && (cfInfo.getItemFlag() == ItemFlag.PRIMARY || cfInfo.getItemFlag() == ItemFlag.BOTH) && cfInfo.getPrimaryItem() != null) {
                int cf = entrys.get(0).get("localcreditamount") != null ? -1 : 1;
                cf = cfInfo.getPrimaryItem().getDirection() == CashFlowDirection.OUT ? -1 * cf : 1 * cf;
                coef = new BigDecimal(cf);
            } else {
                coef = new BigDecimal(1);
            }
            BigDecimal originalAmount = cfInfo.getOriginalAmount().multiply(coef);
            BigDecimal localAmount = cfInfo.getLocalAmount().multiply(coef);
            BigDecimal reportingAmount = cfInfo.getReportingAmount().multiply(coef);
            boolean first = true;
            for (int j = 0; j < entrys.size(); ++j) {
                VoucherEntryInfo entry = entrys.get(j);
                BigDecimal[] amount = WebVoucherUtils.getRemainingAmount(cfs, voucherInfo, entry);
                if (amount[1].doubleValue() == 0.0) continue;
                if (!first) {
                    cfInfo = (CashflowRecordInfo)cfInfo.clone();
                    cfInfo.setId(null);
                    cashflowRecords.add(cfInfo);
                } else {
                    first = false;
                    String assistRecordId = cfInfo.getOppVoucherAssistRecord() != null ? cfInfo.getOppVoucherAssistRecord().getId().toString() : null;
                    List<VoucherEntryInfo> oppEntrys = WebVoucherUtils.getVoucherEntrys(voucherInfo, cfInfo.getOpposingAccountEntry().getId().toString(), assistRecordId);
                    if (!oppEntrys.isEmpty()) {
                        cfInfo.put("oppAccount", (Object)oppEntrys.get(0).getSeq());
                    }
                }
                cfInfo.put("ownAccount", (Object)entry.getSeq());
                if ((amount[1].compareTo(localAmount) != 0 || useRptCurrency && amount[2].compareTo(reportingAmount) != 0) && j + 1 != entrys.size()) {
                    originalAmount = originalAmount.subtract(amount[0].multiply(coef));
                    localAmount = localAmount.subtract(amount[1].multiply(coef));
                    reportingAmount = reportingAmount.subtract(amount[2].multiply(coef));
                    cfInfo.setOriginalAmount(amount[0]);
                    cfInfo.setLocalAmount(amount[1]);
                    cfInfo.setReportingAmount(useRptCurrency ? amount[2] : GlUtils.zero);
                    if (localAmount.doubleValue() != 0.0 || useRptCurrency && reportingAmount.doubleValue() != 0.0) continue;
                    continue block0;
                }
                cfInfo.setOriginalAmount(originalAmount.multiply(coef));
                cfInfo.setLocalAmount(localAmount.multiply(coef));
                cfInfo.setReportingAmount(useRptCurrency ? reportingAmount.multiply(coef) : GlUtils.zero);
                continue block0;
            }
        }
        cfs.addCollection(cashflowRecords);
    }

    private static BigDecimal[] getRemainingAmount(CashflowRecordCollection cfs, VoucherInfo voucherInfo, VoucherEntryInfo entry) {
        Map original = (Map)entry.get("original");
        Object originalAmObj = original.get("originalamount");
        Object localAmObj = entry.get("localcreditamount") != null ? entry.get("localcreditamount") : entry.get("localdebitamount");
        Object reportingAmObj = entry.get("localcreditamount") != null ? entry.get("rptcreditamount") : entry.get("rptdebitamount");
        BigDecimal originalAm = originalAmObj != null ? new BigDecimal(originalAmObj.toString()) : GlUtils.zero;
        BigDecimal localAm = localAmObj != null ? new BigDecimal(localAmObj.toString()) : GlUtils.zero;
        BigDecimal reportingAm = reportingAmObj != null ? new BigDecimal(reportingAmObj.toString()) : GlUtils.zero;
        BigDecimal[] rs = new BigDecimal[]{originalAm, localAm, reportingAm};
        for (int i = 0; i < cfs.size(); ++i) {
            CashflowRecordInfo cfInfo = cfs.get(i);
            Object ownAccount = cfInfo.get("ownAccount");
            Object oppAccount = cfInfo.get("oppAccount");
            if ((ownAccount == null || new BigDecimal(ownAccount.toString()).intValue() != entry.getSeq()) && (oppAccount == null || new BigDecimal(oppAccount.toString()).intValue() != entry.getSeq())) continue;
            if (cfInfo.getOriginalAmount() != null) {
                rs[0] = rs[0].subtract(cfInfo.getOriginalAmount());
            }
            if (cfInfo.getLocalAmount() != null) {
                rs[1] = rs[1].subtract(cfInfo.getLocalAmount());
            }
            if (cfInfo.getReportingAmount() == null) continue;
            rs[2] = rs[2].subtract(cfInfo.getReportingAmount());
        }
        return rs;
    }

    private static List clearUpCashflow(VoucherInfo voucherInfo, List cashflowList, List cfAccountDiffs) {
        ArrayList newCashflows = new ArrayList();
        ArrayList<Map> cashDisPoses = new ArrayList<Map>();
        ArrayList<Map> plDisPoses = new ArrayList<Map>();
        BigDecimal cashAmount = GlUtils.zero;
        BigDecimal plAmount = GlUtils.zero;
        for (int i = 0; i < cashflowList.size(); ++i) {
            int itemFlag;
            Map cashflow = (Map)cashflowList.get(i);
            Object ownEntrySeq = cashflow.get("ownAccount");
            Object oppEntrySeq = cashflow.get("oppAccount");
            if (ownEntrySeq == null) continue;
            VoucherEntryInfo ownEntry = voucherInfo.getEntries().get(new BigDecimal(ownEntrySeq.toString()).intValue() - 1);
            VoucherEntryInfo oppEntry = null;
            if (oppEntrySeq != null) {
                oppEntry = voucherInfo.getEntries().get(new BigDecimal(oppEntrySeq.toString()).intValue() - 1);
            }
            if ((itemFlag = new BigDecimal(cashflow.get("itemFlag").toString()).intValue()) == 5 && cashflow.get("localAmount") != null) {
                BigDecimal localAmount = new BigDecimal(cashflow.get("localAmount").toString());
                boolean isCredit = false;
                Object entryDC = ownEntry.get("entryDC");
                if (entryDC != null) {
                    isCredit = ownEntry.getEntryDC() == EntryDC.CREDIT;
                } else {
                    boolean bl = isCredit = ownEntry.get("localcreditamount") != null && ((BigDecimal)ownEntry.get("localcreditamount")).doubleValue() != 0.0 || ownEntry.get("rptcreditamount") != null && ((BigDecimal)ownEntry.get("rptcreditamount")).doubleValue() != 0.0;
                }
                if (WebVoucherUtils.isCashAccount(ownEntry.getAccount())) {
                    cashDisPoses.add(cashflow);
                    cashAmount = cashAmount.add(isCredit ? localAmount.negate() : localAmount);
                    continue;
                }
                if (!WebVoucherUtils.isPLAccount(ownEntry.getAccount(), cfAccountDiffs)) continue;
                plDisPoses.add(cashflow);
                plAmount = plAmount.add(isCredit ? localAmount.negate() : localAmount);
                continue;
            }
            if (oppEntry == null) continue;
            if (itemFlag == 4) {
                if (WebVoucherUtils.isCashAccount(ownEntry.getAccount()) || WebVoucherUtils.isCashAccount(oppEntry.getAccount()) || WebVoucherUtils.isPLAccount(ownEntry.getAccount(), cfAccountDiffs) || WebVoucherUtils.isPLAccount(oppEntry.getAccount(), cfAccountDiffs)) continue;
                newCashflows.add(cashflow);
                continue;
            }
            if (itemFlag == 3 || itemFlag == 1) {
                if ((!WebVoucherUtils.isCashAccount(ownEntry.getAccount()) || WebVoucherUtils.isCashAccount(oppEntry.getAccount())) && (WebVoucherUtils.isCashAccount(ownEntry.getAccount()) || !WebVoucherUtils.isCashAccount(oppEntry.getAccount()))) continue;
                newCashflows.add(cashflow);
                continue;
            }
            if (itemFlag != 2 || (!WebVoucherUtils.isPLAccount(ownEntry.getAccount(), cfAccountDiffs) || WebVoucherUtils.isPLAccount(oppEntry.getAccount(), cfAccountDiffs) || WebVoucherUtils.isCashAccount(oppEntry.getAccount())) && (WebVoucherUtils.isPLAccount(ownEntry.getAccount(), cfAccountDiffs) || WebVoucherUtils.isCashAccount(ownEntry.getAccount()) || !WebVoucherUtils.isPLAccount(oppEntry.getAccount(), cfAccountDiffs))) continue;
            newCashflows.add(cashflow);
        }
        if (!cashDisPoses.isEmpty() && cashAmount.doubleValue() == 0.0) {
            newCashflows.addAll(cashDisPoses);
        }
        if (!plDisPoses.isEmpty() && plAmount.doubleValue() == 0.0) {
            newCashflows.addAll(plDisPoses);
        }
        return newCashflows;
    }

    private static boolean isCashAccount(AccountViewInfo account) {
        return account.isIsCash() || account.isIsBank() || account.isIsCashEquivalent();
    }

    private static boolean isPLAccount(AccountViewInfo account, List cfAccountDiffs) {
        return account.getAccountTypeID().getProperty() == AccountProperty.SUNYI && (cfAccountDiffs == null || !cfAccountDiffs.contains(account.getId().toString()));
    }

    private static CashflowRecordCollection getCashflowRecordCollection(String voucherId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("voucher.id"));
        view.getSelector().add(new SelectorItemInfo("entry.id"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.id"));
        view.getSelector().add(new SelectorItemInfo("oppVoucherAssistRecord.id"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.id"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.direction"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.name"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.asstAccount.id"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.isDealActivity"));
        view.getSelector().add(new SelectorItemInfo("primaryItem.isEnable"));
        view.getSelector().add(new SelectorItemInfo("supplementaryItem.id"));
        view.getSelector().add(new SelectorItemInfo("supplementaryItem.name"));
        view.getSelector().add(new SelectorItemInfo("fullInfoItem.id"));
        view.getSelector().add(new SelectorItemInfo("fullInfoItem.name"));
        view.getSelector().add(new SelectorItemInfo("assGrp.id"));
        view.getSelector().add(new SelectorItemInfo("assGrp.longNameGroup"));
        view.getSelector().add(new SelectorItemInfo("assGrp.displaynameGroup"));
        view.getSelector().add(new SelectorItemInfo("assGrp.numberGroup"));
        view.getSelector().add(new SelectorItemInfo("originalAmount"));
        view.getSelector().add(new SelectorItemInfo("localAmount"));
        view.getSelector().add(new SelectorItemInfo("reportingAmount"));
        view.getSelector().add(new SelectorItemInfo("itemFlag"));
        view.getSelector().add(new SelectorItemInfo("isSupItem"));
        view.getSelector().add(new SelectorItemInfo("type"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        CashflowRecordCollection cfs = CashflowRecordFactory.getRemoteInstance().getCashflowRecordCollection(view);
        CashflowRecordCollection newCfs = new CashflowRecordCollection();
        CashflowRecordCollection priCfs = new CashflowRecordCollection();
        CashflowRecordCollection suppCfs = new CashflowRecordCollection();
        for (int i = 0; i < cfs.size(); ++i) {
            if (cfs.get(i).getItemFlag() == ItemFlag.DISPOSE) {
                newCfs.add(cfs.get(i));
                continue;
            }
            if (cfs.get(i).getItemFlag() == ItemFlag.SUPPLEMENTARY) {
                suppCfs.add(cfs.get(i));
                continue;
            }
            priCfs.add(cfs.get(i));
        }
        newCfs.addCollection(priCfs);
        newCfs.addCollection(suppCfs);
        return newCfs;
    }

    private static List<VoucherEntryInfo> getVoucherEntrys(VoucherInfo voucherInfo, String entryId, String assistRecordId) {
        ArrayList<VoucherEntryInfo> entries = new ArrayList<VoucherEntryInfo>();
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (!entryId.equals(entry.get("entryid"))) continue;
            if (assistRecordId != null && entry.get("assistrecordid") != null) {
                if (!assistRecordId.equals(entry.get("assistrecordid"))) continue;
                entries.add(entry);
                continue;
            }
            entries.add(entry);
        }
        return entries;
    }

    private static VoucherEntryInfo getVoucherEntryInfo(Context ctx, VoucherEntryInfo entryInfo, VoucherEntryCollection entryColl, List currencies, Map<String, AsstActTypeCollection> atMap, boolean isAsstQty) throws BOSException, EASBizException {
        String entryId = entryInfo.getString("entryid");
        if (StringUtils.isEmpty((String)entryId)) {
            entryInfo.setOprStatus(1);
        } else {
            BOSUuid entryKey = BOSUuid.read((String)entryId);
            if (entryColl.contains((Object)entryKey)) {
                entryInfo.setId(null);
                entryInfo.setOprStatus(1);
            } else {
                entryInfo.setId(entryKey);
                entryInfo.setOprStatus(2);
            }
        }
        EntryDC entryDC = EntryDC.DEBIT;
        BigDecimal localAmount = GlUtils.zero;
        BigDecimal reportingAmount = GlUtils.zero;
        if (WebVoucherUtils.isCredit(entryInfo)) {
            entryDC = EntryDC.CREDIT;
            if (entryInfo.get("localcreditamount") != null) {
                localAmount = new BigDecimal(entryInfo.get("localcreditamount").toString());
            }
            if (entryInfo.get("rptcreditamount") != null) {
                reportingAmount = new BigDecimal(entryInfo.get("rptcreditamount").toString());
            }
        } else {
            if (entryInfo.get("localdebitamount") != null) {
                localAmount = new BigDecimal(entryInfo.get("localdebitamount").toString());
            }
            if (entryInfo.get("rptdebitamount") != null) {
                reportingAmount = new BigDecimal(entryInfo.get("rptdebitamount").toString());
            }
        }
        entryInfo.setLocalAmount(localAmount);
        entryInfo.setReportingAmount(reportingAmount);
        entryInfo.remove("localdebitamount");
        entryInfo.remove("rptdebitamount");
        entryInfo.remove("localcreditamount");
        entryInfo.remove("rptcreditamount");
        entryInfo.setEntryDC(entryDC);
        WebVoucherUtils.setCurrencyOrigAmountQty(ctx, entryInfo, currencies);
        AccountViewInfo account = entryInfo.getAccount();
        if (account != null) {
            entryInfo.setCAA(account.getCAA());
            if (account.getCAA() != null || account.isHasUserProperty()) {
                WebVoucherUtils.toVoucherAssistRecordInfo(ctx, entryInfo, atMap, isAsstQty);
            }
        } else {
            entryInfo.setCAA(null);
        }
        return entryInfo;
    }

    private static void toVoucherAssistRecordInfo(Context ctx, VoucherEntryInfo entryInfo, Map<String, AsstActTypeCollection> atMap, boolean isAsstQty) throws BOSException, EASBizException {
        AccountViewInfo account = entryInfo.getAccount();
        AsstAccountInfo asstAccountInfo = account.getCAA();
        VoucherAssistRecordInfo recordInfo = new VoucherAssistRecordInfo();
        VoucherEntryInfo newEntryInfo = (VoucherEntryInfo)entryInfo.clone();
        newEntryInfo.setAssistRecords(null);
        recordInfo.put("entry", (Object)JSONUtils.convertObjectToJson((Context)ctx, (Object)newEntryInfo));
        recordInfo.setSeq(1);
        recordInfo.setDescription(entryInfo.getDescription());
        recordInfo.setOriginalAmount(entryInfo.getOriginalAmount());
        recordInfo.setLocalAmount(entryInfo.getLocalAmount());
        recordInfo.setReportingAmount(entryInfo.getReportingAmount());
        recordInfo.setQuantity(entryInfo.getQuantity());
        recordInfo.setStandardQuantity(entryInfo.getStandardQuantity());
        recordInfo.setPrice(entryInfo.getPrice());
        String assistrecordId = entryInfo.getString("assistrecordid");
        if (assistrecordId != null) {
            recordInfo.setId(BOSUuid.read((String)assistrecordId));
            recordInfo.setOprStatus(2);
        } else {
            recordInfo.setOprStatus(1);
        }
        if (asstAccountInfo != null && account.getCAA().isIsQty() && isAsstQty) {
            recordInfo.setMeasureUnit(entryInfo.getMeasureUnit());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Object endDate;
            Object bizDate = account.get("asstbizdate");
            if (bizDate != null && bizDate.toString().trim().length() > 0) {
                recordInfo.setBizDate(dateFormat.parse(bizDate.toString()));
            }
            if (account.isAC() && (endDate = account.get("asstenddate")) != null && endDate.toString().trim().length() > 0) {
                recordInfo.setEndDate(dateFormat.parse(endDate.toString()));
            }
        }
        catch (ParseException e) {
            throw new BOSException("parse date error!", (Throwable)e);
        }
        if (asstAccountInfo != null) {
            AsstActTypeCollection atColl = atMap.get(asstAccountInfo.getId().toString());
            if (atColl == null) {
                atColl = WebUtils.getAsstActTypeCollection(asstAccountInfo.getId().toString());
                atMap.put(asstAccountInfo.getId().toString(), atColl);
            }
            if (entryInfo.get("assistGrp") != null) {
                recordInfo.setAssGrp(WebUtils.toAssGrpInfo((Map)((Map)entryInfo.get("assistGrp")).get("asstAct"), asstAccountInfo.getId().toString(), atColl));
            }
        }
        WebVoucherUtils.toAccountCustProp(ctx, account, recordInfo);
        entryInfo.getAssistRecords().add(recordInfo);
        account.remove("assgrp");
        if (account.get("verifiedcussent") != null) {
            Map verifiedcussentMap = (Map)account.get("verifiedcussent");
            AcctCussentInfo cusst = new AcctCussentInfo();
            cusst.setId(BOSUuid.read((String)((String)verifiedcussentMap.get("id"))));
            recordInfo.put("VERIFY_CUSSENT_ID", (Object)((String)verifiedcussentMap.get("id")));
            recordInfo.setVerifiedCussent(cusst);
        }
    }

    private static void toAccountCustProp(Context ctx, AccountViewInfo account, VoucherAssistRecordInfo recordInfo) throws BOSException {
        if (!account.isHasUserProperty()) {
            return;
        }
        String accountcustpropJson = (String)account.get("accountcustprop");
        List custProps = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)accountcustpropJson, List.class);
        if (custProps == null) {
            return;
        }
        for (int n = 0; n < custProps.size(); ++n) {
            Map prop = (Map)custProps.get(n);
            Map type = (Map)prop.get("customizedType");
            String mappingPropName = (String)type.get("mappingPropName");
            if (type != null && type.get("dataType") != null && ((Map)type.get("dataType")).get("value") != null && new BigDecimal(((Map)type.get("dataType")).get("value").toString()).intValue() == 0) {
                if (prop.get("value") == null || "".equals(prop.get("value"))) continue;
                String id = (String)((Map)prop.get("value")).get("id");
                BOSUuid uuid = BOSUuid.read((String)id);
                BOSObjectType bosType = uuid.getType();
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
                try {
                    AbstractCoreBaseInfo value = (AbstractCoreBaseInfo)Class.forName(entityObjectInfo.getObjectValueClass()).newInstance();
                    value.setId(uuid);
                    recordInfo.put(mappingPropName, (Object)value);
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException("newInstance error!", (Throwable)e);
                }
            }
            if (prop == null) continue;
            recordInfo.put(mappingPropName, prop.get("value"));
        }
    }

    private static void calVoucherAmount(VoucherInfo voucherInfo) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            BigDecimal localAmount;
            VoucherEntryInfo entryInfo = voucherInfo.getEntries().get(i);
            BigDecimal rptAmount = entryInfo.getReportingAmount() == null ? GlUtils.zero : entryInfo.getReportingAmount();
            BigDecimal bigDecimal = localAmount = entryInfo.getLocalAmount() == null ? GlUtils.zero : entryInfo.getLocalAmount();
            if (entryInfo.getEntryDC() == EntryDC.CREDIT) {
                BigDecimal credtLocal = voucherInfo.getLocalCreditAmount();
                voucherInfo.setLocalCreditAmount(credtLocal == null ? localAmount : credtLocal.add(localAmount));
                BigDecimal credtRpt = voucherInfo.getReportingCreditAmount();
                voucherInfo.setReportingCreditAmount(credtRpt == null ? rptAmount : credtRpt.add(rptAmount));
                continue;
            }
            BigDecimal debitLocal = voucherInfo.getLocalDebitAmount();
            voucherInfo.setLocalDebitAmount(debitLocal == null ? localAmount : debitLocal.add(localAmount));
            BigDecimal debitRpt = voucherInfo.getReportingDebitAmount();
            voucherInfo.setReportingDebitAmount(debitRpt == null ? rptAmount : debitRpt.add(rptAmount));
        }
    }

    private static void setCurrencyOrigAmountQty(Context ctx, VoucherEntryInfo entryInfo, List currencies) throws BOSException {
        Object originalamountObj;
        if (entryInfo.getCurrency() != null) {
            entryInfo.setCurrency(WebVoucherUtils.getCurrencyInfo(entryInfo.getCurrency().getId().toString(), currencies));
        }
        BigDecimal originalAmount = (originalamountObj = entryInfo.get("originalamount")) == null || StringUtils.isEmpty((String)originalamountObj.toString()) ? GlUtils.zero : new BigDecimal(originalamountObj.toString());
        entryInfo.setOriginalAmount(originalAmount);
        AccountViewInfo account = entryInfo.getAccount();
        BigDecimal quantity = GlUtils.zero;
        BigDecimal standardQuantity = GlUtils.zero;
        BigDecimal price = GlUtils.zero;
        if (account != null && account.isIsQty()) {
            Object measureunitObj;
            Object quantityObj = entryInfo.get("quantity");
            if (quantityObj != null) {
                quantity = new BigDecimal(quantityObj.toString());
            }
            if ((measureunitObj = entryInfo.get("measureunit")) != null && measureunitObj instanceof Map) {
                MeasureUnitInfo mu = (MeasureUnitInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)JSONUtils.convertObjectToJson((Context)ctx, (Object)measureunitObj), MeasureUnitInfo.class);
                if (mu != null && mu.getCoefficient() != null) {
                    entryInfo.setMeasureUnit(mu);
                    standardQuantity = quantity.multiply(mu.getCoefficient());
                }
            } else if (measureunitObj instanceof MeasureUnitInfo) {
                entryInfo.setMeasureUnit((MeasureUnitInfo)measureunitObj);
            }
            Object priceObj = entryInfo.get("price");
            if (priceObj != null) {
                price = new BigDecimal(priceObj.toString());
            }
        }
        entryInfo.setQuantity(quantity);
        entryInfo.setStandardQuantity(standardQuantity);
        entryInfo.setPrice(price);
    }

    private static CurrencyInfo getCurrencyInfo(String currencyId, List currencies) {
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        for (Map currencyMap : currencies) {
            if (!currencyMap.get("value").equals(currencyId)) continue;
            Object precision = currencyMap.get("precision");
            currency.setPrecision(new BigDecimal(precision.toString()).intValue());
            break;
        }
        return currency;
    }

    private static boolean isCredit(VoucherEntryInfo entryInfo) {
        Object localCreditAmount = entryInfo.get("localcreditamount");
        Object rptCreditAmount = entryInfo.get("rptcreditamount");
        return localCreditAmount != null && Double.parseDouble(localCreditAmount.toString()) != 0.0 || rptCreditAmount != null && Double.parseDouble(rptCreditAmount.toString()) != 0.0;
    }

    private static boolean isAsstQty() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("G010", null);
        try {
            HashMap outParam = ParamControlFactory.getRemoteInstance().getParamHashMap(param);
            if (outParam.get("G010") != null) {
                return Boolean.valueOf(outParam.get("G010").toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Get system param error!", (Throwable)e);
        }
        return false;
    }

    private static void removeNull(CoreBaseInfo info) {
        Enumeration e = info.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = info.get(key);
            if (!"null".equals(value) && !"".equals(value)) continue;
            info.put(key, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font SystemFont() throws BOSException {
        if (!cache) {
            String directory = System.getProperty("eas.properties.dir");
            File file = new File(directory);
            if (!file.exists() || !file.isDirectory()) {
                return null;
            }
            FileInputStream aixing = null;
            try {
                aixing = new FileInputStream(new File(file, DEFAULT_FONT_PATH));
                Font dynamicFont = Font.createFont(0, aixing);
                SystemFont = dynamicFont.deriveFont(8.0f);
                aixing.close();
                cache = true;
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (aixing != null) {
                    try {
                        aixing.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return SystemFont;
    }

    public static Map voucherImageCancelFile(Context ctx, Set idSet) throws BOSException, EASBizException {
        return WebVoucherUtils.voucherImageCancelFile(ctx, idSet, false);
    }

    public static Map voucherImageCancelFile(Context ctx, Set idSet, boolean ignoreFiling) throws BOSException, EASBizException {
        StringBuffer error = new StringBuffer();
        int success = 0;
        int failure = 0;
        HashSet<String> companyPermSet = new HashSet<String>();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        VoucherCollection voucherColl = VoucherFactory.getRemoteInstance().getVoucherCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
        int j = voucherColl.size();
        for (int i = 0; i < j; ++i) {
            VoucherInfo voucherInfo = voucherColl.get(i);
            if (!companyPermSet.contains(voucherInfo.getCompany().getId().toString())) {
                PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()), "multiorg_gl_voucherfile02_cancelfile");
                companyPermSet.add(voucherInfo.getCompany().getId().toString());
            }
            if (FileState.NOTFILED.equals((Object)voucherInfo.getFileState())) {
                error.append(MessageFormat.format(EASResource.getString((String)resClassName, (String)"vch_un_filed"), voucherInfo.getNumber())).append("\r\n");
                idSet.remove(voucherInfo.getId().toString());
                ++failure;
                continue;
            }
            if (!FileState.FILING.equals((Object)voucherInfo.getFileState()) || ignoreFiling) continue;
            error.append(MessageFormat.format(EASResource.getString((String)resClassName, (String)"vch_filing"), voucherInfo.getNumber())).append("\r\n");
            idSet.remove(voucherInfo.getId().toString());
            ++failure;
        }
        success = voucherColl.size() - failure;
        FilterInfo mapFilter = new FilterInfo();
        mapFilter.getFilterItems().add(new FilterItemInfo("billID", (Object)idSet, CompareType.INCLUDE));
        IBillImageFacade billImgFac = BillImageFacadeFactory.getRemoteInstance();
        BillImageMapCollection imgMapColl = BillImageMapFactory.getRemoteInstance().getBillImageMapCollection(EntityViewInfo.getInstance((FilterInfo)mapFilter, null, null));
        int j2 = imgMapColl.size();
        for (int i = 0; i < j2; ++i) {
            BillImageMapInfo mapInfo = imgMapColl.get(i);
            billImgFac.deleteBillImage(mapInfo.getImageNumber(), "3", user.getNumber(), "voucherCancelImage");
            DbUtil.execute((Context)ctx, (String)"update t_gl_voucher set ffileState=? where fid=?", (Object[])new Object[]{0, mapInfo.getBillID()});
            DbUtil.execute((Context)ctx, (String)"delete from t_gl_voucherfilerec where fvoucherid=?", (Object[])new Object[]{mapInfo.getBillID()});
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("error", error.toString());
        ret.put("success", success);
        ret.put("failure", failure);
        return ret;
    }

    public static List getSplitCashRecords(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        ArrayList newCashflows = new ArrayList();
        String[] paramNumbers = new String[]{"GL_0152"};
        GlParam glParam = GlParam.getGlParams(null, (String[])paramNumbers, (String)voucherInfo.getCompany().getId().toString());
        boolean companreToAccount = glParam.getInt("GL_0152") == 0;
        int autoSetCashflow = glParam.getInt("GL_078");
        try {
            WebVoucherUtils.splitByTMethod(ctx, WebVoucherUtils.toVoucherInfo(ctx, voucherInfo), companreToAccount, autoSetCashflow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CashflowRecordCollection cfColl = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        if (cfColl != null && !cfColl.isEmpty()) {
            for (int i = 0; i < cfColl.size(); ++i) {
                HashMap<String, Number> cfMap = new HashMap<String, Number>();
                CashflowRecordInfo cfInfo = cfColl.get(i);
                cfMap.put("itemFlag", cfInfo.getItemFlag().getValue());
                if (cfInfo.getType() != null) {
                    cfMap.put("type", cfInfo.getType().getValue());
                }
                cfMap.put("originalAmount", cfInfo.getOriginalAmount());
                cfMap.put("localAmount", cfInfo.getLocalAmount());
                cfMap.put("reportingAmount", cfInfo.getReportingAmount());
                cfMap.put("ownAccount", cfInfo.getEntry().getSeq());
                cfMap.put("oppAccount", cfInfo.getOpposingAccountEntry().getSeq());
                if (cfInfo.getPrimaryItem() != null) {
                    CashFlowItemInfo primaryItem = cfInfo.getPrimaryItem();
                    AssistantHGInfo hgInfo = cfInfo.getAssGrp();
                    if (hgInfo != null) {
                        String displayNameGroup = hgInfo.getDisplayNameGroup();
                        if (displayNameGroup != null) {
                            String[] displayNames = displayNameGroup.split(";");
                            StringBuffer displayName = new StringBuffer();
                            for (int n = 0; n < displayNames.length; ++n) {
                                String[] name = displayNames[n].split("_!", 2);
                                if ("".equals(name[1])) continue;
                                if (displayName.length() > 0) {
                                    displayName.append("|");
                                }
                                displayName.append(name[1]);
                            }
                            hgInfo.put("displayname", (Object)displayName.toString());
                        }
                        primaryItem.put("assgrp", (Object)hgInfo);
                    }
                    cfMap.put("primaryItem", (Number)primaryItem);
                }
                if (cfInfo.getSupplementaryItem() != null) {
                    cfMap.put("supplementaryItem", (Number)cfInfo.getSupplementaryItem());
                }
                if (cfInfo.getFullInfoItem() != null) {
                    cfMap.put("fullInfoItem", (Number)cfInfo.getFullInfoItem());
                }
                newCashflows.add(cfMap);
            }
        }
        voucherInfo.setCashflowRecords(null);
        return newCashflows;
    }

    private static void splitByTMethod(Context ctx, VoucherInfo vch, boolean isSimpleMode, int autoSetCashflow) throws Exception {
        vch.put("ctxVch", (Object)ctx);
        CashFlowUtils.splitByTMethod(vch, isSimpleMode, autoSetCashflow);
    }

    static {
        DEFAULT_FONT_PATH = "simsun.ttc";
    }
}

