/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonSorterPanel;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CompanyPeriodInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Color;
import java.awt.Component;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptClientUtil {
    private static final Logger logger = Logger.getLogger(RptClientUtil.class);
    public static final String RPTRESOURCE = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";

    public static Date getServerDate() throws BOSException {
        return GLGeneralFacadeFactory.getRemoteInstance().getServerDate();
    }

    private RptClientUtil() {
    }

    public static List queryAsstAct(String asstAccountId, String cuId) throws BOSException, EASBizException {
        List list = (List)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#queryAsstAct", new Object[]{asstAccountId, cuId}, new Class[]{String.class, String.class}, true);
        return list;
    }

    public static RptRowSet queryAsstActOfRS(RptParams params) throws BOSException, EASBizException {
        RptRowSet list = (RptRowSet)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#queryAsstActOfRS", new Object[]{params}, new Class[]{RptParams.class}, true);
        return list;
    }

    public static List queryAsstActByAssisthgID(String AssisthgID, String cuId) throws BOSException, EASBizException {
        List list = (List)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#queryAsstActByAssisthgID", new Object[]{AssisthgID, cuId}, new Class[]{String.class, String.class}, true);
        return list;
    }

    public static List queryCussentAsstAct(String cuId) throws BOSException, EASBizException {
        List list = (List)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#queryCussentAsstAct", new Object[]{cuId}, new Class[]{String.class}, true);
        return list;
    }

    public static List getAsstactByAccount(RptParams params) throws BOSException, EASBizException {
        List list = (List)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#getAsstactByAccount", new Object[]{params}, new Class[]{RptParams.class}, true);
        return list;
    }

    public static RptParams getAsstactItemInfo(String actItemId, String actTypeId) throws BOSException, EASBizException {
        RptParams pp = (RptParams)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#getAsstactItemInfo", new Object[]{actItemId, actTypeId}, new Class[]{String.class, String.class}, true);
        return pp;
    }

    public static String getPeriodTitle(int year, int period) {
        String ret = null;
        MessageFormat mf = new MessageFormat(EASResource.getString((String)RPTRESOURCE, (String)"periodformat"));
        ret = mf.format(new String[]{Integer.toString(year), Integer.toString(period)});
        return ret;
    }

    public static String getPeriodToTitle(int yearFrom, int periodFrom, int yearTo, int periodTo) {
        String ret = null;
        MessageFormat mf = new MessageFormat(EASResource.getString((String)RPTRESOURCE, (String)"periodtoformat"));
        ret = mf.format(new String[]{Integer.toString(yearFrom), Integer.toString(periodFrom), Integer.toString(yearTo), Integer.toString(periodTo)});
        return ret;
    }

    public static String getPeriodToTitle(int yearFrom, int periodFrom, int periodTo) {
        String ret = null;
        MessageFormat mf = new MessageFormat(EASResource.getString((String)RPTRESOURCE, (String)"periodtoshortformat"));
        ret = mf.format(new String[]{Integer.toString(yearFrom), Integer.toString(periodFrom), Integer.toString(periodTo)});
        return ret;
    }

    public static String getPeriodTitle(int yearFrom, int periodFrom, int yearTo, int periodTo) {
        String ret = null;
        if (yearFrom == yearTo && periodFrom == periodTo && yearFrom == -1) {
            return "";
        }
        ret = yearFrom == yearTo && periodFrom == periodTo ? RptClientUtil.getPeriodTitle(yearFrom, periodFrom) : (yearFrom == yearTo ? RptClientUtil.getPeriodToTitle(yearFrom, periodFrom, periodTo) : (yearTo < 0 && periodTo < 0 ? RptClientUtil.getPeriodTitle(yearFrom, periodFrom) : RptClientUtil.getPeriodToTitle(yearFrom, periodFrom, yearTo, periodTo)));
        return ret;
    }

    public static RptParams loadSystemParams(String companyId) {
        return RptClientUtil.loadSystemParams(companyId, null);
    }

    public static RptParams loadSystemParams(String companyId, Context ctx) {
        ObjectUuidPK comPk = new ObjectUuidPK(companyId);
        RptParams pp = new RptParams();
        pp.setObject("G001", null);
        pp.setObject("GL_004", (Object)comPk);
        pp.setObject("GL_005", (Object)comPk);
        pp.setObject("GL_006", (Object)comPk);
        pp.setObject("GL_009", (Object)comPk);
        pp.setObject("GL_012", (Object)comPk);
        pp.setObject("GL_002", (Object)comPk);
        pp.setObject("GL_003", (Object)comPk);
        pp.setObject("GL_008", (Object)comPk);
        pp.setObject("G000", null);
        pp.setObject("GL_028", (Object)comPk);
        pp.setObject("GL_053", null);
        pp.setObject("G010", null);
        pp.setObject("GL_064", null);
        pp.setObject("GL_066", null);
        try {
            IParamControl pc = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
            return RptParams.parseFrom((Map)allParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new RptParams();
        }
    }

    public static void removeCurrencyWithSysParam(CurrencyCollection cc, CompanyOrgUnitInfo company) {
        CurrencyInfo currency;
        int i;
        int n;
        RptParams sysParams = RptClientUtil.loadSystemParams(company.getId().toString());
        boolean bForeignCurrencyInUse = Boolean.valueOf(String.valueOf(sysParams.getObject("GL_008")));
        boolean bUsingForeignCurrency = Boolean.valueOf(String.valueOf(sysParams.getObject("G001")));
        boolean removeLocal = true;
        boolean removeReport = true;
        if (!bForeignCurrencyInUse) {
            removeLocal = false;
            if (bUsingForeignCurrency) {
                removeReport = false;
            }
        }
        if (removeLocal) {
            String localId = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            n = cc.size();
            for (i = 0; i < n; ++i) {
                currency = cc.get(i);
                if (!localId.equals(currency.getId().toString())) continue;
                cc.remove(currency);
                break;
            }
        }
        if (removeReport) {
            String reportId = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            n = cc.size();
            for (i = 0; i < n; ++i) {
                currency = cc.get(i);
                if (!reportId.equals(currency.getId().toString())) continue;
                cc.remove(currency);
                break;
            }
        }
    }

    public static void setJComboBoxCurrencys(JComboBox jcb, CurrencyCollection currencyCollection, CurrencyInfo defaultCurrency, CompanyOrgUnitInfo company) {
        RptParams sysParams = RptClientUtil.loadSystemParams(company.getId().toString());
        jcb.removeAllItems();
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        boolean bForeignCurrencyInUse = Boolean.valueOf(String.valueOf(sysParams.getObject("GL_008")));
        boolean bUsingForeignCurrency = Boolean.valueOf(String.valueOf(sysParams.getObject("G001")));
        if (currencyCollection != null) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currency = currencyCollection.get(i);
                if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    jcb.addItem(currencyCollection.get(i));
                }
                if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    generalLocalCurrency = currency;
                }
                if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                generalRptCurrency = currency;
            }
            if (!bForeignCurrencyInUse) {
                if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                    jcb.addItem(generalLocalCurrency);
                }
                if (bUsingForeignCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                    jcb.addItem(generalRptCurrency);
                }
            }
        }
        CurrencyInfo currencyInfo = defaultCurrency = defaultCurrency == null ? company.getBaseCurrency() : defaultCurrency;
        if (defaultCurrency != null) {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)jcb, (ObjectBaseInfo)defaultCurrency);
        }
    }

    public static void setJComboBoxCurrencys(JComboBox jcb, CurrencyCollection currencyCollection, CurrencyInfo defaultCurrency, CompanyOrgUnitInfo company, RptParams sysParams) {
        jcb.removeAllItems();
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        boolean bForeignCurrencyInUse = Boolean.valueOf(String.valueOf(sysParams.getObject("GL_008")));
        boolean bUsingForeignCurrency = Boolean.valueOf(String.valueOf(sysParams.getObject("G001")));
        if (currencyCollection != null) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currency = currencyCollection.get(i);
                if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    jcb.addItem(currencyCollection.get(i));
                }
                if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    generalLocalCurrency = currency;
                }
                if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                generalRptCurrency = currency;
            }
            if (!bForeignCurrencyInUse) {
                if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                    jcb.addItem(generalLocalCurrency);
                }
                if (bUsingForeignCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                    jcb.addItem(generalRptCurrency);
                }
            }
        }
        CurrencyInfo currencyInfo = defaultCurrency = defaultCurrency == null ? company.getBaseCurrency() : defaultCurrency;
        if (defaultCurrency != null) {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)jcb, (ObjectBaseInfo)defaultCurrency);
        }
    }

    public static void checkFIUnit(boolean isSupportVirtual) throws Exception {
        RptClientUtil.checkFIUnit(SysContext.getSysContext().getCurrentFIUnit(), isSupportVirtual);
    }

    public static void checkFIUnit(CompanyOrgUnitInfo company, boolean isSupportVirtual) throws Exception {
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (!company.isIsBizUnit() && !isSupportVirtual) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)company);
    }

    public static void checkFIUnit(Map ctx, CompanyOrgUnitInfo company, boolean isSupportVirtual) throws Exception {
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (!company.isIsBizUnit() && !isSupportVirtual && null == ctx.get(VoucherEditUI.acctonImport)) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)company);
    }

    public static void fullCompanyInfo(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        RptClientUtil.fullCompanyInfo(company, false);
    }

    public static void fullCompanyInfo(CompanyOrgUnitInfo company, boolean isCover) throws BOSException, EASBizException {
        if (isCover || company.getAccountPeriodType().getId() == null || company.getAccountTable() == null || company.getAccountTable().getId() == null) {
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(company.getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
            CompanyOrgUnitInfo buf = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            if (!isCover) {
                buf.putAll((IObjectValue)company);
            }
            company.putAll((IObjectValue)buf);
        }
    }

    public static void setDefaultAccountPeriod(CompanyOrgUnitInfo company, KDBizPromptBox bpPeriodType, KDBizPromptBox bpAccountTable) throws BOSException, EASBizException, SQLException {
        boolean b = false;
        QueryAgent qa = bpPeriodType.getQueryAgent();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        qa.setEntityViewInfo(ev);
        ev.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)company.getAccountPeriodType().getId().toString()));
        IRowSet rs = qa.executeQuery(0, 1);
        b = rs.next();
        if (!b) {
            qa.setEntityViewInfo(null);
            rs = qa.executeQuery(0, 1);
            b = rs.next();
        }
        if (b) {
            PeriodTypeInfo pt = new PeriodTypeInfo();
            pt.setId(BOSUuid.read((String)rs.getString("id")));
            pt.setNumber(rs.getString("number"));
            pt.setName(rs.getString("name"));
            pt.setDescription(rs.getString("description"));
            bpPeriodType.setValue((Object)pt);
        }
        qa.setEntityViewInfo(null);
        RptClientUtil.setDefaultAccount(company, bpAccountTable);
    }

    public static void setDefaultAccount(CompanyOrgUnitInfo company, KDBizPromptBox bpAccountTable) throws BOSException, EASBizException, SQLException {
        boolean b = false;
        b = false;
        FilterInfo filter2 = new FilterInfo();
        FilterItemCollection fic2 = filter2.getFilterItems();
        EntityViewInfo myevi2 = new EntityViewInfo();
        myevi2.setFilter(filter2);
        fic2.add(new FilterItemInfo("destCompany.id", (Object)company.getId().toString()));
        QueryAgent qa = bpAccountTable.getQueryAgent();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        qa.setEntityViewInfo(ev);
        ev.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)company.getAccountTable().getId().toString()));
        IRowSet rs = qa.executeQuery(0, 1);
        b = rs.next();
        if (!b) {
            qa.setEntityViewInfo(myevi2);
            rs = qa.executeQuery(0, 1);
            b = rs.next();
        }
        if (b) {
            AccountTableInfo at = new AccountTableInfo();
            at.setId(BOSUuid.read((String)rs.getString("id")));
            at.setNumber(rs.getString("number"));
            at.setName(rs.getString("name"));
            at.setDescription(rs.getString("description"));
            bpAccountTable.setDataNoNotify(null);
            bpAccountTable.setValue((Object)at);
        }
        qa.setEntityViewInfo(myevi2);
    }

    public static String getCompanyTreeNames(TreeModel model) throws BOSException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            SimpleCompanyUserObject userObject;
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!node.isLeaf()) continue;
            if (node.getUserObject() instanceof SimpleCompanyUserObject) {
                userObject = (SimpleCompanyUserObject)node.getUserObject();
                result.append(userObject.getName()).append(", ");
                continue;
            }
            if (!(node.getUserObject() instanceof OrgStructureInfo)) continue;
            userObject = (OrgStructureInfo)node.getUserObject();
            result.append(userObject.getUnit().getName()).append(", ");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static String getLeafCompany(TreeModel model) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer bf = new StringBuffer("''");
        for (node = node.getFirstLeaf(); node != null; node = node.getNextLeaf()) {
            if (node.getUserObject() == null || !(node.getUserObject() instanceof SimpleCompanyUserObject)) continue;
            SimpleCompanyUserObject info = (SimpleCompanyUserObject)node.getUserObject();
            bf.append(",'");
            bf.append(info.getCompanyId());
            bf.append("'");
        }
        return bf.toString();
    }

    public static String getCompanyByLevel(TreeModel model, int level) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            if (userObject.getLevel() >= level) continue;
            result.append("'");
            result.append(userObject.getCompanyId()).append("', ");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static String getCompanyByCompanyId(TreeModel model, String companyId) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            if (!userObject.getCompanyId().equals(companyId)) continue;
            result.append("'");
            result.append(userObject.getCompanyId()).append("', ");
            RptClientUtil.getCompanyChild(model, node, result);
            break;
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static StringBuffer getCompanyChild(TreeModel model, DefaultMutableTreeNode node, StringBuffer sb) {
        for (int i = 0; i < model.getChildCount(node); ++i) {
            DefaultMutableTreeNode chilidNode = (DefaultMutableTreeNode)model.getChild(node, i);
            if (chilidNode.isLeaf()) continue;
            RptClientUtil.getCompanyChild(model, chilidNode, sb);
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)chilidNode.getUserObject();
            sb.append("'");
            sb.append(userObject.getCompanyId()).append("', ");
        }
        return sb;
    }

    public static CurrencyInfo searchCurrency(CurrencyCollection cc, String id) {
        CurrencyInfo ci = null;
        int n = cc.size();
        for (int i = 0; i < n; ++i) {
            ci = cc.get(i);
            if (!id.equals(ci.getId().toString())) continue;
            return ci;
        }
        return null;
    }

    public static boolean isGeneralLocalCurrency(String currencyId) {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId);
    }

    public static boolean isGeneralReportCurrency(String currencyId) {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId);
    }

    public static String getDecimalFormat(int scale) {
        StringBuffer sb = new StringBuffer("");
        StringBuffer fsb = new StringBuffer("-");
        sb.append("#,##");
        fsb.append("#,##");
        sb.append("0");
        fsb.append("0");
        if (scale > 0) {
            sb.append(".");
            fsb.append(".");
            for (int i = 0; i < scale; ++i) {
                sb.append("0");
                fsb.append("0");
            }
        }
        sb.append(";");
        sb.append(fsb);
        sb.append(";");
        return sb.toString();
    }

    public static String getZeroDecimalFormat(int scale) {
        StringBuilder sb = new StringBuilder("0");
        if (scale > 0) {
            sb.append(".");
            for (int i = 0; i < scale; ++i) {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public static CompanyOrgUnitInfo getCompany(int yearEnd, int numberEnd) {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        return RptClientUtil.getCompany(company, yearEnd, numberEnd);
    }

    public static CompanyOrgUnitInfo getCompany(CompanyOrgUnitInfo company, int yearEnd, int numberEnd) {
        try {
            company = GlUtils.getCompanyById(null, company.getId().toString());
            CompanyOrgUnitInfo orgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(company.getId().toString(), orgUnitInfo.getAccountTable().getId().toString(), yearEnd, numberEnd);
            if (ar != null && ar.getEnabledAcctTable() != null) {
                company.setAccountTable(RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable());
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return company;
    }

    public static void periodChanged(IUIObject owner, CompanyOrgUnitInfo company, int yearEnd, int numberEnd, KDBizPromptBox prbAccount) {
        RptClientUtil.periodChanged(owner, company, null, yearEnd, numberEnd, prbAccount);
    }

    public static void periodChanged(IUIObject owner, CompanyOrgUnitInfo company, int yearEnd, int numberEnd, KDBizPromptBox prbAccountBegin, KDBizPromptBox prbAccountEnd) {
        RptClientUtil.periodChanged(owner, company, null, yearEnd, numberEnd, prbAccountBegin, prbAccountEnd);
    }

    public static void periodChanged(IUIObject owner, CompanyOrgUnitInfo company, FilterInfo oldFilter, int yearEnd, int numberEnd, KDBizPromptBox prbAccount) {
        RptClientUtil.periodChanged(owner, company, oldFilter, yearEnd, numberEnd, prbAccount, prbAccount);
    }

    public static void periodChanged(IUIObject owner, CompanyOrgUnitInfo company, FilterInfo oldFilter, int yearEnd, int numberEnd, KDBizPromptBox prbAccountBegin, KDBizPromptBox prbAccountEnd) {
        try {
            AccountTableInfo table = company.getAccountTable();
            CompanyOrgUnitInfo orgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(company.getId().toString(), orgUnitInfo.getAccountTable().getId().toString(), yearEnd, numberEnd);
            if (ar != null && ar.getEnabledAcctTable() != null) {
                AccountViewInfo[] bgAccount;
                AccountTableInfo accountTableInfo = table = RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
                if (table.getId().equals((Object)company.getAccountTable().getId())) {
                    return;
                }
                table = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(AccessHelper.getId((Object)table.getId().toString())));
                AccountViewInfo account = null;
                if (prbAccountBegin.getValue() != null && prbAccountBegin.getValue() instanceof AccountViewInfo[]) {
                    bgAccount = (AccountViewInfo[])prbAccountBegin.getValue();
                    if (bgAccount.length != 0) {
                        bgAccount[0].getAccountTableID();
                        account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bgAccount[0].getId()));
                    }
                } else if (prbAccountEnd.getValue() != null && prbAccountEnd.getValue() instanceof AccountViewInfo[] && (bgAccount = (AccountViewInfo[])prbAccountEnd.getValue()).length != 0) {
                    bgAccount[0].getAccountTableID();
                    account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bgAccount[0].getId()));
                }
                if (account != null && account.getAccountTableID() != null && !table.getId().equals((Object)account.getAccountTableID().getId())) {
                    prbAccountBegin.setValue(null);
                    prbAccountEnd.setValue(null);
                    company.setAccountTable(table);
                } else if (!table.getId().equals((Object)company.getAccountTable().getId())) {
                    prbAccountBegin.setValue(null);
                    prbAccountEnd.setValue(null);
                    company.setAccountTable(table);
                }
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
            filter.setMaskString("#0 and #1");
            if (oldFilter != null) {
                filter.mergeFilter(oldFilter, "AND");
            }
            EntityViewInfo myevi = new EntityViewInfo();
            myevi.setFilter(filter);
            prbAccountBegin.setEntityViewInfo(myevi);
            prbAccountEnd.setEntityViewInfo(myevi);
            AccountPromptBox apb = new AccountPromptBox(owner, table, filter);
            prbAccountBegin.setSelector((KDPromptSelector)apb);
            prbAccountEnd.setSelector((KDPromptSelector)apb);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static boolean isBetweenAdjPeriod(Component comp, int yearEnd, int yearBegin, int numberBegin) {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        return RptClientUtil.isBetweenAdjPeriod(comp, yearEnd, yearBegin, numberBegin, company);
    }

    public static boolean isBetweenAdjPeriod(Component comp, int yearEnd, int yearBegin, int numberBegin, CompanyOrgUnitInfo company) {
        try {
            String curAcctTableID = company.getAccountTable().getId().toString();
            AccountRefContrastInfo info = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(company.getId().toString(), curAcctTableID);
            if (info == null || !info.isIsEnabled()) {
                return false;
            }
            PeriodInfo enablePeriod = info.getEnabledPeriod();
            if (enablePeriod != null && enablePeriod.getNumber() > yearBegin * 100 + numberBegin && enablePeriod.getNumber() < yearEnd * 100 + 1) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"342_RptClientUtil"));
                sb.append(enablePeriod.toString()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"343_RptClientUtil"));
                MsgBox.showInfo((Component)comp, (String)sb.toString());
                return true;
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isBetweenAdjPeriod(Component comp, AccountRefContrastInfo lastAcctInfo, int yearEnd, int yearBegin, int numberBegin) {
        if (lastAcctInfo == null || !lastAcctInfo.isIsEnabled()) {
            return false;
        }
        PeriodInfo enablePeriod = lastAcctInfo.getEnabledPeriod();
        if (enablePeriod != null && enablePeriod.getNumber() > yearBegin * 100 + numberBegin && enablePeriod.getNumber() < yearEnd * 100 + 1) {
            StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"342_RptClientUtil"));
            sb.append(enablePeriod.toString()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"343_RptClientUtil"));
            MsgBox.showInfo((Component)comp, (String)sb.toString());
            return true;
        }
        return false;
    }

    public static boolean companyBWPeriod(int yearEnd, int numberEnd, TreeModel model) throws EASBizException, BOSException {
        boolean isAfterPeriodIncluded = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        StringBuffer result = new StringBuffer();
        StringBuffer mistakeComPer = new StringBuffer();
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        HashMap<String, SimpleCompanyUserObject> companies = new HashMap<String, SimpleCompanyUserObject>();
        HashMap<String, DefaultMutableTreeNode> companyNodes = new HashMap<String, DefaultMutableTreeNode>();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            companies.put(userObject.getCompanyId(), userObject);
            companyNodes.put(userObject.getCompanyId(), node);
        }
        List periods = RptClientUtil.queryAllCompanyPeriodInfo(new ArrayList(companies.values()));
        ArrayList ls = new ArrayList();
        ArrayList ls1 = new ArrayList();
        CompanyPeriodInfo period = null;
        SimpleCompanyUserObject company = null;
        int size = periods.size();
        for (int i = 0; i < size; ++i) {
            period = (CompanyPeriodInfo)periods.get(i);
            if (period.getCurrP() == null || period.getCurrP().getPeriodNumber() + period.getCurrP().getPeriodYear() * 100 >= numberEnd + yearEnd * 100) continue;
            company = (SimpleCompanyUserObject)companies.get(period.getCompanyID());
            result.append("").append(company.getName()).append(",");
            ls.add(companyNodes.get(company.getCompanyId()));
        }
        Iterator ie = companyNodes.keySet().iterator();
        String periodCompanyId = null;
        String companyId = null;
        boolean found = false;
        while (ie.hasNext()) {
            found = false;
            companyId = (String)ie.next();
            int size2 = periods.size();
            for (int i = 0; i < size2; ++i) {
                periodCompanyId = ((CompanyPeriodInfo)periods.get(i)).getCompanyID();
                if (!companyId.equals(periodCompanyId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ls1.add(companyNodes.get(companyId));
        }
        DefaultMutableTreeNode removenodeNotLeaf = null;
        int returnValue = 1;
        if (result.length() > 0) {
            StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"345_RptClientUtil"));
            sb.append(result.toString());
            returnValue = MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"344_RptClientUtil"), (String)sb.toString());
            if (returnValue == 0) {
                for (DefaultMutableTreeNode removenode : ls) {
                    removenodeNotLeaf = (DefaultMutableTreeNode)removenode.getParent();
                    removenode.removeFromParent();
                    while (removenodeNotLeaf != null && removenodeNotLeaf.getChildCount() == 0) {
                        removenode = (DefaultMutableTreeNode)removenodeNotLeaf.getParent();
                        removenodeNotLeaf.removeFromParent();
                        removenodeNotLeaf = removenode;
                    }
                }
            } else {
                isAfterPeriodIncluded = true;
            }
        }
        try {
            for (DefaultMutableTreeNode removenode : ls1) {
                removenodeNotLeaf = (DefaultMutableTreeNode)removenode.getParent();
                removenode.removeFromParent();
                while (removenodeNotLeaf != null && removenodeNotLeaf.getChildCount() == 0) {
                    removenode = (DefaultMutableTreeNode)removenodeNotLeaf.getParent();
                    removenodeNotLeaf.removeFromParent();
                    removenodeNotLeaf = removenode;
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return isAfterPeriodIncluded;
    }

    private static List queryAllCompanyPeriodInfo(List companies) throws BOSException, EASBizException {
        List list = (List)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#queryAllCompanyPeriodInfo", new Object[]{companies}, new Class[]{List.class}, true);
        return list;
    }

    public static String queryAsstItemByAssisthgID(String assistanthgid) throws BOSException, EASBizException {
        String asstitemid = (String)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#queryAsstItemByAssisthgID", new Object[]{assistanthgid}, new Class[]{String.class}, true);
        return asstitemid;
    }

    public static int getMaxCompanyLevel(TreeModel model) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        int maxLevel = node.getLevel();
        for (node = node.getFirstLeaf(); node != null; node = node.getNextLeaf()) {
            SimpleCompanyUserObject info;
            if (node.getUserObject() == null || !(node.getUserObject() instanceof SimpleCompanyUserObject) || maxLevel >= (info = (SimpleCompanyUserObject)node.getUserObject()).getLevel()) continue;
            maxLevel = info.getLevel();
        }
        return maxLevel;
    }

    public static void companyPeriod(int periodYearFrom, int periodNumberFrom, int periodYearTo, int periodNumberTo, AccountTableInfo value, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap map = (HashMap)CommRptBaseFactory.getRemoteInstance().invoke("com.kingdee.eas.fi.gl.common.RptServerUtil#getCompanyPeriod", new Object[]{new Integer(periodYearFrom), new Integer(periodNumberFrom), new Integer(periodYearTo), new Integer(periodNumberTo), value, company}, new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, AccountTableInfo.class, CompanyOrgUnitInfo.class}, true);
        if (map.get("isTrue") != null && ((Boolean)map.get("isTrue")).booleanValue()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"393_RptClientUtil"));
            throw new RptException(new NumericExceptionSubItem("9991", ""));
        }
    }

    public static void showCommonQueryItems(CommonQueryPanel commonQueryPanel, String[] items, boolean isVisible) throws BOSException {
        if (isVisible) {
            RptClientUtil.addCommonQueryItems(commonQueryPanel, items);
        } else {
            RptClientUtil.removeCommonQueryItems(commonQueryPanel, items);
        }
    }

    public static void removeCommonQueryItems(CommonQueryPanel commonQueryPanel, String[] items) throws BOSException {
        if (commonQueryPanel == null) {
            return;
        }
        CommonFilterPanel commonFilterPanel = commonQueryPanel.getCommonFilterPanel();
        CommonSorterPanel commonSorterPanel = commonQueryPanel.getCommonSorterPanel();
        KDTable kdFilterTable = null;
        if (commonFilterPanel != null) {
            kdFilterTable = commonFilterPanel.getKdtTable();
        }
        KDTable kdSorterTable = null;
        if (commonSorterPanel != null) {
            kdSorterTable = commonSorterPanel.getKdtTable();
        }
        QueryInfo queryInfo = commonQueryPanel.getQueryInfo();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < items.length; ++j) {
                DataObject obj;
                IRow row;
                int rowIndex;
                QueryFieldInfo queryFieldInfo;
                if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !(queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName().equals(items[j])) continue;
                if (commonFilterPanel != null && queryFieldInfo.getExtendedProperty("isCommonQueryFilter") != null) {
                    queryFieldInfo.setExtendedProperty("isCommonQueryFilter", null);
                    if (kdFilterTable != null) {
                        for (rowIndex = kdFilterTable.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
                            row = kdFilterTable.getRow(rowIndex);
                            DataObject dataObject = obj = row.getCell(1).getValue() instanceof DataObject ? (DataObject)row.getCell(1).getValue() : null;
                            if (obj == null || !obj.getValue().equals(queryFieldInfo.getName())) continue;
                            kdFilterTable.removeRow(rowIndex);
                        }
                    }
                }
                if (commonSorterPanel == null || queryFieldInfo.getExtendedProperty("isCommonQuerySorter") == null) continue;
                queryFieldInfo.setExtendedProperty("isCommonQuerySorter", null);
                if (kdSorterTable == null) continue;
                for (rowIndex = 0; rowIndex < kdSorterTable.getRowCount(); ++rowIndex) {
                    row = kdSorterTable.getRow(rowIndex);
                    obj = (DataObject)row.getCell(0).getValue();
                    if (obj == null || !obj.getValue().equals(queryFieldInfo.getName())) continue;
                    row.getStyleAttributes().setLocked(true);
                    row.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
                    row.getCell(1).setValue((Object)new Boolean(false));
                    row.getCell(2).setValue(null);
                }
            }
        }
        commonFilterPanel.reInitCondition();
    }

    public static void addCommonQueryItems(CommonQueryPanel commonQueryPanel, String[] items) throws BOSException {
        if (commonQueryPanel == null) {
            return;
        }
        CommonFilterPanel commonFilterPanel = commonQueryPanel.getCommonFilterPanel();
        CommonSorterPanel commonSorterPanel = commonQueryPanel.getCommonSorterPanel();
        KDTable kdFilterTable = null;
        if (commonFilterPanel != null) {
            kdFilterTable = commonFilterPanel.getKdtTable();
        }
        KDTable kdSorterTable = null;
        if (commonSorterPanel != null) {
            kdSorterTable = commonSorterPanel.getKdtTable();
        }
        QueryInfo queryInfo = commonQueryPanel.getQueryInfo();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < items.length; ++j) {
                QueryFieldInfo queryFieldInfo;
                if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !(queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName().equals(items[j])) continue;
                if (kdFilterTable != null && (queryFieldInfo.getExtendedProperty("isCommonQueryFilter") == null || "".equals(queryFieldInfo.getExtendedProperty("isCommonQueryFilter").trim()))) {
                    queryFieldInfo.setExtendedProperty("isCommonQueryFilter", "true");
                }
                if (commonSorterPanel == null || queryFieldInfo.getExtendedProperty("isCommonQuerySorter") != null && !"".equals(queryFieldInfo.getExtendedProperty("isCommonQuerySorter").trim())) continue;
                queryFieldInfo.setExtendedProperty("isCommonQuerySorter", "true");
                boolean itemExisted = false;
                if (kdSorterTable != null) {
                    for (int rowIndex = 0; rowIndex < kdSorterTable.getRowCount(); ++rowIndex) {
                        IRow row = kdSorterTable.getRow(rowIndex);
                        DataObject obj = (DataObject)row.getCell(0).getValue();
                        if (obj == null || !obj.getValue().equals(queryFieldInfo.getName())) continue;
                        row.getStyleAttributes().setLocked(false);
                        row.getStyleAttributes().setBackground(Color.white);
                        itemExisted = true;
                    }
                }
                if (itemExisted) continue;
                try {
                    if (kdSorterTable == null) continue;
                    IRow row = kdSorterTable.addRow(kdSorterTable.getRowCount());
                    DataObject obj = new DataObject();
                    obj.setName(queryFieldInfo.getDisplayName());
                    obj.setValue(queryFieldInfo.getName());
                    row.getCell(0).setValue((Object)obj);
                    row.getCell(1).setValue((Object)new Boolean(false));
                    row.getCell(2).setValue(null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        commonFilterPanel.reInitCondition();
    }

    public static void setSpinnerPeriodNumber(PeriodEntity pe, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod) {
        int period;
        int year;
        if (pe == null) {
            return;
        }
        PeriodEntity usedPeriod = pe.getUsedPeriod();
        if (usedPeriod == null) {
            return;
        }
        int startYear = usedPeriod.getMinYear();
        int startPeriod = usedPeriod.getMinPeriod(startYear);
        if (fromYear.getValue() instanceof Integer && fromPeriod.getValue() instanceof Integer) {
            year = (Integer)fromYear.getValue();
            period = (Integer)fromPeriod.getValue();
            if (year < startYear || year == startYear && period < startPeriod) {
                fromYear.setValue((Object)new Integer(startYear));
                fromPeriod.setValue((Object)new Integer(startPeriod));
            }
        }
        if (toYear.getValue() instanceof Integer && toPeriod.getValue() instanceof Integer) {
            year = (Integer)toYear.getValue();
            period = (Integer)toPeriod.getValue();
            if (year < startYear || year == startYear && period < startPeriod) {
                toYear.setValue((Object)new Integer(startYear));
                toPeriod.setValue((Object)new Integer(startPeriod));
            }
        }
    }

    public static List getPeriodListByNumberRange(int[] periodRange, CompanyOrgUnitInfo companyInfo, boolean isIncludeInit) throws BOSException {
        int numberFrom = periodRange[0];
        int numberTo = periodRange[1];
        String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
        ArrayList<String> list = null;
        IPeriod iperiod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(numberFrom), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(numberTo), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId));
        evi.setFilter(filter);
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("number"));
        PeriodCollection coll = iperiod.getPeriodCollection(evi);
        PeriodInfo prd = null;
        list = new ArrayList<String>();
        if (isIncludeInit) {
            list.add("AAAAAAAAAAAAAAAAAAAAAII4jEw=");
        }
        for (int i = 0; i < coll.size(); ++i) {
            prd = coll.get(i);
            list.add(prd.getId().toString());
        }
        return list;
    }

    public static boolean periodCheckForAccountRefContrast(AccountRefContrastInfo ar, int year, int month) {
        if (ar.getEnabledPeriod() == null) {
            return false;
        }
        int periodYear = ar.getEnabledPeriod().getPeriodYear();
        int periodNumber = ar.getEnabledPeriod().getPeriodNumber();
        return year <= periodYear && (year != periodYear || month <= periodNumber);
    }

    public static CompanyOrgUnitInfo toCompanyOrgUnitInfo(SimpleCompanyUserObject spCompany) {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        if (null != spCompany.getCuId()) {
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)spCompany.getCuId()));
            company.setCU(cu);
        }
        company.setId(BOSUuid.read((String)spCompany.getCompanyId()));
        company.setName(spCompany.getName());
        company.setNumber(spCompany.getNumber());
        company.setLongNumber(spCompany.getLongNumber());
        company.setLevel(spCompany.getLevel());
        company.setIsLeaf(spCompany.isLeaf());
        return company;
    }

    public static SimpleCompanyUserObject toSimpleCompanyInfo(CompanyOrgUnitInfo company) {
        SimpleCompanyUserObject simpleCompany = new SimpleCompanyUserObject();
        simpleCompany.setCompanyId(company.getId().toString());
        simpleCompany.setNumber(company.getNumber());
        simpleCompany.setName(company.getName());
        simpleCompany.setLeaf(company.isIsBizUnit());
        simpleCompany.setLevel(company.getLevel());
        return simpleCompany;
    }

    public static boolean isHasStartPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        return startPeriod != null;
    }

    public static boolean isHasFunction(CompanyOrgUnitInfo company, String permissionItem) throws EASBizException, BOSException {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(company.getId()), permissionItem);
    }

    public static String getFICompanySQL(boolean isAssistantOrg) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cp.fid ");
        sql.append(" from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        sql.append(" inner join t_org_company cp on cp.fid = ssc.fcompanyid ");
        sql.append(" where ssc.fstartperiodid is not null ");
        if (isAssistantOrg) {
            sql.append(" and cp.fisAssistantOrg = 1");
        } else {
            sql.append(" and cp.fisAssistantOrg = 0");
        }
        sql.append(" and cp.faccounttableid is not null ");
        return sql.toString();
    }

    public static ProfitCenterOrgUnitInfo toProfitCenterOrgUnitInfo(SimpleCompanyUserObject spProfitCenter) {
        ProfitCenterOrgUnitInfo profitCenter = new ProfitCenterOrgUnitInfo();
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)spProfitCenter.getCuId()));
        profitCenter.setCU(cu);
        profitCenter.setId(BOSUuid.read((String)spProfitCenter.getCompanyId()));
        profitCenter.setName(spProfitCenter.getName());
        profitCenter.setNumber(spProfitCenter.getNumber());
        profitCenter.setLongNumber(spProfitCenter.getLongNumber());
        profitCenter.setLevel(spProfitCenter.getLevel());
        profitCenter.setIsLeaf(spProfitCenter.isLeaf());
        return profitCenter;
    }

    public static CompanyOrgUnitCollection getCompanyCollection(Set companyIdSet) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        evi.setFilter(f);
        CompanyOrgUnitCollection comCol = null;
        try {
            comCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return comCol;
    }

    public static boolean isSameBaseCurrency(CompanyOrgUnitCollection companys) {
        if (companys == null || companys.isEmpty()) {
            return true;
        }
        boolean same = true;
        BOSUuid lastId = null;
        for (int i = 0; i < companys.size(); ++i) {
            CurrencyInfo currency = companys.get(i).getBaseCurrency();
            if (currency == null) continue;
            if (lastId == null) {
                lastId = currency.getId();
                continue;
            }
            if (lastId.equals((Object)currency.getId())) continue;
            same = false;
            break;
        }
        return same;
    }
}

