/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.print;

import com.kingdee.bos.ctrl.kdf.table.print.FrugalPrintManager;
import com.kingdee.bos.ctrl.kdf.table.print.IRetrieveDataListener;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.eas.fi.gl.common.print.MultiPrintModel;
import com.kingdee.eas.fi.gl.common.print.PrintOptionUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.PrintServiceSet;
import java.awt.Component;

public class MultiPrint {
    private MultiPrintModel model;
    private FrugalPrintManager printManager;
    private boolean optionPrintAll = false;
    private boolean optionSwapPage = false;

    public MultiPrint(Component parentWindow) {
        this.init(parentWindow);
    }

    public boolean showPrintOption() throws Exception {
        boolean[] bs = PrintOptionUI.showDlg(this.model.getParentWindow());
        if (bs == null) {
            return false;
        }
        this.optionPrintAll = PrintOptionUI.isRangeAll(bs);
        this.optionSwapPage = PrintOptionUI.isTypeSplit(bs);
        this.model.setOptionSwapPage(this.optionSwapPage);
        if (!this.optionSwapPage) {
            this.printManager.setFrugalPrint(true);
            this.printManager.setBlockSpace(20);
        } else {
            this.printManager.setFrugalPrint(false);
        }
        return true;
    }

    public boolean isPrintAll() {
        return this.optionPrintAll;
    }

    private void init(Component parentWindow) {
        this.model = new MultiPrintModel();
        this.model.setParentWindow(parentWindow);
        this.printManager = new FrugalPrintManager((IRetrieveDataListener)this.model);
        this.printManager.setParent(parentWindow);
        this.printManager.setPreviewWindowType((short)0);
        this.printManager.getPrinter().addConfigChangeListener((IConfigChangeListener)this.model);
        if (parentWindow instanceof CoreUI) {
            PrintServiceSet printService = new PrintServiceSet((CoreUI)parentWindow);
            this.printManager.getPrinter().addPrintActionListener((IPrintActionListener)printService);
            this.printManager.getPrinter().addConfigChangeListener((IConfigChangeListener)new PrintServiceSet.PrinterSetChange(printService));
        }
    }

    public MultiPrintModel getMultiPrintModel() {
        return this.model;
    }

    public void print() {
        this.printManager.print();
    }

    public void preview() {
        this.printManager.printPreview();
    }

    public void setPrintJobName(String jobName) {
        if (jobName != null) {
            this.printManager.getPrinter().getPrintConfig().setPrintJobName(jobName);
        }
    }
}

