/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.CheckSchemeParam;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistoryFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.cslacct.CheckViewInfo;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckType;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionEntryInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionException;
import com.kingdee.eas.fi.gl.cslacct.RequisitionFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionInfo;
import com.kingdee.eas.fi.gl.cslacct.VoucherCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.app.AbstractRequisitionCheckControllerBean;
import com.kingdee.eas.fi.gl.cslacct.app.ServerHelper;
import com.kingdee.eas.fi.gl.cslacct.util.Helper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequisitionCheckControllerBean
extends AbstractRequisitionCheckControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.cslacct.app.RequisitionCheckControllerBean");
    private static final String TABLE_FIELD_SRCREQENTRYID = "FSrcRequisitionEntryID";
    private static final String TABLE_FIELD_SRCASSISTID = "FSrcAssistRecordID";
    private static final String TABLE_FIELD_TARGREQENTRYID = "FTargRequisitionEntryID";
    private static final String TABLE_FIELD_TARGASSISTID = "FTargAssistRecordID";
    private static final String TABLE_FIELD_STATUS = "FStatus";
    private static final String TABLE_FIELD_SRCVCHNUMBER = "FSrcVchNumber";
    private static final String TABLE_FIELD_TARGVCHNUMBER = "FTargVchNumber";
    private static final String TABLE_FIELD_CHECKNUMBER = "FCheckNumber";
    public static final int BY_DATE = 64;
    public static final int SINGLE_PERIOD = 128;
    public static final int SAME_YEAR = 256;
    public static final int DIFF_YEAR = 512;
    public static int limitLength = 1000;
    public static final String suffix = "...";
    private PreparedStatement stReq = null;
    private PreparedStatement stAvoid = null;
    private PreparedStatement stVch = null;

    @Override
    protected void _check(Context ctx, Map checkViews) throws BOSException, EASBizException {
        this.handCheck(ctx, checkViews);
    }

    @Override
    protected void _autoCheckByReq(Context ctx, ReqCheckCondition condition) throws BOSException, EASBizException {
        this.lockReqAndVch(ctx, null, null);
        this.auto_CheckReqByReqNew(ctx, condition);
        this.customLogic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockReqAndVch(Context ctx, String vchIds, Map vchMap) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)vchIds)) {
            String sql = "select fid, fnumber,flastupdatetime from t_gl_voucher where fid in " + vchIds;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String vchId = null;
            String vchNumber = null;
            try {
                while (rs.next()) {
                    vchId = rs.getString("fid");
                    vchNumber = rs.getString("fnumber");
                    Timestamp time = rs.getTimestamp("flastupdatetime");
                    if (vchMap.get(vchId) == null || time.compareTo((Timestamp)vchMap.get(vchId)) == 0) continue;
                    throw new RequisitionException(RequisitionException.BILL_VCH_CHANGED, null, new Object[]{vchNumber});
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void customLogic() throws BOSException, EASBizException {
    }

    @Override
    protected void _autoCheckByVch(Context ctx, ReqCheckCondition condition) throws BOSException, EASBizException {
        this.auto_CheckReqByReq(ctx, condition);
    }

    @Override
    protected void _cancelCheck(Context ctx, Collection checkViews) throws BOSException, EASBizException {
        this.cancel_Check(ctx, checkViews);
    }

    @Override
    protected void _clearReqRelation(Context ctx, String vchIds, boolean isClearAll) throws BOSException, EASBizException {
        this.clear_ReqRelation(ctx, vchIds, isClearAll);
    }

    @Override
    protected void _checkReqCoherence(Context ctx, String voucherID) throws BOSException, EASBizException {
        this.checkReq_Coherence(ctx, voucherID);
    }

    @Override
    protected void _checkReqCoherenceBatch(Context ctx, String companyID, String periodID) throws BOSException, EASBizException {
        this.check_ReqCoherenceBatch(ctx, companyID, periodID);
    }

    @Override
    protected void _virtualSubmit(Context ctx, IObjectPK requisition) throws BOSException {
    }

    @Override
    protected Object[] _getReqIdForCheckVoucher(Context ctx, ReqCheckCondition condition) throws BOSException {
        return this.get_ReqIdForCheckVoucher(ctx, condition);
    }

    private void handCheck(Context ctx, Map checkViews) throws EASBizException, BOSException {
        RequisitionCheckInfo info;
        Iterator it;
        Object obj;
        if (checkViews == null || checkViews.size() == 0) {
            return;
        }
        Collection srcViews = (Collection)checkViews.get("checkview.source");
        Collection targViews = (Collection)checkViews.get("checkview.target");
        StringBuilder logDetail = this.getLogDetail(srcViews, targViews);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"check", (BOSObjectType)RequisitionCheckFactory.getLocalInstance(ctx).getType(), null, (String)logDetail.toString(), (String)"gl_req_validate");
        Map src = this.putCheckInfo(srcViews);
        Map target = this.putCheckInfo(targViews);
        Map vchMap = (Map)src.get("voucher.id");
        vchMap.putAll((Map)target.get("voucher.id"));
        String ids = SQLUtil.collection2InList(vchMap.keySet());
        ids = ids.replace(")(", ",");
        this.lockReqAndVch(ctx, ids, vchMap);
        DbUtil.execute((Context)ctx, (String)("update t_gl_voucher set flastupdatetime = ? where fid in " + ids), (Object[])new Object[]{GlUtils.getTime()});
        Uuid uuid = Uuid.create();
        this.checkRequsition(ctx, src, target, uuid.toString());
        if (srcViews != null && srcViews.size() > 0 && (obj = (it = srcViews.iterator()).next()) instanceof RequisitionCheckInfo && (info = (RequisitionCheckInfo)obj).getRequisition() != null && info.getRequisition().getId() != null) {
            DbUtil.execute((Context)ctx, (String)this.getUpdateAvoidSQL(info.getRequisition().getId().toString()), (Object[])new Object[]{new Integer(0)});
        }
        if (targViews != null && targViews.size() > 0 && (obj = (it = targViews.iterator()).next()) instanceof RequisitionCheckInfo && (info = (RequisitionCheckInfo)obj).getRequisition() != null && info.getRequisition().getId() != null) {
            DbUtil.execute((Context)ctx, (String)this.getUpdateAvoidSQL(info.getRequisition().getId().toString()), (Object[])new Object[]{new Integer(0)});
        }
        this.checkAssistRecord(ctx, src, target, uuid.toString());
        if (logPk != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
    }

    private StringBuilder getLogDetail(Collection srcViews, Collection targViews) {
        StringBuilder logDetail = new StringBuilder();
        this.setLogDetail(srcViews, logDetail);
        if (logDetail.length() < limitLength) {
            this.setLogDetail(targViews, logDetail);
        }
        if (logDetail.length() > 0 && logDetail.lastIndexOf(suffix) < 0) {
            logDetail.deleteCharAt(logDetail.length() - 1);
        }
        return logDetail;
    }

    private void setLogDetail(Collection views, StringBuilder logDetail) {
        for (CheckViewInfo reqCheckInfo : views) {
            String reqCheckNumber = (String)reqCheckInfo.getPropertyValueBykey("requisition.number");
            if (StringUtils.isEmpty((String)reqCheckNumber)) continue;
            if (logDetail.length() <= limitLength) {
                logDetail.append(reqCheckNumber).append(",");
                continue;
            }
            logDetail.deleteCharAt(logDetail.length() - 1);
            logDetail.append(suffix);
            break;
        }
    }

    private synchronized void checkRequsition(Context ctx, Map src, Map target, String checkNumber) throws EASBizException, BOSException {
        Object[] vs;
        IRowSet rs;
        Object[] os;
        String pkFiled = "FID";
        if (src.size() != 0 && src.containsKey(RequisitionCheckInfo.class.getName())) {
            os = new Object[]{new Integer(2), checkNumber, target.get("voucher.number").toString()};
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByReqForUpdate(pkFiled, src.get("id").toString()));
            rs = DbUtil.executeQuery((Context)ctx, (String)this.getSQLStringByReqForCheck(pkFiled, src.get("id").toString()));
            try {
                if (rs.next()) {
                    throw new RequisitionException(RequisitionException.BILL_PART_CHECKED2);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByReq(pkFiled, src.get("id").toString()), (Object[])os);
            vs = new Object[]{new Integer(2), checkNumber};
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByVch(pkFiled, src.get("assistrecord.id").toString()), (Object[])vs);
        }
        if (target.size() != 0 && target.containsKey(RequisitionCheckInfo.class.getName())) {
            os = new Object[]{new Integer(2), checkNumber, src.get("voucher.number").toString()};
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByReqForUpdate(pkFiled, target.get("id").toString()));
            rs = DbUtil.executeQuery((Context)ctx, (String)this.getSQLStringByReqForCheck(pkFiled, target.get("id").toString()));
            try {
                if (rs.next()) {
                    throw new RequisitionException(RequisitionException.BILL_PART_CHECKED2);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByReq(pkFiled, target.get("id").toString()), (Object[])os);
            vs = new Object[]{new Integer(2), checkNumber};
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByVch(pkFiled, target.get("assistrecord.id").toString()), (Object[])vs);
        }
    }

    private String getSQLStringByReq(String pkFiled, String idString) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_CSL_RequisitionEntry Set FStatus = ?,FCheckNumber =?,FVchNumber = ? \r\n");
        strSQL.append("Where ").append(pkFiled).append(" IN(").append(idString).append(")");
        return strSQL.toString();
    }

    private String getSQLStringByReqForUpdate(String pkFiled, String idString) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("update T_CSL_RequisitionEntry set  Fsummary = Fsummary  \r\n");
        strSQL.append("Where ").append(pkFiled).append(" IN(").append(idString).append(")");
        return strSQL.toString();
    }

    private String getSQLStringByReqForCheck(String pkFiled, String idString) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select top 1 fid from T_CSL_RequisitionEntry where (FStatus = 2 or FCheckNumber is not null or FVchNumber is not null) \r\n");
        strSQL.append("and ").append(pkFiled).append(" IN(").append(idString).append(")");
        return strSQL.toString();
    }

    private String getUpdateAvoidSQL(String idString) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_CSL_Requisition Set FIsAvoidCheck = ? \r\n");
        strSQL.append("Where FID  IN('").append(idString).append("')");
        return strSQL.toString();
    }

    private String getSQLStringByReq(String pkFiled) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_CSL_RequisitionEntry \t\t\r\n");
        strSQL.append("Set FStatus = ?, \t\t\t\t\t\r\n");
        strSQL.append("\t   FCheckNumber = ?, \t\t\t\t\r\n");
        strSQL.append("\t   FVchNumber = ? \t\t\t\t\t\r\n");
        strSQL.append("Where ").append(pkFiled).append(" = ? \r\n");
        return strSQL.toString();
    }

    private String getUpdateAvoidSQLByAutou() {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_CSL_Requisition Set FIsAvoidCheck = 0 \r\n");
        strSQL.append("Where FID = ?");
        return strSQL.toString();
    }

    private String getSQLStringByVch(String pkFiled, String idString) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_GL_VoucherAssistRecord Set FReqCheckStatus = ?,FCheckNumber =? \r\n");
        strSQL.append("Where ").append(pkFiled).append(" IN(").append(idString).append(")\t   \r\n");
        return strSQL.toString();
    }

    private String getSQLStringByVch(String pkFiled) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_GL_VoucherAssistRecord \t\t\r\n");
        strSQL.append("Set FReqCheckStatus =?, \t\t\t\t\r\n");
        strSQL.append("FCheckNumber = ? \t\t\t\t    \r\n");
        strSQL.append("Where ").append(pkFiled).append(" = ? \r\n");
        return strSQL.toString();
    }

    private void createRequistion(Context ctx, Map<String, Object> infoMap, ReqStatusEnum reqStatus) throws EASBizException, BOSException {
        RequisitionInfo req = new RequisitionInfo();
        req.setNumber(Uuid.create().toString());
        String reqNumber = "";
        String comNumber = infoMap.get("comNumber").toString();
        String vchTypeAndNumber = infoMap.get("vchType").toString() + infoMap.get("vchNumber").toString();
        int periodYear = Integer.valueOf(infoMap.get("periodYear").toString());
        int periodNumber = Integer.valueOf(infoMap.get("periodNumber").toString());
        int period = Integer.valueOf(infoMap.get("period").toString());
        int entrySeq = Integer.valueOf(infoMap.get("entrySeq").toString());
        int recordSeq = Integer.valueOf(infoMap.get("recordSeq").toString());
        String numberSql = " Select Fnumber from t_csl_Requisition where fnumber=?";
        do {
            reqNumber = comNumber + "-" + periodYear + GlUtils.formatNumber(periodNumber, 2) + "-" + vchTypeAndNumber + "-" + GlUtils.formatNumber(entrySeq, 2) + GlUtils.formatNumber(recordSeq++, 2);
            if (recordSeq <= 99) continue;
            ++entrySeq;
            recordSeq = 1;
        } while (AcNoticeUtil.isExistReqNumber(ctx, reqNumber, numberSql));
        CompanyOrgUnitInfo srcCom = new CompanyOrgUnitInfo();
        srcCom.setId(BOSUuid.read((String)infoMap.get("srcCompanyId").toString()));
        req.setSrcCompany(srcCom);
        CompanyOrgUnitInfo com = new CompanyOrgUnitInfo();
        com.setId(BOSUuid.read((String)infoMap.get("companyId").toString()));
        req.setCompany(com);
        req.setPeriod(Integer.valueOf(infoMap.get("period").toString()));
        VoucherInfo vch = new VoucherInfo();
        vch.setId(BOSUuid.read((String)infoMap.get("vchID").toString()));
        vch.setNumber(vchTypeAndNumber);
        vch.setLastUpdateTime((Timestamp)infoMap.get("lastUpdateTime"));
        req.setVchNumber(vch.getNumber());
        req.setNumber(reqNumber);
        req.setFiVouchered(false);
        req.setVoucher(vch);
        String acctId = infoMap.get("accountID").toString();
        String curId = infoMap.get("currencyID").toString();
        EntryDC dc = EntryDC.getEnum((int)Integer.valueOf(infoMap.get("dc").toString()));
        BigDecimal amount = (BigDecimal)infoMap.get("amount");
        RequisitionEntryInfo e = new RequisitionEntryInfo();
        req.getRequisitionEntry().add(e);
        e.setRequisition(req);
        e.setLineNo(1);
        AccountViewInfo acct = new AccountViewInfo();
        e.setAccount(acct);
        acct.setId(BOSUuid.read((String)acctId));
        CurrencyInfo cur = new CurrencyInfo();
        e.setCurrency(cur);
        cur.setId(BOSUuid.read((String)curId));
        e.setDc(dc);
        e.setOriginalAmount(amount);
        e.setStatus(reqStatus);
        VoucherAssistRecordInfo as = new VoucherAssistRecordInfo();
        as.setId(BOSUuid.read((String)infoMap.get("recID").toString()));
        e.setAssistRecord(as);
        String recDesc = infoMap.get("recDesc").toString();
        if (recDesc != null && recDesc.length() > 255) {
            recDesc = recDesc.substring(0, 255) + suffix;
        }
        e.setSummary(recDesc);
        e.setCheckNumber(infoMap.get("checkNumber").toString());
        e.setCheckVchNumber(infoMap.get("checkVchNubmer").toString());
        RequisitionFactory.getLocalInstance(ctx).submit((CoreBaseInfo)req);
    }

    private String getSqlInStr(int count) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                sb.append("?");
                continue;
            }
            sb.append(",?");
        }
        return sb.toString();
    }

    private String optionalNullString(String value) {
        return value == null ? "" : value;
    }

    private BigDecimal optionalNullBigDecimal(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    private void checkAssistRecord(Context ctx, Map src, Map target, String checkNumber) throws BOSException, EASBizException {
        String pkFiled = "FID";
        if (src.size() != 0 && src.containsKey(VoucherCheckInfo.class.getName())) {
            Object[] vs = new Object[]{new Integer(2), checkNumber};
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByVch(pkFiled, src.get("id").toString()), (Object[])vs);
        }
        if (target.size() != 0 && target.containsKey(VoucherCheckInfo.class.getName())) {
            String idStr = target.get("id").toString();
            Object[] vs = new Object[]{new Integer(2), checkNumber};
            DbUtil.execute((Context)ctx, (String)this.getSQLStringByVch(pkFiled, idStr), (Object[])vs);
            this.sendRequistion(ctx, src, checkNumber, idStr);
        }
    }

    private void sendRequistion(Context ctx, Map src, String checkNumber, String idStr) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuilder existReqSql = new StringBuilder();
            existReqSql.append("select FAssistRecordID from T_CSL_RequisitionEntry where FAssistRecordID in(").append(idStr).append(")");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)existReqSql.toString());
            try {
                idStr = idStr.replace("'", "");
                ArrayList<String> vchAsstIdList = new ArrayList<String>(Arrays.asList(idStr.split(",")));
                while (result.next()) {
                    vchAsstIdList.remove(result.getString(1));
                }
                if (vchAsstIdList.size() > 0) {
                    String checkVchNubmer = src.get("voucher.number") != null ? src.get("voucher.number").toString() : "";
                    String filterSql = this.getSqlInStr(vchAsstIdList.size());
                    existReqSql.setLength(0);
                    String lang = ctx.getLocale().getLanguage();
                    existReqSql.append("select vch.FID vchID,com.fid srcCompanyId,com.fnumber comNumber, vchType.FName_").append(lang).append(" vchType, \n");
                    existReqSql.append("vch.FNumber vchNumber, pd.fperiodYear periodYear,pd.fperiodNumber periodNumber,pd.fnumber period, \n");
                    existReqSql.append("ve.faccountid accountID, ve.FCurrencyID currencyID, \n");
                    existReqSql.append("ve.FEntryDC dc,ve.fSeq entrySeq, \n");
                    existReqSql.append("isnull(assGrp.FCompanyOrgID, isnull(customer.FInternalCompanyID, supplier.FInternalCompanyID)) companyId, \n");
                    existReqSql.append("vchAsst.FOriginalAmount amount, vchAsst.FID recID, vchAsst.FDescription recDesc,vchAsst.fSeq recordSeq, vch.FlastUpdateTime lastUpdateTime \n");
                    existReqSql.append(" from t_gl_voucher vch  inner join T_GL_VoucherEntry ve on vch.fid = ve.fbillid inner join T_GL_VoucherAssistRecord vchAsst on ve.fid = vchAsst.FEntryID  inner join T_BD_VoucherTypes vchType on vch.FVoucherTypeID = vchType.FID  inner join T_BD_Period pd on vch.FPeriodID = pd.FID  inner join T_Org_Company com on vch.FCompanyId = com.FID  join T_BD_AssistantHG assGrp  on vchAsst.FAssGrpID = assGrp.FID  left join T_BD_Customer customer on assGrp.FCustomerID = customer.FID  left join T_BD_Supplier supplier on assGrp.FProviderID = supplier.FID  where vchAsst.fid in(").append(filterSql).append(")");
                    IRowSet queryResult = DbUtil.executeQuery((Context)ctx, (String)existReqSql.toString(), (Object[])vchAsstIdList.toArray());
                    while (queryResult.next()) {
                        HashMap<String, Object> reqInfo = new HashMap<String, Object>();
                        reqInfo.put("vchID", this.optionalNullString(queryResult.getString("vchID")));
                        reqInfo.put("srcCompanyId", this.optionalNullString(queryResult.getString("srcCompanyId")));
                        reqInfo.put("comNumber", this.optionalNullString(queryResult.getString("comNumber")));
                        reqInfo.put("vchNumber", this.optionalNullString(queryResult.getString("vchNumber")));
                        reqInfo.put("vchType", this.optionalNullString(queryResult.getString("vchType")));
                        reqInfo.put("periodYear", queryResult.getInt("periodYear"));
                        reqInfo.put("periodNumber", queryResult.getInt("periodNumber"));
                        reqInfo.put("period", queryResult.getInt("period"));
                        reqInfo.put("accountID", this.optionalNullString(queryResult.getString("accountID")));
                        reqInfo.put("currencyID", this.optionalNullString(queryResult.getString("currencyID")));
                        reqInfo.put("dc", queryResult.getInt("dc"));
                        reqInfo.put("entrySeq", queryResult.getInt("entrySeq"));
                        reqInfo.put("amount", this.optionalNullBigDecimal(queryResult.getBigDecimal("amount")));
                        reqInfo.put("recID", this.optionalNullString(queryResult.getString("recID")));
                        reqInfo.put("recDesc", this.optionalNullString(queryResult.getString("recDesc")));
                        reqInfo.put("recordSeq", queryResult.getInt("recordSeq"));
                        reqInfo.put("lastUpdateTime", queryResult.getTimestamp("lastUpdateTime"));
                        reqInfo.put("checkVchNubmer", checkVchNubmer);
                        reqInfo.put("checkNumber", checkNumber);
                        reqInfo.put("companyId", this.optionalNullString(queryResult.getString("companyId")));
                        this.createRequistion(ctx, reqInfo, ReqStatusEnum.CHECKED);
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"query requistion info exception.", (Throwable)e);
                throw new BOSException("query requistion info exception.");
            }
        }
    }

    private Map putCheckInfo(Collection checkViews) {
        HashMap chkInfo = new HashMap();
        chkInfo.put(RequisitionCheckInfo.class.getName(), new HashMap());
        chkInfo.put(VoucherCheckInfo.class.getName(), new HashMap());
        CheckViewInfo o2 = null;
        for (CheckViewInfo o2 : checkViews) {
            o2.putCheckInfo(chkInfo);
        }
        Map req = this.getCheckInfoByReq(chkInfo);
        Map vch = this.getCheckInfoByVch(chkInfo);
        if (req.size() == 0) {
            vch.put(VoucherCheckInfo.class.getName(), VoucherCheckInfo.class.getName());
        } else {
            req.put(RequisitionCheckInfo.class.getName(), RequisitionCheckInfo.class.getName());
        }
        return req.size() == 0 ? vch : req;
    }

    private Map getCheckInfoByReq(Map info) {
        Map reqChkInfo = (Map)info.get(RequisitionCheckInfo.class.getName());
        if (reqChkInfo.size() != 0) {
            StringBuffer assistIdString;
            StringBuffer vchNumber;
            StringBuffer idString = (StringBuffer)reqChkInfo.get("id");
            if (idString != null && idString.length() != 0) {
                idString.deleteCharAt(0);
            }
            if ((vchNumber = (StringBuffer)reqChkInfo.get("voucher.number")) != null && vchNumber.length() != 0) {
                vchNumber.deleteCharAt(0);
            }
            if ((assistIdString = (StringBuffer)reqChkInfo.get("assistrecord.id")) != null && assistIdString.length() != 0) {
                assistIdString.deleteCharAt(0);
            }
            reqChkInfo.put("id", idString.toString());
            reqChkInfo.put("voucher.number", vchNumber.toString());
            reqChkInfo.put("assistrecord.id", assistIdString.toString());
        }
        return reqChkInfo;
    }

    private Map getCheckInfoByVch(Map info) {
        Map vchChkInfo = (Map)info.get(VoucherCheckInfo.class.getName());
        if (vchChkInfo.size() != 0) {
            StringBuffer vchNumber;
            StringBuffer idString = (StringBuffer)vchChkInfo.get("id");
            if (idString != null && idString.length() != 0) {
                idString.deleteCharAt(0);
            }
            if ((vchNumber = (StringBuffer)vchChkInfo.get("voucher.number")) != null && vchNumber.length() != 0) {
                vchNumber.deleteCharAt(0);
            }
            vchChkInfo.put("id", idString.toString());
            vchChkInfo.put("voucher.number", vchNumber.toString());
        }
        return vchChkInfo;
    }

    private void checkCanCnacel(Context ctx, Collection checkViews) throws EASBizException {
        CheckViewInfo checkView2 = null;
        StringBuffer reqList = new StringBuffer();
        for (CheckViewInfo checkView2 : checkViews) {
            if (checkView2.getPropertyValueBykey("requisition.id") == null) continue;
            String reqID = checkView2.getPropertyValueBykey("requisition.id").toString();
            if (reqList.length() > 0) {
                reqList.append(",");
            }
            reqList.append("'").append(reqID).append("'");
        }
        if (reqList.length() == 0) {
            return;
        }
        StringBuffer sqlVoucher = new StringBuffer();
        sqlVoucher.append("select voucher.fid fvoucherid, voucher.fbizstatus, voucher.fischeck, req.fid frequisitionid, \r\n");
        sqlVoucher.append("req.fnumber frequisitionnumber \r\n");
        sqlVoucher.append("from t_csl_requisition req \r\n");
        sqlVoucher.append("inner join t_bot_relation botp on botp.fsrcobjectid = req.fid \r\n");
        sqlVoucher.append("inner join t_gl_voucher voucher on voucher.fid = botp.fdestobjectid \r\n");
        sqlVoucher.append("where req.fid in (").append(reqList.toString()).append(")");
        sqlVoucher.append(" and req.ffivouchered = 1 \r\n");
        try {
            StringBuffer vchCheckedMsg = new StringBuffer();
            StringBuffer vchAuditedMsg = new StringBuffer();
            StringBuffer vchPostedMsg = new StringBuffer();
            HashMap<String, String> vchDeleteMap = new HashMap<String, String>();
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlVoucher.toString());
            while (set != null && set.next()) {
                if (set.getBoolean("fischeck") && set.getString("frequisitionnumber") != null) {
                    if (vchCheckedMsg.length() > 0) {
                        vchCheckedMsg.append(",");
                    }
                    vchCheckedMsg.append(set.getString("frequisitionnumber").toString());
                    continue;
                }
                if (set.getInt("fbizstatus") == 3 && set.getString("frequisitionnumber") != null) {
                    if (vchAuditedMsg.length() > 0) {
                        vchAuditedMsg.append(",");
                    }
                    vchAuditedMsg.append(set.getString("frequisitionnumber").toString());
                    continue;
                }
                if (set.getInt("fbizstatus") == 5 && set.getString("frequisitionnumber") != null) {
                    if (vchPostedMsg.length() > 0) {
                        vchPostedMsg.append(",");
                    }
                    vchPostedMsg.append(set.getString("frequisitionnumber").toString());
                    continue;
                }
                if (set.getString("fvoucherid") == null || set.getString("frequisitionnumber") == null || vchDeleteMap.containsKey(set.getString("fvoucherid").toString())) continue;
                vchDeleteMap.put(set.getString("fvoucherid").toString(), set.getString("frequisitionnumber").toString());
            }
            if (vchCheckedMsg.length() > 0) {
                throw new RequisitionException(RequisitionException.REQVCHCHECKED, new String[]{vchCheckedMsg.toString()});
            }
            if (vchPostedMsg.length() > 0) {
                throw new RequisitionException(RequisitionException.REQVCHPOSTTED, new String[]{vchPostedMsg.toString()});
            }
            if (vchAuditedMsg.length() > 0) {
                throw new RequisitionException(RequisitionException.REQVCHAUDITED, new String[]{vchAuditedMsg.toString()});
            }
            VoucherOprateSharer vchLocker = new VoucherOprateSharer(ctx);
            IAcctCussentHistoryFacade iACHistory = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx);
            StringBuffer vchVerifieddMsg = new StringBuffer();
            Iterator vchIt = vchDeleteMap.entrySet().iterator();
            while (vchIt != null && vchIt.hasNext()) {
                String vchID = vchIt.next().getKey().toString();
                vchLocker.lockVoucher(ctx, vchID);
                if (!iACHistory.hasVerify(vchID)) continue;
                if (vchVerifieddMsg.length() > 0) {
                    vchVerifieddMsg.append(",");
                }
                vchVerifieddMsg.append(vchDeleteMap.get(vchID).toString());
                vchDeleteMap.remove(vchID);
            }
            if (vchVerifieddMsg.length() > 0) {
                throw new RequisitionException(RequisitionException.REQVCHVERIFIED, new String[]{vchVerifieddMsg.toString()});
            }
            Iterator it = vchDeleteMap.entrySet().iterator();
            IVoucher iVoucher = null;
            while (it.hasNext()) {
                if (iVoucher == null) {
                    iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
                }
                iVoucher.delete((IObjectPK)new ObjectUuidPK(it.next().getKey().toString()));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    private void cancel_Check(Context ctx, Collection checkViews) throws BOSException, EASBizException {
        if (checkViews == null || checkViews.size() == 0) {
            return;
        }
        this.checkCanCnacel(ctx, checkViews);
        CheckViewInfo o2 = null;
        int index = 0;
        StringBuffer checkNumber = new StringBuffer();
        StringBuilder logDetail = new StringBuilder();
        for (CheckViewInfo o2 : checkViews) {
            String reqNumber;
            if (index != 0 && checkNumber.length() != 0 && o2.getCheckNumber() != null) {
                checkNumber.append(",");
                logDetail.append(",");
            }
            if (o2.getCheckNumber() != null) {
                checkNumber.append("'").append(o2.getCheckNumber().toString()).append("'");
            }
            if ((reqNumber = (String)o2.getPropertyValueBykey("requisition.number")) != null) {
                logDetail.append(reqNumber);
            }
            ++index;
        }
        if (checkNumber.length() == 0) {
            return;
        }
        IObjectPK logPk = null;
        if (logDetail.length() > 0) {
            logPk = LogUtil.beginLog((Context)ctx, (String)"cancelCheck", (BOSObjectType)RequisitionCheckFactory.getLocalInstance(ctx).getType(), null, (String)logDetail.toString(), (String)"gl_req_unvalidate");
        }
        String pkFiled = TABLE_FIELD_CHECKNUMBER;
        Connection cn = null;
        PreparedStatement pst = null;
        try {
            cn = super.getConnection(ctx);
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)("select e.fassistrecordid,r.FVOUCHERID from t_csl_requisitionentry e inner join t_csl_requisition r on E.FREQUISITIONID = R.FID where e.FCheckNumber in(" + checkNumber.toString() + ")"));
            ArrayList<String> vchIds = new ArrayList<String>();
            StringBuffer vchRd = new StringBuffer();
            while (set != null && set.next()) {
                String vchRdId = set.getString("fassistrecordid");
                if (vchRd.length() > 0) {
                    vchRd.append(",");
                }
                vchRd.append("'").append(vchRdId).append("'");
                if (vchIds.contains(set.getString("FVOUCHERID"))) continue;
                vchIds.add(set.getString("FVOUCHERID"));
            }
            if (vchIds == null || vchIds.size() == 0) {
                throw new RequisitionException(RequisitionException.BILL_NOT_EXIST);
            }
            String ids = SQLUtil.collection2InList(vchIds);
            DbUtil.execute((Context)ctx, (String)("update t_gl_voucher set flastupdatetime = ? where fid in " + ids), (Object[])new Object[]{GlUtils.getTime()});
            if (vchRd != null && vchRd.length() > 0) {
                StringBuffer strSQL = new StringBuffer();
                strSQL.append("Update T_GL_VoucherAssistRecord Set FReqCheckStatus = ?,FCheckNumber =? \r\n");
                strSQL.append("Where FId IN(").append(vchRd.toString()).append(")\t   \r\n");
                index = 1;
                pst = cn.prepareStatement(strSQL.toString());
                pst.setInt(index++, 1);
                pst.setNull(index++, 1);
                pst.execute();
            }
            index = 1;
            pst = cn.prepareStatement(this.getSQLStringByReq(pkFiled, checkNumber.toString()));
            pst.setInt(index++, 1);
            pst.setNull(index++, 1);
            pst.setNull(index++, 12);
            pst.execute();
            index = 1;
            pst = cn.prepareStatement(this.getSQLStringByVch(pkFiled, checkNumber.toString()));
            pst.setInt(index++, 1);
            pst.setNull(index++, 1);
            pst.execute();
            if (logPk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)cn);
    }

    private void clear_ReqRelation(Context ctx, String vchIds, boolean clearAll) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("update t_csl_requisition set flastupdatetime=flastupdatetime where fvoucherid in (" + vchIds + ")"));
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select a.FID As ReqID,b.FID As ReqEntryID \r\n");
        strSQL.append("From T_CSL_Requisition a \r\n");
        strSQL.append("inner join T_CSL_RequisitionEntry b on a.fid=b.frequisitionid \r\n");
        strSQL.append("Where a.FVoucherId in (").append(vchIds + ")").append(" and b.FStatus = ? \r\n");
        try {
            if (clearAll) {
                Object[] os = new Object[]{new Integer(2)};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])os);
                if (rs != null && rs.next()) {
                    throw new RequisitionException(RequisitionException.REQISCHECKEDBYSTORE);
                }
            }
            StringBuffer reqIdString = new StringBuffer();
            StringBuffer reqEntryIdString = new StringBuffer();
            int index = 0;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{new Integer(1)});
            HashMap<String, String> reqIds = new HashMap<String, String>();
            while (rs.next()) {
                if (index != 0) {
                    reqIdString.append(",");
                    reqEntryIdString.append(",");
                }
                reqIdString.append("'").append(rs.getString("ReqID")).append("'");
                reqEntryIdString.append("'").append(rs.getString("ReqEntryID")).append("'");
                if (!reqIds.containsKey(rs.getString("ReqID"))) {
                    reqIds.put(rs.getString("ReqID"), rs.getString("ReqEntryID"));
                }
                ++index;
            }
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            String requisitionId = null;
            if (reqIds != null && reqIds.size() != 0) {
                Iterator it = reqIds.keySet().iterator();
                while (it.hasNext()) {
                    requisitionId = it.next().toString();
                    if (requisitionId == null || requisitionId.length() == 0) continue;
                    this.callbackReqCheckTask((IEnactmentService)service, requisitionId);
                }
            }
            if (reqEntryIdString.length() != 0) {
                DbUtil.execute((Context)ctx, (String)("Delete From T_CSL_RequisitionEntry Where FID IN (" + reqEntryIdString.toString() + ")"));
            }
            if (reqIdString.length() != 0) {
                DbUtil.execute((Context)ctx, (String)("Delete From T_CSL_Requisition Where FID IN (" + reqIdString.toString() + ")"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void callbackReqCheckTask(IEnactmentService service, String bizObjId) throws WfException {
        if (service == null || bizObjId == null) {
            return;
        }
        ProcessInstInfo[] procInstArray = service.getProcessInstanceByHoldedObjectId(bizObjId);
        for (int i = 0; i < procInstArray.length; ++i) {
            String procInstId = procInstArray[i].getProcInstId();
            String state = procInstArray[i].getState();
            if (!state.startsWith("open")) continue;
            service.abortProcessInst(procInstId);
        }
    }

    protected void modifySql(StringBuffer sql, StringBuffer where) {
    }

    private void auto_CheckReqByReq(Context ctx, ReqCheckCondition condition) throws EASBizException, BOSException {
        ReqCheckType reqCheckType = condition.getReqCheckType();
        CheckSchemeParam checkSchemeParam = condition.getCheckSchemeParam();
        boolean bizNumberSame = checkSchemeParam == null ? false : checkSchemeParam.isSameBizNumber();
        Connection cn = super.getConnection(ctx);
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select b.FID as FSrcRequisitionEntryID, \t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t    a.FID as FSrcRequisitionID, \t\t\t\t\t\t\t\t\t\t    \r\n");
        strSQL.append("   \tb.FAssistRecordID As FSrcAssistRecordID,\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \td.FID as FTargRequisitionEntryID,\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \tc.FID as FTargRequisitionID,\t\t\t\t\t\t\t\t\t\t    \r\n");
        strSQL.append("   \td.FAssistRecordID As FTargAssistRecordID,\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \ta.FVOUCHERID as FSrcVchID,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \tc.FVOUCHERID as FTargVchID,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \ta.FVchNumber as FSrcVchNumber,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \tc.FVchNumber as FTargVchNumber,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("   \tnewBosID('5C45F8FF') as FCheckNumber\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("From T_CSL_Requisition a,\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("  \tT_CSL_RequisitionEntry b,\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append(" \tT_CSL_Requisition c,\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append(" \tT_CSL_RequisitionEntry d\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (reqCheckType == ReqCheckType.DIFFCY) {
            strSQL.append(",t_org_company srcOrg");
            strSQL.append(",t_org_company targOrg");
        }
        if (reqCheckType == ReqCheckType.DIFFCY || bizNumberSame) {
            strSQL.append(",t_gl_voucherassistrecord srcAssist");
            strSQL.append(",t_gl_voucherassistrecord targAssist");
        }
        if (condition != null && (condition.getAccount() != null || condition.getAcctNumForRecive() != null)) {
            strSQL.append(",T_BD_ACCOUNTVIEW e\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            strSQL.append(",T_BD_ACCOUNTVIEW f\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        }
        StringBuffer strSQL2 = new StringBuffer();
        strSQL2.append("        where \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL2.append("\t\ta.FID = b.FRequisitionID \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL2.append("\t\tAnd c.FID = d.FRequisitionID \t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL2.append("\t\tAnd b.FStatus = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL2.append("\t\tAnd d.FStatus = b.FStatus \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL2.append("\t\tAnd a.FSrcCompanyID = c.FTargCompanyID  \t\t\t\t\t\t\t\t\r\n");
        strSQL2.append("\t\tAnd a.FTargCompanyID = c.FSrcCompanyID \t\t\t\t\t\t\t\t\t\r\n");
        if (reqCheckType == ReqCheckType.DIFFCY) {
            strSQL2.append("\t\tAnd a.FSrcCompanyID = srcOrg.FID \t\t\t\t\t\t\t\t\t\r\n");
            strSQL2.append("\t\tAnd a.FTargCompanyID = targOrg.FID \t\t\t\t\t\t\t\t\t\r\n");
            strSQL2.append("\t\tAnd srcOrg.FBaseCurrencyID = targOrg.FBaseCurrencyID      \t\t\t\r\n");
            strSQL2.append("\t\tAnd b.FCurrencyID <> d.FCurrencyID       \t\t\t                \r\n");
        } else {
            strSQL2.append("\t\tAnd b.FCurrencyID = d.FCurrencyID \t\t\t\t\t\t\t\t\t\t\r\n");
        }
        if (reqCheckType == ReqCheckType.DIFFCY || bizNumberSame) {
            strSQL2.append("\t\tAnd b.FAssistRecordID = srcAssist.FID \t\t\t\t\t\t\t\t\t\r\n");
            strSQL2.append("\t\tAnd d.FAssistRecordID = targAssist.FID \t\t\t\t\t\t\t\t\t\r\n");
        }
        if (condition != null && (condition.getAccount() != null || condition.getAcctNumForRecive() != null)) {
            strSQL2.append("\t\tAnd b.FACCOUNTID = e.fid\t\t\t\t\t\t\t\t\t\t\r\n");
            strSQL2.append("\t\tAnd d.FACCOUNTID = f.fid\t\t\t\t\t\t\t\t\t\t\r\n");
        }
        if (reqCheckType == ReqCheckType.DIFFCY) {
            strSQL2.append("\t\tAnd ( (srcAssist.FLOCALAMOUNT = targAssist.FLOCALAMOUNT And  b.FDc <> d.FDc ) \t\t\r\n");
            strSQL2.append("\t\tOr    (srcAssist.FLOCALAMOUNT = targAssist.FLOCALAMOUNT * -1 And b.FDc = d.FDc))\t\r\n");
        } else {
            strSQL2.append("\t\tAnd ( (b.FOriginalAmount = d.FOriginalAmount And  b.FDc <> d.FDc ) \t\t\r\n");
            strSQL2.append("\t\tOr    (b.FOriginalAmount = d.FOriginalAmount * -1 And b.FDc = d.FDc))\t\r\n");
        }
        if (bizNumberSame) {
            strSQL2.append(" and ((srcAssist.FBizNumber is null and targAssist.FBizNumber is null) or (srcAssist.FBizNumber = targAssist.fbizNumber))");
        }
        this.modifySql(strSQL, strSQL2);
        ArrayList<Object> vs = new ArrayList<Object>();
        vs.add(new Integer(1));
        if (condition != null) {
            if (condition.getCompany() != null) {
                strSQL2.append(" \tAnd a.FSrcCompanyID =? \t\t\t\t\t\t\t\t\t\t\t\r\n");
                vs.add(condition.getCompany().getId().toString());
            }
            if (condition.getTargCompany() != null) {
                strSQL2.append(" \tAnd a.FTargCompanyID =? \t\t\t\t\t\t\t\t\t\t\r\n");
                vs.add(condition.getTargCompany().getId().toString());
            }
            if (condition.getCurrency() != null) {
                strSQL2.append(" \tAnd b.FCurrencyID =? \t\t\t\t\t\t\t\t\t\t\t\r\n");
                vs.add(condition.getCurrency().getId().toString());
            }
            if (condition.getAccount() != null) {
                AccountViewInfo account = condition.getAccount();
                String accountNumber = account.getNumber();
                strSQL2.append(" and e.fnumber = ? \r\n");
                vs.add(accountNumber);
            }
            if (condition.getAcctNumForRecive() != null) {
                strSQL2.append(" and f.fnumber = ? \r\n");
                vs.add(condition.getAcctNumForRecive());
            }
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            String curCompanyID = condition.getCompany() != null ? condition.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curCompanyID));
            hmParamIn.put("GL_026", comPK);
            boolean isAllowUnConfirm = true;
            try {
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
                isAllowUnConfirm = Integer.valueOf(hmAllParam.get("GL_026").toString()) == 2;
            }
            catch (EASBizException ex) {
                throw new BOSException((Throwable)ex);
            }
            if (condition.getVoucherID() != null) {
                String[] reqEntryIds;
                String[] ids = condition.getVoucherID().split(",");
                if (ids.length != 0) {
                    strSQL2.append(" \tAnd ").append(ServerHelper.getOrString(ids, "srcvoucher", "FID", vs));
                }
                if (condition.getRequisitionId() != null && (reqEntryIds = condition.getRequisitionId().split(",")).length != 0) {
                    strSQL2.append(" and ").append(ServerHelper.getOrString(reqEntryIds, "d", "fid", vs));
                }
                strSQL.append(" ,t_gl_voucher srcvoucher ,   \r\n");
                strSQL.append(" t_bd_period srcpi ,      \r\n");
                strSQL.append(" t_gl_voucher targvoucher ,   \r\n");
                strSQL.append(" t_bd_period targpi       \r\n");
                strSQL2.append("     AND srcvoucher.fid=a.FVoucherID   \r\n");
                strSQL2.append("     AND srcpi.fid=srcvoucher.fperiodid  \r\n");
                strSQL2.append("     AND targvoucher.fid=c.FVoucherID    \r\n");
                strSQL2.append("     AND targpi.fid=targvoucher.fperiodid  \r\n");
                strSQL.append(strSQL2);
            } else {
                int flag;
                if (!isAllowUnConfirm && !condition.isIncludeAvoid().booleanValue()) {
                    strSQL2.append("    And a.FIsAvoidCheck = 0 ");
                }
                if (((flag = condition.getFlag().intValue()) & 0x40) != 0) {
                    if (condition.getStartDate() != null) {
                        strSQL2.append(" \tAnd a.FCreateTime >= ? \t\t\t\t\t\t\t\t\t\t\t\r\n");
                        vs.add(Helper.getFilterDate(condition.getStartDate(), "startDate"));
                        strSQL2.append(" \tAnd c.FCreateTime >= ? \t\t\t\t\t\t\t\t\t\t\t\r\n");
                        vs.add(Helper.getFilterDate(condition.getStartDate(), "startDate"));
                    }
                    if (condition.getEndDate() != null) {
                        strSQL2.append(" \tAnd a.FCreateTime <= ? \t\t\t\t\t\t\t\t\t\t\t\r\n");
                        vs.add(Helper.getFilterDate(condition.getEndDate(), "endDate"));
                        strSQL2.append(" \tAnd c.FCreateTime <= ? \t\t\t\t\t\t\t\t\t\t\t\r\n");
                        vs.add(Helper.getFilterDate(condition.getEndDate(), "endDate"));
                    }
                    strSQL.append(strSQL2);
                } else {
                    Integer yearFrom = condition.getFromPiYear();
                    Integer periodFrom = condition.getFromPiNum();
                    Integer yearTo = condition.getToPiYear();
                    Integer periodTo = condition.getToPiNum();
                    if ((flag & 0x80) != 0) {
                        strSQL2.append("     And a.fperiod = ?         \r\n");
                        strSQL2.append("     And c.fperiod = ?         \r\n");
                        vs.add(new Integer(yearFrom * 100 + periodFrom));
                        vs.add(new Integer(yearFrom * 100 + periodFrom));
                        strSQL.append(strSQL2);
                    } else {
                        strSQL2.append("     And a.fperiod >= ?         \r\n");
                        strSQL2.append("     And a.fperiod <= ?         \r\n");
                        strSQL2.append("     And c.fperiod >= ?         \r\n");
                        strSQL2.append("     And c.fperiod <= ?         \r\n");
                        vs.add(new Integer(yearFrom * 100 + periodFrom));
                        vs.add(new Integer(yearTo * 100 + periodTo));
                        vs.add(new Integer(yearFrom * 100 + periodFrom));
                        vs.add(new Integer(yearTo * 100 + periodTo));
                        strSQL.append(strSQL2);
                    }
                }
            }
        }
        IRowSet rs = null;
        try {
            HashMap<String, String> pkM = new HashMap<String, String>();
            HashMap<String, String> srcReqEntrys = new HashMap<String, String>();
            String srcReqEntryId = null;
            HashMap<String, String> targetReqEntrys = new HashMap<String, String>();
            String targetReqEntryId = null;
            String pkFiled = "FID";
            StringBuffer sqlForTmp = new StringBuffer("select t.* into t_gl_requisitionchecktmp from (");
            sqlForTmp.append("select t1.FSrcRequisitionEntryID EntryID, t1.FSrcVchID VchID from ( \r\n");
            sqlForTmp.append(strSQL.toString()).append(") t1 \r\n");
            sqlForTmp.append("union all \r\n");
            sqlForTmp.append("select t2.FTargRequisitionEntryID EntryID,t2.FTargVchID VchID from ( \r\n");
            sqlForTmp.append(strSQL.toString()).append(") t2 )t \r\n");
            String acSumNewtempTable = "";
            try {
                SqlParams vsForUpdateAndCheck = new SqlParams();
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < vs.size(); ++j) {
                        vsForUpdateAndCheck.addObject(vs.get(j));
                    }
                }
                StringBuffer sqlForUpdate = new StringBuffer();
                sqlForUpdate.append("update T_CSL_RequisitionEntry set  Fsummary = Fsummary where fid in ( \r\n");
                acSumNewtempTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sqlForTmp.toString(), (SqlParams)vsForUpdateAndCheck, (Connection)cn).getTempTable();
                sqlForUpdate.append("select EntryID from ").append(acSumNewtempTable).append(") \r\n");
                DbUtil.execute((Context)ctx, (String)sqlForUpdate.toString(), (Object[])new Object[0]);
                StringBuffer sqlForUpdate1 = new StringBuffer();
                sqlForUpdate1.append("update t_gl_voucher set flastupdatetime = ? where fid in(select VchID from ").append(acSumNewtempTable).append(")");
                DbUtil.execute((Context)ctx, (String)sqlForUpdate1.toString(), (Object[])new Object[]{GlUtils.getTime()});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
            }
            StringBuffer sqlForCheck = new StringBuffer();
            sqlForCheck.append("select top 1 fid from T_CSL_RequisitionEntry where (FStatus = 2 or FCheckNumber is not null or FVchNumber is not null) and (fid in ( \r\n");
            sqlForCheck.append("select EntryID from ").append(acSumNewtempTable).append("))\r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlForCheck.toString(), (Object[])new Object[0]);
            if (rs.next()) {
                throw new RequisitionException(RequisitionException.BILL_PART_CHECKED2);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])vs.toArray());
            ArrayList<Object[]> updateByReqParams = new ArrayList<Object[]>();
            ArrayList<Object[]> updateAvoidParams = new ArrayList<Object[]>();
            ArrayList<Object[]> updateByVchParams = new ArrayList<Object[]>();
            while (rs.next()) {
                String srcReqId = rs.getString("FSrcRequisitionID");
                String targetReqId = rs.getString("FTargRequisitionID");
                srcReqEntryId = rs.getString(TABLE_FIELD_SRCREQENTRYID);
                targetReqEntryId = rs.getString(TABLE_FIELD_TARGREQENTRYID);
                if (srcReqEntrys.containsKey(srcReqEntryId) || targetReqEntrys.containsKey(targetReqEntryId)) continue;
                ObjectStringPK pk = new ObjectStringPK(srcReqId);
                if (!pkM.containsKey(srcReqId)) {
                    this.virtualSubmit(ctx, (IObjectPK)pk);
                    pkM.put(srcReqId, srcReqId);
                }
                pk = new ObjectStringPK(targetReqId);
                if (!pkM.containsKey(targetReqId)) {
                    this.virtualSubmit(ctx, (IObjectPK)pk);
                    pkM.put(targetReqId, targetReqId);
                }
                srcReqEntrys.put(srcReqEntryId, targetReqEntryId);
                srcReqEntrys.put(targetReqEntryId, srcReqEntryId);
                targetReqEntrys.put(srcReqEntryId, targetReqEntryId);
                targetReqEntrys.put(targetReqEntryId, srcReqEntryId);
                updateByReqParams.add(new Object[]{2, rs.getString(TABLE_FIELD_CHECKNUMBER), rs.getString(TABLE_FIELD_TARGVCHNUMBER), rs.getString(TABLE_FIELD_SRCREQENTRYID)});
                updateByReqParams.add(new Object[]{2, rs.getString(TABLE_FIELD_CHECKNUMBER), rs.getString(TABLE_FIELD_SRCVCHNUMBER), rs.getString(TABLE_FIELD_TARGREQENTRYID)});
                if (srcReqId != null) {
                    updateAvoidParams.add(new Object[]{srcReqId});
                }
                if (targetReqId != null) {
                    updateAvoidParams.add(new Object[]{srcReqId});
                }
                updateByVchParams.add(new Object[]{2, rs.getString(TABLE_FIELD_CHECKNUMBER), rs.getString(TABLE_FIELD_SRCASSISTID)});
                updateByVchParams.add(new Object[]{2, rs.getString(TABLE_FIELD_CHECKNUMBER), rs.getString(TABLE_FIELD_TARGASSISTID)});
            }
            if (updateByReqParams.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)this.getSQLStringByReq(pkFiled), updateByReqParams);
            }
            if (updateAvoidParams.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)this.getUpdateAvoidSQLByAutou(), updateAvoidParams);
            }
            if (updateByVchParams.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)this.getSQLStringByVch(pkFiled), updateByVchParams);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
    }

    private void auto_CheckReqByReqNew(Context ctx, ReqCheckCondition condition) throws EASBizException, BOSException {
        ReqCheckType reqCheckType = condition.getReqCheckType();
        CheckSchemeParam checkSchemeParam = condition.getCheckSchemeParam();
        boolean bizNumberSame = checkSchemeParam == null ? false : checkSchemeParam.isSameBizNumber();
        Connection cn = super.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T.FID RID, E.FID EID, E.FASSISTRECORDID SID, T.FVOUCHERID VID, T.FVCHNUMBER VCHNUM,E.FDC,  \r\n");
        sql.append(" CASE WHEN E.FORIGINALAMOUNT >= 0 THEN 1 ELSE -1 END OMT, newBosID('5C45F8FF') CHKNUM, #DIR, #PKSTR \r\n");
        sql.append(" FROM T_CSL_REQUISITION T \r\n");
        sql.append(" INNER JOIN T_CSL_REQUISITIONENTRY E ON T.FID = E.FREQUISITIONID \r\n");
        sql.append(" INNER JOIN T_BD_CURRENCY CUR ON CUR.FID = E.FCURRENCYID \r\n");
        sql.append(" INNER JOIN T_BD_ACCOUNTVIEW BD ON BD.FID = E.FACCOUNTID \r\n");
        if (reqCheckType == ReqCheckType.DIFFCY || bizNumberSame) {
            sql.append(" INNER JOIN t_gl_voucherassistrecord vchAsst ON vchAsst.FID = E.FAssistRecordID \r\n");
        }
        if (reqCheckType == ReqCheckType.DIFFCY) {
            sql.append(" INNER JOIN t_org_company org ON org.FID = T.FSrcCompanyID \r\n");
        }
        sql.append(" WHERE E.FSTATUS = 1 ");
        StringBuffer tsql = new StringBuffer(sql.toString());
        StringBuffer ksql = new StringBuffer();
        StringBuffer ktsql = new StringBuffer();
        if (reqCheckType == ReqCheckType.DIFFCY) {
            ksql.append(" T.FSRCCOMPANYID || T.FTARGCOMPANYID || org.FBaseCurrencyID || to_char(ABS(vchAsst.FLOCALAMOUNT)) ");
            ktsql.append(" T.FTARGCOMPANYID || T.FSRCCOMPANYID || org.FBaseCurrencyID || to_char(ABS(vchAsst.FLOCALAMOUNT)) ");
        } else {
            ksql.append(" T.FSRCCOMPANYID || T.FTARGCOMPANYID || E.FCURRENCYID || to_char(ABS(E.FORIGINALAMOUNT)) ");
            ktsql.append(" T.FTARGCOMPANYID || T.FSRCCOMPANYID || E.FCURRENCYID || to_char(ABS(E.FORIGINALAMOUNT)) ");
        }
        if (bizNumberSame) {
            ksql.append(" || isNull(vchAsst.FBizNumber,'')");
            ktsql.append(" || isNull(vchAsst.FBizNumber,'')");
        }
        ksql.append(" TKEY");
        ktsql.append(" TKEY");
        ArrayList<Object> vs = new ArrayList<Object>();
        ArrayList<Object> tVs = new ArrayList<Object>();
        boolean companyflg = false;
        if (condition != null) {
            int flag;
            if (condition.getCompany() != null) {
                sql.append(" And t.FSrcCompanyID =? \r\n");
                tsql.append(" And t.FTargCompanyID =? \r\n");
                String companyId = condition.getCompany().getId().toString();
                vs.add(companyId);
                tVs.add(companyId);
                companyflg = true;
            }
            if (condition.getTargCompany() != null) {
                sql.append(" And t.FTargCompanyID =? \r\n");
                tsql.append(" And t.FSrcCompanyID =? \r\n");
                String tCompanyId = condition.getTargCompany().getId().toString();
                vs.add(tCompanyId);
                tVs.add(tCompanyId);
            }
            if (condition.getAccount() != null) {
                sql.append(" and bd.fnumber = ? \r\n");
                vs.add(condition.getAccount().getNumber());
            }
            if (condition.getAcctNumForRecive() != null) {
                tsql.append(" and bd.fnumber = ? \r\n");
                tVs.add(condition.getAcctNumForRecive());
            }
            StringBuilder commonWhereSql = new StringBuilder();
            if (condition.getCurrency() != null) {
                commonWhereSql.append(" And E.FCurrencyID =? \r\n");
                String currencyId = condition.getCurrency().getId().toString();
                vs.add(currencyId);
                tVs.add(currencyId);
            }
            if (((flag = condition.getFlag().intValue()) & 0x40) != 0) {
                if (condition.getStartDate() != null) {
                    commonWhereSql.append(" \tAnd t.FCreateTime >= ? \r\n");
                    Timestamp startDate = Helper.getFilterDate(condition.getStartDate(), "startDate");
                    vs.add(startDate);
                    tVs.add(startDate);
                }
                if (condition.getEndDate() != null) {
                    commonWhereSql.append(" \tAnd t.FCreateTime <= ?  \r\n");
                    Timestamp endDate = Helper.getFilterDate(condition.getEndDate(), "endDate");
                    vs.add(endDate);
                    tVs.add(endDate);
                }
            } else {
                Integer fromPeriod;
                Integer yearFrom = condition.getFromPiYear();
                Integer periodFrom = condition.getFromPiNum();
                Integer yearTo = condition.getToPiYear();
                Integer periodTo = condition.getToPiNum();
                if ((flag & 0x80) != 0) {
                    commonWhereSql.append("     And t.fperiod = ? \r\n");
                    fromPeriod = new Integer(yearFrom * 100 + periodFrom);
                    vs.add(fromPeriod);
                    tVs.add(fromPeriod);
                } else {
                    commonWhereSql.append("     And t.fperiod >= ?  And t.fperiod <= ?  \r\n");
                    fromPeriod = new Integer(yearFrom * 100 + periodFrom);
                    Integer toPeriod = new Integer(yearTo * 100 + periodTo);
                    vs.add(fromPeriod);
                    vs.add(toPeriod);
                    tVs.add(fromPeriod);
                    tVs.add(toPeriod);
                }
            }
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            String curCompanyID = condition.getCompany() != null ? condition.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curCompanyID));
            hmParamIn.put("GL_026", comPK);
            boolean isAllowUnConfirm = true;
            try {
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
                isAllowUnConfirm = Integer.valueOf(hmAllParam.get("GL_026").toString()) == 2;
            }
            catch (EASBizException ex) {
                throw new BOSException((Throwable)ex);
            }
            if (!isAllowUnConfirm && !condition.isIncludeAvoid().booleanValue()) {
                commonWhereSql.append(" And t.FIsAvoidCheck = 0 ");
            }
            sql.append((CharSequence)commonWhereSql);
            tsql.append((CharSequence)commonWhereSql);
        }
        int idx = sql.indexOf("#PKSTR");
        if (companyflg) {
            sql.replace(idx, idx + 6, ksql.toString());
            tsql.replace(idx, idx + 6, ktsql.toString());
        } else {
            sql.replace(idx, idx + 6, ksql.toString());
        }
        idx = sql.indexOf("#DIR");
        if (companyflg) {
            sql.replace(idx, idx + 4, "N'S' DIR");
            tsql.replace(idx, idx + 4, "N'T' DIR");
        } else {
            sql.replace(idx, idx + 4, "N'S' DIR");
        }
        IRowSet rs = null;
        try {
            int j;
            this.stReq = cn.prepareStatement("UPDATE T_CSL_REQUISITIONENTRY SET FSTATUS = ?, FCHECKNUMBER = ? , FVCHNUMBER = ? WHERE FID = ? ");
            this.stAvoid = cn.prepareStatement("UPDATE T_CSL_REQUISITION SET FISAVOIDCHECK = 0 WHERE FID = ? ");
            this.stVch = cn.prepareStatement("UPDATE T_GL_VOUCHERASSISTRECORD SET FREQCHECKSTATUS = ?, FCHECKNUMBER = ? WHERE FID = ? ");
            StringBuffer insertSql = new StringBuffer("SELECT TT.* INTO REQ_TMP FROM (");
            if (companyflg) {
                insertSql.append(sql).append(" union all ").append(tsql.toString()).append(")TT ");
            } else {
                insertSql.append(sql).append(" )TT ");
            }
            SqlParams spp = new SqlParams();
            for (j = 0; j < vs.size(); ++j) {
                spp.addObject(vs.get(j));
            }
            if (companyflg) {
                for (j = 0; j < tVs.size(); ++j) {
                    spp.addObject(tVs.get(j));
                }
            }
            String req_tmp = "AAA";
            try {
                req_tmp = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)insertSql.toString(), (SqlParams)spp, (Connection)cn).getTempTable();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException(e.getMessage());
            }
            StringBuffer sqlForUpdate = new StringBuffer();
            sqlForUpdate.append("update T_CSL_RequisitionEntry set  Fsummary = Fsummary where fid in ( SELECT EID FROM ").append(req_tmp).append(")  ");
            DbUtil.execute((Context)ctx, (String)sqlForUpdate.toString());
            StringBuffer sqlForCheck = new StringBuffer();
            sqlForCheck.append("select top 1 fid from T_CSL_RequisitionEntry where (FStatus = 2 or FCheckNumber is not null or FVchNumber is not null) and fid in ( \r\n");
            sqlForCheck.append(" SELECT EID FROM ").append(req_tmp).append(") ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlForCheck.toString());
            if (rs.next()) {
                throw new RequisitionException(RequisitionException.BILL_PART_CHECKED2);
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append(" SELECT T1.* FROM ").append(req_tmp).append(" T1 ORDER BY T1.TKEY,T1.FDC, T1.OMT DESC ");
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            HashMap sMap = new HashMap();
            Map tmp = null;
            while (rs.next()) {
                ArrayList<String[]> list;
                String RID = rs.getString("RID");
                String EID = rs.getString("EID");
                String SID = rs.getString("SID");
                String CHKNUM = rs.getString("CHKNUM");
                String VCHNUM = rs.getString("VCHNUM");
                String DIR = rs.getString("DIR");
                String DC = rs.getString("FDC");
                String TKEY = rs.getString("TKEY");
                String OMT = rs.getString("OMT");
                if (sMap.containsKey(TKEY)) {
                    tmp = (Map)sMap.get(TKEY);
                    if (tmp.containsKey(DIR + DC)) {
                        ((List)tmp.get(DIR + DC)).add(new String[]{RID, EID, SID, CHKNUM, VCHNUM, OMT});
                        continue;
                    }
                    list = new ArrayList();
                    list.add(new String[]{RID, EID, SID, CHKNUM, VCHNUM, OMT});
                    tmp.put(DIR + DC, list);
                    continue;
                }
                tmp = new HashMap();
                list = new ArrayList<String[]>();
                list.add(new String[]{RID, EID, SID, CHKNUM, VCHNUM, OMT});
                tmp.put(DIR + DC, list);
                sMap.put(TKEY, tmp);
            }
            Iterator it = sMap.keySet().iterator();
            ArrayList<String[]> sclist = new ArrayList();
            ArrayList<String[]> tclist = new ArrayList();
            ArrayList<String[]> sdlist = new ArrayList();
            ArrayList<String[]> tdlist = new ArrayList();
            List<List<String[]>> stlist1 = null;
            List<List<String[]>> stlist2 = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                sclist = (List)((Map)sMap.get(key)).get("S0");
                tclist = (List)((Map)sMap.get(key)).get("T0");
                sdlist = (List)((Map)sMap.get(key)).get("S1");
                tdlist = (List)((Map)sMap.get(key)).get("T1");
                stlist1 = this.matchRecords(sclist, tdlist, true);
                stlist2 = this.matchRecords(sdlist, tclist, true);
                this.matchRecords(stlist1.get(0), stlist2.get(1), false);
                this.matchRecords(stlist2.get(0), stlist1.get(1), false);
            }
            this.stReq.executeBatch();
            this.stAvoid.executeBatch();
            this.stVch.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)this.stReq);
                SQLUtils.cleanup((Statement)this.stAvoid);
                SQLUtils.cleanup((Statement)this.stVch);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)this.stReq);
        SQLUtils.cleanup((Statement)this.stAvoid);
        SQLUtils.cleanup((Statement)this.stVch);
        SQLUtils.cleanup((Connection)cn);
    }

    private List<List<String[]>> matchRecords(List<String[]> slist, List<String[]> tlist, boolean sameomt) throws SQLException {
        int j;
        ArrayList<List<String[]>> result = new ArrayList<List<String[]>>();
        List<Object> snlist = new ArrayList();
        ArrayList<Object> tnlist = new ArrayList<Object>();
        List<Object> tmplist = new ArrayList();
        if (slist == null) {
            tmplist = tlist;
            if (tlist != null) {
                for (int t = tmplist.size() - 1; t >= 0; --t) {
                    tnlist.add(tmplist.get(t));
                }
            }
            result.add(snlist);
            result.add(tnlist);
            return result;
        }
        if (tlist == null) {
            snlist = slist;
            result.add(snlist);
            result.add(tnlist);
            return result;
        }
        int i = 0;
        String[] svals = null;
        String[] tvals = null;
        for (j = 0; i < slist.size() && j < tlist.size(); ++i, ++j) {
            svals = slist.get(i);
            tvals = tlist.get(j);
            if (sameomt) {
                if ("1".equals(svals[5])) {
                    if ("-1".equals(tvals[5])) {
                        --j;
                        snlist.add(svals);
                        continue;
                    }
                    this.excuteCheck(svals, tvals, true);
                    continue;
                }
                if ("1".equals(tvals[5])) {
                    --i;
                    tmplist.add(tvals);
                    continue;
                }
                this.excuteCheck(svals, tvals, true);
                continue;
            }
            if ("1".equals(svals[5])) {
                if ("1".equals(tvals[5])) {
                    --j;
                    continue;
                }
                this.excuteCheck(svals, tvals, true);
                continue;
            }
            if ("-1".equals(tvals[5])) {
                --i;
                continue;
            }
            this.excuteCheck(svals, tvals, true);
        }
        while (i < slist.size()) {
            snlist.add(slist.get(i));
            ++i;
        }
        while (j < tlist.size()) {
            tmplist.add(tlist.get(j));
            ++j;
        }
        for (int t = tmplist.size() - 1; t >= 0; --t) {
            tnlist.add(tmplist.get(t));
        }
        result.add(snlist);
        result.add(tnlist);
        return result;
    }

    private void excuteCheck(String[] svals, String[] tvals, boolean sameOmt) throws SQLException {
        this.stReq.setObject(1, 2);
        this.stReq.setObject(2, svals[3]);
        this.stReq.setObject(3, svals[4]);
        this.stReq.setObject(4, svals[1]);
        this.stReq.addBatch();
        this.stReq.setObject(1, 2);
        this.stReq.setObject(2, svals[3]);
        this.stReq.setObject(3, tvals[4]);
        this.stReq.setObject(4, tvals[1]);
        this.stReq.addBatch();
        if (svals[0] != null) {
            this.stAvoid.setObject(1, svals[0]);
            this.stAvoid.addBatch();
        }
        if (tvals[0] != null) {
            this.stAvoid.setObject(1, tvals[0]);
            this.stAvoid.addBatch();
        }
        this.stVch.setObject(1, 2);
        this.stVch.setObject(2, svals[3]);
        this.stVch.setObject(3, svals[2]);
        this.stVch.addBatch();
        this.stVch.setObject(1, 2);
        this.stVch.setObject(2, svals[3]);
        this.stVch.setObject(3, tvals[2]);
        this.stVch.addBatch();
    }

    private void checkReq_Coherence(Context ctx, String voucherID) throws BOSException, EASBizException {
        if (voucherID == null) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)"update t_csl_requisition set flastupdatetime=flastupdatetime where fvoucherid=?", (Object[])new Object[]{voucherID});
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("select count(req.fid) cnt from t_csl_requisition req \r\n");
        sqlSelect.append("inner join t_csl_requisitionentry reqe on req.fid=reqe.frequisitionid \r\n");
        sqlSelect.append("where req.fvoucherid=? and reqe.fstatus=2 \r\n");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString(), (Object[])new Object[]{voucherID});
            rs.next();
            if (rs.getInt(1) > 0) {
                throw new RequisitionException(RequisitionException.REQISCHECKEDBYSTORE);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void check_ReqCoherenceBatch(Context ctx, String companyID, String periodID) throws BOSException, EASBizException {
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update t_csl_requisition set flastupdatetime=flastupdatetime where fvoucherid in ( \r\n");
        sqlUpdate.append("  select fid from t_gl_voucher v \r\n");
        sqlUpdate.append("  where v.fcompanyid=? and v.fperiodid=? \r\n");
        sqlUpdate.append(")\r\n");
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])new Object[]{companyID, periodID});
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("select count(req.fid) cnt from t_csl_requisition req \r\n");
        sqlSelect.append("inner join t_csl_requisitionentry reqe on req.fid=reqe.frequisitionid \r\n");
        sqlSelect.append("inner join t_gl_voucher v on v.fid=req.fvoucherid \r\n");
        sqlSelect.append("where v.fcompanyid=? and v.fperiodid=? and reqe.fstatus=2 \r\n");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString(), (Object[])new Object[]{companyID, periodID});
            rs.next();
            if (rs.getInt(1) > 0) {
                throw new RequisitionException(RequisitionException.REQISCHECKED);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private Object[] get_ReqIdForCheckVoucher(Context ctx, ReqCheckCondition condition) throws BOSException {
        ArrayList ps = new ArrayList();
        ArrayList<String> rsIDList = new ArrayList<String>();
        StringBuffer strPreSQL = new StringBuffer();
        strPreSQL.append("Select distinct reqE.FID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strPreSQL.append("From (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strPreSQL.append(this.getSQLStringForCheckVoucher(ctx, ps));
        String ids = condition.getVoucherID();
        if (ids != null && ids.length() != 0) {
            String[] vchIds = ids.split(",");
            int size = vchIds.length;
            for (int i = 0; i < size; i += 100) {
                StringBuffer strSuffSQL = new StringBuffer();
                ArrayList<Object> tepBaseParams = new ArrayList<Object>(ps);
                int j = 0;
                StringBuffer sf = new StringBuffer("");
                while (100 - j++ > 0 && i < size) {
                    if (j > 1) {
                        sf.append(",");
                    }
                    sf.append("?");
                    tepBaseParams.add(vchIds[i]);
                    ++i;
                }
                strSuffSQL.append("\t\t\tAnd vch.FID IN(").append(sf.toString()).append(") \t\t\t\t\t\t\t\t\t\t\r\n");
                if (condition.getCompany() != null) {
                    strSuffSQL.append("\t\t\tAnd vch.FCompanyID = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                    tepBaseParams.add(condition.getCompany().getId().toString());
                }
                if (condition.getPeriodID() != null) {
                    strSuffSQL.append("\t\t\tAnd vch.FPeriodID = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                    tepBaseParams.add(condition.getPeriodID());
                }
                strSuffSQL.append("\t\t) vch, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tT_CSL_Requisition req, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tT_CSL_RequisitionEntry reqE \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("where req.FID = reqE.FRequisitionID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tAnd reqE.FStatus = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tAnd vch.FSrcCompanyID = req.FTargCompanyID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tAnd vch.FTargCompanyID = req.FSrcCompanyID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tAnd vch.FCurrencyID = reqE.FCurrencyID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tAnd ( (vch.FOriginalAmount = reqE.FOriginalAmount And  vch.FDc <> reqE.FDc ) \t\t\t\t\t\r\n");
                strSuffSQL.append("\t\tOr    (vch.FOriginalAmount = reqE.FOriginalAmount * -1 And vch.FDc = reqE.FDc)) \t\t\t\t\r\n");
                tepBaseParams.add(new Integer(1));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(strPreSQL.toString() + strSuffSQL.toString()), (Object[])tepBaseParams.toArray());
                try {
                    while (rs.next()) {
                        rsIDList.add(rs.getString("FID"));
                    }
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
            }
        }
        return rsIDList.toArray();
    }

    private String getSQLStringForCheckVoucher(Context ctx, List ps) {
        StringBuffer strSQL = new StringBuffer();
        String s = "_" + ctx.getLocale().getLanguage();
        strSQL.append(" \tSelect (vchtype.FName").append(s).append(" || vch.FNumber) as FVchNumber,\t\t\t\t\t\t\r\n");
        strSQL.append(" \t\t\tvch.FCompanyID As FSrcCompanyID,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append(" \t\t\tCase When assGrp.FCompanyOrgID Is Not Null Then assGrp.FCompanyOrgID\t\t\t\t\t\r\n");
        strSQL.append(" \t\t \t\t When (assGrp.FCompanyOrgID Is Null And customer.FInternalCompanyID Is Not Null) Then customer.FInternalCompanyID \r\n");
        strSQL.append("  \t\t \t\t When (assGrp.FCompanyOrgID Is Null And customer.FInternalCompanyID Is Null And supplier.FInternalCompanyID Is Not Null) Then supplier.FInternalCompanyID \r\n");
        strSQL.append("\t\t\t\tEnd As FTargCompanyID, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\t\tvchE.FCurrencyID, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\t\tvchE.FEntryDc as FDc, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\t\tasst.FOriginalAmount,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\t\tasst.FID as FAssistRecordID, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\t\tvch.FID as FVoucherID, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\t\tvch.FCreateTime \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\tFrom T_GL_Voucher vch  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tInner Join T_GL_VoucherEntry vchE \tOn vch.FID = vchE.FBillID\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tInner Join T_GL_VoucherAssistRecord asst On vchE.FID = asst.FEntryID\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tInner Join T_BD_AccountView account On vchE.FAccountID = account.FID \t\r\n");
        strSQL.append("\t\t\tInner Join T_BD_VoucherTypes vchtype On vch.FVoucherTypeID = vchtype.FID\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tInner Join T_BD_AssistantHG assGrp  On asst.FAssGrpID = assGrp.FID\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tLeft Outer Join T_BD_Customer customer  On assGrp.FCustomerID = customer.FID \t\t\t\t\t\r\n");
        strSQL.append("\t\t\tLeft Outer Join T_BD_Supplier supplier On assGrp.FProviderID = supplier.FID \t\t\t\t\t\r\n");
        strSQL.append("\t\tWhere vch.FBizStatus <> ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tAnd vch.FBizStatus <> ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tAnd vch.FBizStatus <> ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tAnd asst.FReqCheckStatus = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tAnd asst.FReqStatus <> ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tAnd account.FACNotice <> 0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tAnd ((assGrp.FCompanyOrgID Is Not Null) \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t\t\tOr (customer.FIsInternalCompany <>0 and customer.FInternalCompanyID Is Not Null) \t\t\t\r\n");
        strSQL.append("\t\t\tOr (supplier.FIsInternalCompany <>0 and supplier.FInternalCompanyID Is Not Null)) \t\t\t\r\n");
        ps.add(new Integer(0));
        ps.add(new Integer(2));
        ps.add(new Integer(5));
        ps.add(new Integer(1));
        ps.add(new Integer(2));
        return strSQL.toString();
    }

    @Override
    protected Collection _checkCollection(Context ctx, Collection checkViews) throws BOSException, EASBizException {
        if (checkViews == null || checkViews.size() == 0) {
            return checkViews;
        }
        CheckViewInfo o2 = null;
        int index = 0;
        StringBuffer checkNumber = new StringBuffer();
        for (CheckViewInfo o2 : checkViews) {
            if (index != 0 && checkNumber.length() != 0 && o2.getCheckNumber() != null) {
                checkNumber.append(",");
            }
            if (o2.getCheckNumber() != null) {
                checkNumber.append("'").append(o2.getCheckNumber().toString()).append("'");
            }
            ++index;
        }
        if (checkNumber.length() == 0) {
            return checkViews;
        }
        ArrayList<CheckViewInfo> temp = new ArrayList<CheckViewInfo>();
        try {
            StringBuffer sql = new StringBuffer();
            CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            sql.append("select b.FCheckNumber from t_csl_requisition a ");
            sql.append("inner join t_csl_requisitionentry b on a.fid = b.FRequisitionID ");
            sql.append("where b.FCheckNumber in (").append(checkNumber.toString()).append(") ");
            sql.append("and a.FFiVouchered = 1 ");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer tempCheckNumber = new StringBuffer();
            index = 0;
            while (set != null && set.next()) {
                String tmpCheckNumber = set.getString(TABLE_FIELD_CHECKNUMBER);
                if (tempCheckNumber.length() > 0) {
                    tempCheckNumber.append(",");
                }
                tempCheckNumber.append("'").append(tmpCheckNumber).append("'");
                ++index;
            }
            for (CheckViewInfo o2 : checkViews) {
                if (o2.getCheckNumber() == null || tempCheckNumber.toString().indexOf(o2.getCheckNumber()) == -1) continue;
                temp.add(o2);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return temp;
    }
}

