/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.fileVch.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherCollection;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherInfo;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherResultInfo;
import com.kingdee.eas.fi.gl.fileVch.app.AbstractFileVoucherControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FileVoucherControllerBean
extends AbstractFileVoucherControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.fileVch.app.FileVoucherControllerBean");

    @Override
    protected FileVoucherResultInfo _saveFileVoucherColl(Context ctx, FileVoucherCollection coll) throws BOSException, EASBizException {
        FileVoucherResultInfo result = new FileVoucherResultInfo();
        for (int i = 0; i < coll.size(); ++i) {
            FilterInfo filter = new FilterInfo();
            FileVoucherInfo info = coll.get(i);
            filter.appendFilterItem("voucher.id", (Object)info.getVoucher().getId().toString());
            filter.appendFilterItem("sourceBillId", (Object)info.getSourceBillId());
            if (this.exists(ctx, filter)) continue;
            this.addnew(ctx, info);
        }
        return result;
    }

    @Override
    protected FileVoucherResultInfo _cancelMatch(Context ctx, List pkList) throws BOSException, EASBizException {
        FileVoucherResultInfo result = new FileVoucherResultInfo();
        HashSet idSet = new HashSet(pkList);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("number");
        view.getSelector().add("voucher.number");
        view.getSelector().add("voucher.voucherType.number");
        view.getSelector().add("voucher.voucherType.name");
        view.getSelector().add("filed");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FileVoucherCollection coll = this.getFileVoucherCollection(ctx, view);
        ArrayList<FileVoucherInfo> isFiledList = new ArrayList<FileVoucherInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            FileVoucherInfo info = coll.get(i);
            if (info.isFiled()) {
                isFiledList.add(info);
                continue;
            }
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
        boolean isSucc = true;
        if (isFiledList.size() > 0) {
            isSucc = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < isFiledList.size(); ++i) {
                String number = "[" + ((FileVoucherInfo)isFiledList.get(i)).getVoucher().getVoucherType().getName() + "]" + ((FileVoucherInfo)isFiledList.get(i)).getVoucher().getNumber();
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherResource", (String)"Cancel_Match_Record_is_filed", (Locale)ctx.getLocale(), (Object[])new Object[]{((FileVoucherInfo)isFiledList.get(i)).getNumber(), number})).append("<br>");
            }
            result.setErrorMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherResource", (String)"Cancel_Match_Failed", (Locale)ctx.getLocale()));
            result.setErrorMsgDetail(sb.toString());
        }
        result.setSuccess(isSucc);
        return result;
    }

    @Override
    protected FileVoucherResultInfo _fileVoucher(Context ctx, List pkList) throws BOSException, EASBizException {
        FileVoucherResultInfo result = new FileVoucherResultInfo();
        HashSet idSet = new HashSet(pkList);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("voucher.number");
        view.getSelector().add("voucher.voucherType.number");
        view.getSelector().add("voucher.voucherType.name");
        view.getSelector().add("filed");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FileVoucherCollection coll = this.getFileVoucherCollection(ctx, view);
        ArrayList<FileVoucherInfo> isFiledList = new ArrayList<FileVoucherInfo>();
        StringBuffer idSql = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            FileVoucherInfo info = coll.get(i);
            if (info.isFiled()) {
                isFiledList.add(info);
                continue;
            }
            if (idSql.length() == 0) {
                idSql.append("'").append(info.getId().toString()).append("'");
                continue;
            }
            idSql.append(",'").append(info.getId().toString()).append("'");
        }
        if (idSql.length() > 0) {
            StringBuffer sql = new StringBuffer("update T_GL_FileVoucher set Filed = 1, filedDate = ? where fid in (").append(idSql).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Date(System.currentTimeMillis())});
        }
        boolean isSucc = true;
        if (isFiledList.size() > 0) {
            isSucc = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < isFiledList.size(); ++i) {
                String number = "[" + ((FileVoucherInfo)isFiledList.get(i)).getVoucher().getVoucherType().getName() + "]" + ((FileVoucherInfo)isFiledList.get(i)).getVoucher().getNumber();
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherResource", (String)"File_Voucher_Record_is_filed", (Locale)ctx.getLocale(), (Object[])new Object[]{((FileVoucherInfo)isFiledList.get(i)).getNumber(), number})).append("<br>");
            }
            result.setErrorMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherResource", (String)"File_Voucher_failed", (Locale)ctx.getLocale()));
            result.setErrorMsgDetail(sb.toString());
        }
        result.setSuccess(isSucc);
        return result;
    }

    @Override
    protected FileVoucherResultInfo _cancelFileVoucher(Context ctx, List pkList) throws BOSException, EASBizException {
        FileVoucherResultInfo result = new FileVoucherResultInfo();
        HashSet idSet = new HashSet(pkList);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("voucher.number");
        view.getSelector().add("voucher.voucherType.number");
        view.getSelector().add("voucher.voucherType.name");
        view.getSelector().add("filed");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FileVoucherCollection coll = this.getFileVoucherCollection(ctx, view);
        ArrayList<FileVoucherInfo> isFiledList = new ArrayList<FileVoucherInfo>();
        StringBuffer idSql = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            FileVoucherInfo info = coll.get(i);
            if (!info.isFiled()) {
                isFiledList.add(info);
                continue;
            }
            if (idSql.length() == 0) {
                idSql.append("'").append(info.getId().toString()).append("'");
                continue;
            }
            idSql.append(",'").append(info.getId().toString()).append("'");
        }
        if (idSql.length() > 0) {
            StringBuffer sql = new StringBuffer("update T_GL_FileVoucher set Filed = 0, filedDate = null where fid in (").append(idSql).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        boolean isSucc = true;
        if (isFiledList.size() > 0) {
            isSucc = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < isFiledList.size(); ++i) {
                String number = "[" + ((FileVoucherInfo)isFiledList.get(i)).getVoucher().getVoucherType().getName() + "]" + ((FileVoucherInfo)isFiledList.get(i)).getVoucher().getNumber();
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherResource", (String)"Cancel_File_Record_isnot_filed", (Locale)ctx.getLocale(), (Object[])new Object[]{((FileVoucherInfo)isFiledList.get(i)).getNumber(), number})).append("<br>");
            }
            result.setErrorMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherResource", (String)"Cancel_File_failed", (Locale)ctx.getLocale()));
            result.setErrorMsgDetail(sb.toString());
        }
        result.setSuccess(isSucc);
        return result;
    }
}

