/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.fileVch.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.FileVoucherBillInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.FileVoucherBillInstance;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherExternalSystemCollection;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherExternalSystemFactory;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherExternalSystemInfo;
import com.kingdee.eas.fi.gl.fileVch.FileVoucherInstanceInfo;
import com.kingdee.eas.fi.gl.fileVch.app.AbstractFileVoucherFasadeControllerBean;
import com.kingdee.eas.fi.gl.fileVch.app.FileVoucherBillInstanceFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileVoucherFasadeControllerBean
extends AbstractFileVoucherFasadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.fileVch.FileVoucherFasadeControllerBean");

    @Override
    protected List _getBillInfoList(Context ctx, String imageNumber) throws BOSException, EASBizException {
        Object billID = null;
        List resultList = new ArrayList();
        resultList = this.getEXSystemInfo(ctx, imageNumber);
        if (resultList != null && resultList.size() > 0) {
            return resultList;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNumber));
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection.size() > 0 && null != billImageMapCollection.get(0)) {
            BillImageMapInfo billImage = billImageMapCollection.get(0);
            String billId = billImage.getBillID();
            String bosType = billImage.getBosType();
            FileVoucherInstanceInfo billInstanceInfo = FileVoucherBillInstanceFactory.getFileVoucherInstanceInfo(ctx, bosType);
            if (null == billInstanceInfo) {
                return resultList;
            }
            FileVoucherBillInstance billInstance = FileVoucherBillInstanceFactory.CreateFileVoucherInstance(billInstanceInfo.getBillInstance());
            String pageId = billInstanceInfo.getBillPageId();
            if (billInstance == null) {
                return resultList;
            }
            FileVoucherBillInfo billInfo = billInstance.getBillInfo(ctx, billId, bosType);
            if (billInfo == null) {
                return resultList;
            }
            billInfo.setSourceSysEnum(billInstanceInfo.getSourceSys());
            Set voucherIdSet = billInstance.getVoucherIdSet(ctx, bosType, billId);
            if (voucherIdSet != null && voucherIdSet.size() > 0) {
                this.getBillInfoWithVoucher(ctx, imageNumber, resultList, billId, bosType, billInfo, voucherIdSet, pageId);
            } else {
                this.getBillInfoWithoutVoucher(resultList, billId, bosType, billInfo, pageId);
            }
        }
        return resultList;
    }

    private List getEXSystemInfo(Context ctx, String imageNumber) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        FilterInfo exSystemFilter = new FilterInfo();
        exSystemFilter.appendFilterItem("imageNo", (Object)imageNumber);
        boolean isExistExSystemBill = FileVoucherExternalSystemFactory.getLocalInstance(ctx).exists(exSystemFilter);
        if (isExistExSystemBill) {
            EntityViewInfo exView = new EntityViewInfo();
            exView.setFilter(exSystemFilter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("vouchered");
            sic.add("billBosType");
            sic.add("billCreator.id");
            sic.add("billType");
            sic.add("sourceSys");
            sic.add("imageNo");
            sic.add("voucher.id");
            sic.add("voucher.number");
            sic.add("voucher.bookedDate");
            sic.add("voucher.company.id");
            sic.add("voucher.company.name");
            sic.add("voucher.voucherType.id");
            sic.add("voucher.voucherType.name");
            sic.add("voucher.voucherAbstract");
            sic.add("voucher.voucherType.name");
            sic.add("billCreator.id");
            sic.add("billCreator.name");
            sic.add("voucher.bizStatus");
            sic.add("sourceSysEnum");
            sic.add("sourceBillId");
            sic.add("number");
            sic.add("id");
            exView.setSelector(sic);
            FileVoucherExternalSystemCollection coll = FileVoucherExternalSystemFactory.getLocalInstance(ctx).getFileVoucherExternalSystemCollection(exView);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    FileVoucherExternalSystemInfo exBillInfo = coll.get(i);
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    VoucherInfo voucher = exBillInfo.getVoucher();
                    resultMap.put("id", exBillInfo.getSourceBillId().toString() + voucher.getId().toString());
                    resultMap.put("bookDate", voucher.getBookedDate());
                    resultMap.put("billNumber", exBillInfo.getNumber());
                    resultMap.put("voucherNumber", "[" + voucher.getVoucherType().getName() + "]" + voucher.getNumber());
                    resultMap.put("voucherDesc", voucher.getVoucherAbstract());
                    resultMap.put("voucherStatus", voucher.getBizStatus().getAlias());
                    resultMap.put("company", voucher.getCompany().getName());
                    resultMap.put("companyId", voucher.getCompany().getId().toString());
                    resultMap.put("creator", exBillInfo.getBillCreator().getName());
                    resultMap.put("creatorId", exBillInfo.getBillCreator().getId().toString());
                    resultMap.put("billId", exBillInfo.getSourceBillId().toString());
                    resultMap.put("voucherId", voucher.getId().toString());
                    resultMap.put("billType", exBillInfo.getBillType());
                    if (exBillInfo.getSourceSys() != null) {
                        resultMap.put("sourceSystem", exBillInfo.getSourceSys());
                    } else {
                        resultMap.put("sourceSystem", exBillInfo.getSourceSysEnum().getAlias());
                    }
                    resultMap.put("sourceSysEnum", exBillInfo.getSourceSysEnum().getValue());
                    resultMap.put("isPosted", Boolean.TRUE);
                    resultMap.put("billBosType", exBillInfo.getBillBosType());
                    resultMap.put("imageNo", imageNumber);
                    resultMap.put("pageId", null);
                    resultList.add(resultMap);
                }
            }
        }
        return resultList;
    }

    private void getBillInfoWithVoucher(Context ctx, String imageNumber, List resultList, String billId, String bosType, FileVoucherBillInfo billInfo, Set voucherIdSet, String pageId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo vfilter = new FilterInfo();
        vfilter.getFilterItems().add(new FilterItemInfo("id", (Object)voucherIdSet, CompareType.INCLUDE));
        view.setFilter(vfilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("voucherType.number"));
        view.setSelector(sic);
        VoucherCollection coll = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                VoucherInfo voucher = coll.get(i);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("id", billId + voucher.getId().toString());
                resultMap.put("bookDate", voucher.getBookedDate());
                resultMap.put("billNumber", billInfo.getBillNumber());
                resultMap.put("voucherNumber", "[" + voucher.getVoucherType().getName() + "]" + voucher.getNumber());
                resultMap.put("voucherDesc", voucher.getVoucherAbstract());
                resultMap.put("voucherStatus", voucher.getBizStatus().getAlias());
                resultMap.put("company", voucher.getCompany().getName());
                resultMap.put("companyId", voucher.getCompany().getId().toString());
                resultMap.put("creator", billInfo.getBillCreator().getName());
                resultMap.put("creatorId", billInfo.getBillCreator().getId().toString());
                resultMap.put("billId", billId);
                resultMap.put("voucherId", voucher.getId().toString());
                resultMap.put("billType", billInfo.getBillType());
                if (billInfo.getBillSystem() != null) {
                    resultMap.put("sourceSystem", billInfo.getBillSystem());
                } else {
                    resultMap.put("sourceSystem", billInfo.getSourceSysEnum().getAlias());
                }
                resultMap.put("sourceSysEnum", billInfo.getSourceSysEnum().getValue());
                resultMap.put("isPosted", Boolean.TRUE);
                resultMap.put("billBosType", bosType);
                resultMap.put("imageNo", imageNumber);
                resultMap.put("pageId", pageId);
                resultMap.put("matchedDate", new Date());
                resultList.add(resultMap);
            }
        } else {
            this.getBillInfoWithoutVoucher(resultList, billId, bosType, billInfo, pageId);
        }
    }

    private void getBillInfoWithoutVoucher(List resultList, String billId, String bosType, FileVoucherBillInfo billInfo, String pageId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("id", billId);
        resultMap.put("billNumber", billInfo.getBillNumber());
        resultMap.put("amount", billInfo.getAmount());
        resultMap.put("billStatus", billInfo.getBillStatus());
        resultMap.put("creator", billInfo.getBillCreator().getName());
        resultMap.put("creatorId", billInfo.getBillCreator().getId().toString());
        resultMap.put("billType", billInfo.getBillType());
        if (billInfo.getBillSystem() != null) {
            resultMap.put("sourceSystem", billInfo.getBillSystem());
        } else {
            resultMap.put("sourceSystem", billInfo.getSourceSysEnum().getAlias());
        }
        resultMap.put("sourceSysEnum", billInfo.getSourceSysEnum().getValue());
        resultMap.put("company", billInfo.getCompany().getName());
        resultMap.put("billId", billId);
        resultMap.put("isPosted", Boolean.FALSE);
        resultMap.put("billBosType", bosType);
        resultMap.put("pageId", pageId);
        resultMap.put("matchedDate", new Date());
        resultList.add(resultMap);
    }

    private Set<String> getVoucherIdSet(Context ctx, String bosType, String billId) throws BOSException {
        HashSet<String> voucherIdSet = new HashSet<String>();
        try {
            StringBuffer sql = new StringBuffer(" select FDESTOBJECTID from T_BOT_RELATION where FSRCENTITYID = ? and FSRCOBJECTID =? and FDESTENTITYID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bosType, billId, "2652E01E"});
            while (rs.next()) {
                voucherIdSet.add(rs.getString("FDESTOBJECTID"));
            }
            if (voucherIdSet.size() > 0) {
                return voucherIdSet;
            }
            sql = new StringBuffer(" select r2.FDESTOBJECTID from T_BOT_RELATION r1 ,T_BOT_RELATION r2 ").append("where r1.FSRCENTITYID = ? and r1.FSRCOBJECTID =? and r1.FDESTENTITYID = r2.FSRCENTITYID and r1.FDESTOBJECTID =r2.FSRCOBJECTID and r2.FDESTENTITYID = ?").append(" and r1.FDESTENTITYID ='40284E81'");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bosType, billId, "2652E01E"});
            while (rs.next()) {
                voucherIdSet.add(rs.getString("FDESTOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherIdSet;
    }

    @Override
    protected List _getSystemList(Context ctx) throws BOSException, EASBizException {
        String sql = "select distinct FSourceSys from T_GL_FileVoucherInstance order by FSourceSys";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<Integer> systemList = new ArrayList<Integer>();
        try {
            while (rs.next()) {
                systemList.add(rs.getInt("FSourceSys"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return systemList;
    }

    @Override
    protected Map _getBillPrintSetting(Context ctx) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        HashMap systemBillMap = new HashMap();
        HashMap billPrintSettingMap = new HashMap();
        resultMap.put("billPrintSettingMap", billPrintSettingMap);
        resultMap.put("systemBillMap", systemBillMap);
        String localeValue = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select  FSourceSys,FBILLTYPE" + localeValue + ",FBOSTYPE,FPRINGPATH,FPRINGQUERY,FPRINGDATAPROVIDE from T_GL_FileVoucherInstance order by FOrder";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String system = rs.getString("FSourceSys");
                ArrayList systemList = (ArrayList)systemBillMap.get(system);
                if (systemList == null) {
                    systemList = new ArrayList();
                    systemBillMap.put(system, systemList);
                }
                HashMap<String, String> billTypeMap = new HashMap<String, String>();
                String bosType = rs.getString("FBOSTYPE");
                billTypeMap.put("bosType", bosType);
                billTypeMap.put("billType", rs.getString("FBILLTYPE" + localeValue));
                systemList.add(billTypeMap);
                HashMap<String, String> printSettingMap = new HashMap<String, String>();
                printSettingMap.put("printPath", rs.getString("FPRINGPATH"));
                printSettingMap.put("printQuery", rs.getString("FPRINGQUERY"));
                printSettingMap.put("printDataProvide", rs.getString("FPRINGDATAPROVIDE"));
                billPrintSettingMap.put(bosType, printSettingMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    protected Map _getBillInfo(Context ctx, String billId, String bosType) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Object billID = null;
        FileVoucherInstanceInfo billInstanceInfo = FileVoucherBillInstanceFactory.getFileVoucherInstanceInfo(ctx, bosType);
        FileVoucherBillInstance billInstance = FileVoucherBillInstanceFactory.CreateFileVoucherInstance(billInstanceInfo.getBillInstance());
        String pageId = billInstanceInfo.getBillPageId();
        if (billInstance == null) {
            return resultMap;
        }
        FileVoucherBillInfo billInfo = billInstance.getBillInfo(ctx, billId, bosType);
        if (billInfo == null) {
            return resultMap;
        }
        billInfo.setSourceSysEnum(billInstanceInfo.getSourceSys());
        Set voucherIdSet = billInstance.getVoucherIdSet(ctx, bosType, billId);
        resultMap.put("billInfo", billInfo);
        resultMap.put("voucherIdSet", voucherIdSet);
        return resultMap;
    }

    @Override
    protected Map _getBillInfoByImageNumber(Context ctx, String imageNumber) throws BOSException, EASBizException {
        Object billID = null;
        List resultList = new ArrayList();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultList = this.getEXSystemInfo(ctx, imageNumber);
        if (resultList != null && resultList.size() > 0) {
            return resultMap;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNumber));
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection.size() > 0) {
            BillImageMapInfo billImage = billImageMapCollection.get(0);
            String billId = billImage.getBillID();
            String bosType = billImage.getBosType();
            FileVoucherInstanceInfo billInstanceInfo = FileVoucherBillInstanceFactory.getFileVoucherInstanceInfo(ctx, bosType);
            FileVoucherBillInstance billInstance = FileVoucherBillInstanceFactory.CreateFileVoucherInstance(billInstanceInfo.getBillInstance());
            String pageId = billInstanceInfo.getBillPageId();
            if (billInstance == null) {
                return resultMap;
            }
            FileVoucherBillInfo billInfo = billInstance.getBillInfo(ctx, billId, bosType);
            if (billInfo == null) {
                return resultMap;
            }
            billInfo.setSourceSysEnum(billInstanceInfo.getSourceSys());
            billInfo.setPageId(billInstanceInfo.getBillPageId());
            billInfo.setBillId(billId);
            billInfo.setBosType(bosType);
            Set voucherIdSet = billInstance.getVoucherIdSet(ctx, bosType, billId);
            voucherIdSet.add("e74AAAAAXdYmUuAe");
            resultMap.put("billInfo", billInfo);
            resultMap.put("voucherIdSet", voucherIdSet);
        }
        return resultMap;
    }
}

