/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ParamEx;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptSysParam;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class GLRptBaseCondition
extends ReportConditionBase {
    private static final long serialVersionUID = -7486329129520992632L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition");
    public static final int createIDTempTableMaxCount = 500;
    protected transient Context ctx;
    private CompanyOrgUnitInfo company;
    private GLRptSysParam rptParams;
    private PeriodInfo currPeriod;
    private Boolean isAfterCurrPeriod;
    private ProfitCenterOrgUnitInfo profitCenter;
    private ProfitCenterOrgUnitInfo[] profitCenters;
    private ProfitCenterOrgUnitInfo[] selectedProfitCenters;
    private String profitCenterIdsStr;
    private CompanyOrgUnitInfo[] companys;
    private String periodTypeId;
    private String accountTableId;
    private boolean optionBalanceZero = false;
    private boolean optionAmountZero = false;
    private boolean optionAmountAndBalZero = false;
    private boolean isAmountZeroByVoucher = false;
    private boolean showLeafAccount = false;
    private boolean showQty = false;
    private boolean notIncluePLVoucher = false;
    private EntityViewInfo selfCond;
    protected String companyIdsStr;
    private Set balQueryPeriodIdSet;
    private Set voucherQueryPeriodIdSet;
    private CompanyDisplayModeEnum companyDisplayMode;
    private String accountIdStr;
    private boolean isLeafAccount = false;
    private boolean isSupportUnion = false;
    private CompanyOrgUnitInfo[] selectedCompanys;
    private boolean isFillInfo = false;
    protected boolean isCompanysSelect = false;
    protected String extendParams = null;
    protected transient Map exParams = null;

    public boolean isCompanysSelect() {
        return this.isCompanysSelect;
    }

    public void setCompanysSelect(boolean isCompanysSelect) {
        this.isCompanysSelect = isCompanysSelect;
    }

    public GLRptBaseCondition() {
    }

    public GLRptBaseCondition(Map map) throws CloneNotSupportedException {
        super(map);
        this.setFillInfo(this.getBoolean((Boolean)map.get("isFillInfo")));
        if (this.isOldQuerySolution(map)) {
            Object accountTable;
            Object periodType;
            if (map.get("bpPeriod") != null && (periodType = ((RptConditionManager.ComponentStatus)map.get("bpPeriod")).getValue()) instanceof PeriodTypeInfo) {
                this.setPeriodTypeId(((PeriodTypeInfo)periodType).getId().toString());
            }
            if (map.get("bpAccount") != null && (accountTable = ((RptConditionManager.ComponentStatus)map.get("bpAccount")).getValue()) instanceof AccountTableInfo) {
                this.setAccountTableId(((AccountTableInfo)accountTable).getId().toString());
            }
            Boolean optionAmountZero = map.get("jcbNoDisplayZero") == null ? Boolean.FALSE : (Boolean)((RptConditionManager.ComponentStatus)map.get("jcbNoDisplayZero")).getValue();
            this.setOptionAmountZero(optionAmountZero != null && optionAmountZero != false);
            Boolean notIncluePLVoucher = map.get("jcbincludeNoTransPLVoucher") == null ? Boolean.FALSE : (Boolean)((RptConditionManager.ComponentStatus)map.get("jcbincludeNoTransPLVoucher")).getValue();
            this.setNotIncluePLVoucher(notIncluePLVoucher != null && notIncluePLVoucher != false);
            Object company = map.get("company");
            if (company != null) {
                if (company instanceof Object[]) {
                    this.setCompanys(this.toCompanyOrgUnitInfoArray((Object[])company));
                    this.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
                } else if (company instanceof CompanyOrgUnitInfo && !((CompanyOrgUnitInfo)company).isIsBizUnit()) {
                    this.switchCompany((CompanyOrgUnitInfo)company);
                    this.setCompanys(this.toCompanyOrgUnitInfoArray(new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company}));
                    this.setCompanyDisplayMode(CompanyDisplayModeEnum.level);
                } else {
                    this.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
                }
            } else {
                Object profitCenter = map.get("profitCenter");
                if (profitCenter instanceof Object[]) {
                    this.setProfitCenters(this.toProfitCenterOrgUnitInfoArray((Object[])profitCenter));
                    this.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
                } else if (profitCenter instanceof ProfitCenterOrgUnitInfo && !((ProfitCenterOrgUnitInfo)profitCenter).isIsBizUnit()) {
                    this.switchProfitCenter((ProfitCenterOrgUnitInfo)profitCenter);
                    this.setProfitCenters(this.toProfitCenterOrgUnitInfoArray(new ProfitCenterOrgUnitInfo[]{(ProfitCenterOrgUnitInfo)profitCenter}));
                    this.setCompanyDisplayMode(CompanyDisplayModeEnum.level);
                } else {
                    this.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
                }
            }
            Object obj = null;
            if (map.get("jcbNoPlayBalanceZero") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jcbNoPlayBalanceZero")).getValue();
                this.setOptionBalanceZero(Boolean.parseBoolean(obj.toString()));
            }
            if (this.isOptionAmountZero() && this.isOptionBalanceZero()) {
                this.setOptionAmountAndBalZero(true);
                this.setOptionAmountZero(false);
                this.setOptionBalanceZero(false);
            }
            if (map.get("isQtyAsst") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("jspLevelTo")).getValue();
                this.setShowQty(Boolean.parseBoolean(obj.toString()));
            }
            if (map.get("chkShowLeafAccount") != null) {
                obj = ((RptConditionManager.ComponentStatus)map.get("chkShowLeafAccount")).getValue();
                this.setShowLeafAccount(Boolean.parseBoolean(obj.toString()));
            }
        } else {
            this.setShowLeafAccount(this.getBoolean((Boolean)map.get("OptionOnlyLeaf")));
            this.setOptionAmountZero(this.getBoolean((Boolean)map.get("OptionAmountZero")));
            this.setOptionBalanceZero(this.getBoolean((Boolean)map.get("OptionBalanceZero")));
            this.setOptionAmountAndBalZero(this.getBoolean((Boolean)map.get("OptionAmountAndBalZero")));
            this.setShowQty(this.getBoolean((Boolean)map.get("showQty")));
            this.setNotIncluePLVoucher(this.getBoolean((Boolean)map.get("notIncluePLVoucher")));
            this.setAccountTableId((String)map.get("accountTableId"));
            this.setPeriodTypeId((String)map.get("periodTypeId"));
            if (map.get("company") != null || map.get("companys") != null) {
                this.switchCompany((CompanyOrgUnitInfo)map.get("company"));
                Object[] companys = (Object[])map.get("companys");
                this.setCompanys(this.toCompanyOrgUnitInfoArray(companys));
                Object[] selectedCompanys = (Object[])map.get("selectedCompanys");
                this.setSelectedCompanys(this.toCompanyOrgUnitInfoArray(selectedCompanys));
            } else {
                this.switchProfitCenter((ProfitCenterOrgUnitInfo)map.get("profitCenter"));
                Object[] profitCenters = (Object[])map.get("profitCenters");
                this.setProfitCenters(this.toProfitCenterOrgUnitInfoArray(profitCenters));
                Object[] selectedProfitCenters = (Object[])map.get("selectedProfitCenters");
                this.setSelectedProfitCenters(this.toProfitCenterOrgUnitInfoArray(selectedProfitCenters));
            }
            this.setCompanyDisplayMode((CompanyDisplayModeEnum)((Object)map.get("companyDisplayMode")));
            this.setAccountIdSet((Set)map.get("hashAccountIdSet"));
            this.setSelfCond((EntityViewInfo)map.get("selfCond"));
        }
        this.setExtendParams((String)map.get("extendParams"));
    }

    private CompanyOrgUnitInfo[] toCompanyOrgUnitInfoArray(Object[] companys) {
        if (companys == null) {
            return null;
        }
        CompanyOrgUnitInfo[] cps = new CompanyOrgUnitInfo[companys.length];
        for (int i = 0; i < companys.length; ++i) {
            cps[i] = (CompanyOrgUnitInfo)companys[i];
        }
        return cps;
    }

    private ProfitCenterOrgUnitInfo[] toProfitCenterOrgUnitInfoArray(Object[] profitCenters) {
        if (profitCenters == null) {
            return null;
        }
        ProfitCenterOrgUnitInfo[] cps = new ProfitCenterOrgUnitInfo[profitCenters.length];
        for (int i = 0; i < profitCenters.length; ++i) {
            cps[i] = (ProfitCenterOrgUnitInfo)profitCenters[i];
        }
        return cps;
    }

    public GLRptBaseCondition(ReportConditionBase base) {
        super(base);
        if (base instanceof GLRptBaseCondition) {
            GLRptBaseCondition cond = (GLRptBaseCondition)base;
            this.setOptionAmountZero(cond.isOptionAmountZero());
            this.setOptionBalanceZero(cond.isOptionBalanceZero());
            this.setOptionAmountAndBalZero(cond.isOptionAmountAndBalZero());
            this.setShowQty(cond.isShowQty());
            this.setNotIncluePLVoucher(cond.isNotIncluePLVoucher());
            this.setAccountTableId(cond.getAccountTableId());
            this.setPeriodTypeId(cond.getPeriodTypeId());
            this.setShowLeafAccount(cond.isShowLeafAccount());
            if (cond.getProfitCenter() != null && cond.getProfitCenters() != null) {
                this.switchProfitCenter(cond.getProfitCenter());
                this.setProfitCenters(cond.getProfitCenters());
                this.setTreeModelOfProfitCenter(cond.getTreeModelOfProfitCenter());
                this.setSelectedProfitCenters(cond.getSelectedProfitCenters());
            } else {
                this.switchCompany(cond.getCompany());
                this.setCompanys(cond.getCompanys());
                this.setTreeModelOfCompany(base.getTreeModelOfCompany());
                this.setSelectedCompanys(cond.getSelectedCompanys());
            }
            this.setCompanyDisplayMode(cond.getCompanyDisplayMode());
            this.setSelfCond(cond.getSelfCond());
            this.setExtendParams(cond.getExtendParams());
        }
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        map.put("OptionOnlyLeaf", this.isShowLeafAccount());
        map.put("OptionAmountZero", this.isOptionAmountZero());
        map.put("OptionBalanceZero", this.isOptionBalanceZero());
        map.put("OptionAmountAndBalZero", this.isOptionAmountAndBalZero());
        map.put("showQty", this.isShowQty());
        map.put("notIncluePLVoucher", this.isNotIncluePLVoucher());
        map.put("accountTableId", this.getAccountTableId());
        map.put("periodTypeId", this.getPeriodTypeId());
        map.put("company", this.getCompany());
        map.put("companys", this.getCompanys());
        map.put("selectedCompanys", this.getSelectedCompanys());
        map.put("companyDisplayMode", this.getCompanyDisplayMode());
        map.put("hashAccountIdSet", this.getAccountIdSet());
        map.put("selfCond", this.getSelfCond());
        map.put("isFillInfo", this.isFillInfo());
        map.put("profitCenter", this.getProfitCenter());
        map.put("profitCenters", this.getProfitCenters());
        map.put("selectedProfitCenters", this.getSelectedProfitCenters());
        map.put("extendParams", this.getExtendParams());
        return map;
    }

    public String getProfitCenterIdsStr() throws BOSException {
        if (this.profitCenterIdsStr == null) {
            Set idSet = this.getProfitCenterIds();
            this.profitCenterIdsStr = this.genProfitCenterIdsStr(idSet);
        }
        return this.profitCenterIdsStr;
    }

    public void setProfitCenterIdsStr(String profitCenterIdsStr) {
        this.profitCenterIdsStr = profitCenterIdsStr;
    }

    public void setProfitCenter(ProfitCenterOrgUnitInfo profitCenter) {
        this.profitCenter = profitCenter;
    }

    public ProfitCenterOrgUnitInfo getProfitCenter() {
        return this.profitCenter;
    }

    public void setProfitCenters(ProfitCenterOrgUnitInfo[] profitCenters) {
        this.profitCenters = profitCenters;
    }

    public ProfitCenterOrgUnitInfo[] getProfitCenters() {
        return this.profitCenters;
    }

    public void setSelectedProfitCenters(ProfitCenterOrgUnitInfo[] selectedProfitCenters) {
        this.selectedProfitCenters = selectedProfitCenters;
    }

    public ProfitCenterOrgUnitInfo[] getSelectedProfitCenters() {
        if (this.selectedProfitCenters != null) {
            return this.selectedProfitCenters;
        }
        this.selectedProfitCenters = this.getProfitCentersByProfitCenterTree();
        return this.selectedProfitCenters;
    }

    public String getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(String accountTableId) {
        this.accountTableId = accountTableId;
    }

    public String getPeriodTypeId() {
        if (this.periodTypeId == null) {
            return this.getCompany().getAccountPeriodType().getId().toString();
        }
        return this.periodTypeId;
    }

    public void setPeriodTypeId(String periodTypeId) {
        this.periodTypeId = periodTypeId;
    }

    public boolean isOptionBalanceZero() {
        return this.optionBalanceZero;
    }

    public void setOptionBalanceZero(boolean optionBalanceZero) {
        this.optionBalanceZero = optionBalanceZero;
    }

    public boolean isOptionAmountZero() {
        return this.optionAmountZero;
    }

    public void setOptionAmountZero(boolean optionAmountZero) {
        this.optionAmountZero = optionAmountZero;
    }

    public boolean isOptionAmountAndBalZero() {
        return this.optionAmountAndBalZero;
    }

    public void setOptionAmountAndBalZero(boolean optionAmountAndBalZero) {
        this.optionAmountAndBalZero = optionAmountAndBalZero;
    }

    public boolean isAmountZeroByVoucher() {
        return this.isAmountZeroByVoucher;
    }

    public void setAmountZeroByVoucher(boolean isAmountZeroByVoucher) {
        this.isAmountZeroByVoucher = isAmountZeroByVoucher;
    }

    public boolean isShowLeafAccount() {
        return this.showLeafAccount;
    }

    public void setShowLeafAccount(boolean showLeafAccount) {
        this.showLeafAccount = showLeafAccount;
    }

    public boolean isShowQty() {
        return this.showQty;
    }

    public void setShowQty(boolean showQty) {
        this.showQty = showQty;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void switchCompany(CompanyOrgUnitInfo company) {
        this.switchCompany(company, false);
    }

    public void switchCompany(CompanyOrgUnitInfo company, boolean isChangeCompanys) {
        if (company == null) {
            return;
        }
        this.company = company;
        this.companyIdsStr = null;
        this.rptParams = null;
        this.currPeriod = null;
        this.setCompanyId(company.getId().toString());
        if (isChangeCompanys) {
            this.companys = new CompanyOrgUnitInfo[]{company};
            this.selectedCompanys = new CompanyOrgUnitInfo[]{company};
        }
    }

    public void switchProfitCenter(ProfitCenterOrgUnitInfo profitCenter) {
        this.switchProfitCenter(profitCenter, false);
    }

    public void switchProfitCenter(ProfitCenterOrgUnitInfo profitCenter, boolean isChangeProfitCenter) {
        if (profitCenter == null) {
            return;
        }
        this.profitCenter = profitCenter;
        this.profitCenterIdsStr = null;
        this.rptParams = null;
        this.currPeriod = null;
        this.setProfitCenterId(profitCenter.getId().toString());
        if (isChangeProfitCenter) {
            this.profitCenters = new ProfitCenterOrgUnitInfo[]{profitCenter};
            this.selectedProfitCenters = new ProfitCenterOrgUnitInfo[]{profitCenter};
        }
    }

    public void setCompany(CompanyOrgUnitInfo unionCompany) {
        this.company = unionCompany;
    }

    public CompanyOrgUnitInfo getCompany() {
        if (this.company == null) {
            this.company = this.ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)this.ctx);
        }
        return this.company;
    }

    public boolean isNotIncluePLVoucher() {
        return this.notIncluePLVoucher;
    }

    public void setNotIncluePLVoucher(boolean notIncluePLVoucher) {
        this.notIncluePLVoucher = notIncluePLVoucher;
    }

    public CompanyDisplayModeEnum getCompanyDisplayMode() {
        if (this.companyDisplayMode == null) {
            return this.getCompany().isIsBizUnit() ? CompanyDisplayModeEnum.enumerate : CompanyDisplayModeEnum.level;
        }
        return this.companyDisplayMode;
    }

    public void setCompanyDisplayMode(CompanyDisplayModeEnum mode) {
        this.companyDisplayMode = mode;
    }

    public EntityViewInfo getSelfCond() {
        return this.selfCond;
    }

    public void setSelfCond(EntityViewInfo selfCond) {
        this.selfCond = selfCond;
    }

    public GLRptSysParam getRptParams() throws EASBizException, BOSException {
        if (this.rptParams == null) {
            this.rptParams = GLRptSysParam.getGLRptParam(this.getCompany().getId().toString(), this.ctx);
        }
        return this.rptParams;
    }

    public void setRptParams(GLRptSysParam rptParams) {
        this.rptParams = rptParams;
    }

    public boolean isBalanceDirSamAsAccount() throws EASBizException, BOSException {
        return this.getRptParams().isBalanceDirSamAsAccount();
    }

    public boolean isAccountShowLongName() throws EASBizException, BOSException {
        return this.getRptParams().isAccountShowLongName();
    }

    @Override
    public GLRptBaseCondition clone() {
        try {
            return (GLRptBaseCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"clone error!", (Throwable)e);
            return null;
        }
    }

    public boolean isShowFor() {
        return !CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.getCurrencyID()) && !CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.getCurrencyID());
    }

    public boolean isShowLocal() throws EASBizException, BOSException {
        return !this.getRptParams().isForeignCurrencySu() && (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.getCurrencyID()) || !this.company.getBaseCurrency().getId().toString().equals(this.getCurrencyID()) && !CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.getCurrencyID()));
    }

    public boolean isShowRpt() throws EASBizException, BOSException {
        return this.getRptParams().isUseReportCurrency() && (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.getCurrencyID()) || this.company.getReportCurrency() != null && !this.company.getReportCurrency().getId().toString().equals(this.getCurrencyID()) && !CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.getCurrencyID()));
    }

    public int getQtyScale() throws EASBizException, BOSException {
        return this.getRptParams().getQtyScale();
    }

    public int getPriceScale() throws EASBizException, BOSException {
        return this.getRptParams().getPriceScale();
    }

    public PeriodInfo getCurrPeriod() throws EASBizException, BOSException {
        if (this.profitCenters != null) {
            this.currPeriod = this.getProfitCenterCurrPeriod();
        } else if (this.currPeriod == null) {
            if (CompanyDisplayModeEnum.enumerate == this.getCompanyDisplayMode()) {
                this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
            } else if (this.ctx != null) {
                StringBuffer sql = new StringBuffer();
                sql.append(" select top 1 pd.fid, pd.fnumber, pd.fperiodyear, pd.fperiodnumber ");
                sql.append(" from t_bd_systemstatusctrol ssc ");
                sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
                sql.append(" inner join t_bd_period pd on pd.fid = ssc.fcurrentperiodid ");
                sql.append(" where ssc.fcompanyid in ").append(this.getCompanyIdsStr());
                sql.append(" order by pd.fnumber ");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                try {
                    if (rs.next()) {
                        this.currPeriod = new PeriodInfo();
                        this.currPeriod.setId(BOSUuid.read((String)rs.getString("fid")));
                        this.currPeriod.setNumber(rs.getInt("fnumber"));
                        this.currPeriod.setPeriodYear(rs.getInt("fperiodyear"));
                        this.currPeriod.setPeriodNumber(rs.getInt("fperiodnumber"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("sql error!", (Throwable)e);
                }
            }
        }
        return this.currPeriod;
    }

    public PeriodInfo getProfitCenterCurrPeriod() throws EASBizException, BOSException {
        if (this.currPeriod == null) {
            if (CompanyDisplayModeEnum.enumerate == this.getCompanyDisplayMode()) {
                this.currPeriod = this.getProfitCenterCurrentPeriod(this.ctx, 1006, this.profitCenter.getId().toString());
            } else if (this.ctx != null) {
                StringBuffer sql = new StringBuffer();
                sql.append(" select top 1 pd.fid, pd.fnumber, pd.fperiodyear, pd.fperiodnumber ");
                sql.append(" from t_bd_systemstatusctrol ssc ");
                sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(1006);
                sql.append(" inner join t_bd_period pd on pd.fid = ssc.fcurrentperiodid ");
                sql.append(" where ssc.fprofitcenterid in ").append(this.getProfitCenterIdsStr());
                sql.append(" order by pd.fnumber ");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                try {
                    if (rs.next()) {
                        this.currPeriod = new PeriodInfo();
                        this.currPeriod.setId(BOSUuid.read((String)rs.getString("fid")));
                        this.currPeriod.setNumber(rs.getInt("fnumber"));
                        this.currPeriod.setPeriodYear(rs.getInt("fperiodyear"));
                        this.currPeriod.setPeriodNumber(rs.getInt("fperiodnumber"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("sql error!", (Throwable)e);
                }
            }
        }
        return this.currPeriod;
    }

    protected PeriodInfo getProfitCenterCurrentPeriod(Context ctx, int systemStatus, String profitCenterID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        sql.append(" select FCurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FProfitCenterID='");
        sql.append(profitCenterID);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(systemStatus);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                String periodid;
                if (iRowSet.next() && (periodid = iRowSet.getString("FCurrentPeriodID")) != null && periodid.length() > 0) {
                    IPeriod iperiod = PeriodFactory.getLocalInstance((Context)ctx);
                    return iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return null;
    }

    public String getPeriodIdStr(boolean isFromBeginPeriod) throws BOSException, EASBizException {
        Set periodIdSet = this.getPeriodIdSet(isFromBeginPeriod);
        if (periodIdSet.size() == 0) {
            return "('')";
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = periodIdSet.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    public Set getPeriodIdSet(boolean isFromBeginPeriod) throws BOSException, EASBizException {
        return isFromBeginPeriod ? this.getBalQueryPeriodIdSet() : this.getPeriodIdSet();
    }

    private Set getBalQueryPeriodIdSet() throws BOSException, EASBizException {
        if (this.balQueryPeriodIdSet == null) {
            int startPeriodYear = this.getPeriodYearStart();
            int startPeriodNumber = this.getPeriodNumberStart();
            PeriodInfo currPeriod = null;
            currPeriod = this.getProfitCenters() != null ? this.getProfitCenterCurrPeriod() : this.getCurrPeriod();
            if (currPeriod == null || currPeriod.getNumber() >= startPeriodYear * 100 + startPeriodNumber) {
                return this.getPeriodIdSet();
            }
            startPeriodYear = currPeriod.getPeriodYear();
            startPeriodNumber = currPeriod.getPeriodNumber();
            this.balQueryPeriodIdSet = this.getPeriodIdSet(startPeriodYear, startPeriodNumber);
        }
        return this.balQueryPeriodIdSet;
    }

    private Set getPeriodIdSet() throws BOSException, EASBizException {
        if (this.voucherQueryPeriodIdSet == null) {
            int startPeriodYear = this.getPeriodYearStart();
            int startPeriodNumber = this.getPeriodNumberStart();
            this.voucherQueryPeriodIdSet = this.getPeriodIdSet(startPeriodYear, startPeriodNumber);
        }
        return this.voucherQueryPeriodIdSet;
    }

    private Set getPeriodIdSet(int startPeriodYear, int startPeriodNumber) throws BOSException {
        int endPeriodYear = this.getPeriodYearEnd();
        int endPeriodNumber = this.getPeriodNumberEnd();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.getPeriodTypeId()));
        if (startPeriodYear == endPeriodYear && startPeriodNumber == endPeriodNumber) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(startPeriodYear * 100 + startPeriodNumber)));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(startPeriodYear * 100 + startPeriodNumber), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(endPeriodYear * 100 + endPeriodNumber), CompareType.LESS_EQUALS));
        }
        view.setFilter(filter);
        IPeriod iPeriod = this.ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)this.ctx);
        PeriodCollection periodColl = iPeriod.getPeriodCollection(view);
        HashSet<String> periodIdSet = new HashSet<String>();
        if (!periodColl.isEmpty()) {
            for (int i = 0; i < periodColl.size(); ++i) {
                periodIdSet.add(periodColl.get(i).getId().toString());
            }
        }
        return periodIdSet;
    }

    public Set<String> getPeriodIdSetByRange(int startPeriod, int endPeriod) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.getPeriodTypeId()));
        if (startPeriod == endPeriod) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)endPeriod, CompareType.LESS_EQUALS));
        }
        view.setFilter(filter);
        IPeriod iPeriod = this.ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)this.ctx);
        PeriodCollection periodColl = iPeriod.getPeriodCollection(view);
        HashSet<String> periodIdSet = new HashSet<String>();
        if (!periodColl.isEmpty()) {
            for (int i = 0; i < periodColl.size(); ++i) {
                periodIdSet.add(periodColl.get(i).getId().toString());
            }
        }
        return periodIdSet;
    }

    public void clearPeriodIdCache() {
        this.balQueryPeriodIdSet = null;
        this.voucherQueryPeriodIdSet = null;
    }

    public String getPeriodNumbersInSql(boolean isFromBeginPeriod) throws EASBizException, BOSException {
        return SQLUtil.buildPeriodNumbersInSql(isFromBeginPeriod, this);
    }

    public Set getPeriodNumbers(boolean isFromBeginPeriod) throws EASBizException, BOSException {
        return SQLUtil.buildPeriodNumbers(isFromBeginPeriod, this);
    }

    public void setCompanyIdsStr(String companyIds) {
        this.companyIdsStr = companyIds;
    }

    public String getCompanyIdsStr() throws BOSException {
        if (this.companyIdsStr == null) {
            Set idSet = this.getCompanyIds();
            this.companyIdsStr = this.genCompanyIdsStr(idSet);
        }
        return this.companyIdsStr;
    }

    public String getCompanyIdsStrWithGL053() throws BOSException, EASBizException {
        Set idSet = this.getCompanyIdsWithGL053();
        this.companyIdsStr = this.genCompanyIdsStr(idSet);
        return this.companyIdsStr;
    }

    public Set getCompanyIds() {
        Set<String> idSet = new HashSet<String>();
        if (this.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            idSet.add(this.getCompany().getId().toString());
        } else {
            idSet = this.getAllCompanyIds();
        }
        return idSet;
    }

    public Set getCompanyIdsWithGL053() throws BOSException, EASBizException {
        Set<String> idSet = new HashSet();
        idSet = this.getAllCompanyIds();
        IOrgRange orgRange = null;
        BOSUuid currentUserID = null;
        String compId = null;
        if (this.ctx != null) {
            orgRange = OrgRangeFactory.getLocalInstance((Context)this.ctx);
            currentUserID = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId();
            compId = ContextUtil.getCurrentFIUnit((Context)this.ctx).getId().toString();
        } else {
            orgRange = OrgRangeFactory.getRemoteInstance();
            currentUserID = SysContext.getSysContext().getCurrentUserInfo().getId();
            compId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        }
        List compIdList = orgRange.getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(currentUserID), OrgRangeType.BIZ_ORG_TYPE);
        HashSet compIdSet = new HashSet(compIdList);
        idSet.retainAll(compIdSet);
        if (idSet.size() == 0) {
            idSet.add(compId);
        }
        return idSet;
    }

    public Set getProfitCenterIds() {
        Set<String> idSet = new HashSet<String>();
        if (this.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            idSet.add(this.getProfitCenter().getId().toString());
        } else {
            idSet = this.getAllProfitCenterIds();
        }
        return idSet;
    }

    public Set getAllCompanyIds() {
        HashSet<String> idSet = new HashSet<String>();
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    public Set getAllProfitCenterIds() {
        HashSet<String> idSet = new HashSet<String>();
        ProfitCenterOrgUnitInfo[] profitCenters = this.getProfitCenters();
        for (int i = 0; i < profitCenters.length; ++i) {
            idSet.add(profitCenters[i].getId().toString());
        }
        return idSet;
    }

    public String getAllProfitCenterIdsStr() throws BOSException {
        return this.genProfitCenterIdsStr(this.getAllProfitCenterIds());
    }

    public CompanyOrgUnitInfo[] getCompanys() {
        if (this.companys != null) {
            return this.companys;
        }
        this.companys = this.getCompanysByCompanyTree();
        return this.companys;
    }

    public void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.companys = companys;
    }

    protected String genCompanyIdsStr(Set companyIds) throws BOSException {
        if (companyIds.size() > 500) {
            String companyIDTempTable = GLRptDaoUtil.createIdTempTable(this.ctx, companyIds);
            return "(select fid from " + companyIDTempTable + ")";
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = companyIds.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    private String genProfitCenterIdsStr(Set profitCenterIds) throws BOSException {
        if (profitCenterIds.size() > 500) {
            String profitCenterIDTempTable = GLRptDaoUtil.createIdTempTable(this.ctx, profitCenterIds);
            return "(select fid from " + profitCenterIDTempTable + ")";
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = profitCenterIds.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    public boolean isAfterCurrPeriod() throws EASBizException, BOSException {
        PeriodInfo currPeriod = null;
        currPeriod = this.getProfitCenters() != null ? this.getProfitCenterCurrPeriod() : this.getCurrPeriod();
        if (this.isAfterCurrPeriod == null) {
            this.isAfterCurrPeriod = this.getPeriodYearEnd() * 100 + this.getPeriodNumberEnd() > currPeriod.getNumber() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isAfterCurrPeriod;
    }

    public String getAccountIdFilter() throws BOSException {
        if (this.accountIdStr == null) {
            this.accountIdStr = this.genAccountIdsStr();
        }
        return this.accountIdStr;
    }

    public void setAccountIdFilter(String filter) {
        this.accountIdStr = filter;
        this.accountIdSet = null;
    }

    protected String genAccountIdsStr() throws BOSException {
        AccountViewCollection accts;
        FilterInfo filter;
        EntityViewInfo view;
        boolean useNumberFilter = false;
        if (!(this.getAccountCodeStart() == null && this.getAccountCodeEnd() == null || this.getAccountIdSet().isEmpty())) {
            useNumberFilter = true;
        }
        if (this.getAccountIdSet().size() > 500) {
            String accountTempTable = GLRptDaoUtil.createIdTempTable(this.ctx, this.getAccountIdSet());
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT fid from ").append(accountTempTable);
            if (useNumberFilter) {
                sql.append(" t where exists (select 1 from t_bd_accountview av where ");
                if (this.getAccountCodeStart() != null) {
                    sql.append("av.fnumber >= '").append(this.getAccountCodeStart()).append("'");
                    if (this.getAccountCodeEnd() != null) {
                        sql.append(" and ");
                    }
                }
                if (this.getAccountCodeEnd() != null) {
                    sql.append("av.fnumber < '").append(this.getAccountCodeEnd()).append("zz'");
                }
                sql.append(" and av.fid = t.fid) ");
            }
            return sql.toString();
        }
        StringBuffer accountIds = new StringBuffer();
        Set<String> accountIdSet = this.getAccountIdSet();
        if (accountIdSet.isEmpty()) {
            return "''";
        }
        if (this.companys != null && this.companys.length > 1 || this.profitCenters != null && this.profitCenters.length > 1) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
            if (useNumberFilter) {
                if (this.getAccountCodeStart() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.getAccountCodeStart(), CompareType.GREATER_EQUALS));
                }
                if (this.getAccountCodeEnd() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)(this.getAccountCodeEnd() + "zz"), CompareType.LESS));
                }
            }
            view.setFilter(filter);
            accts = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
            HashSet<String> acctNumSet = new HashSet<String>();
            for (int i = 0; i < accts.size(); ++i) {
                acctNumSet.add(accts.get(i).getNumber());
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", acctNumSet, CompareType.INCLUDE));
            String companyId = this.getCompanyId();
            if (null == companyId) {
                companyId = this.company.getId().toString();
            }
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.getAccountTableId()));
            filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyId));
            view.setFilter(filter);
            accts = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
            accountIdSet = new HashSet<String>();
            for (int i = 0; i < accts.size(); ++i) {
                accountIdSet.add((String)accts.get(i).getId());
            }
        } else if (useNumberFilter) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
            if (this.getAccountCodeStart() != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.getAccountCodeStart(), CompareType.GREATER_EQUALS));
            }
            if (this.getAccountCodeEnd() != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)(this.getAccountCodeEnd() + "zz"), CompareType.LESS));
            }
            view.setFilter(filter);
            accts = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
            accountIdSet = new HashSet<String>();
            for (int i = 0; i < accts.size(); ++i) {
                accountIdSet.add((String)accts.get(i).getId());
            }
        }
        if (accountIdSet.isEmpty()) {
            return "''";
        }
        Iterator<String> it = accountIdSet.iterator();
        accountIds.append("'").append((Object)it.next()).append("'");
        while (it.hasNext()) {
            accountIds.append(",'").append((Object)it.next()).append("'");
        }
        return accountIds.toString();
    }

    public void setAccountIdSet(Set accountIdSet) {
        this.accountIdStr = null;
        this.accountIdSet = accountIdSet;
    }

    public void setLeafAccount(boolean isLeafAccount) {
        this.isLeafAccount = isLeafAccount;
    }

    public boolean isLeafAccount() {
        return this.isLeafAccount;
    }

    public boolean isSupportUnion() {
        return this.isSupportUnion;
    }

    public void setSupportUnion(boolean isSupportUnion) {
        this.isSupportUnion = isSupportUnion;
    }

    public CompanyOrgUnitInfo[] getSelectedCompanys() {
        if (this.selectedCompanys != null) {
            return this.selectedCompanys;
        }
        this.selectedCompanys = this.getCompanysByCompanyTree();
        return this.selectedCompanys;
    }

    public void setSelectedCompanys(CompanyOrgUnitInfo[] selectedCompanys) {
        this.selectedCompanys = selectedCompanys;
    }

    private CompanyOrgUnitInfo[] getCompanysByCompanyTree() {
        CompanyOrgUnitInfo[] companys;
        DefaultMutableTreeNode companyTree = (DefaultMutableTreeNode)this.getTreeModelOfCompany();
        if (companyTree == null) {
            companys = new CompanyOrgUnitInfo[]{this.getCompany()};
        } else {
            ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
            Enumeration<TreeNode> enums = companyTree.breadthFirstEnumeration();
            while (enums.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enums.nextElement();
                if (!node.isLeaf() || node.getUserObject() == null) continue;
                companyList.add(RptClientUtil.toCompanyOrgUnitInfo((SimpleCompanyUserObject)node.getUserObject()));
            }
            CompanyOrgUnitInfo[] simpleCompanys = new CompanyOrgUnitInfo[companyList.size()];
            companys = companyList.toArray(simpleCompanys);
        }
        return companys;
    }

    private ProfitCenterOrgUnitInfo[] getProfitCentersByProfitCenterTree() {
        ProfitCenterOrgUnitInfo[] profitCenters;
        DefaultMutableTreeNode profitCenterTree = (DefaultMutableTreeNode)this.getTreeModelOfProfitCenter();
        if (profitCenterTree == null) {
            profitCenters = new ProfitCenterOrgUnitInfo[]{this.getProfitCenter()};
        } else {
            ArrayList<ProfitCenterOrgUnitInfo> profitCenterList = new ArrayList<ProfitCenterOrgUnitInfo>();
            Enumeration<TreeNode> enums = profitCenterTree.breadthFirstEnumeration();
            while (enums.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enums.nextElement();
                if (!node.isLeaf()) continue;
                profitCenterList.add(RptClientUtil.toProfitCenterOrgUnitInfo((SimpleCompanyUserObject)node.getUserObject()));
            }
            ProfitCenterOrgUnitInfo[] simpleProfitCenters = new ProfitCenterOrgUnitInfo[profitCenterList.size()];
            profitCenters = profitCenterList.toArray(simpleProfitCenters);
        }
        return profitCenters;
    }

    public boolean isFillInfo() {
        return this.isFillInfo;
    }

    public void setFillInfo(boolean fillInfo) {
        this.isFillInfo = fillInfo;
    }

    public String getExtendParams() {
        return this.extendParams;
    }

    public void setExtendParams(String extendParams) {
        this.extendParams = extendParams;
    }

    public String getExtendParam(String param) {
        if (param == null) {
            return null;
        }
        if (this.exParams != null) {
            return (String)this.exParams.get(param);
        }
        this.exParams = new HashMap();
        try {
            String strExtends = this.extendParams;
            if (strExtends != null && strExtends.trim().length() > 0 && (strExtends = strExtends.trim()).length() > 0 && strExtends.startsWith("[{") && strExtends.endsWith("}]")) {
                List paramExList = (List)JSON.parseObject((String)strExtends, List.class);
                for (Object obj : paramExList) {
                    ParamEx paramEx = (ParamEx)JSON.parseObject((String)obj.toString(), ParamEx.class);
                    this.exParams.put(paramEx.name, paramEx.value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)this.exParams.get(param);
    }
}

