/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.CashflowTableService;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBasePage;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CashflowTablePage
extends GLNRptBasePage {
    private static final String CF_RESOURCE = "com.kingdee.eas.fi.gl.GLNRptCFResource";
    protected boolean sumByUnion = false;
    protected boolean showAsst = false;
    protected boolean showExchangeItem = false;
    protected boolean showInvisibleItem = false;
    protected boolean showCashInitEndBalance = false;
    protected boolean showSupplementItem = false;
    protected boolean showAsstNumber = false;
    protected boolean showAsstLongName = false;
    protected Integer sumItemLevel = 10;
    protected Integer colCount = 0;
    private int currencyScale = 4;
    private int maxScale = 4;
    private boolean isForCurrency = true;
    private Map<Integer, String> typeAlias = null;
    private Map<String, Object> hgs = new HashMap<String, Object>();
    private Map<String, String> hgIdToAsstAccountIds = new HashMap<String, String>();
    private Map<String, String> hgNameCache = new HashMap<String, String>();
    private Map<String, List<AsstActTypeInfo>> asstActTypess = new HashMap<String, List<AsstActTypeInfo>>();

    @Override
    protected void init() {
        int count2;
        super.init();
        Object param = this.params.get("sumByUnion");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.sumByUnion = true;
        }
        if ((param = this.params.get("showAsst")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsst = true;
        }
        if ((param = this.params.get("showExchangeItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showExchangeItem = true;
        }
        if ((param = this.params.get("showInvisibleItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showInvisibleItem = true;
        }
        if ((param = this.params.get("showCashInitEndBalance")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCashInitEndBalance = true;
        }
        if ((param = this.params.get("showSupplementItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showSupplementItem = true;
        }
        if ((param = this.params.get("showAsstNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstNumber = true;
        }
        if ((param = this.params.get("isForCurrency")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.isForCurrency = true;
        }
        if ((param = this.params.get("showAsstLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstLongName = true;
        }
        if ((param = this.params.get("sumItemLevel")) != null && param.toString().trim().length() > 0) {
            try {
                count2 = Integer.parseInt(param.toString().trim());
                if (count2 > 0) {
                    this.sumItemLevel = count2;
                }
            }
            catch (Exception count2) {
                // empty catch block
            }
        }
        if ((param = this.params.get("colCount")) != null && param.toString().trim().length() > 0) {
            try {
                count2 = Integer.parseInt(param.toString().trim());
                if (count2 > 0) {
                    this.colCount = count2;
                }
            }
            catch (Exception count3) {
                // empty catch block
            }
        }
        if ((param = this.params.get("maxScale")) != null && param.toString().trim().length() > 0) {
            try {
                int count4 = Integer.parseInt(param.toString().trim());
                if (count4 > 0) {
                    this.maxScale = count4;
                }
            }
            catch (Exception count4) {
                // empty catch block
            }
        }
        if ((param = this.params.get("currencyScale")) != null && param.toString().trim().length() > 0) {
            try {
                int count5 = Integer.parseInt(param.toString().trim());
                if (count5 > 0) {
                    this.currencyScale = count5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.showAsst) {
            this.typeAlias = new HashMap<Integer, String>();
            this.typeAlias.put(1, "");
            this.typeAlias.put(2, CashflowTypeEnum.getEnum((int)2).toString());
            this.typeAlias.put(3, CashflowTypeEnum.getEnum((int)3).toString());
        }
    }

    @Override
    protected String getPageSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select /*+ LEADING(b) */ \n");
        sql.append("    KSQL_SEQ, \n");
        sql.append("    itemName, \n");
        sql.append("    itemID, \n");
        sql.append("    itemType, \n");
        sql.append("    itemLevel, \n");
        sql.append("    isExchange, \n");
        sql.append("    isProfit, \n");
        sql.append("    companyName, \n");
        sql.append("    companyLevel, \n");
        sql.append("    companyId, \n");
        if (this.showAsst) {
            sql.append("    hgID, \n");
            sql.append("    FType, \n");
        }
        sql.append("    amount, \n");
        sql.append("    yearSum, \n");
        sql.append("    flag, \n");
        sql.append("    canQuery \n");
        sql.append("from " + this.params.get("pageId") + " b \n");
        sql.append("where KSQL_SEQ >= ? and KSQL_SEQ < ? \n");
        sql.append("order by KSQL_SEQ \n");
        return sql.toString();
    }

    @Override
    protected Object buildCache(ResultSet rowset) throws BOSException, SQLException {
        HashMap cache = new HashMap();
        if (!this.showAsst) {
            return cache;
        }
        HashSet<String> hgIds = new HashSet<String>();
        while (rowset.next()) {
            String hgID = rowset.getString("hgID");
            if (hgID == null || hgID.trim().length() <= 0) continue;
            hgIds.add(hgID);
        }
        rowset.beforeFirst();
        Map<String, Set<String>> hgIdss = this.groupHgIds(this.ctx, hgIds);
        HashMap<String, Object> hgs = new HashMap<String, Object>();
        for (String asstAccountId : hgIdss.keySet()) {
            Set<String> tempIds = hgIdss.get(asstAccountId);
            Set<Object> ids = new HashSet();
            if (hgs.size() == 0) {
                ids = tempIds;
            } else {
                for (String tempId : tempIds) {
                    if (hgs.containsKey(tempId)) continue;
                    ids.add(tempId);
                }
            }
            if (ids.size() <= 0) continue;
            try {
                Map<String, Object> map = GLAsstAccountUtils.getAssistantHgs(this.ctx, asstAccountId, this.getAsstActTypes(this.ctx, asstAccountId), ids);
                hgs.putAll(map);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        cache.put("hgs", hgs);
        return cache;
    }

    private List<String> getCategoryRowData(String itemName) {
        ArrayList<String> rowData = new ArrayList<String>();
        rowData.add(itemName);
        for (int i = 0; i < this.colCount - 1; ++i) {
            rowData.add(null);
        }
        return rowData;
    }

    public String getCFResource(String resName) {
        return ResourceBase.getString((String)CF_RESOURCE, (String)resName, (Locale)this.ctx.getLocale());
    }

    @Override
    protected List<String> buildRow(ResultSet rs, Object cache) throws BOSException, SQLException {
        boolean addition;
        ArrayList<String> list = new ArrayList<String>();
        String itemName = rs.getString("itemName");
        Integer itemLevel = rs.getInt("itemLevel");
        String companyName = rs.getString("companyName");
        Integer companyLevel = rs.getInt("companyLevel");
        BigDecimal amount = rs.getBigDecimal("amount");
        BigDecimal yearSum = rs.getBigDecimal("yearSum");
        String itemID = rs.getString("itemID");
        String companyID = rs.getString("companyId");
        int flag = rs.getInt("flag");
        int itemType = rs.getInt("itemType");
        int isExchange = rs.getInt("isExchange");
        if (itemLevel == 1) {
            List<String> categoryRowData = this.getCategoryRowData(itemName);
            return categoryRowData;
        }
        boolean isAsstRow = false;
        if (flag == CashflowTableService.Flag.ASST.getValue()) {
            isAsstRow = true;
        }
        boolean isNetRow = flag == CashflowTableService.Flag.NET_AMOUNT.getValue() || flag == CashflowTableService.Flag.NET_TOTAL_AMOUNT.getValue() || flag == CashflowTableService.Flag.ALL_CASH_BEGIN.getValue() || flag == CashflowTableService.Flag.ALL_CASH_END.getValue() || flag == CashflowTableService.Flag.NET_DEAL_ACTIVITY.getValue();
        list.add(itemName);
        list.add(null);
        list.add(companyName);
        if (this.showAsst && itemType == 0) {
            Integer type = rs.getInt("FType");
            list.add(this.typeAlias.get(type));
        } else if (this.showAsst) {
            list.add(null);
        }
        if (this.showAsst) {
            String hgID = rs.getString("hgID");
            this.setHgColumn(hgID, list, itemType, cache);
        } else if (this.showAsst) {
            list.add(null);
        }
        int scale = this.isForCurrency ? this.currencyScale : this.maxScale;
        list.add(amount.compareTo(BigDecimal.ZERO) == 0 ? null : amount.setScale(scale, 4).toPlainString());
        list.add(yearSum.compareTo(BigDecimal.ZERO) == 0 ? null : yearSum.setScale(scale, 4).toPlainString());
        boolean bl = addition = flag == CashflowTableService.Flag.CASH_END.getValue() || flag == CashflowTableService.Flag.CASH_BEGIN.getValue() || flag == CashflowTableService.Flag.EQU_END.getValue() || flag == CashflowTableService.Flag.EQU_BEGIN.getValue() || flag == CashflowTableService.Flag.NET_TOTAL_AMOUNT_LAST.getValue();
        if (isNetRow || addition) {
            itemLevel = 2;
        }
        list.add(itemLevel.toString());
        list.add(companyLevel.toString());
        if (isNetRow) {
            list.add("1");
        } else {
            list.add("0");
        }
        list.add(itemID);
        list.add(companyID);
        if (this.showAsst && itemType == 0) {
            list.add(rs.getString("hgID"));
            list.add(isAsstRow ? "1" : "0");
        } else if (this.showAsst) {
            list.add(null);
            list.add("0");
        }
        boolean canQuery = !isNetRow && !addition && rs.getInt("canQuery") != 0 && rs.getInt("ISPROFIT") != 1 && (rs.getInt("canQuery") == 1 || flag == CashflowTableService.Flag.ASST.getValue() || flag == CashflowTableService.Flag.ITEM.getValue());
        list.add(canQuery ? "1" : "0");
        return list;
    }

    private Map<String, Set<String>> groupHgIds(Context ctx, Set<String> hgIds) throws BOSException {
        HashMap<String, Set<String>> hgIdss = new HashMap<String, Set<String>>();
        if (hgIds.size() <= 0) {
            return hgIdss;
        }
        String sql = "select FID, FAsstAccountID from T_BD_AssistantHG where FID in ";
        List<Set<String>> batchs = GlUtils.split(hgIds, 100);
        try {
            for (Set<String> batch : batchs) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + SQLUtil.buildMarkSQL(batch.size())), (Object[])batch.toArray());
                while (rs.next()) {
                    String asstAccountId = rs.getString("FAsstAccountID");
                    if (asstAccountId == null) continue;
                    HashSet<String> set = (HashSet<String>)hgIdss.get(asstAccountId);
                    if (set == null) {
                        set = new HashSet<String>();
                        hgIdss.put(asstAccountId, set);
                    }
                    String hgId = rs.getString("FID");
                    set.add(hgId);
                    this.hgIdToAsstAccountIds.put(hgId, asstAccountId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hgIdss;
    }

    private List<AsstActTypeInfo> getAsstActTypes(Context ctx, String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        AsstActTypeCollection aats = VoucherProcessCache.getAsstActTypes(ctx, asstAccountId);
        ArrayList<AsstActTypeInfo> asstActTypes = new ArrayList<AsstActTypeInfo>(aats.size());
        for (AsstActTypeInfo aat : aats) {
            if (this.showAsstNumber) {
                if (aat.isUseLongNumber()) {
                    aat.put("showLongNumber", (Object)true);
                } else {
                    aat.put("showNumber", (Object)true);
                }
            }
            if (this.showAsstLongName) {
                aat.put("showLongName", (Object)true);
            }
            if (this.showAsstNumber && this.showAsstLongName) {
                aat.put("showName", (Object)false);
            } else {
                aat.put("showName", (Object)true);
            }
            asstActTypes.add(aat);
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    private void setHgColumn(String hgID, List<String> list, int itemType, Object cache) throws BOSException {
        if (!this.showAsst) {
            return;
        }
        if (itemType == 1 || StringUtils.isEmpty((String)hgID)) {
            list.add(null);
            return;
        }
        if (this.hgNameCache.containsKey(hgID)) {
            list.add(this.hgNameCache.get(hgID));
            return;
        }
        Map hgs = (Map)((Map)cache).get("hgs");
        Map hg = (Map)hgs.get(hgID);
        List<AsstActTypeInfo> asstActTypes = this.getAsstActTypes(this.ctx, this.hgIdToAsstAccountIds.get(hgID));
        StringBuilder asstStr = new StringBuilder();
        if (hg != null && asstActTypes != null) {
            for (int k = 0; k < asstActTypes.size(); ++k) {
                String number;
                AsstActTypeInfo asstActType = asstActTypes.get(k);
                asstStr.append(asstActType.getName());
                asstStr.append(":");
                if (!this.showAsstNumber && !this.showAsstLongName) {
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".name"));
                } else if (this.showAsstNumber && !this.showAsstLongName) {
                    if (asstActType.isUseLongNumber()) {
                        number = (String)hg.get(asstActType.getNumber() + ".longNumber");
                        if (number != null) {
                            number = number.replace('!', '.');
                        }
                    } else {
                        number = (String)hg.get(asstActType.getNumber() + ".number");
                    }
                    asstStr.append(number);
                    asstStr.append(" ");
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".name"));
                } else if (!this.showAsstNumber && this.showAsstLongName) {
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".longName"));
                } else {
                    if (asstActType.isUseLongNumber()) {
                        number = (String)hg.get(asstActType.getNumber() + ".longNumber");
                        if (number != null) {
                            number = number.replace('!', '.');
                        }
                    } else {
                        number = (String)hg.get(asstActType.getNumber() + ".number");
                    }
                    asstStr.append(number);
                    asstStr.append(" ");
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".longName"));
                }
                asstStr.append(";");
            }
        }
        String hgName = asstStr.toString();
        list.add(hgName);
        this.hgNameCache.put(hgID, hgName);
    }
}

