/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class GLNRptBasePage {
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    protected Map<String, Object> result = new HashMap<String, Object>();
    protected List<List<String>> rows = new ArrayList<List<String>>();
    protected List<String> errs = new ArrayList<String>();
    protected Context ctx;
    protected Map params;
    protected int startIndex = 1;
    protected int pageSize = 100;
    protected boolean showFor = false;
    protected boolean showLocal = false;
    protected boolean showRpt = false;
    protected boolean showQty = false;
    protected boolean notIncludePLVoucher = false;
    protected boolean showCompanyLongNumber = false;
    protected boolean showCompanyName = false;
    protected boolean showCompanyLevel = false;
    protected boolean showCompanyBizUnit = false;
    protected boolean showAccountName = false;
    protected boolean showAccountLongName = false;
    protected boolean showAccountLevel = false;
    protected boolean showAccountDc = false;
    protected boolean showCurrencyNumber = false;
    protected boolean showCurrencyName = false;
    protected Map<String, Integer> precisions = new HashMap<String, Integer>();
    private Map<String, List<AsstActTypeInfo>> aatss = null;

    protected void init() {
        int i2;
        this.result.put("rows", this.rows);
        this.result.put("errs", this.errs);
        Object param = this.params.get("showFor");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showFor = true;
        }
        if ((param = this.params.get("showLocal")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showLocal = true;
        }
        if ((param = this.params.get("showRpt")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showRpt = true;
        }
        if ((param = this.params.get("showQty")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showQty = true;
        }
        if ((param = this.params.get("notIncludePLVoucher")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notIncludePLVoucher = true;
        }
        if ((param = this.params.get("showCompanyLongNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyLongNumber = true;
        }
        if ((param = this.params.get("showCompanyName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyName = true;
        }
        if ((param = this.params.get("showCompanyLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyLevel = true;
        }
        if ((param = this.params.get("showCompanyBizUnit")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyBizUnit = true;
        }
        if ((param = this.params.get("showAccountName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountName = true;
        }
        if ((param = this.params.get("showAccountLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountLongName = true;
        }
        if ((param = this.params.get("showAccountLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountLevel = true;
        }
        if ((param = this.params.get("showAccountDc")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountDc = true;
        }
        if ((param = this.params.get("showCurrencyNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCurrencyNumber = true;
        }
        if ((param = this.params.get("showCurrencyName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCurrencyName = true;
        }
        if ((param = this.params.get("startIndex")) != null && param.toString().trim().length() > 0) {
            try {
                i2 = Integer.parseInt(param.toString().trim());
                if (i2 > 0) {
                    this.startIndex = i2;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        if ((param = this.params.get("pageSize")) != null && param.toString().trim().length() > 0) {
            try {
                i2 = Integer.parseInt(param.toString().trim());
                if (i2 > 0) {
                    this.pageSize = i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, Object> query(Context ctx, Map params) throws BOSException, SQLException {
        this.ctx = ctx;
        this.params = params;
        this.init();
        if (this.errs.size() > 0) {
            return this.result;
        }
        this.rows.clear();
        Object param = params.get("search");
        if (param != null && "true".equalsIgnoreCase(param.toString())) {
            return this.search(ctx, params);
        }
        String pageSql = this.getPageSql();
        if (pageSql != null) {
            List pageParams = this.getPageParams();
            IRowSet rowset = pageParams != null && pageParams.size() > 0 ? DbUtil.executeQuery((Context)ctx, (String)pageSql, (Object[])pageParams.toArray()) : DbUtil.executeQuery((Context)ctx, (String)pageSql);
            this.buildData((ResultSet)rowset);
        }
        return this.result;
    }

    protected String getPageSql() {
        return null;
    }

    protected List getPageParams() {
        ArrayList<Integer> pageParams = new ArrayList<Integer>();
        pageParams.add(this.startIndex);
        pageParams.add(this.startIndex + this.pageSize);
        return pageParams;
    }

    protected void buildData(ResultSet rowset) throws BOSException, SQLException {
        Object cache = this.buildCache(rowset);
        while (rowset.next()) {
            List<String> row = this.buildRow(rowset, cache);
            if (row == null) continue;
            this.rows.add(row);
        }
    }

    protected Object buildCache(ResultSet rowset) throws BOSException, SQLException {
        return null;
    }

    protected List<String> buildRow(ResultSet rowset, Object cache) throws BOSException, SQLException {
        return null;
    }

    protected String[] buildAssData(final Map<String, Integer> aatIndexs, ResultSet rowset, String idField, String ngField, String dgField, boolean showType, boolean showNumber, boolean showName, boolean showLongName) throws SQLException {
        int i;
        String assGrpId = rowset.getString(idField);
        if (assGrpId == null || assGrpId.length() == 0) {
            return new String[0];
        }
        List<String[]> ngs = this.splitNumberGroup(rowset.getString(ngField));
        if (ngs == null) {
            return new String[]{"NumberGroupError:" + assGrpId};
        }
        if (showLongName) {
            List<String[]> dgs = this.splitDisplayNameGroup(rowset.getString(dgField));
            if (dgs == null || dgs.size() != ngs.size()) {
                return new String[]{"DisplayNameGroupError:" + assGrpId};
            }
            for (i = 0; i < ngs.size(); ++i) {
                ngs.get((int)i)[3] = dgs.get(i)[2];
            }
        }
        if (ngs.size() > 1 && aatIndexs != null && aatIndexs.size() > 0) {
            Collections.sort(ngs, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    Integer index2;
                    Integer index1 = (Integer)aatIndexs.get(o1[0]);
                    if (index1 == null) {
                        index1 = 99;
                    }
                    if ((index2 = (Integer)aatIndexs.get(o2[0])) == null) {
                        index2 = 99;
                    }
                    return index1 - index2;
                }
            });
        }
        String[] result = new String[ngs.size()];
        for (i = 0; i < ngs.size(); ++i) {
            String string = result[i] = showNumber ? ngs.get(i)[2] : "";
            if (showName || showLongName) {
                if (result[i].length() > 0) {
                    int n = i;
                    result[n] = result[n] + " ";
                }
                int n = i;
                result[n] = result[n] + ngs.get(i)[3];
            }
            if (!showType) continue;
            result[i] = ngs.get(i)[1] + ":" + result[i];
        }
        return result;
    }

    protected List<String[]> splitNumberGroup(String numberGroup) {
        if (numberGroup != null && numberGroup.length() > 0) {
            String[] groups = numberGroup.split(";");
            ArrayList<String[]> result = new ArrayList<String[]>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                String[] strs = groups[i].replaceAll("_!", ":").split(":");
                if (strs.length != 4) {
                    return null;
                }
                result.add(strs);
            }
            return result;
        }
        return null;
    }

    protected List<String[]> splitDisplayNameGroup(String displayNameGroup) {
        if (displayNameGroup != null && displayNameGroup.length() > 0) {
            String[] groups = displayNameGroup.split(";");
            ArrayList<String[]> result = new ArrayList<String[]>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                String[] strs = groups[i].replaceAll("_!", ":").split(":");
                if (strs.length != 3) {
                    return null;
                }
                result.add(strs);
            }
            return result;
        }
        return null;
    }

    protected int getCurrencyPrecision(Context ctx, String currencyId) {
        if (currencyId == null) {
            return 2;
        }
        if (this.precisions.containsKey(currencyId)) {
            return this.precisions.get(currencyId);
        }
        int precision = 2;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FPrecision from T_BD_Currency where FID = ?", (Object[])new String[]{currencyId});
            if (rs.next()) {
                precision = rs.getInt("FPrecision");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.precisions.put(currencyId, precision);
        return precision;
    }

    protected List<AsstActTypeInfo> getAsstActTypes(String asstAccountId, List<AsstActTypeInfo> sorts) throws BOSException {
        List<AsstActTypeInfo> aats;
        if (this.aatss == null) {
            this.aatss = new HashMap<String, List<AsstActTypeInfo>>();
        }
        String key = asstAccountId;
        final HashMap<String, Integer> indexs = new HashMap<String, Integer>();
        if (sorts != null && sorts.size() > 0) {
            for (int i = 0; i < sorts.size(); ++i) {
                key = key + sorts.get(i).getNumber();
                indexs.put(sorts.get(i).getNumber(), i);
            }
        }
        if ((aats = this.aatss.get(key)) != null) {
            return aats;
        }
        AsstActTypeCollection coll = GLAsstAccountUtils.getAsstActTypes(this.ctx, asstAccountId);
        aats = new ArrayList<AsstActTypeInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            aats.add(coll.get(i));
        }
        if (aats.size() > 1 && indexs.size() > 0) {
            Collections.sort(aats, new Comparator<AsstActTypeInfo>(){

                @Override
                public int compare(AsstActTypeInfo o1, AsstActTypeInfo o2) {
                    Integer index2;
                    Integer index1 = (Integer)indexs.get(o1.getNumber());
                    if (index1 == null) {
                        index1 = 99;
                    }
                    if ((index2 = (Integer)indexs.get(o2.getNumber())) == null) {
                        index2 = 99;
                    }
                    return index1 - index2;
                }
            });
        }
        this.aatss.put(key, aats);
        return aats;
    }

    protected String[] buildAssData(List<AsstActTypeInfo> aats, Map<String, String> hg, boolean showType, boolean showNumber, boolean showName, boolean showLongName) {
        String[] asstActs = new String[aats.size()];
        for (int i = 0; i < aats.size(); ++i) {
            AsstActTypeInfo aat = aats.get(i);
            String number = null;
            if (showNumber) {
                if (aat.isUseLongNumber()) {
                    number = hg.get(aat.getNumber() + ".longNumber");
                    if (number == null) {
                        hg.get(aat.getNumber() + ".number");
                    } else {
                        number = number.replace('!', '.');
                    }
                } else {
                    number = hg.get(aat.getNumber() + ".number");
                }
            }
            if (number == null) {
                number = "";
            }
            String name = null;
            if (showLongName) {
                name = hg.get(aat.getNumber() + ".longName");
            } else if (showName) {
                name = hg.get(aat.getNumber() + ".name");
            }
            if (name == null) {
                name = "";
            }
            String asstAct = number.length() > 0 && name.length() > 0 ? number + " " + name : number + name;
            if (showType) {
                asstAct = aat.getName() + ":" + asstAct;
            }
            asstActs[i] = asstAct;
        }
        return asstActs;
    }

    public Map<String, Object> search(Context ctx, Map params) throws BOSException, SQLException {
        return this.result;
    }

    public String getResource(String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)this.ctx.getLocale());
    }
}

