/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBasePage;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GLNRptSubLedgerPage
extends GLNRptBasePage {
    private DateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean showAsstDetail = false;
    protected boolean showOppAccount = false;
    protected boolean showOppAsstact = false;
    protected boolean showVoucherId = false;
    protected List<AsstActTypeInfo> asstActTypes = null;
    private Map<String, Integer> aatIndexs = null;
    private boolean rebuildAsstAct = false;
    protected boolean showAsstActNumber = false;
    protected boolean showAsstActLongName = false;
    protected boolean sumByUnion = false;
    protected int asstMaxCount = 0;
    protected int oppAsstMaxCount = 0;
    protected String localPrecision = "";
    protected String rptPrecision = "";

    @Override
    protected void init() {
        super.init();
        Object param = this.params.get("showAsstDetail");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstDetail = true;
        }
        if ((param = this.params.get("showOppAccount")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showOppAccount = true;
        }
        if (this.showOppAccount && (param = this.params.get("showOppAsstact")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showOppAsstact = true;
        }
        if ((param = this.params.get("showVoucherId")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showVoucherId = true;
        }
        if ((param = this.params.get("showAsstActNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActNumber = true;
        }
        if ((param = this.params.get("showAsstActLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActLongName = true;
        }
        if ((param = this.params.get("sumByUnion")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.sumByUnion = true;
        }
        this.asstActTypes = (List)this.params.get("asstActTypes");
        this.aatIndexs = new HashMap<String, Integer>();
        for (int i = 0; i < this.asstActTypes.size(); ++i) {
            this.aatIndexs.put(this.asstActTypes.get(i).getNumber(), i);
        }
        param = this.params.get("rebuildAsstAct");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.rebuildAsstAct = true;
        }
        this.asstMaxCount = (Integer)this.params.get("asstMaxCount");
        this.oppAsstMaxCount = (Integer)this.params.get("oppAsstMaxCount");
        this.localPrecision = (String)this.params.get("localPrecision");
        this.rptPrecision = (String)this.params.get("rptPrecision");
    }

    @Override
    protected String getPageSql() {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select \n");
        sql.append("    /*+ LEADING(b) */ \n");
        sql.append("    b.FAccountNumber, \n");
        if (this.showAccountName) {
            sql.append("    av.FName_" + loc + " FAccountName, \n");
        }
        if (this.showAccountLongName) {
            sql.append("    av.FDisplayName_" + loc + " FAccountLongName, \n");
        }
        if (this.showAccountLevel) {
            sql.append("    av.FLevel FAccountLevel, \n");
        }
        if (this.showAccountDc) {
            sql.append("    av.FDC FAccountDc, \n");
        }
        sql.append("    b.FPeriod, \n");
        sql.append("    v.FBookedDate, \n");
        sql.append("    v.FBizDate, \n");
        sql.append("    v.FCreateTime, \n");
        sql.append("    c.FNumber FCompanyNumber, \n");
        if (this.showCompanyLongNumber) {
            sql.append("    c.FLongNumber FCompanyLongNumber, \n");
        }
        if (this.showCompanyName) {
            sql.append("    c.FName_" + loc + " FCompanyName, \n");
        }
        if (this.showCompanyLevel) {
            sql.append("    c.FLevel FCompanyLevel, \n");
        }
        if (this.showCompanyBizUnit) {
            sql.append("    c.FIsBizUnit, \n");
        }
        if (this.showVoucherId) {
            sql.append("    b.FVoucherID, \n");
        }
        sql.append("    vt.FName_" + loc + " FVoucherType, \n");
        sql.append("    v.FNumber FVoucherNumber, \n");
        sql.append("    b.FDescription, \n");
        sql.append("    u.FName_" + loc + " FCreatorName, \n");
        sql.append("    b.FEntrySeq, \n");
        sql.append("    cy.FID FCurrencyID, \n");
        if (this.showCurrencyNumber) {
            sql.append("    cy.FNumber FCurrencyNumber, \n");
        }
        if (this.showCurrencyName) {
            sql.append("    cy.FName_" + loc + " FCurrencyName, \n");
        }
        if (this.showAsstDetail) {
            sql.append("    b.FRecordSeq, \n");
            sql.append("    b.FAssGrpID, \n");
            if (this.rebuildAsstAct) {
                sql.append("    hg.FAsstAccountID FAsstAccountID, \n");
            } else {
                sql.append("    hg.FNumberGroup_" + loc + " FNumberGroup, \n");
                if (this.showAsstActLongName) {
                    sql.append("    hg.FDisplayNameGroup_" + loc + " FDisplayNameGroup, \n");
                }
            }
        }
        if (this.showOppAccount) {
            sql.append("    b.FOppEntrySeq, \n");
            sql.append("    oppav.FNumber FOppAccountNumber, \n");
            if (this.showAccountName) {
                sql.append("    oppav.FName_" + loc + " FOppAccountName, \n");
            }
            if (this.showAccountLongName) {
                sql.append("    oppav.FDisplayName_" + loc + " FOppAccountLongName, \n");
            }
            sql.append("    b.FOppDescription, \n");
        }
        if (this.showOppAsstact) {
            sql.append("    b.FOppRecordSeq, \n");
            sql.append("    b.FOppAssGrpID, \n");
            if (this.rebuildAsstAct) {
                sql.append("    opphg.FAsstAccountID FOppAsstAccountID, \n");
            } else {
                sql.append("    opphg.FNumberGroup_" + loc + " FOppNumberGroup, \n");
                if (this.showAsstActLongName) {
                    sql.append("    opphg.FDisplayNameGroup_" + loc + " FOppDisplayNameGroup, \n");
                }
            }
        }
        if (this.showFor) {
            sql.append("    FDebitFor, \n");
            sql.append("    FCreditFor, \n");
            sql.append("    FEndBalanceFor, \n");
        }
        if (this.showLocal) {
            sql.append("    FDebitLocal, \n");
            sql.append("    FCreditLocal, \n");
            sql.append("    FEndBalanceLocal, \n");
        }
        if (this.showRpt) {
            sql.append("    FDebitRpt, \n");
            sql.append("    FCreditRpt, \n");
            sql.append("    FEndBalanceRpt, \n");
        }
        if (this.showQty) {
            sql.append("    mu.FName_" + loc + " FMeasureUnitName, \n");
            sql.append("    FDebitQty, \n");
            sql.append("    FCreditQty, \n");
            sql.append("    FEndQty, \n");
        }
        sql.append("    b.FType \n");
        sql.append("from " + this.params.get("pageId") + " b \n");
        sql.append("left join T_GL_Voucher v on v.FID = b.FVoucherID \n");
        sql.append("left join T_BD_VoucherTypes vt on vt.FID = v.FVoucherTypeID \n");
        sql.append("left join T_PM_User u on u.FID = v.FCreatorID \n");
        sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        sql.append("left join T_BD_MeasureUnit mu on mu.FID = b.FMeasureUnitID \n");
        if (this.showAsstDetail) {
            sql.append("left join T_BD_AssistantHG hg on hg.FID = b.FAssGrpID \n");
        }
        if (this.showOppAccount) {
            sql.append("left join T_BD_AccountView oppav on oppav.FID = b.FOppAccountID \n");
        }
        if (this.showOppAsstact) {
            sql.append("left join T_BD_AssistantHG opphg on opphg.FID = b.FOppAssGrpID \n");
        }
        sql.append("where FRowIndex >= ? and FRowIndex < ? \n");
        sql.append("order by FRowIndex \n");
        return sql.toString();
    }

    @Override
    protected Object buildCache(ResultSet rowset) throws BOSException, SQLException {
        HashMap<String, Map<String, Object>> cache = new HashMap<String, Map<String, Object>>();
        if (this.rebuildAsstAct && (this.asstMaxCount > 0 || this.oppAsstMaxCount > 0)) {
            HashMap<String, HashSet<String>> idss = new HashMap<String, HashSet<String>>();
            while (rowset.next()) {
                Set<String> ids;
                String asstAccountId;
                String hgId;
                if (this.asstMaxCount > 0 && (hgId = rowset.getString("FAssGrpID")) != null && (asstAccountId = rowset.getString("FAsstAccountID")) != null) {
                    ids = (HashSet<String>)idss.get(asstAccountId);
                    if (ids == null) {
                        ids = new HashSet<String>();
                        idss.put(asstAccountId, (HashSet<String>)ids);
                    }
                    ids.add(hgId);
                }
                if (this.oppAsstMaxCount <= 0 || (hgId = rowset.getString("FOppAssGrpID")) == null || (asstAccountId = rowset.getString("FOppAsstAccountID")) == null) continue;
                ids = (Set)idss.get(asstAccountId);
                if (ids == null) {
                    ids = new HashSet();
                    idss.put(asstAccountId, (HashSet<String>)ids);
                }
                ids.add(hgId);
            }
            rowset.beforeFirst();
            Map<String, Object> hgs = null;
            for (String asstAccountId : idss.keySet()) {
                List<AsstActTypeInfo> aats = this.getAsstActTypes(asstAccountId, this.asstActTypes);
                for (AsstActTypeInfo aat : aats) {
                    aat.put("showNumber", (Object)this.showAsstActNumber);
                    if (aat.isUseLongNumber()) {
                        aat.put("showLongNumber", (Object)true);
                    }
                    aat.put("showName", (Object)(!this.showAsstActLongName ? 1 : 0));
                    aat.put("showLongName", (Object)this.showAsstActLongName);
                }
                if (hgs == null) {
                    hgs = GLAsstAccountUtils.getAssistantHgs(this.ctx, asstAccountId, aats, (Set)idss.get(asstAccountId));
                    continue;
                }
                hgs.putAll(GLAsstAccountUtils.getAssistantHgs(this.ctx, asstAccountId, aats, (Set)idss.get(asstAccountId)));
            }
            cache.put("hgs", hgs);
        }
        return cache;
    }

    @Override
    protected List<String> buildRow(ResultSet rowset, Object cache) throws BOSException, SQLException {
        String asstAccountId;
        Map hg;
        int type;
        ArrayList<String> row = new ArrayList<String>();
        row.add(rowset.getString("FAccountNumber"));
        if (this.showAccountName) {
            row.add(rowset.getString("FAccountName"));
        }
        if (this.showAccountLongName) {
            row.add(rowset.getString("FAccountLongName"));
        }
        if (this.showAccountLevel) {
            row.add(rowset.getString("FAccountLevel"));
        }
        if (this.showAccountDc) {
            row.add(rowset.getString("FAccountDc"));
        }
        if ((type = rowset.getInt("FType")) == 2) {
            Date bookedDate = rowset.getDate("FBookedDate");
            row.add(bookedDate != null ? this.DF.format(bookedDate) : "");
        } else {
            row.add(String.valueOf(type));
        }
        Date bizDate = rowset.getDate("FBizDate");
        row.add(bizDate != null ? this.DF.format(bizDate) : "");
        row.add(rowset.getString("FCompanyNumber"));
        if (this.showCompanyLongNumber) {
            row.add(rowset.getString("FCompanyLongNumber"));
        }
        if (this.showCompanyName) {
            row.add(rowset.getString("FCompanyName"));
        }
        if (this.showCompanyLevel) {
            row.add(rowset.getString("FCompanyLevel"));
        }
        if (this.showCompanyBizUnit) {
            row.add(String.valueOf(rowset.getInt("FIsBizUnit")));
        }
        if (this.showVoucherId) {
            row.add(rowset.getString("FVoucherID"));
        }
        row.add(rowset.getString("FVoucherType"));
        row.add(rowset.getString("FVoucherNumber"));
        row.add(rowset.getString("FDescription"));
        row.add(rowset.getString("FCreatorName"));
        if (this.showCurrencyNumber) {
            row.add(rowset.getString("FCurrencyNumber"));
        }
        if (this.showCurrencyName) {
            row.add(rowset.getString("FCurrencyName"));
        }
        if (this.showAsstDetail && this.asstMaxCount > 0) {
            String assGrpId = rowset.getString("FAssGrpID");
            row.add(assGrpId);
            String[] asstActs = null;
            if (this.rebuildAsstAct) {
                Map hgs;
                if (assGrpId != null && assGrpId.length() > 0 && (hg = (Map)(hgs = (Map)((Map)cache).get("hgs")).get(assGrpId)) != null) {
                    asstAccountId = rowset.getString("FAsstAccountID");
                    asstActs = this.buildAssData(this.getAsstActTypes(asstAccountId, this.asstActTypes), hg, true, this.showAsstActNumber, !this.showAsstActLongName, this.showAsstActLongName);
                }
                if (asstActs == null) {
                    asstActs = new String[]{};
                }
            } else {
                asstActs = this.buildAssData(this.aatIndexs, rowset, "FAssGrpID", "FNumberGroup", "FDisplayNameGroup", true, this.showAsstActNumber, !this.showAsstActLongName, this.showAsstActLongName);
            }
            for (int i = 0; i < this.asstMaxCount; ++i) {
                row.add(i < asstActs.length ? asstActs[i] : "");
            }
        }
        if (this.showOppAccount) {
            row.add(rowset.getString("FOppAccountNumber"));
            if (this.showAccountName) {
                row.add(rowset.getString("FOppAccountName"));
            }
            if (this.showAccountLongName) {
                row.add(rowset.getString("FOppAccountLongName"));
            }
            row.add(rowset.getString("FOppDescription"));
        }
        if (this.showOppAsstact && this.oppAsstMaxCount > 0) {
            String[] asstActs = null;
            if (this.rebuildAsstAct) {
                Map hgs;
                String assGrpId = rowset.getString("FOppAssGrpID");
                if (assGrpId != null && assGrpId.length() > 0 && (hg = (Map)(hgs = (Map)((Map)cache).get("hgs")).get(assGrpId)) != null) {
                    asstAccountId = rowset.getString("FOppAsstAccountID");
                    asstActs = this.buildAssData(this.getAsstActTypes(asstAccountId, this.asstActTypes), hg, true, this.showAsstActNumber, !this.showAsstActLongName, this.showAsstActLongName);
                }
                if (asstActs == null) {
                    asstActs = new String[]{};
                }
            } else {
                asstActs = this.buildAssData(this.aatIndexs, rowset, "FOppAssGrpID", "FOppNumberGroup", "FOppDisplayNameGroup", true, this.showAsstActNumber, !this.showAsstActLongName, this.showAsstActLongName);
            }
            for (int i = 0; i < this.oppAsstMaxCount; ++i) {
                row.add(i < asstActs.length ? asstActs[i] : "");
            }
        }
        if (this.showFor) {
            row.add(String.valueOf(rowset.getBigDecimal("FDebitFor")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditFor")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndBalanceFor")));
            row.add(String.valueOf(this.getCurrencyPrecision(this.ctx, rowset.getString("FCurrencyID"))));
        }
        if (this.showLocal) {
            row.add(String.valueOf(rowset.getBigDecimal("FDebitLocal")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditLocal")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndBalanceLocal")));
            row.add(this.localPrecision);
        }
        if (this.showRpt) {
            row.add(String.valueOf(rowset.getBigDecimal("FDebitRpt")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditRpt")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndBalanceRpt")));
            row.add(this.rptPrecision);
        }
        if (this.showQty) {
            row.add(rowset.getString("FMeasureUnitName"));
            row.add(String.valueOf(rowset.getBigDecimal("FDebitQty")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditQty")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndQty")));
            row.add("4");
        }
        return row;
    }

    @Override
    public Map<String, Object> search(Context ctx, Map params) throws BOSException, SQLException {
        int i;
        ArrayList rows = new ArrayList();
        this.result.put("rows", rows);
        String word = (String)params.get("word");
        if (word == null || word.length() == 0) {
            return this.result;
        }
        boolean mistiness = true;
        if ("false".equalsIgnoreCase((String)params.get("mistiness"))) {
            mistiness = false;
        }
        boolean caseSensitive = true;
        if ("false".equalsIgnoreCase((String)params.get("caseSensitive"))) {
            caseSensitive = false;
        }
        if (!caseSensitive) {
            word = word.toLowerCase(Locale.getDefault());
        }
        BigDecimal bdWord = null;
        try {
            bdWord = new BigDecimal(word);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean previous = "previous".equalsIgnoreCase((String)params.get("action"));
        boolean wrapSearch = "true".equalsIgnoreCase((String)params.get("wrapSearch"));
        int rowIndex = 0;
        Object param = params.get("rowIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                int i2 = Integer.parseInt(param.toString().trim());
                if (i2 >= 0) {
                    rowIndex = i2;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        ++rowIndex;
        int columIndex = -1;
        param = params.get("columIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                columIndex = Integer.parseInt(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (columIndex < 0) {
            columIndex = previous ? 0 : -1;
        }
        final HashMap<String, Integer> targetIndexs = new HashMap<String, Integer>();
        ArrayList<String> targets = new ArrayList<String>();
        Map sourceIndexs = (Map)params.get("targetIndexs");
        if (sourceIndexs == null || sourceIndexs.size() == 0) {
            this.errs.add(this.getResource("SelectSearchColumn"));
            return this.result;
        }
        for (Object target : sourceIndexs.keySet()) {
            param = sourceIndexs.get(target);
            Integer targetIndex = null;
            if (param instanceof Integer) {
                targetIndex = (Integer)param;
            } else if (param instanceof String) {
                try {
                    targetIndex = Integer.parseInt((String)param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String name = (String)target;
            if (targetIndex == null || targetIndex < 0) continue;
            if (name.startsWith("asstAct")) {
                try {
                    int asstActIndex = Integer.parseInt(name.substring(7));
                    if (asstActIndex < 1 || asstActIndex > this.asstActTypes.size()) continue;
                    targetIndexs.put(name, targetIndex);
                    targets.add(name);
                }
                catch (Exception asstActIndex) {}
                continue;
            }
            targetIndexs.put(name, targetIndex);
            targets.add(name);
        }
        if (targetIndexs.size() == 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        Collections.sort(targets, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = (Integer)targetIndexs.get(o1);
                int i2 = (Integer)targetIndexs.get(o2);
                return i1 - i2;
            }
        });
        StringBuffer sql = new StringBuffer();
        ArrayList<String> searchParams = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String csStart = "    ";
        String csEnd = "";
        if (!caseSensitive) {
            csStart = "    lower(";
            csEnd = ")";
        }
        sql.append("select /*+ LEADING(b) */ top 2 \n");
        if (targets.contains("companyNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FNumber" + csEnd + " FCompanyNumber, \n");
            } else {
                sql.append(csStart + "c.FNumber" + csEnd + " FCompanyNumber, \n");
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "s.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            } else {
                sql.append(csStart + "c.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            }
        }
        if (targets.contains("companyName")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FName_" + loc + csEnd + " FCompanyName, \n");
            } else {
                sql.append(csStart + "c.FName_" + loc + csEnd + " FCompanyName, \n");
            }
        }
        if (targets.contains("accountNumber")) {
            sql.append(csStart + "av.FNumber" + csEnd + " FAccountNumber, \n");
        }
        if (targets.contains("accountName")) {
            sql.append(csStart + "av.FName_" + loc + csEnd + " FAccountName, \n");
        }
        if (targets.contains("accountLongName")) {
            sql.append(csStart + "av.FDisplayName_" + loc + csEnd + " FAccountLongName, \n");
        }
        if (this.showOppAccount) {
            if (targets.contains("oppAccountNumber")) {
                sql.append(csStart + "oppav.FNumber" + csEnd + " FOppAccountNumber, \n");
            }
            if (targets.contains("oppAccountName")) {
                sql.append(csStart + "oppav.FName_" + loc + csEnd + " FOppAccountName, \n");
            }
            if (targets.contains("oppAccountLongName")) {
                sql.append(csStart + "oppav.FDisplayName_" + loc + csEnd + " FOppAccountLongName, \n");
            }
        }
        if (targets.contains("currencyNumber")) {
            sql.append(csStart + "cy.FNumber" + csEnd + " FCurrencyNumber, \n");
        }
        if (targets.contains("currencyName")) {
            sql.append(csStart + "cy.FName_" + loc + csEnd + " FCurrencyName, \n");
        }
        if (targets.contains("voucherNumber")) {
            sql.append(csStart + "v.FNumber" + csEnd + " FVoucherNumber, \n");
        }
        if (targets.contains("voucherType")) {
            sql.append(csStart + "vt.FName_" + loc + csEnd + " FVoucherType, \n");
        }
        if (targets.contains("bookedDate")) {
            sql.append("    TOCHAR(v.FBookedDate, 'YYYY-MM-DD') FBookedDate, \n");
        }
        if (targets.contains("bizDate")) {
            sql.append("    TOCHAR(v.FBizDate, 'YYYY-MM-DD') FBizDate, \n");
        }
        if (targets.contains("description")) {
            sql.append(csStart + "b.FDescription" + csEnd + " FDescription, \n");
        }
        if (this.showOppAccount && targets.contains("oppDescription")) {
            sql.append(csStart + "b.FOppDescription" + csEnd + " FOppDescription, \n");
        }
        if (targets.contains("creatorName")) {
            sql.append(csStart + "cu.FName_" + loc + csEnd + " FCreatorName, \n");
        }
        boolean aatTarget = false;
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            if (!targetIndexs.containsKey("asstAct" + (i + 1))) continue;
            AsstActTypeInfo type = this.asstActTypes.get(i);
            aatTarget = true;
            if (this.showAsstActNumber) {
                String FNumber = ".FNumber";
                if (type.isUseLongNumber()) {
                    FNumber = ".FLongNumber";
                }
                sql.append(csStart + "aat" + (i + 1) + FNumber + csEnd + " FAat" + (i + 1) + "Number, \n");
            }
            String FName = "aat" + (i + 1) + ".FName_" + loc;
            if (this.showAsstActLongName) {
                FName = type.isIsMultilevel() && type.getGroupTableName() == null ? "aat" + (i + 1) + ".FDisplayName_" + loc : "g" + (i + 1) + ".FDisplayName_" + loc + " || '_' || " + FName;
            }
            sql.append(csStart + FName + csEnd + " FAat" + (i + 1) + "Name, \n");
        }
        sql.append("    b.FRowIndex \n");
        sql.append("from " + params.get("pageId") + " b \n");
        sql.append("left join T_GL_Voucher v on v.FID = b.FVoucherID \n");
        sql.append("left join T_BD_VoucherTypes vt on vt.FID = v.FVoucherTypeID \n");
        sql.append("left join T_PM_User cu on cu.FID = v.FCreatorID \n");
        if (this.sumByUnion) {
            sql.append("left join T_ORG_Structure s on s.FID = b.FUnionID \n");
            sql.append("left join T_ORG_BaseUnit u on u.FID = s.FUnitID \n");
        } else {
            sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        }
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (this.showOppAccount) {
            sql.append("left join T_BD_AccountView oppav on oppav.FID = b.FOppAccountID \n");
        }
        if (aatTarget) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssGrpID \n");
            for (i = 0; i < this.asstActTypes.size(); ++i) {
                if (!targetIndexs.containsKey("asstAct" + (i + 1))) continue;
                AsstActTypeInfo aat = this.asstActTypes.get(i);
                sql.append("join " + aat.getRealtionDataObject() + " aat" + (i + 1) + " on aat" + (i + 1) + ".FID = hg." + aat.getMappingFieldName() + " \n");
                if (aat.getGroupTableName() == null) continue;
                sql.append("join " + aat.getGroupTableName() + " g" + (i + 1) + " on g" + (i + 1) + ".FID = aat" + (i + 1) + "." + aat.getGroupMappingFieldName() + " \n");
            }
        }
        csStart = "";
        csEnd = "";
        if (!caseSensitive) {
            csStart = "lower(";
            csEnd = ")";
        }
        String compare = mistiness ? " like ? \n" : " = ? \n";
        String compareValue = mistiness ? "%" + word + "%" : word;
        StringBuffer where = new StringBuffer();
        if (targets.contains("companyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "s.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("accountNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountLongName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FDisplayName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (this.showOppAccount) {
            if (targets.contains("oppAccountNumber")) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                where.append(csStart + "oppav.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (targets.contains("oppAccountName")) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                where.append(csStart + "oppav.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (targets.contains("oppAccountLongName")) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                where.append(csStart + "oppav.FDisplayName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("currencyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("voucherNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "v.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("voucherType")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "vt.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("bookedDate")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append("TOCHAR(v.FBookedDate, 'YYYY-MM-DD')");
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("bizDate")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append("TOCHAR(v.FBizDate, 'YYYY-MM-DD')");
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("description")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "b.FDescription" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (this.showOppAccount && targets.contains("oppDescription")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "b.FOppDescription" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("creatorName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cu.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        for (int i3 = 0; i3 < this.asstActTypes.size(); ++i3) {
            String ww;
            if (!targetIndexs.containsKey("asstAct" + (i3 + 1))) continue;
            AsstActTypeInfo type = this.asstActTypes.get(i3);
            String assWord = word;
            int ix = assWord.indexOf(58);
            if (ix > 0) {
                assWord = assWord.substring(ix + 1);
            }
            String FNumber = ".FNumber";
            if (type.isUseLongNumber()) {
                FNumber = ".FLongNumber";
            }
            Object FName = "aat" + (i3 + 1) + ".FName_" + loc;
            if (this.showAsstActLongName) {
                FName = type.isIsMultilevel() && type.getGroupTableName() == null ? "aat" + (i3 + 1) + ".FDisplayName_" + loc : "g" + (i3 + 1) + ".FDisplayName_" + loc + " || '_' || " + (String)FName;
            }
            if (this.showAsstActNumber) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                ww = assWord;
                if (type.isUseLongNumber()) {
                    ww = ww.replace('.', '!');
                }
                where.append(csStart + "aat" + (i3 + 1) + FNumber + csEnd);
                where.append(compare);
                searchParams.add(mistiness ? "%" + ww + "%" : ww);
            }
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + (String)FName + csEnd);
            where.append(compare);
            searchParams.add(mistiness ? "%" + assWord + "%" : assWord);
            if (!this.showAsstActNumber || assWord.indexOf(32) <= 0) continue;
            if (where.length() > 0) {
                where.append("or ");
            }
            ww = assWord;
            if (type.isUseLongNumber()) {
                int idx = assWord.indexOf(32);
                ww = ww.substring(0, idx).replace('.', '!') + ww.substring(idx);
            }
            where.append(csStart + "aat" + (i3 + 1) + FNumber + " || ' ' || " + (String)FName + csEnd);
            where.append(compare);
            searchParams.add(mistiness ? "%" + ww + "%" : ww);
        }
        if (where.length() <= 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        where.append(") \n");
        if (previous) {
            where.append("order by FRowIndex desc \n");
        } else {
            where.append("order by FRowIndex \n");
        }
        StringBuffer sql1 = new StringBuffer();
        ArrayList<Object> searchParams1 = new ArrayList<Object>();
        sql1.append(sql);
        if (previous) {
            sql1.append("where FRowIndex <= ? \n");
            searchParams1.add(rowIndex);
        } else {
            sql1.append("where FRowIndex >= ? \n");
            searchParams1.add(rowIndex);
        }
        sql1.append("and ( \n" + where);
        searchParams1.addAll(searchParams);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("FRowIndex");
            for (String target : targets) {
                String name;
                String creatorName;
                String oppDescription;
                String description;
                String bizDate;
                String bookedDate;
                String voucherType;
                String voucherNumber;
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) >= columIndex) && (previous || (Integer)targetIndexs.get(target) <= columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (this.showOppAccount) {
                    String oppAccountLongName;
                    String oppAccountName;
                    String oppAccountNumber;
                    if (target.equals("oppAccountNumber") && this.isMatch(word, bdWord, oppAccountNumber = rowset.getString("FOppAccountNumber"), mistiness)) {
                        row.put("name", "oppAccountNumber");
                        row.put("value", oppAccountNumber);
                        break;
                    }
                    if (target.equals("oppAccountName") && this.isMatch(word, bdWord, oppAccountName = rowset.getString("FOppAccountName"), mistiness)) {
                        row.put("name", "oppAccountName");
                        row.put("value", oppAccountName);
                        break;
                    }
                    if (target.equals("oppAccountLongName") && this.isMatch(word, bdWord, oppAccountLongName = rowset.getString("FOppAccountLongName"), mistiness)) {
                        row.put("name", "oppAccountLongName");
                        row.put("value", oppAccountLongName);
                        break;
                    }
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                if (target.equals("voucherNumber") && this.isMatch(word, bdWord, voucherNumber = rowset.getString("FVoucherNumber"), mistiness)) {
                    row.put("name", "voucherNumber");
                    row.put("value", voucherNumber);
                    break;
                }
                if (target.equals("voucherType") && this.isMatch(word, bdWord, voucherType = rowset.getString("FVoucherType"), mistiness)) {
                    row.put("name", "voucherType");
                    row.put("value", voucherType);
                    break;
                }
                if (target.equals("bookedDate") && this.isMatch(word, bdWord, bookedDate = rowset.getString("FBookedDate"), mistiness)) {
                    row.put("name", "bookedDate");
                    row.put("value", bookedDate);
                    break;
                }
                if (target.equals("bizDate") && this.isMatch(word, bdWord, bizDate = rowset.getString("FBizDate"), mistiness)) {
                    row.put("name", "bizDate");
                    row.put("value", bizDate);
                    break;
                }
                if (target.equals("description") && this.isMatch(word, bdWord, description = rowset.getString("FDescription"), mistiness)) {
                    row.put("name", "description");
                    row.put("value", description);
                    break;
                }
                if (this.showOppAccount && target.equals("oppDescription") && this.isMatch(word, bdWord, oppDescription = rowset.getString("FOppDescription"), mistiness)) {
                    row.put("name", "oppDescription");
                    row.put("value", oppDescription);
                    break;
                }
                if (target.equals("creatorName") && this.isMatch(word, bdWord, creatorName = rowset.getString("FCreatorName"), mistiness)) {
                    row.put("name", "creatorName");
                    row.put("value", creatorName);
                    break;
                }
                if (!target.startsWith("asstAct")) continue;
                int asstActIndex = Integer.parseInt(target.substring(7));
                AsstActTypeInfo type = this.asstActTypes.get(asstActIndex - 1);
                String myWord = word;
                int ix = myWord.indexOf(58);
                if (ix > 0) {
                    myWord = myWord.substring(ix + 1);
                }
                if (this.showAsstActNumber) {
                    String number = rowset.getString("FAat" + asstActIndex + "Number");
                    if (type.isUseLongNumber()) {
                        number = number.replace('!', '.');
                    }
                    if (this.isAssMatch(myWord, number, mistiness)) {
                        row.put("name", target);
                        row.put("value", number);
                        break;
                    }
                }
                if (this.isAssMatch(myWord, name = rowset.getString("FAat" + asstActIndex + "Name"), mistiness)) {
                    row.put("name", target);
                    row.put("value", name);
                    break;
                }
                if (!this.showAsstActNumber || myWord.indexOf(32) <= 0) continue;
                String number = rowset.getString("FAat" + asstActIndex + "Number");
                if (type.isUseLongNumber()) {
                    number = number.replace('!', '.');
                }
                name = rowset.getString("FAat" + asstActIndex + "Name");
                if (!this.isAssMatch(myWord, number + " " + name, mistiness)) continue;
                row.put("name", target);
                row.put("value", name);
                break;
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        if (!wrapSearch) {
            return this.result;
        }
        StringBuffer sql2 = new StringBuffer();
        ArrayList<Object> searchParams2 = new ArrayList<Object>();
        sql2.append(sql);
        if (previous) {
            sql2.append("where FRowIndex >= ? \n");
            searchParams2.add(rowIndex);
        } else {
            sql2.append("where FRowIndex <= ? \n");
            searchParams2.add(rowIndex);
        }
        sql2.append("and ( \n" + where);
        searchParams2.addAll(searchParams);
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("FRowIndex");
            for (String target : targets) {
                String name;
                String creatorName;
                String oppDescription;
                String description;
                String bizDate;
                String bookedDate;
                String voucherType;
                String voucherNumber;
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) < columIndex) && (previous || (Integer)targetIndexs.get(target) > columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (this.showOppAccount) {
                    String oppAccountLongName;
                    String oppAccountName;
                    String oppAccountNumber;
                    if (target.equals("oppAccountNumber") && this.isMatch(word, bdWord, oppAccountNumber = rowset.getString("FOppAccountNumber"), mistiness)) {
                        row.put("name", "oppAccountNumber");
                        row.put("value", oppAccountNumber);
                        break;
                    }
                    if (target.equals("oppAccountName") && this.isMatch(word, bdWord, oppAccountName = rowset.getString("FOppAccountName"), mistiness)) {
                        row.put("name", "oppAccountName");
                        row.put("value", oppAccountName);
                        break;
                    }
                    if (target.equals("oppAccountLongName") && this.isMatch(word, bdWord, oppAccountLongName = rowset.getString("FOppAccountLongName"), mistiness)) {
                        row.put("name", "oppAccountLongName");
                        row.put("value", oppAccountLongName);
                        break;
                    }
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                if (target.equals("voucherNumber") && this.isMatch(word, bdWord, voucherNumber = rowset.getString("FVoucherNumber"), mistiness)) {
                    row.put("name", "voucherNumber");
                    row.put("value", voucherNumber);
                    break;
                }
                if (target.equals("voucherType") && this.isMatch(word, bdWord, voucherType = rowset.getString("FVoucherType"), mistiness)) {
                    row.put("name", "voucherType");
                    row.put("value", voucherType);
                    break;
                }
                if (target.equals("bookedDate") && this.isMatch(word, bdWord, bookedDate = rowset.getString("FBookedDate"), mistiness)) {
                    row.put("name", "bookedDate");
                    row.put("value", bookedDate);
                    break;
                }
                if (target.equals("bizDate") && this.isMatch(word, bdWord, bizDate = rowset.getString("FBizDate"), mistiness)) {
                    row.put("name", "bizDate");
                    row.put("value", bizDate);
                    break;
                }
                if (target.equals("description") && this.isMatch(word, bdWord, description = rowset.getString("FDescription"), mistiness)) {
                    row.put("name", "description");
                    row.put("value", description);
                    break;
                }
                if (this.showOppAccount && target.equals("oppDescription") && this.isMatch(word, bdWord, oppDescription = rowset.getString("FOppDescription"), mistiness)) {
                    row.put("name", "oppDescription");
                    row.put("value", oppDescription);
                    break;
                }
                if (target.equals("creatorName") && this.isMatch(word, bdWord, creatorName = rowset.getString("FCreatorName"), mistiness)) {
                    row.put("name", "creatorName");
                    row.put("value", creatorName);
                    break;
                }
                if (!target.startsWith("asstAct")) continue;
                int asstActIndex = Integer.parseInt(target.substring(7));
                AsstActTypeInfo type = this.asstActTypes.get(asstActIndex - 1);
                String myWord = word;
                int ix = myWord.indexOf(58);
                if (ix > 0) {
                    myWord = myWord.substring(ix + 1);
                }
                if (this.showAsstActNumber) {
                    String number = rowset.getString("FAat" + asstActIndex + "Number");
                    if (type.isUseLongNumber()) {
                        number = number.replace('!', '.');
                    }
                    if (this.isAssMatch(myWord, number, mistiness)) {
                        row.put("name", target);
                        row.put("value", number);
                        break;
                    }
                }
                if (this.isAssMatch(myWord, name = rowset.getString("FAat" + asstActIndex + "Name"), mistiness)) {
                    row.put("name", target);
                    row.put("value", name);
                    break;
                }
                if (!this.showAsstActNumber || myWord.indexOf(32) <= 0) continue;
                String number = rowset.getString("FAat" + asstActIndex + "Number");
                if (type.isUseLongNumber()) {
                    number = number.replace('!', '.');
                }
                name = rowset.getString("FAat" + asstActIndex + "Name");
                if (!this.isAssMatch(myWord, number + " " + name, mistiness)) continue;
                row.put("name", target);
                row.put("value", name);
                break;
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        return this.result;
    }

    protected boolean isMatch(String word, BigDecimal bdWord, Object value, boolean mistiness) {
        if (value != null) {
            String v;
            if (value instanceof BigDecimal) {
                if (bdWord != null && bdWord.compareTo((BigDecimal)value) == 0) {
                    return true;
                }
                v = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                if (v.equals(word)) {
                    return true;
                }
            }
            v = value.toString();
            if (mistiness && v.contains(word) || !mistiness && v.equals(word)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAssMatch(String word, String value, boolean mistiness) {
        if (value != null) {
            String str;
            String v = value.toString();
            if (mistiness) {
                return v.contains(word);
            }
            int index = v.indexOf(":");
            if (index > 0 && (index = (str = v.substring(index + 1)).indexOf(" ")) > 0 && (str.substring(0, index).equals(word) || str.substring(index + 1).equals(word))) {
                return true;
            }
            return v.equals(word);
        }
        return false;
    }
}

