/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeTreeNode;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.GLRptIDManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class GLRptAsstActTypeIDManager
extends GLRptIDManager {
    private static final Logger logger = Logger.getLogger(GLRptAsstActTypeIDManager.class);
    protected CompanyDisplayModeEnum displayMode;

    public GLRptAsstActTypeIDManager(CompanyDisplayModeEnum displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public void initGLRptID(List idList, int expandLevel) throws BOSException {
        if (idList == null) {
            return;
        }
        if (expandLevel > -1) {
            Iterator it = idList.iterator();
            GLRptAsstActTypeTreeNode lastNode = null;
            this.list = new ArrayList();
            while (it.hasNext()) {
                GLRptAsstActTypeTreeNode father;
                GLRptAsstActTypeTreeNode node = (GLRptAsstActTypeTreeNode)it.next();
                if (node.getLevel() < expandLevel) {
                    node.setExpend(true);
                }
                if (this.displayMode == CompanyDisplayModeEnum.level || this.displayMode == CompanyDisplayModeEnum.details) {
                    if (lastNode != null) {
                        if (lastNode.getGroupID() == null) {
                            father = null;
                        } else if (lastNode.getGroupID().equals(node.getGroupID())) {
                            if (node.getLevel() == lastNode.getLevel()) {
                                if (!lastNode.isGroupRootNode() && lastNode.getGroupRootNode() == null) {
                                    logger.error((Object)"", (Throwable)new Exception());
                                }
                                father = (GLRptAsstActTypeTreeNode)lastNode.getParentNode();
                            } else if (node.getLevel() < lastNode.getLevel()) {
                                for (father = lastNode; father != null && node.getLevel() <= father.getLevel(); father = (GLRptAsstActTypeTreeNode)father.getParentNode()) {
                                    if (father.getParentNode() == null && !father.isGroupRootNode()) continue;
                                }
                            }
                            if (father != null && !father.isGroupRootNode() && father.getGroupRootNode() == null) {
                                // empty if block
                            }
                        } else {
                            father = null;
                        }
                    }
                    node.setParentNode(father);
                    if (node.getLevel() <= expandLevel) {
                        this.list.add(node);
                    }
                } else if (this.displayMode == CompanyDisplayModeEnum.details) {
                    if (lastNode != null) {
                        if (lastNode.getGroupID() == null) {
                            father = null;
                        } else if (lastNode.getGroupID().equals(node.getGroupID())) {
                            if (node.getLevel() == lastNode.getLevel()) {
                                father = (GLRptAsstActTypeTreeNode)lastNode.getParentNode();
                            } else if (node.getLevel() < lastNode.getLevel()) {
                                while (father != null && node.getLevel() <= father.getLevel()) {
                                    father = (GLRptAsstActTypeTreeNode)father.getParentNode();
                                }
                            }
                        } else {
                            father = null;
                        }
                    }
                    node.setParentNode(father);
                    if (node.getLevel() <= expandLevel) {
                        this.list.add(node);
                    }
                } else {
                    logger.error((Object)"no-expected", (Throwable)new Exception());
                }
                lastNode = node;
            }
        } else {
            this.list = idList;
        }
    }

    @Override
    protected int openNode(int index, GLRptTreeNode node) {
        if (node == null || node.isLeaf()) {
            return index;
        }
        List sonNodes = node.getSonNodes();
        if (sonNodes == null) {
            return index;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            GLRptAsstActTypeTreeNode sonNode = (GLRptAsstActTypeTreeNode)sonNodes.get(i);
            this.list.add(++index, sonNode);
            if (!sonNode.isExpend()) continue;
            index = this.openNode(index, sonNode);
        }
        return index;
    }

    @Override
    protected void closeNode(GLRptTreeNode node) {
        if (node == null || node.isLeaf()) {
            return;
        }
        List sonNodes = node.getSonNodes();
        if (sonNodes == null) {
            return;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            GLRptAsstActTypeTreeNode sonNode = (GLRptAsstActTypeTreeNode)sonNodes.get(i);
            if (sonNode.isExpend()) {
                this.closeNode(sonNode);
            }
            this.list.remove(sonNode);
        }
    }
}

