/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.IGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.AbstractGLRptAsstactMultiColumnFacadeControllerBean;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactMultiColumnDao;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAsstactMultiColumnFacadeControllerBean
extends AbstractGLRptAsstactMultiColumnFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLRptAsstactMultiColumnFacadeControllerBean");

    @Override
    protected IGLRptDao getGLRptDao(Context ctx, ReportConditionBase condition) throws BOSException, EASBizException {
        return new GLRptAsstactMultiColumnDao(ctx);
    }

    @Override
    protected List _queryAsstactType(Context ctx, Map params) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String accountId = (String)params.get("accountId");
        String accountLongNumber = (String)params.get("accountLongNumber");
        String accountTableId = (String)params.get("accountTableId");
        String companyId = (String)params.get("companyId");
        if (accountLongNumber == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("longNumber");
            AccountViewInfo info = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
            accountLongNumber = info.getLongNumber();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("  B.fid, B.fnumber, \n");
        sql.append("  B.FMappingFieldName, B.FDefaultQueryName, B.FName_").append(loc).append(" FName, \n");
        sql.append("  B.FIsForCompany, B.FGLAsstActTypeGrpID, B.FAsstHGAttribute, \n");
        sql.append("  B.FIsMultiLevel, \n");
        sql.append("  B.FGroupTableName, B.FGroupMappingFieldName, B.frealtiondataobject, B.fisqty, mu.fname_").append(loc).append(" muname, \n");
        sql.append("  1 FmaxLevel,1 FSelectedLevel, B.FUseLongNumber,b.FPermissionItem, \n");
        sql.append("  b.FMeasureUnitGroupID FMeasureUnitGroupID,b.FMeasureUnitGroupID FAsstMeasureUnitGroupId \n");
        sql.append("from t_bd_asstactgroupdetail A \n");
        sql.append("inner join t_bd_asstacttype B on B.FID=A.FAsstActTypeId \n");
        sql.append("left join T_BD_MeasureUnitGroup mug on  mug.fid = b.FMeasureUnitGroupID \n");
        sql.append("left join t_bd_measureunit mu on mu.fid = mug.FDefaultUnitID \n");
        sql.append("where A.FAsstAccountId in ( \n");
        sql.append("  select D.FCAA \n");
        sql.append("  from T_BD_AccountView D \n");
        sql.append("  where D.FCompanyID = ? and D.FAccountTableID = ? \n");
        sql.append("    and (D.FID = ? or D.FLongNumber like '" + accountLongNumber + "!%') \n");
        sql.append("    and D.fisleaf = 1 \n");
        sql.append("  union \n");
        sql.append("  select FBeforeID \n");
        sql.append("  from T_BD_AsstAccountChange aac \n");
        sql.append("  join T_BD_AccountView D on D.FID = aac.FAccountID \n");
        sql.append("  where D.FCompanyID = ? and D.FAccountTableID = ? \n");
        sql.append("    and (D.FID = ? or D.FLongNumber like '" + accountLongNumber + "!%') \n");
        sql.append("    and D.fisleaf = 1 \n");
        sql.append(") \n");
        SqlParams pp = new SqlParams().setString(1, companyId);
        pp.setString(2, accountTableId);
        pp.setString(3, accountId);
        pp.setString(4, companyId);
        pp.setString(5, accountTableId);
        pp.setString(6, accountId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])pp.getParams());
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        HashMap<String, String> has = new HashMap<String, String>();
        try {
            while (rs.next()) {
                AsstactTypeEntity at = new AsstactTypeEntity();
                String id = rs.getString("FID");
                if (has.containsKey(id)) continue;
                at.setId(id);
                has.put(id, id);
                at.setNumber(rs.getString("FNumber"));
                at.setQueryName(rs.getString("FDefaultQueryname"));
                at.setTableName(rs.getString("FRealtionDataObject"));
                at.setName(rs.getString("FName"));
                at.setForCompany("1".equals(String.valueOf(rs.getObject("FisForCompany"))));
                at.setGeneralAsstactGroupId(rs.getString("FGLAsstActTypeGrpID"));
                at.setHgField(rs.getString("FMappingFieldName"));
                at.setHgAttribute(rs.getString("FAsstHGAttribute"));
                at.setGroupTable(rs.getString("FGroupTableName"));
                at.setGroupField(rs.getString("FGroupMappingFieldName"));
                at.setMaxLevel(rs.getInt("FMaxLevel"));
                at.setSelected(true);
                at.setCollect(CollectEnum.LEAF);
                at.setMultilevel("1".equals(String.valueOf(rs.getObject("FIsMultiLevel"))));
                at.setFrom(null);
                at.setTo(null);
                at.setSelectedLevel(rs.getInt("FSelectedLevel"));
                at.setEnabledPermissionLimit(true);
                at.setPermissionItem(rs.getString("FPermissionItem"));
                at.setAsstMeasureUnitGroupId(rs.getString("FMeasureUnitGroupID"));
                at.setUseLongNumber("1".equals(String.valueOf(rs.getObject("FUseLongNumber"))));
                list.add(at);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return list;
    }
}

