/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.GLTransactionUtils;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptCache;
import com.kingdee.eas.fi.gl.rpt.GLRptException;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryInitData;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.AbstractGLRptBaseFacadeControllerBean;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.IDRptDataManager;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GLRptBaseFacadeControllerBean
extends AbstractGLRptBaseFacadeControllerBean {
    private static final long serialVersionUID = -1329210650576561223L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLRptBaseFacadeControllerBean");

    @Override
    protected int _expandAllRow(Context ctx, String queryId, int rowIndex) throws BOSException, EASBizException {
        IDRptDataManager manager = this.getGLRptIDManager(ctx, queryId);
        return manager.expandAllRow(rowIndex);
    }

    @Override
    protected int _expandRow(Context ctx, String queryId, int rowIndex) throws BOSException, EASBizException {
        IDRptDataManager manager = this.getGLRptIDManager(ctx, queryId);
        return manager.expandRow(rowIndex);
    }

    @Override
    protected int _shrinkRow(Context ctx, String queryId, int rowIndex) throws BOSException, EASBizException {
        IDRptDataManager manager = this.getGLRptIDManager(ctx, queryId);
        return manager.shrinkRow(rowIndex);
    }

    @Override
    protected GLRptRowSet _getData(Context ctx, String queryId, int rowIndex, int length) throws BOSException, EASBizException {
        return this.getGLRptDao(ctx, queryId).getData(rowIndex, length);
    }

    @Override
    protected GLRptRowSet _getSumData(Context ctx, String queryId) throws BOSException, EASBizException {
        return this.getGLRptDao(ctx, queryId).getAsynSumData();
    }

    @Override
    protected GLRptQueryResult _query(Context ctx, EntityViewInfo ev) throws BOSException, EASBizException {
        if (ev == null) {
            return null;
        }
        GLRptBaseCondition condition = (GLRptBaseCondition)ev.get("GLFixCondition");
        if (condition == null) {
            return null;
        }
        GLTempTableUtil.setCondition(condition);
        condition.setCtx(ctx);
        IGLRptDao dao = this.getGLRptDao(ctx, condition);
        String queryId = null;
        boolean isRequired = this.isOracleRequired(ctx, ev, condition);
        GLTempTableUtil.setTransactionRequired(isRequired);
        queryId = isRequired ? (String)GLTransactionUtils.invoke(dao, "createDataSourceTable", new Class[]{EntityViewInfo.class}, new Object[]{ev}, 0) : dao.createDataSourceTable(ev);
        if (queryId == null) {
            return null;
        }
        GLRptCache cache = GLRptCache.createGLRptCache(ctx, queryId);
        cache.setDao(dao);
        ((AbstractGLRptDao)dao).createDataSourceTableIndex();
        int length = 100;
        Object pageRowCount = ev.get("PAGE_ROW_COUNT");
        if (pageRowCount instanceof Integer) {
            length = (Integer)pageRowCount;
        }
        return new GLRptQueryResult(queryId, dao, length);
    }

    private boolean isOracleRequired(Context ctx, EntityViewInfo ev, GLRptBaseCondition condition) throws EASBizException, BOSException {
        String required = condition.getExtendParam("Query_Required");
        if (required != null && required.trim().length() > 0) {
            if ((required = required.trim()).equalsIgnoreCase("true")) {
                return SQLUtil.isOracle(ctx);
            }
            if (required.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return condition.getRptParams().isRptQueryRequired() && SQLUtil.isOracle(ctx);
    }

    protected IGLRptDao getGLRptDao(Context ctx, ReportConditionBase condition) throws BOSException, EASBizException {
        throw new BOSException("please implementat this method!");
    }

    protected IGLRptDao getGLRptDao(Context ctx, String queryId) throws BOSException, EASBizException {
        GLRptCache cache = GLRptCache.getGLRptCache(ctx, queryId);
        if (cache == null) {
            throw new GLRptException(GLRptException.SESSION_INVALID);
        }
        return cache.getDao();
    }

    @Override
    protected void _releaseDataSource(Context ctx, String queryId) throws BOSException {
        GLRptCache cache = GLRptCache.getGLRptCache(ctx, queryId);
        if (cache == null) {
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(queryId);
            }
            catch (Exception e) {
                logger.error((Object)"Release tempTable error!", (Throwable)e);
            }
            return;
        }
        cache.getDao().releaseTempTable();
        GLRptCache.clearGLRptCache(ctx, queryId);
    }

    protected IDRptDataManager getGLRptIDManager(Context ctx, String queryId) throws GLRptException {
        GLRptCache cache = GLRptCache.getGLRptCache(ctx, queryId);
        if (cache == null) {
            throw new GLRptException(GLRptException.SESSION_INVALID);
        }
        return (IDRptDataManager)((AbstractGLRptDao)cache.getDao()).getDataManager();
    }

    @Override
    protected GLRptQueryInitData _getQueryInitData(Context ctx, boolean isSupportUnion) throws BOSException, EASBizException {
        GLRptQueryInitData initData = this.getQueryInitData();
        Map params = this.getGlobalParams(ctx);
        this.setGlobalParamsValue(ctx, initData);
        Object useRptCurrency = params.get("G001");
        boolean isUseRptCurrency = useRptCurrency != null && Boolean.valueOf(useRptCurrency.toString()) != false;
        initData.setCurrencys(this.getCurrencys(ctx, isUseRptCurrency));
        initData.setAccountTables(this.getAccountTableCollection(ctx, null, isSupportUnion));
        initData.setPeriodTypes(this.getPeriodTypeCollection(ctx));
        return initData;
    }

    @Override
    protected GLRptQueryInitData _getQueryInitData(Context ctx, Set companyIds, boolean isSupportUnion) throws BOSException, EASBizException {
        GLRptQueryInitData initData = this.getQueryInitData();
        CompanyOrgUnitInfo company = null;
        if (companyIds != null && companyIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("isBizUnit");
            view.setSelector(selector);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            if (coll.size() > 0) {
                company = coll.get(0);
            }
        }
        Map params = this.getGlobalParams(ctx);
        this.setGlobalParamsValue(ctx, initData);
        Object useRptCurrency = params.get("G001");
        boolean isUseRptCurrency = useRptCurrency != null && Boolean.valueOf(useRptCurrency.toString()) != false;
        initData.setCurrencys(this.getCurrencys(ctx, isUseRptCurrency));
        initData.setAccountTables(this.getAccountTableCollection(ctx, company, isSupportUnion));
        initData.setPeriodTypes(this.getPeriodTypeCollection(ctx));
        return initData;
    }

    @Override
    protected Map _getPeriodRange(Context ctx, Set companyIdSet, String periodTypeId) throws BOSException, EASBizException {
        return GlUtils.getPeriodRange(ctx, companyIdSet, periodTypeId);
    }

    @Override
    protected int _getAccountMaxLevel(Context ctx, Set companyIdSet, String accountTableId) throws BOSException, EASBizException {
        int MaxLevel = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT MAX(FLEVEL) AS MAXLevel FROM T_BD_AccountView ");
        sql.append(" WHERE FAccountTableId = ? and FCompanyID in (");
        Iterator it = companyIdSet.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountTableId});
        try {
            if (rowSet.next()) {
                MaxLevel = rowSet.getInt("MAXLevel");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return MaxLevel;
    }

    private void setGlobalParamsValue(Context ctx, GLRptQueryInitData initData) throws EASBizException, BOSException {
        Map params = this.getGlobalParams(ctx);
        if (params != null) {
            Object companyByUser;
            Object qtyAsst = params.get("G010");
            if (qtyAsst != null) {
                initData.setAsstQty(Boolean.valueOf(qtyAsst.toString()));
            }
            if ((companyByUser = params.get("GL_053")) != null) {
                initData.setCompanyByUser(Boolean.valueOf(companyByUser.toString()));
            }
        }
    }

    private Map getGlobalParams(Context ctx) throws EASBizException, BOSException {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("G001", null);
        items.put("G010", null);
        items.put("GL_053", null);
        items.put("GL_008", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        return ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(items);
    }

    private boolean isForeignCurrency(Context ctx) throws EASBizException, BOSException {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("GL_008", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        HashMap param = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(items);
        return Boolean.valueOf(param.get("GL_008").toString());
    }

    protected Vector getCurrencys(Context ctx, boolean isUseReportCurrency) throws BOSException, EASBizException {
        CurrencyCollection currencyCollection = this.getAllCurrencyCollection(ctx);
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        Vector<Object> currencys = new Vector<Object>();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                currencys.add(currencyCollection.get(i));
            }
            if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                generalLocalCurrency = currency;
            }
            if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
            generalRptCurrency = currency;
        }
        if (!this.isForeignCurrency(ctx)) {
            if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                currencys.add(generalLocalCurrency);
            }
            if (isUseReportCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                currencys.add(generalRptCurrency);
            }
        }
        currencys.add(GLResUtil.getRes("all_currency", ctx.getLocale()));
        return currencys;
    }

    private CurrencyCollection getAllCurrencyCollection(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        return currencyCollection;
    }

    private AccountTableCollection getAccountTableCollection(Context ctx, CompanyOrgUnitInfo company, boolean isSupportUnion) throws ReportBizException, BOSException {
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        return AccountTools.getAllAccountTableByCompany((Context)ctx, (CompanyOrgUnitInfo)company);
    }

    private PeriodTypeCollection getPeriodTypeCollection(Context ctx) throws ReportBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection(view);
    }

    protected GLRptQueryInitData getQueryInitData() {
        return new GLRptQueryInitData();
    }
}

