/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GLRptIDManager {
    protected List list;

    public void initGLRptID(List idList, int expandLevel) throws BOSException {
        if (idList == null) {
            return;
        }
        if (expandLevel > -1) {
            Iterator it = idList.iterator();
            GLRptTreeNode lastNode = null;
            this.list = new ArrayList();
            while (it.hasNext()) {
                GLRptTreeNode father;
                GLRptTreeNode node = (GLRptTreeNode)it.next();
                if (node.getLevel() < expandLevel) {
                    node.setExpend(true);
                }
                if (lastNode != null) {
                    if (node.getLevel() == lastNode.getLevel()) {
                        father = lastNode.getParentNode();
                    } else if (node.getLevel() < lastNode.getLevel()) {
                        for (father = lastNode; father != null && node.getLevel() <= father.getLevel(); father = father.getParentNode()) {
                        }
                    }
                }
                node.setParentNode(father);
                if (node.getLevel() <= expandLevel) {
                    this.list.add(node);
                }
                lastNode = node;
            }
        } else {
            this.list = idList;
        }
    }

    public int expandRow(int index) {
        GLRptTreeNode node = (GLRptTreeNode)this.getId(index);
        if (node.getSonNodes() == null && node.isMerge()) {
            this.expandMergeRow(index, node);
        } else {
            this.openNode(index, node);
            node.setExpend(true);
        }
        return this.getViewRowCount();
    }

    public int expandAllRow(int index) {
        GLRptTreeNode node = (GLRptTreeNode)this.getId(index);
        if (node.getSonNodes() == null && node.isMerge()) {
            this.expandMergeAllRow(index, node);
        } else {
            this.openAllNode(index, node);
        }
        return this.getViewRowCount();
    }

    public int shrinkRow(int index) {
        GLRptTreeNode node = (GLRptTreeNode)this.getId(index);
        if (node.getSonNodes() == null && node.isMerge()) {
            this.shrinkMergeRow(index, node);
        } else {
            this.closeNode(node);
            node.setExpend(false);
        }
        return this.getViewRowCount();
    }

    protected void closeNode(GLRptTreeNode node) {
        if (node == null || node.isLeaf()) {
            return;
        }
        List sonNodes = node.getSonNodes();
        if (sonNodes == null) {
            return;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            GLRptTreeNode sonNode = (GLRptTreeNode)sonNodes.get(i);
            if (sonNode.isExpend()) {
                this.closeNode(sonNode);
            }
            this.list.remove(sonNode);
        }
    }

    protected int openNode(int index, GLRptTreeNode node) {
        if (node == null || node.isLeaf()) {
            return index;
        }
        List sonNodes = node.getSonNodes();
        if (sonNodes == null) {
            return index;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            GLRptTreeNode sonNode = (GLRptTreeNode)sonNodes.get(i);
            this.list.add(++index, sonNode);
            if (!sonNode.isExpend()) continue;
            index = this.openNode(index, sonNode);
        }
        return index;
    }

    private int openAllNode(int index, GLRptTreeNode node) {
        if (node == null || node.isLeaf()) {
            return index;
        }
        List sonNodes = node.getSonNodes();
        if (sonNodes == null) {
            return index;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            GLRptTreeNode sonNode = (GLRptTreeNode)sonNodes.get(i);
            this.list.add(++index, sonNode);
            index = this.openAllNode(index, sonNode);
        }
        node.setExpend(true);
        return index;
    }

    public GLRptID[] getIdList(int start, int length) {
        if (start + 1 > this.list.size()) {
            return new GLRptID[0];
        }
        if (start + length > this.list.size()) {
            length = this.list.size() - start;
        }
        List idList = this.list.subList(start, start + length);
        GLRptID[] ids = new GLRptID[idList.size()];
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            ids[i] = (GLRptID)idList.get(i);
        }
        return ids;
    }

    public GLRptID getId(int index) {
        return (GLRptID)this.list.get(index);
    }

    public int getViewRowCount() {
        return this.list.size();
    }

    public void expandMergeRow(int index, GLRptTreeNode currentNode) {
        GLRptTreeNode includSonNodesNode = currentNode;
        for (int i = index; i < this.list.size(); ++i) {
            GLRptTreeNode treeNode = (GLRptTreeNode)this.list.get(i);
            if (treeNode.getSonNodes() == null || !StringUtils.equals((String)currentNode.getUserObject().toString(), (String)treeNode.getUserObject().toString())) continue;
            includSonNodesNode = treeNode;
            index = i;
            break;
        }
        this.openNode(index, includSonNodesNode);
        currentNode.setExpend(true);
    }

    public void expandMergeAllRow(int index, GLRptTreeNode currentNode) {
        GLRptTreeNode includSonNodesNode = currentNode;
        for (int i = index; i < this.list.size(); ++i) {
            GLRptTreeNode treeNode = (GLRptTreeNode)this.list.get(i);
            if (treeNode.getSonNodes() == null || !StringUtils.equals((String)currentNode.getUserObject().toString(), (String)treeNode.getUserObject().toString())) continue;
            includSonNodesNode = treeNode;
            index = i;
            break;
        }
        this.openAllNode(index, includSonNodesNode);
    }

    public void shrinkMergeRow(int index, GLRptTreeNode currentNode) {
        GLRptTreeNode includSonNodesNode = currentNode;
        for (int i = index; i < this.list.size(); ++i) {
            GLRptTreeNode treeNode = (GLRptTreeNode)this.list.get(i);
            if (treeNode.getSonNodes() == null || !StringUtils.equals((String)currentNode.getUserObject().toString(), (String)treeNode.getUserObject().toString())) continue;
            includSonNodesNode = treeNode;
            break;
        }
        this.closeNode(includSonNodesNode);
        currentNode.setExpend(false);
    }
}

