/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.DefaultGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.GLRptIDManager;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItemInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableStruct;
import com.kingdee.eas.fi.gl.rpt.app.dao.IDRptDataManager;
import com.kingdee.eas.fi.gl.rpt.app.dao.IRptDataManager;
import com.kingdee.eas.fi.gl.rpt.app.dao.SeqTableRptDataManager;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public abstract class AbstractGLRptDao
implements IGLRptDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.AbstractGLRptDao");
    protected static final int MAX_PERIOD = 999999;
    protected static final int createIDTempTableMaxCount = 100;
    protected static final String CUID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private Context ctx;
    private GLRptSelector selector;
    private GLRptTempTableInfo dataSourceTable;
    private IRptDataManager dataManager;
    private GLRptBaseCondition condition;
    private CompanyOrgUnitInfo company;
    private GLRptTableHeadInfo headInfo;
    private GLRptTempTableStruct struct;
    private GLRptSumItems sumItem;
    private boolean isAsynSumData = true;
    private int batch = 0;
    protected String resource = "com.kingdee.eas.fi.gl.rpt.GLRPptOtherResource";
    private Map<String, String> dataTypes = null;
    protected Set<String> processTempTables = new HashSet<String>();

    public AbstractGLRptDao(Context ctx) throws EASBizException, BOSException {
        this.ctx = ctx;
    }

    protected Map<String, String> getDataTypes(Context ctx) throws BOSException {
        if (this.dataTypes == null) {
            this.dataTypes = GLTempTableUtil.getDataTypes(ctx, this.getTempTableDefineFunction(), this.getTempTableDefineTableName());
        }
        return this.dataTypes;
    }

    protected String getTempTableDefineFunction() {
        return null;
    }

    protected String getTempTableDefineTableName() {
        return "dataTable";
    }

    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        if (ev.get("isAsynSumData") != null) {
            this.isAsynSumData = (Boolean)ev.get("isAsynSumData");
        }
        this.condition = (GLRptBaseCondition)ev.get("GLFixCondition");
        if (this.condition.getCurrencyID() == null) {
            this.condition.setCurrencyID("AllCurrency");
        }
        this.company = this.initCompany();
        if (this.condition.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            PeriodInfo startPeriod = this.initPeriod();
            if (this.condition.getPeriodYearStart() * 100 + this.condition.getPeriodNumberStart() < startPeriod.getNumber()) {
                this.condition.setPeriodYearStart(startPeriod.getPeriodYear());
                this.condition.setPeriodNumberStart(startPeriod.getPeriodNumber());
            }
        }
        this.setTreeModelOfCompany();
        this.updateVoucherBalance();
        Object objIsFromWeb = ev.get("isFromWeb");
        if (objIsFromWeb != null && objIsFromWeb instanceof Boolean) {
            this.setIsFromWeb((Boolean)objIsFromWeb);
        }
    }

    protected void setIsFromWeb(Boolean isFromWeb) {
    }

    protected PeriodInfo initPeriod() throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.condition.getCompany());
        return startPeriod;
    }

    protected void updateVoucherBalance() throws BOSException {
        String updateBalance;
        EntityViewInfo ev = this.condition.getSelfCond();
        if (ev != null && (updateBalance = this.condition.getExtendParam("Update_Balance")) != null && "false".equalsIgnoreCase(updateBalance.trim())) {
            return;
        }
        String[] companyIds = GLRptDaoUtil.set2StringArray(this.condition.getCompanyIds());
        GLBalanceFacadeFactory.getLocalInstance(this.ctx).updateVoucherBalance(companyIds);
    }

    protected void setTreeModelOfCompany() throws BOSException {
        this.condition.setTreeModelOfCompany(this.getTreeModeOfCompany(this.ctx, this.condition, this.company));
    }

    protected DefaultKingdeeTreeNode getTreeModeOfCompany(Context ctx, GLRptBaseCondition cond, CompanyOrgUnitInfo company) throws BOSException {
        if (this.condition.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && this.condition.getTreeModelOfCompany() == null) {
            if (!this.condition.getCompanyIds().isEmpty()) {
                return GLRptDaoUtil.getTreeModeOfCompany(ctx, company, this.condition.getCompanyIds());
            }
            return GLRptDaoUtil.getTreeModeOfCompany(ctx, company);
        }
        return (DefaultKingdeeTreeNode)this.condition.getTreeModelOfCompany();
    }

    protected CompanyOrgUnitInfo initCompany() throws EASBizException, BOSException {
        AccountRefContrastInfo ar;
        CompanyOrgUnitInfo company = this.condition.getCompany();
        if (company.isIsBizUnit() && this.condition.getAccountTableId() == null && (ar = AccountRefContrastFactory.getLocalInstance((Context)this.ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), this.condition.getPeriodYearEnd(), this.condition.getPeriodNumberEnd())) != null && ar.getEnabledAcctTable() != null) {
            company.setAccountTable(ar.getEnabledAcctTable());
            this.condition.setAccountTableId(ar.getEnabledAcctTable().getId().toString());
        }
        CurrencyInfo baseCurrency = this.getBaseCurrency(this.ctx, company);
        company.setBaseCurrency(baseCurrency);
        if (this.condition.getRptParams().isUseReportCurrency()) {
            CurrencyInfo rptCurrency = this.getRptCurrency(this.ctx, company);
            company.setReportCurrency(rptCurrency);
        }
        return company;
    }

    protected CurrencyInfo getQueryCurrencyInfo() throws EASBizException, BOSException {
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.condition.getCurrencyID())) {
            return this.company.getBaseCurrency();
        }
        if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.condition.getCurrencyID())) {
            return this.company.getReportCurrency();
        }
        if (!this.condition.isAllCurrency()) {
            return this.getCurrency(this.ctx, this.condition.getCurrencyID());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createDataSourceTable(EntityViewInfo ev) throws BOSException, EASBizException {
        try {
            this.init(ev);
            this.selector = this.initSelector();
            if (this.isInsertAfterCurrPeriodBalance() && this.condition.isAfterCurrPeriod()) {
                if (CompanyDisplayModeEnum.enumerate != this.condition.getCompanyDisplayMode()) {
                    this.selector.add(new GLRptField("FIsAfterCurrPeriod", "case when b.fperiod > ssc.fcurrperiod then 1 else 0 end", "FIsAfterCurrPeriod", "INT"));
                } else {
                    this.selector.add(new GLRptField("FIsAfterCurrPeriod", "case when b.fperiod > " + this.condition.getCurrPeriod().getNumber() + " then 1 else 0 end", "FIsAfterCurrPeriod", "INT"));
                }
            }
            this.sumItem = this.getTempTableSumItem();
            this.struct = this.getTempTableStruct();
            this.dataSourceTable = this.createDataTempTable();
            this.buildData();
            this.headInfo = this.initTableHeadInfo();
            this.dataManager = this.getRptDataManager();
            this.dataManager.init();
            String string = this.dataManager.getQueryId();
            return string;
        }
        finally {
            List<String> tempTables = GLTempTableUtil.getTempTables();
            if (tempTables != null) {
                this.processTempTables.addAll(tempTables);
            }
            GLTempTableUtil.dropDBSysTempTable(this.getContex());
        }
    }

    private IRptDataManager getRptDataManager() throws EASBizException, BOSException {
        if (!this.isCreateSeqTable()) {
            return new IDRptDataManager(this);
        }
        return new SeqTableRptDataManager(this);
    }

    public void createDataSourceTableIndex() {
        try {
            if (this.isCreateSeqTable()) {
                TempTablePool.getInstance((Context)this.ctx).createIndex(this.getDataSourceTableName(), "KSQL_SEQ", false, false);
            } else {
                TempTablePool.getInstance((Context)this.ctx).createIndex(this.getDataSourceTableName(), "KSQL_SEQ,SQL_BATCH", false, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"create index error!", (Throwable)e);
        }
    }

    protected void insertFuturePeriodBalance() throws BOSException, EASBizException {
        String periodTypeId = this.condition.getPeriodTypeId().toString();
        PeriodInfo currPeriod = this.condition.getCurrPeriod();
        int startPeriod = this.condition.getPeriodYearStart() * 100 + this.condition.getPeriodNumberStart();
        int endPeriod = this.condition.getPeriodYearEnd() * 100 + this.condition.getPeriodNumberEnd();
        if (currPeriod.getNumber() > startPeriod) {
            startPeriod = currPeriod.getNumber();
        }
        PeriodCollection pc = GLRptDaoUtil.getPeriodCollection(this.ctx, periodTypeId, startPeriod, endPeriod);
        PeriodInfo lastPeriod = null;
        if (pc.size() <= 0) {
            return;
        }
        if (pc.get(0).getNumber() > currPeriod.getNumber()) {
            lastPeriod = currPeriod;
        }
        GLRptBalNextPeriodQuery laterPeriodQuery = this.getRptBalNextPeriodQuery(this.ctx, this.condition);
        laterPeriodQuery.setSelector(this.selector);
        laterPeriodQuery.setDataSourceTableName(this.dataSourceTable.getTableName());
        if (CompanyDisplayModeEnum.enumerate != this.condition.getCompanyDisplayMode()) {
            String sysStatusTmpTable = GLRptDaoUtil.createSysStatusTmpTable(this.getContex(), this.condition);
            laterPeriodQuery.setSysStatusTable(sysStatusTmpTable);
        }
        for (int i = 0; i < pc.size(); ++i) {
            PeriodInfo period = pc.get(i);
            if (lastPeriod != null) {
                laterPeriodQuery.setPeriod(lastPeriod.getNumber(), period.getNumber());
                this.insertData(laterPeriodQuery.getSQL());
            }
            lastPeriod = period;
        }
    }

    protected GLRptBalNextPeriodQuery getRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new GLRptBalNextPeriodQuery(ctx, cond);
    }

    protected boolean isInsertAfterCurrPeriodBalance() {
        return false;
    }

    protected int getExpandLevel() {
        int level = -1;
        if (this.getTreeColmun() != null) {
            if (this.getOrgUnit().isIsBizUnit()) {
                level = 1;
            } else {
                int rootLevel = ((SimpleCompanyUserObject)((DefaultMutableTreeNode)this.condition.getTreeModelOfCompany()).getUserObject()).getLevel();
                level = this.condition.getExpandCompanyLevel() + rootLevel - 1;
            }
        }
        return level;
    }

    protected GLRptTempTableInfo createDataTempTable() throws BOSException, EASBizException {
        if (this.isCreateSeqTable()) {
            return new GLRptTempTableInfo(GLTempTableUtil.createDBSysTempTable(this.getContex(), this.struct.getDataTableDesc()));
        }
        return new GLRptTempTableInfo(GLTempTableUtil.createTempTable(this.getContex(), "KSQL_SEQ INT IDENTITY (1, 1), SQL_BATCH INT," + this.struct.getDataTableDesc()));
    }

    protected GLRptTempTableStruct getTempTableStruct() throws BOSException, EASBizException {
        GLRptTempTableStruct struct = new GLRptTempTableStruct();
        Iterator<GLRptField> it = this.selector.iterator();
        boolean isCreateDataTempTable = this.isCreateDataTempTable();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!this.isCreateFiled(field, isCreateDataTempTable)) continue;
            String defaultValue = null;
            if (field.getName() == "FIsAfterCurrPeriod") {
                defaultValue = "0";
            } else if (field.getType() == "NUMERIC(29,10)") {
                defaultValue = "0.0";
            }
            this.addTempTableField(struct, field, defaultValue);
        }
        if (this.sumItem != null) {
            for (GLRptSumItemInfo item : this.sumItem.getSumItems()) {
                this.addTempTableField(struct, new GLRptField(item.getName(), "INT", true), "0");
            }
        }
        return struct;
    }

    protected boolean isCreateFiled(GLRptField field, boolean isCreateDataTempTable) {
        return !(field.getType() == "NUMERIC(29,10)" && !isCreateDataTempTable || !field.isTempTableField() && field.getType() != "NUMERIC(29,10)");
    }

    protected String[] getTempTableFields() throws EASBizException, BOSException {
        ArrayList fieldList = new ArrayList();
        Iterator<GLRptField> fIt = this.selector.iterator();
        while (fIt.hasNext()) {
            GLRptField field = fIt.next();
            if (field.getSelect() == null || field.getType() == "NUMERIC(29,10)" && !this.isCreateDataTempTable() || !field.isTempTableField() || field.getQueryField() == null) continue;
            this.appendTempTableField(fieldList, field);
        }
        String[] fields = new String[fieldList.size()];
        fields = fieldList.toArray(fields);
        return fields;
    }

    protected void addTempTableField(GLRptTempTableStruct struct, GLRptField field, String defaultValue) throws EASBizException, BOSException {
        String type = field.getType();
        String typeFromDB = GLTempTableUtil.getDataTypeWithoutFieldName(field.getName(), this.getDataTypes(this.ctx), type);
        if (typeFromDB != null && !typeFromDB.equalsIgnoreCase(type)) {
            type = typeFromDB;
        }
        struct.addField(field.getName(), type, defaultValue);
    }

    protected void buildData() throws BOSException, EASBizException {
        this.insertData();
        if (this.isInsertAfterCurrPeriodBalance() && this.condition.isAfterCurrPeriod()) {
            this.insertFuturePeriodBalance();
        }
        if (this.isGroupByCompany()) {
            this.insertCompanyLevelSumData();
        }
        this.insertSumItem();
    }

    protected void insertCompanyLevelSumData() throws EASBizException, BOSException {
        this.insertLevelSumData(GLRptField.orgUnitID, "t_org_company", "cp", this.getCompany().getLevel());
    }

    protected boolean isGroupByCompany() throws EASBizException, BOSException {
        return this.condition.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && this.getGLRptSelector().contains(GLRptField.orgUnitID);
    }

    protected abstract void insertData() throws BOSException, EASBizException;

    protected void appendTempTableField(ArrayList fieldList, GLRptField field) {
        fieldList.add(field.getName());
    }

    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        GLRptTableHeadInfo headInfo = new GLRptTableHeadInfo();
        this.addTableHeadColumn(headInfo, new GLRptField("KSQL_SEQ", "INT"));
        if (!this.isCreateSeqTable()) {
            this.addTableHeadColumn(headInfo, new GLRptField("SQL_BATCH", "INT"));
        }
        if (this.selector == null) {
            return headInfo;
        }
        Iterator<GLRptField> it = this.selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            this.addTableHeadColumn(headInfo, field);
        }
        this.addSumItemColumn(headInfo);
        headInfo.setHeadTitle(this.getHeadTitles());
        return headInfo;
    }

    @Override
    public GLRptTableHeadInfo getTableHeadInfo() throws BOSException, EASBizException {
        return this.headInfo;
    }

    protected void addSumItemColumn(GLRptTableHeadInfo headInfo) throws EASBizException, BOSException {
        if (this.sumItem != null) {
            for (GLRptSumItemInfo item : this.sumItem.getSumItems()) {
                GLRptField field = new GLRptField(item.getName(), "INT");
                this.addTableHeadColumn(headInfo, field);
            }
        }
    }

    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field.getName() == null) {
            return;
        }
        GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
        colInfo.setColName(field.getName());
        colInfo.setWidth(field.getLength());
        if (field.getLength() == -1) {
            colInfo.setHide(true);
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
        if (field.getType() == "NUMERIC(29,10)") {
            colInfo.setNumeral(true);
            this.setAmountColScale(field, colInfo);
        } else if (field.getType() == "NUMERIC(27,10)") {
            colInfo.setNumeral(true);
            colInfo.setScale(this.condition.getRptParams().getPriceScale());
        }
        if (this.getTreeColmun() != null && field.getLength() >= 0 && field.getName().equals(this.getTreeColmun().getName())) {
            colInfo.setTreeNode(true);
        }
    }

    protected void setAmountColScale(GLRptField field, GLRptTableHeadInfo.GLRptTableColumnInfo colInfo) throws EASBizException, BOSException {
        if (field.isQty()) {
            colInfo.setScale(this.condition.getQtyScale());
        } else if (field.isPrice()) {
            colInfo.setScale(this.condition.getRptParams().getPriceScale());
        } else {
            CurrencyInfo currency = this.getQueryCurrencyInfo();
            if (currency != null && field.getName().endsWith("For")) {
                colInfo.setScale(currency.getPrecision());
            } else if (field.getName().endsWith("Local")) {
                colInfo.setScale(this.company.getBaseCurrency().getPrecision());
            } else if (this.company.getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                colInfo.setScale(this.company.getReportCurrency().getPrecision());
            }
        }
    }

    protected GLRptField getFreezeField() {
        return null;
    }

    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = !this.condition.isShowQty() && this.isSingleAmountFiled() ? new String[][]{this.getTitleRow1()} : new String[][]{this.getTitleRow1(), this.getTitleRow2()};
        return titles;
    }

    protected boolean isSingleAmountFiled() throws EASBizException, BOSException {
        if (this.condition.getRptParams().isUseReportCurrency() && this.company.getReportCurrency() == null) {
            this.company.setReportCurrency(this.company.getBaseCurrency());
        }
        return !this.isExistAmount() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.condition.getCurrencyID()) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.condition.getCurrencyID()) || this.condition.getRptParams().isForeignCurrencySu() || (this.condition.getRptParams().isUseReportCurrency() ? this.company.getBaseCurrency().getId().toString().equals(this.condition.getCurrencyID()) && this.company.getReportCurrency().getId().toString().equals(this.condition.getCurrencyID()) : this.company.getBaseCurrency().getId().toString().equals(this.condition.getCurrencyID()));
    }

    private boolean isExistAmount() {
        Iterator<GLRptField> it = this.selector.iterator();
        while (it.hasNext()) {
            if (it.next().getType() != "NUMERIC(29,10)") continue;
            return true;
        }
        return false;
    }

    protected String[] getTitleRow1() throws EASBizException, BOSException {
        Iterator<GLRptField> it = this.selector.iterator();
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            this.setRow1Title(colTitles, field);
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void addSumItemTitle(List colTitles) throws EASBizException, BOSException {
        if (this.sumItem != null) {
            for (GLRptSumItemInfo item : this.sumItem.getSumItems()) {
                colTitles.add(item.getName());
            }
        }
    }

    protected void setRow1Title(List colTitles, GLRptField field) {
        colTitles.add(field.getTitle() == null ? "" : field.getTitle());
    }

    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            this.setRow2Title(colTitles, field);
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.getType() == "NUMERIC(29,10)") {
            if (field.isQty()) {
                colTitles.add("asst_quantity");
            } else if (this.isSingleAmountFiled()) {
                colTitles.add("money_amount");
            } else if (field.getName().endsWith("For")) {
                colTitles.add("currency_for");
            } else if (field.getName().endsWith("Local")) {
                colTitles.add("currency_local");
            } else if (field.getName().endsWith("Rpt")) {
                colTitles.add("currency_rpt");
            }
        } else {
            colTitles.add(field.getTitle());
        }
    }

    @Override
    public int getViewRowCount() throws BOSException, EASBizException {
        return this.dataManager.getTotalRowCount();
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        if (length == 0) {
            return new GLRptRowSet(this.headInfo.getColNames(), 0);
        }
        GLRptRowSet result = this.dataManager.getData(start, length);
        if (this.getContex().get((Object)"isPca") != null) {
            this.getContex().put((Object)"isPca", null);
        }
        return result;
    }

    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
    }

    protected void doDetailRowSet(GLRptRowSet rowSet) throws EASBizException, BOSException {
    }

    protected void setTreeNode(GLRptRowSet rowSet, IRowSet rs, GLRptTreeNode node) throws BOSException {
        rowSet.updateObject(this.getTreeColmun().getName(), node);
    }

    protected void setSumData(int start, GLRptPageQuery query, GLRptID[] ids, GLRptRowSet rowSet) throws BOSException, EASBizException, SQLException {
        if (this.sumItem == null || !this.isAutoSumData()) {
            return;
        }
        for (GLRptSumItemInfo item : this.sumItem.getSumItems()) {
            if (item.isAsyn() && this.isCreateSeqTable()) {
                this.setAsynWaitPrompt(rowSet, item);
                continue;
            }
            query.setSumItem(item);
            String sql = query.getSQL();
            IRowSet rs = this.executeQuery(sql, query.getSQLParams().toArray());
            while (rs.next()) {
                int rowIndex = this.getRowIndex(item, start, ids, rowSet, rs);
                rowSet.moveToRow(rowIndex + start);
                this.toGLRptRowData(rs, rowSet);
                this.doGLRptRowData(rowSet);
            }
        }
    }

    protected void toAmountRowData(IRowSet rs, GLRptRowSet rowSet) throws BOSException, SQLException {
        Iterator<GLRptField> it = this.selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null) continue;
            if (field.getType() == "NUMERIC(29,10)") {
                rowSet.updateObject(field.getName(), rs.getObject(field.getName()));
                continue;
            }
            if (rs.getObject(field.getName()) == null) continue;
            rowSet.updateObject(field.getName(), rs.getObject(field.getName()));
        }
    }

    private int getRowIndex(GLRptSumItemInfo item, int start, GLRptID[] ids, GLRptRowSet rowSet, IRowSet rs) throws SQLException, BOSException {
        int rowIndex = -1;
        if (ids != null) {
            rowIndex = this.indexof(ids, rs);
        } else if (this.isCreateSeqTable()) {
            rowIndex = rs.getInt("KSQL_SEQ") - start - 1;
        } else {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                ++rowIndex;
                if (rowSet.getInt(item.getName()) != 1 || !this.isSameRecrod(rowSet, rs)) continue;
                break;
            }
        }
        return rowIndex;
    }

    protected boolean isAutoSumData() {
        return true;
    }

    @Override
    public GLRptRowSet getAsynSumData() throws BOSException, EASBizException {
        if (this.sumItem == null) {
            return null;
        }
        List asynSumIts = this.sumItem.getAsynSumItems();
        if (asynSumIts == null) {
            return null;
        }
        if (!this.isCreateSeqTable()) {
            return null;
        }
        return ((SeqTableRptDataManager)this.dataManager).getAsynSumData();
    }

    private boolean isSameRecrod(GLRptRowSet subTotalRs, IRowSet rs) throws BOSException, SQLException {
        return subTotalRs.getInt("KSQL_SEQ") == rs.getInt("KSQL_SEQ") && subTotalRs.getInt("SQL_BATCH") == rs.getInt("SQL_BATCH");
    }

    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws BOSException, EASBizException, SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String colName = md.getColumnName(i);
            Object value = null;
            if (md.getColumnType(i) == 91 || md.getColumnType(i) == 93) {
                Date date = rs.getDate(i);
                if (date != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    value = df.format(date);
                }
            } else {
                value = rs.getObject(i);
            }
            this.updateField(rs, rowData, colName, value);
        }
    }

    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        rowData.updateObject(colName, value);
    }

    protected void setAsynWaitPrompt(GLRptRowSet rowData, GLRptSumItemInfo item) throws BOSException {
        rowData.beforeFirst();
        String waitColName = this.getShowAsynWaitColName(item);
        while (rowData.next()) {
            if (rowData.getInt(item.getName()) != 1) continue;
            rowData.updateString(waitColName, EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"612_AbstractGLRptDao", (Locale)this.ctx.getLocale()));
        }
    }

    protected String getShowAsynWaitColName(GLRptSumItemInfo item) {
        String firstAmountField = null;
        Iterator<GLRptField> it = this.selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!field.getType().equals("NUMERIC(29,10)")) continue;
            firstAmountField = field.getName();
            break;
        }
        if (firstAmountField == null) {
            return null;
        }
        return firstAmountField;
    }

    protected void insertData(String[] fields, String querySQL, List params) throws BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(this.dataSourceTable.getTableName());
        if (fields != null && fields.length > 0) {
            insertSql.append("(");
            if (!this.isCreateSeqTable()) {
                insertSql.append("KSQL_SEQ").append(", ").append("SQL_BATCH").append(", ");
            }
            insertSql.append(fields[0]);
            for (int i = 1; i < fields.length; ++i) {
                insertSql.append(",").append(fields[i]);
            }
            insertSql.append(") ");
        }
        if (!this.isCreateSeqTable()) {
            int index;
            String sql;
            querySQL = querySQL.trim();
            Pattern p = Pattern.compile("/\\*.*?\\*/");
            Matcher matcher = p.matcher(sql = (index = querySQL.toUpperCase().indexOf("FROM")) >= 0 ? querySQL.substring(0, index) : querySQL.toString());
            if (matcher.find()) {
                if ("DISTINCT".equalsIgnoreCase(matcher.replaceFirst("").trim().split("\\s+")[1])) {
                    querySQL = querySQL.replaceFirst("DISTINCT ", "DISTINCT " + this.batch++ + ",");
                } else {
                    String selectSql = matcher.replaceFirst(matcher.group() + " " + this.batch++ + ",");
                    querySQL = selectSql + querySQL.substring(index);
                }
            } else {
                String f = querySQL.split("\\s+")[1];
                querySQL = "DISTINCT".equalsIgnoreCase(f) ? querySQL.replaceFirst(f, "DISTINCT " + this.batch++ + ",") : "SELECT " + this.batch++ + "," + querySQL.substring(6);
            }
        }
        insertSql.append(querySQL);
        if (params == null || params.size() == 0) {
            this.execute(insertSql.toString());
        } else {
            String sql = GLRptSQLUtil.getSqlWithParameters(insertSql.toString(), params.toArray());
            this.execute(sql);
        }
    }

    public GLRptBaseCondition getQueryCondition() {
        return this.condition;
    }

    protected void insertSumItem() throws EASBizException, BOSException {
        if (this.sumItem == null) {
            return;
        }
        Iterator it = this.sumItem.getSumItems().iterator();
        while (it.hasNext()) {
            ArrayList groupFields = new ArrayList();
            String sql = this.getSumItemSQL((GLRptSumItemInfo)it.next(), groupFields);
            this.insertData(groupFields.toArray(new String[groupFields.size()]), sql);
        }
    }

    protected String getSumItemSQL(GLRptSumItemInfo item, List groupFields) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct ");
        sql.append(" 1 ").append(item.getName());
        groupFields.add(item.getName());
        List fields = item.getFields();
        if (fields == null || fields.isEmpty()) {
            return sql.toString();
        }
        StringBuffer where = new StringBuffer();
        int j = 0;
        for (int i = 0; i < fields.size(); ++i) {
            GLRptField field = (GLRptField)fields.get(i);
            if (field.getQueryField() == null) continue;
            String fieldName = field.getName();
            sql.append(",");
            if (j == 0) {
                where.append(" where ");
                ++j;
            } else {
                where.append(" and ");
            }
            sql.append(" t.").append(fieldName);
            where.append(" t.").append(fieldName).append(" is not null");
            groupFields.add(fieldName);
        }
        GLRptPageQuery query = this.getGLRptDataQuery();
        query.setDataSourceTable(this.dataSourceTable);
        String filter = query.getWhereSQL();
        if (filter != null && filter.trim().length() > 0) {
            if (where.length() == 0) {
                where.append(" where ");
            } else {
                where.append(" and ");
            }
            where.append(" (").append(filter).append(")");
        }
        sql.append(" from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        sql.append(where);
        try {
            return KSqlUtil.optimize((String)sql.toString());
        }
        catch (SqlTranslateException e) {
            throw new BOSException("SqlTranslateException", (Throwable)e);
        }
    }

    protected void insertLevelSumData(GLRptField field, String table, String tab, int topLevel) throws EASBizException, BOSException {
        String whereSql;
        int maxLevel = this.getMaxLevel(table, field);
        StringBuffer sql = new StringBuffer();
        GLRptPageQuery query = this.getGLRptDataQuery();
        query.setSelector(this.getGLRptSelector());
        query.setDataSourceTable(this.dataSourceTable);
        sql.append(" select ").append(this.getParentSelectSQL(field, tab));
        sql.append("\r\n from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        sql.append(" where ");
        if (query.getCond().getCompanyDisplayMode() != CompanyDisplayModeEnum.merger && !StringUtils.isEmpty((Object)(whereSql = this.getWhere(query.getMainTable().getAlias())))) {
            sql.append(whereSql).append(" and ");
        }
        sql.append(tab).append(".flevel = ?");
        if (this.isInsertAfterCurrPeriodBalance() && this.condition.isAfterCurrPeriod()) {
            sql.append(" and t.").append("FIsAfterCurrPeriod").append(" = 0");
        }
        sql.append("\r\n group by ").append(this.getParentGroupBySQL(field, tab));
        String sqlStr = null;
        try {
            sqlStr = KSqlUtil.optimize((String)sql.toString());
        }
        catch (SqlTranslateException e) {
            throw new BOSException("sql optimize error!", (Throwable)e);
        }
        if ((this.condition.getProfitCenters() != null || this.condition.getProfitCenter() != null) && sqlStr.contains("t.FOrgUnitID,")) {
            sqlStr = sqlStr.replaceFirst("t.FOrgUnitID,", "1 FOrgUnitID,");
            sqlStr = sqlStr.replaceFirst("t.FOrgUnitID,", "");
        }
        for (int i = maxLevel; i > topLevel; --i) {
            ArrayList<Integer> sp = new ArrayList<Integer>();
            sp.add(new Integer(i));
            this.insertData(sqlStr, sp);
        }
    }

    protected int getMaxLevel(String table, GLRptField field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(flevel) maxLevel ");
        sql.append(" from ").append(table);
        sql.append(" where fid in (select ").append(field.getName()).append(" from ").append(this.getDataSourceTable().getTableName()).append(")");
        IRowSet rs = this.executeQuery(sql.toString());
        int maxLevel = 0;
        try {
            if (rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error!", (Throwable)e);
        }
        return maxLevel;
    }

    protected String getParentSelectSQL(GLRptField sumField, String alias) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getName().equals(sumField.getName())) {
                sql.append(alias).append(".fparentid ").append(field.getName());
                continue;
            }
            if ("NUMERIC(29,10)".equals(field.getType())) {
                sql.append("sum(t.").append(field.getName()).append(") ").append(field.getName());
                continue;
            }
            if ("FIsAfterCurrPeriod".equals(field.getName())) {
                sql.append(" 0 ").append(field.getName());
                continue;
            }
            if (GLRptField.accountID.getName().compareToIgnoreCase(sumField.getName()) == 0 && CompanyDisplayModeEnum.merger == this.condition.getCompanyDisplayMode() && (GLRptField.accountNumberMerger.getName().compareToIgnoreCase(field.getName()) == 0 || GLRptField.accountNameMerger.getName().compareToIgnoreCase(field.getName()) == 0)) {
                sql.append(" p").append(field.getSelect());
                if (field.isMultiLang()) {
                    sql.append("_").append(this.ctx.getLocale());
                }
                sql.append(" ").append(field.getName());
                continue;
            }
            sql.append("t.").append(field.getName());
        }
        return sql.toString();
    }

    protected String getParentGroupBySQL(GLRptField sumField, String alias) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null || field.getQueryField() == null || field.getType() == "NUMERIC(29,10)" || "FIsAfterCurrPeriod".equals(field.getName())) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getName().equals(sumField.getName())) {
                sql.append(alias).append(".fparentid");
                continue;
            }
            if (GLRptField.accountID.getName().compareToIgnoreCase(sumField.getName()) == 0 && CompanyDisplayModeEnum.merger == this.condition.getCompanyDisplayMode() && (GLRptField.accountNumber.getName().compareToIgnoreCase(field.getName()) == 0 || GLRptField.accountName.getName().compareToIgnoreCase(field.getName()) == 0)) {
                sql.append(" p").append(field.getSelect());
                if (!field.isMultiLang()) continue;
                sql.append("_").append(this.ctx.getLocale());
                continue;
            }
            sql.append("t.").append(field.getName());
        }
        return sql.toString();
    }

    protected String getWhere(String alias) {
        return null;
    }

    protected abstract GLRptSelector initSelector() throws EASBizException, BOSException;

    protected GLRptSelector getGLRptSelector() {
        return this.selector;
    }

    protected void setGLRptSelector(GLRptSelector selector) {
        this.selector = selector;
    }

    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        return null;
    }

    private CurrencyInfo getRptCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getReportCurrency() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("reportCurrency.id"));
            selector.add(new SelectorItemInfo("reportCurrency.name"));
            selector.add(new SelectorItemInfo("reportCurrency.precision"));
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector).getReportCurrency();
        }
        if (company.getReportCurrency().get("precision") == null) {
            if (company.getReportCurrency().getId().equals((Object)company.getBaseCurrency().getId())) {
                return company.getBaseCurrency();
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("precision"));
            return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getReportCurrency().getId()));
        }
        return company.getReportCurrency();
    }

    private CurrencyInfo getBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getBaseCurrency() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.precision"));
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector).getBaseCurrency();
        }
        if (company.getBaseCurrency().get("precision") == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("precision"));
            return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        }
        return company.getBaseCurrency();
    }

    protected CurrencyInfo getCurrency(Context ctx, String currencyId) throws EASBizException, BOSException {
        if (currencyId.equals(this.company.getBaseCurrency().getId().toString())) {
            return this.company.getBaseCurrency();
        }
        if (this.company.getReportCurrency() != null && currencyId.equals(this.company.getReportCurrency().getId().toString())) {
            return this.company.getReportCurrency();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("precision"));
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
    }

    protected int getMaxCompanyLevel() throws BOSException {
        IRowSet rs = this.executeQuery("select max(FLevel) maxLevel from t_org_company where fid in " + this.condition.getCompanyIdsStr());
        try {
            if (rs.next()) {
                return rs.getInt("maxLevel");
            }
            return 1;
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
    }

    protected List queryIdList(Context ctx, String sql, IGLRptIDCreator idCreator) throws BOSException {
        ArrayList<GLRptID> arrayList;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("GLRptQuery sql error!", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            ArrayList<GLRptID> idList = new ArrayList<GLRptID>();
            while (rs.next()) {
                idList.add(idCreator.create(rs));
            }
            arrayList = idList;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return arrayList;
    }

    protected int indexof(GLRptID[] ids, IRowSet rs) throws SQLException {
        if (ids == null) {
            return -1;
        }
        int batch = rs.getInt("SQL_BATCH");
        int seq = rs.getInt("KSQL_SEQ");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].getBatch() != batch || ids[i].getSeq() != seq) continue;
            return i;
        }
        return -1;
    }

    protected boolean isAllCurrency() {
        return this.condition.isAllCurrency();
    }

    protected boolean isGeneralLocalCurrency() {
        return this.condition.isGeneralLocalCurrency();
    }

    protected boolean isGeneralReportCurrency() {
        return this.condition.isGeneralReportCurrency();
    }

    protected boolean isShowQty() {
        return this.condition.isShowQty();
    }

    protected boolean isShowFor() {
        return this.condition.isShowFor();
    }

    protected boolean isShowLocal() throws EASBizException, BOSException {
        return this.condition.isShowLocal();
    }

    protected boolean isShowRpt() throws EASBizException, BOSException {
        return this.condition.isShowRpt();
    }

    @Override
    public void releaseTempTable() {
        for (String tempTable : this.processTempTables) {
            try {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
            }
            catch (Exception e) {
                logger.error((Object)"Release tempTable error!", (Throwable)e);
            }
        }
        this.processTempTables.clear();
        GLTempTableUtil.dropTempTable(this.getContex(), this.dataSourceTable.getTableName());
    }

    protected void insertData(String[] fields, String querySQL) throws EASBizException, BOSException {
        this.insertData(fields, querySQL, null);
    }

    protected void insertData(String querySQL, List params) throws BOSException, EASBizException {
        this.insertData(this.getTempTableFields(), querySQL, params);
    }

    protected void insertData(String querySQL) throws EASBizException, BOSException {
        this.insertData(querySQL, null);
    }

    protected abstract GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException;

    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return this.getTreeColmun() != null || this.condition.isAfterCurrPeriod() || this.condition.isOptionAmountZero() || this.condition.isOptionBalanceZero() || this.condition.isOptionAmountAndBalZero();
    }

    protected boolean isCreateSeqTable() throws BOSException {
        return !this.isUseRptID();
    }

    protected boolean isUseRptID() {
        return this.getTreeColmun() != null;
    }

    public GLRptIDManager createIDManager() {
        return new GLRptIDManager();
    }

    public IGLRptIDCreator getGLRptIDCreator(String mainTableAlias, GLRptField field) {
        return new DefaultGLRptIDCreator(mainTableAlias, this.getQueryCondition());
    }

    public GLRptField getTreeColmun() {
        if (!this.company.isIsBizUnit()) {
            return GLRptField.orgUnitName;
        }
        return null;
    }

    protected IRowSet executeQuery(String sql) throws BOSException {
        return this.executeQuery(sql, null);
    }

    protected IRowSet executeQuery(String sql, Object[] params) throws BOSException {
        if (params == null) {
            return DbUtil.executeQuery((Context)this.ctx, (String)sql);
        }
        return DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params);
    }

    protected void execute(String sql) throws BOSException {
        this.execute(sql, null);
    }

    protected void execute(String sql, Object[] params) throws BOSException {
        if (SQLUtil.isOracle(this.ctx) && (sql.contains("/*+ opt_param('_complex_view_merging','false') */") || sql.contains("/*+ opt_param('_complex_view_merging','true') */"))) {
            int index;
            sql = sql.replaceAll("ISNULL", "NVL");
            StringBuffer buffer = new StringBuffer();
            String key = "TO_DATE('";
            int start = 0;
            while ((index = sql.indexOf(key, start)) >= 0) {
                buffer.append(sql.substring(start, index += key.length()));
                start = index;
                index = sql.indexOf("')", start);
                String date = sql.substring(start, index);
                if (date.length() <= 10) {
                    date = date + " 00:00:00";
                }
                buffer.append(date).append("', 'YYYY-MM-DD HH24:MI:SS");
                start = index;
            }
            buffer.append(sql.substring(start));
            sql = AbstractGLRptDao.replaceFunction(buffer.toString(), "CHARINDEX");
            sql = "/*dialect*/ " + sql;
        }
        if (params == null) {
            DbUtil.execute((Context)this.ctx, (String)sql);
        } else {
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])params);
        }
    }

    private static String replaceFunction(String sql, String function) {
        StringBuffer buffer = new StringBuffer();
        int len = sql.length();
        int start = 0;
        int begin = 0;
        block0: while ((begin = sql.indexOf(function, start)) >= 0) {
            buffer.append(sql.substring(start, begin));
            int left = 0;
            for (int index = begin + 9; index < len; ++index) {
                char c = sql.charAt(index);
                if (c == '(') {
                    ++left;
                    continue;
                }
                if (c != ')' || --left != 0) continue;
                String fsql = sql.substring(begin, index + 1);
                buffer.append(AbstractGLRptDao.translateFunction(fsql, function));
                start = index + 1;
                continue block0;
            }
        }
        if (buffer.length() > 0) {
            if (start < len) {
                buffer.append(sql.substring(start));
            }
            return buffer.toString();
        }
        return sql;
    }

    private static String translateFunction(String fsql, String function) {
        int index = fsql.indexOf(44);
        int start = fsql.indexOf(40);
        int end = fsql.lastIndexOf(41);
        if (index < 0 || start < 0 || end < 0 || end < start) {
            return fsql;
        }
        String[] strs = fsql.substring(start + 1, end).split(",");
        if (strs.length != 2) {
            return fsql;
        }
        return "INSTR(" + strs[1].trim() + ", " + strs[0].trim() + ")";
    }

    protected void createIndex(String tableName, String fieldNames) throws Exception {
        TempTablePool.getInstance((Context)this.ctx).createIndex(tableName, fieldNames, false, false);
    }

    public Context getContex() {
        return this.ctx;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public GLRptTempTableInfo getDataSourceTable() {
        return this.dataSourceTable;
    }

    public String getDataSourceTableName() {
        return this.dataSourceTable.getTableName();
    }

    public void setDataSourceTable(GLRptTempTableInfo dataSourceTable) {
        this.dataSourceTable = dataSourceTable;
    }

    public IRptDataManager getDataManager() {
        return this.dataManager;
    }

    public GLRptSumItems getSumItem() {
        return this.sumItem;
    }

    protected String getAccountBalanceTable() {
        return GLBalanceUtils.getAccountBalanceTable(this.getQueryCondition());
    }

    protected String getAssistBalanceTable() {
        return GLBalanceUtils.getAssistBalanceTable(this.getQueryCondition());
    }

    protected String getAssistMeasureBalanceTable() {
        return GLBalanceUtils.getAssistMeasureBalanceTable(this.getQueryCondition());
    }

    protected boolean isAsynSumData() {
        return this.isAsynSumData;
    }

    protected OrgUnitExtInfo getOrgUnit() {
        return this.getCompany();
    }

    protected String getLocaleStr(String name) {
        return EASResource.getString((String)this.resource, (String)name, (Locale)this.ctx.getLocale());
    }
}

