/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.AcctCussentCheckCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.AcctCussentCheckTreePageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.AcctCussentCheckTreeQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class AcctCussentCheckTreeDao
extends AbstractGLRptDao {
    protected AcctCussentCheckCondition cond;

    public AcctCussentCheckTreeDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (AcctCussentCheckCondition)this.getQueryCondition();
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new AcctCussentCheckTreePageQuery(this.getContex(), this.cond);
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            selector.add(GLRptField.genAsstDataBaseID(at));
            boolean isShowNumber = this.cond.getRptParams().isAssitemShowNumber();
            boolean isShowLongName = this.cond.getRptParams().isShowLongNameForGeneral();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            selector.add(GLRptField.genAsstDataBaseNumber(at, isShowLongNumber));
            selector.add(GLRptField.genAsstDataBaseName(at, this.getContex().getLocale(), isShowNumber, isShowLongNumber, isShowLongName));
        }
        return selector;
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        GLRptQuery query = this.getQuery();
        GLRptSelector selector = this.getGLRptSelector();
        Iterator<GLRptField> it = selector.iterator();
        GLRptSelector insertSel = new GLRptSelector();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (!f.isTempTableField() || f.getSelect() == null) continue;
            insertSel.add(f);
        }
        query.setSelector(insertSel);
        List<GLRptField> keyFields = selector.getTempTableFields();
        String[] fields = new String[keyFields.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = keyFields.get(i).getName();
        }
        String sql = query.getSQL();
        List param = ((AcctCussentCheckTreeQuery)query).getParam();
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(this.getDataSourceTable().getTableName());
        if (fields != null && fields.length > 0) {
            insertSql.append("(");
            if (!this.isCreateSeqTable()) {
                insertSql.append("KSQL_SEQ").append(", ").append("SQL_BATCH").append(", ");
            }
            insertSql.append(fields[0]);
            for (int i = 1; i < fields.length; ++i) {
                insertSql.append(",").append(fields[i]);
            }
            insertSql.append(") ");
        }
        insertSql.append(sql);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBUtils.getConnection((Context)this.getContex());
            ps = con.prepareStatement(insertSql.toString());
            int i = 1;
            for (Object obj : param) {
                if (obj == null) {
                    ps.setString(i++, "");
                    continue;
                }
                if (obj.getClass().equals(Integer.class)) {
                    ps.setInt(i++, (Integer)obj);
                    continue;
                }
                if (obj.getClass().equals(Date.class)) {
                    ps.setDate(i++, (Date)obj);
                    continue;
                }
                ps.setString(i++, (String)obj);
            }
            ps.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    protected GLRptQuery getQuery() throws BOSException, EASBizException {
        if (this.cond.isHideNotHappened()) {
            // empty if block
        }
        return new AcctCussentCheckTreeQuery(this.getContex(), this.cond);
    }

    protected GLRptBalQuery getRptAsstactBalQuery(Context ctx, OrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAsstactBalQuery(ctx, company, cond, isMeasureUnit, isCreateDataTempTable);
    }

    protected GLRptVoucherAssistQuery getRptVoucherAssistQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isOnlyQty) {
        return new GLRptVoucherAssistQuery(ctx, cond, isOnlyQty);
    }
}

