/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.rpt.GLInnerAcctContrastCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLInnerAcctContrastDetailBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLInnerAcctContrastDetailPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GLInnerAcctContrastDetailDao
extends AbstractGLRptDao {
    private String tempContrastTable;
    private String tempAccountTable;
    private GLInnerAcctContrastCondition cond;
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    private boolean isYearQuery = false;

    public GLInnerAcctContrastDetailDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    @Override
    public void buildData() throws BOSException, EASBizException {
        this.insertData();
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLInnerAcctContrastCondition)this.getQueryCondition();
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        this.cond.setLeafAccount(false);
        String strStructure = this.getTempContrastTableStruct();
        this.tempContrastTable = GLTempTableUtil.createDBSysTempTable(this.getContex(), strStructure);
        this.insertFirstTempContrastData();
        this.createAccountTempTalbe();
        this.insertContrastDetailDataNew();
        this.insertSumtotalData();
        GLTempTableUtil.dropTempTable(this.getContex(), this.tempContrastTable);
    }

    protected void createAccountTempTalbe() throws BOSException {
        StringBuffer strAccount = new StringBuffer();
        strAccount.append("FAccountNumber VARCHAR(44),");
        strAccount.append("FOppAccountNumber VARCHAR(44),");
        strAccount.append("FCurrencyid VARCHAR(44)");
        this.tempAccountTable = GLTempTableUtil.createDBSysTempTable(this.getContex(), strAccount.toString());
        StringBuffer accountSql = new StringBuffer();
        accountSql.append(" insert into ").append(this.tempAccountTable);
        if (this.cond.getContrastType() == 1) {
            Set tableDataList = this.cond.getTabledata();
            Iterator itr = tableDataList.iterator();
            CurrencyInfo[] currency = this.cond.getCurrencyList();
            while (itr.hasNext()) {
                Map row = (Map)itr.next();
                for (int i = 0; i < currency.length; ++i) {
                    if (itr.hasNext()) {
                        accountSql.append(" ").append(" select '").append(((Map)((List)row.get("account")).get(0)).get("number").toString()).append("', ");
                        accountSql.append(" '").append(((Map)row.get("oppAccount")).get("number").toString()).append("' , ");
                        accountSql.append(" '").append(currency[i].getId()).append("' union ");
                        continue;
                    }
                    if (i < currency.length - 1) {
                        accountSql.append(" ").append(" select '").append(((Map)((List)row.get("account")).get(0)).get("number").toString()).append("', ");
                        accountSql.append(" '").append(((Map)row.get("oppAccount")).get("number").toString()).append("' , ");
                        accountSql.append(" '").append(currency[i].getId()).append("' union ");
                        continue;
                    }
                    accountSql.append(" ").append(" select '").append(((Map)((List)row.get("account")).get(0)).get("number").toString()).append("', ");
                    accountSql.append(" '").append(((Map)row.get("oppAccount")).get("number").toString()).append("' , ");
                    accountSql.append(" '").append(currency[i].getId()).append("' ");
                }
            }
        } else {
            String gSql = "SELECT  FNUMBER  FROM t_bd_accountview where FCOMPANYID = ? and FACCOUNTTABLEID = ? and (FAC =1 or FACNotice =1) order by FNUMBER ";
            ArrayList<String> sp = new ArrayList<String>();
            sp.add(this.cond.getCompany().getId().toString());
            sp.add(this.cond.getCompany().getAccountTable().getId().toString());
            String sql = GLRptSQLUtil.getSqlWithParameters(gSql, sp.toArray());
            IRowSet rs = DbUtil.executeQuery((Context)this.cond.getCtx(), (String)sql.toString());
            ArrayList<String> accountNumber = new ArrayList<String>();
            try {
                while (rs.next()) {
                    accountNumber.add(rs.getString("FNUMBER"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            sql = "";
            sp = new ArrayList();
            sp.add(this.cond.getOppCompany()[0].getId().toString());
            sp.add(this.cond.getOppCompany()[0].getAccountTable().getId().toString());
            sql = GLRptSQLUtil.getSqlWithParameters(gSql, sp.toArray());
            IRowSet rst = DbUtil.executeQuery((Context)this.cond.getCtx(), (String)sql.toString());
            ArrayList<String> oppAccountNumber = new ArrayList<String>();
            try {
                while (rst.next()) {
                    oppAccountNumber.add(rst.getString("FNUMBER"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            CurrencyInfo[] currency = this.cond.getCurrencyList();
            ArrayList tempList = new ArrayList();
            ArrayList otempList = new ArrayList();
            int size = 0;
            tempList = accountNumber;
            otempList = oppAccountNumber;
            String tempId = "linshi";
            size = accountNumber.size() > oppAccountNumber.size() ? accountNumber.size() : oppAccountNumber.size();
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < currency.length; ++j) {
                    if (i + 1 < size) {
                        accountSql.append(" ").append(" select '").append((Object)(tempList.size() == 0 || tempList.size() <= i || tempList.size() > i && tempList.get(i) == null ? tempId + i : tempList.get(i))).append("', ");
                        accountSql.append(" '").append((Object)(otempList.size() == 0 || otempList.size() <= i || otempList.size() > i && otempList.get(i) == null ? tempId + i : otempList.get(i))).append("' , ");
                        accountSql.append(" '").append(currency[j].getId()).append("' union ");
                        continue;
                    }
                    if (j < currency.length - 1) {
                        accountSql.append(" ").append(" select '").append((Object)(tempList.size() == 0 || tempList.size() <= i || tempList.size() > i && tempList.get(i) == null ? tempId + i + j : tempList.get(i))).append("', ");
                        accountSql.append(" '").append((Object)(otempList.size() == 0 || otempList.size() <= i || otempList.size() > i && otempList.get(i) == null ? tempId + i + j : otempList.get(i))).append("' , ");
                        accountSql.append(" '").append(currency[j].getId()).append("' union ");
                        continue;
                    }
                    accountSql.append(" ").append(" select '").append((Object)(tempList.size() == 0 || tempList.size() <= i || tempList.size() > i && tempList.get(i) == null ? tempId + i + j : tempList.get(i))).append("', ");
                    accountSql.append(" '").append((Object)(otempList.size() == 0 || otempList.size() <= i || otempList.size() > i && otempList.get(i) == null ? tempId + i + j : otempList.get(i))).append("' , ");
                    accountSql.append(" '").append(currency[j].getId()).append("' ");
                }
            }
        }
        DbUtil.execute((Context)this.getContex(), (String)accountSql.toString());
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.orgUnitID);
        selector.add(GLRptField.orgUnitName);
        selector.add(GLRptField.oppOrgUnitID);
        selector.add(GLRptField.oppOrgUnitName);
        selector.add(GLRptField.accountID);
        selector.add(new GLRptField("accountNumber", "av.fnumber", "NVARCHAR(80)", "accountView_number", -1, false));
        if (this.cond == null) {
            this.cond = (GLInnerAcctContrastCondition)this.getQueryCondition();
        }
        selector.add(this.cond.getRptParams().isAccountShowLongName() ? GLRptField.accountDisplayName : GLRptField.accountName);
        selector.add(GLRptField.oppAccountID);
        selector.add(new GLRptField("oppAccountNumber", "avv.fnumber", "NVARCHAR(80)", "oppAccountView_number", -1, false));
        selector.add(this.cond.getRptParams().isAccountShowLongName() ? GLRptField.oppAccountDisplayName : GLRptField.oppAccountName);
        selector.add(new GLRptField("FIsAccountTotal", "b.FIsAccountTotal", "FIsAccountTotal", "INT"));
        selector.add(new GLRptField("FASSISTGRPType", "b.FASSISTGRPType", "FASSISTGRPType", "NVARCHAR(80)"));
        selector.add(new GLRptField("FOppASSISTGRPType", "b.FOppASSISTGRPType", "FOppASSISTGRPType", "NVARCHAR(80)"));
        selector.add(GLRptField.currencyID);
        selector.add(GLRptField.currencyNumber);
        selector.add(GLRptField.currencyName);
        selector.add(GLRptField.currencyPre);
        if (this.cond.getContrastDataType() == 1) {
            selector.add(GLRptField.yearBeginBalanceForS);
            selector.add(GLRptField.oppYearBeginBalanceForS);
            selector.add(GLRptField.yearBeginBalanceDiffForS);
            selector.add(GLRptField.yearBeginBalanceLocalS);
            selector.add(GLRptField.oppYearBeginBalanceLocalS);
            selector.add(GLRptField.yearBeginBalanceDiffLocalS);
            if (this.cond.getRptParams().isUseReportCurrency()) {
                selector.add(GLRptField.yearBeginBalanceRptS);
                selector.add(GLRptField.oppYearBeginBalanceRptS);
                selector.add(GLRptField.yearBeginBalanceDiffRptS);
            }
        } else if (this.cond.getContrastDataType() == 2) {
            selector.add(GLRptField.beginBalanceFor);
            selector.add(GLRptField.oppBeginBalanceFor);
            selector.add(GLRptField.beginBalanceDiffFor);
            selector.add(GLRptField.beginBalanceLocal);
            selector.add(GLRptField.oppBeginBalanceLocal);
            selector.add(GLRptField.beginBalanceDiffLocal);
            if (this.cond.getRptParams().isUseReportCurrency()) {
                selector.add(GLRptField.beginBalanceRpt);
                selector.add(GLRptField.oppBeginBalanceRpt);
                selector.add(GLRptField.beginBalanceDiffRpt);
            }
        } else {
            selector.add(GLRptField.endBalanceFor);
            selector.add(GLRptField.oppEndBalanceFor);
            selector.add(GLRptField.endBalanceDiffFor);
            selector.add(GLRptField.endBalanceLocal);
            selector.add(GLRptField.oppEndBalanceLocal);
            selector.add(GLRptField.endBalanceDiffLocal);
            if (this.cond.getRptParams().isUseReportCurrency()) {
                selector.add(GLRptField.endBalanceRpt);
                selector.add(GLRptField.oppEndBalanceRpt);
                selector.add(GLRptField.endBalanceDiffRpt);
            }
        }
        return selector;
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLInnerAcctContrastDetailPageQuery(this.getContex(), this.cond);
    }

    public String getTempContrastTableStruct() {
        StringBuffer tbl = new StringBuffer();
        tbl.append("FCompanyID VARCHAR(44),");
        tbl.append("FAccountID VARCHAR(44),FAccountNumber VARCHAR(44), FAccountDC INT,");
        tbl.append("FASSISTGRPID VARCHAR(44),");
        tbl.append("FASSISTGRPTYPE VARCHAR(44),");
        tbl.append("FOppCompanyID VARCHAR(44),");
        tbl.append("FCurrencyID VARCHAR(44),FPeriod INT,");
        tbl.append("  FYearBeginBalanceFor DECIMAL(28,10), FYearBeginBalanceLocal DECIMAL(28,10),  FYearBeginBalanceRpt DECIMAL(28,10),\r\n");
        tbl.append("  FBeginBalanceFor DECIMAL(28,10), FBeginBalanceLocal DECIMAL(28,10), FBeginBalanceRpt DECIMAL(28,10), \r\n");
        tbl.append("  FDebitFor DECIMAL(28,10), FDebitLocal DECIMAL(28,10), FDebitRpt DECIMAL(28,10), \r\n");
        tbl.append("  FCreditFor DECIMAL(28,10),  FCreditLocal DECIMAL(28,10), FCreditRpt DECIMAL(28,10),\r\n");
        tbl.append("  FYearDebitFor DECIMAL(28,10), FYearDebitLocal DECIMAL(28,10), FYearDebitRpt DECIMAL(28,10), \r\n");
        tbl.append("  FYearCreditFor DECIMAL(28,10), FYearCreditLocal DECIMAL(28,10), FYearCreditRpt DECIMAL(28,10),\r\n");
        tbl.append("  FEndBalanceFor DECIMAL(28,10), FEndBalanceLocal DECIMAL(28,10), FEndBalanceRpt DECIMAL(28,10)  \r\n ");
        tbl.append(" ,FIsAfterCurrPeriod INT ");
        return tbl.toString();
    }

    protected GLRptSelector getTempSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(new GLRptField("FCompanyID", "b.FCompanyID", "orgUnit.id", "VARCHAR(44)"));
        selector.add(GLRptField.accountID);
        selector.add(new GLRptField("accountNumber", "av.fnumber", "NVARCHAR(80)", "accountView_number", -1, false));
        selector.add(GLRptField.accountDC);
        selector.add(new GLRptField("FASSISTGRPID", "b.FASSISTGRPID", "asstgrp.id", "VARCHAR(44)"));
        selector.add(new GLRptField("FASSISTGRPTYPE", "b.FASSISTGRPTYPE", "asstgrp.id", "VARCHAR(44)"));
        selector.add(new GLRptField("FOppCompanyID", "b.FOppCompanyID", "orgUnit.id", "VARCHAR(44)"));
        selector.add(GLRptField.currencyID);
        selector.add(GLRptField.period);
        selector.add(GLRptField.beginBalanceFor);
        selector.add(GLRptField.beginBalanceLocal);
        selector.add(GLRptField.beginBalanceRpt);
        selector.add(GLRptField.debitFor);
        selector.add(GLRptField.debitLocal);
        selector.add(GLRptField.debitRpt);
        selector.add(GLRptField.creditFor);
        selector.add(GLRptField.creditLocal);
        selector.add(GLRptField.creditRpt);
        selector.add(GLRptField.yearDebitFor);
        selector.add(GLRptField.yearDebitLocal);
        selector.add(GLRptField.yearDebitRpt);
        selector.add(GLRptField.yearCreditFor);
        selector.add(GLRptField.yearCreditLocal);
        selector.add(GLRptField.yearCreditRpt);
        selector.add(GLRptField.endBalanceFor);
        selector.add(GLRptField.endBalanceLocal);
        selector.add(GLRptField.endBalanceRpt);
        selector.add(new GLRptField("FIsAfterCurrPeriod", "b.FIsAfterCurrPeriod", "FIsAfterCurrPeriod", "INT"));
        return selector;
    }

    public String getTempContrastTable(GLInnerAcctContrastCondition condition) throws BOSException, EASBizException {
        String result = "";
        this.cond = condition;
        this.cond.setLeafAccount(true);
        String strStructure = this.getTempContrastTableStruct();
        this.tempContrastTable = GLTempTableUtil.createDBSysTempTable(this.getContex(), strStructure);
        this.insertFirstTempContrastData();
        result = this.tempContrastTable;
        return result;
    }

    protected void insertDefaultDataTempContrastData(int period, String companyId, String oppCompanyId, String accountNumber, String currencyId, String companyIds) throws BOSException {
        int i;
        String tempTableName = "";
        tempTableName = this.tempContrastTable;
        StringBuffer tempField = new StringBuffer();
        tempField.append("  ( FCompanyID ,");
        tempField.append("FAccountID ,FAccountNumber , FAccountDC ,");
        tempField.append("FASSISTGRPID ,");
        tempField.append("FASSISTGRPTYPE ,");
        tempField.append("FOppCompanyID ,");
        tempField.append("FCurrencyID ,FPeriod ,");
        tempField.append("  FYearBeginBalanceFor , FYearBeginBalanceLocal ,  FYearBeginBalanceRpt ,");
        tempField.append("  FBeginBalanceFor , FBeginBalanceLocal , FBeginBalanceRpt , ");
        tempField.append("  FDebitFor , FDebitLocal , FDebitRpt , ");
        tempField.append("  FCreditFor ,  FCreditLocal , FCreditRpt ,");
        tempField.append("  FYearDebitFor , FYearDebitLocal , FYearDebitRpt ,");
        tempField.append("  FYearCreditFor , FYearCreditLocal , FYearCreditRpt ,");
        tempField.append("  FEndBalanceFor, FEndBalanceLocal , FEndBalanceRpt ");
        tempField.append(" ,FIsAfterCurrPeriod )  ");
        StringBuffer strSql = new StringBuffer();
        strSql.append(" select '").append(companyId).append("' fcompanyid,");
        if (this.cond.getContrastType() == 1) {
            strSql.append(" av.fid ,");
            strSql.append(" av.FNUMBER FAccountNumber,");
            strSql.append(" av.FDC FAccountDC,");
        } else {
            strSql.append(" av.fid faccountid,");
            strSql.append(" av.FNUMBER FAccountNumber,");
            strSql.append(" '',");
        }
        if (oppCompanyId.indexOf(",") > 0) {
            strSql.append(" '', '', T.foppcompanyid  foppcompanyid,");
        } else {
            strSql.append(" '', '',").append(oppCompanyId).append(" foppcompanyid,");
        }
        if (currencyId.indexOf(",") > 0) {
            strSql.append(" C.fcurrencyid fcurrencyid, ");
        } else {
            strSql.append(currencyId).append(" , ");
        }
        strSql.append(period).append(" , ");
        strSql.append(" 0 FYearBEGINBALANCEFOR,");
        strSql.append(" 0 FYearBEGINBALANCELOCAL,");
        strSql.append(" 0 FYearBEGINBALANCERPT,");
        strSql.append(" 0 FBEGINBALANCEFOR,");
        strSql.append(" 0 FBEGINBALANCELOCAL,");
        strSql.append(" 0 FBEGINBALANCERPT,");
        strSql.append(" 0 FDEBITFOR,");
        strSql.append(" 0 FDEBITLOCAL,");
        strSql.append(" 0 FDEBITRPT,");
        strSql.append(" 0 FCREDITFOR,");
        strSql.append(" 0 FCREDITLOCAL,");
        strSql.append(" 0 FCREDITRPT,");
        strSql.append(" 0 FYEARDEBITFOR,");
        strSql.append(" 0 FYEARDEBITLOCAL,");
        strSql.append(" 0 FYEARDEBITRPT,");
        strSql.append(" 0 FYEARCREDITFOR,");
        strSql.append(" 0 FYEARCREDITLOCAL,");
        strSql.append(" 0 FYEARCREDITRPT,");
        strSql.append(" 0 FENDBALANCEFOR,");
        strSql.append(" 0 FENDBALANCELOCAL,");
        strSql.append(" 0 FENDBALANCERPT ");
        strSql.append(" ,0 FIsAfterCurrPeriod");
        strSql.append(" from T_BD_ACCOUNTVIEW  av  ");
        if (oppCompanyId.indexOf(",") > 0) {
            String[] oppids = oppCompanyId.split(",");
            String tSql = "";
            for (i = 0; i < oppids.length; ++i) {
                tSql = tSql.length() == 0 ? " , ( select " + oppids[i] + " foppcompanyid " : tSql + " union select " + oppids[i] + " foppcompanyid ";
            }
            tSql = tSql + " ) T  ";
            strSql.append(tSql);
        }
        if (currencyId.indexOf(",") > 0) {
            String[] curids = currencyId.split(",");
            String cSql = "";
            for (i = 0; i < curids.length; ++i) {
                cSql = cSql.length() == 0 ? " , ( select " + curids[i] + " fcurrencyid " : cSql + " union select " + curids[i] + " fcurrencyid ";
            }
            cSql = cSql + " ) C  ";
            strSql.append(cSql);
        }
        strSql.append("  where  av.fcompanyid IN ").append(companyIds).append(" ");
        if (companyId.equals(this.cond.getCompany().getId().toString())) {
            strSql.append(" and av.FACCOUNTTABLEID ='").append(this.cond.getCompany().getAccountTable().getId().toString()).append("' ");
        } else {
            strSql.append(" and av.FACCOUNTTABLEID ='").append(this.cond.getOppCompany()[0].getAccountTable().getId().toString()).append("' ");
        }
        strSql.append(" and (av.FAC  = 1 or av.FACNotice = 1) ");
        if (this.cond.getContrastType() == 1) {
            strSql.append("  AND av.FNUMBER in (").append(accountNumber).append(") ");
        }
        strSql.append(" and not exists (select 1 from ").append(tempTableName).append(" T1 where T1.fcompanyid = av.fcompanyid and t1.faccountnumber = av.fnumber  ");
        if (currencyId.indexOf(",") > 0) {
            strSql.append(" and t1.fcurrencyid = c.fcurrencyid )");
        } else {
            strSql.append(" ) ");
        }
        DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + tempTableName + tempField.toString() + strSql.toString()));
    }

    @Override
    protected GLRptBalNextPeriodQuery getRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new GLInnerAcctContrastDetailBalNextPeriodQuery(ctx, cond);
    }

    protected void insertFuturePeriodBalance(int type, GLRptBaseCondition condition) throws BOSException, EASBizException {
        String periodTypeId = condition.getCompany().getAccountPeriodType().getId().toString();
        PeriodInfo currPeriod = null;
        currPeriod = condition.getCurrPeriod();
        StringBuffer tempField = new StringBuffer();
        tempField.append("  ( FCompanyID ,");
        tempField.append("FAccountID ,FAccountNumber , FAccountDC ,");
        tempField.append("FASSISTGRPID ,");
        tempField.append("FASSISTGRPTYPE ,");
        tempField.append("FOppCompanyID ,");
        tempField.append("FCurrencyID ,FPeriod ,");
        tempField.append("  FYearBeginBalanceFor , FYearBeginBalanceLocal ,  FYearBeginBalanceRpt ,");
        tempField.append("  FBeginBalanceFor , FBeginBalanceLocal , FBeginBalanceRpt , ");
        tempField.append("  FDebitFor , FDebitLocal , FDebitRpt , ");
        tempField.append("  FCreditFor ,  FCreditLocal , FCreditRpt ,");
        tempField.append("  FYearDebitFor , FYearDebitLocal , FYearDebitRpt ,");
        tempField.append("  FYearCreditFor , FYearCreditLocal , FYearCreditRpt ,");
        tempField.append("  FEndBalanceFor, FEndBalanceLocal , FEndBalanceRpt ");
        tempField.append(" ,FIsAfterCurrPeriod )  ");
        int startPeriod = condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
        int endPeriod = condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd();
        if (currPeriod.getNumber() > startPeriod) {
            startPeriod = currPeriod.getNumber();
        }
        PeriodCollection pc = GLRptDaoUtil.getPeriodCollection(this.getContex(), periodTypeId, startPeriod, endPeriod);
        PeriodInfo lastPeriod = null;
        if (pc.size() <= 0) {
            return;
        }
        if (pc.get(0).getNumber() > currPeriod.getNumber()) {
            lastPeriod = currPeriod;
        }
        GLRptBalNextPeriodQuery laterPeriodQuery = this.getRptBalNextPeriodQuery(this.getContex(), condition);
        laterPeriodQuery.setSelector(this.getTempSelector());
        laterPeriodQuery.setDataSourceTableName(this.tempContrastTable);
        for (int i = 0; i < pc.size(); ++i) {
            PeriodInfo period = pc.get(i);
            if (lastPeriod != null) {
                laterPeriodQuery.setPeriod(lastPeriod.getNumber(), period.getNumber());
                DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + this.tempContrastTable + tempField.toString() + laterPeriodQuery.getSQL()));
            }
            lastPeriod = period;
        }
    }

    protected void insertFirstTempContrastData() throws BOSException, EASBizException {
        int period = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        StringBuffer str = new StringBuffer();
        this.getInsertTempDataSql(str, 0, period);
        if (this.cond.isAfterCurrPeriod()) {
            this.isYearQuery = false;
            this.insertFuturePeriodBalance(0, this.cond);
        }
        this.insertDefaultDataTempContrastData(period, this.cond.getCompanyId(), this.cond.getOppCompanyStr(), this.cond.getAccountStr(), this.cond.getCurrencyIdStr(), this.cond.getCompanyIdsStr());
        str = new StringBuffer();
        this.getInsertTempDataSql(str, 1, period);
        this.insertDefaultDataTempContrastData(period, this.cond.getOppCompany()[0].getId().toString(), "'" + this.cond.getCompanyId() + "'", this.cond.getOppAccountStr(), this.cond.getCurrencyIdStr(), "(" + this.cond.getOppCompanyStr() + ")");
        String sql11 = "delete from " + this.tempContrastTable + " where FIsAfterCurrPeriod = 1 ";
        DbUtil.execute((Context)this.getContex(), (String)sql11);
    }

    private void getInsertTempDataSql(StringBuffer str, int type, int period) throws EASBizException, BOSException {
        int balType = this.cond.isHasUnRegVoucher() ? 1 : 5;
        String table = "T_GL_ASSISTBALANCE";
        if (balType == 1) {
            table = table + "_1F";
        } else if (balType == 5) {
            table = table + "_5F";
        }
        StringBuffer tempField = new StringBuffer();
        tempField.append("  ( FCompanyID ,");
        tempField.append("FAccountID ,FAccountNumber , FAccountDC ,");
        tempField.append("FASSISTGRPID ,");
        tempField.append("FASSISTGRPTYPE ,");
        tempField.append("FOppCompanyID ,");
        tempField.append("FCurrencyID ,FPeriod ,");
        tempField.append("  FYearBeginBalanceFor , FYearBeginBalanceLocal ,  FYearBeginBalanceRpt ,");
        tempField.append("  FBeginBalanceFor , FBeginBalanceLocal , FBeginBalanceRpt , ");
        tempField.append("  FDebitFor , FDebitLocal , FDebitRpt , ");
        tempField.append("  FCreditFor ,  FCreditLocal , FCreditRpt ,");
        tempField.append("  FYearDebitFor , FYearDebitLocal , FYearDebitRpt ,");
        tempField.append("  FYearCreditFor , FYearCreditLocal , FYearCreditRpt ,");
        tempField.append("  FEndBalanceFor, FEndBalanceLocal , FEndBalanceRpt ");
        tempField.append(" ,FIsAfterCurrPeriod )  ");
        ArrayList<Object> sp = new ArrayList<Object>();
        str.append(" select t.FORGUNITID FCompanyID,  \r\n");
        str.append(" t.FACCOUNTID , t.FNUMBER FAccountNumber ,  t.FDC FAccountDC,  \r\n");
        str.append(" t.FASSISTGRPID, ");
        str.append(" case when t.fcompany is not null then 'companyOrg' when t.fcustomer is not null then 'customer' when t.fsuppler is not null then 'provider' end FASSISTGRPType,");
        str.append(" case when t.fcompany is not null then  t.fcompany  when t.fcustomer is not null then  t.fcustomer  when t.fsuppler is not null then  t.fsuppler  end foppCompanyID, \r\n");
        str.append(" t.FCURRENCYID, ");
        str.append(" t.FPERIOD, ");
        str.append(" (t.FENDBALANCEFOR + t.FYEARCREDITFOR - t.FYEARDEBITFOR) * t.FDC FYearBEGINBALANCEFOR, \r\n");
        str.append(" (t.FENDBALANCElocal + t.FYEARCREDITlocal - t.FYEARDEBITlocal) * t.FDC FYearBEGINBALANCElocal, \r\n");
        str.append(" (t.FENDBALANCERpt + t.FYEARCREDITRpt - t.FYEARDEBITRpt) * t.FDC FYearBEGINBALANCERpt, \r\n");
        if (this.cond.getPeriodNumberStart() == 1) {
            str.append("  (t.FENDBALANCEFOR + t.FYEARCREDITFOR - t.FYEARDEBITFOR) * t.FDC  FBEGINBALANCEFOR, \r\n");
            str.append("  (t.FENDBALANCElocal + t.FYEARCREDITlocal - t.FYEARDEBITlocal) * t.FDC FBEGINBALANCElocal ,\r\n");
            str.append("  (t.FENDBALANCErpt + t.FYEARCREDITrpt - t.FYEARDEBITrpt) * t.FDC FBEGINBALANCErpt , \r\n");
        } else {
            str.append("  t.FBEGINBALANCEFOR * t.FDC FBEGINBALANCEFOR, \r\n");
            str.append("  t.FBEGINBALANCElocal * t.FDC FBEGINBALANCElocal, \r\n");
            str.append("  t.FBEGINBALANCErpt * t.FDC FBEGINBALANCErpt, \r\n");
        }
        str.append(" t.FDEBITFOR,");
        str.append(" t.FDEBITLOCAL,");
        str.append(" t.FDEBITRPT,");
        str.append(" t.FCREDITFOR,");
        str.append(" t.FCREDITLOCAL,");
        str.append(" t.FCREDITRPT,");
        str.append(" t.FYEARDEBITFOR,");
        str.append(" t.FYEARDEBITLOCAL,");
        str.append(" t.FYEARDEBITRPT,");
        str.append(" t.FYEARCREDITFOR,");
        str.append(" t.FYEARCREDITLOCAL,");
        str.append(" t.FYEARCREDITRPT,");
        str.append(" t.FENDBALANCEFOR * t.FDC FENDBALANCEFOR,");
        str.append(" t.FENDBALANCELOCAL * t.FDC FENDBALANCELOCAL,");
        str.append(" t.FENDBALANCERPT * t.FDC FENDBALANCERPT");
        try {
            if (type == 0) {
                str.append(" ,CASE WHEN (t.fperiod > ").append(this.cond.getCurrPeriod().getNumber()).append(") THEN 1 ELSE 0 END FIsAfterCurrPeriod ");
            } else {
                str.append(" ,CASE WHEN (t.fperiod > ? ) THEN 1 ELSE 0 END FIsAfterCurrPeriod ");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        str.append(" from ( ");
        str.append(" select b.FORGUNITID,");
        str.append(" b.FACCOUNTID , av.FNUMBER , av.FDC,");
        str.append(" b.FASSISTGRPID,");
        str.append(" p.FID fcompany,");
        str.append(" c.FINTERNALCOMPANYID fcustomer,");
        str.append(" s.FINTERNALCOMPANYID fsuppler,");
        str.append(" b.FCURRENCYID,b.FPERIOD,");
        str.append(" isnull(b.FBEGINBALANCEFOR,0)  FBEGINBALANCEFOR, isnull( b.FBEGINBALANCELOCAL,0) FBEGINBALANCELOCAL, isnull( b.FBEGINBALANCERPT,0) FBEGINBALANCERPT, ");
        str.append(" isnull(b.FDEBITFOR,0) FDEBITFOR, isnull(b.FDEBITLOCAL,0) FDEBITLOCAL, isnull(b.FDEBITRPT,0) FDEBITRPT, ");
        str.append(" isnull(b.FCREDITFOR,0) FCREDITFOR, isnull(b.FCREDITLOCAL,0) FCREDITLOCAL, isnull(b.FCREDITRPT,0) FCREDITRPT,");
        str.append(" isnull(b.FYEARDEBITFOR,0) FYEARDEBITFOR, isnull(b.FYEARDEBITLOCAL,0) FYEARDEBITLOCAL, isnull(b.FYEARDEBITRPT,0) FYEARDEBITRPT, ");
        str.append(" isnull(b.FYEARCREDITFOR,0) FYEARCREDITFOR, isnull(b.FYEARCREDITLOCAL,0) FYEARCREDITLOCAL, isnull(b.FYEARCREDITRPT,0) FYEARCREDITRPT,");
        str.append(" isnull(b.FENDBALANCEFOR,0) FENDBALANCEFOR, isnull(b.FENDBALANCELOCAL,0) FENDBALANCELOCAL, isnull(b.FENDBALANCERPT,0) FENDBALANCERPT ");
        str.append("from ").append(table).append(" b");
        str.append(" inner join T_BD_ASSISTANTHG aa on b.FASSISTGRPID = aa.FID \r\n");
        str.append(" LEFT OUTER JOIN T_BD_AccountView av ON av.FID = b.FAccountID \r\n");
        str.append(" LEFT OUTER JOIN T_org_company p on aa.FCOMPANYORGID = p.FID \r\n");
        str.append(" LEFT OUTER JOIN T_bd_customer c on c.fid = aa.FCUSTOMERID \r\n");
        str.append(" LEFT OUTER JOIN T_BD_SUPPLIER s on aa.FPROVIDERID = s.fid \r\n");
        if (type == 0) {
            str.append(" where b.FOrgUnitID = '").append(this.cond.getCompanyId().toString()).append("' ");
        } else {
            str.append(" where b.FOrgUnitID in ( ? ) ");
        }
        if (type == 0) {
            try {
                str.append(" AND b.FPeriod IN  ").append(this.cond.getPeriodNumbersInSql(true));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            str.append(" AND b.FPeriod IN ## ");
        }
        str.append(" AND b.FCurrencyID in (").append(this.cond.getCurrencyIdStr()).append(") ");
        if (type == 0 && this.cond.getContrastType() == 1) {
            str.append(" AND av.fcompanyid IN ('").append(this.cond.getCompanyId().toString()).append("') ");
            str.append(" AND av.faccounttableid = '").append(this.cond.getCompany().getAccountTable().getId().toString()).append("' ");
            str.append(" AND av.FNUMBER in (").append(this.cond.getAccountStr()).append(") ");
        } else if (type == 1 && this.cond.getContrastType() == 1) {
            str.append(" AND av.fcompanyid IN ( ? ) ");
            str.append(" AND av.faccounttableid = ? ");
            str.append(" AND av.FNUMBER in (").append(this.cond.getOppAccountStr()).append(") ");
        } else if (type == 0 && this.cond.getContrastType() == 2) {
            str.append(" AND av.fcompanyid IN ('").append(this.cond.getCompanyId().toString()).append("') ");
            str.append(" AND av.faccounttableid = '").append(this.cond.getCompany().getAccountTable().getId().toString()).append("' ");
        } else if (type == 1 && this.cond.getContrastType() == 2) {
            str.append(" AND av.fcompanyid IN ( ? ) ");
            str.append(" AND av.faccounttableid = ? ");
        }
        if (type == 0) {
            str.append(" and ( c.FINTERNALCOMPANYID  in ( ").append(this.cond.getOppCompanyStr()).append(" ) ");
            str.append("    or p.FID in ( ").append(this.cond.getOppCompanyStr()).append(" ) ");
            str.append("    or s.FINTERNALCOMPANYID in ( ").append(this.cond.getOppCompanyStr()).append(" ) ");
        } else {
            str.append(" and ( c.FINTERNALCOMPANYID  in ( ? ) ");
            str.append("    or p.FID in ( ? ) ");
            str.append("    or s.FINTERNALCOMPANYID in ( ? ) ");
        }
        str.append(" ) )  T");
        if (type == 0) {
            try {
                DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + this.tempContrastTable + tempField.toString() + str.toString()));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            CompanyOrgUnitInfo[] oppCompanys = this.cond.getOppCompany();
            CompanyOrgUnitInfo ownCompany = this.cond.getCompany();
            for (int i = 0; i < oppCompanys.length; ++i) {
                if (oppCompanys[i].getId().toString().equals(ownCompany.getId().toString())) continue;
                GLInnerAcctContrastCondition conddd = new GLInnerAcctContrastCondition();
                conddd.setOppCompany(new CompanyOrgUnitInfo[]{ownCompany});
                conddd.setPeriodYearStart(this.cond.getPeriodYearStart());
                conddd.setPeriodNumberStart(this.cond.getPeriodNumberStart());
                conddd.setPeriodYearEnd(this.cond.getPeriodYearEnd());
                conddd.setPeriodNumberEnd(this.cond.getPeriodNumberEnd());
                conddd.setCompanyDisplayMode(this.cond.getCompanyDisplayMode());
                conddd.setCompany(oppCompanys[i]);
                conddd.setLeafAccount(this.cond.isLeafAccount());
                conddd.setContrastType(this.cond.getContrastType());
                int currentPeriod = period;
                try {
                    currentPeriod = conddd.getCurrPeriod().getNumber();
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                sp = new ArrayList();
                sp.add(new Integer(currentPeriod));
                sp.add(conddd.getCompany().getId().toString());
                sp.add(conddd.getCompany().getId().toString());
                if (conddd.getCompany().getAccountTable() == null) {
                    throw new BOSException(this.getLocaleStr("oppCompany") + "\uff1a" + conddd.getCompany().getName() + " " + this.getLocaleStr("noEnableAccountTable"));
                }
                sp.add(conddd.getCompany().getAccountTable().getId().toString());
                sp.add(conddd.getOppCompany()[0].getId().toString());
                sp.add(conddd.getOppCompany()[0].getId().toString());
                sp.add(conddd.getOppCompany()[0].getId().toString());
                try {
                    String str11 = str.toString();
                    str11 = str11.replace("##", conddd.getPeriodNumbersInSql(true));
                    String sql = GLRptSQLUtil.getSqlWithParameters(str11, sp.toArray());
                    DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + this.tempContrastTable + tempField.toString() + sql));
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                try {
                    if (!conddd.isAfterCurrPeriod()) continue;
                    this.isYearQuery = true;
                    this.insertFuturePeriodBalance(1, conddd);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void insertOppCompanyFuturePeriodBalance(GLRptBaseCondition condition) {
    }

    protected void insertContrastDetailDataNew() throws EASBizException, BOSException {
        int period = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        String sql = "select (select count(1) from  " + this.tempContrastTable + " where fcompanyid='" + this.cond.getCompany().getId().toString() + "' and fperiod = " + period + "  and faccountid is not null ) ownCount ,(select count(1) from " + this.tempContrastTable + " where fcompanyid='" + this.cond.getOppCompany()[0].getId().toString() + "' and fperiod = " + period + "  and faccountid is not null  ) oppCount";
        IRowSet rs = DbUtil.executeQuery((Context)this.cond.getCtx(), (String)sql.toString());
        boolean isOwnCountMore = true;
        try {
            while (rs.next()) {
                int ownCount = rs.getInt("ownCount");
                int oppCount = rs.getInt("oppCount");
                if (oppCount <= ownCount) continue;
                isOwnCountMore = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuffer str = new StringBuffer();
        str.append(" select fcompanyid ,foppcompanyid ,faccountid,foppaccountid, fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,  ");
        if (this.cond.getContrastDataType() == 1) {
            str.append(" FYearBEGINBALANCEFOR , FoppYearBEGINBALANCEFOR, FYearBEGINBALANCEDiffFOR,FYearBEGINBALANCELocal, FoppYearBEGINBALANCELocal,FYearBEGINBALANCEDiffLocal");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(",FYearBEGINBALANCERpt, FoppYearBEGINBALANCERpt,FYearBEGINBALANCEDiffRpt ");
            }
            str.append(" from ( ");
            str.append(" select fcompanyid ,foppcompanyid ,");
            str.append(" faccountid,foppaccountid, ");
            str.append(" 0 fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,");
            str.append(" FYearBEGINBALANCEFOR , FoppYearBEGINBALANCEFOR, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FYearBEGINBALANCEFOR + FoppYearBEGINBALANCEFOR else FYearBEGINBALANCEFOR - FoppYearBEGINBALANCEFOR end FYearBEGINBALANCEDiffFOR, ");
            str.append(" FYearBEGINBALANCELocal, FoppYearBEGINBALANCELocal, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FYearBEGINBALANCELocal + FoppYearBEGINBALANCELocal else FYearBEGINBALANCELocal - FoppYearBEGINBALANCELocal end FYearBEGINBALANCEDiffLocal ");
            str.append(" ,FYearBEGINBALANCERpt, FoppYearBEGINBALANCERpt, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FYearBEGINBALANCERpt + FoppYearBEGINBALANCERpt else FYearBEGINBALANCERpt - FoppYearBEGINBALANCERpt end FYearBEGINBALANCEDiffRpt ");
        } else if (this.cond.getContrastDataType() == 2) {
            str.append(" FBEGINBALANCEFOR , FoppBEGINBALANCEFOR,FBEGINBALANCEDiffFOR,FBEGINBALANCELocal, FoppBEGINBALANCELocal,FBEGINBALANCEDiffLocal");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,FBEGINBALANCERpt, FoppBEGINBALANCERpt,FBEGINBALANCEDiffRpt ");
            }
            str.append(" from ( ");
            str.append(" select fcompanyid ,foppcompanyid ,");
            str.append(" faccountid,foppaccountid, ");
            str.append(" 0 fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,");
            str.append(" FBEGINBALANCEFOR , FoppBEGINBALANCEFOR, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FBEGINBALANCEFOR + FoppBEGINBALANCEFOR else FBEGINBALANCEFOR - FoppBEGINBALANCEFOR end FBEGINBALANCEDiffFOR, ");
            str.append(" FBEGINBALANCELocal, FoppBEGINBALANCELocal, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FBEGINBALANCELocal + FoppBEGINBALANCELocal else FBEGINBALANCELocal - FoppBEGINBALANCELocal end FBEGINBALANCEDiffLocal ");
            str.append(" ,FBEGINBALANCERpt, FoppBEGINBALANCERpt, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FBEGINBALANCERpt + FoppBEGINBALANCERpt else FBEGINBALANCERpt - FoppBEGINBALANCERpt end FBEGINBALANCEDiffRpt ");
        } else {
            str.append(" FEndBALANCEFOR , FoppEndBALANCEFOR, FEndBALANCEDiffFOR,FEndBALANCELocal, FoppEndBALANCELocal,FEndBALANCEDiffLocal");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,FEndBALANCERpt, FoppEndBALANCERpt,FEndBALANCEDiffRpt ");
            }
            str.append(" from ( ");
            str.append(" select fcompanyid ,foppcompanyid ,");
            str.append(" faccountid,foppaccountid, ");
            str.append(" 0 fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,");
            str.append(" FEndBALANCEFOR , FoppEndBALANCEFOR, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FEndBALANCEFOR + FoppEndBALANCEFOR else FEndBALANCEFOR - FoppEndBALANCEFOR end FEndBALANCEDiffFOR, ");
            str.append(" FEndBALANCELocal, FoppEndBALANCELocal, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FEndBALANCELocal + FoppEndBALANCELocal else FEndBALANCELocal - FoppEndBALANCELocal end FEndBALANCEDiffLocal ");
            str.append(" ,FEndBALANCERpt, FoppEndBALANCERpt, ");
            str.append(" case when t.faccountdc = t.foppaccountdc then FEndBALANCERpt + FoppEndBALANCERpt else FEndBALANCERpt - FoppEndBALANCERpt end FEndBALANCEDiffRpt ");
        }
        str.append(" from  ( ");
        str.append(" select t1.fcompanyid, ");
        str.append(" t1.faccountid, t1.faccountnumber, t1.faccountdc, t1.fassistgrpid, t1.fassistgrpType , ");
        str.append(" isnull( t2.fcompanyid ,'" + this.cond.getOppCompany()[0].getId().toString() + "' ) foppcompanyid, t2.faccountid foppaccountid, t2.faccountnumber foppaccountnumber, t2.faccountdc foppaccountdc, t2.fassistgrpid foppassistgrpid, t2.fassistgrptype foppassistgrptype, ");
        str.append(" t1.fcurrencyid, ");
        if (this.cond.getContrastDataType() == 1) {
            str.append(" isnull(t1.FYearBEGINBALANCEFOR,0) FYearBEGINBALANCEFOR, ");
            str.append(" isnull(t2.FYearBEGINBALANCEFOR,0) FoppYearBEGINBALANCEFOR, ");
            str.append(" isnull(t1.FYearBEGINBALANCELocal,0) FYearBEGINBALANCELocal, ");
            str.append(" isnull(t2.FYearBEGINBALANCELocal,0) FoppYearBEGINBALANCELocal, ");
            str.append(" isnull(t1.FYearBEGINBALANCERpt,0) FYearBEGINBALANCERpt, ");
            str.append(" isnull(t2.FYearBEGINBALANCERpt,0) FoppYearBEGINBALANCERpt ");
        } else if (this.cond.getContrastDataType() == 2) {
            str.append(" isnull(t1.FBEGINBALANCEFOR,0) FBEGINBALANCEFOR, ");
            str.append(" isnull(t2.FBEGINBALANCEFOR,0) FoppBEGINBALANCEFOR, ");
            str.append(" isnull(t1.FBEGINBALANCELocal,0) FBEGINBALANCELocal, ");
            str.append(" isnull(t2.FBEGINBALANCELocal,0) FoppBEGINBALANCELocal, ");
            str.append(" isnull(t1.FBEGINBALANCERpt,0) FBEGINBALANCERpt, ");
            str.append(" isnull(t2.FBEGINBALANCERpt,0) FoppBEGINBALANCERpt ");
        } else {
            str.append(" isnull(t1.FEndBALANCEFOR,0) FEndBALANCEFOR, ");
            str.append(" isnull(t2.FEndBALANCEFOR,0) FoppEndBALANCEFOR, ");
            str.append(" isnull(t1.FEndBALANCELocal,0) FEndBALANCELocal, ");
            str.append(" isnull(t2.FEndBALANCELocal,0) FoppEndBALANCELocal, ");
            str.append(" isnull(t1.FEndBALANCERpt,0) FEndBALANCERpt, ");
            str.append(" isnull(t2.FEndBALANCERpt,0) FoppEndBALANCERpt ");
        }
        str.append(" from (");
        str.append(" select p.faccountnumber tpnumber,p.foppaccountnumber tpoppnumber, ");
        str.append(" case  when b1.fcompanyid is null then '").append(this.cond.getCompany().getId().toString()).append("' else b1.fcompanyid end fcompanyid, ");
        str.append(" case  when b1.faccountid is null then av.fid else b1.faccountid end faccountid,");
        str.append(" case  when b1.faccountnumber is null then p.faccountnumber else b1.faccountnumber end faccountnumber,");
        str.append(" case  when b1.faccountdc is null then av.fdc else b1.faccountdc end faccountdc,");
        str.append(" case  when b1.foppcompanyid is null then '").append(this.cond.getOppCompany()[0].getId().toString()).append("' else b1.foppcompanyid end foppcompanyid, ");
        str.append(" case  when b1.fassistgrpid is null then '' else b1.fassistgrpid end fassistgrpid,");
        str.append(" case  when b1.fassistgrpType is null then '' else b1.fassistgrpType end fassistgrpType,");
        str.append(" case  when b1.fcurrencyid is null then p.fcurrencyid else b1.fcurrencyid end fcurrencyid,");
        str.append(" case  when b1.fperiod is null then ").append(period).append(" else b1.fperiod end fperiod,");
        if (this.cond.getContrastDataType() == 1) {
            str.append(" isnull(b1.FYearBEGINBALANCEFOR,0) FYearBEGINBALANCEFOR, ");
            str.append(" isnull(b1.FYearBEGINBALANCELocal,0) FYearBEGINBALANCELocal, ");
            str.append(" isnull(b1.FYearBEGINBALANCERpt,0) FYearBEGINBALANCERpt ");
        } else if (this.cond.getContrastDataType() == 2) {
            str.append(" isnull(b1.FBEGINBALANCEFOR,0) FBEGINBALANCEFOR, ");
            str.append(" isnull(b1.FBEGINBALANCELocal,0) FBEGINBALANCELocal, ");
            str.append(" isnull(b1.FBEGINBALANCERpt,0) FBEGINBALANCERpt ");
        } else {
            str.append(" isnull(b1.FEndBALANCEFOR,0) FEndBALANCEFOR, ");
            str.append(" isnull(b1.FEndBALANCELocal,0) FEndBALANCELocal, ");
            str.append(" isnull(b1.FEndBALANCERpt,0) FEndBALANCERpt ");
        }
        str.append(" from ").append(this.tempAccountTable).append(" p LEFT OUTER JOIN ").append(this.tempContrastTable).append(" b1 on p.faccountnumber = b1.faccountnumber  and p.fcurrencyid = b1.fcurrencyid");
        str.append(" left outer join t_bd_accountview av on p.faccountnumber = av.fnumber and av.fcompanyid = '").append(this.cond.getCompany().getId().toString()).append("' ");
        str.append(" and av.faccounttableid = '").append(this.cond.getCompany().getAccountTable().getId().toString()).append("' ");
        str.append(" where ( b1.fcompanyid =  '").append(this.cond.getCompany().getId().toString()).append("' or b1.fcompanyid is null) ) t1 ");
        if (isOwnCountMore) {
            str.append(" left outer join (");
        } else {
            str.append(" RIGHT OUTER JOIN (");
        }
        str.append(" select pp.faccountnumber tpnumber,pp.foppaccountnumber tpoppnumber, ");
        str.append(" case  when b2.fcompanyid is null then '").append(this.cond.getOppCompany()[0].getId().toString()).append("' else b2.fcompanyid end fcompanyid, ");
        str.append(" case  when b2.faccountid is null then avv.fid else b2.faccountid end faccountid,");
        str.append(" case  when b2.faccountnumber is null then pp.foppaccountnumber else b2.faccountnumber end faccountnumber,");
        str.append(" case  when b2.faccountdc is null then avv.fdc else b2.faccountdc end faccountdc,");
        str.append(" case  when b2.foppcompanyid is null then '").append(this.cond.getCompany().getId().toString()).append("' else b2.foppcompanyid end foppcompanyid, ");
        str.append(" case  when b2.fassistgrpid is null then '' else b2.fassistgrpid end fassistgrpid,");
        str.append(" case  when b2.fassistgrpType is null then '' else b2.fassistgrpType end fassistgrpType,");
        str.append(" case  when b2.fcurrencyid is null then pp.fcurrencyid else b2.fcurrencyid end fcurrencyid,");
        str.append(" case  when b2.fperiod is null then ").append(period).append(" else b2.fperiod end fperiod,");
        if (this.cond.getContrastDataType() == 1) {
            str.append(" isnull(b2.FYearBEGINBALANCEFOR,0) FYearBEGINBALANCEFOR, ");
            str.append(" isnull(b2.FYearBEGINBALANCELocal,0) FYearBEGINBALANCELocal, ");
            str.append(" isnull(b2.FYearBEGINBALANCERpt,0) FYearBEGINBALANCERpt ");
        } else if (this.cond.getContrastDataType() == 2) {
            str.append(" isnull(b2.FBEGINBALANCEFOR,0) FBEGINBALANCEFOR, ");
            str.append(" isnull(b2.FBEGINBALANCELocal,0) FBEGINBALANCELocal, ");
            str.append(" isnull(b2.FBEGINBALANCERpt,0) FBEGINBALANCERpt ");
        } else {
            str.append(" isnull(b2.FEndBALANCEFOR,0) FEndBALANCEFOR, ");
            str.append(" isnull(b2.FEndBALANCELocal,0) FEndBALANCELocal, ");
            str.append(" isnull(b2.FEndBALANCERpt,0) FEndBALANCERpt ");
        }
        str.append(" from ").append(this.tempAccountTable).append(" pp LEFT OUTER JOIN ").append(this.tempContrastTable).append(" b2 on pp.foppaccountnumber = b2.faccountnumber  and pp.fcurrencyid = b2.fcurrencyid");
        str.append(" left outer join t_bd_accountview avv on pp.foppaccountnumber = avv.fnumber and avv.fcompanyid = '").append(this.cond.getOppCompany()[0].getId().toString()).append("' ");
        str.append(" and avv.faccounttableid = '").append(this.cond.getOppCompany()[0].getAccountTable().getId().toString()).append("' ");
        str.append(" where ( b2.fcompanyid =  '").append(this.cond.getOppCompany()[0].getId().toString()).append("'  or b2.fcompanyid is null) ) t2 ");
        str.append(" on t1.fcompanyid = t2.foppcompanyid and t1.foppcompanyid = t2.fcompanyid and t1.fcurrencyid = t2.fcurrencyid ");
        str.append(" and t1.tpnumber = t2.tpnumber and t1.tpoppnumber = t2.tpoppnumber ");
        str.append(" where t1.fcompanyid = '").append(this.cond.getCompany().getId().toString()).append("' ");
        str.append(" and t1.foppcompanyid in ( ").append(this.cond.getOppCompanyStr()).append(" )");
        str.append(" and t1.fperiod = ").append(period);
        str.append(" and  ( t2.fperiod = ").append(period).append(" or t2.fperiod is null) ");
        str.append(" ) T ");
        str.append(" ) P ");
        if (this.cond.getStatus() == 1) {
            str.append(" where ");
            if (this.cond.getContrastDataType() == 1) {
                str.append(" FYearBEGINBALANCEDiffFOR = 0 and FYearBEGINBALANCEDiffLocal = 0 and FYearBEGINBALANCEDiffRpt = 0 ");
            } else if (this.cond.getContrastDataType() == 2) {
                str.append(" FBEGINBALANCEDiffFOR = 0 and FBEGINBALANCEDiffLocal = 0 and FBEGINBALANCEDiffRpt = 0 ");
            } else {
                str.append(" FEndBALANCEDiffFOR = 0 and FEndBALANCEDiffLocal = 0 and FEndBALANCEDiffRpt = 0 ");
            }
        } else if (this.cond.getStatus() == 2) {
            str.append(" where ");
            if (this.cond.getContrastDataType() == 1) {
                str.append(" FYearBEGINBALANCEDiffFOR <> 0 or FYearBEGINBALANCEDiffLocal <> 0 or FYearBEGINBALANCEDiffRpt <> 0 ");
            } else if (this.cond.getContrastDataType() == 2) {
                str.append(" FBEGINBALANCEDiffFOR <> 0 or FBEGINBALANCEDiffLocal <> 0 or FBEGINBALANCEDiffRpt <> 0 ");
            } else {
                str.append(" FEndBALANCEDiffFOR <> 0 or FEndBALANCEDiffLocal <> 0 or FEndBALANCEDiffRpt <> 0 ");
            }
        }
        this.insertData(str.toString());
    }

    protected void insertContrastDetailData() throws EASBizException, BOSException {
        String sql = "select (select count(1) from  " + this.tempContrastTable + " ) ownCount ,(select count(1) from  " + this.tempAccountTable + " ) oppCount";
        IRowSet rs = DbUtil.executeQuery((Context)this.cond.getCtx(), (String)sql.toString());
        boolean isOwnCountMore = true;
        try {
            while (rs.next()) {
                int ownCount = rs.getInt("ownCount");
                int oppCount = rs.getInt("oppCount");
                if (oppCount <= ownCount) continue;
                isOwnCountMore = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int period = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        StringBuffer str = new StringBuffer();
        str.append(" select fcompanyid ,foppcompanyid ,faccountid,foppaccountid, fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,  ");
        if (this.cond.getContrastDataType() == 1) {
            str.append(" FYearBEGINBALANCEFOR , FoppYearBEGINBALANCEFOR, FYearBEGINBALANCEDiffFOR,FYearBEGINBALANCELocal, FoppYearBEGINBALANCELocal,FYearBEGINBALANCEDiffLocal");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(",FYearBEGINBALANCERpt, FoppYearBEGINBALANCERpt,FYearBEGINBALANCEDiffRpt ");
            }
            str.append(" from ( ");
            str.append(" select fcompanyid ,foppcompanyid ,");
            str.append(" faccountid,foppaccountid, ");
            str.append(" 0 fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,");
            str.append(" FYearBEGINBALANCEFOR , FoppYearBEGINBALANCEFOR, ");
            str.append(" FYearBEGINBALANCEFOR - FoppYearBEGINBALANCEFOR FYearBEGINBALANCEDiffFOR, ");
            str.append(" FYearBEGINBALANCELocal, FoppYearBEGINBALANCELocal, ");
            str.append(" FYearBEGINBALANCELocal - FoppYearBEGINBALANCELocal FYearBEGINBALANCEDiffLocal ");
            str.append(" ,FYearBEGINBALANCERpt, FoppYearBEGINBALANCERpt, ");
            str.append(" FYearBEGINBALANCERpt - FoppYearBEGINBALANCERpt FYearBEGINBALANCEDiffRpt ");
        } else if (this.cond.getContrastDataType() == 2) {
            str.append(" FBEGINBALANCEFOR , FoppBEGINBALANCEFOR,FBEGINBALANCEDiffFOR,FBEGINBALANCELocal, FoppBEGINBALANCELocal,FBEGINBALANCEDiffLocal");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,FBEGINBALANCERpt, FoppBEGINBALANCERpt,FBEGINBALANCEDiffRpt ");
            }
            str.append(" from ( ");
            str.append(" select fcompanyid ,foppcompanyid ,");
            str.append(" faccountid,foppaccountid, ");
            str.append(" 0 fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,");
            str.append(" FBEGINBALANCEFOR , FoppBEGINBALANCEFOR, ");
            str.append(" FBEGINBALANCEFOR - FoppBEGINBALANCEFOR FBEGINBALANCEDiffFOR, ");
            str.append(" FBEGINBALANCELocal, FoppBEGINBALANCELocal, ");
            str.append(" FBEGINBALANCELocal - FoppBEGINBALANCELocal FBEGINBALANCEDiffLocal ");
            str.append(" ,FBEGINBALANCERpt, FoppBEGINBALANCERpt, ");
            str.append(" FBEGINBALANCERpt - FoppBEGINBALANCERpt FBEGINBALANCEDiffRpt ");
        } else {
            str.append(" FEndBALANCEFOR , FoppEndBALANCEFOR, FEndBALANCEDiffFOR,FEndBALANCELocal, FoppEndBALANCELocal,FEndBALANCEDiffLocal");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,FEndBALANCERpt, FoppEndBALANCERpt,FEndBALANCEDiffRpt ");
            }
            str.append(" from ( ");
            str.append(" select fcompanyid ,foppcompanyid ,");
            str.append(" faccountid,foppaccountid, ");
            str.append(" 0 fisaccounttotal , fassistgrpType , foppassistgrpType, fcurrencyid,");
            str.append(" FEndBALANCEFOR , FoppEndBALANCEFOR, ");
            str.append(" FEndBALANCEFOR - FoppEndBALANCEFOR FEndBALANCEDiffFOR, ");
            str.append(" FEndBALANCELocal, FoppEndBALANCELocal, ");
            str.append(" FEndBALANCELocal - FoppEndBALANCELocal FEndBALANCEDiffLocal ");
            str.append(" ,FEndBALANCERpt, FoppEndBALANCERpt, ");
            str.append(" FEndBALANCERpt - FoppEndBALANCERpt FEndBALANCEDiffRpt ");
        }
        str.append(" from  ( ");
        str.append(" select t1.fcompanyid, ");
        str.append(" t1.faccountid, t1.faccountnumber, t1.faccountdc, t1.fassistgrpid, t1.fassistgrpType , ");
        str.append(" t2.fcompanyid foppcompanyid, t2.faccountid foppaccountid, t2.faccountnumber foppaccountnumber, t2.faccountdc foppaccountdc, t2.fassistgrpid foppassistgrpid, t2.fassistgrptype foppassistgrptype, ");
        str.append(" t1.fcurrencyid, ");
        if (this.cond.getContrastDataType() == 1) {
            str.append(" isnull(t1.FYearBEGINBALANCEFOR,0) FYearBEGINBALANCEFOR, ");
            str.append(" isnull(t2.FYearBEGINBALANCEFOR,0) FoppYearBEGINBALANCEFOR, ");
            str.append(" isnull(t1.FYearBEGINBALANCELocal,0) FYearBEGINBALANCELocal, ");
            str.append(" isnull(t2.FYearBEGINBALANCELocal,0) FoppYearBEGINBALANCELocal, ");
            str.append(" isnull(t1.FYearBEGINBALANCERpt,0) FYearBEGINBALANCERpt, ");
            str.append(" isnull(t2.FYearBEGINBALANCERpt,0) FoppYearBEGINBALANCERpt ");
        } else if (this.cond.getContrastDataType() == 2) {
            str.append(" isnull(t1.FBEGINBALANCEFOR,0) FBEGINBALANCEFOR, ");
            str.append(" isnull(t2.FBEGINBALANCEFOR,0) FoppBEGINBALANCEFOR, ");
            str.append(" isnull(t1.FBEGINBALANCELocal,0) FBEGINBALANCELocal, ");
            str.append(" isnull(t2.FBEGINBALANCELocal,0) FoppBEGINBALANCELocal, ");
            str.append(" isnull(t1.FBEGINBALANCERpt,0) FBEGINBALANCERpt, ");
            str.append(" isnull(t2.FBEGINBALANCERpt,0) FoppBEGINBALANCERpt ");
        } else {
            str.append(" isnull(t1.FEndBALANCEFOR,0) FEndBALANCEFOR, ");
            str.append(" isnull(t2.FEndBALANCEFOR,0) FoppEndBALANCEFOR, ");
            str.append(" isnull(t1.FEndBALANCELocal,0) FEndBALANCELocal, ");
            str.append(" isnull(t2.FEndBALANCELocal,0) FoppEndBALANCELocal, ");
            str.append(" isnull(t1.FEndBALANCERpt,0) FEndBALANCERpt, ");
            str.append(" isnull(t2.FEndBALANCERpt,0) FoppEndBALANCERpt ");
        }
        str.append(" from ").append(this.tempContrastTable).append(" t1 ");
        if (isOwnCountMore) {
            str.append(" left outer join ");
        } else {
            str.append(" RIGHT OUTER JOIN ");
        }
        str.append(this.tempAccountTable).append(" t2 ");
        str.append(" on t2.fid = t1.fid and t1.fcompanyid = t2.foppcompanyid and t1.foppcompanyid = t2.fcompanyid and t1.fcurrencyid = t2.fcurrencyid ");
        str.append(" where t1.fcompanyid = '").append(this.cond.getCompany().getId().toString()).append("' ");
        str.append(" and t1.foppcompanyid in ( ").append(this.cond.getOppCompanyStr()).append(" )");
        str.append(" and t1.fperiod = ").append(period);
        str.append(" and t2.fperiod = ").append(period);
        if (isOwnCountMore) {
            str.append("  order by t1.fid ");
        } else {
            str.append("  order by t2.fid ");
        }
        str.append(" ) T ");
        str.append(" ) P ");
        if (this.cond.getStatus() == 1) {
            str.append(" where ");
            if (this.cond.getContrastDataType() == 1) {
                str.append(" FYearBEGINBALANCEDiffFOR = 0 and FYearBEGINBALANCEDiffLocal = 0 and FYearBEGINBALANCEDiffRpt = 0 ");
            } else if (this.cond.getContrastDataType() == 2) {
                str.append(" FBEGINBALANCEDiffFOR = 0 and FBEGINBALANCEDiffLocal = 0 and FBEGINBALANCEDiffRpt = 0 ");
            } else {
                str.append(" FEndBALANCEDiffFOR = 0 and FEndBALANCEDiffLocal = 0 and FEndBALANCEDiffRpt = 0 ");
            }
        } else if (this.cond.getStatus() == 2) {
            str.append(" where ");
            if (this.cond.getContrastDataType() == 1) {
                str.append(" FYearBEGINBALANCEDiffFOR <> 0 or FYearBEGINBALANCEDiffLocal <> 0 or FYearBEGINBALANCEDiffRpt <> 0 ");
            } else if (this.cond.getContrastDataType() == 2) {
                str.append(" FBEGINBALANCEDiffFOR <> 0 or FBEGINBALANCEDiffLocal <> 0 or FBEGINBALANCEDiffRpt <> 0 ");
            } else {
                str.append(" FEndBALANCEDiffFOR <> 0 or FEndBALANCEDiffLocal <> 0 or FEndBALANCEDiffRpt <> 0 ");
            }
        }
        this.insertData(str.toString());
    }

    protected void insertSumtotalData() throws EASBizException, BOSException {
        StringBuffer str = new StringBuffer();
        str.append(" select ");
        str.append("  '' fcompanyid, ");
        str.append("  '" + this.getLocaleStr("subTotal") + "' FOppOrgUnitID, ");
        str.append(" '' faccountid, ");
        str.append(" '' foppaccountid, ");
        str.append("  1 fisaccounttotal , ");
        str.append("  '' fassistgrpType , ");
        str.append("  '' foppassistgrpType , ");
        str.append(" '' fcurrencyid, ");
        if (this.cond.getContrastDataType() == 1) {
            if (this.cond.getCurrencyList().length > 1) {
                str.append(" to_decimal(null) FYearBEGINBALANCEFOR,");
                str.append(" to_decimal(null) FoppYearBEGINBALANCEFOR,");
                str.append(" to_decimal(null) FYearBEGINBALANCEDiffFOR,");
            } else {
                str.append(" sum(FYearBEGINBALANCEFOR) FYearBEGINBALANCEFOR,");
                str.append(" sum(FoppYearBEGINBALANCEFOR) FoppYearBEGINBALANCEFOR,");
                str.append(" sum(FYearBEGINBALANCEDiffFOR) FYearBEGINBALANCEDiffFOR,");
            }
            str.append(" sum(FYearBEGINBALANCELocal) FYearBEGINBALANCELocal, ");
            str.append(" sum(FoppYearBEGINBALANCELocal)  FoppYearBEGINBALANCELocal, ");
            str.append(" sum(FYearBEGINBALANCEDiffLocal)  FYearBEGINBALANCEDiffLocal ");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,sum(FYearBEGINBALANCERpt) FYearBEGINBALANCERpt, ");
                str.append(" sum(FoppYearBEGINBALANCERpt)  FoppYearBEGINBALANCERpt, ");
                str.append(" sum(FYearBEGINBALANCEDiffRpt)   FYearBEGINBALANCEDiffRpt ");
            }
        } else if (this.cond.getContrastDataType() == 2) {
            if (this.cond.getCurrencyList().length > 1) {
                str.append(" to_decimal(null) FBEGINBALANCEFOR,");
                str.append(" to_decimal(null) FoppBEGINBALANCEFOR,");
                str.append(" to_decimal(null) FBEGINBALANCEDiffFOR,");
            } else {
                str.append(" sum(FBEGINBALANCEFOR) FBEGINBALANCEFOR,");
                str.append(" sum(FoppBEGINBALANCEFOR) FoppBEGINBALANCEFOR,");
                str.append(" sum(FBEGINBALANCEDiffFOR) FBEGINBALANCEDiffFOR,");
            }
            str.append(" sum(FBEGINBALANCELocal) FBEGINBALANCELocal, ");
            str.append(" sum(FoppBEGINBALANCELocal)  FoppBEGINBALANCELocal, ");
            str.append(" sum(FBEGINBALANCEDiffLocal)  FBEGINBALANCEDiffLocal ");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,sum(FBEGINBALANCERpt) FBEGINBALANCERpt, ");
                str.append(" sum(FoppBEGINBALANCERpt)  FoppBEGINBALANCERpt, ");
                str.append(" sum(FBEGINBALANCEDiffRpt)   FBEGINBALANCEDiffRpt ");
            }
        } else {
            if (this.cond.getCurrencyList().length > 1) {
                str.append(" to_decimal(null) FEndBALANCEFOR,");
                str.append(" to_decimal(null) FoppEndBALANCEFOR,");
                str.append(" to_decimal(null) FEndBALANCEDiffFOR,");
            } else {
                str.append(" sum(FEndBALANCEFOR) FEndBALANCEFOR,");
                str.append(" sum(FoppEndBALANCEFOR) FoppEndBALANCEFOR,");
                str.append(" sum(FEndBALANCEDiffFOR) FEndBALANCEDiffFOR,");
            }
            str.append(" sum(FEndBALANCELocal) FEndBALANCELocal, ");
            str.append(" sum(FoppEndBALANCELocal)  FoppEndBALANCELocal, ");
            str.append(" sum(FEndBALANCEDiffLocal)  FEndBALANCEDiffLocal ");
            if (this.cond.getRptParams().isUseReportCurrency()) {
                str.append(" ,sum(FEndBALANCERpt) FEndBALANCERpt, ");
                str.append(" sum(FoppEndBALANCERpt)  FoppEndBALANCERpt, ");
                str.append(" sum(FEndBALANCEDiffRpt)   FEndBALANCEDiffRpt ");
            }
        }
        str.append(" from ").append(this.getDataSourceTableName());
        str.append(" group by FOppOrgUnitID ");
        this.insertData(str.toString());
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws SQLException, BOSException, EASBizException {
        super.toGLRptRowData(rs, rowData);
        String strAccountNumber = rs.getString("accountNumber") == null ? "" : rs.getString("accountNumber");
        String strAccountName = rs.getString("accountName") == null ? "" : rs.getString("accountName");
        rowData.updateObject("accountName", strAccountNumber + "  " + strAccountName);
        String stroppAccountNumber = rs.getString("oppAccountNumber") == null ? "" : rs.getString("oppAccountNumber");
        String stroppAccountName = rs.getString("oppAccountName") == null ? "" : rs.getString("oppAccountName");
        rowData.updateObject("oppAccountName", stroppAccountNumber + "  " + stroppAccountName);
        int isTotal = rs.getInt("FisAccountTotal");
        if (isTotal == 1) {
            rowData.updateObject("oppCompanyName", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"subtotal", (Locale)this.getContex().getLocale()));
            rowData.updateObject("accountName", "");
            rowData.updateObject("oppAccountName", "");
        }
    }

    public BigDecimal getBalanceForDC(BigDecimal balance, boolean isParmBalanceDirSamAsAccount, int accountDC) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
    }

    @Override
    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        super.updateField(rs, rowData, colName, value);
        if (value != null && GLRptField.period.getName().equalsIgnoreCase(colName)) {
            int period = Integer.parseInt(value.toString());
            rowData.updateObject(colName, period / 100 + "." + period % 100);
        } else if (GLRptField.accountDC.getName().equalsIgnoreCase(colName) && this.cond.getRptParams().isBalanceDirSamAsAccount() && value != null) {
            int dc = Integer.parseInt(value.toString());
            rowData.updateObject(colName, BalanceDirectionEnum.getEnum((int)dc));
        }
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field.getName().equals("oppCompanyName")) {
            colTitles.add("opp_company");
        } else if (field.getName().equals("companyName")) {
            colTitles.add("own_company");
        } else if (field.getName().equals("accountName")) {
            colTitles.add("own_account");
        } else if (field.getName().equals("oppAccountName")) {
            colTitles.add("opp_account");
        } else {
            super.setRow1Title(colTitles, field);
        }
    }

    @Override
    protected String[] getTitleRow2() throws EASBizException, BOSException {
        return super.getTitleRow2();
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.getName().equals("oppCompanyName")) {
            colTitles.add("opp_company");
        } else if (field.getName().equals("companyName")) {
            colTitles.add("own_company");
        } else if (field.getName().equals("accountName")) {
            colTitles.add("own_account");
        } else if (field.getName().equals("oppAccountName")) {
            colTitles.add("opp_account");
        } else if (field.getName().indexOf("Diff") > 0) {
            colTitles.add("detail_diff");
        } else if (field.getName().endsWith("For")) {
            if (field.getName().indexOf("Opp") > 0) {
                colTitles.add("opp_company_for");
            } else {
                colTitles.add("own_company_for");
            }
        } else if (field.getName().endsWith("Local")) {
            if (field.getName().indexOf("Opp") > 0) {
                colTitles.add("opp_company_local");
            } else {
                colTitles.add("own_company_local");
            }
        } else if (field.getName().endsWith("Rpt")) {
            if (field.getName().indexOf("Opp") > 0) {
                colTitles.add("opp_company_rpt");
            } else {
                colTitles.add("own_company_rpt");
            }
        } else {
            super.setRow2Title(colTitles, field);
        }
    }

    @Override
    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        return super.initTableHeadInfo();
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = new String[][]{this.getTitleRow1(), this.getTitleRow2()};
        return titles;
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    protected void insertSecondTempContrastData() {
    }

    @Override
    protected GLRptField getFreezeField() {
        return null;
    }
}

