/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQueryHelper;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;

public class GLRptAccountBalPageQuery
extends GLRptPageQuery {
    private boolean isDisplayAsstDetail = false;
    private boolean isIncludeBWAccount = false;
    private boolean isCreateDataTempTable = false;
    private GLRptAccountBalQueryHelper helper;
    private String locale = "_L2";

    public GLRptAccountBalPageQuery(Context ctx, GLRptAccountBalanceCondition cond, boolean isCreateDataTempTable, GLRptAccountBalQueryHelper helper) throws EASBizException, BOSException {
        super(ctx, cond);
        this.locale = "_" + ctx.getLocale().getLanguage();
        this.isDisplayAsstDetail = cond.getDisplayAsstDetail();
        this.isIncludeBWAccount = cond.getIncludeBWAccount();
        this.isCreateDataTempTable = isCreateDataTempTable;
        this.helper = helper;
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String alias = this.getMainTable().getAlias();
        if (!this.isCreateDataTempTable) {
            alias = "b";
            sql.append("b.sqlseq");
        } else {
            sql.append(alias).append(".").append("KSQL_SEQ");
            if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
                sql.append(",").append(alias).append(".").append("SQL_BATCH");
            }
        }
        GLRptSelector selector = this.getSelector();
        Iterator<GLRptField> it = selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field == GLRptField.orgUnitName) continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if (field == GLRptField.accountID || field == GLRptField.currencyID || field == GLRptField.HG || field == GLRptField.orgUnitID) {
                sql.append(this.getMainTable().getAlias()).append(".").append(field.getName()).append(" ").append(field.getName());
                continue;
            }
            if (field == GLRptField.accountNumber || field == GLRptField.accountNumberMerger) {
                if (this.isQueryAccountNumber()) {
                    sql.append("av.fnumber");
                } else {
                    sql.append("t.accountNumber");
                }
                sql.append(" ").append(field.getName());
                continue;
            }
            if (field == GLRptField.accountName || field == GLRptField.accountNameMerger || field == GLRptField.accountDisplayName || field == GLRptField.accountDisplayNameMerger) {
                if (CompanyDisplayModeEnum.merger == this.getCond().getCompanyDisplayMode()) {
                    sql.append("t.accountName");
                } else {
                    sql.append(field.getSelect()).append(this.locale);
                }
                sql.append(" ").append(field.getName());
                continue;
            }
            if (field == GLRptField.measureUnitID || field == GLRptField.accountMeasureUnitName) {
                if (field == GLRptField.accountMeasureUnitName) {
                    if (CompanyDisplayModeEnum.merger == this.getCond().getCompanyDisplayMode()) {
                        sql.append("t.measureUnit");
                    } else {
                        sql.append(field.getSelect()).append(this.locale);
                    }
                } else if (CompanyDisplayModeEnum.merger == this.getCond().getCompanyDisplayMode()) {
                    sql.append("t.fmeasureUnitid");
                } else {
                    sql.append("mu.FID");
                }
                sql.append(" ").append(field.getName());
                continue;
            }
            if (field == GLRptField.findAsstName) {
                sql.append("' ' " + field.getName());
                continue;
            }
            if (field == GLRptField.HGName) {
                sql.append(" HG.FdisplaynameGroup").append(this.locale).append(" FdisplaynameGroup,");
                sql.append(" HG.FNumberGroup").append(this.locale).append(" FNumberGroup,");
                sql.append(" HG.flongnamegroup");
                sql.append(this.locale).append(" HGName ");
                continue;
            }
            if (field.isQty()) {
                sql.append("case when av.FIsQty = 0 then 0 else TO_DECIMAL(isnull(" + alias + "." + field.getName() + ",0), 28, 10)/ISNULL(MU.FCoefficient,1) end " + field.getName());
                continue;
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append(alias).append(".").append(field.getName());
                continue;
            }
            if (field.isMultiLang()) {
                sql.append(field.getSelect()).append(this.locale).append(" ").append(field.getName());
                continue;
            }
            sql.append(field.getSelect()).append(" ").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(super.getJoinSQL());
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        if (this.getCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.merger) {
            sql.append(" left outer join t_bd_accountview pav on av.fparentid = pav.fid ");
        }
        if (this.getCond().isShowQty()) {
            sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  ");
        }
        if (this.getCond().isAllCurrency()) {
            sql.append(" left outer join t_bd_currency cy on cy.fid = t.fcurrencyid ");
        }
        sql.append(this.getOrgJoinSQL());
        if (this.isDisplayAsstDetail) {
            sql.append(" left outer join t_bd_assistanthg HG on HG.fid = t.fassistgrpid ");
        }
        if (!this.isCreateDataTempTable) {
            sql.append(" left outer join (").append(this.getBalanceSQL(this.sp, false));
            if (this.isDisplayAsstDetail) {
                sql.append(" union all ").append(this.getBalanceSQL(this.sp, true));
            }
            sql.append(") b on b.sqlseq = t.ksql_seq");
        }
        return sql.toString();
    }

    private String getBalanceSQL(List sp, boolean isAsstBal) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.ksql_seq sqlseq");
        sql.append(this.helper.getAmountSelectSQL());
        sql.append(this.helper.getFromSQL(isAsstBal, this.getDataSourceTableName()));
        sql.append(this.helper.getWhereSQL());
        String pageFilter = this.getPageFilter("t", sp);
        if (!StringUtils.isEmpty((String)pageFilter)) {
            sql.append(" and ").append(pageFilter);
        }
        sql.append(" group by t.ksql_seq");
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        boolean isAccountTypeTotal = ((GLRptAccountBalanceCondition)this.getCond()).isAccountTypeTotal();
        order.add("t.FIsAccountTotal");
        if (isAccountTypeTotal) {
            order.add("t.FpTypeNum");
            order.add("t.FIsAccountTypeTotal");
        }
        if (this.isIncludeBWAccount) {
            order.add("t.FBWType");
            order.add("t.FIsAccountBWSum");
        }
        if (this.isQueryAccountNumber()) {
            order.add("av.fnumber");
        } else {
            order.add("t.accountNumber");
        }
        if (CompanyDisplayModeEnum.merger == this.getCond().getCompanyDisplayMode()) {
            order.add("t.accountName");
        }
        if (this.getCond().isAllCurrency()) {
            order.add("t.FIsCurrencyTotal");
            order.add(GLRptField.currencyNumber.getSelect());
        }
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            order.add("company.flongnumber");
        }
        if (this.isDisplayAsstDetail) {
            order.add("t.FIsAssist");
        }
        if (this.isDisplayAsstDetail) {
            order.add("hg.fnumbergroup_" + this.getCtx().getLocale().toString());
        }
        return order;
    }

    protected boolean isQueryAccountNumber() {
        return CompanyDisplayModeEnum.merger != this.getCond().getCompanyDisplayMode();
    }

    protected String getOrgJoinSQL() throws BOSException, EASBizException {
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            return " left outer join t_org_company company on company.fid = t.forgunitid ";
        }
        return "";
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String where = super.getWhereSQL();
        if (!this.getCond().isShowLeafAccount() && this.getCond().getCompanyDisplayMode() != CompanyDisplayModeEnum.merger) {
            boolean isAccountTypeTotal;
            if (where.length() > 0) {
                where = where + " and ";
            }
            where = (isAccountTypeTotal = ((GLRptAccountBalanceCondition)this.getCond()).isAccountTypeTotal()) ? where + "((av.flevel >= " + this.getCond().getAccountLevelStart() + " and av.flevel <= " + this.getCond().getAccountLevelEnd() + ") or t.fisAccounttotal = 1 or t.FIsAccountTypeTotal = 1)" : where + "((av.flevel >= " + this.getCond().getAccountLevelStart() + " and av.flevel <= " + this.getCond().getAccountLevelEnd() + ") or t.fisAccounttotal = 1)";
        }
        return where;
    }
}

