/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLRptHelper;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.app.DefaultGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.GLRptAccountBalanceIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQueryHelper;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptAccountBalanceDao
extends AbstractGLRptDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLRptAccountBalanceDao");
    protected GLRptAccountBalanceCondition cond;
    private Set accountIdSet4Sum;
    private String accountTempTable4Sum;
    private int assistCount = -1;
    private int maxAssistCount = 8;
    private int findAssistCount = -1;
    private String sysStatusTmpTable;
    String plVoucherTempTable;
    private Map<String, Integer> actTypeMap;
    private boolean isYearQuery = false;
    private boolean isWhrInAssitBalance = true;
    private boolean keepAssistToAccountBalance = false;
    private boolean isUseGL053 = false;
    private String companyIdsWithGL053 = "";
    private Context ctx;
    private Map<String, BigDecimal> loadedAssistGrpIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> loadedAsstActIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Map<String, MeasureUnitInfo> loadedAssistGrpIDToQtyMeasureUnit = new HashMap<String, MeasureUnitInfo>();
    private Map<String, MeasureUnitInfo> loadedAsstActIdToQtyMeasureUnit = new HashMap<String, MeasureUnitInfo>();
    private Map<String, AsstActTypeCollection> loadedAsstAccountIdToAsstActTypeCol = new HashMap<String, AsstActTypeCollection>();
    private Map<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
    private Map<String, GeneralAsstActTypeInfo> generalAsstActTypeMap = new HashMap<String, GeneralAsstActTypeInfo>();
    private Map<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
    private Map<String, AssistantHGInfo> loadedHGIDToHG = new HashMap<String, AssistantHGInfo>();
    private Map<String, BigDecimal> loadedAccountIDToQtyCoefficient = new HashMap<String, BigDecimal>();

    public GLRptAccountBalanceDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx);
        String companyId = null;
        if (company != null) {
            companyId = company.getId().toString();
        }
        GlParam param = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_118", "GL_053"}, (String)companyId);
        this.isWhrInAssitBalance = param.getBoolean("GL_118");
        boolean bl = this.isUseGL053 = param.getBoolean("GL_053") && !company.isIsBizUnit();
        if (this.actTypeMap == null) {
            this.actTypeMap = GLRptHelper.initAcctTypeMap(ctx);
        }
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptAccountBalanceCondition)this.getQueryCondition();
        if (this.cond.getDisplayAsstDetail()) {
            // empty if block
        }
        if (this.isUseGL053) {
            this.companyIdsWithGL053 = this.cond.getCompanyIdsStrWithGL053();
        }
    }

    @Override
    public void buildData() throws BOSException, EASBizException {
        this.insertData();
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        Set<String> comapnyIds;
        Set<String> moreBeginPeriodCompanyIds;
        if (this.cond.isNotIncluePLVoucher()) {
            this.createPLVoucherTempTable();
        }
        if (!(this.cond.getPeriodYearStart() != this.cond.getPeriodYearEnd() || this.cond.getPeriodNumberStart() != 1 || this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero() || this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero())) {
            this.cond.setPeriodNumberStart(this.cond.getPeriodNumberEnd());
            this.isYearQuery = true;
        }
        if (this.isCreateDataTempTable()) {
            this.sysStatusTmpTable = GLRptDaoUtil.createSysStatusTmpTable(this.getContex(), this.cond);
        }
        if (!(moreBeginPeriodCompanyIds = GLRptDaoUtil.getMoreBeginPeriodCompanyIds(this.getContex(), this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr(), this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart())).isEmpty()) {
            this.insertAccountBalance(GLRptDaoUtil.getIdFilter(this.getContex(), moreBeginPeriodCompanyIds), this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart());
        }
        Map<Integer, Set<String>> lessBeginPeriodCompanyIds = GLRptDaoUtil.getLessBeginPeriodCompanyIds(this.getContex(), this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr(), this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart());
        for (int period : lessBeginPeriodCompanyIds.keySet()) {
            comapnyIds = lessBeginPeriodCompanyIds.get(period);
            this.insertAccountBalance(GLRptDaoUtil.getIdFilter(this.getContex(), comapnyIds), period / 100, period % 100);
        }
        if (this.cond.getIncludeBWAccount()) {
            this.insertAccountSum(true);
        }
        this.insertAccountSum(false);
        if (CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode() && !this.cond.isShowLeafAccount()) {
            this.insertLevelSumData(GLRptField.accountID, "t_bd_accountview", "av", 1);
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.insertCompanySum();
        }
        if (this.isAllCurrency()) {
            this.insertCurrencySum();
        }
        if (this.cond.getDisplayAsstDetail()) {
            if (!moreBeginPeriodCompanyIds.isEmpty()) {
                this.insertAssistBalance(moreBeginPeriodCompanyIds, this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart());
            }
            for (int period : lessBeginPeriodCompanyIds.keySet()) {
                comapnyIds = lessBeginPeriodCompanyIds.get(period);
                this.insertAssistBalance(comapnyIds, period / 100, period % 100);
            }
            this.assistCount = this.getAssistColumnCount();
            this.findAssistCount = this.cond.getAsstActList().size();
        }
        if (this.cond.isAccountTypeTotal()) {
            this.insertAccountTypeSum();
        }
    }

    @Override
    protected String getParentSelectSQL(GLRptField sumField, String alias) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            if (field.getName().equals(sumField.getName())) {
                sql.append(alias).append(".fparentid ").append(field.getName());
                continue;
            }
            if ("NUMERIC(29,10)".equals(field.getType())) {
                sql.append("sum(t.").append(field.getName()).append(") ").append(field.getName());
                continue;
            }
            if ("FIsAfterCurrPeriod".equals(field.getName()) || "FIsAssist".equals(field.getName())) {
                sql.append("0 ").append(field.getName());
                continue;
            }
            if (GLRptField.HG.getName().compareToIgnoreCase(field.getName()) == 0) {
                sql.append("'' ").append(field.getName());
                continue;
            }
            if (GLRptField.accountID.getName().compareToIgnoreCase(sumField.getName()) == 0 && CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() && (GLRptField.accountNumberMerger.getName().compareToIgnoreCase(field.getName()) == 0 || GLRptField.accountNameMerger.getName().compareToIgnoreCase(field.getName()) == 0)) {
                sql.append("p").append(field.getSelect());
                if (field.isMultiLang()) {
                    sql.append("_").append(this.getContex().getLocale());
                }
                sql.append(" ").append(field.getName());
                continue;
            }
            if (this.isShowQty() && (field == GLRptField.measureUnitID || field == GLRptField.accountMeasureUnitName)) {
                sql.append(" '' ").append(field.getName());
                continue;
            }
            sql.append("t.").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getWhere(String alias) {
        if (this.cond.getDisplayAsstDetail()) {
            return alias + ".FIsAssist = 0";
        }
        return null;
    }

    @Override
    protected String getParentGroupBySQL(GLRptField sumField, String alias) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null || field.getQueryField() == null || "NUMERIC(29,10)".equals(field.getType()) || "FIsAfterCurrPeriod".equals(field.getName()) || GLRptField.HG.getName().equals(field.getName()) || "FIsAssist".equals(field.getName()) || field == GLRptField.measureUnitID || field == GLRptField.accountMeasureUnitName) continue;
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            if (field.getName().equals(sumField.getName())) {
                sql.append(alias).append(".fparentid");
                continue;
            }
            if (GLRptField.accountID.getName().compareToIgnoreCase(sumField.getName()) == 0 && CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() && (GLRptField.accountNumberMerger.getName().compareToIgnoreCase(field.getName()) == 0 || GLRptField.accountNameMerger.getName().compareToIgnoreCase(field.getName()) == 0)) {
                sql.append("p").append(field.getSelect());
                if (!field.isMultiLang()) continue;
                sql.append("_").append(this.getContex().getLocale());
                continue;
            }
            sql.append("t.").append(field.getName());
        }
        return sql.toString();
    }

    protected int getAssistColumnCount() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT /*+ LEADING(t) */ MAX(aa.FCount) FCount \n");
        sql.append("FROM " + this.getDataSourceTableName() + " t \n");
        sql.append("JOIN T_BD_AssistantHG hg on hg.FID = t.FAssistGrpID \n");
        sql.append("JOIN t_bd_asstaccount aa on aa.FID = hg.FAsstAccountID \n");
        IRowSet rs = this.executeQuery(sql.toString());
        int assCount = 0;
        try {
            if (rs.next()) {
                assCount = rs.getInt("fcount");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return assCount;
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws SQLException, BOSException, EASBizException {
        super.toGLRptRowData(rs, rowData);
        if (this.cond.getDisplayAsstDetail()) {
            this.setAsstName(rs, rowData);
        }
        this.setBalance(rs, rowData);
        if (this.cond.isAccountTypeTotal() && this.isAccounTypeTotal(rs)) {
            this.setAcountSumAmount(this.getAccountSumAmount(rs, true), rowData);
        } else if (this.isAccountTotal(rs)) {
            this.setAcountSumAmount(this.getAccountSumAmount(rs, false), rowData);
        } else {
            this.setYearBegin(rs, rowData);
        }
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        String isQty;
        super.doGLRptRowData(rowSet);
        GLRptTreeNode node = null;
        if (!this.cond.isFillInfo() && CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            node = (GLRptTreeNode)rowSet.getObject("companyName");
            if (this.cond.getDisplayAsstDetail() && rowSet.getInt("FIsAssist") == 1) {
                node.setShow(false);
            }
        }
        if (!this.cond.isFillInfo() && CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() && node.getParentNode() != null) {
            rowSet.updateObject(GLRptField.currencyName.getName(), null);
        }
        if (!this.cond.isFillInfo() && (this.cond.getDisplayAsstDetail() && rowSet.getInt("FIsAssist") == 1 || CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() && node.getParentNode() != null)) {
            rowSet.updateObject(GLRptField.accountName.getName(), null);
            rowSet.updateObject(GLRptField.accountNumber.getName(), null);
        }
        if (this.cond.getRptParams().isQtyAsst() && this.cond.isShowQty() && this.cond.getDisplayAsstDetail() && (isQty = rowSet.getString("FMeasureUnitID")) != null) {
            this.setMeasureUnitAndQty(rowSet);
        }
    }

    protected void setMeasureUnitAndQty(GLRptRowSet rowSet) throws BOSException, EASBizException {
        String accountId = rowSet.getString(GLRptField.accountID.getName());
        String assistGrpId = rowSet.getString(GLRptField.HG.getName());
        if (!StringUtils.isEmpty((String)accountId) && !StringUtils.isEmpty((String)assistGrpId)) {
            BigDecimal accountQtyCoefficient = this.getAccountQtyCoefficient(accountId);
            BigDecimal asstQtyCoefficient = this.getAsstQtyCoefficient(rowSet);
            if (rowSet.getBigDecimal("FYearBeginDebitQty") != null) {
                rowSet.updateBigDecimal("FYearBeginDebitQty", rowSet.getBigDecimal("FYearBeginDebitQty").multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal("FYearBeginCreditQty") != null) {
                rowSet.updateBigDecimal("FYearBeginCreditQty", rowSet.getBigDecimal("FYearBeginCreditQty").multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal("FBeginDebitQty") != null) {
                rowSet.updateBigDecimal("FBeginDebitQty", rowSet.getBigDecimal("FBeginDebitQty").multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal("FBeginCreditQty") != null) {
                rowSet.updateBigDecimal("FBeginCreditQty", rowSet.getBigDecimal("FBeginCreditQty").multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.debitQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.debitQty.getName(), rowSet.getBigDecimal(GLRptField.debitQty.getName()).multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.creditQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.creditQty.getName(), rowSet.getBigDecimal(GLRptField.creditQty.getName()).multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.yearDebitQty.getName(), rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()).multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()) != null) {
                rowSet.updateBigDecimal(GLRptField.yearCreditQty.getName(), rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()).multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal("FEndDebitQty") != null) {
                rowSet.updateBigDecimal("FEndDebitQty", rowSet.getBigDecimal("FEndDebitQty").multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (rowSet.getBigDecimal("FEndCreditQty") != null) {
                rowSet.updateBigDecimal("FEndCreditQty", rowSet.getBigDecimal("FEndCreditQty").multiply(accountQtyCoefficient).divide(asstQtyCoefficient, this.cond.getQtyScale(), 4));
            }
            if (this.loadedAssistGrpIDToQtyMeasureUnit.get(assistGrpId) != null) {
                rowSet.updateString(GLRptField.measureUnitName.getName(), this.loadedAssistGrpIDToQtyMeasureUnit.get(assistGrpId).getName());
            }
        }
    }

    protected BigDecimal getAsstQtyCoefficient(GLRptRowSet rs) throws BOSException, EASBizException {
        String assistGrpId = rs.getString(GLRptField.HG.getName());
        String asstaccountId = rs.getString("FAsstAccountId");
        if (asstaccountId == null) {
            return GlUtils.one;
        }
        if (this.loadedAssistGrpIDToQtyCoefficient.containsKey(assistGrpId)) {
            return this.loadedAssistGrpIDToQtyCoefficient.get(assistGrpId) == null ? GlUtils.one : this.loadedAssistGrpIDToQtyCoefficient.get(assistGrpId);
        }
        AsstActTypeCollection asstActTypes = null;
        if (this.loadedAsstAccountIdToAsstActTypeCol.containsKey(asstaccountId)) {
            asstActTypes = this.loadedAsstAccountIdToAsstActTypeCol.get(asstaccountId);
        } else {
            asstActTypes = VoucherProcessCache.getAsstActTypes(this.ctx, asstaccountId);
            this.loadedAsstAccountIdToAsstActTypeCol.put(asstaccountId, asstActTypes);
        }
        AsstActTypeInfo accountingAsstActType = null;
        if (asstActTypes != null) {
            for (int i = 0; i < asstActTypes.size(); ++i) {
                AsstActTypeInfo asstActTypeInfo = asstActTypes.get(i);
                if (!asstActTypeInfo.isIsQty()) continue;
                if (this.asstActTypeMap.containsKey(asstActTypeInfo.getId().toString())) {
                    accountingAsstActType = this.asstActTypeMap.get(asstActTypeInfo.getId().toString());
                    break;
                }
                IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("asstActType.id"));
                sic.add(new SelectorItemInfo("mappingFieldName"));
                sic.add(new SelectorItemInfo("asstHGAttribute"));
                sic.add(new SelectorItemInfo("measureUnit.id"));
                sic.add(new SelectorItemInfo("measureUnit.name"));
                sic.add(new SelectorItemInfo("measureUnit.coefficient"));
                sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
                sic.add(new SelectorItemInfo("measureUnitGroup.id"));
                sic.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.id"));
                sic.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.name"));
                accountingAsstActType = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeInfo.getId()), sic);
                asstActTypeInfo.put(asstActTypeInfo.getId().toString(), (Object)accountingAsstActType);
                break;
            }
        }
        if (accountingAsstActType == null) {
            return GlUtils.one;
        }
        AssistantHGInfo hgInfo = null;
        if (this.loadedHGIDToHG.containsKey(assistGrpId)) {
            hgInfo = this.loadedHGIDToHG.get(assistGrpId);
        } else {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("asstAccount.id"));
            selectors.add(new SelectorItemInfo(accountingAsstActType.getAsstHGAttribute() + ".id"));
            hgInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(assistGrpId), selectors);
            this.loadedHGIDToHG.put(assistGrpId, hgInfo);
        }
        BigDecimal accountingCoefficient = GlUtils.one;
        MeasureUnitInfo measureUnitInfo = null;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)hgInfo.get(accountingAsstActType.getAsstHGAttribute());
        String asstActId = dataBaseInfo.getId().toString();
        accountingCoefficient = this.loadedAsstActIDToQtyCoefficient.get(asstActId);
        if (accountingCoefficient != null) {
            if (!this.loadedAssistGrpIDToQtyMeasureUnit.containsKey(assistGrpId)) {
                this.loadedAssistGrpIDToQtyMeasureUnit.put(assistGrpId, this.loadedAsstActIdToQtyMeasureUnit.get(asstActId));
            }
            return accountingCoefficient;
        }
        if (accountingAsstActType.getGlAsstActTypeGrp() != null) {
            GeneralAsstActTypeInfo accountingAsstAct = null;
            if (this.generalAsstActTypeMap.containsKey(asstActId)) {
                accountingAsstAct = this.generalAsstActTypeMap.get(asstActId);
            } else {
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("id"));
                selectorItemCollection.add(new SelectorItemInfo("measureUnit.id"));
                selectorItemCollection.add(new SelectorItemInfo("measureUnit.name"));
                selectorItemCollection.add(new SelectorItemInfo("measureUnit.coefficient"));
                selectorItemCollection.add(new SelectorItemInfo("measureUnitGroup.id"));
                selectorItemCollection.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.id"));
                selectorItemCollection.add(new SelectorItemInfo("measureUnitGroup.defaultUnit.name"));
                accountingAsstAct = GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getGeneralAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActId), selectorItemCollection);
                this.generalAsstActTypeMap.put(asstActId, accountingAsstAct);
            }
            if (accountingAsstAct != null) {
                if (accountingAsstAct.getMeasureUnit() != null) {
                    measureUnitInfo = accountingAsstAct.getMeasureUnit();
                    accountingCoefficient = measureUnitInfo.getCoefficient();
                } else if (accountingAsstAct.getMeasureUnitGroup() != null) {
                    accountingCoefficient = GlUtils.one;
                    measureUnitInfo = accountingAsstAct.getMeasureUnitGroup().getDefaultUnit();
                } else if (accountingAsstActType.getMeasureUnit() != null) {
                    measureUnitInfo = accountingAsstActType.getMeasureUnit();
                    accountingCoefficient = measureUnitInfo.getCoefficient();
                } else if (accountingAsstActType.getMeasureUnitGroup() != null) {
                    measureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
                    accountingCoefficient = GlUtils.one;
                } else {
                    accountingCoefficient = GlUtils.one;
                }
            } else {
                accountingCoefficient = GlUtils.one;
                measureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
            }
        } else if ("material".equals(accountingAsstActType.getAsstHGAttribute())) {
            MaterialInfo mateial = null;
            if (this.materialMap.containsKey(asstActId)) {
                mateial = this.materialMap.get(asstActId);
            } else {
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("id"));
                selectorItemCollection.add(new SelectorItemInfo("baseUnit.id"));
                selectorItemCollection.add(new SelectorItemInfo("baseUnit.name"));
                selectorItemCollection.add(new SelectorItemInfo("baseUnit.coefficient"));
                mateial = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(asstActId), selectorItemCollection);
                this.materialMap.put(asstActId, mateial);
            }
            if (mateial != null) {
                if (mateial.getBaseUnit() != null) {
                    measureUnitInfo = mateial.getBaseUnit();
                    accountingCoefficient = measureUnitInfo.getCoefficient();
                } else if (accountingAsstActType.getMeasureUnit() != null) {
                    measureUnitInfo = accountingAsstActType.getMeasureUnit();
                    accountingCoefficient = measureUnitInfo.getCoefficient();
                } else if (accountingAsstActType.getMeasureUnitGroup() != null) {
                    accountingCoefficient = GlUtils.one;
                    measureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
                } else {
                    accountingCoefficient = GlUtils.one;
                }
            } else {
                accountingCoefficient = GlUtils.one;
            }
        } else if (accountingAsstActType.getMeasureUnit() != null) {
            measureUnitInfo = accountingAsstActType.getMeasureUnit();
            accountingCoefficient = measureUnitInfo.getCoefficient();
        } else if (accountingAsstActType.getMeasureUnitGroup() != null) {
            accountingCoefficient = GlUtils.one;
            measureUnitInfo = accountingAsstActType.getMeasureUnitGroup().getDefaultUnit();
        } else {
            accountingCoefficient = GlUtils.one;
        }
        this.loadedAsstActIDToQtyCoefficient.put(asstActId, accountingCoefficient);
        this.loadedAsstActIdToQtyMeasureUnit.put(asstActId, measureUnitInfo);
        this.loadedAssistGrpIDToQtyMeasureUnit.put(assistGrpId, measureUnitInfo);
        return accountingCoefficient;
    }

    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        if (accountId != null) {
            MeasureUnitInfo measureUnitID;
            BigDecimal accountQtyCoefficient = GlUtils.one;
            AccountViewInfo accountViewInfo = null;
            if (this.loadedAccountIDToQtyCoefficient.containsKey(accountId)) {
                accountQtyCoefficient = this.loadedAccountIDToQtyCoefficient.get(accountId);
            } else {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            }
            if (accountViewInfo != null && (measureUnitID = accountViewInfo.getMeasureUnitID()) != null) {
                accountQtyCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID.getId().toString())).getCoefficient();
            }
            this.loadedAccountIDToQtyCoefficient.put(accountId, accountQtyCoefficient);
            return accountQtyCoefficient;
        }
        return GlUtils.one;
    }

    private void setAsstName(IRowSet rs, IGLRptRowData rowData) throws SQLException, EASBizException, BOSException {
        String[] ass = new String[this.findAssistCount];
        for (int i = 0; i < this.findAssistCount; ++i) {
            ass[i] = ((AsstactTypeEntity)this.cond.getAsstActList().get(i)).getName();
        }
        String asstNameL = rs.getString(GLRptField.HGName.getName());
        String asstNameD = rs.getString("FdisplaynameGroup");
        String asstNameN = rs.getString("FNumberGroup");
        try {
            Object hg = null;
            boolean onlyOne = true;
            if (asstNameL != null && asstNameL.trim().length() > 0) {
                asstNameL = asstNameL.substring(0, asstNameL.length() - 1);
                asstNameD = asstNameD.substring(0, asstNameD.length() - 1);
                asstNameN = asstNameN.substring(0, asstNameN.length() - 1);
                String[] strAsstNameL = asstNameL.split(";");
                String[] strAsstNameD = asstNameD.split(";");
                String[] strAsstNameN = asstNameN.split(";");
                String number = null;
                int acctTypeFlag = 0;
                int index = this.findAssistCount;
                for (int i = 0; i < strAsstNameL.length && i < this.assistCount; ++i) {
                    String realName;
                    if (strAsstNameL[i] == null) continue;
                    int subIndex = strAsstNameN[i].indexOf("_!");
                    if (subIndex != -1) {
                        number = strAsstNameN[i].substring(0, subIndex);
                    }
                    if (this.actTypeMap.get(number) != null) {
                        acctTypeFlag = this.actTypeMap.get(number);
                    }
                    if ((realName = GLRptHelper.getAssDisplayName(this.cond.getRptParams().isAssitemShowNumber(), this.cond.getRptParams().isShowLongNameForGeneral(), true, acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i])).equals("Error") && onlyOne) {
                        onlyOne = false;
                        String hgid = rs.getString("FAssistGrpId");
                        String[] result = GLRptHelper.rePairHg(this.getContex(), hgid);
                        strAsstNameL = result[0].split(";");
                        strAsstNameD = result[1].split(";");
                        strAsstNameN = result[2].split(";");
                        realName = GLRptHelper.getAssDisplayName(this.cond.getRptParams().isAssitemShowNumber(), this.cond.getRptParams().isShowLongNameForGeneral(), true, acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i]);
                    }
                    boolean isFindAsst = false;
                    for (int j = 0; j < this.findAssistCount; ++j) {
                        if (!realName.split(":")[0].equals(ass[j])) continue;
                        rowData.updateString("FAsstAccountName" + j, realName);
                        isFindAsst = true;
                        break;
                    }
                    if (isFindAsst) continue;
                    rowData.updateString("FAsstAccountName" + index++, realName);
                }
            }
        }
        catch (RuntimeException e) {
            throw new GLBaseDataCheckException(GLBaseDataCheckException.BASE_DATA_FORMAT_ERROR, new Object[]{rs.getString("FAccountID"), rs.getString("FASSISTGRPID"), asstNameL, asstNameD, asstNameN});
        }
    }

    private void setBalance(IRowSet rs, IGLRptRowData rowData) throws SQLException, EASBizException, BOSException {
        BigDecimal endQty = null;
        BigDecimal beginQty = null;
        if (this.isShowQty()) {
            endQty = rs.getBigDecimal("FEndQty");
            if (endQty == null) {
                endQty = GlUtils.zero;
            }
            if (this.isYearQuery) {
                BigDecimal yearDebitQty = rs.getBigDecimal("FYearDebitQty");
                BigDecimal yearCreditQty = rs.getBigDecimal("FYearCreditQty");
                if (yearDebitQty == null) {
                    yearDebitQty = GlUtils.zero;
                }
                if (yearCreditQty == null) {
                    yearCreditQty = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitQty", yearDebitQty);
                rowData.updateBigDecimal("FCreditQty", yearCreditQty);
                beginQty = endQty.add(yearCreditQty).subtract(yearDebitQty);
            } else {
                beginQty = rs.getBigDecimal("FBeginQty");
            }
            if (beginQty == null) {
                beginQty = GlUtils.zero;
            }
        }
        BigDecimal endBalFor = null;
        BigDecimal beginBalFor = null;
        if (this.isShowFor()) {
            endBalFor = rs.getBigDecimal("FEndBalanceFor");
            if (endBalFor == null) {
                endBalFor = GlUtils.zero;
            }
            if (this.isYearQuery) {
                BigDecimal yearDebitBalFor = rs.getBigDecimal("FYearDebitFor");
                BigDecimal yearCreditBalFor = rs.getBigDecimal("FYearCreditFor");
                if (yearDebitBalFor == null) {
                    yearDebitBalFor = GlUtils.zero;
                }
                if (yearCreditBalFor == null) {
                    yearCreditBalFor = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitFor", yearDebitBalFor);
                rowData.updateBigDecimal("FCreditFor", yearCreditBalFor);
                beginBalFor = endBalFor.add(yearCreditBalFor).subtract(yearDebitBalFor);
            } else {
                beginBalFor = rs.getBigDecimal("FBeginBalanceFor");
            }
            if (beginBalFor == null) {
                beginBalFor = GlUtils.zero;
            }
        }
        BigDecimal endBalLocal = null;
        BigDecimal beginBalLocal = null;
        if (this.isShowLocal()) {
            endBalLocal = rs.getBigDecimal("FEndBalanceLocal");
            if (endBalLocal == null) {
                endBalLocal = GlUtils.zero;
            }
            if (this.isYearQuery) {
                BigDecimal yearDebitBalLocal = rs.getBigDecimal("FYearDebitLocal");
                BigDecimal yearCreditBalLocal = rs.getBigDecimal("FYearCreditLocal");
                if (yearDebitBalLocal == null) {
                    yearDebitBalLocal = GlUtils.zero;
                }
                if (yearCreditBalLocal == null) {
                    yearCreditBalLocal = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitLocal", yearDebitBalLocal);
                rowData.updateBigDecimal("FCreditLocal", yearCreditBalLocal);
                beginBalLocal = endBalLocal.add(yearCreditBalLocal).subtract(yearDebitBalLocal);
            } else {
                beginBalLocal = rs.getBigDecimal("FBeginBalanceLocal");
            }
            if (beginBalLocal == null) {
                beginBalLocal = GlUtils.zero;
            }
        }
        BigDecimal endBalRpt = null;
        BigDecimal beginBalRpt = null;
        if (this.isShowRpt()) {
            endBalRpt = rs.getBigDecimal("FEndBalanceRpt");
            if (endBalRpt == null) {
                endBalRpt = GlUtils.zero;
            }
            if (this.isYearQuery) {
                BigDecimal yearDebitBalRpt = rs.getBigDecimal("FYearDebitRpt");
                BigDecimal yearCreditBalRpt = rs.getBigDecimal("FYearCreditRpt");
                if (yearDebitBalRpt == null) {
                    yearDebitBalRpt = GlUtils.zero;
                }
                if (yearCreditBalRpt == null) {
                    yearCreditBalRpt = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitRpt", yearDebitBalRpt);
                rowData.updateBigDecimal("FCreditRpt", yearCreditBalRpt);
                beginBalRpt = endBalRpt.add(yearCreditBalRpt).subtract(yearDebitBalRpt);
            } else {
                beginBalRpt = rs.getBigDecimal("FBeginBalanceRpt");
            }
            if (beginBalRpt == null) {
                beginBalRpt = GlUtils.zero;
            }
        }
        boolean isEndDebit = this.isDebit(rs, endBalFor, endBalLocal, endBalRpt);
        boolean isBeginDebit = this.isDebit(rs, beginBalFor, beginBalLocal, beginBalRpt);
        if (this.isShowQty()) {
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitQty", endQty);
            } else {
                rowData.updateBigDecimal("FEndCreditQty", endQty.negate());
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitQty", beginQty);
            } else {
                rowData.updateBigDecimal("FBeginCreditQty", beginQty.negate());
            }
        }
        if (this.isShowFor()) {
            if (endBalFor.doubleValue() != 0.0) {
                if (isEndDebit) {
                    rowData.updateBigDecimal("FEndDebitBalanceFor", endBalFor);
                } else {
                    rowData.updateBigDecimal("FEndCreditBalanceFor", endBalFor.negate());
                }
            }
            if (beginBalFor.doubleValue() != 0.0) {
                if (isBeginDebit) {
                    rowData.updateBigDecimal("FBeginDebitBalanceFor", beginBalFor);
                } else {
                    rowData.updateBigDecimal("FBeginCreditBalanceFor", beginBalFor.negate());
                }
            }
        }
        if (this.isShowLocal()) {
            if (endBalLocal.doubleValue() != 0.0) {
                if (isEndDebit) {
                    rowData.updateBigDecimal("FEndDebitBalanceLocal", endBalLocal);
                } else {
                    rowData.updateBigDecimal("FEndCreditBalanceLocal", endBalLocal.negate());
                }
            }
            if (beginBalLocal.doubleValue() != 0.0) {
                if (isBeginDebit) {
                    rowData.updateBigDecimal("FBeginDebitBalanceLocal", beginBalLocal);
                } else {
                    rowData.updateBigDecimal("FBeginCreditBalanceLocal", beginBalLocal.negate());
                }
            }
        }
        if (this.isShowRpt()) {
            if (endBalRpt.doubleValue() != 0.0) {
                if (isEndDebit) {
                    rowData.updateBigDecimal("FEndDebitBalanceRpt", endBalRpt);
                } else {
                    rowData.updateBigDecimal("FEndCreditBalanceRpt", endBalRpt.negate());
                }
            }
            if (beginBalRpt.doubleValue() != 0.0) {
                if (isBeginDebit) {
                    rowData.updateBigDecimal("FBeginDebitBalanceRpt", beginBalRpt);
                } else {
                    rowData.updateBigDecimal("FBeginCreditBalanceRpt", beginBalRpt.negate());
                }
            }
        }
    }

    private boolean isDebit(IRowSet rs, BigDecimal balanceFor, BigDecimal balanceLocal, BigDecimal balanceRpt) throws SQLException, EASBizException, BOSException {
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        boolean isSameDC = dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount();
        boolean isDebit = true;
        if (isSameDC) {
            isDebit = new BigDecimal(dc.toString()).intValue() == 1;
        } else {
            BigDecimal amount = GlUtils.zero;
            if (this.isShowFor()) {
                amount = balanceFor;
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
                amount = balanceLocal;
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
                amount = balanceRpt;
            }
            isDebit = amount == null || amount.doubleValue() >= 0.0;
        }
        return isDebit;
    }

    private void appendAmountSumSelect(StringBuffer sql, String currencyId, String companyId, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginDebitSum(sql, "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(",0.0 FYearBeginDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginDebitSum(sql, "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FYearBeginDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginDebitSum(sql, "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendYearBeginDebitSum(sql, "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginCreditSum(sql, "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FYearBeginCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginCreditSum(sql, "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FYearBeginCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginCreditSum(sql, "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendYearBeginCreditSum(sql, "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginDebitSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FBeginDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginDebitSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FBeginDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginDebitSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginDebitSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginCreditSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FBeginCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginCreditSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FBeginCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginCreditSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginCreditSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TO_DECIMAL(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("Qty,28,10)*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FDebitQty");
            } else {
                sql.append(", 0.0 FDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("For) FDebitFor");
            } else {
                sql.append(", 0.0  FDebitFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("Local) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("Rpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TO_DECIMAL(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("Qty,28,10)*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FCreditQty");
            } else {
                sql.append(", 0.0 FCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("For) FCreditFor");
            } else {
                sql.append(", 0.0  FCreditFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("Local) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("Rpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TO_DECIMAL(TB.FYearDebitQty,28,10)*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FYearDebitQty");
            } else {
                sql.append(", 0.0 FYearDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearDebitFor) FYearDebitFor");
            } else {
                sql.append(", 0.0  FYearDebitFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearDebitLocal) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearDebitRpt) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(case when av.FIsQty = 1 then TO_DECIMAL(TB.FYearCreditQty,28,10)*1.0000/ISNULL(MU.FCoefficient,1) else 0.00 end) FYearCreditQty");
            } else {
                sql.append(", 0.0 FYearCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearCreditFor) FYearCreditFor");
            } else {
                sql.append(", 0.0  FYearCreditFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearCreditLocal) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearCreditRpt) FYearCreditRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndDebitSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndDebitSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndDebitSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndDebitSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndCreditSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndCreditSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndCreditSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndCreditSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
    }

    private void appendYearBeginDebitSum(StringBuffer sql, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if ("Qty".equals(suff)) {
            sql.append("av.FIsQty = 1 and ");
        }
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FYearBegin" + suff + " > 0 ");
        }
        sql.append(" THEN TO_DECIMAL((TB.FYearBegin" + suff).append("),28,10)");
        if ("Qty".equals(suff)) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FYearBeginDebit" + suff + " ");
    }

    private void appendYearBeginCreditSum(StringBuffer sql, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if ("Qty".equals(suff)) {
            sql.append("av.FIsQty = 1 and ");
        }
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FYearBegin" + suff + " < 0 ");
        }
        sql.append(" THEN -1 * TO_DECIMAL((TB.FYearBegin" + suff + "),28,10) ");
        if ("Qty".equals(suff)) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FYearBeginCredit" + suff + " ");
    }

    private void appendPeriodBeginDebitSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        String begin = this.isYearQuery ? " TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type : " TB.FBegin" + suff;
        sql.append(" ,sum(CASE WHEN ");
        if (type.equals("Qty")) {
            sql.append("av.FIsQty = 1 and ");
        }
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(begin + " > 0 ");
        }
        sql.append(" THEN TO_DECIMAL((").append(begin).append("),28,10)");
        if (type.equals("Qty")) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FBeginDebit" + suff);
    }

    private void appendPeriodBeginCreditSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        String begin = this.isYearQuery ? " TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type : " TB.FBegin" + suff;
        sql.append(", sum(CASE WHEN ");
        if (type.equals("Qty")) {
            sql.append("av.FIsQty = 1 and ");
        }
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(begin + " < 0 ");
        }
        sql.append(" THEN -1 * TO_DECIMAL((").append(begin).append("),28,10)");
        if (type.equals("Qty")) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FBeginCredit" + suff);
    }

    private void appendPeriodEndDebitSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (type.equals("Qty")) {
            sql.append("av.FIsQty = 1 and ");
        }
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FEnd" + suff + ">0");
        }
        sql.append(" THEN TO_DECIMAL(TB.FEnd" + suff + ",28,10)");
        if (type.equals("Qty")) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FEndDebit" + suff + " ");
    }

    private void appendPeriodEndCreditSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (type.equals("Qty")) {
            sql.append("av.FIsQty = 1 and ");
        }
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FEnd" + suff + "<0");
        }
        sql.append(" THEN -1*TO_DECIMAL(TB.FEnd" + suff + ",28,10)");
        if (type.equals("Qty")) {
            sql.append("*1.0000/ISNULL(MU.FCoefficient,1)");
        }
        sql.append(" ELSE 0.0 END) FEndCredit" + suff + " ");
    }

    private IRowSet getAccountSumAmount(IRowSet rs, boolean isAccountTypeTotal) throws EASBizException, BOSException, SQLException {
        String companyId = CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() ? rs.getString("FOrgUnitID") : this.getCompany().getId().toString();
        SelectorItemCollection companySelector = new SelectorItemCollection();
        companySelector.add(new SelectorItemInfo("id"));
        companySelector.add(new SelectorItemInfo("isBizUnit"));
        companySelector.add(new SelectorItemInfo("longNumber"));
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.cond.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), companySelector);
        String currencyId = null;
        if (this.isAllCurrency() && (currencyId = rs.getString("FCurrencyID")) != null && currencyId.trim().length() == 0) {
            currencyId = null;
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst()) {
                int bwType;
                StringBuffer sql = new StringBuffer();
                sql.append(" select 1 xxx");
                this.appendAmountSumSelect(sql, currencyId, companyId, this.cond.isBalanceDirSamAsAccount());
                sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TB \r\n");
                sql.append(" INNER JOIN T_BD_AccountView av on TB.FAccountID = av.FID \r\n");
                if (this.isShowQty()) {
                    sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  \r\n");
                }
                sql.append(" WHERE ((av.FCAA IS NULL AND FIsAssist = 0 and (av.fisleaf = 1 or av.flevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append("))");
                sql.append(" OR (av.FCAA IS not NULL AND FIsAssist = 0 and av.FLevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append(" and av.FIsLeaf = 0) ");
                sql.append(" OR (av.FCAA IS not NULL AND FIsAssist = 1 )) \r\n");
                if (this.isAllCurrency()) {
                    sql.append(" and TB.FCurrencyID is not null and TB.FCurrencyID <> ' ' \r\n");
                }
                if (companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                    sql.append(" and tb.FOrgUnitID <> '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
                } else {
                    sql.append(" and tb.FOrgUnitID = '").append(companyId).append("'");
                }
                if (this.isAllCurrency()) {
                    if (currencyId != null && currencyId.trim().length() > 0) {
                        sql.append(" and TB.FCurrencyID = '").append(currencyId).append("'");
                    } else {
                        sql.append(" and TB.FCurrencyID != ' '");
                    }
                }
                if (this.cond.getIncludeBWAccount() && ((bwType = rs.getInt("FBWType")) == 0 || bwType == 1)) {
                    sql.append(" and TB.FBWType = ").append(bwType);
                }
                return this.executeQuery(sql.toString());
            }
            return this.getAccountAmountForMerger(rs, currencyId, companyId);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 xxx");
        this.appendAmountSumSelect(sql, currencyId, companyId, this.cond.isBalanceDirSamAsAccount());
        int bwType = -1;
        if (this.cond.getIncludeBWAccount()) {
            bwType = rs.getInt("FBWType");
        }
        if (this.isCreateDataTempTable()) {
            sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TB ");
            sql.append(" INNER JOIN T_BD_AccountView av on TB.FAccountID = av.FID ");
            if (this.isShowQty()) {
                sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  ");
            }
            if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst()) {
                sql.append(" WHERE ((av.FCAA is null AND FIsAssist = 0 and (av.fisleaf = 1 or av.flevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append("))");
                sql.append(" OR (av.FCAA is not null AND FIsAssist = 0 and av.FLevel = ").append(new Integer(this.cond.getAccountLevelEnd())).append(" and av.FIsLeaf = 0) ");
                sql.append(" OR (av.FCAA is not null AND FIsAssist = 1 )) ");
                if (!this.cond.isShowLeafAccount() && CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                    sql.append(" and (av.flevel <=  ").append(this.cond.getAccountLevelEnd()).append(" or tb.fisAccounttotal = 1)");
                }
            } else {
                if (this.cond.isShowLeafAccount()) {
                    sql.append(" WHERE ").append(" av.FIsLeaf = 1 ");
                } else {
                    sql.append(" WHERE ").append(" av.flevel = ").append(this.cond.getAccountLevelStart());
                }
                if (this.cond.getDisplayAsstDetail()) {
                    sql.append(" and tb.FIsAssist = 0 ");
                }
            }
            if (this.isAllCurrency()) {
                sql.append(" and TB.FCurrencyID is not null and TB.FCurrencyID <> ' ' ");
            }
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst() && !companyInfo.isIsBizUnit()) {
                    sql.append(" and TB.FOrgUnitID in (").append("select distinct cp.fid ").append(GlUtils.getCompanyFilterSQLForCu(null, "ea82f5b7-00fd-1000-e000-0011c0a813dbPERMITEM", false, companyInfo, null, true, null, false)).append(")");
                } else {
                    sql.append(" and TB.FOrgUnitID = '").append(companyId).append("'");
                }
                if (CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode() && this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst() && (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode())) {
                    sql.append(" and av.fcompanyid = tb.forgunitid ");
                }
            }
            if (this.isAllCurrency()) {
                if (currencyId != null && currencyId.trim().length() > 0) {
                    sql.append(" and TB.FCurrencyID = '").append(currencyId).append("'");
                } else {
                    sql.append(" and TB.FCurrencyID != ' '");
                }
            }
            if (!(bwType != 0 && bwType != 1 || isAccountTypeTotal)) {
                sql.append(" and TB.FBWType = ").append(bwType);
            }
            if (isAccountTypeTotal) {
                String pTypeNum = rs.getString("fpTypeNum");
                sql.append(" and TB.fpTypeNum = '" + pTypeNum + "' ");
            }
        } else {
            sql.append(" from (").append(this.getBalanceSumSQL(false, bwType, isAccountTypeTotal));
            if (this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst()) {
                sql.append(" union all ").append(this.getBalanceSumSQL(true, bwType, isAccountTypeTotal));
            }
            sql.append(") tb ");
            sql.append(" left outer join T_BD_AccountView av on tb.FAccountID = av.FID ");
            if (this.isShowQty()) {
                sql.append(" left outer join T_BD_MeasureUnit mu on mu.FID = av.FMeasureUnitID  ");
            }
            if (isAccountTypeTotal && this.cond.isShowLeafAccount()) {
                String pTypeNum = rs.getString("fpTypeNum");
                sql.append(" where TB.fpTypeNum = '" + pTypeNum + "' ");
            }
        }
        return this.executeQuery(sql.toString());
    }

    private String getBalanceSumSQL(boolean isAsstBal, int bwType, boolean isAccountTypeTotal) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.faccountid");
        if (isAccountTypeTotal && this.cond.isShowLeafAccount()) {
            sql.append(", t.fpTypeNum ");
        }
        if (this.isAllCurrency()) {
            sql.append(", t.fcurrencyid");
        }
        GLRptAccountBalQueryHelper helper = this.getQueryHelper();
        sql.append(helper.getAmountSelectSQL());
        sql.append(helper.getFromSQL(isAsstBal, this.getDataSourceTableName()));
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        sql.append(helper.getWhereSQL());
        if (bwType == 0 || bwType == 1) {
            sql.append(" and t.FBWType = ").append(bwType);
        }
        sql.append(" and ").append(" av.FIsLeaf = 1 ");
        if (!isAsstBal && this.cond.getDisplayAsstDetail() && this.cond.getOptionDCDispatchAsst() && (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode())) {
            sql.append(" and ((av.FCAA is null AND t.FIsAssist = 0 and (av.fisleaf = 1 or av.flevel = ").append(this.cond.getAccountLevelEnd()).append("))");
            sql.append(" or (av.FCAA is not null AND t.FIsAssist = 0 and av.FLevel = ").append(this.cond.getAccountLevelEnd()).append(" and av.FIsLeaf = 0)) ");
        }
        if (isAccountTypeTotal && this.cond.isShowLeafAccount()) {
            sql.append("group by t.fpTypeNum,t.faccountid");
        } else {
            sql.append(" group by t.faccountid");
        }
        if (this.isAllCurrency()) {
            sql.append(", t.fcurrencyid");
        }
        return sql.toString();
    }

    private void setAcountSumAmount(IRowSet rs, IGLRptRowData rowData) throws BOSException, SQLException, EASBizException {
        if (!rs.next()) {
            return;
        }
        ArrayList<String> colNames = new ArrayList<String>();
        boolean isNeedCompute = false;
        for (String colName : rowData.getColumKeys()) {
            if (!isNeedCompute && !colName.contains("FYearBeginDebit")) continue;
            colNames.add(colName);
            isNeedCompute = true;
        }
        for (int i = 0; i < colNames.size(); ++i) {
            rowData.updateBigDecimal((String)colNames.get(i), rs.getBigDecimal((String)colNames.get(i)));
        }
    }

    private boolean isAccounTypeTotal(IRowSet rs) throws SQLException {
        if (this.cond.isAccountTypeTotal()) {
            return rs.getString("FIsAccountTypeTotal") != null && rs.getInt("FIsAccountTypeTotal") == 1;
        }
        return false;
    }

    private boolean isAccountTotal(IRowSet rs) throws SQLException {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            return rs.getString("accountNumber") == null || rs.getString("accountNumber").trim().length() == 0;
        }
        if (this.cond.isAccountTypeTotal() && rs.getString("fpTypeNum") != null) {
            return false;
        }
        return rs.getString("FAccountID") == null || rs.getString("FAccountID").trim().length() == 0;
    }

    protected void setYearBegin(IRowSet rs, IGLRptRowData rowData) throws SQLException, BOSException, EASBizException, NumberFormatException {
        if (this.isShowFor()) {
            this.setYearBegin(rs, rowData, "For", "BalanceFor");
        }
        if (this.isShowLocal()) {
            this.setYearBegin(rs, rowData, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.setYearBegin(rs, rowData, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            String suffix;
            String string = this.isShowLocal() ? "Local" : (this.isShowFor() ? "For" : (suffix = this.isShowRpt() ? "Rpt" : "Local"));
            String balSuffix = this.isShowLocal() ? "BalanceLocal" : (this.isShowFor() ? "BalanceFor" : (this.isShowRpt() ? "BalanceRpt" : "BalanceLocal"));
            this.setQtyYearBegin(rs, rowData, suffix, balSuffix);
        }
    }

    private void setYearBegin(IRowSet rs, IGLRptRowData rowData, String suffix, String balSuffix) throws SQLException, EASBizException, BOSException {
        Object dc;
        BigDecimal amount = null;
        if (this.isYearQuery) {
            BigDecimal yearCredit;
            BigDecimal yearDebit;
            BigDecimal end = rs.getBigDecimal("FEnd" + balSuffix);
            if (end == null) {
                end = GlUtils.zero;
            }
            if ((yearDebit = rs.getBigDecimal("FYearDebit" + suffix)) == null) {
                yearDebit = GlUtils.zero;
            }
            if ((yearCredit = rs.getBigDecimal("FYearCredit" + suffix)) == null) {
                yearCredit = GlUtils.zero;
            }
            amount = end.subtract(yearDebit).add(yearCredit);
        } else {
            amount = rs.getBigDecimal("FYearBegin" + balSuffix);
        }
        if (amount == null) {
            amount = GlUtils.zero;
        }
        if ((dc = rs.getObject(GLRptField.accountDC.getName())) != null && this.cond.getRptParams().isBalanceDirSamAsAccount()) {
            if (new BigDecimal(dc.toString()).intValue() == 1) {
                rowData.updateBigDecimal("FYearBeginDebit" + balSuffix, amount);
            } else {
                rowData.updateBigDecimal("FYearBeginCredit" + balSuffix, amount.negate());
            }
        } else if (amount.doubleValue() < 0.0) {
            rowData.updateBigDecimal("FYearBeginCredit" + balSuffix, amount.negate());
        } else {
            rowData.updateBigDecimal("FYearBeginDebit" + balSuffix, amount);
        }
    }

    private void setQtyYearBegin(IRowSet rs, IGLRptRowData rowData, String suffix, String balSuffix) throws SQLException, EASBizException, BOSException {
        BigDecimal qtyYearCredit;
        BigDecimal qtyYearDebit;
        BigDecimal yearCredit;
        BigDecimal yearDebit;
        BigDecimal end = rs.getBigDecimal("FEnd" + balSuffix);
        if (end == null) {
            end = GlUtils.zero;
        }
        if ((yearDebit = rs.getBigDecimal("FYearDebit" + suffix)) == null) {
            yearDebit = GlUtils.zero;
        }
        if ((yearCredit = rs.getBigDecimal("FYearCredit" + suffix)) == null) {
            yearCredit = GlUtils.zero;
        }
        BigDecimal amount = end.subtract(yearDebit).add(yearCredit);
        BigDecimal endQty = rs.getBigDecimal("FEndQty");
        if (endQty == null) {
            endQty = GlUtils.zero;
        }
        if ((qtyYearDebit = rs.getBigDecimal("FYearDebitQty")) == null) {
            qtyYearDebit = GlUtils.zero;
        }
        if ((qtyYearCredit = rs.getBigDecimal("FYearCreditQty")) == null) {
            qtyYearCredit = GlUtils.zero;
        }
        BigDecimal qty = endQty.subtract(qtyYearDebit).add(qtyYearCredit);
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        if (dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount()) {
            if (new BigDecimal(dc.toString()).intValue() == 1) {
                rowData.updateBigDecimal("FYearBeginDebitQty", qty);
            } else {
                rowData.updateBigDecimal("FYearBeginCreditQty", qty.negate());
            }
        } else if (amount.doubleValue() < 0.0) {
            rowData.updateBigDecimal("FYearBeginCreditQty", qty.negate());
        } else {
            rowData.updateBigDecimal("FYearBeginDebitQty", qty);
        }
    }

    private void insertAccountBalance(String companyIds, int startYear, int startMonth) throws EASBizException, BOSException {
        boolean showExist = this.cond.isOptionAmountZero() || this.cond.getOptionYearAmountZero() || this.cond.isOptionAmountAndBalZero() || this.cond.getOptionYearAmountAndBalZero() || !this.cond.getAsstActList().isEmpty();
        StringBuffer sqlAccount = new StringBuffer();
        StringBuffer select = new StringBuffer();
        select.append(" select distinct AV.FID FAccountId");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            select.append(", AV.FNumber accountNumber");
            select.append(", AV.").append(this.getAccountName()).append(" accountName");
        }
        select.append(", 0 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            select.append(" ,AV.fbw FBWType, 0 FIsAccountBWSum ");
        }
        if (this.isAllCurrency()) {
            select.append(" ,isnull(TB.FCurrencyID,'").append(this.getCompany().getBaseCurrency().getId().toString()).append("') FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (this.cond.isAccountTypeTotal()) {
            select.append(" ,(case when charindex('!', type.FLONGNUMBER)=0 then type.FLONGNUMBER else  SUBSTRING(type.FLONGNUMBER, 0, charindex('!', type.FLONGNUMBER) - 1) end) fpTypeNum ");
            select.append(" ,(case when charindex('_', type.FDISPLAYNAME_l2)=0 then type.FDISPLAYNAME_l2 || '\u5c0f\u8ba1' else  SUBSTRING(type.FDISPLAYNAME_l2,0,charindex('_', type.FDISPLAYNAME_l2) - 1) || '\u5c0f\u8ba1' end) FpTypeName ");
            select.append(" ,0 FIsAccountTypeTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            select.append(",AV.FCompanyid forgunitid ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            select.append(",0 FIsAssist, ' ' FAssistGrpID ");
        }
        if (this.isShowQty()) {
            select.append(", MU.FID FMeasureUnitID");
            select.append(", MU.fname_").append(this.getContex().getLocale()).append(" measureUnit");
        }
        if (this.isCreateDataTempTable()) {
            this.addInsertSqlForCurrency("TB", select);
        }
        if (this.cond.getDisplayAsstDetail() && this.isWhrInAssitBalance && (this.cond.isOptionAmountAndBalZero() || this.cond.getOptionYearAmountAndBalZero()) || this.cond.isNotIncluePLVoucher()) {
            if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
                select.append(", isnull(TB.fdetailcount, 0) fdetailcount");
            } else if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
                select.append(", isnull(TB.fyeardetailcount, 0) fyeardetailcount");
            }
        }
        sqlAccount.append(select);
        sqlAccount.append(" from t_bd_accountview AV ");
        if (this.cond.isAccountTypeTotal()) {
            sqlAccount.append(" left join t_bd_accountType type on AV.FACCOUNTTYPEID = type.FID ");
        }
        sqlAccount.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID ");
        if (showExist) {
            sqlAccount.append(" inner join \t");
        } else {
            sqlAccount.append(" left outer join ");
        }
        sqlAccount.append("( ");
        sqlAccount.append(this.getAccountBalanceSQL(companyIds, startYear, startMonth));
        sqlAccount.append(") TB on AV.FID = TB.accountId ");
        sqlAccount.append(" WHERE AV.FAccountTableID = '").append(this.cond.getAccountTableId()).append("' ");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            if (this.cond.isShowLeafAccount()) {
                sqlAccount.append(" and av.fisleaf = 1 ");
            } else {
                sqlAccount.append(" and av.flevel <= ").append(this.cond.getAccountLevelEnd());
            }
        } else {
            sqlAccount.append(" and av.fisleaf = 1 ");
        }
        sqlAccount.append(" AND AV.FCompanyId in ").append(companyIds);
        if (!this.cond.getIncludeBWAccount()) {
            sqlAccount.append(" AND av.FBW = 0 ");
        }
        sqlAccount.append(" and 1 = 1 ");
        String accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "AV", "AV.FID", "AV.fcompanyid", false, true, this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr()).getSQL();
        if (accountFilter != null) {
            sqlAccount.append(" AND ").append(accountFilter);
        }
        if (!showExist && this.cond.isNeverUsed()) {
            sqlAccount.append(" and exists (select 1 from T_GL_AccountBalance_1L b");
            sqlAccount.append(" where b.forgunitid in ").append(companyIds);
            sqlAccount.append(" and b.faccountid = av.fid) ");
        }
        String sql = sqlAccount.toString();
        if (this.cond.isNotIncluePLVoucher()) {
            sql = this.getNotIncludePLVoucherSQL(sql, this.plVoucherTempTable);
            String where = this.buildAmountFilterSql("tpnl");
            if (!StringUtils.isEmpty((String)where)) {
                if (this.cond.getDisplayAsstDetail() && this.isWhrInAssitBalance && (this.cond.isOptionBalanceZero() || this.cond.isOptionAmountAndBalZero() || this.cond.getOptionYearAmountAndBalZero())) {
                    this.keepAssistToAccountBalance = true;
                    where = this.getAssistBalanceLimitSql(where, companyIds, startYear, startMonth, "tpnl");
                    this.keepAssistToAccountBalance = false;
                }
                sql = sql + where;
            }
        } else {
            String where = this.buildAmountFilterSql("TP");
            if (!StringUtils.isEmpty((String)where)) {
                if (this.cond.getDisplayAsstDetail() && this.isWhrInAssitBalance && (this.cond.isOptionBalanceZero() || this.cond.isOptionAmountAndBalZero() || this.cond.getOptionYearAmountAndBalZero())) {
                    this.keepAssistToAccountBalance = true;
                    String whereAssistBalanceZero = this.getAssistBalanceLimitSql(where, companyIds, startYear, startMonth, "TP");
                    this.keepAssistToAccountBalance = false;
                    sql = this.getSelectSqlDependOnTempTableFields("TP") + " from (" + sql + ") TP " + whereAssistBalanceZero;
                } else {
                    where = where.replaceAll("TP\\.", "TB.");
                    where = where.replaceFirst("where ", " and ");
                    sql = sql.replaceFirst(" and 1 = 1 ", where);
                }
            }
        }
        this.insertData(sql);
    }

    private String getSelectSqlDependOnTempTableFields(String tableName) throws EASBizException, BOSException {
        String[] fields = this.getTempTableFields();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select ");
        if (fields != null && fields.length > 0) {
            selectSql.append(tableName).append(".").append(fields[0]);
            for (int i = 1; i < fields.length; ++i) {
                selectSql.append(",").append(tableName).append(".").append(fields[i]);
            }
        }
        return selectSql.toString();
    }

    private String getAssistBalanceLimitSql(String where, String companyIds, int startYear, int startMonth, String prefix) throws EASBizException, BOSException {
        String whereIs;
        String avAlias;
        StringBuffer sqlAssist = new StringBuffer();
        sqlAssist.append(" select TB.FAccountID");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(", AV.Fnumber accountNumber, AV.").append(this.getAccountName()).append(" accountName");
        }
        sqlAssist.append(", 0 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sqlAssist.append(", AV.fbw FBWType, 0 FIsAccountBWSum ");
        }
        if (this.isCreateDataTempTable() && this.cond.isAccountTypeTotal()) {
            sqlAssist.append(", '' fpTypeNum, '' FpTypeName, 0 FIsAccountTypeTotal ");
        }
        if (this.isAllCurrency()) {
            sqlAssist.append(", TB.FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(", TB.FOrgUnitId ");
        }
        sqlAssist.append(", 1 FIsAssist, TB.FAssistGrpID FAssistGrpID");
        if (this.isShowQty()) {
            sqlAssist.append(", MU.FID FMeasureUnitID");
            sqlAssist.append(", MU.fname_").append(this.getContex().getLocale()).append(" measureUnit");
        }
        boolean isUnionQuery = CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode();
        String string = avAlias = isUnionQuery ? "TA" : "AV";
        if (this.isCreateDataTempTable()) {
            this.addInsertSqlForCurrency("TB", sqlAssist);
        }
        if (this.cond.isOptionAmountAndBalZero()) {
            sqlAssist.append(", TB.fdetailcount");
        } else if (this.cond.getOptionYearAmountAndBalZero()) {
            sqlAssist.append(", TB.fyeardetailcount");
        }
        sqlAssist.append(" FROM (").append(this.getAssistBalanceSQL(companyIds, startYear, startMonth)).append(") TB ");
        if (this.isShowQty() || this.cond.getIncludeBWAccount() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(" LEFT OUTER JOIN T_BD_AccountView AV ON AV.FID = TB.FAccountID ");
            if (isUnionQuery && this.isShowQty()) {
                sqlAssist.append(" LEFT OUTER JOIN T_BD_AccountView TA ON TA.FNumber = AV.FNumber AND TA.FAccountTableID = AV.FAccountTableID AND TA.FCompanyID = '").append(this.cond.getCompany().getId()).append("' ");
            }
        }
        if (this.isShowQty()) {
            sqlAssist.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = ").append(avAlias).append(".FMeasureUnitID ");
        }
        String sql = sqlAssist.toString();
        if (this.cond.isNotIncluePLVoucher()) {
            sql = this.getNotIncludePLVoucherSQL(sql, this.plVoucherTempTable);
        }
        if (!StringUtils.isEmpty((String)(whereIs = this.buildAmountFilterSql("tpnl".equals(prefix) ? prefix : "TPZeroBal")))) {
            sql = "tpnl".equals(prefix) ? sql + whereIs : "select TPZeroBal.* from (" + sql + ") TPZeroBal " + whereIs;
        }
        if (where.lastIndexOf("where") >= 0 && where.lastIndexOf(")") >= 0) {
            String whereOriginal = where.substring(where.lastIndexOf("(") + 1, where.indexOf(")", where.lastIndexOf("(")));
            whereOriginal = whereOriginal.replaceFirst("<>", "=");
            where = where.substring(0, where.lastIndexOf(")")) + " OR (" + whereOriginal + " and exists(select 1  from (select TEMPASSISTBALANCE.*  from (" + sql + ") TEMPASSISTBALANCE) T2  where T2.FACCOUNTID = " + prefix + ".FACCOUNTID " + (this.isAllCurrency() ? " AND T2.FCurrencyID = " + prefix + ".FCurrencyID" : "") + ")))";
        }
        return where;
    }

    private void insertAssistBalance(Set<String> companyIds, int startYear, int startMonth) throws EASBizException, BOSException {
        String avAlias;
        StringBuffer sqlAssist = new StringBuffer();
        sqlAssist.append(" select distinct TB.FAccountID");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(", AV.Fnumber accountNumber, AV.").append(this.getAccountName()).append(" accountName");
        }
        sqlAssist.append(", 0 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sqlAssist.append(", AV.fbw FBWType, 0 FIsAccountBWSum ");
        }
        if (this.isAllCurrency()) {
            sqlAssist.append(", TB.FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (this.cond.isAccountTypeTotal()) {
            sqlAssist.append(" ,(case when charindex('!', type.FLONGNUMBER)=0 then type.FLONGNUMBER else  SUBSTRING(type.FLONGNUMBER, 0, charindex('!', type.FLONGNUMBER) - 1) end) fpTypeNum ");
            sqlAssist.append(" ,(case when charindex('_', type.FDISPLAYNAME_l2)=0 then type.FDISPLAYNAME_l2 || '\u5c0f\u8ba1' else  SUBSTRING(type.FDISPLAYNAME_l2,0,charindex('_', type.FDISPLAYNAME_l2) - 1) || '\u5c0f\u8ba1' end) FpTypeName ");
            sqlAssist.append(" ,0 FIsAccountTypeTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sqlAssist.append(", TB.FOrgUnitId ");
        }
        sqlAssist.append(", 1 FIsAssist, TB.FAssistGrpID FAssistGrpID");
        if (this.isShowQty()) {
            sqlAssist.append(", MU.FID FMeasureUnitID");
            sqlAssist.append(", MU.fname_").append(this.getContex().getLocale()).append(" measureUnit");
        }
        boolean isUnionQuery = CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode();
        String string = avAlias = isUnionQuery ? "TA" : "AV";
        if (this.isCreateDataTempTable()) {
            this.addInsertSqlForCurrency("TB", sqlAssist);
        }
        if (this.cond.isNotIncluePLVoucher() && this.isWhrInAssitBalance) {
            if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
                sqlAssist.append(", TB.fdetailcount");
            } else if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
                sqlAssist.append(", TB.fyeardetailcount");
            }
        }
        sqlAssist.append(" FROM (").append(this.getAssistBalanceSQL(GLRptDaoUtil.getIdFilter(this.getContex(), companyIds), startYear, startMonth)).append(") TB ");
        if (this.isShowQty() || this.cond.getIncludeBWAccount() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || this.cond.isAccountTypeTotal()) {
            sqlAssist.append(" LEFT OUTER JOIN T_BD_AccountView AV ON AV.FID = TB.FAccountID ");
            if (isUnionQuery && this.isShowQty()) {
                sqlAssist.append(" LEFT OUTER JOIN T_BD_AccountView TA ON TA.FNumber = AV.FNumber AND TA.FAccountTableID = AV.FAccountTableID AND TA.FCompanyID = '").append(this.cond.getCompany().getId()).append("' ");
            }
        }
        if (this.cond.isAccountTypeTotal()) {
            sqlAssist.append(" left join t_bd_accountType type on AV.FACCOUNTTYPEID = type.FID ");
        }
        if (this.isShowQty()) {
            sqlAssist.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = ").append(avAlias).append(".FMeasureUnitID ");
        }
        sqlAssist.append(" where 2 = 2 ");
        String sql = sqlAssist.toString();
        if (this.cond.isNotIncluePLVoucher()) {
            sql = this.getNotIncludePLVoucherSQL(sql, this.plVoucherTempTable);
            String where = this.buildAmountFilterSql(" tpnl");
            if (!StringUtils.isEmpty((String)where) && this.isWhrInAssitBalance) {
                sql = sql + where;
            }
        } else {
            String where = this.buildAmountFilterSql("TB");
            if (!StringUtils.isEmpty((String)where) && this.isWhrInAssitBalance) {
                sql = sql.replaceFirst(" where 2 = 2 ", where);
            }
        }
        this.insertData(sql);
    }

    private String buildAmountFilterSql(String t) throws EASBizException, BOSException {
        StringBuffer str;
        String debit = this.isYearQuery ? "FYearDebit" : "FDebit";
        String credit = this.isYearQuery ? "FYearCredit" : "FCredit";
        StringBuffer where = new StringBuffer();
        if (this.cond.isOptionAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".").append(debit).append("For <> 0) OR (").append(t).append(".").append(credit).append("For <>0 ))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Local <> 0) OR (").append(t).append(".").append(credit).append("Local <>0 ))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Rpt <> 0) OR (").append(t).append(".").append(credit).append("Rpt <>0 ))");
            }
            str.append(" or ").append(t).append(".fDetailCount <> 0 ");
            where.append(" where (").append(str).append(" ) ");
        }
        if (this.cond.isOptionBalanceZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(where.length() == 0 ? " where " : " and ").append("(").append(str).append(") ");
        }
        if (this.cond.getOptionYearAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FYearDebitFor <> 0) OR (").append(t).append(".FYearCreditFor <>0 ))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitLocal <> 0) OR (").append(t).append(".FYearCreditLocal <>0 ))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitRpt <> 0) OR (").append(t).append(".FYearCreditRpt <>0 ))");
            }
            str.append(" or ").append(t).append(".fyearDetailCount <> 0");
            where.append(where.length() == 0 ? " where " : " and ").append("(").append(str).append(") ");
        }
        if (this.cond.isOptionAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".").append(debit).append("For <> 0) OR (").append(t).append(".").append(credit).append("For <> 0) OR (").append(t).append(".fDetailCount <> 0) OR (").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Local <> 0) OR (").append(t).append(".").append(credit).append("Local <> 0) OR (").append(t).append(".fDetailCount <> 0) OR (").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Rpt <> 0) OR (").append(t).append(".").append(credit).append("Rpt <> 0) OR (").append(t).append(".fDetailCount <> 0) OR (").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(where.length() == 0 ? " where " : " and ").append("(").append(str).append(") ");
        }
        if (this.cond.getOptionYearAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FYearDebitFor <> 0) OR (").append(t).append(".FYearCreditFor <>0 ) OR (").append(t).append(".fyearDetailCount <> 0) OR (").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitLocal <> 0) OR (").append(t).append(".FYearCreditLocal <>0 ) OR (").append(t).append(".fyearDetailCount <> 0) OR (").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FYearDebitRpt <> 0) OR (").append(t).append(".FYearCreditRpt <>0 ) OR (").append(t).append(".fyearDetailCount <> 0) OR (").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(where.length() == 0 ? " where " : " and ").append("(").append(str).append(") ");
        }
        return where.toString();
    }

    private String getAssistBalanceSQL(String companyIds, int startYear, int startMonth) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select b.faccountid");
        sql.append(", b.fassistgrpid ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(", b.forgunitid ");
        }
        if (this.isAllCurrency()) {
            sql.append(", b.fcurrencyid ");
        }
        if (this.isCreateDataTempTable()) {
            Integer startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
                sql.append(",sum(case when b.fperiod >=").append(startPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.fdetailcount").append(" else 0 end").append(") fdetailcount");
            }
            if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
                sql.append(",sum(case when b.fperiod >= ").append(this.cond.getPeriodYearEnd() * 100 + 1).append(" then b.fdetailcount").append(" else 0 end").append(") fyeardetailcount");
            }
            GLRptAccountBalQueryHelper helper = this.getQueryHelper();
            sql.append(helper.getAmountSelectSQL());
            sql.append(" from ").append(this.getAssistBalanceTable()).append(" b ");
            sql.append("\n inner join t_bd_assistAntHG assGrp on assGrp.FID=b.FAssistGrpID");
            sql.append(" inner join ").append(this.sysStatusTmpTable).append(" ssc on ssc.fcompanyid = b.forgunitid ");
        } else {
            sql.append(" from ").append(this.getAssistBalanceTable()).append(" b ");
            sql.append("\n inner join t_bd_assistAntHG assGrp on assGrp.FID=b.FAssistGrpID");
        }
        sql.append(" where b.forgunitid in ").append(companyIds);
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
            sql.append(" and ").append(this.getPeriodFilter(startYear, 1));
        } else {
            sql.append(" and ").append(this.getPeriodFilter(startYear, startMonth));
        }
        if (SQLUtil.isQueryByCurrency(this.cond)) {
            sql.append(" and b.fcurrencyid = '").append(this.cond.getCurrencyID()).append("'");
        }
        if (!this.isWhrInAssitBalance) {
            sql.append(" and (b.fdetailcount <> 0 ");
            if (this.cond.getCurrencyID().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                sql.append(" or b.fbeginbalancelocal <> 0 or b.fdebitlocal <> 0 or b.fcreditlocal <> 0 or");
                sql.append(" b.fyeardebitlocal <> 0 or b.fyearcreditlocal <> 0 or");
                sql.append(" b.fendbalancelocal <> 0 ");
            } else if (this.cond.getCurrencyID().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                sql.append(" or b.fbeginbalancerpt <> 0 or b.fdebitrpt <> 0 or b.fcreditrpt <> 0 or");
                sql.append(" b.fyeardebitrpt <> 0 or b.fyearcreditrpt <> 0 ");
            } else {
                sql.append(" or b.fbeginbalancefor <> 0 or  b.fbeginbalancelocal <> 0 or b.fbeginbalancerpt <> 0 or");
                sql.append(" b.fdebitfor <> 0 or b.fcreditfor <> 0 or b.fdebitlocal <> 0 or b.fcreditlocal <> 0 or b.fdebitrpt <> 0 or b.fcreditrpt <> 0 or");
                sql.append(" b.fyeardebitfor <> 0 or b.fyearcreditfor <> 0 or b.fyeardebitlocal <> 0 or b.fyearcreditlocal <> 0 or b.fyeardebitrpt <> 0 or b.fyearcreditrpt <> 0 or");
                sql.append(" b.fendbalancefor <> 0 or b.fendbalancelocal <> 0 ");
            }
            sql.append(") ");
        }
        if (this.cond.getDisplayAsstDetail() && !this.cond.getAsstActList().isEmpty()) {
            StringBuffer asstAccountFilter = new StringBuffer();
            Set asstAccountIdSet = this.cond.getAsstAccountIdSet();
            for (Object asstAccountId : asstAccountIdSet) {
                asstAccountFilter.append("'" + asstAccountId.toString() + "'").append(", ");
            }
            sql.append(" and assGrp.FAsstAccountID in ( ").append(asstAccountFilter.substring(0, asstAccountFilter.length() - 2)).append(") ");
            String asstLimitCondition = GLRptDaoUtil.getAsstLimitCondition(this.ctx, this.cond.getAsstActList());
            if (!asstLimitCondition.isEmpty()) {
                sql.append(" and b.FAssistGrpId in ( ").append(asstLimitCondition).append(" ) ");
            }
        }
        if (!this.keepAssistToAccountBalance) {
            sql.append(" and exists (select 1 from ").append(this.getDataSourceTableName()).append(" t where t.faccountid = b.faccountid ");
            if (this.isAllCurrency()) {
                sql.append(" and b.fcurrencyid = t.fcurrencyid ");
            }
            sql.append(") ");
        }
        this.addAsstDataPermissionFilter(sql);
        if (this.isCreateDataTempTable() || this.cond.getPeriodYearStart() != this.cond.getPeriodYearEnd() || this.cond.getPeriodNumberStart() != this.cond.getPeriodNumberEnd()) {
            sql.append(" group by b.faccountid ");
            if (this.isAllCurrency()) {
                sql.append(", b.fcurrencyid ");
            }
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                sql.append(", b.forgUnitid ");
            }
            sql.append(", b.fassistgrpid ");
        }
        return sql.toString();
    }

    protected boolean addAsstDataPermissionFilter(StringBuffer filter) throws EASBizException, BOSException {
        if (this.cond == null || !this.cond.getRptParams().useAccountPermission() || !this.cond.getDisplayAsstDetail()) {
            return false;
        }
        AsstAccountCollection asstAccountColl = this.getAsstAccountCollection();
        StringBuffer sql = new StringBuffer();
        boolean existPermSql = false;
        for (int m = 0; m < asstAccountColl.size(); ++m) {
            AsstAccountInfo caa = asstAccountColl.get(m);
            if (m > 0) {
                sql.append(" OR ");
            }
            sql.append("(");
            StringBuffer assgrpSql = new StringBuffer();
            this.addFilterItem(assgrpSql, "assGrp.FAsstAccountID = '" + caa.getId().toString() + "'");
            sql.append(assgrpSql);
            AsstActGroupDetailCollection detailColl = caa.getAsstActGpDt();
            for (int n = 0; n < detailColl.size(); ++n) {
                AsstActTypeInfo at = detailColl.get(n).getAsstActType();
                if (at.getPermissionItem() == null) continue;
                try {
                    String permSql;
                    String strPermItem = at.getPermissionItem();
                    boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU(this.cond.getCtx(), strPermItem);
                    String companyId = this.cond.getCompany().getId().toString();
                    if (isPermissionByCU) {
                        companyId = this.cond.getCompany().getCU().getId().toString();
                    }
                    if ((permSql = GLRptDaoUtil.getDataPermissionSQL(this.cond.getCtx(), companyId, at.getPermissionItem())) == null) continue;
                    this.addFilterItem(sql, "assGrp." + at.getMappingFieldName() + " in (" + permSql + ")");
                    existPermSql = true;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Get permission sql error!", (Throwable)e);
                }
            }
            sql.append(")");
        }
        if (existPermSql) {
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            filter.append("(").append(sql).append(")");
        }
        return existPermSql;
    }

    private AsstAccountCollection getAsstAccountCollection() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
        FilterInfo filter = new FilterInfo();
        StringBuffer accountIdSql = new StringBuffer();
        accountIdSql.append(" select lav.fid from t_bd_accountview lav ");
        accountIdSql.append(" inner join t_bd_accountview av on lav.fcompanyid = av.fcompanyid  ");
        accountIdSql.append(" and lav.faccounttableid = av.faccounttableid ");
        if (SQLUtil.isSupportCharIndexToLike(this.cond.getCtx())) {
            accountIdSql.append(" and (lav.flongnumber like concat(av.flongnumber, '!%') or av.fid = lav.fid)");
        } else {
            accountIdSql.append(" and (charindex(av.flongnumber||'!', lav.flongnumber) = 1 or av.fid = lav.fid)");
        }
        accountIdSql.append(" where av.fid in (").append("SELECT distinct FAccountID FROM ").append(this.getDataSourceTableName()).append(" where FIsAccountTotal =0 and FIsAssist = 0").append(")");
        accountIdSql.append(" and lav.fcaa is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIdSql.toString(), CompareType.INNER));
        view.setFilter(filter);
        AccountViewCollection accountColl = AccountViewFactory.getLocalInstance((Context)this.cond.getCtx()).getAccountViewCollection(view);
        AsstAccountCollection asstAccountColl = new AsstAccountCollection();
        for (int i = 0; i < accountColl.size(); ++i) {
            AsstAccountInfo caa = accountColl.get(i).getCAA();
            if (asstAccountColl.contains((Object)caa.getId())) continue;
            asstAccountColl.add(caa);
        }
        return asstAccountColl;
    }

    protected void addFilterItem(StringBuffer filters, String filterItem) {
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)filterItem)) {
            return;
        }
        if (filters.length() > 0) {
            filters.append(" AND ");
        }
        filters.append(filterItem);
    }

    private String getAccountBalanceSQL(String companyIds, int startYear, int startMonth) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select");
        if (StringUtils.isEmpty((String)this.cond.getAccountCodeStart()) && StringUtils.isEmpty((String)this.cond.getAccountCodeEnd())) {
            sql.append("/*+ INDEX(b ").append(this.getAccountBalanceIndexName()).append(")*/");
        }
        sql.append(" av.fid accountId ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(", b.forgunitid ");
        }
        if (this.isAllCurrency()) {
            sql.append(", b.fcurrencyid ");
        }
        if (this.isCreateDataTempTable()) {
            GLRptAccountBalQueryHelper helper = this.getQueryHelper();
            sql.append(helper.getAmountSelectSQL());
        }
        int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
            sql.append(",sum(case when b.fperiod >= ").append(startPeriod).append(" and b.fperiod >= ssc.fstartPeriod then b.fdetailcount").append(" else 0 end").append(") fdetailcount");
        }
        if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
            sql.append(",sum(case when b.fperiod >= ").append(this.cond.getPeriodYearEnd() * 100 + 1).append(" then b.fdetailcount").append(" else 0 end").append(") fyeardetailcount");
        }
        boolean isAsstFilter = !this.cond.getAsstActList().isEmpty();
        sql.append(" from ").append(isAsstFilter ? this.getAssistBalanceTable() : this.getAccountBalanceTable()).append(" b ");
        sql.append(" inner join t_bd_accountview av on av.fid = b.faccountid ");
        if (this.isCreateDataTempTable()) {
            sql.append(" inner join ").append(this.sysStatusTmpTable).append(" ssc on ssc.fcompanyid = b.forgunitid ");
        }
        if (isAsstFilter) {
            sql.append(" inner join T_BD_AssistantHG assGrp");
            sql.append(" ON assGrp.FID = b.FAssistGrpId ");
        }
        sql.append(" where b.forgunitid in ").append(companyIds);
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
            sql.append(" and ").append(this.getPeriodFilter(startYear, 1));
        } else {
            sql.append(" and ").append(this.getPeriodFilter(startYear, startMonth));
        }
        if (SQLUtil.isQueryByCurrency(this.cond)) {
            sql.append(" and b.fcurrencyid = '").append(this.cond.getCurrencyID()).append("'");
        }
        sql.append(" and av.faccounttableid = '").append(this.cond.getAccountTableId()).append("' ");
        sql.append(" and av.fcompanyid in ").append(companyIds);
        GLRptAccountFilter accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "av", "av.fid", "b.forgunitid", false, true, companyIds);
        accountFilter.setPermFilter(false);
        if (accountFilter.getSQL() != null) {
            sql.append(" and ").append(accountFilter.getSQL());
        }
        if (this.cond.isShowLeafAccount()) {
            if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(" and av.fisleaf = 1 ");
            }
        } else if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(" and av.flevel <= ").append(this.cond.getAccountLevelEnd());
        }
        if (isAsstFilter) {
            StringBuffer asstAccountFilter = new StringBuffer();
            Set asstAccountIdSet = this.cond.getAsstAccountIdSet();
            for (Object asstAccountId : asstAccountIdSet) {
                if (asstAccountFilter.length() > 0) {
                    asstAccountFilter.append(", ");
                }
                asstAccountFilter.append("'" + asstAccountId.toString() + "'");
            }
            sql.append(" and assGrp.FAsstAccountID in ( ").append(asstAccountFilter).append(") ");
            String asstLimitCondition = GLRptDaoUtil.getAsstLimitCondition(this.ctx, this.cond.getAsstActList());
            if (!asstLimitCondition.isEmpty()) {
                sql.append(" and b.FAssistGrpId in ( ").append(asstLimitCondition).append(" ) ");
            }
        }
        sql.append(" group by av.fid ");
        if (this.isAllCurrency()) {
            sql.append(" ,b.fcurrencyid ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(" ,b.forgUnitid ");
        }
        return sql.toString();
    }

    private String getAccountBalanceIndexName() {
        StringBuffer indexName = new StringBuffer();
        indexName.append("IX_GL_AC_");
        indexName.append(this.cond.getOptionPosting() ? "1" : "5");
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.cond.getCurrencyID())) {
            indexName.append("L");
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.cond.getCurrencyID())) {
            indexName.append("R");
        } else {
            indexName.append("F");
        }
        indexName.append("_AC1");
        return indexName.toString();
    }

    protected String getPeriodFilter(int startYear, int startMonth) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" b.fperiod in ");
        sql.append(SQLUtil.buildPeriodNumbersInSql(startYear, startMonth, this.cond.getPeriodYearEnd(), this.cond.getPeriodNumberEnd()));
        return sql.toString();
    }

    private void addInsertSqlForCurrency(String alias, StringBuffer sql) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            sql.append(", TB.FYearBeginQty");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FYearBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FYearBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FYearBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FBeginQty");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FDebitQty,0) FDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FDebitFor,0) FDebitFor ");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FDebitLocal,0) FDebitLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FDebitRpt,0) FDebitRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FCreditQty,0) FCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FCreditFor,0) FCreditFor ");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FCreditLocal,0) FCreditLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FCreditRpt,0) FCreditRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FYearDebitQty,0) FYearDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FYearDebitFor,0) FYearDebitFor ");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FYearDebitLocal,0) FYearDebitLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FYearDebitRpt,0) FYearDebitRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",isnull(TB.FYearCreditQty,0) FYearCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(",isnull(TB.FYearCreditFor,0) FYearCreditFor ");
        }
        if (this.isShowLocal()) {
            sql.append(",isnull(TB.FYearCreditLocal,0) FYearCreditLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(",isnull(TB.FYearCreditRpt,0) FYearCreditRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FEndQty");
        }
        if (this.isShowFor()) {
            sql.append(", isnull(TB.FEndBalanceFor, 0) FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(", isnull(TB.FEndBalanceLocal, 0) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(", isnull(TB.FEndBalanceRpt, 0) FEndBalanceRpt");
        }
    }

    protected void insertAccountSum(boolean isBW) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct ' ' FAccountID");
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.merger) {
            sql.append(", to_char(null) accountNumber");
        }
        sql.append(", 1 FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            if (isBW) {
                sql.append(" ,TP.FBWType ");
                sql.append(" ,1 FIsAccountBWSum ");
            } else {
                sql.append(" ,2 FBWType ");
                sql.append(" ,2 FIsAccountBWSum ");
            }
        }
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID, 0 FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.FOrgUnitID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",0 FIsAssist, ' ' FAssistGrpID ");
        }
        sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TP ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" where TP.FOrgUnitID is not null");
        }
        ArrayList params = new ArrayList();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("FAccountID");
        if (this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.merger) {
            fields.add("accountNumber");
        }
        fields.add("FIsAccountTotal");
        if (this.cond.getIncludeBWAccount()) {
            fields.add("FBWType");
            fields.add("FIsAccountBWSum");
        }
        if (this.isAllCurrency()) {
            fields.add("FCurrencyID");
            fields.add("FIsCurrencyTotal");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            fields.add("FOrgUnitID");
        }
        if (this.cond.getDisplayAsstDetail()) {
            fields.add("FIsAssist");
            fields.add("FAssistGrpID");
        }
        String[] fs = new String[fields.size()];
        this.insertData(fields.toArray(fs), sql.toString(), params);
    }

    protected void createPLVoucherTempTable() throws BOSException, EASBizException {
        Object asstLimitCondition;
        Set asstAccountIdSet;
        StringBuffer asstAccountFilter;
        String prefix;
        StringBuffer struct = new StringBuffer();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            struct.append("companyid varchar(44),");
        }
        struct.append("accountid varchar(44)");
        if (this.isAllCurrency()) {
            struct.append(",currencyid varchar(44)");
        }
        if (this.cond.getDisplayAsstDetail()) {
            struct.append(",hgid varchar(44)");
        }
        if (this.isShowFor()) {
            struct.append(",debitfor NUMERIC(28,10)");
            struct.append(",creditfor NUMERIC(28,10)");
            struct.append(",yeardebitfor NUMERIC(28,10)");
            struct.append(",yearcreditfor NUMERIC(28,10)");
        }
        if (this.isShowLocal()) {
            struct.append(",debitlocal NUMERIC(28,10)");
            struct.append(",creditlocal NUMERIC(28,10)");
            struct.append(",yeardebitlocal NUMERIC(28,10)");
            struct.append(",yearcreditlocal NUMERIC(28,10)");
        }
        if (this.isShowRpt()) {
            struct.append(",debitrpt NUMERIC(28,10)");
            struct.append(",creditrpt NUMERIC(28,10)");
            struct.append(",yeardebitrpt NUMERIC(28,10)");
            struct.append(",yearcreditrpt NUMERIC(28,10)");
        }
        if (this.isShowQty()) {
            struct.append(",debitqty NUMERIC(28,10)");
            struct.append(",creditqty NUMERIC(28,10)");
            struct.append(",yeardebitqty NUMERIC(28,10)");
            struct.append(",yearcreditqty NUMERIC(28,10)");
        }
        if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
            struct.append(",detailCount int DEFAULT 0");
        }
        if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
            struct.append(",yearDetailCount int DEFAULT 0");
        }
        StringBuffer indexStr = new StringBuffer();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            indexStr.append(" companyid,");
        }
        indexStr.append("accountid");
        if (this.isAllCurrency()) {
            indexStr.append(",currencyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            indexStr.append(",hgid ");
        }
        this.plVoucherTempTable = GLTempTableUtil.createDBSysTempTable(this.getContex(), struct.toString(), indexStr.toString());
        boolean isAsstFilter = !this.cond.getAsstActList().isEmpty();
        StringBuffer sql = new StringBuffer("select ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append("v.fcompanyid companyid,");
        }
        sql.append("ve.faccountid accountid");
        if (this.isAllCurrency()) {
            sql.append(",ve.fcurrencyid currencyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",' ' hgid ");
        }
        int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        String string = prefix = isAsstFilter ? "vr" : "ve";
        if (this.isShowFor()) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FOriginalAmount else 0 end)").append(" debitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FOriginalAmount else 0 end)").append(" creditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FOriginalAmount else 0 end) yeardebitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FOriginalAmount else 0 end) yearcreditfor ");
        }
        if (this.isShowLocal()) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FLocalAmount else 0 end) debitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FLocalAmount else 0 end) creditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FLocalAmount else 0 end) yeardebitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FLocalAmount else 0 end) yearcreditlocal ");
        }
        if (this.isShowRpt()) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FReportingAmount else 0 end) debitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FReportingAmount else 0 end) creditrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FReportingAmount else 0 end) yeardebitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FReportingAmount else 0 end) yearcreditrpt ");
        }
        if (this.isShowQty()) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FStandardQuantity else 0 end) debitqty ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ").append(prefix).append(".FStandardQuantity else 0 end) creditqty ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FStandardQuantity else 0 end) yeardebitqty ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then ").append(prefix).append(".FStandardQuantity else 0 end) yearcreditqty ");
        }
        if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
            sql.append(" ,sum(case when pd.FNumber >= ").append(startPeriod).append(" then 1 else 0 end) FDetailCount \n");
        } else if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
            sql.append(" ,sum(case when pd.FNumber >= ").append(this.cond.getPeriodYearEnd() * 100 + 1).append(" then 1 else 0 end) FYearDetailCount \n");
        }
        sql.append(" from t_gl_voucher v ");
        sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid ");
        if (isAsstFilter) {
            sql.append(" inner join t_gl_voucherassistrecord vr on vr.fbillid = v.fid and vr.fentryid = ve.fid ");
        }
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid ");
        ArrayList<Object> sp = new ArrayList<Object>();
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid ");
        sql.append(" where v.fbizstatus ").append(this.cond.getOptionPosting() ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and v.fcompanyid = ?");
            sp.add(this.getCompany().getId().toString());
        } else {
            sql.append(" and v.fcompanyid in ").append(this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr());
        }
        sql.append(" and av.faccounttableid = ? ");
        sp.add(this.cond.getAccountTableId());
        sql.append(" and av.fcompanyid in ").append(this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr());
        GLRptAccountFilter accountFilter = new GLRptAccountFilter(this.getContex(), this.cond, "av", "av.fid", "v.fcompanyid", false, true, this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr());
        accountFilter.setPermFilter(false);
        String accountFilterSQL = accountFilter.getSQL();
        if (accountFilterSQL != null) {
            sql.append(" and ").append(accountFilterSQL);
        }
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
            sp.add(this.cond.getPeriodYearStart() * 100 + 1);
        } else {
            sp.add(startPeriod);
        }
        sp.add(endPeriod);
        if (!(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || this.isAllCurrency())) {
            sql.append(" and ve.fcurrencyid = ?");
            sp.add(this.cond.getCurrencyID());
        }
        if (isAsstFilter) {
            asstAccountFilter = new StringBuffer();
            asstAccountIdSet = this.cond.getAsstAccountIdSet();
            for (Object asstAccountId : asstAccountIdSet) {
                asstAccountFilter.append("'" + asstAccountId.toString() + "'").append(", ");
            }
            sql.append(" and ve.FCAA in ( ").append(asstAccountFilter.substring(0, asstAccountFilter.length() - 2)).append(") ");
            asstLimitCondition = GLRptDaoUtil.getAsstLimitCondition(this.ctx, this.cond.getAsstActList());
            if (!((String)asstLimitCondition).isEmpty()) {
                sql.append(" and vr.FAssGrpId in ( ").append((String)asstLimitCondition).append(" ) ");
            }
        }
        sql.append(" group by ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append("v.fcompanyid,");
        }
        sql.append("ve.faccountid");
        if (this.isAllCurrency()) {
            sql.append(",ve.fcurrencyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(" union all ");
            sql.append(" select ");
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                sql.append("v.fcompanyid companyid,");
            }
            sql.append("ve.faccountid accountid");
            if (this.isAllCurrency()) {
                sql.append(",ve.fcurrencyid currencyid");
            }
            sql.append(",vr.fassgrpid hgid");
            if (this.isShowFor()) {
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FOriginalAmount else 0 end)").append(" debitfor ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FOriginalAmount else 0 end)").append(" creditfor ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FOriginalAmount else 0 end) yeardebitfor ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FOriginalAmount else 0 end) yearcreditfor ");
            }
            if (this.isShowLocal()) {
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FLocalAmount else 0 end) debitlocal ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FLocalAmount else 0 end) creditlocal ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FLocalAmount else 0 end) yeardebitlocal ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FLocalAmount else 0 end) yearcreditlocal ");
            }
            if (this.isShowRpt()) {
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FReportingAmount else 0 end) debitrpt ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FReportingAmount else 0 end) creditrpt ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FReportingAmount else 0 end) yeardebitrpt ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FReportingAmount else 0 end) yearcreditrpt ");
            }
            if (this.isShowQty()) {
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FStandardQuantity else 0 end) debitqty ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then vr.FStandardQuantity else 0 end) creditqty ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FStandardQuantity else 0 end) yeardebitqty ");
                sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fperiodyear = ").append(this.cond.getPeriodYearEnd()).append(" then vr.FStandardQuantity else 0 end) yearcreditqty ");
            }
            if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
                sql.append(" ,sum(case when pd.FNumber >= ").append(startPeriod).append(" then 1 else 0 end) detailCount \n");
            } else if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
                sql.append(" ,sum(case when pd.FNumber >= ").append(this.cond.getPeriodYearEnd() * 100 + 1).append(" then 1 else 0 end) yearDetailCount \n");
            }
            sql.append(" from t_gl_voucher v ");
            sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid ");
            sql.append(" inner join t_gl_voucherassistrecord vr on vr.fbillid = v.fid and vr.fentryid = ve.fid ");
            sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid ");
            sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid ");
            sql.append(" where v.fbizstatus ").append(this.cond.getOptionPosting() ? " in (1,3,5)" : "=5");
            sql.append(" and fsourcetype = ").append(1);
            if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
                sql.append(" and v.fcompanyid = ?");
                sp.add(this.getCompany().getId().toString());
            } else {
                sql.append(" and v.fcompanyid in ").append(this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr());
            }
            sql.append(" and av.faccounttableid = ? ");
            sp.add(this.cond.getAccountTableId());
            sql.append(" and av.fcompanyid in ").append(this.isUseGL053 ? this.companyIdsWithGL053 : this.cond.getCompanyIdsStr());
            if (accountFilterSQL != null) {
                sql.append(" and ").append(accountFilterSQL);
            }
            sql.append(" and pd.ftypeid = ?");
            sp.add(this.cond.getPeriodTypeId());
            sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
            if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd()) {
                sp.add(this.cond.getPeriodYearStart() * 100 + 1);
            } else {
                sp.add(startPeriod);
            }
            sp.add(endPeriod);
            if (!(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) || this.isAllCurrency())) {
                sql.append(" and ve.fcurrencyid = ?");
                sp.add(this.cond.getCurrencyID());
            }
            if (isAsstFilter) {
                asstAccountFilter = new StringBuffer();
                asstAccountIdSet = this.cond.getAsstAccountIdSet();
                for (Object asstAccountId : asstAccountIdSet) {
                    asstAccountFilter.append("'" + asstAccountId.toString() + "'").append(", ");
                }
                sql.append(" and ve.FCAA in ( ").append(asstAccountFilter.substring(0, asstAccountFilter.length() - 2)).append(") ");
                asstLimitCondition = GLRptDaoUtil.getAsstLimitCondition(this.ctx, this.cond.getAsstActList());
                if (!((String)asstLimitCondition).isEmpty()) {
                    sql.append(" and vr.FAssGrpId in ( ").append((String)asstLimitCondition).append(" ) ");
                }
            }
            sql.append(" group by ");
            if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                sql.append("v.fcompanyid,");
            }
            sql.append("ve.faccountid,");
            if (this.isAllCurrency()) {
                sql.append("ve.fcurrencyid,");
            }
            sql.append("vr.fassgrpid");
        }
        try {
            DbUtil.execute((Context)this.getContex(), (String)("insert into " + this.plVoucherTempTable + " " + sql), (Object[])sp.toArray());
            if (!this.cond.isShowLeafAccount() || CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
                this.insertPLAccountSum(this.plVoucherTempTable);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Execute select into failed.(" + sql + ")"), (Throwable)e);
            throw new BOSException("Error sql: " + sql, (Throwable)e);
        }
    }

    private void insertPLAccountSum(String plTempTable) throws BOSException, EASBizException, SQLException {
        int maxLevel = this.getMaxPLAccountLevel(plTempTable);
        StringBuffer accountSum = new StringBuffer(" select ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            accountSum.append("t.companyid companyid,");
        }
        accountSum.append("av.fid accountid");
        if (this.isAllCurrency()) {
            accountSum.append(",t.currencyid currencyid ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            accountSum.append(",' ' hgid ");
        }
        if (this.isShowFor()) {
            accountSum.append(" ,sum(debitfor) debitfor ");
            accountSum.append(" ,sum(creditfor) creditfor ");
            accountSum.append(" ,sum(yeardebitfor) yeardebitfor ");
            accountSum.append(" ,sum(yearcreditfor) yearcreditfor ");
        }
        if (this.isShowLocal()) {
            accountSum.append(" ,sum(debitlocal) debitlocal ");
            accountSum.append(" ,sum(creditlocal) creditlocal ");
            accountSum.append(" ,sum(yeardebitlocal) yeardebitlocal ");
            accountSum.append(" ,sum(yearcreditlocal) yearcreditlocal ");
        }
        if (this.isShowRpt()) {
            accountSum.append(" ,sum(debitrpt) debitrpt ");
            accountSum.append(" ,sum(creditrpt) creditrpt ");
            accountSum.append(" ,sum(yeardebitrpt) yeardebitrpt ");
            accountSum.append(" ,sum(yearcreditrpt) yearcreditrpt ");
        }
        if (this.isShowQty()) {
            accountSum.append(" ,sum(debitqty) debitqty ");
            accountSum.append(" ,sum(creditqty) creditqty ");
            accountSum.append(" ,sum(yeardebitqty) yeardebitqty ");
            accountSum.append(" ,sum(yearcreditqty) yearcreditqty ");
        }
        if (this.cond.isOptionAmountZero() || this.cond.isOptionAmountAndBalZero()) {
            accountSum.append(" ,sum(detailcount) detailcount");
        } else if (this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero()) {
            accountSum.append(" ,sum(yeardetailcount) yeardetailcount");
        }
        accountSum.append(" from ").append(plTempTable).append(" t ");
        accountSum.append(" inner join t_bd_accountview lav on lav.fid = t.accountid ");
        accountSum.append(" inner join t_bd_accountview av on av.fid = lav.fparentid ");
        accountSum.append(" where lav.flevel = ? ");
        if (this.cond.getDisplayAsstDetail()) {
            accountSum.append(" and t.hgid = ' ' ");
        }
        accountSum.append(" group by ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            accountSum.append("t.companyid,");
        }
        accountSum.append("av.fid");
        if (this.isAllCurrency()) {
            accountSum.append(",t.currencyid ");
        }
        while (maxLevel > 1) {
            this.execute("insert into " + plTempTable + accountSum, new Object[]{maxLevel});
            --maxLevel;
        }
    }

    private int getMaxPLAccountLevel(String plBalanceTable) throws BOSException, SQLException, EASBizException {
        int maxLevel = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(av.flevel) maxLevel from ").append(plBalanceTable).append(" temp ");
        sql.append(" inner join t_bd_accountview av on av.fid = temp.accountid ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" and av.fcompanyid = temp.companyid ");
        }
        IRowSet rs = this.executeQuery(sql.toString());
        while (rs.next()) {
            maxLevel = rs.getInt("maxLevel");
        }
        return maxLevel;
    }

    protected String getNotIncludePLVoucherSQL(String sqlToBeExcute, String plVoucherTempTable) throws BOSException, EASBizException {
        StringBuilder tempSql = new StringBuilder();
        StringBuffer selectSql = new StringBuffer();
        tempSql.append(" select tpnl.* from (");
        tempSql.append(" select balTable.FAccountID");
        selectSql.append("tpnl.FAccountID");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            tempSql.append(",balTable.accountNumber, balTable.accountName");
            selectSql.append(", tpnl.accountNumber, tpnl.accountName");
        }
        tempSql.append(", balTable.FIsAccountTotal ");
        selectSql.append(", tpnl.FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            tempSql.append(" ,balTable.FBWType ");
            selectSql.append(" ,tpnl.FBWType ");
            tempSql.append(" ,balTable.FIsAccountBWSum ");
            selectSql.append(" ,tpnl.FIsAccountBWSum ");
        }
        if (this.cond.isAccountTypeTotal()) {
            tempSql.append(", balTable.fpTypeNum ");
            selectSql.append(" ,tpnl.fpTypeNum ");
            tempSql.append(", balTable.FpTypeName ");
            selectSql.append(" ,tpnl.FpTypeName ");
            tempSql.append(", balTable.FIsAccountTypeTotal ");
            selectSql.append(" ,tpnl.FIsAccountTypeTotal ");
        }
        if (this.isAllCurrency()) {
            tempSql.append(",balTable.FCurrencyID ");
            tempSql.append(",balTable.FIsCurrencyTotal ");
            selectSql.append(",tpnl.FCurrencyID ");
            selectSql.append(",tpnl.FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            tempSql.append(",balTable.FOrgUnitID ");
            selectSql.append(",tpnl.FOrgUnitID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            tempSql.append(",balTable.FIsAssist ");
            tempSql.append(",balTable.FAssistGrpID ");
            selectSql.append(",tpnl.FIsAssist ");
            selectSql.append(",tpnl.FAssistGrpID ");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FMeasureUnitID \r\n");
            tempSql.append(", balTable.measureUnit \r\n");
            tempSql.append(", balTable.FYearBeginQty ");
            selectSql.append(", tpnl.FMeasureUnitID \r\n");
            selectSql.append(", tpnl.measureUnit \r\n");
            selectSql.append(", tpnl.FYearBeginQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FYearBeginBalanceFor\t");
            selectSql.append(", tpnl.FYearBeginBalanceFor ");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FYearBeginBalanceLocal ");
            selectSql.append(", tpnl.FYearBeginBalanceLocal\t");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FYearBeginBalanceRpt\t");
            selectSql.append(", tpnl.FYearBeginBalanceRpt ");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FBeginQty ");
            selectSql.append(", tpnl.FBeginQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FBeginBalanceFor\t");
            selectSql.append(", tpnl.FBeginBalanceFor ");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FBeginBalanceLocal ");
            selectSql.append(", tpnl.FBeginBalanceLocal\t");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FBeginBalanceRpt\t");
            selectSql.append(", tpnl.FBeginBalanceRpt ");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FDebitQty - isnull(plBalTable.DebitQty,0) FDebitQty ");
            selectSql.append(", tpnl.FDebitQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FDebitFor - isnull(plBalTable.DebitFor,0) FDebitFor");
            selectSql.append(", tpnl.FDebitFor");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FDebitLocal - isnull(plBalTable.DebitLocal,0) FDebitLocal");
            selectSql.append(", tpnl.FDebitLocal");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FDebitRpt - isnull(plBalTable.DebitRpt,0) FDebitRpt");
            selectSql.append(", tpnl.FDebitRpt");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FCreditQty - isnull(plBalTable.CreditQty,0) FCreditQty ");
            selectSql.append(", tpnl.FCreditQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FCreditFor - isnull(plBalTable.CreditFor,0) FCreditFor ");
            selectSql.append(", tpnl.FCreditFor ");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FCreditLocal - isnull(plBalTable.CreditLocal,0) FCreditLocal ");
            selectSql.append(", tpnl.FCreditLocal ");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FCreditRpt - isnull(plBalTable.CreditRpt,0) FCreditRpt ");
            selectSql.append(", tpnl.FCreditRpt ");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FYearDebitQty - isnull(plBalTable.YearDebitQty,0) FYearDebitQty ");
            selectSql.append(", tpnl.FYearDebitQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FYearDebitFor - isnull(plBalTable.YearDebitFor,0) FYearDebitFor");
            selectSql.append(", tpnl.FYearDebitFor");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FYearDebitLocal - isnull(plBalTable.YearDebitLocal,0) FYearDebitLocal");
            selectSql.append(", tpnl.FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FYearDebitRpt - isnull(plBalTable.YearDebitRpt,0) FYearDebitRpt");
            selectSql.append(", tpnl.FYearDebitRpt");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FYearCreditQty - isnull(plBalTable.YearCreditQty,0) FYearCreditQty ");
            selectSql.append(", tpnl.FYearCreditQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FYearCreditFor - isnull(plBalTable.YearCreditFor,0) FYearCreditFor\t");
            selectSql.append(", tpnl.FYearCreditFor\t");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FYearCreditLocal - isnull(plBalTable.YearCreditLocal,0) FYearCreditLocal ");
            selectSql.append(", tpnl.FYearCreditLocal ");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FYearCreditRpt - isnull(plBalTable.YearCreditRpt,0) FYearCreditRpt ");
            selectSql.append(", tpnl.FYearCreditRpt ");
        }
        if (this.isShowQty()) {
            tempSql.append(", balTable.FEndQty + isnull(plBalTable.CreditQty,0) - isnull(plBalTable.DebitQty, 0) FEndQty ");
            selectSql.append(", tpnl.FEndQty ");
        }
        if (this.isShowFor()) {
            tempSql.append(", balTable.FEndBalanceFor + isnull(plBalTable.CreditFor,0) - isnull(plBalTable.DebitFor,0) FEndBalanceFor ");
            selectSql.append(", tpnl.FEndBalanceFor ");
        }
        if (this.isShowLocal()) {
            tempSql.append(", balTable.FEndBalanceLocal + isnull(plBalTable.CreditLocal,0) - isnull(plBalTable.DebitLocal,0) FEndBalanceLocal ");
            selectSql.append(", tpnl.FEndBalanceLocal ");
        }
        if (this.isShowRpt()) {
            tempSql.append(", balTable.FEndBalanceRpt + isnull(plBalTable.CreditRpt,0) - isnull(plBalTable.DebitRpt,0) FEndBalanceRpt ");
            selectSql.append(", tpnl.FEndBalanceRpt ");
        }
        if (sqlToBeExcute.contains("TB.fdetailcount")) {
            tempSql.append(", balTable.fdetailcount - isnull(plBalTable.detailcount,0) fdetailcount");
        }
        if (sqlToBeExcute.contains("TB.fyeardetailcount")) {
            tempSql.append(", balTable.fyeardetailcount - isnull(plBalTable.yeardetailcount,0) fyeardetailcount ");
        }
        tempSql.append(" from (").append(sqlToBeExcute).append(") balTable ");
        tempSql.append(" left outer join ").append(plVoucherTempTable).append(" plBalTable on balTable.FAccountID = plBalTable.accountID ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            tempSql.append(" and balTable.forgunitid = plBalTable.companyid");
        }
        if (this.cond.getDisplayAsstDetail()) {
            tempSql.append(" and balTable.FAssistGrpID = plBalTable.hgid ");
        }
        if (this.isAllCurrency()) {
            tempSql.append(" and balTable.fcurrencyid = plBalTable.currencyid ");
        }
        tempSql.append(") tpnl ");
        return tempSql.toString().replace("tpnl.*", selectSql);
    }

    protected void insertCurrencySum() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FAccountID");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(", TP.accountNumber, TP.accountName");
        }
        sql.append(", TP.FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sql.append(" ,TP.FBWType ");
            sql.append(" ,TP.FIsAccountBWSum ");
        }
        sql.append(",' ' FCurrencyID, 1 FIsCurrencyTotal ");
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.FOrgUnitID ");
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",0 FIsAssist,' ' FAssistGrpID ");
        }
        if (this.isShowQty()) {
            sql.append(", '' FMeasureUnitID ");
            sql.append(", '' measureUnit ");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FYearBeginQty) FYearBeginQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FYearBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FYearBeginBalanceLocal,0)) FYearBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FYearBeginBalanceRpt,0)) FYearBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FBeginQty) FBeginQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FBeginBalanceLocal,0)) FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FBeginBalanceRpt,0)) FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FDebitQty) FDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FDebitLocal,0)) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FDebitRpt,0)) FDebitRPT");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FCreditQty) FCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FCreditLocal,0)) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FCreditRpt,0)) FCreditRPT");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FYearDebitQty) FYearDebitQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FYearDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FYearDebitLocal,0)) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FYearDebitRpt,0)) FYearDebitRPT");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FYearCreditQty) FYearCreditQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FYearCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FYearCreditLocal,0)) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FYearCreditRpt,0)) FYearCreditRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",SUM(FEndQty) FEndQty");
        }
        if (this.isShowFor()) {
            sql.append(",0 FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(ISNULL(FEndBalanceLocal,0)) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(ISNULL(FEndBalanceRpt,0)) FEndBalanceRpt");
        }
        sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TP ");
        if (this.isAllCurrency()) {
            sql.append(" where TP.FCurrencyID is not null ");
        }
        sql.append(" group by TP.FIsAccountTotal, TP.FAccountID ");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(", TP.accountNumber, TP.accountName");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(",TP.FOrgUnitID ");
        }
        if (this.cond.getIncludeBWAccount()) {
            sql.append(",TP.FBWType,TP.FIsAccountBWSum ");
        }
        this.insertData(sql.toString());
    }

    protected void insertCompanySum() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(" '' FAccountID, TP.accountNumber, TP.accountName");
        } else {
            sql.append(" case when PAV.FID is null then max(AV.FID) else PAV.FID end FAccountID");
        }
        sql.append(", TP.FIsAccountTotal ");
        if (this.cond.getIncludeBWAccount()) {
            sql.append(" ,TP.FBWType ");
            sql.append(" ,TP.FIsAccountBWSum ");
        }
        if (this.cond.isAccountTypeTotal()) {
            sql.append(" ,TP.fpTypeNum ");
            sql.append(" ,TP.FpTypeName ");
            sql.append(" ,TP.FIsAccountTypeTotal ");
        }
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID, TP.FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(",'").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(", '").append(this.cond.getCompany().getId().toString()).append("'");
        } else if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        sql.append(" FOrgUnitID ");
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(",0 FIsAssist,' ' FAssistGrpID ");
        }
        if (this.isShowQty()) {
            sql.append(", '' FMeasureUnitID ");
            sql.append(", '' measureUnit ");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearBeginQty");
            } else {
                sql.append(",sum(FYearBeginQty) FYearBeginQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearBeginBalanceFor) FYearBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearBeginBalanceLocal) FYearBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearBeginBalanceRpt) FYearBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FBeginQty");
            } else {
                sql.append(",sum(FBeginQty) FBeginQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FBeginBalanceFor) FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FBeginBalanceLocal) FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FBeginBalanceRpt) FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FDebitQty");
            } else {
                sql.append(",sum(FDebitQty) FDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FDebitFor) FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FDebitLocal) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FDebitRpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FCreditQty");
            } else {
                sql.append(",sum(FCreditQty) FCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FCreditFor) FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FCreditLocal) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FCreditRpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearDebitQty");
            } else {
                sql.append(",sum(FYearDebitQty) FYearDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearDebitFor) FYearDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearDebitLocal) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearDebitRpt) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearCreditQty");
            } else {
                sql.append(",sum(FYearCreditQty) FYearCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearCreditFor) FYearCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearCreditLocal) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearCreditRpt) FYearCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FEndQty");
            } else {
                sql.append(",sum(FEndQty) FEndQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FEndBalanceFor) FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FEndBalanceLocal) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FEndBalanceRpt) FEndBalanceRpt");
        }
        sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TP ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" inner join t_org_company cp on cp.fid = tp.forgunitid ");
        }
        if (CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode()) {
            sql.append(" left outer join t_bd_accountview AV on AV.fid = TP.FAccountID ");
            sql.append(" left outer join t_bd_accountview PAV on AV.FNumber = PAV.FNumber and AV.FAccountTableID = PAV.FAccountTableID ");
            if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
                sql.append(" and PAV.FCompanyID = cp.FParentID ");
            } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
                sql.append(" and PAV.FCompanyID = '").append(this.cond.getCompany().getId().toString()).append("'");
            }
        }
        if (this.cond.isAccountTypeTotal()) {
            sql.append(" left join t_bd_accountType type on AV.FACCOUNTTYPEID = type.FID ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" where cp.flevel = ? ");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" where TP.Forgunitid is not null ");
        }
        sql.append(" group by ");
        if (this.cond.isAccountTypeTotal()) {
            sql.append("  TP.FpTypeNum ");
            sql.append(", TP.FpTypeName ");
            sql.append(", TP.FIsAccountTypeTotal,");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append("TP.accountNumber, TP.accountName");
        } else {
            sql.append("PAV.FID, av.FNumber");
        }
        sql.append(", TP.FIsAccountTotal ");
        if (this.isAllCurrency()) {
            sql.append(",TP.FCurrencyID, TP.FIsCurrencyTotal ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        if (this.cond.getIncludeBWAccount()) {
            sql.append(",TP.FBWType,TP.FIsAccountBWSum ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            int maxLevel;
            for (int i = maxLevel = this.getMaxCompanyLevel(); i > this.getCompany().getLevel(); --i) {
                ArrayList<Integer> sp = new ArrayList<Integer>();
                sp.add(new Integer(i));
                this.insertData(sql.toString(), sp);
            }
        } else if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            this.insertData(sql.toString());
        }
    }

    protected void insertAccountTypeSum() throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            fields.add("fisAccounttotal");
            fields.add("fpTypeNum");
            fields.add("FpTypeName");
            fields.add("FIsAccountTypeTotal");
            fields.add("ForgUnitId");
            sql.append(" select ");
            sql.append(" 0 fisAccounttotal, ");
            sql.append(" t.fpTypeNum, ");
            sql.append(" t.FpTypeName, ");
            sql.append(" 1 FIsAccountTypeTotal, ");
            sql.append(" t.ForgUnitId ");
            sql.append(" from  ");
            sql.append(this.getDataSourceTableName()).append(" t ").append(" left join T_BD_AccountView av ");
            sql.append(" on t.FAccountID = av.fid ");
            sql.append(" where t.fpTypeNum is not null and t.fisAccounttotal <> 1 ");
            sql.append(" group by t.ForgUnitId,t.fpTypeNum,t.FpTypeName ");
        } else {
            fields.add("fisAccounttotal");
            fields.add("fpTypeNum");
            fields.add("FpTypeName");
            fields.add("FIsAccountTypeTotal");
            sql.append(" select ");
            sql.append(" 0 fisAccounttotal, ");
            sql.append(" t.fpTypeNum, ");
            sql.append(" t.FpTypeName, ");
            sql.append(" 1 FIsAccountTypeTotal ");
            sql.append(" from  ");
            sql.append(this.getDataSourceTableName()).append(" t ").append(" left join T_BD_AccountView av ");
            sql.append(" on t.FAccountID = av.fid ");
            sql.append(" where t.fpTypeNum is not null and t.fisAccounttotal <> 1 ");
            sql.append(" group by t.fpTypeNum,t.FpTypeName ");
        }
        this.insertData(fields.toArray(new String[0]), sql.toString());
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() || this.cond.isAllCurrency() || this.cond.isNotIncluePLVoucher() || this.cond.getIncludeBWAccount() || this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart() > this.cond.getCurrPeriod().getNumber() || this.cond.isAfterCurrPeriod() || this.cond.isOptionAmountZero() || this.cond.isOptionBalanceZero() || this.cond.getOptionYearAmountZero() || this.cond.getOptionYearAmountAndBalZero() || this.cond.isOptionAmountAndBalZero() || this.cond.getOptionDCDispatchAsst() || !this.cond.getAsstActList().isEmpty() || !this.cond.isShowLeafAccount();
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAccountBalPageQuery(this.getContex(), this.cond, this.isCreateDataTempTable(), this.getQueryHelper());
    }

    @Override
    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        GLRptTableHeadInfo headInfo = new GLRptTableHeadInfo();
        this.addTableHeadColumn(headInfo, new GLRptField("KSQL_SEQ", "INT"));
        if (!this.isCreateSeqTable()) {
            this.addTableHeadColumn(headInfo, new GLRptField("SQL_BATCH", "INT"));
        }
        GLRptSelector selector = this.getGLRptSelector();
        if (this.getGLRptSelector() == null) {
            return headInfo;
        }
        Iterator<GLRptField> it = selector.iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    this.addTableHeadCreditColumn(headInfo, (GLRptField)creditList.get(i));
                }
                creditList.clear();
            }
            if (field.isYearBegin()) {
                creditList.add(field);
                lastPrefix = "FYearBegin";
            } else if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.addTableHeadColumn(headInfo, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                this.addTableHeadCreditColumn(headInfo, (GLRptField)creditList.get(i));
            }
            creditList.clear();
        }
        headInfo.setHeadTitle(this.getHeadTitles());
        return headInfo;
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = !this.cond.isShowQty() && this.isSingleAmountFiled() ? new String[][]{this.getTitleRow1(), this.getTitleRow2()} : new String[][]{this.getTitleRow1(), this.getTitleRow2(), this.getTitleRow3()};
        return titles;
    }

    protected void addTableHeadCreditColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        String prefix = null;
        if (field.isYearBegin()) {
            prefix = "FYearBegin";
        } else if (field.isBegin()) {
            prefix = "FBegin";
        } else if (field.isEnd()) {
            prefix = "FEnd";
        }
        GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
        colInfo.setNumeral(true);
        colInfo.setColName(prefix + "Credit" + field.getBalSuffix());
        colInfo.setWidth(field.getLength());
        if (field.isQty()) {
            colInfo.setScale(this.cond.getQtyScale());
        } else {
            CurrencyInfo currency = this.getQueryCurrencyInfo();
            if (currency != null && field.getName().endsWith("For")) {
                colInfo.setScale(currency.getPrecision());
            } else if (field.getName().endsWith("Local")) {
                colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
            } else if (this.getCompany().getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                colInfo.setScale(this.getCompany().getReportCurrency().getPrecision());
            }
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field.isYearBegin() || field.isBegin() || field.isEnd()) {
            String prefix = null;
            if (field.isYearBegin()) {
                prefix = "FYearBegin";
            } else if (field.isBegin()) {
                prefix = "FBegin";
            } else if (field.isEnd()) {
                prefix = "FEnd";
            }
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setNumeral(true);
            colInfo.setColName(prefix + "Debit" + field.getBalSuffix());
            colInfo.setWidth(field.getLength());
            if (field.isQty()) {
                colInfo.setScale(this.cond.getQtyScale());
            } else {
                CurrencyInfo currency = this.getQueryCurrencyInfo();
                if (currency != null && field.getName().endsWith("For")) {
                    colInfo.setScale(currency.getPrecision());
                } else if (field.getName().endsWith("Local")) {
                    colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
                } else if (this.getCompany().getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                    colInfo.setScale(this.getCompany().getReportCurrency().getPrecision());
                }
            }
            if (this.getFreezeField() == field) {
                colInfo.setFreeze(true);
            }
        } else if (GLRptField.findAsstName == field) {
            for (int i = 0; i < this.findAssistCount; ++i) {
                GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
                colInfo.setColName("FAsstAccountName" + i);
                colInfo.setWidth(120);
            }
        } else if (GLRptField.HGName == field) {
            for (int i = this.findAssistCount; i < this.maxAssistCount; ++i) {
                GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
                colInfo.setColName("FAsstAccountName" + i);
                colInfo.setWidth(i >= this.assistCount ? -1 : 120);
            }
        } else if (GLRptField.accountDC == field) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setWidth(-1);
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field.isYearBegin() || field.isBegin() || field.isEnd()) {
            colTitles.add(field.getTitle());
            colTitles.add(field.getTitle());
        } else if (field.isDebit() || field.isCredit()) {
            colTitles.add("period_happened");
        } else if (field.isYearDebit() || field.isYearCredit()) {
            colTitles.add("sum_year");
        } else if (GLRptField.findAsstName == field) {
            for (int i = 0; i < this.findAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (GLRptField.HGName == field) {
            for (int i = this.findAssistCount; i < this.maxAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else {
            colTitles.add(field.getTitle());
        }
    }

    @Override
    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    colTitles.add("dir_credit");
                }
                creditList.clear();
            }
            if (field.isYearBegin()) {
                creditList.add(field);
                lastPrefix = "FYearBegin";
            } else if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.setRow2Title(colTitles, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                colTitles.add("dir_credit");
            }
            creditList.clear();
        }
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.isYearBegin() || field.isBegin() || field.isEnd()) {
            colTitles.add("dir_debit");
        } else if (GLRptField.findAsstName == field) {
            for (int i = 0; i < this.findAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (GLRptField.HGName == field) {
            for (int i = this.findAssistCount; i < this.maxAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (field.isYearDebit()) {
            colTitles.add("dir_debit");
        } else if (field.isYearCredit()) {
            colTitles.add("dir_credit");
        } else {
            colTitles.add(field.getTitle());
        }
    }

    protected String[] getTitleRow3() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    this.setRow3Title(colTitles, (GLRptField)creditList.get(i));
                }
                creditList.clear();
            }
            if (field.isYearBegin()) {
                creditList.add(field);
                lastPrefix = "FYearBegin";
            } else if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.setRow3Title(colTitles, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                this.setRow3Title(colTitles, (GLRptField)creditList.get(i));
            }
            creditList.clear();
        }
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void setRow3Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.getType() == "NUMERIC(29,10)") {
            if (field.isQty()) {
                colTitles.add("asst_quantity");
            } else if (this.isSingleAmountFiled()) {
                colTitles.add("money_amount");
            } else if (field.getName().endsWith("For")) {
                colTitles.add("currency_for");
            } else if (field.getName().endsWith("Local")) {
                colTitles.add("currency_local");
            } else if (field.getName().endsWith("Rpt")) {
                colTitles.add("currency_rpt");
            }
        } else if (GLRptField.findAsstName == field) {
            for (int i = 0; i < this.findAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else if (GLRptField.HGName == field) {
            for (int i = this.findAssistCount; i < this.maxAssistCount; ++i) {
                colTitles.add(field.getTitle());
            }
        } else {
            colTitles.add(field.getTitle());
        }
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            selector.add(GLRptField.accountNumberMerger);
            selector.add(this.cond.getRptParams().isAccountShowLongName() ? GLRptField.accountDisplayNameMerger : GLRptField.accountNameMerger);
        } else {
            selector.add(GLRptField.accountNumber);
            selector.add(this.cond.getRptParams().isAccountShowLongName() ? GLRptField.accountDisplayName : GLRptField.accountName);
        }
        selector.add(GLRptField.accountDC);
        selector.add(new GLRptField("FIsAccountTotal", "t.FIsAccountTotal", "FIsAccountTotal", "INT"));
        if (this.cond.getIncludeBWAccount()) {
            selector.add(new GLRptField("FBWType", "t.FBWType", "FBWType", "INT"));
            selector.add(new GLRptField("FIsAccountBWSum", "t.FIsAccountBWSum", "FIsAccountBWSum", "INT"));
        }
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.currencyName);
            selector.add(GLRptField.currencyPre);
            selector.add(new GLRptField("FIsCurrencyTotal", "t.FIsCurrencyTotal", "FIsCurrencyTotal", "INT"));
        }
        if (this.cond.isAccountTypeTotal()) {
            selector.add(new GLRptField("FpTypeNum", "t.FpTypeNum", "FpTypeNum", "NVARCHAR(500)"));
            selector.add(new GLRptField("FpTypeName", "t.FpTypeName", "FpTypeName", "NVARCHAR(500)"));
            selector.add(new GLRptField("FIsAccountTypeTotal", "t.FIsAccountTypeTotal", "FIsAccountTypeTotal", "INT"));
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            selector.add(GLRptField.orgUnitID);
            selector.add(GLRptField.orgUnitName);
        }
        if (this.cond.getDisplayAsstDetail()) {
            selector.add(new GLRptField("FIsAssist", "t.FIsAssist", "FIsAssist", "INT"));
            selector.add(GLRptField.HG);
            if (!this.cond.getAsstActList().isEmpty()) {
                selector.add(GLRptField.findAsstName);
            }
            selector.add(GLRptField.HGName);
            if (this.cond.getRptParams().isQtyAsst() && this.cond.isShowQty()) {
                selector.add(GLRptField.asstAccountId);
            }
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.measureUnitID);
            selector.add(GLRptField.accountMeasureUnitName);
            selector.add(GLRptField.yearBeginQtyS);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearBeginBalanceForS);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearBeginBalanceLocalS);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearBeginBalanceRptS);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.endQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.endBalanceRpt);
        }
        return selector;
    }

    @Override
    protected GLRptField getFreezeField() {
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            return GLRptField.orgUnitName;
        }
        if (this.isAllCurrency()) {
            return GLRptField.currencyName;
        }
        return GLRptField.accountName;
    }

    @Override
    public GLRptField getTreeColmun() {
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            return GLRptField.orgUnitName;
        }
        return null;
    }

    @Override
    public IGLRptIDCreator getGLRptIDCreator(String mainTableAlias, GLRptField field) {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            return new GLRptAccountBalanceIDCreator(mainTableAlias, this.cond);
        }
        return new DefaultGLRptIDCreator(mainTableAlias, this.cond);
    }

    @Override
    protected int getExpandLevel() {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            if (this.cond.isDisplayLeafCompany()) {
                return 1;
            }
            return 0;
        }
        return super.getExpandLevel();
    }

    private String getAccountName() throws EASBizException, BOSException {
        if (this.cond.getRptParams().isAccountShowLongName()) {
            return "FdisplayName_" + this.getContex().getLocale();
        }
        return "FName_" + this.getContex().getLocale();
    }

    private boolean isNeedQty(String companyId) {
        return CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode();
    }

    private AccountViewCollection getAccountInfoByTempTable(String companyIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.cond.getCompanyIds(), CompareType.INCLUDE));
        } else if (companyIds != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyIds));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.getCompany().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.cond.getAccountTableId()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select faccountid from " + this.getDataSourceTableName()), CompareType.INNER));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("companyID.id"));
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return AccountViewFactory.getLocalInstance((Context)this.getContex()).getAccountViewCollection(view);
    }

    private IRowSet getAccountAmountForMerger(IRowSet rs, String currencyId, String companyId) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 xxx");
        this.appendAmountTotalSumSelect(sql, currencyId, companyId);
        sql.append(" FROM (").append(this.getDataSourceTableNameForMeger(rs, currencyId, companyId)).append(") TB ");
        return this.executeQuery(sql.toString());
    }

    private String getDataSourceTableNameForMeger(IRowSet rs, String currencyId, String companyId) throws EASBizException, BOSException, SQLException {
        int bwType;
        StringBuffer sql = new StringBuffer();
        sql.append("select tg.accountnumber,tg.accountname ");
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearBeginQty");
            } else {
                sql.append(",SUM(FYearBeginQty) FYearBeginQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearBeginBalanceFor) FYearBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearBeginBalanceLocal) FYearBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearBeginBalanceRpt) FYearBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FBeginQty");
            } else {
                sql.append(",SUM(FBeginQty) FBeginQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FBeginBalanceFor) FBeginBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FBeginBalanceLocal) FBeginBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FBeginBalanceRpt) FBeginBalanceRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FDebitQty");
            } else {
                sql.append(",sum(FDebitQty) FDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FDebitFor) FDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FDebitLocal) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FDebitRpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FCreditQty");
            } else {
                sql.append(",sum(FCreditQty) FCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FCreditFor) FCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FCreditLocal) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FCreditRpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearDebitQty");
            } else {
                sql.append(",SUM(FYearDebitQty) FYearDebitQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearDebitFor) FYearDebitFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearDebitLocal) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearDebitRpt) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FYearCreditQty");
            } else {
                sql.append(",SUM(FYearCreditQty) FYearCreditQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FYearCreditFor) FYearCreditFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FYearCreditLocal) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FYearCreditRpt) FYearCreditRpt");
        }
        if (this.isShowQty()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                sql.append(",0 FEndQty");
            } else {
                sql.append(",sum(FEndQty) FEndQty");
            }
        }
        if (this.isShowFor()) {
            sql.append(",SUM(FEndBalanceFor) FEndBalanceFor");
        }
        if (this.isShowLocal()) {
            sql.append(",SUM(FEndBalanceLocal) FEndBalanceLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",SUM(FEndBalanceRpt) FEndBalanceRpt");
        }
        sql.append(" from ").append(this.getDataSourceTableName()).append(" tg ");
        sql.append(" INNER JOIN T_BD_AccountView av on tg.FAccountID = av.FID ");
        if (this.isShowQty()) {
            sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  ");
        }
        if (this.cond.isShowLeafAccount()) {
            sql.append(" WHERE ").append(" av.FIsLeaf = 1 ");
        } else {
            sql.append(" WHERE ").append(" av.flevel = ").append(this.cond.getAccountLevelStart());
        }
        if (this.cond.getDisplayAsstDetail()) {
            sql.append(" and tg.FIsAssist = 0 ");
        }
        if (this.isAllCurrency()) {
            sql.append(" and tg.FCurrencyID is not null and tg.FCurrencyID <> ' ' ");
        }
        if (companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            sql.append(" and tg.FOrgUnitID <> '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        } else {
            sql.append(" and tg.FOrgUnitID = '").append(companyId).append("'");
        }
        if (this.isAllCurrency()) {
            if (currencyId != null && currencyId.trim().length() > 0) {
                sql.append(" and tg.FCurrencyID = '").append(currencyId).append("'");
            } else {
                sql.append(" and tg.FCurrencyID != ' '");
            }
        }
        if (this.cond.getIncludeBWAccount() && ((bwType = rs.getInt("FBWType")) == 0 || bwType == 1)) {
            sql.append(" and tg.FBWType = ").append(bwType);
        }
        sql.append(" group by tg.accountnumber,tg.accountname ");
        return sql.toString();
    }

    protected GLRptAccountBalQueryHelper getQueryHelper() {
        return new GLRptAccountBalQueryHelper(this.cond);
    }

    protected PeriodInfo getCurrPeriod() throws EASBizException, BOSException {
        return this.cond.getCurrPeriod();
    }

    protected PeriodInfo getStartPeriod() throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getStartPeriod((Context)this.getContex(), (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.cond.getCompany());
    }

    private void appendAmountTotalSumSelect(StringBuffer sql, String currencyId, String companyId) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginDebitTotal(sql, "Qty");
            } else {
                sql.append(",0.0 FYearBeginDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginDebitTotal(sql, "BalanceFor");
            } else {
                sql.append(", 0.0  FYearBeginDebitBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginDebitTotal(sql, "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendYearBeginDebitTotal(sql, "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendYearBeginCreditTotal(sql, "Qty");
            } else {
                sql.append(", 0.0 FYearBeginCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginCreditTotal(sql, "BalanceFor");
            } else {
                sql.append(", 0.0  FYearBeginCreditBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginCreditTotal(sql, "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendYearBeginCreditTotal(sql, "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginDebitTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FBeginDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginDebitTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FBeginDebitBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginDebitTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginDebitTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodBeginCreditTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FBeginCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginCreditTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0  FBeginCreditBalanceFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginCreditTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginCreditTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FDebitQty) FDebitQty       \r\n");
            } else {
                sql.append(", 0.0 FDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FDebitFor) FDebitFor       \r\n");
            } else {
                sql.append(", 0.0  FDebitFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FDebitLocal) FDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FDebitRpt) FDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FCreditQty) FCreditQty\t   \r\n");
            } else {
                sql.append(", 0.0 FCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FCreditFor) FCreditFor     \r\n");
            } else {
                sql.append(", 0.0  FCreditFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FCreditLocal) FCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FCreditRpt) FCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FYearDebitQty) FYearDebitQty       \r\n");
            } else {
                sql.append(", 0.0 FYearDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearDebitFor) FYearDebitFor       \r\n");
            } else {
                sql.append(", 0.0  FYearDebitFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearDebitLocal) FYearDebitLocal   \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearDebitRpt) FYearDebitRpt       \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                sql.append(",sum(TB.FYearCreditQty) FYearCreditQty\t   \r\n");
            } else {
                sql.append(", 0.0 FYearCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearCreditFor) FYearCreditFor     \r\n");
            } else {
                sql.append(", 0.0  FYearCreditFor     \r\n");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearCreditLocal) FYearCreditLocal \r\n");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearCreditRpt) FYearCreditRpt     \r\n");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndDebitTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FEndDebitQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndDebitTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0 FEndDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndDebitTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndDebitTotal(sql, "Rpt", "BalanceRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId)) {
                this.appendPeriodEndCreditTotal(sql, "Qty", "Qty");
            } else {
                sql.append(", 0.0 FEndCreditQty \r\n");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndCreditTotal(sql, "For", "BalanceFor");
            } else {
                sql.append(", 0.0 FEndCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndCreditTotal(sql, "Local", "BalanceLocal");
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndCreditTotal(sql, "Rpt", "BalanceRpt");
        }
    }

    private void appendYearBeginDebitTotal(StringBuffer sql, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FYearBegin").append(suff).append(" > 0 ");
        sql.append(" THEN (TB.FYearBegin").append(suff).append(")");
        sql.append(" ELSE 0.0 END) FYearBeginDebit").append(suff).append(" \r\n");
    }

    private void appendYearBeginCreditTotal(StringBuffer sql, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FYearBegin").append(suff).append(" < 0 ");
        sql.append(" THEN -1 * (TB.FYearBegin").append(suff).append(") ");
        sql.append(" ELSE 0.0 END) FYearBeginCredit").append(suff).append(" \r\n");
    }

    private void appendPeriodBeginDebitTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(" ,sum(CASE WHEN ");
        sql.append(" TB.FBegin" + suff + " > 0 ");
        sql.append(" THEN TB.FBegin" + suff);
        sql.append(" ELSE 0.0 END) FBeginDebit" + suff + "     \r\n");
    }

    private void appendPeriodBeginCreditTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FBegin" + suff + " < 0 ");
        sql.append(" THEN -1 * TB.FBegin" + suff);
        sql.append(" ELSE 0.0 END) FBeginCredit" + suff + "\t\r\n");
    }

    private void appendPeriodEndDebitTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FEnd" + suff + ">0");
        sql.append(" THEN TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndDebit" + suff + "    \r\n");
    }

    private void appendPeriodEndCreditTotal(StringBuffer sql, String type, String suff) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        sql.append(" TB.FEnd" + suff + "<0");
        sql.append(" THEN -1*TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndCredit" + suff + "  \r\n");
    }
}

