/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountWithNotAcctBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSubLedgerVoucherQuery;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class GLRptAccountBeginPeriodBalQuery
extends GLRptQuery {
    private CompanyOrgUnitInfo company;
    private boolean isCreateDataTempTable = false;
    private boolean beginPeriodCompareCurrPeriod = false;
    private GLRptBaseCondition cond;
    private boolean isGetAccoutBalWithNoAcct = false;

    public GLRptAccountBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws BOSException, EASBizException {
        super(ctx, cond);
        this.company = company;
        this.cond = cond;
        this.isCreateDataTempTable = isCreateDataTempTable;
        int beginPeriod = cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart();
        int currPeriod = cond.getCurrPeriod().getNumber();
        this.beginPeriodCompareCurrPeriod = beginPeriod > currPeriod;
        this.setOptimize(false);
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        String merging;
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        if (SQLUtil.isOracle(this.getCtx()) && (merging = SQLUtil.getComplexViewMerging(this.getCtx())) != null && ("true".equals(merging = merging.trim()) || "false".equals(merging))) {
            sql.append(" /*+ opt_param('_complex_view_merging','" + merging + "') */ ");
        }
        boolean first = true;
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!field.isTempTableField()) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            if (this.cond instanceof GLRptSubLedgerCondition && !((GLRptSubLedgerCondition)this.cond).isNoDisplayZeroTotal()) {
                if (GLRptField.period == field) {
                    sql.append(this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart()).append(" ").append(field.getName());
                    continue;
                }
                if (GLRptField.periodBeginDate == field) {
                    Date beginDate = null;
                    try {
                        StringBuffer periodSql = new StringBuffer();
                        periodSql.append("SELECT FBeginDate FROM T_BD_PERIOD where FTYPEID = '");
                        periodSql.append(this.cond.getPeriodTypeId());
                        periodSql.append("' and FPeriodYear = ").append(this.cond.getPeriodYearStart());
                        periodSql.append(" and FPeriodNumber = ").append(this.cond.getPeriodNumberStart() - (this.cond.getPeriodNumberStart() == 13 ? 1 : 0));
                        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)periodSql.toString());
                        while (rs.next()) {
                            beginDate = rs.getDate("FBeginDate");
                        }
                    }
                    catch (SQLException throwables) {
                        System.out.println("\u83b7\u53d6\u671f\u95f4\u9519\u8bef");
                    }
                    if (beginDate == null) {
                        beginDate = this.cond.getPeriodNumberStart() != 13 ? new Date(this.cond.getPeriodYearStart() - 1900, this.cond.getPeriodNumberStart() - 1, 1) : new Date(this.cond.getPeriodYearStart() - 1900, this.cond.getPeriodNumberStart() - 2, 31);
                    }
                    sql.append("{ts'").append(DateTimeUtils.format(beginDate)).append("'} ").append(field.getName());
                    continue;
                }
            }
            sql.append("t1.").append(field.getName());
        }
        return sql.toString();
    }

    protected String getAmountSelectSQL(GLRptField field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (field.getName().startsWith("FYearDebit")) {
            sql.append("t1.").append(field).append(" - t1.").append("FDebit").append(field.getSuffix());
            if (this.cond.isNotIncluePLVoucher() && (this.cond.getPeriodNumberStart() != 1 || this.cond.getPeriodYearStart() != this.cond.getPeriodYearEnd())) {
                sql.append(" - ISNULL(plYear.").append("FYearDebit").append(field.getSuffix()).append(", 0)");
            }
            sql.append(" ").append(field);
        } else if (field.getName().startsWith("FYearCredit")) {
            sql.append("t1.").append(field).append(" - t1.").append("FCredit").append(field.getSuffix());
            if (this.cond.isNotIncluePLVoucher() && (this.cond.getPeriodNumberStart() != 1 || this.cond.getPeriodYearStart() != this.cond.getPeriodYearEnd())) {
                sql.append(" - ISNULL(plYear.").append("FYearCredit").append(field.getSuffix()).append(", 0)");
            }
            sql.append(" ").append(field);
        } else {
            sql.append("t1.").append(field).append(" ").append(field);
        }
        return sql.toString();
    }

    @Override
    protected String getFromSQL() throws BOSException, EASBizException {
        GLRptSelector sel = new GLRptSelector();
        sel.add(this.getSelector());
        if (this.cond.isShowFor()) {
            sel.add(GLRptField.debitFor);
            sel.add(GLRptField.creditFor);
        }
        if (this.cond.isShowLocal()) {
            sel.add(GLRptField.debitLocal);
            sel.add(GLRptField.creditLocal);
        }
        if (this.cond.isShowRpt()) {
            sel.add(GLRptField.debitRpt);
            sel.add(GLRptField.creditRpt);
        }
        if (this.cond.isShowQty()) {
            sel.add(GLRptField.debitQty);
            sel.add(GLRptField.creditQty);
        }
        GLRptBalQuery query = this.getFromBalQuery();
        query.setSelector(sel);
        String sql = null;
        if (this.beginPeriodCompareCurrPeriod) {
            int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            int currPeriod = this.cond.getCurrPeriod().getNumber();
            GLRptBalNextPeriodQuery nextPreiodQuery = this.getRptBalNextPeriodQuery(this.getCtx(), this.cond);
            nextPreiodQuery.setGLRptQuery(query);
            nextPreiodQuery.setSelector(sel);
            nextPreiodQuery.setPeriod(currPeriod, beginPeriod);
            sql = nextPreiodQuery.getSQL();
            sql = GLRptSQLUtil.addBalTableHint(sql);
        } else {
            sql = query.getSQL();
        }
        return "(" + sql + ") t1 ";
    }

    protected GLRptBalNextPeriodQuery getRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new GLRptBalNextPeriodQuery(ctx, cond);
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        if (this.beginPeriodCompareCurrPeriod || this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd() && this.cond.getPeriodNumberStart() == this.cond.getPeriodNumberEnd()) {
            return null;
        }
        Iterator<GLRptField> it = this.getSelector().iterator();
        StringBuffer filterSql = new StringBuffer();
        GLRptSelector joinSel = new GLRptSelector();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || field.getType() == "NUMERIC(29,10)") continue;
            if (filterSql.length() > 0) {
                filterSql.append(" and ");
            }
            filterSql.append("t1.").append(field.getName()).append(" = t2.").append(field.getName());
            if (field == GLRptField.period) {
                joinSel.add(new GLRptField("FPeriod", "min(b.FPeriod)", "period.number", "INT"));
                continue;
            }
            if (field == GLRptField.periodBeginDate) {
                joinSel.add(new GLRptField("FPeriodBeginDate", "min(pd.FbeginDate)", "period.beginDate", "DateTime"));
                continue;
            }
            joinSel.add(field);
        }
        GLRptBalQuery joinQuery = this.getJoinBalQuery();
        joinQuery.setSelector(joinSel);
        if (this.cond.isNotIncluePLVoucher()) {
            joinQuery.setIncluePLVoucher(true);
        }
        StringBuffer joinSql = new StringBuffer();
        joinSql.append("inner join (").append(joinQuery.getSQL()).append(") t2 on ").append(filterSql);
        return joinSql.toString();
    }

    @Override
    protected String getJoinPLYearSQL() throws BOSException, EASBizException {
        boolean isCurrencyFilter;
        GLRptAsstactBaseCondition condition;
        String prefix;
        String accountTmpTable = null;
        if (this.cond instanceof GLRptSubLedgerCondition && !this.cond.isLeafAccount()) {
            GLRptSubLedgerVoucherQuery subLedgerVoucherQuery = new GLRptSubLedgerVoucherQuery(this.getCtx(), this.company, (GLRptSubLedgerCondition)this.cond, false);
            accountTmpTable = subLedgerVoucherQuery.createAccountTmpTable((GLRptSubLedgerCondition)this.cond);
        }
        int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
        boolean isAsstFilter = this.cond instanceof GLRptAsstactBaseCondition && !((GLRptAsstactBaseCondition)this.cond).getAsstActList().isEmpty();
        GLRptSelector selector = this.getSelector();
        boolean isUseHG = selector.contains(GLRptField.HG);
        boolean isUseCompany = selector.contains(GLRptField.orgUnitID);
        boolean isUseAccountId = selector.contains(GLRptField.accountID);
        StringBuffer groupBy = new StringBuffer();
        StringBuffer sql = new StringBuffer(" left join (");
        sql.append(" select");
        if (isUseCompany) {
            sql.append(" v.fcompanyid,");
            groupBy.append("v.fcompanyid,");
        }
        if (isUseAccountId) {
            sql.append(accountTmpTable == null ? " ve.faccountid" : " av.FParentID faccountid").append(",");
            groupBy.append(accountTmpTable == null ? " ve.faccountid" : " av.FParentID").append(",");
        }
        if (this.cond.isAllCurrency()) {
            sql.append(" ve.fcurrencyid,");
            groupBy.append(" ve.fcurrencyid,");
        }
        if (isUseHG) {
            sql.append(" vr.fassgrpid,");
            groupBy.append(" vr.fassgrpid,");
        }
        String string = prefix = isAsstFilter || isUseHG ? "vr" : "ve";
        if (this.cond.isShowFor()) {
            sql.append(" sum(case when ve.FEntryDC =").append(1).append(" then ").append(prefix).append(".FOriginalAmount else 0 end) fyeardebitfor,");
            sql.append(" sum(case when ve.FEntryDC =").append(0).append(" then ").append(prefix).append(".FOriginalAmount else 0 end) fyearcreditfor,");
        }
        if (this.cond.isShowLocal()) {
            sql.append(" sum(case when ve.FEntryDC =").append(1).append(" then ").append(prefix).append(".FLocalAmount else 0 end) fyeardebitlocal,");
            sql.append(" sum(case when ve.FEntryDC =").append(0).append(" then ").append(prefix).append(".FLocalAmount else 0 end) fyearcreditlocal,");
        }
        if (this.cond.isShowRpt()) {
            sql.append(" sum(case when ve.FEntryDC =").append(1).append(" then ").append(prefix).append(".FReportingAmount else 0 end) fyeardebitrpt,");
            sql.append(" sum(case when ve.FEntryDC =").append(0).append(" then ").append(prefix).append(".FReportingAmount else 0 end) fyearcreditrpt,");
        }
        if (this.cond.isShowQty()) {
            sql.append(" sum(case when ve.FEntryDC =").append(1).append(" then ").append(prefix).append(".FStandardQuantity else 0 end) fyeardebitqty,");
            sql.append(" sum(case when ve.FEntryDC =").append(0).append(" then ").append(prefix).append(".FStandardQuantity else 0 end) fyearcreditqty,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" from t_gl_voucher v ");
        sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid ");
        if (isUseHG || isAsstFilter) {
            sql.append(" inner join t_gl_voucherassistrecord vr on vr.fbillid = v.fid and vr.fentryid = ve.fid ");
        }
        if (accountTmpTable != null) {
            sql.append(" inner join ").append(accountTmpTable).append(" av on av.fid = ve.faccountid");
        } else {
            sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid ");
        }
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid ");
        if (isAsstFilter && (condition = (GLRptAsstactBaseCondition)this.cond).isFilterByCat()) {
            sql.append(" LEFT OUTER JOIN T_BD_AssistantHG assGrp ON vr.FAssGrpID = assGrp.FID ");
            for (Object obj : condition.getAsstActList()) {
                AsstactTypeEntity at = (AsstactTypeEntity)obj;
                sql.append(" LEFT OUTER JOIN ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid ").append(" = ").append("assGrp").append(".").append(at.getHgField());
                if (!condition.isFilterByCat() || at.isBasicCat()) continue;
                sql.append(" LEFT OUTER JOIN ").append(GLRptDaoUtil.getGroupDetailTable(at)).append(" ").append(at.getHgAttribute()).append("GDet on ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getField(at)).append(" = ").append("assGrp").append(".").append(at.getHgField());
            }
        }
        sql.append(" where v.fbizstatus ").append(this.cond.getOptionPosting() ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and v.fcompanyid = '").append(this.cond.getCompany().getId().toString()).append("'");
        } else {
            sql.append(" and v.fcompanyid in ").append(this.cond.getCompanyIdsStr());
        }
        if (accountTmpTable == null) {
            sql.append(" and av.faccounttableid = '").append(this.cond.getAccountTableId()).append("'");
            sql.append(" and av.fcompanyid in ").append(this.cond.getCompanyIdsStr());
            GLRptAccountFilter accountFilter = new GLRptAccountFilter(this.getCtx(), this.cond, "av", "av.fid", "v.fcompanyid", false, true, this.cond.getCompanyIdsStr());
            accountFilter.setPermFilter(false);
            String accountFilterSQL = accountFilter.getSQL();
            if (accountFilterSQL != null) {
                sql.append(" and ").append(accountFilterSQL);
            }
        }
        sql.append(" and pd.fnumber >= ");
        sql.append(this.cond.getPeriodYearStart() * 100 + 1);
        sql.append(" and pd.fnumber <= ");
        sql.append(startPeriod - 1);
        boolean bl = isCurrencyFilter = !CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) && !CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID()) && !this.cond.isAllCurrency();
        if (isCurrencyFilter) {
            sql.append(" and ve.fcurrencyid = '").append(this.cond.getCurrencyID()).append("'");
        }
        if (isAsstFilter) {
            this.getAsstFilterSql(sql);
        }
        if (groupBy.length() > 0) {
            sql.append(" group by ").append(groupBy.deleteCharAt(groupBy.length() - 1));
        }
        sql.append(") plYear on ");
        if (isUseAccountId) {
            sql.append(" plYear.faccountid = t1.faccountid");
        } else {
            sql.append(" 1 = 1");
        }
        if (isUseCompany) {
            sql.append(" and plYear.fcompanyid = t1.FOrgUnitID");
        }
        if (this.cond.isAllCurrency()) {
            sql.append(" and plYear.fcurrencyid = t1.fcurrencyid");
        }
        if (isUseHG) {
            sql.append(" and plYear.fassgrpid = t1.FAssistGrpId");
        }
        return sql.toString();
    }

    protected void getAsstFilterSql(StringBuffer sql) throws EASBizException, BOSException {
        StringBuffer asstAccountFilter = new StringBuffer();
        Set asstAccountIdSet = ((GLRptAsstactBaseCondition)this.cond).getAsstAccountIdSet();
        for (Object asstAccountId : asstAccountIdSet) {
            asstAccountFilter.append("'" + asstAccountId.toString() + "'").append(", ");
        }
        sql.append(" and ve.FCAA in ( ").append(asstAccountFilter.substring(0, asstAccountFilter.length() - 2)).append(") ");
        String asstLimitCondition = GLRptDaoUtil.getAsstLimitCondition(this.getCtx(), ((GLRptAsstactBaseCondition)this.cond).getAsstActList());
        if (!asstLimitCondition.isEmpty()) {
            sql.append(" and vr.FAssGrpId in ( ").append(asstLimitCondition).append(" ) ");
        }
    }

    protected GLRptBalQuery getFromBalQuery() throws EASBizException, BOSException {
        if (this.isGetAccoutBalWithNoAcct()) {
            GLRptAccountWithNotAcctBalQuery accNotAcctBalQuery = this.getRptAccountWithNotAcctBalQuery(this.getCtx(), (OrgUnitInfo)this.company, this.cond, this.isCreateDataTempTable);
            accNotAcctBalQuery.setPeriodBeginBalance(true);
            return accNotAcctBalQuery;
        }
        GLRptAccountBalQuery query = this.getRptAccountBalQuery(this.getCtx(), (OrgUnitInfo)this.company, this.cond, this.isCreateDataTempTable);
        query.setPeriodBeginBalance(true);
        return query;
    }

    protected GLRptAccountWithNotAcctBalQuery getRptAccountWithNotAcctBalQuery(Context ctx, OrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAccountWithNotAcctBalQuery(ctx, company, cond, isCreateDataTempTable, false);
    }

    protected GLRptBalQuery getJoinBalQuery() throws EASBizException, BOSException {
        GLRptBalQuery query = null;
        query = this.isGetAccoutBalWithNoAcct() ? this.getRptAccountWithNotAcctBalQuery(this.getCtx(), (OrgUnitInfo)this.company, this.cond, this.isCreateDataTempTable) : this.getRptAccountBalQuery(this.getCtx(), (OrgUnitInfo)this.company, this.cond, this.isCreateDataTempTable);
        query.setPeriodBeginBalance(true);
        return query;
    }

    protected GLRptAccountBalQuery getRptAccountBalQuery(Context ctx, OrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAccountBalQuery(ctx, company, cond, isCreateDataTempTable, false);
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public boolean isCreateDataTempTable() {
        return this.isCreateDataTempTable;
    }

    public boolean isGetAccoutBalWithNoAcct() {
        return this.isGetAccoutBalWithNoAcct;
    }

    public void setGetAccoutBalWithNoAcct(boolean isGetAccoutBalWithNoAcct) {
        this.isGetAccoutBalWithNoAcct = isGetAccoutBalWithNoAcct;
    }
}

