/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBeginPeriodBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalNextPeriodQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GLRptAccountNotHasAsstBeginPeriodBalQuery
extends GLRptAccountBeginPeriodBalQuery {
    private GLRptBaseCondition cond;
    private OrgUnitInfo company;
    private boolean isCreateDataTempTable;
    private boolean beginPeriodCompareCurrPeriod;

    public GLRptAccountNotHasAsstBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws BOSException, EASBizException {
        super(ctx, company, cond, isCreateDataTempTable);
        this.company = company;
        this.cond = cond;
        this.isCreateDataTempTable = isCreateDataTempTable;
        int beginPeriod = cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart();
        int currPeriod = cond.getCurrPeriod().getNumber();
        this.beginPeriodCompareCurrPeriod = beginPeriod > currPeriod;
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        boolean first = true;
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!field.isTempTableField()) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            sql.append("t1.").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected String getAmountSelectSQL(GLRptField field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (field.getName().startsWith("FYearDebit")) {
            sql.append("t1.").append(field).append(" - t1.").append("FDebit").append(field.getSuffix()).append(" ").append(field);
        } else if (field.getName().startsWith("FYearCredit")) {
            sql.append("t1.").append(field).append(" - t1.").append("FCredit").append(field.getSuffix()).append(" ").append(field);
        } else {
            sql.append("t1.").append(field).append(" ").append(field);
        }
        return sql.toString();
    }

    @Override
    protected String getFromSQL() throws BOSException, EASBizException {
        GLRptSelector sel = new GLRptSelector();
        sel.add(this.getSelector());
        if (this.cond.isShowFor()) {
            sel.add(GLRptField.debitFor);
            sel.add(GLRptField.creditFor);
        }
        if (this.cond.isShowLocal()) {
            sel.add(GLRptField.debitLocal);
            sel.add(GLRptField.creditLocal);
        }
        if (this.cond.isShowRpt()) {
            sel.add(GLRptField.debitRpt);
            sel.add(GLRptField.creditRpt);
        }
        if (this.cond.isShowQty()) {
            sel.add(GLRptField.debitQty);
            sel.add(GLRptField.creditQty);
        }
        String sql = null;
        AccountViewCollection accountColl = this.getAsstBalAccount();
        GLRptSubLedgerCondition childCond = (GLRptSubLedgerCondition)this.cond.clone();
        childCond.setAccounts(accountColl);
        childCond.setAccountId(null);
        HashSet<String> childAccountIdSet = new HashSet<String>();
        for (int i = 0; i < accountColl.size(); ++i) {
            childAccountIdSet.add(accountColl.get(i).getId().toString());
        }
        childCond.setAccountIdSet(childAccountIdSet);
        GLRptBalQuery query = this.getFromBalQuery(childCond);
        query.setSelector(sel);
        if (this.beginPeriodCompareCurrPeriod) {
            int beginPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            int currPeriod = this.cond.getCurrPeriod().getNumber();
            GLRptBalNextPeriodQuery nextPreiodQuery = this.getRptBalNextPeriodQuery(this.getCtx(), childCond);
            nextPreiodQuery.setGLRptQuery(query);
            nextPreiodQuery.setSelector(sel);
            nextPreiodQuery.setPeriod(currPeriod, beginPeriod);
            sql = nextPreiodQuery.getSQL();
            sql = GLRptSQLUtil.addBalTableHint(sql);
        } else {
            sql = query.getSQL();
        }
        String groupSelectSql = this.getFromSelectSQL(sel);
        sql = "select " + groupSelectSql + " from (" + sql + ") t2 group by " + this.getFromGroupSQL();
        return "(" + sql + ") t1 ";
    }

    protected String getFromSelectSQL(GLRptSelector sel) throws EASBizException, BOSException {
        if (sel == null || sel.isEmpty()) {
            return "1";
        }
        String accountId = ((GLRptSubLedgerCondition)this.cond).getAccounts().get(0).getId().toString();
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = sel.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (field == GLRptField.accountID) {
                if (sql.length() > 0) {
                    sql.append(",");
                }
                sql.append(" '").append(accountId).append("' ").append(field.getName());
                continue;
            }
            if (field.getType() == "NUMERIC(29,10)") {
                if (sql.length() > 0) {
                    sql.append(",");
                }
                sql.append("sum (t2.").append(field.getName()).append(") ").append(field.getName());
                continue;
            }
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("t2.").append(field.getName());
        }
        return sql.toString();
    }

    protected String getFromGroupSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            return "1";
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || field.getType() == "NUMERIC(29,10)") continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("t2.").append(field.getName());
        }
        return sql.toString();
    }

    protected AccountViewCollection getAsstBalAccount() throws EASBizException, BOSException {
        GLRptSubLedgerCondition accountCond = (GLRptSubLedgerCondition)this.cond.clone();
        accountCond.setAccountId(null);
        accountCond.setAccountIdSet((Set)null);
        GLRptAsstactBalQuery query = this.getRptAsstactBalanceQuery(this.getCtx(), this.cond.getCompany(), accountCond);
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.accountID);
        query.setSelector(selector);
        query.setNotGroup(true);
        if (this.cond.isOptionAmountAndBalZero()) {
            query.addGLRptFilter(this.getAmountGLRptFilter());
        }
        GLRptFilter filter = new GLRptFilter(){

            @Override
            public String getSQL() throws EASBizException, BOSException {
                return "av.flongnumber like '" + ((GLRptSubLedgerCondition)GLRptAccountNotHasAsstBeginPeriodBalQuery.this.cond).getAccounts().get(0).getLongNumber() + "!%' and av.fisleaf = 1 ";
            }
        };
        query.addGLRptFilter(filter);
        String assBalSql = query.getSQL();
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)assBalSql);
        AccountViewCollection coll = new AccountViewCollection();
        try {
            while (rs.next()) {
                String accountId = rs.getString(GLRptField.accountID.getName());
                AccountViewInfo account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)accountId));
                coll.add(account);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return coll;
    }

    private GLRptFilter getAmountGLRptFilter() {
        return new GLRptFilter(){

            @Override
            public String getSQL() throws EASBizException, BOSException {
                StringBuffer s = new StringBuffer();
                String currencyId = GLRptAccountNotHasAsstBeginPeriodBalQuery.this.cond.getCurrencyID();
                boolean isForCurrency = false;
                boolean isLocalCurrency = false;
                boolean isRptCurrency = false;
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
                    isLocalCurrency = true;
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                    isRptCurrency = true;
                } else {
                    isForCurrency = true;
                }
                s.append(" (b.fdetailcount<> 0 ");
                if (isForCurrency) {
                    s.append(" or b.fendbalancefor <> 0");
                    s.append(" or b.fdebitfor <>0 or b.fcreditfor <> 0");
                }
                if (isLocalCurrency || isForCurrency) {
                    s.append(" or b.fdebitlocal<>0 or b.fcreditlocal<>0");
                    s.append(" or b.fendbalancelocal <> 0");
                }
                if ((isRptCurrency || isForCurrency) && GLRptAccountNotHasAsstBeginPeriodBalQuery.this.cond.getRptParams().isUseReportCurrency()) {
                    s.append(" or b.fendbalancerpt <>0");
                    s.append(" or b.fdebitrpt<>0 or b.fcreditrpt<>0");
                }
                s.append(")");
                return s.toString();
            }
        };
    }

    protected GLRptAsstactBalQuery getRptAsstactBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptSubLedgerCondition cond) throws EASBizException, BOSException {
        return new GLRptAsstactBalQuery(ctx, (OrgUnitInfo)company, cond, false, false);
    }

    protected String getAccountMapSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        return sql.toString();
    }

    @Override
    protected GLRptBalNextPeriodQuery getRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws EASBizException, BOSException {
        return new GLRptBalNextPeriodQuery(ctx, cond);
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        if (this.beginPeriodCompareCurrPeriod || this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd() && this.cond.getPeriodNumberStart() == this.cond.getPeriodNumberEnd()) {
            return null;
        }
        Iterator<GLRptField> it = this.getSelector().iterator();
        StringBuffer filterSql = new StringBuffer();
        GLRptSelector joinSel = new GLRptSelector();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || field.getType() == "NUMERIC(29,10)") continue;
            if (filterSql.length() > 0) {
                filterSql.append(" and ");
            }
            filterSql.append("t1.").append(field.getName()).append(" = t2.").append(field.getName());
            if (field == GLRptField.period) {
                joinSel.add(new GLRptField("FPeriod", "min(b.FPeriod)", "period.number", "INT"));
                continue;
            }
            if (field == GLRptField.periodBeginDate) {
                joinSel.add(new GLRptField("FPeriodBeginDate", "min(pd.FbeginDate)", "period.beginDate", "DateTime"));
                continue;
            }
            joinSel.add(field);
        }
        GLRptBalQuery joinQuery = this.getJoinBalQuery();
        joinQuery.setSelector(joinSel);
        if (this.cond.isNotIncluePLVoucher()) {
            joinQuery.setIncluePLVoucher(true);
        }
        StringBuffer joinSql = new StringBuffer();
        joinSql.append("inner join (").append(joinQuery.getSQL()).append(") t2 on ").append(filterSql);
        return joinSql.toString();
    }

    protected GLRptBalQuery getFromBalQuery(GLRptSubLedgerCondition childCond) throws EASBizException, BOSException {
        GLRptAccountBalQuery query = this.getRptAccountBalQuery(this.getCtx(), this.company, childCond, this.isCreateDataTempTable);
        query.setPeriodBeginBalance(true);
        return query;
    }

    @Override
    protected GLRptBalQuery getJoinBalQuery() throws EASBizException, BOSException {
        GLRptAccountBalQuery query = this.getRptAccountBalQuery(this.getCtx(), this.company, this.cond, this.isCreateDataTempTable);
        query.setPeriodBeginBalance(true);
        return query;
    }

    @Override
    protected GLRptAccountBalQuery getRptAccountBalQuery(Context ctx, OrgUnitInfo company, GLRptBaseCondition cond, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAccountBalQuery(ctx, company, cond, isCreateDataTempTable, false);
    }
}

