/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalanceTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPLVoucherAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTableJoin;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GLRptAccountWithNotAcctBalQuery
extends GLRptBalQuery {
    private GLRptBaseCondition cond;
    private String accountTmpTable;

    public GLRptAccountWithNotAcctBalQuery(Context ctx, OrgUnitInfo company, GLRptBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws BOSException, EASBizException {
        super(ctx, company, cond, isMeasureUnit, isCreateDataTempTable);
        this.cond = cond;
        this.setMainTable(new GLRptAccountBalanceTable(cond));
    }

    @Override
    protected void appendSelectField(StringBuffer sql, GLRptField field) {
        if (this.isGroupByPAccount() && field == GLRptField.accountID) {
            sql.append(" av.fparentid ").append(field.getName());
        } else if (this.isGroupByPAccount() && GLRptField.accountNumberMerger == field) {
            sql.append(" pav.fnumber ").append(field.getName());
        } else if (this.isGroupByPAccount() && GLRptField.accountNameMerger == field) {
            sql.append(" pav.fname");
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale().toString());
            }
            sql.append(" ").append(field.getName());
        } else if (field.getType() == "NUMERIC(29,10)" && this.isGroupByPAccount()) {
            sql.append(" sum(").append(field.getSelect()).append(") ").append(field.getName());
        } else {
            super.appendSelectField(sql, field);
        }
    }

    @Override
    protected GLRptQuery getPLVoucherQuery() throws EASBizException, BOSException {
        GLRptPLVoucherAsstactBalQuery query = new GLRptPLVoucherAsstactBalQuery(this.getCtx(), (GLRptAsstactBaseCondition)this.getCond());
        query.setGroupByPAccount(this.isGroupByPAccount());
        if (this.isGroupByPAccount()) {
            query.setAccountTmpTable(this.getAccountTmpTable());
        }
        return query;
    }

    @Override
    protected GLRptTableJoin initJoinTable() throws EASBizException, BOSException {
        if (this.getMainTable() == null) {
            return null;
        }
        GLRptTableJoin join = new GLRptTableJoin();
        if (!this.isGroupByPAccount()) {
            join.add(GLRptDataTable.ACCOUNT, this.getMainTable().getAlias() + "." + GLRptField.accountID, false);
        }
        return join;
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        if (this.isGroupByPAccount()) {
            StringBuffer sql = new StringBuffer();
            sql.append(super.getJoinSQL());
            sql.append(" inner join ").append(this.getAccountTmpTable()).append(" av on av.fid = ").append(this.getMainTable().getAlias()).append(".").append(GLRptField.accountID);
            return sql.toString();
        }
        return super.getJoinSQL();
    }

    protected String getAccountTmpTable() throws BOSException, EASBizException {
        if (this.accountTmpTable != null) {
            return this.accountTmpTable;
        }
        this.accountTmpTable = GLTempTableUtil.createDBSysTempTable(this.getCtx(), "fid varchar(44), fparentid varchar(44)");
        StringBuffer sql = new StringBuffer();
        sql.append(" select av.fid, pav.fid from t_bd_accountview av inner join t_bd_accountview pav on (");
        if (SQLUtil.isSupportCharIndexToLike(this.getCtx())) {
            sql.append(" av.flongnumber like concat(pav.flongnumber, '!%') ");
        } else {
            sql.append(" charindex(pav.flongnumber||'!', av.flongnumber) = 1 ");
        }
        sql.append(" or pav.fnumber = av.fnumber) ");
        sql.append(" and pav.faccounttableid = av.faccounttableid ");
        this.getJoinOrgUnitSql(sql);
        sql.append(" where ").append(this.getAccountFilterSQL());
        sql.append(" and av.fisleaf = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString());
        HashMap<String, String> idMap = new HashMap<String, String>();
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.cond.getCtx());
            while (rs.next()) {
                idMap.put(rs.getString(1), rs.getString(2));
            }
            int startPeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart();
            int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
            Map caaIds = AccountFacadeFactory.getLocalInstance((Context)this.cond.getCtx()).getCAAIdsByPeriodRange(idMap.keySet(), startPeriod, endPeriod);
            sql.setLength(0);
            sql.append(" insert into ").append(this.accountTmpTable).append("(fid, fparentid) values(?, ?)");
            stmt = conn.prepareStatement(sql.toString());
            for (String key : caaIds.keySet()) {
                if (((Set)caaIds.get(key)).size() != 0) continue;
                stmt.setString(1, key);
                stmt.setString(2, (String)idMap.get(key));
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        this.processBizAccountAndVirtualAccountMap();
        return this.accountTmpTable;
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String where = super.getWhereSQL();
        if (!this.isGroupByPAccount()) {
            where = where + " and " + this.getAccountFilterSQL();
        }
        return where;
    }

    @Override
    protected boolean isGroupBy() throws BOSException, EASBizException {
        return super.isGroupBy() || this.isGroupByPAccount();
    }

    @Override
    protected void appendGroupField(StringBuffer sql, GLRptField field) {
        if (field == GLRptField.accountID && this.isGroupByPAccount()) {
            sql.append("av.fparentid");
        } else if (this.isGroupByPAccount() && GLRptField.accountNumberMerger == field) {
            sql.append(" pav.fnumber ");
        } else if (this.isGroupByPAccount() && GLRptField.accountNameMerger == field) {
            sql.append(" pav.fname");
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale().toString());
            }
        } else {
            super.appendGroupField(sql, field);
        }
    }

    protected String getAccountFilterSQL() throws EASBizException, BOSException {
        String accFilter;
        GLRptBaseCondition cond = this.getCond();
        StringBuffer sql = new StringBuffer();
        if (cond.getCtx().get((Object)"isPca") == null) {
            sql.append(GLRptDataTable.ACCOUNT.getAlias()).append(".fcompanyid in ").append(cond.getCompanyIdsStr());
            sql.append(" and ");
        }
        sql.append(GLRptDataTable.ACCOUNT.getAlias()).append(".faccounttableid = '").append(cond.getAccountTableId()).append("'");
        if (cond.getCtx().get((Object)"isPca") == null) {
            sql.append(" and ").append(GLRptDataTable.ACCOUNT.getAlias()).append(".fisProfitCenter <>  '1' ");
        }
        if (!StringUtils.isEmpty((String)(accFilter = this.getAccountFilter().getSQL()))) {
            sql.append(" and ").append(accFilter);
        }
        return sql.toString();
    }

    protected GLRptFilter getAccountFilter() throws BOSException {
        if (this.isGroupByPAccount()) {
            return new GLRptAccountFilter(this.getCtx(), this.cond, "pav", "pav.fid", "b.forgunitid", false);
        }
        return new GLRptAccountFilter(this.getCtx(), this.getCond(), "av", this.getMainTable().getAlias() + "." + GLRptField.accountID.getName(), this.getMainTable().getAlias() + "." + GLRptField.orgUnitID.getName(), false, true, this.getCond().getCompanyIdsStr());
    }

    protected boolean containsAccountSelector() {
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field != GLRptField.accountID) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroupByPAccount() {
        return true;
    }

    protected void getJoinOrgUnitSql(StringBuffer sql) {
        if (!this.getCompany().isIsBizUnit()) {
            GLRptBaseCondition cond = this.getCond();
            if (cond == null || !(cond instanceof GLRptSubLedgerCondition)) {
                sql.append(" and pav.fcompanyid = '").append(this.getCompany().getId().toString()).append("'");
            }
            sql.append(" and av.fisLeaf = 1 ");
            if (cond.isShowLeafAccount()) {
                sql.append(" and pav.fisLeaf = 1 ");
            } else {
                sql.append(" and pav.flevel <= ").append(cond.getAccountLevelEnd());
            }
        } else {
            sql.append(" and pav.fcompanyid = av.fcompanyid ");
        }
    }

    private void processBizAccountAndVirtualAccountMap() throws BOSException {
        Map<String, String> bizAccountVirtualAccountMap;
        GLRptBaseCondition cond = this.getCond();
        if (cond instanceof GLRptSubLedgerCondition && (bizAccountVirtualAccountMap = ((GLRptSubLedgerCondition)cond).getBizAccountVirtualAccountMap()) != null && !bizAccountVirtualAccountMap.isEmpty()) {
            String sql = "update " + this.accountTmpTable + " set FParentId = ? where FParentId = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            int count = 0;
            for (Map.Entry<String, String> entry : bizAccountVirtualAccountMap.entrySet()) {
                Object[] params = new Object[]{entry.getValue(), entry.getKey()};
                paramList.add(params);
                if (++count != 1000) continue;
                DbUtil.executeBatch((Context)this.getCtx(), (String)sql, paramList);
                count = 0;
                paramList.clear();
            }
            if (count > 0) {
                DbUtil.executeBatch((Context)this.getCtx(), (String)sql, paramList);
            }
        }
    }
}

