/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;

public class GLRptAmountFilter
implements GLRptFilter {
    private GLRptBaseCondition cond;
    private String tab;
    private boolean isFilterByPeriod = false;

    public GLRptAmountFilter(GLRptBaseCondition cond, String tab) {
        this.cond = cond;
        this.tab = tab;
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.isOptionAmountAndBalZero()) {
            sql.append(" (");
            this.setAmountAndBalZeroFilter(this.tab, sql);
            sql.append(") ");
        } else {
            if (this.cond.isOptionBalanceZero()) {
                sql.append(" (");
                sql.append(this.getBalanceZeroFilter(this.tab));
                sql.append(") ");
            }
            if (this.cond.isOptionAmountZero()) {
                if (this.cond.isOptionBalanceZero()) {
                    sql.append(" and (");
                } else {
                    sql.append(" (");
                }
                sql.append(this.getAmountZeroFilter(this.tab));
                sql.append(") ");
            }
        }
        return sql.toString();
    }

    private void setAmountAndBalZeroFilter(String tab, StringBuffer sql) throws EASBizException, BOSException {
        sql.append(this.getBalanceZeroFilter(tab)).append(" or ").append(this.getAmountZeroFilter(tab));
    }

    private String getBalanceZeroFilter(String tab) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.isShowFor()) {
            this.setBalanceZeroFilter(tab, sql, GLRptField.endBalanceFor);
        }
        if (this.cond.isShowLocal()) {
            if (this.cond.isShowFor()) {
                sql.append(" or ");
            }
            this.setBalanceZeroFilter(tab, sql, GLRptField.endBalanceLocal);
        }
        if (this.cond.isShowRpt()) {
            if (this.cond.isShowFor() || this.cond.isShowLocal()) {
                sql.append(" or ");
            }
            this.setBalanceZeroFilter(tab, sql, GLRptField.endBalanceRpt);
        }
        return sql.toString();
    }

    private void setBalanceZeroFilter(String tab, StringBuffer sql, GLRptField endBalField) {
        sql.append(tab).append(".").append(endBalField.getName()).append(" <> 0 ");
    }

    public void setFilterByPeriod(boolean isFilterByPeriod) {
        this.isFilterByPeriod = isFilterByPeriod;
    }

    private String getAmountZeroFilter(String tab) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.isFilterByPeriod) {
            sql.append(this.getPeriodFilter(tab)).append(" and ");
        }
        sql.append(" (");
        if (this.cond.isShowFor()) {
            this.setAmountZeroFilter(tab, sql, GLRptField.debitFor, GLRptField.creditFor);
        }
        if (this.cond.isShowLocal()) {
            if (this.cond.isShowFor()) {
                sql.append(" or ");
            }
            this.setAmountZeroFilter(tab, sql, GLRptField.debitLocal, GLRptField.creditLocal);
        }
        if (this.cond.isShowRpt()) {
            if (this.cond.isShowFor() || this.cond.isShowLocal()) {
                sql.append(" or ");
            }
            this.setAmountZeroFilter(tab, sql, GLRptField.debitRpt, GLRptField.creditRpt);
        }
        if (this.cond.isAmountZeroByVoucher()) {
            sql.append(" or ").append(tab).append(".fdetailcount > 0 ");
        }
        sql.append(")");
        return "(" + sql.toString() + ")";
    }

    private void setAmountZeroFilter(String tab, StringBuffer sql, GLRptField debitField, GLRptField creditField) {
        sql.append(tab).append(".").append(debitField.getName()).append(" <> 0 or ").append(tab).append(".").append(creditField.getName()).append(" <> 0 ");
    }

    private String getPeriodFilter(String tab) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(tab).append(".").append("FPeriod").append(" in ").append(this.cond.getPeriodNumbersInSql(false));
        return sql.toString();
    }
}

