/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.SelectedAsstItemFilter;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GLRptAsstAccountFilter
implements GLRptFilter {
    private static final String AND = " and ";
    private Context ctx;
    private List asstActList;
    private AsstactTypeEntity at;
    private String field;
    private String hgAlias;
    private String fieldCAA;
    private boolean isOnlyQty = false;
    private String fieldCompany;
    private GLRptAsstactBaseCondition cond;
    private GLRptSelector selector;
    private int topHgNum = 100;
    private IRowSet hgIdRs;
    protected Set assAccIdSet;
    private boolean isBizCode;

    public void setBizCode(boolean isBizCode) {
        this.isBizCode = isBizCode;
    }

    public GLRptAsstAccountFilter(Context ctx, GLRptAsstactBaseCondition cond, GLRptSelector selector, String field, String fieldCompany) throws EASBizException, BOSException {
        this(ctx, cond, selector, field, fieldCompany, GLRptDataTable.HG.getAlias(), GLRptDataTable.HG.getAlias() + ".FAsstAccountID", false);
    }

    public GLRptAsstAccountFilter(Context ctx, GLRptAsstactBaseCondition cond, GLRptSelector selector, String field, String fieldCompany, String hgAlias, String fieldCAA, boolean isOnlyQty) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.cond = cond;
        this.selector = selector;
        this.asstActList = cond.getAsstActList();
        this.field = field;
        this.fieldCompany = fieldCompany;
        this.hgAlias = hgAlias;
        this.fieldCAA = fieldCAA;
        this.isOnlyQty = isOnlyQty;
    }

    public void setAsstactType(AsstactTypeEntity at) {
        this.at = at;
        this.asstActList = new ArrayList();
        this.asstActList.add(at);
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        String hgIdSql;
        StringBuffer sql = new StringBuffer();
        StringBuffer idStr = new StringBuffer();
        Iterator itaa = this.cond.getAsstAccountIdSet().iterator();
        while (itaa.hasNext()) {
            if (idStr.length() > 0) {
                idStr.append(",");
            }
            idStr.append("'").append(itaa.next()).append("'");
        }
        if (idStr.length() > 0) {
            sql.append(this.fieldCAA + " in (" + idStr + ") ");
        }
        if (this.isOnlyQty) {
            if (sql.length() > 0) {
                sql.append(AND);
            }
            sql.append("CAA.FIsQty = 1 ");
        }
        for (AsstactTypeEntity at : this.asstActList) {
            if (!this.cond.isFilterByCat() || at.getAsstGroup() == null) continue;
            StringBuffer groupFilterSql = new StringBuffer();
            String detailTab = at.getTableName();
            detailTab = detailTab.equalsIgnoreCase("T_BD_Material") ? detailTab + "GroupDetial" : detailTab + "GroupDetail";
            if (!at.isBasicCat()) {
                groupFilterSql.append(" select ").append(GLRptDaoUtil.getGroupField(at)).append(" from ").append(detailTab).append(" t ");
            } else {
                groupFilterSql.append(" select ").append(GLRptDaoUtil.getField(at)).append(" from ").append(detailTab).append(" t ");
            }
            groupFilterSql.append(" where ").append(GLRptDaoUtil.getGroupField(at)).append(" in ('").append(at.getAsstGroup().replaceAll(",", "','")).append("')");
            if (sql.length() > 0) {
                sql.append(AND);
            }
            if (!at.isBasicCat()) {
                sql.append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getGroupField(at)).append(" in (").append(groupFilterSql).append(")");
                continue;
            }
            sql.append(at.getHgAttribute()).append(".fid in (").append(groupFilterSql).append(")");
        }
        if (!this.isBizCode && !StringUtils.isEmpty((String)(hgIdSql = this.getHgIdSql(false)))) {
            if (sql.length() > 0) {
                sql.append(AND);
            }
            sql.append(this.field).append(" in (");
            IRowSet rs = this.getHgIdList();
            if (rs == null || rs.size() >= this.topHgNum) {
                sql.append(hgIdSql);
            } else {
                try {
                    if (rs.next()) {
                        sql.append("'").append(rs.getString("fid")).append("'");
                    } else {
                        sql.append("''");
                    }
                    while (rs.next()) {
                        sql.append(",'").append(rs.getString("fid")).append("'");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
            return sql.append(")").toString();
        }
        return sql.toString();
    }

    protected IRowSet getHgIdList() throws BOSException, EASBizException {
        String sql;
        if (this.hgIdRs == null && !StringUtils.isEmpty((String)(sql = this.getHgIdSql(true)))) {
            this.hgIdRs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        }
        try {
            if (this.hgIdRs != null) {
                this.hgIdRs.beforeFirst();
            }
        }
        catch (SQLException e) {
            throw new BOSException(" RowSet beforeFirst error!", (Throwable)e);
        }
        return this.hgIdRs;
    }

    protected String getHgIdSql(boolean isTopRecords) throws EASBizException, BOSException {
        String hgFilter = this.getHGFilterSQL(false, isTopRecords);
        if (!StringUtils.isEmpty((String)hgFilter)) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select ");
            if (isTopRecords) {
                sql.append("top ").append(this.topHgNum).append(" ");
            }
            sql.append(this.hgAlias).append(".fid from t_bd_assistanthg ").append(this.hgAlias);
            sql.append(" where ").append(hgFilter);
            return sql.toString();
        }
        return null;
    }

    private String getHGFilterSQL(boolean isFilterAccountCaa, boolean isTopRecords) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        for (AsstactTypeEntity at : this.asstActList) {
            String fieldHg = this.hgAlias + "." + at.getHgField();
            if (at.getFrom() != null || at.getTo() != null || at.getDist() != null) {
                if (sql.length() > 0) {
                    sql.append(AND);
                }
                sql.append(fieldHg).append(" in (");
                sql.append(this.getAssistItemFilterSQL(at)).append(")");
            }
            if (!this.cond.getRptParams().useAccountPermission() || at.getPermissionItem() == null) continue;
            String strPermItem = at.getPermissionItem();
            boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU(this.ctx, strPermItem);
            CompanyDisplayModeEnum companyDisplayMode = this.cond.getCompanyDisplayMode();
            String permSql = GLRptDaoUtil.getDataPermSqlFilter(this.ctx, companyDisplayMode, this.cond.getCompany(), this.cond.getCompanyIdsStr(), strPermItem, isPermissionByCU, fieldHg, this.fieldCompany);
            if (StringUtils.isEmpty((String)permSql)) continue;
            if (sql.length() > 0) {
                sql.append(AND);
            }
            sql.append(permSql);
        }
        SelectedAsstItemFilter builder = new SelectedAsstItemFilter(this.ctx, this.cond, this.hgAlias, this.selector);
        String asstFilter = builder.getSQL();
        if (!StringUtils.isEmpty((String)asstFilter)) {
            if (sql.length() > 0) {
                sql.append(AND);
            }
            sql.append(asstFilter);
        }
        if (this.cond.getDataSourceTable() == null) {
            this.setAsstGroupFilter(sql, isTopRecords);
        }
        return sql.toString();
    }

    private String getAssistItemFilterSQL(AsstactTypeEntity at) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(at.getHgAttribute()).append(".fid from ").append(at.getTableName()).append(" ").append(at.getHgAttribute());
        boolean f = false;
        if (at.isGeneralActType()) {
            sql.append(" where ");
            f = true;
            sql.append(at.getHgAttribute()).append(".FGroupID= '").append(at.getGeneralAsstactGroupId()).append("'");
        }
        Object[] assists = null;
        Object dist = at.getDist();
        if (dist instanceof List) {
            assists = ((List)dist).toArray();
        } else if (dist instanceof Set) {
            assists = ((Set)dist).toArray();
        }
        if (assists != null && assists.length > 0) {
            boolean isGeneralActType;
            sql.append(f ? AND : " where ");
            boolean bl = isGeneralActType = at.getHgAttribute() != null && at.getHgAttribute().startsWith("generalAssActType");
            if (isGeneralActType) {
                sql.append(at.getHgAttribute()).append(".").append("flongnumber").append(" in (");
            } else {
                sql.append(at.getHgAttribute()).append(".").append("fnumber").append(" in (");
            }
            String asstActId = null;
            DataBaseInfo singleDistValue = null;
            for (int i = 0; i < assists.length; ++i) {
                String number;
                Object obj = assists[i];
                if (obj instanceof AssistViewFilterInfo) {
                    number = ((AssistViewFilterInfo)obj).getNumber();
                    Set ids = ((AssistViewFilterInfo)obj).getIdSet();
                    if (!ids.isEmpty()) {
                        asstActId = (String)ids.iterator().next();
                    }
                } else if (obj instanceof Map) {
                    number = (String)((Map)obj).get("number");
                    asstActId = (String)((Map)obj).get("id");
                } else {
                    number = (String)obj;
                }
                if (isGeneralActType && asstActId != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(asstActId);
                    singleDistValue = GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getDataBaseInfo((IObjectPK)pk);
                    number = (String)singleDistValue.get("longnumber");
                }
                sql.append("'").append(number).append("', ");
            }
            sql.deleteCharAt(sql.lastIndexOf(",")).append(")");
        } else {
            DataBaseInfo toValue;
            DataBaseInfo fromValue = (DataBaseInfo)at.getFrom();
            if (fromValue != null) {
                DataBaseInfo data;
                boolean useLongNumber;
                if (at.isGeneralActType()) {
                    ObjectUuidPK pk = new ObjectUuidPK(fromValue.getId());
                    fromValue = GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getDataBaseInfo((IObjectPK)pk);
                }
                sql.append(f ? AND : " where ");
                if (!f) {
                    f = true;
                }
                if ((useLongNumber = this.isUseLongNumber(at, fromValue)) && fromValue.get("longnumber") == null && (data = this.findAsstActObject(this.cond.getCtx(), at.getHgAttribute(), fromValue.getString("id"))) != null) {
                    fromValue = data;
                }
                if (!useLongNumber && fromValue.get("number") == null && (data = this.findAsstActObject(this.cond.getCtx(), at.getHgAttribute(), fromValue.getString("id"))) != null) {
                    fromValue = data;
                }
                String fromNumber = this.getActLongNumber(useLongNumber, fromValue);
                sql.append(at.getHgAttribute()).append(".").append(useLongNumber ? "flongnumber" : "fnumber").append(" >= '").append(fromNumber).append("'");
            }
            if ((toValue = (DataBaseInfo)at.getTo()) != null) {
                DataBaseInfo data;
                if (at.isGeneralActType()) {
                    ObjectUuidPK pk = new ObjectUuidPK(toValue.getId());
                    toValue = GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getDataBaseInfo((IObjectPK)pk);
                }
                sql.append(f ? AND : " where ");
                boolean useLongNumber = this.isUseLongNumber(at, toValue);
                if (useLongNumber && toValue.get("longnumber") == null && (data = this.findAsstActObject(this.cond.getCtx(), at.getHgAttribute(), toValue.getString("id"))) != null) {
                    toValue = data;
                }
                if (!useLongNumber && toValue.get("number") == null && (data = this.findAsstActObject(this.cond.getCtx(), at.getHgAttribute(), toValue.getString("id"))) != null) {
                    toValue = data;
                }
                String toNumber = this.getActLongNumber(useLongNumber, toValue);
                if (at.isUseLevel() && toValue.getString("isLeaf") != "true" && toValue.getString("isLeaf") != null) {
                    toNumber = toNumber + "Z";
                }
                sql.append(at.getHgAttribute()).append(".").append(useLongNumber ? "flongnumber" : "fnumber").append(" <= '").append(toNumber).append("'");
            }
        }
        return sql.toString();
    }

    private void setAsstGroupFilter(StringBuffer sql, boolean isTopRecords) throws BOSException {
        for (AsstactTypeEntity at : this.asstActList) {
            if (at == null || at.getAsstGroup() == null || !this.cond.isFilterByCat()) continue;
            if (sql.length() > 0) {
                sql.append(AND);
            }
            sql.append(" exists (").append(this.getAsstGroupFilterSQL(at, isTopRecords));
            sql.append(" and pgp.fid in ").append("('").append(at.getAsstGroup().replaceAll(",", "','")).append("'))");
        }
    }

    private StringBuffer getAsstGroupFilterSQL(AsstactTypeEntity at, boolean isTopRecords) {
        StringBuffer asstgp = new StringBuffer();
        if (at.isBasicCat()) {
            asstgp.append(" select 1 from ").append(at.getTableName()).append(" ").append(at.getHgAttribute());
            asstgp.append(" inner join ").append(at.getTableName());
            if (at.getTableName().equalsIgnoreCase("T_BD_Material")) {
                asstgp.append("GroupDetial");
            } else {
                asstgp.append("GroupDetail");
            }
            asstgp.append(" gpd on gpd.f").append(at.getTableName().substring(5)).append("id =").append(at.getHgAttribute()).append(".fid");
            asstgp.append(" inner join ").append(at.getGroupTable());
            asstgp.append(" gp on gp.fid = ").append("gpd.f").append(at.getTableName().substring(5)).append("groupid");
        } else {
            asstgp.append(" select 1 from ").append(at.getGroupTable()).append(" gp ");
        }
        if (SQLUtil.isSupportCharIndexToLike(this.ctx)) {
            asstgp.append(" inner join ").append(at.getGroupTable()).append(" pgp on (gp.flongnumber like concat(pgp.flongnumber, '!%') or gp.fid = pgp.fid) ");
        } else {
            asstgp.append(" inner join ").append(at.getGroupTable()).append(" pgp on (charindex(pgp.flongnumber||'!', gp.flongnumber) = 1 or gp.fid = pgp.fid) ");
        }
        if (at.isBasicCat()) {
            if (this.cond instanceof GLRptSubLedgerCondition && at.getTableName().equalsIgnoreCase("T_BD_Customer") && ((GLRptSubLedgerCondition)this.cond).isShowOppAccount()) {
                asstgp.append(" where ").append(at.getHgAttribute()).append(".fid = ").append("gpd").append(".").append(at.getHgField());
            } else {
                asstgp.append(" where ").append(at.getHgAttribute()).append(".fid = ").append(this.hgAlias).append(".").append(at.getHgField());
            }
        } else if (!isTopRecords && this.selector != null && this.selector.contains(at.getHgAttribute() + "GroupID")) {
            asstgp.append(" where ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getGroupField(at)).append(" = gp.fid");
        } else {
            asstgp.append(" inner join ").append(GLRptDaoUtil.getGroupDetailTable(at)).append(" ").append(at.getHgAttribute()).append("GDet ");
            asstgp.append(" on gp.fid = ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getGroupField(at));
            asstgp.append(" where ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getField(at)).append(" = ");
            if (this.cond instanceof GLRptSubLedgerCondition && (at.getTableName().equalsIgnoreCase("T_BD_Material") || at.getTableName().equalsIgnoreCase("T_BD_Supplier") || at.getTableName().equalsIgnoreCase("T_BD_Customer")) && ((GLRptSubLedgerCondition)this.cond).isShowOppAccount()) {
                asstgp.append(this.hgAlias).append(".").append(at.getHgField());
            } else {
                asstgp.append(GLRptDataTable.HG.getAlias()).append(".").append(at.getHgField());
            }
        }
        return asstgp;
    }

    private boolean isUseLongNumber(AsstactTypeEntity at, DataBaseInfo value) throws EASBizException, BOSException {
        boolean useLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
        return at.isUseLongNumber() || at.isUseLevel() && !value.getBoolean("isLeaf");
    }

    protected String getActLongNumber(boolean useLongNumber, Object value) throws BOSException, EASBizException {
        if (value instanceof DataBaseInfo) {
            DataBaseInfo obj = (DataBaseInfo)value;
            if (useLongNumber) {
                return obj.get("longnumber").toString();
            }
            return obj.get("number").toString();
        }
        return value.toString();
    }

    public boolean isMulHG() throws EASBizException, BOSException {
        if (!this.isFullHGFromTo()) {
            return true;
        }
        if (this.isBizCode) {
            return true;
        }
        IRowSet rs = this.getHgIdList();
        return rs == null || this.getHgIdList().size() > 1;
    }

    public boolean isFullHGFromTo() {
        for (AsstactTypeEntity at : this.asstActList) {
            if (at.getFrom() != null && at.getTo() != null) continue;
            return false;
        }
        return true;
    }

    private DataBaseInfo findAsstActObject(Context ctx, String asstHGAttribute, String id) throws BOSException {
        IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        BOSObjectType type = iAssistantHG.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(type);
        PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
        Iterator itr = props.iterator();
        LinkPropertyInfo pi = null;
        DataBaseInfo data = null;
        while (itr.hasNext()) {
            PropertyInfo p = (PropertyInfo)itr.next();
            if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
            pi = (LinkPropertyInfo)p;
            break;
        }
        if (pi != null) {
            EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
            String strFacotry = eobj.getBusinessImplFactory();
            String strLocal = eobj.getBusinessImplName();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("longnumber"));
            sic.add(new SelectorItemInfo("CU.id"));
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("id", (Object)id);
            view.setFilter(filter);
            String strMethod = "getDataBaseCollection";
            Class[] argTypes = new Class[]{view.getClass()};
            Object[] args = new Object[]{view};
            Object result = null;
            try {
                result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
            }
            catch (Exception e) {
                result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, eobj.getType());
            }
            if (result != null) {
                DataBaseCollection collection = (DataBaseCollection)result;
                if (data == null && collection.size() > 0) {
                    data = collection.get(0);
                }
            }
        }
        return data;
    }
}

