/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class GLRptAsstActTypeBalPageQuery
extends GLRptPageQuery {
    private static final Logger logger = Logger.getLogger(GLRptAsstActTypeBalPageQuery.class);
    private GLRptAsstActTypeBalanceCondition cond;

    public GLRptAsstActTypeBalPageQuery(Context ctx, GLRptAsstActTypeBalanceCondition cond) {
        super(ctx, cond);
        this.cond = cond;
    }

    @Override
    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode()) {
            sql.append(" and av.fcompanyid = '").append(this.cond.getCompanyId()).append("' and av.faccounttableid = '").append(this.cond.getAccountTableId()).append("' ");
        }
        sql.append(" left outer join t_bd_accountview pav on pav.fid = av.fparentid ");
        if (this.cond.isAllCurrency()) {
            sql.append(" left outer join t_bd_currency cy on cy.fid = t.fcurrencyid ");
        }
        if (this.cond.isShowByStandardMU()) {
            if (this.cond.getRptParams().isQtyAsst()) {
                sql.append(" left outer  join t_bd_asstaccount asstAccount on av.fcaa = asstAccount.fid \r\n");
                sql.append(" left outer  join t_bd_measureUnitGroup muGroup on muGroup.fid = asstAccount.FMEASUREUNITGROUPID \r\n");
            } else {
                sql.append(" left outer  join t_bd_measureUnitGroup muGroup on muGroup.fid = av.FMEASUREUNITGROUPID \r\n");
            }
            sql.append(" left outer  join t_bd_measureUnit mu on mu.fid = muGroup.FDEFAULTUNITID ");
        } else if (this.cond.isShowQty()) {
            sql.append(" left outer join T_BD_MeasureUnit mu on mu.fid = t.FMeasureUnitID ");
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sql.append(this.getJoinDataOrgSQL());
        }
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            sql.append(" left outer join ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid = t.").append(at.getHgField());
            if (at.isShowAsstGroup()) {
                sql.append(" left outer join ").append(at.getGroupTable()).append(" ").append(at.getHgAttribute()).append(this.getAsstGroupAlias()).append(" on ").append(at.getHgAttribute()).append(this.getAsstGroupAlias()).append(".FID=").append("t.").append(at.getHgAttribute()).append("GroupID");
                continue;
            }
            if (!this.cond.getRptParams().isShowLongNameForGeneral() || !at.isUseGroup()) continue;
            sql.append(" left outer join ").append(at.getGroupTable()).append(" ").append(at.getHgAttribute()).append(this.getAsstGroupAlias()).append(" on ").append(at.getHgAttribute()).append(this.getAsstGroupAlias()).append(".FID=").append(at.getHgAttribute()).append(".").append(at.getGroupField());
        }
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        AsstactTypeEntity at;
        int i;
        boolean flags = true;
        GLRptSQLOrder order = new GLRptSQLOrder();
        order.add("t.isTotal");
        boolean noLevelOrUp = true;
        List actTypeList = this.cond.getAsstActList();
        for (i = 0; i < actTypeList.size(); ++i) {
            at = (AsstactTypeEntity)actTypeList.get(i);
            if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP || !at.isShowAsstGroup()) continue;
            noLevelOrUp = false;
        }
        if (this.cond.isBizCode()) {
            order.add("t.bacNumber");
        } else {
            for (i = 0; i < actTypeList.size(); ++i) {
                String alias;
                at = (AsstactTypeEntity)actTypeList.get(i);
                String string = alias = at.isShowAsstGroup() ? at.getHgAttribute() + this.getAsstGroupAlias() : at.getHgAttribute();
                if (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) {
                    if (!this.cond.isAllCurrency()) {
                        flags = false;
                    }
                    if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                        if (this.cond.isShowAsstItemTotal()) {
                            order.add("t.asstactTypeAllIsTotal");
                        }
                        order.add("case when " + GLRptField.accountNumber.getSelect() + " is null then N'0' else " + GLRptField.accountNumber.getSelect() + " end ");
                    }
                    if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
                        if (this.cond.isShowAsstItemTotal() && flags) {
                            order.add("t.asstactTypeIsTotal");
                        }
                        if (this.cond.isAllCurrency()) {
                            order.add("case when " + GLRptField.currencyNumber.getSelect() + " is null then '0' else " + GLRptField.currencyNumber.getSelect() + " end ");
                        }
                    }
                    order.add("case when " + alias + ".Flevel = 1 then " + alias + ".flongnumber else LEFT(" + alias + ".flongnumber,CHARINDEX('!'," + alias + ".flongnumber) -1) end");
                    if (at.isShowAsstGroup()) {
                        if (actTypeList.size() > 1) {
                            for (int j = 0; j < actTypeList.size(); ++j) {
                                if (i == j) continue;
                                AsstactTypeEntity tempAt = (AsstactTypeEntity)actTypeList.get(j);
                                order.add(tempAt.getHgAttribute() + "." + (tempAt.isUseLongNumber() || tempAt.getCollect() == CollectEnum.LEVEL || tempAt.getCollect() == CollectEnum.UP ? "flongnumber" : "fnumber"));
                            }
                        }
                        order.add(at.getHgAttribute() + this.getAsstGroupAlias() + ".flongnumber");
                        order.add("case when t." + at.getHgField() + " is null then " + at.getHgAttribute() + this.getAsstGroupAlias() + ".FLevel else " + at.getHgAttribute() + this.getAsstGroupAlias() + ".FLevel + 1 end");
                        order.add(at.getHgAttribute() + ".fnumber");
                    } else {
                        order.add(at.getHgAttribute() + ".flongnumber");
                    }
                    if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() || !this.cond.isShowAsstItemTotal()) continue;
                    order.add("t.asstactTypeAllIsTotal");
                    continue;
                }
                if (!noLevelOrUp) continue;
                order.add(at.getHgAttribute() + "." + (at.isUseLongNumber() || at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP ? "flongnumber" : "fnumber"));
            }
        }
        if (this.cond.isShowAsstItemTotal() && flags && !order.getFields().contains("t.asstactTypeIsTotal")) {
            order.add("t.asstactTypeIsTotal");
        }
        if (this.cond.isAllCurrency() && !order.getFields().contains("case when cy.fnumber is null then '0' else cy.fnumber end")) {
            order.add("case when " + GLRptField.currencyNumber.getSelect() + " is null then '0' else " + GLRptField.currencyNumber.getSelect() + " end ");
        }
        if (!order.getFields().contains("case when av.fnumber is null then N'0' else av.fnumber end")) {
            order.add("case when " + GLRptField.accountNumber.getSelect() + " is null then N'0' else " + GLRptField.accountNumber.getSelect() + " end ");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            order.add("t.companyIsTotal", SortType.DESCEND);
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            if (this.cond.isShowQty()) {
                order.add("mu.FNumber", SortType.ASCEND);
            }
            order.add(this.getOrgOrderSql());
        }
        return order;
    }

    protected String getJoinDataOrgSQL() {
        return " left outer join t_org_company cp on cp.fid = t.forgunitid  \r\n";
    }

    protected String getOrgOrderSql() {
        return "cp.flongnumber";
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String sql = super.getWhereSQL();
        if (!this.cond.isShowLeafAccount()) {
            if (!StringUtils.isEmpty((String)sql)) {
                sql = sql + " and ";
            }
            sql = sql + "  ((av.flevel >= " + this.cond.getAccountLevelStart() + "and av.flevel <=" + this.cond.getAccountLevelEnd() + ") or av.fid is null)";
        }
        boolean asstactTypeIsTotalFlags = true;
        boolean asstactTypeAllIsTotalFlags = false;
        List actTypeList = this.cond.getAsstActList();
        for (int i = 0; i < actTypeList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actTypeList.get(i);
            if (at.getCollect() == CollectEnum.UP) {
                if (!StringUtils.isEmpty((String)sql)) {
                    sql = sql + " and ";
                }
                if (at.isShowAsstGroup()) {
                    sql = sql + "((case when t." + at.getHgField() + " is null then " + at.getHgAttribute() + this.getAsstGroupAlias() + ".FLevel else " + at.getHgAttribute() + this.getAsstGroupAlias() + ".FLevel + 1 end <=" + at.getSelectedLevel() + ") ";
                    sql = sql + " or " + at.getHgAttribute() + this.getAsstGroupAlias() + ".FLevel is null )";
                } else {
                    sql = sql + "(" + at.getHgAttribute() + ".FLevel <=" + at.getSelectedLevel();
                    sql = sql + " or " + at.getHgAttribute() + ".FLevel is null )";
                }
            }
            if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
            if (CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode() && CompanyDisplayModeEnum.details != this.cond.getCompanyDisplayMode() && !this.cond.isAllCurrency()) {
                asstactTypeIsTotalFlags = false;
            }
            asstactTypeAllIsTotalFlags = true;
        }
        if (this.cond.isOptionBalanceZero() && (this.cond.getCompany().isIsBizUnit() || this.sumItems == null)) {
            if (!StringUtils.isEmpty((String)sql)) {
                sql = sql + " and ";
            }
            StringBuilder optionBalanceZeroFilter = new StringBuilder();
            optionBalanceZeroFilter.append("(t.isTotal = 1 ");
            if (!this.cond.isBizCode() && this.cond.isShowAsstItemTotal() && asstactTypeIsTotalFlags) {
                optionBalanceZeroFilter.append(" or t.asstactTypeIsTotal = 1 ");
            }
            if (!this.cond.isBizCode() && this.cond.isShowAsstItemTotal() && asstactTypeAllIsTotalFlags) {
                optionBalanceZeroFilter.append(" or t.asstactTypeAllIsTotal = 1 ");
            }
            if (this.cond.isShowFor()) {
                optionBalanceZeroFilter.append(" or t.FEndBalanceFor <> 0 ");
            }
            if (this.cond.isShowLocal()) {
                optionBalanceZeroFilter.append(" or t.FEndBalanceLocal <> 0");
            }
            if (this.cond.isShowRpt()) {
                optionBalanceZeroFilter.append(" or t.FEndBalanceRpt <> 0");
            }
            optionBalanceZeroFilter.append(")");
            sql = sql + optionBalanceZeroFilter.toString();
        }
        return sql;
    }

    @Override
    protected void appendRecordID(StringBuffer sql) {
        super.appendRecordID(sql);
        if (this.cond.isShowByStandardMU()) {
            sql.append(" ,mu.fid measureUnitId,mu.fname_").append(this.getCtx().getLocale()).append(" standMeasureUnit");
        }
    }
}

