/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstTreeUserObject;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.TOTAL;
import com.kingdee.eas.fi.gl.rpt.app.DefaultGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.GLRptAsstActTypeBalanceIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.GLRptAsstItemTreeNodeIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstActTypeBalPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalanceBaseDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItemInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GLRptAsstActTypeBalanceDao
extends GLRptBalanceBaseDao {
    private static final Logger logger = Logger.getLogger(GLRptAsstActTypeBalanceDao.class);
    private GLRptAsstActTypeBalanceCondition cond;
    private String sysStatusTmpTable;
    private String asstActTypeName;
    private String assTreeId = null;
    private boolean isYearQuery = false;
    private int pageCount = 50;
    private String endId = null;
    private boolean isFirstPageQuery = true;
    private Map<String, BigDecimal> loadedAccountIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Context ctx;

    public GLRptAsstActTypeBalanceDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptAsstActTypeBalanceCondition)this.getQueryCondition();
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
            this.asstActTypeName = at.getHgAttribute() + "Name";
        }
        this.pageCount = (Integer)ev.get("PAGE_ROW_COUNT");
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        Set<String> moreCompanyIds;
        if (this.cond.getPeriodYearStart() == this.cond.getPeriodYearEnd() && this.cond.getPeriodNumberStart() == 1) {
            this.isYearQuery = true;
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.sysStatusTmpTable = this.createSysStatusTmpTable();
        }
        if (!(moreCompanyIds = GLRptDaoUtil.getMoreBeginPeriodCompanyIds(this.getContex(), this.cond.getCompanyIdsStr(), this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart())).isEmpty()) {
            GLRptAsstActTypeBalanceCondition condition = (GLRptAsstActTypeBalanceCondition)this.cond.clone();
            condition.setCompanys(this.getCompanys(this.cond.getCompanys(), moreCompanyIds));
            condition.setCompanyIdsStr(GLRptDaoUtil.getIdFilter(this.getContex(), moreCompanyIds));
            this.insertAssistBalance(condition, this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart());
        }
        Map<Integer, Set<String>> lessBeginPeriodCompanyIds = GLRptDaoUtil.getLessBeginPeriodCompanyIds(this.getContex(), this.cond.getCompanyIdsStr(), this.cond.getPeriodYearStart(), this.cond.getPeriodNumberStart());
        for (int period : lessBeginPeriodCompanyIds.keySet()) {
            Set<String> lessCompanyIds = lessBeginPeriodCompanyIds.get(period);
            GLRptAsstActTypeBalanceCondition condition = (GLRptAsstActTypeBalanceCondition)this.cond.clone();
            condition.setCompanys(this.getCompanys(this.cond.getCompanys(), lessCompanyIds));
            condition.setCompanyIdsStr(GLRptDaoUtil.getIdFilter(this.getContex(), lessCompanyIds));
            this.insertAssistBalance(condition, period / 100, period % 100);
        }
    }

    @Override
    public GLRptTableHeadInfo initTableHeadInfo() throws BOSException, EASBizException {
        GLRptTableHeadInfo headInfo = new GLRptTableHeadInfo();
        this.addTableHeadColumn(headInfo, new GLRptField("KSQL_SEQ", "INT"));
        if (!this.isCreateSeqTable()) {
            this.addTableHeadColumn(headInfo, new GLRptField("SQL_BATCH", "INT"));
        }
        GLRptSelector selector = this.getGLRptSelector();
        if (this.getGLRptSelector() == null) {
            return headInfo;
        }
        Iterator<GLRptField> it = selector.iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    this.addTableHeadCreditColumn(headInfo, (GLRptField)creditList.get(i));
                }
                creditList.clear();
            }
            if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.addTableHeadColumn(headInfo, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                this.addTableHeadCreditColumn(headInfo, (GLRptField)creditList.get(i));
            }
            creditList.clear();
        }
        this.addSumItemColumn(headInfo);
        headInfo.setHeadTitle(this.getHeadTitles());
        return headInfo;
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = !this.cond.isShowQty() && this.isSingleAmountFiled() ? new String[][]{this.getTitleRow1(), this.getTitleRow2()} : new String[][]{this.getTitleRow1(), this.getTitleRow2(), this.getTitleRow3()};
        return titles;
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        GLRptSumItems sumItem = new GLRptSumItems();
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            sumItem.add(this.getOrgUnitIDField());
            sumItem.setSumGroup("isTotal");
        } else {
            sumItem.setSumGroup("isTotal");
        }
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            AsstactTypeEntity at;
            Iterator it;
            if (this.cond.isBizCode()) {
                sumItem.add(GLRptField.bacId);
                sumItem.add(GLRptField.bacNumber);
                sumItem.add(GLRptField.bacName);
            } else {
                it = this.cond.getAsstActList().iterator();
                at = null;
                while (it.hasNext()) {
                    at = (AsstactTypeEntity)it.next();
                    if (this.isShowAsstGroup(at)) {
                        if (at.isBasicCat()) {
                            sumItem.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "." + at.getGroupField(), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                        } else {
                            sumItem.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "GDet." + GLRptDaoUtil.getGroupField(at), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                        }
                    }
                    sumItem.add(new GLRptField(at.getHgField(), GLRptDataTable.HG.getAlias() + "." + at.getHgField(), "assGrp." + at.getHgAttribute() + ".id", "VARCHAR(44)"));
                }
            }
            if (this.cond.isShowAsstItemTotal()) {
                if (this.cond.isBizCode()) {
                    sumItem.setSumGroup("bacIdIsTotal");
                } else {
                    it = this.cond.getAsstActList().iterator();
                    at = null;
                    while (it.hasNext()) {
                        at = (AsstactTypeEntity)it.next();
                        if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                        sumItem.setSumGroup("asstactTypeAllIsTotal");
                        sumItem.add(GLRptField.accountID);
                    }
                    sumItem.setSumGroup("asstactTypeIsTotal");
                }
            } else {
                it = this.cond.getAsstActList().iterator();
                at = null;
                while (it.hasNext()) {
                    at = (AsstactTypeEntity)it.next();
                    if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                    sumItem.add(GLRptField.accountID);
                }
            }
            sumItem.setSumGroup("companyIsTotal");
        } else {
            if (!this.cond.isShowAsstItemTotal()) {
                return sumItem;
            }
            if (this.cond.isBizCode()) {
                sumItem.setSumGroup("bacIdIsTotal");
            } else {
                Iterator it = this.cond.getAsstActList().iterator();
                AsstactTypeEntity at = null;
                while (it.hasNext()) {
                    at = (AsstactTypeEntity)it.next();
                    if (this.isShowAsstGroup(at)) {
                        if (at.isBasicCat()) {
                            sumItem.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "." + at.getGroupField(), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                            sumItem.add(new GLRptField(at.getHgField(), at.getHgAttribute() + "." + at.getHgField(), "assGrp." + at.getHgAttribute() + ".id", "VARCHAR(44)"));
                            continue;
                        }
                        sumItem.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "GDet." + GLRptDaoUtil.getGroupField(at), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                        continue;
                    }
                    sumItem.add(new GLRptField(at.getHgField(), GLRptDataTable.HG.getAlias() + "." + at.getHgField(), "assGrp." + at.getHgAttribute() + ".id", "VARCHAR(44)"));
                }
                it = this.cond.getAsstActList().iterator();
                boolean flags = true;
                while (it.hasNext()) {
                    at = (AsstactTypeEntity)it.next();
                    if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                    sumItem.setSumGroup("asstactTypeAllIsTotal");
                    sumItem.add(GLRptField.accountID);
                    if (this.cond.isAllCurrency()) continue;
                    flags = false;
                }
                if (flags) {
                    sumItem.setSumGroup("asstactTypeIsTotal");
                }
            }
        }
        return sumItem;
    }

    private boolean isShowAsstGroup(AsstactTypeEntity at) {
        return at.isMultilevel() && at.isUseGroup() && (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP);
    }

    protected void addTableHeadCreditColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        String prefix = null;
        if (field.isBegin()) {
            prefix = "FBegin";
        } else if (field.isEnd()) {
            prefix = "FEnd";
        }
        GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
        colInfo.setNumeral(true);
        colInfo.setColName(prefix + "Credit" + field.getBalSuffix());
        colInfo.setWidth(field.getLength());
        if (field.isQty()) {
            colInfo.setScale(this.cond.getQtyScale());
        } else if (field.isPrice()) {
            colInfo.setScale(this.cond.getPriceScale());
        } else {
            CurrencyInfo currency = this.getQueryCurrencyInfo();
            if (currency != null && field.getName().endsWith("For")) {
                colInfo.setScale(currency.getPrecision());
            } else if (field.getName().endsWith("Local")) {
                colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
            } else if (this.getCompany().getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                colInfo.setScale(this.getCompany().getReportCurrency().getPrecision());
            }
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field.isBegin() || field.isEnd()) {
            String prefix = null;
            if (field.isBegin()) {
                prefix = "FBegin";
            } else if (field.isEnd()) {
                prefix = "FEnd";
            }
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setNumeral(true);
            colInfo.setColName(prefix + "Debit" + field.getBalSuffix());
            colInfo.setWidth(field.getLength());
            if (field.isQty()) {
                colInfo.setScale(this.cond.getQtyScale());
            } else if (field.isPrice()) {
                colInfo.setScale(this.cond.getPriceScale());
            } else {
                CurrencyInfo currency = this.getQueryCurrencyInfo();
                if (currency != null && field.getName().endsWith("For")) {
                    colInfo.setScale(currency.getPrecision());
                } else if (field.getName().endsWith("Local")) {
                    colInfo.setScale(this.getCompany().getBaseCurrency().getPrecision());
                } else if (this.getCompany().getReportCurrency() != null && field.getName().endsWith("Rpt")) {
                    colInfo.setScale(this.getCompany().getReportCurrency().getPrecision());
                }
            }
            if (colInfo != null && this.getFreezeField() == field) {
                colInfo.setFreeze(true);
            }
        } else if (GLRptField.accountDC == field) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setWidth(-1);
        } else if (field.getName().equals(this.asstActTypeName)) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setWidth(field.getLength());
            if (field.getLength() == -1) {
                colInfo.setHide(true);
            }
            if (colInfo != null && this.getFreezeField() == field) {
                colInfo.setFreeze(true);
            }
            colInfo.setTreeNode(true);
            if (!this.isOrgBizUnitAndISHGTree()) {
                colInfo.setExpandNode(false);
            }
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field.isBegin() || field.isEnd()) {
            colTitles.add(field.getTitle());
            colTitles.add(field.getTitle());
        } else if (field.isDebit() || field.isCredit()) {
            colTitles.add("period_happened");
        } else if (field.isYearDebit() || field.isYearCredit()) {
            colTitles.add("sum_year");
        } else {
            colTitles.add(field.getTitle());
        }
    }

    @Override
    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    colTitles.add("dir_credit");
                }
                creditList.clear();
            }
            if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.setRow2Title(colTitles, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                colTitles.add("dir_credit");
            }
            creditList.clear();
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    @Override
    protected void setRow2Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.isBegin() || field.isEnd()) {
            colTitles.add("dir_debit");
        } else if (field.isYearDebit()) {
            colTitles.add("dir_debit");
        } else if (field.isYearCredit()) {
            colTitles.add("dir_credit");
        } else {
            colTitles.add(field.getTitle());
        }
    }

    protected String[] getTitleRow3() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        ArrayList<GLRptField> creditList = new ArrayList<GLRptField>();
        String lastPrefix = null;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            if (!creditList.isEmpty() && !field.getName().startsWith(lastPrefix)) {
                for (int i = 0; i < creditList.size(); ++i) {
                    this.setRow3Title(colTitles, (GLRptField)creditList.get(i));
                }
                creditList.clear();
            }
            if (field.isBegin()) {
                creditList.add(field);
                lastPrefix = "FBegin";
            } else if (field.isEnd()) {
                creditList.add(field);
                lastPrefix = "FEnd";
            } else {
                lastPrefix = null;
            }
            this.setRow3Title(colTitles, field);
        }
        if (!creditList.isEmpty()) {
            for (int i = 0; i < creditList.size(); ++i) {
                this.setRow3Title(colTitles, (GLRptField)creditList.get(i));
            }
            creditList.clear();
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void setRow3Title(List colTitles, GLRptField field) throws EASBizException, BOSException {
        if (field.getType() == "NUMERIC(29,10)") {
            if (field.isQty()) {
                colTitles.add("asst_quantity");
            } else if (field.isPrice()) {
                colTitles.add("price");
            } else if (this.isSingleAmountFiled()) {
                colTitles.add("money_amount");
            } else if (field.getName().endsWith("For")) {
                colTitles.add("currency_for");
            } else if (field.getName().endsWith("Local")) {
                colTitles.add("currency_local");
            } else if (field.getName().endsWith("Rpt")) {
                colTitles.add("currency_rpt");
            }
        } else {
            colTitles.add(field.getTitle());
        }
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected String getSumItemSQL(GLRptSumItemInfo item, List groupFields) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct ");
        sql.append(" 1 ").append(item.getName());
        groupFields.add(item.getName());
        List fields = item.getFields();
        if (fields == null || fields.isEmpty()) {
            sql.append(" from ").append(this.getDataSourceTableName());
            return sql.toString();
        }
        StringBuffer where = new StringBuffer();
        boolean needContact = false;
        String lastFieldName = null;
        for (int i = 0; i < fields.size(); ++i) {
            GLRptField field = (GLRptField)fields.get(i);
            if (field.getQueryField() == null) continue;
            String fieldName = field.getName();
            sql.append(",");
            if ("companyIsTotal".equals(item.getName()) && fieldName.equals("FCurrencyID")) {
                sql.append(" t.").append(fieldName);
                groupFields.add(fieldName);
                continue;
            }
            if (i == 0) {
                where.append(" where ( ");
            } else if (needContact) {
                if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
                    where.append(" or ");
                } else if (!StringUtils.isEmpty(lastFieldName) && lastFieldName.endsWith("GroupID") && fieldName != null && !fieldName.endsWith("GroupID")) {
                    where.append(" or ");
                } else {
                    where.append(" and ");
                }
            }
            if ("companyIsTotal".equals(item.getName()) && this.getOrgUnitIDField().equals(field)) {
                if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                    sql.append("'").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
                } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
                    sql.append("'").append(this.cond.getCompany().getId().toString()).append("'");
                    sql.append(" ").append(fieldName);
                }
                groupFields.add(this.getOrgUnitIDField().getName());
                needContact = false;
                continue;
            }
            sql.append(" t.").append(fieldName);
            where.append(" t.").append(fieldName).append(" is not null");
            groupFields.add(fieldName);
            needContact = true;
            lastFieldName = fieldName;
        }
        if (where.length() > 1) {
            where.append(")");
        }
        GLRptPageQuery query = this.getGLRptDataQuery();
        query.setDataSourceTable(this.getDataSourceTable());
        String filter = query.getWhereSQL();
        if (filter != null && filter.trim().length() > 0) {
            if (where.length() == 0) {
                where.append(" where ");
            } else {
                where.append(" and ");
            }
            where.append(" (").append(filter).append(")");
        }
        if (item.getName().equals("asstactTypeIsTotal")) {
            Iterator it = this.cond.getAsstActList().iterator();
            AsstactTypeEntity at = null;
            at = null;
            while (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
                if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                where.append(" and (t.asstacttypeAllIsTotal = 0) ");
            }
        }
        sql.append(" from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        sql.append(where);
        try {
            return KSqlUtil.optimize((String)sql.toString());
        }
        catch (SqlTranslateException e) {
            throw new BOSException("SqlTranslateException", (Throwable)e);
        }
    }

    @Override
    protected void insertSumItem() throws EASBizException, BOSException {
        if (!this.cond.isShowLeafAccount() && this.getIsOrgISBizUnit()) {
            this.insertLevelSumData(GLRptField.accountID, "t_bd_accountview", "av", 1);
        }
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            boolean first;
            boolean bl = first = at.isUseGroup();
            if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
            if (at.isMultilevel() && at.isUseGroup()) {
                this.insertLevelSumData(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at), at.getGroupTable(), at.getHgAttribute() + "Group", 1, first);
                break;
            }
            this.insertLevelSumData(GLRptField.genAsstDataBaseID(at), at.getTableName(), at.getHgAttribute(), 1, first);
            break;
        }
        super.insertSumItem();
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            this.insertMergerData();
        }
    }

    private void insertMergerData() throws EASBizException, BOSException {
        GLRptSumItems sumItem = new GLRptSumItems();
        sumItem.setSumGroup("isTotal");
        Iterator it = sumItem.getSumItems().iterator();
        while (it.hasNext()) {
            ArrayList groupFields = new ArrayList();
            String sql = this.getMergerSumItemSQL((GLRptSumItemInfo)it.next(), groupFields);
            this.insertData(groupFields.toArray(new String[groupFields.size()]), sql);
        }
    }

    protected String getMergerSumItemSQL(GLRptSumItemInfo item, List groupFields) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct ");
        sql.append(" 1 ").append(item.getName());
        groupFields.add(item.getName());
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            sql.append(" ,'").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" ,'").append(this.cond.getCompany().getId().toString()).append("'");
            sql.append(" ").append(this.getOrgUnitIDField().getName());
        }
        groupFields.add(this.getOrgUnitIDField().getName());
        List fields = item.getFields();
        if (fields == null || fields.isEmpty()) {
            return sql.toString();
        }
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            GLRptField field = (GLRptField)fields.get(i);
            if (field.getQueryField() == null) continue;
            String fieldName = field.getName();
            sql.append(",");
            if (i == 0) {
                where.append(" where ");
            } else {
                where.append(" and ");
            }
            sql.append(" t.").append(fieldName);
            where.append(" t.").append(fieldName).append(" is not null");
            groupFields.add(fieldName);
        }
        GLRptPageQuery query = this.getGLRptDataQuery();
        query.setDataSourceTable(this.getDataSourceTable());
        String filter = query.getWhereSQL();
        if (filter != null && filter.trim().length() > 0) {
            if (where.length() == 0) {
                where.append(" where ");
            } else {
                where.append(" and ");
            }
            where.append(" (").append(filter).append(")");
        }
        sql.append(" from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        sql.append(where);
        try {
            return KSqlUtil.optimize((String)sql.toString());
        }
        catch (SqlTranslateException e) {
            throw new BOSException("SqlTranslateException", (Throwable)e);
        }
    }

    protected void insertLevelSumData(GLRptField field, String table, String tab, int topLevel, boolean first) throws EASBizException, BOSException {
        int maxLevel = this.getMaxLevel(table, field);
        String sqlStr = null;
        GLRptSelector tempSelector = this.getGLRptSelector();
        for (int i = maxLevel; i > topLevel; --i) {
            ArrayList<Integer> sp = new ArrayList<Integer>();
            sqlStr = this.getParentSql(field, table, tab, first && i == maxLevel);
            if (!first || i != maxLevel) {
                sp.add(new Integer(i));
            }
            this.insertData(sqlStr, sp);
            if (!tab.endsWith("Group")) continue;
            StringBuffer sql = new StringBuffer();
            StringBuffer selectSql = new StringBuffer();
            GLRptSelector selector = new GLRptSelector();
            selector.add(this.getGLRptSelector());
            this.setGLRptSelector(selector);
            block1: for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                for (int k = 0; k < selector.size(); ++k) {
                    if (!this.isShowAsstGroup(at) || !GLRptField.genAsstDataBaseID(at).getName().equalsIgnoreCase(selector.getField(k).getName())) continue;
                    selector.removeField(k);
                    continue block1;
                }
            }
            Iterator<GLRptField> it = selector.iterator();
            GLRptField sumField = field;
            boolean firstQuery = first;
            while (it.hasNext()) {
                GLRptField field11 = it.next();
                if (field11.getSelect() == null || field11.getQueryField() == null || field11.getType() == "NUMERIC(29,10)" || "FIsAfterCurrPeriod".equals(field11.getName())) continue;
                if (firstQuery) {
                    firstQuery = false;
                } else {
                    sql.append(",");
                    selectSql.append(",");
                }
                if (field11.getName().equals(sumField.getName())) {
                    sql.append(sumField.getName()).append(" VARCHAR(80) ");
                    selectSql.append(sumField.getName());
                    continue;
                }
                sql.append(field11.getName()).append(" VARCHAR(80)  ");
                selectSql.append(field11.getName());
            }
            String sumTempTable = GLTempTableUtil.createDBSysTempTable(this.getContex(), sql.toString());
            StringBuffer sumSqlStr = new StringBuffer();
            sumSqlStr.append(" select ").append(selectSql).append(" from ").append(this.getDataSourceTable().getTableName());
            String nullField = "F" + tab.replace("Group", "") + "ID";
            sumSqlStr.append(" where ").append(nullField).append(" is null ");
            String num = "1";
            sumSqlStr.append(" group by ").append(selectSql).append(" having count(*)> ").append(num);
            DbUtil.execute((Context)this.getContex(), (String)("INSERT  INTO " + sumTempTable + "  " + sumSqlStr.toString()));
            StringBuffer updateStr = new StringBuffer();
            String[] fields = selectSql.toString().split(",");
            String whereSql = "";
            String mainTable = this.getDataSourceTable().getTableName();
            for (int m = 0; m < fields.length; ++m) {
                String temp = fields[m].trim();
                whereSql = whereSql.length() == 0 ? mainTable + "." + temp + "= " + sumTempTable + "." + temp : whereSql + " and " + mainTable + "." + temp + "= " + sumTempTable + "." + temp;
            }
            updateStr.append(" update " + mainTable + " set istotal = 2  ");
            updateStr.append(" where  ").append(nullField).append(" IS NULL and EXISTS (select 1 from ").append(sumTempTable);
            updateStr.append("  where ").append(whereSql).append(" ) ");
            DbUtil.execute((Context)this.getContex(), (String)updateStr.toString());
            String insertStr = "";
            insertStr = this.getParentSql(field, table, tab, true);
            insertStr = insertStr.replace(" 1 = 1 ", "  t." + nullField + " IS NULL and t.istotal = 2 ");
            this.insertData(insertStr, new ArrayList());
            String delStr = " delete from " + this.getDataSourceTable().getTableName() + " where  " + nullField + " IS NULL and istotal = 2 ";
            DbUtil.execute((Context)this.getContex(), (String)delStr);
            GLTempTableUtil.dropTempTable(this.getContex(), sumTempTable);
        }
        this.setGLRptSelector(tempSelector);
    }

    private String getParentSql(GLRptField field, String table, String tab, boolean first) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GLRptSelector selector = new GLRptSelector();
        selector.add(this.getGLRptSelector());
        this.setGLRptSelector(selector);
        block2: for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            for (int i = 0; i < selector.size(); ++i) {
                if (!this.isShowAsstGroup(at) || !GLRptField.genAsstDataBaseID(at).getName().equalsIgnoreCase(selector.getField(i).getName())) continue;
                selector.removeField(i);
                continue block2;
            }
        }
        GLRptPageQuery query = this.getGLRptDataQuery();
        query.setSelector(selector);
        query.setDataSourceTable(this.getDataSourceTable());
        sql.append(" select distinct ").append(this.getParentSelectSQL(field, tab, selector, first));
        sql.append("\r\n from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        if (!first) {
            sql.append(" where ").append(tab).append(".flevel = ?");
            if (tab.endsWith("Group")) {
                sql.append("  and t.F").append(tab.substring(0, tab.length() - 5).toUpperCase()).append("ID is null");
            }
        } else {
            sql.append(" where 1=1");
        }
        if (this.isInsertAfterCurrPeriodBalance() && this.cond.isAfterCurrPeriod()) {
            sql.append(" and t.").append("FIsAfterCurrPeriod").append(" = 0");
        }
        sql.append("\r\n group by ").append(this.getParentGroupBySQL(field, tab, selector, first));
        String sqlStr = null;
        try {
            sqlStr = KSqlUtil.optimize((String)sql.toString());
        }
        catch (SqlTranslateException e) {
            throw new BOSException("sql optimize error!", (Throwable)e);
        }
        if ((this.cond.getProfitCenters() != null || this.cond.getProfitCenter() != null) && sqlStr.contains("t.FOrgUnitID,")) {
            sqlStr = sqlStr.replaceFirst("t.FOrgUnitID,", "1 FOrgUnitID,");
            sqlStr = sqlStr.replaceFirst("t.FOrgUnitID,", "1,");
        }
        return sqlStr;
    }

    private String getParentSelectSQL(GLRptField sumField, String alias, GLRptSelector selector, boolean firstQuery) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = selector.iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getName().equals(sumField.getName())) {
                sql.append(alias).append(firstQuery ? ".fid " : ".fparentid ").append(field.getName());
                continue;
            }
            if (field.getType() == "NUMERIC(29,10)") {
                sql.append("sum(t.").append(field.getName()).append(") ").append(field.getName());
                continue;
            }
            if ("FIsAfterCurrPeriod".equals(field.getName())) {
                sql.append(" 0 ").append(field.getName());
                continue;
            }
            if (GLRptField.accountID.getName().compareToIgnoreCase(sumField.getName()) == 0 && CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() && (GLRptField.accountNumberMerger.getName().compareToIgnoreCase(field.getName()) == 0 || GLRptField.accountNameMerger.getName().compareToIgnoreCase(field.getName()) == 0)) {
                sql.append(" p").append(field.getSelect());
                if (field.isMultiLang()) {
                    sql.append("_").append(this.getContex().getLocale());
                }
                sql.append(" ").append(field.getName());
                continue;
            }
            sql.append("t.").append(field.getName());
        }
        return sql.toString();
    }

    private String getParentGroupBySQL(GLRptField sumField, String alias, GLRptSelector selector, boolean firstQuery) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = selector.iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getSelect() == null || field.getQueryField() == null || field.getType() == "NUMERIC(29,10)" || "FIsAfterCurrPeriod".equals(field.getName())) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getName().equals(sumField.getName())) {
                sql.append(alias).append(firstQuery ? ".fid " : ".fparentid");
                continue;
            }
            if (GLRptField.accountID.getName().compareToIgnoreCase(sumField.getName()) == 0 && CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() && (GLRptField.accountNumber.getName().compareToIgnoreCase(field.getName()) == 0 || GLRptField.accountName.getName().compareToIgnoreCase(field.getName()) == 0)) {
                sql.append(" p").append(field.getSelect());
                if (!field.isMultiLang()) continue;
                sql.append("_").append(this.getContex().getLocale());
                continue;
            }
            sql.append("t.").append(field.getName());
        }
        return sql.toString();
    }

    @Override
    protected int getMaxLevel(String table, GLRptField field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(flevel) maxLevel ");
        sql.append(" from ").append(table);
        sql.append(" where fid in (select ").append(field.getName()).append(" from ").append(this.getDataSourceTable().getTableName()).append(")");
        IRowSet rs = this.executeQuery(sql.toString());
        int maxLevel = 0;
        try {
            if (rs.next()) {
                maxLevel = field.getName().endsWith("GroupID") ? rs.getInt("maxLevel") + 1 : rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error!", (Throwable)e);
        }
        return maxLevel;
    }

    protected int getAccountLevel(String field) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select flevel ");
        sql.append(" from ").append("T_BD_AccountView");
        sql.append(" where fid = '").append(field).append("'");
        IRowSet rs = this.executeQuery(sql.toString());
        int flevel = 0;
        try {
            if (rs.next()) {
                flevel = rs.getInt("flevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error!", (Throwable)e);
        }
        return flevel;
    }

    protected boolean getIsOrgISBizUnit() {
        return this.getCompany().isIsBizUnit();
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        block121: {
            block120: {
                block116: {
                    int currenctRowIndxe;
                    block117: {
                        String curId;
                        block119: {
                            GLRptField assField;
                            Object ohg;
                            int seq;
                            String lastId;
                            block118: {
                                block115: {
                                    if (this.isYearQuery) {
                                        if (this.isShowQty()) {
                                            rowSet.updateBigDecimal("FDebitQty", rowSet.getBigDecimal("FYearDebitQty"));
                                            rowSet.updateBigDecimal("FCreditQty", rowSet.getBigDecimal("FYearCreditQty"));
                                        }
                                        if (this.isShowFor()) {
                                            rowSet.updateBigDecimal("FDebitFor", rowSet.getBigDecimal("FYearDebitFor"));
                                            rowSet.updateBigDecimal("FCreditFor", rowSet.getBigDecimal("FYearCreditFor"));
                                        }
                                        if (this.isShowLocal()) {
                                            rowSet.updateBigDecimal("FDebitLocal", rowSet.getBigDecimal("FYearDebitLocal"));
                                            rowSet.updateBigDecimal("FCreditLocal", rowSet.getBigDecimal("FYearCreditLocal"));
                                        }
                                        if (this.isShowRpt()) {
                                            rowSet.updateBigDecimal("FDebitRpt", rowSet.getBigDecimal("FYearDebitRpt"));
                                            rowSet.updateBigDecimal("FCreditRpt", rowSet.getBigDecimal("FYearCreditRpt"));
                                        }
                                    }
                                    if (this.isShowQty()) {
                                        if (!this.cond.getRptParams().isQtyAsst()) {
                                            this.setQty(rowSet);
                                        }
                                        int priceScala = this.cond.getPriceScale();
                                        BigDecimal beginQty = rowSet.getBigDecimal("FBeginCreditQty");
                                        BigDecimal beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FBeginCreditBalanceFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FBeginCreditBalanceLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FBeginCreditBalanceRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FBeginCreditPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FBeginDebitQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FBeginDebitBalanceFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FBeginDebitBalanceLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FBeginDebitBalanceRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FBeginDebitPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FCreditQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FCreditFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FCreditLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FCreditRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FCreditPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FDebitQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FDebitFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FDebitLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FDebitRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FDebitPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FYearCreditQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FYearCreditFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FYearCreditLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FYearCreditRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FYearCreditPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FYearDebitQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FYearDebitFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FYearDebitLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FYearDebitRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FYearDebitPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FEndCreditQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FEndCreditBalanceFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FEndCreditBalanceLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FEndCreditBalanceRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FEndCreditPrice", beginPrice);
                                        beginQty = rowSet.getBigDecimal("FEndDebitQty");
                                        beginPrice = BigDecimal.ZERO;
                                        if (beginQty != null && beginQty.signum() != 0) {
                                            if (this.isShowFor()) {
                                                beginPrice = rowSet.getBigDecimal("FEndDebitBalanceFor").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowLocal()) {
                                                beginPrice = rowSet.getBigDecimal("FEndDebitBalanceLocal").divide(beginQty, priceScala, 4);
                                            } else if (this.isShowRpt()) {
                                                beginPrice = rowSet.getBigDecimal("FEndDebitBalanceRpt").divide(beginQty, priceScala, 4);
                                            }
                                        }
                                        rowSet.updateBigDecimal("FEndDebitPrice", beginPrice);
                                    }
                                    GLRptTreeNode node = null;
                                    currenctRowIndxe = rowSet.getCurrRowIndex();
                                    if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                                        node = (GLRptTreeNode)rowSet.getObject("companyName");
                                    }
                                    if (CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() || node.getParentNode() == null) break block115;
                                    if (this.cond.isBizCode()) {
                                        if (!this.cond.isFillInfo()) {
                                            rowSet.updateObject("bacName", null);
                                            rowSet.updateObject("bacNumber", null);
                                        }
                                    } else {
                                        Iterator it = this.cond.getAsstActList().iterator();
                                        AsstactTypeEntity at = null;
                                        while (it.hasNext()) {
                                            at = (AsstactTypeEntity)it.next();
                                            if (!this.cond.isFillInfo()) {
                                                rowSet.updateString(at.getHgAttribute() + "Name", "");
                                                rowSet.updateString(at.getHgAttribute() + "Number", "");
                                            }
                                            if (this.cond.isFillInfo() || at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                                            rowSet.updateString("accountName", null);
                                            rowSet.updateString("accountNumber", null);
                                        }
                                    }
                                    if (!this.cond.isFillInfo() && CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
                                        rowSet.updateObject(GLRptField.currencyName.getName(), null);
                                        rowSet.updateString("accountName", null);
                                        rowSet.updateString("accountNumber", null);
                                    }
                                    break block116;
                                }
                                if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() || currenctRowIndxe <= 0) break block117;
                                lastId = null;
                                curId = null;
                                seq = 0;
                                rowSet.previous();
                                seq = rowSet.getInt("KSQL_SEQ");
                                if (!this.cond.isBizCode()) break block118;
                                lastId = rowSet.getString(GLRptField.bacId.getName());
                                rowSet.next();
                                curId = rowSet.getString(GLRptField.bacId.getName());
                                if (curId == null || !curId.equals(lastId)) break block119;
                                if (!curId.equals(lastId)) {
                                    ++seq;
                                }
                                rowSet.updateInt("KSQL_SEQ", seq);
                                if (this.cond.isFillInfo()) break block119;
                                rowSet.updateObject("bacName", null);
                                rowSet.updateObject("bacNumber", null);
                                break block119;
                            }
                            Iterator it = this.cond.getAsstActList().iterator();
                            AsstactTypeEntity at2 = null;
                            while (it.hasNext()) {
                                at2 = (AsstactTypeEntity)it.next();
                                if (lastId == null) {
                                    ohg = rowSet.getObject(at2.getHgField());
                                    lastId = ohg != null ? ohg.toString() : null;
                                } else {
                                    ohg = rowSet.getObject(at2.getHgField());
                                    lastId = lastId + (ohg != null ? ohg.toString() : "");
                                }
                                if (at2.getCollect() != CollectEnum.LEVEL && at2.getCollect() != CollectEnum.UP) continue;
                                ohg = rowSet.getObject(at2.getHgField() + "GroupID");
                                if (ohg == null && at2.isMultilevel() && at2.isUseGroup()) {
                                    assField = GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at2);
                                    ohg = rowSet.getObject(assField.toString());
                                }
                                if (!at2.isShowAsstGroup() || ohg == null) continue;
                                lastId = lastId + ohg.toString();
                            }
                            rowSet.next();
                            for (AsstactTypeEntity at2 : this.cond.getAsstActList()) {
                                if (curId == null) {
                                    ohg = rowSet.getObject(at2.getHgField());
                                    curId = ohg != null ? ohg.toString() : null;
                                } else {
                                    ohg = rowSet.getObject(at2.getHgField());
                                    curId = curId + (ohg != null ? ohg.toString() : "");
                                }
                                if (at2.getCollect() != CollectEnum.LEVEL && at2.getCollect() != CollectEnum.UP) continue;
                                ohg = rowSet.getObject(at2.getHgField() + "GroupID");
                                if (ohg == null && at2.isMultilevel() && at2.isUseGroup()) {
                                    assField = GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at2);
                                    ohg = rowSet.getObject(assField.toString());
                                }
                                if (at2.isShowAsstGroup() && ohg != null) {
                                    curId = curId + ohg.toString();
                                    continue;
                                }
                                Object obj = rowSet.getObject(at2.getHgAttribute() + "Number");
                                curId = curId + (obj != null ? obj.toString() : "");
                            }
                            if (curId != null) {
                                if (!curId.equals(lastId)) {
                                    ++seq;
                                }
                                rowSet.updateInt("KSQL_SEQ", seq);
                            } else {
                                rowSet.updateInt("KSQL_SEQ", ++seq);
                            }
                            if (curId != null && curId.equals(lastId)) {
                                for (AsstactTypeEntity at2 : this.cond.getAsstActList()) {
                                    if (this.cond.isFillInfo() || at2.getCollect() == CollectEnum.LEVEL || at2.getCollect() == CollectEnum.UP) break;
                                    rowSet.updateObject(at2.getHgAttribute() + "Name", null);
                                    rowSet.updateObject(at2.getHgAttribute() + "Number", null);
                                }
                            }
                        }
                        if (currenctRowIndxe != this.pageCount - 1 || curId == null) break block116;
                        this.endId = curId;
                        break block116;
                    }
                    if (this.endId != null && CompanyDisplayModeEnum.enumerate == this.cond.getCompanyDisplayMode() && currenctRowIndxe == 0) {
                        if (this.isFirstPageQuery) {
                            this.isFirstPageQuery = false;
                        }
                        String curId = null;
                        Iterator it = this.cond.getAsstActList().iterator();
                        AsstactTypeEntity at = null;
                        while (it.hasNext()) {
                            Object ohg;
                            at = (AsstactTypeEntity)it.next();
                            if (curId == null) {
                                ohg = rowSet.getObject(at.getHgField());
                                curId = ohg != null ? ohg.toString() : null;
                            } else {
                                ohg = rowSet.getObject(at.getHgField());
                                curId = curId + (ohg != null ? ohg.toString() : "");
                            }
                            if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                            ohg = rowSet.getObject(at.getHgField() + "GroupID");
                            if (at.isShowAsstGroup() && ohg != null) {
                                curId = curId + ohg.toString();
                                continue;
                            }
                            Object obj = rowSet.getObject(at.getHgAttribute() + "Number");
                            curId = curId + (obj != null ? obj.toString() : "");
                        }
                        if (curId != null && curId.equals(this.endId)) {
                            it = this.cond.getAsstActList().iterator();
                            at = null;
                            while (it.hasNext()) {
                                at = (AsstactTypeEntity)it.next();
                                if (this.cond.isFillInfo() || at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) break;
                                rowSet.updateObject(at.getHgAttribute() + "Name", null);
                                rowSet.updateObject(at.getHgAttribute() + "Number", null);
                            }
                        }
                    }
                }
                if (!this.cond.isBizCode()) break block120;
                if (rowSet.getInt("isTotal") != 1) break block121;
                rowSet.updateObject("bacName", TOTAL.getTotal(this.getContex()));
                break block121;
            }
            AsstactTypeEntity at = (AsstactTypeEntity)this.cond.getAsstActList().get(0);
            for (AsstactTypeEntity tempAt : this.cond.getAsstActList()) {
                if (tempAt.getCollect() != CollectEnum.LEVEL && tempAt.getCollect() != CollectEnum.UP) continue;
                at = tempAt;
            }
            if (rowSet.getInt("isTotal") == 1) {
                rowSet.updateObject(at.getHgAttribute() + "Name", TOTAL.getTotal(this.getContex()));
                if (this.cond.getAsstActList().size() > 1) {
                    for (int i = 1; i < this.cond.getAsstActList().size(); ++i) {
                        at = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                        rowSet.updateObject(at.getHgAttribute() + "Name", "");
                        rowSet.updateObject(at.getHgAttribute() + "Number", "");
                    }
                }
            } else if (this.cond.isShowAsstItemTotal()) {
                at = (AsstactTypeEntity)this.cond.getAsstActList().get(0);
                if (rowSet.getInt("asstactTypeIsTotal") == 1) {
                    if (this.cond.isAllCurrency()) {
                        rowSet.updateObject("currencyName", TOTAL.getSubTotal(this.getContex()));
                    } else {
                        rowSet.updateObject(at.getHgAttribute() + "Name", TOTAL.getSubTotal(this.getContex()));
                    }
                }
                if (rowSet.getInt("asstactTypeAllIsTotal") == 1) {
                    rowSet.updateObject("accountNumber", TOTAL.getSubTotal(this.getContex()));
                }
            }
            Iterator it = this.cond.getAsstActList().iterator();
            GLRptTreeNode asstItem = null;
            if (this.isOrgBizUnitAndISHGTree()) {
                GLRptField assField;
                Object ohg = null;
                if (at.isMultilevel() && at.isUseGroup()) {
                    assField = GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at);
                    ohg = rowSet.getObject(assField.toString());
                } else {
                    assField = GLRptField.genAsstDataBaseID(at);
                    ohg = rowSet.getObject(assField.toString());
                }
                if (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) {
                    asstItem = (GLRptTreeNode)ohg;
                }
            } else {
                asstItem = new GLRptTreeNode(rowSet.getInt("SQL_BATCH"), rowSet.getInt("KSQL_SEQ"));
            }
            while (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
                if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                int level = rowSet.getInt(at.getHgAttribute() + "Level");
                String name = rowSet.getString(at.getHgAttribute() + "Name");
                StringBuffer levelName = new StringBuffer();
                if (StringUtils.isNotEmpty((String)name)) {
                    levelName.append(name);
                }
                if (level == -1 || asstItem == null) {
                    if (asstItem == null) {
                        GLRptField assField;
                        Object ohg = null;
                        if (at.isMultilevel() && at.isUseGroup()) {
                            assField = GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at);
                            ohg = rowSet.getObject(assField.toString());
                        } else {
                            assField = GLRptField.genAsstDataBaseID(at);
                            ohg = rowSet.getObject(assField.toString());
                        }
                        asstItem = (GLRptTreeNode)ohg;
                    }
                    if (asstItem == null) {
                        asstItem = new GLRptTreeNode(rowSet.getInt("SQL_BATCH"), rowSet.getInt("KSQL_SEQ"));
                    }
                }
                if (this.cond.getCompany().isIsBizUnit()) {
                    asstItem.setMerge(true);
                }
                asstItem.setLevel(level);
                if (!this.isOrgBizUnitAndISHGTree()) {
                    asstItem.setExpend(true);
                }
                if (at.isUseGroup()) {
                    int maxLevel = this.getMaxLevel(at.getGroupTable(), GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
                    if (level == maxLevel) {
                        asstItem.setLeaf(true);
                    } else {
                        asstItem.setLeaf(false);
                    }
                } else {
                    asstItem.setLeaf(rowSet.getInt(at.getHgAttribute() + "IsLeaf") == 1);
                }
                rowSet.updateObject(at.getHgAttribute() + "Name", "");
                GLRptAsstTreeUserObject valueObj = new GLRptAsstTreeUserObject();
                valueObj.setId(this.assTreeId);
                valueObj.setLevelName(levelName.toString());
                asstItem.setUserObject(valueObj);
                if (levelName.toString().trim().length() <= 0) break;
                if (level == -1 || level == 1 && !this.isOrgBizUnitAndISHGTree()) {
                    rowSet.updateObject(at.getHgAttribute() + "Name", levelName.toString());
                    break;
                }
                rowSet.updateObject(at.getHgAttribute() + "Name", asstItem);
                break;
            }
        }
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            boolean isShowLongNumber;
            GLRptField asstDataBaseNumber = GLRptField.genAsstDataBaseNumber2(at, isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral());
            String assDatabaseNum = rowSet.getString(asstDataBaseNumber.getName());
            if (assDatabaseNum == null || !assDatabaseNum.contains("!")) continue;
            assDatabaseNum = assDatabaseNum.replace("!", ".");
            rowSet.updateObject(asstDataBaseNumber.getName(), assDatabaseNum);
        }
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws SQLException, BOSException, EASBizException {
        super.toGLRptRowData(rs, rowData);
        this.setBalance(rs, rowData);
        boolean flags2 = true;
        AsstactTypeEntity at1 = null;
        for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
            at1 = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
            if (at1.getCollect() == CollectEnum.LEVEL || at1.getCollect() == CollectEnum.UP) {
                this.assTreeId = at1.isMultilevel() && at1.isUseGroup() ? rs.getString(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at1).toString()) : rs.getString(GLRptField.genAsstDataBaseID(at1).toString());
            }
            if (this.cond.isAllCurrency() || at1.getCollect() != CollectEnum.LEVEL && at1.getCollect() != CollectEnum.UP) continue;
            flags2 = false;
        }
        if (rs.getInt("isTotal") == 1) {
            StringBuffer filter = null;
            if (!this.cond.isBizCode()) {
                filter = new StringBuffer();
                AsstactTypeEntity at = null;
                for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
                    at = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                    filter.append(" TB.").append(at.getHgField()).append(" is not null and ");
                }
            }
            if (filter == null) {
                this.setAcountSumAmount(this.getTotalSumAmount(rs, null), rowData);
            } else if (filter.length() > 0) {
                this.setAcountSumAmount(this.getTotalSumAmount(rs, filter.substring(0, filter.lastIndexOf("and"))), rowData);
            }
        } else if ((CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) && rs.getInt("companyIsTotal") == 1) {
            if (this.cond.isBizCode()) {
                StringBuffer filter = new StringBuffer();
                if (rs.getString(GLRptField.bacId.getName()) != null) {
                    filter.append(GLRptField.bacId).append(" = '").append(rs.getString(GLRptField.bacId.getName())).append("' ");
                }
                this.setAcountSumAmount(this.getTotalSumAmount(rs, filter.toString()), rowData);
            } else {
                AsstactTypeEntity at = null;
                StringBuffer filter = new StringBuffer();
                for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
                    at = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                    if (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) {
                        if (at.isShowAsstGroup() && rs.getString(at.getHgAttribute() + "GroupID") != null) {
                            filter.append(" TB.").append(at.getHgAttribute() + "GroupID").append("='").append(rs.getString(at.getHgAttribute() + "GroupID")).append("' and ");
                            filter.append(" TB.").append(at.getHgField()).append(" is not null and ");
                        }
                        if (rs.getInt("companyIsTotal") == 1) {
                            filter.append("TB.FAccountID = '").append(rs.getString("FAccountID")).append("' and ");
                            if (!this.cond.isShowLeafAccount()) {
                                filter.append("av.flevel = ").append(this.getAccountLevel(rs.getString("FAccountID"))).append(" and ");
                            }
                        }
                    }
                    if (rs.getString(at.getHgField()) == null) continue;
                    filter.append(" TB.").append(at.getHgField()).append("='").append(rs.getString(at.getHgField())).append("' and ");
                }
                if (filter.length() > 0) {
                    this.setAcountSumAmount(this.getTotalSumAmount(rs, filter.substring(0, filter.lastIndexOf("and"))), rowData);
                }
            }
        } else if (this.cond.isShowAsstItemTotal()) {
            if (this.cond.isBizCode() && rs.getInt("bacIdIsTotal") == 1) {
                StringBuffer filter = new StringBuffer();
                if (rs.getString(GLRptField.bacId.getName()) != null) {
                    filter.append(GLRptField.bacId).append(" = '").append(rs.getString(GLRptField.bacId.getName())).append("' ");
                }
                this.setAcountSumAmount(this.getTotalSumAmount(rs, filter.toString()), rowData);
            } else if (flags2 && rs.getInt("asstactTypeIsTotal") == 1) {
                AsstactTypeEntity at = null;
                StringBuffer filter = new StringBuffer();
                for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
                    at = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                    if (rs.getString(at.getHgField()) != null) {
                        filter.append("tb." + at.getHgField()).append("='").append(rs.getString(at.getHgField())).append("' and ");
                    } else if (this.isShowAsstGroup(at) && rs.getString(at.getHgAttribute() + "GroupID") != null) {
                        filter.append(at.getHgAttribute() + "GroupID").append("='").append(rs.getString(at.getHgAttribute() + "GroupID")).append("' and ");
                        filter.append(at.getHgField()).append(" is null and ");
                    }
                    if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                    filter.append("tb.FAccountID = '").append(rs.getString("FAccountID")).append("' and ");
                    if (this.cond.isShowLeafAccount()) continue;
                    filter.append("av.flevel = ").append(this.getAccountLevel(rs.getString("FAccountID"))).append(" and ");
                }
                if (filter.length() > 0) {
                    this.setAcountSumAmount(this.getTotalSumAmount(rs, filter.substring(0, filter.lastIndexOf("and"))), rowData);
                }
            } else {
                AsstactTypeEntity at = null;
                boolean flags = false;
                StringBuffer filter = new StringBuffer();
                for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
                    at = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                    if (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) {
                        if (rs.getInt("asstactTypeAllIsTotal") != 1) continue;
                        flags = true;
                    }
                    if (rs.getString(at.getHgField()) != null) {
                        filter.append(at.getHgField()).append("='").append(rs.getString(at.getHgField())).append("' and ");
                        continue;
                    }
                    if (!at.isShowAsstGroup() || rs.getString(at.getHgAttribute() + "GroupID") == null) continue;
                    filter.append(at.getHgAttribute() + "GroupID").append("='").append(rs.getString(at.getHgAttribute() + "GroupID")).append("' and ");
                    filter.append(at.getHgField()).append(" is null and ");
                }
                if (flags && filter.length() > 0) {
                    this.setAcountSumAmount(this.getTotalSumAmount(rs, filter.substring(0, filter.lastIndexOf("and"))), rowData);
                }
            }
        }
    }

    private void setAcountSumAmount(IRowSet rs, IGLRptRowData rowData) throws BOSException, SQLException, EASBizException {
        if (!rs.next()) {
            return;
        }
        if (this.isShowQty()) {
            rowData.updateBigDecimal("FYearBeginDebitQty", rs.getBigDecimal("FYearBeginDebitQty"));
            rowData.updateBigDecimal("FYearBeginCreditQty", rs.getBigDecimal("FYearBeginCreditQty"));
            rowData.updateBigDecimal("FDebitQty", rs.getBigDecimal("FDebitQty"));
            rowData.updateBigDecimal("FCreditQty", rs.getBigDecimal("FCreditQty"));
            rowData.updateBigDecimal("FYearDebitQty", rs.getBigDecimal("FYearDebitQty"));
            rowData.updateBigDecimal("FYearCreditQty", rs.getBigDecimal("FYearCreditQty"));
            this.setBalanceSumAmount(rs, rowData, this.cond.isOptionDCDispatchAsst(), "Qty");
        }
        if (this.isShowFor()) {
            rowData.updateBigDecimal("FYearBeginDebitBalanceFor", rs.getBigDecimal("FYearBeginDebitBalanceFor"));
            rowData.updateBigDecimal("FYearBeginCreditBalanceFor", rs.getBigDecimal("FYearBeginCreditBalanceFor"));
            rowData.updateBigDecimal("FDebitFor", rs.getBigDecimal("FDebitFor"));
            rowData.updateBigDecimal("FCreditFor", rs.getBigDecimal("FCreditFor"));
            rowData.updateBigDecimal("FYearDebitFor", rs.getBigDecimal("FYearDebitFor"));
            rowData.updateBigDecimal("FYearCreditFor", rs.getBigDecimal("FYearCreditFor"));
            this.setBalanceSumAmount(rs, rowData, this.cond.isOptionDCDispatchAsst(), "BalanceFor");
        }
        if (this.isShowLocal()) {
            rowData.updateBigDecimal("FYearBeginDebitBalanceLocal", rs.getBigDecimal("FYearBeginDebitBalanceLocal"));
            rowData.updateBigDecimal("FYearBeginCreditBalanceLocal", rs.getBigDecimal("FYearBeginCreditBalanceLocal"));
            rowData.updateBigDecimal("FDebitLocal", rs.getBigDecimal("FDebitLocal"));
            rowData.updateBigDecimal("FCreditLocal", rs.getBigDecimal("FCreditLocal"));
            rowData.updateBigDecimal("FYearDebitLocal", rs.getBigDecimal("FYearDebitLocal"));
            rowData.updateBigDecimal("FYearCreditLocal", rs.getBigDecimal("FYearCreditLocal"));
            this.setBalanceSumAmount(rs, rowData, this.cond.isOptionDCDispatchAsst(), "BalanceLocal");
        }
        if (this.isShowRpt()) {
            rowData.updateBigDecimal("FYearBeginDebitBalanceRpt", rs.getBigDecimal("FYearBeginDebitBalanceRpt"));
            rowData.updateBigDecimal("FYearBeginCreditBalanceRpt", rs.getBigDecimal("FYearBeginCreditBalanceRpt"));
            rowData.updateBigDecimal("FDebitRpt", rs.getBigDecimal("FDebitRpt"));
            rowData.updateBigDecimal("FCreditRpt", rs.getBigDecimal("FCreditRpt"));
            rowData.updateBigDecimal("FYearDebitRpt", rs.getBigDecimal("FYearDebitRpt"));
            rowData.updateBigDecimal("FYearCreditRpt", rs.getBigDecimal("FYearCreditRpt"));
            this.setBalanceSumAmount(rs, rowData, this.cond.isOptionDCDispatchAsst(), "BalanceRpt");
        }
    }

    private void setBalanceSumAmount(IRowSet rs, IGLRptRowData rowData, boolean isOptionDCDispatchAsst, String suff) throws BOSException, SQLException, EASBizException {
        if (isOptionDCDispatchAsst) {
            rowData.updateBigDecimal("FBeginDebit" + suff, rs.getBigDecimal("FBeginDebit" + suff));
            rowData.updateBigDecimal("FBeginCredit" + suff, rs.getBigDecimal("FBeginCredit" + suff));
            rowData.updateBigDecimal("FEndDebit" + suff, rs.getBigDecimal("FEndDebit" + suff));
            rowData.updateBigDecimal("FEndCredit" + suff, rs.getBigDecimal("FEndCredit" + suff));
        } else {
            BigDecimal beginDebit = BigDecimal.ZERO;
            BigDecimal beginCredit = BigDecimal.ZERO;
            BigDecimal endDebit = BigDecimal.ZERO;
            BigDecimal endCredit = BigDecimal.ZERO;
            if (rs.getBigDecimal("FBeginDebit" + suff) != null) {
                beginDebit = rs.getBigDecimal("FBeginDebit" + suff);
            }
            if (rs.getBigDecimal("FBeginCredit" + suff) != null) {
                beginCredit = rs.getBigDecimal("FBeginCredit" + suff);
            }
            if (rs.getBigDecimal("FEndDebit" + suff) != null) {
                endDebit = rs.getBigDecimal("FEndDebit" + suff);
            }
            if (rs.getBigDecimal("FEndCredit" + suff) != null) {
                endCredit = rs.getBigDecimal("FEndCredit" + suff);
            }
            if (beginDebit.compareTo(beginCredit) >= 0) {
                rowData.updateBigDecimal("FBeginDebit" + suff, beginDebit.subtract(beginCredit));
                rowData.updateBigDecimal("FBeginCredit" + suff, BigDecimal.ZERO);
            } else {
                rowData.updateBigDecimal("FBeginDebit" + suff, BigDecimal.ZERO);
                rowData.updateBigDecimal("FBeginCredit" + suff, beginCredit.subtract(beginDebit));
            }
            if (endDebit.compareTo(endCredit) >= 0) {
                rowData.updateBigDecimal("FEndDebit" + suff, endDebit.subtract(endCredit));
                rowData.updateBigDecimal("FEndCredit" + suff, BigDecimal.ZERO);
            } else {
                rowData.updateBigDecimal("FEndDebit" + suff, BigDecimal.ZERO);
                rowData.updateBigDecimal("FEndCredit" + suff, endCredit.subtract(endDebit));
            }
        }
    }

    private IRowSet getTotalSumAmount(IRowSet rs, String filter) throws EASBizException, BOSException, SQLException {
        String companyId = null;
        companyId = CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode() ? rs.getString("FOrgUnitID") : this.getCompany().getId().toString();
        String currencyId = null;
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            return this.getAccountAmountForMerger(rs, currencyId, companyId, filter);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 xxx");
        this.appendAmountSumSelect(rs, sql, currencyId, companyId, this.cond.isBalanceDirSamAsAccount());
        if (this.isCreateDataTempTable()) {
            sql.append(" FROM ").append(this.getDataSourceTableName()).append(" TB ");
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                sql.append(" left outer join ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid = TB.").append(at.getHgField());
                if (at.isUseGroup()) continue;
            }
            sql.append(" INNER JOIN T_BD_AccountView av on TB.FAccountID = av.FID ");
            if (this.isShowQty()) {
                sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  ");
            }
            sql.append(" WHERE 1 = 1 ");
            if (!(this.cond.isShowLeafAccount() || filter != null && filter.contains("av.flevel"))) {
                sql.append(" and (av.flevel = ").append(this.cond.getAccountLevelEnd());
                sql.append(" or (av.flevel < ").append(this.cond.getAccountLevelEnd()).append(" and av.fisleaf = 1)) ");
            }
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                if (!at.isUseLevel() || at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP || rs.getInt("isTotal") != 1) continue;
                sql.append(" AND " + at.getHgAttribute() + ".FLevel = 1 ");
            }
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() && companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                sql.append(" and tb.FOrgUnitID <> '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
            } else if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
                if (companyId.equals(this.cond.getCompany().getId().toString()) || this.cond.isOptionDCDispatchAsst() && !this.cond.getCompanyIds().contains(companyId)) {
                    sql.insert(sql.indexOf("WHERE"), " INNER JOIN T_ORG_Company co on TB.FOrgUnitID = co.FID ");
                    sql.append(" and tb.FOrgUnitID <> '").append(companyId).append("'");
                    sql.append(" and co.FIsLeaf = 1");
                } else {
                    sql.append(" and tb.FOrgUnitID = '").append(companyId).append("'");
                }
            }
            if (StringUtils.isNotEmpty((String)filter)) {
                sql.append(" and ").append(filter);
            }
        }
        return this.executeQuery(sql.toString());
    }

    private IRowSet getAccountAmountForMerger(IRowSet rs, String currencyId, String companyId, String filter) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 xxx");
        this.appendAmountSelect(sql, currencyId, companyId, this.cond.isBalanceDirSamAsAccount());
        sql.append(" FROM (").append(this.getDataSourceTableNameForMeger(rs, currencyId, companyId, filter)).append(") TB ");
        return this.executeQuery(sql.toString());
    }

    private String getDataSourceTableNameForMeger(IRowSet rs, String currencyId, String companyId, String filter) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 xx ");
        this.appendAmountSumSelect(rs, sql, currencyId, companyId, this.cond.isBalanceDirSamAsAccount());
        sql.append(" from ").append(this.getDataSourceTableName()).append(" TB ");
        sql.append(" INNER JOIN T_BD_AccountView av on TB.FAccountID = av.FID ");
        if (this.isShowQty()) {
            sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = av.FMeasureUnitID  ");
        }
        boolean hasLevelGeneralType = false;
        String hgField = null;
        if (rs.getInt("isTotal") == 1) {
            int size = this.cond.getAsstActList().size();
            for (int i = 0; i < size; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                if (at.getCollect() == CollectEnum.LEAF || !at.isMultilevel() || !at.isGeneralActType()) continue;
                hasLevelGeneralType = true;
                hgField = at.getHgField();
                break;
            }
        }
        if (hasLevelGeneralType) {
            sql.append(" inner join T_BD_GeneralAsstActType ga on tb.").append(hgField).append(" = ga.fid ");
        }
        sql.append(" WHERE 1 = 1 ");
        if (!(this.cond.isShowLeafAccount() || filter != null && filter.contains("av.flevel"))) {
            sql.append(" and (av.flevel = ").append(this.cond.getAccountLevelEnd());
            sql.append(" or (av.flevel < ").append(this.cond.getAccountLevelEnd()).append(" and av.fisleaf = 1)) ");
        }
        if (hasLevelGeneralType) {
            sql.append(" and ga.fisleaf = 1 ");
        }
        if (companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            sql.append(" and TB.FOrgUnitID <> '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("'");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" and TB.FOrgUnitID <> '").append(this.cond.getCompany().getId().toString()).append("'");
            if (!companyId.equals(this.cond.getCompany().getId().toString())) {
                sql.append(" and TB.FOrgUnitID = '").append(companyId).append("'");
            } else {
                sql.append(" and TB.FOrgUnitID <> '").append(this.cond.getCompany().getId().toString()).append("'");
            }
        } else {
            sql.append(" and TB.FOrgUnitID = '").append(companyId).append("'");
        }
        if (StringUtils.isNotEmpty((String)filter)) {
            sql.append(" and ").append(filter);
        }
        return sql.toString();
    }

    private void appendAmountSumSelect(IRowSet rowSet, StringBuffer sql, String currencyId, String companyId, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException, SQLException {
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                this.appendYearBeginDebitSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(",0.0 FYearBeginDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginDebitSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FYearBeginDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginDebitSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendYearBeginDebitSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                this.appendYearBeginCreditSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FYearBeginCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendYearBeginCreditSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FYearBeginCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendYearBeginCreditSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendYearBeginCreditSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                this.appendPeriodBeginDebitSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FBeginDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginDebitSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FBeginDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginDebitSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginDebitSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                this.appendPeriodBeginCreditSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FBeginCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodBeginCreditSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0  FBeginCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodBeginCreditSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodBeginCreditSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("Qty) FDebitQty");
            } else {
                sql.append(", 0.0 FDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("For) FDebitFor");
            } else {
                sql.append(", 0.0  FDebitFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("Local) FDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearDebit" : "FDebit").append("Rpt) FDebitRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("Qty) FCreditQty");
            } else {
                sql.append(", 0.0 FCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("For) FCreditFor");
            } else {
                sql.append(", 0.0  FCreditFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("Local) FCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.").append(this.isYearQuery ? "FYearCredit" : "FCredit").append("Rpt) FCreditRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                sql.append(",sum(TB.FYearDebitQty) FYearDebitQty");
            } else {
                sql.append(", 0.0 FYearDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearDebitFor) FYearDebitFor");
            } else {
                sql.append(", 0.0  FYearDebitFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearDebitLocal) FYearDebitLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearDebitRpt) FYearDebitRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                sql.append(",sum(TB.FYearCreditQty) FYearCreditQty");
            } else {
                sql.append(", 0.0 FYearCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                sql.append(",sum(TB.FYearCreditFor) FYearCreditFor");
            } else {
                sql.append(", 0.0  FYearCreditFor ");
            }
        }
        if (this.isShowLocal()) {
            sql.append(",sum(TB.FYearCreditLocal) FYearCreditLocal");
        }
        if (this.isShowRpt()) {
            sql.append(",sum(TB.FYearCreditRpt) FYearCreditRpt");
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                this.appendPeriodEndDebitSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndDebitQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndDebitSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndDebitBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndDebitSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndDebitSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
        if (this.isShowQty()) {
            if (this.isNeedQty(companyId) && (this.cond.isShowByStandardMU() || this.cond.getMeasureUnit() != null)) {
                this.appendPeriodEndCreditSum(sql, "Qty", "Qty", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndCreditQty ");
            }
        }
        if (this.isShowFor()) {
            if (!this.isAllCurrency() || currencyId != null) {
                this.appendPeriodEndCreditSum(sql, "For", "BalanceFor", isBalanceDirSamAsAccount);
            } else {
                sql.append(", 0.0 FEndCreditBalanceFor ");
            }
        }
        if (this.isShowLocal()) {
            this.appendPeriodEndCreditSum(sql, "Local", "BalanceLocal", isBalanceDirSamAsAccount);
        }
        if (this.isShowRpt()) {
            this.appendPeriodEndCreditSum(sql, "Rpt", "BalanceRpt", isBalanceDirSamAsAccount);
        }
    }

    private void appendAmountSelect(StringBuffer sql, String currencyId, String companyId, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            sql.append(",TB.FYearBeginDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(",TB.FYearBeginDebitBalanceFor ");
        }
        if (this.isShowLocal()) {
            sql.append(" ,TB.FYearBeginDebitBalanceLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FYearBeginDebitBalanceRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",TB.FYearBeginCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(",TB.FYearBeginCreditBalanceFor ");
        }
        if (this.isShowLocal()) {
            sql.append(",TB.FYearBeginCreditBalanceLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(",TB.FYearBeginCreditBalanceRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FBeginDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FBeginDebitBalanceFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FBeginDebitBalanceLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FBeginDebitBalanceRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FBeginCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FBeginCreditBalanceFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FBeginCreditBalanceLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FBeginCreditBalanceRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FDebitFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FDebitLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FDebitRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FCreditFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FCreditLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FCreditRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FYearDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FYearDebitFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FYearDebitLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FYearDebitRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FYearCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FYearCreditFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FYearCreditLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FYearCreditRpt ");
        }
        if (this.isShowQty()) {
            sql.append(",TB.FEndDebitQty ");
        }
        if (this.isShowFor()) {
            sql.append(", TB.FEndDebitBalanceFor ");
        }
        if (this.isShowLocal()) {
            sql.append(", TB.FEndDebitBalanceLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(", TB.FEndDebitBalanceRpt ");
        }
        if (this.isShowQty()) {
            sql.append(", TB.FEndCreditQty ");
        }
        if (this.isShowFor()) {
            sql.append(",TB.FEndCreditBalanceFor ");
        }
        if (this.isShowLocal()) {
            sql.append(",TB.FEndCreditBalanceLocal ");
        }
        if (this.isShowRpt()) {
            sql.append(",TB.FEndCreditBalanceRpt ");
        }
    }

    private void appendYearBeginDebitSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + " > 0 ");
        }
        sql.append(" THEN (TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type).append(")");
        sql.append(" ELSE 0.0 END) FYearBeginDebit" + suff + " ");
    }

    private void appendYearBeginCreditSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + " < 0 ");
        }
        sql.append(" THEN -1 * (TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type + ") ");
        sql.append(" ELSE 0.0 END) FYearBeginCredit" + suff + " ");
    }

    private void appendPeriodBeginDebitSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        String begin = this.isYearQuery ? " TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type : " TB.FBegin" + suff;
        sql.append(" ,sum(CASE WHEN ");
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(begin + " > 0 ");
        }
        sql.append(" THEN ").append(begin).append(" ELSE 0.0 END) FBeginDebit" + suff + " ");
    }

    private void appendPeriodBeginCreditSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        String begin = this.isYearQuery ? " TB.FEnd" + suff + "+TB.FYearCredit" + type + "-TB.FYearDebit" + type : " TB.FBegin" + suff;
        sql.append(", sum(CASE WHEN ");
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(begin + " < 0 ");
        }
        sql.append(" THEN -1 * (").append(begin).append(") ELSE 0.0 END) FBeginCredit" + suff + "\t");
    }

    private void appendPeriodEndCreditSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(-1);
        } else {
            sql.append(" TB.FEnd" + suff + "<0");
        }
        sql.append(" THEN -1*TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndCredit" + suff + " ");
    }

    private void appendPeriodEndDebitSum(StringBuffer sql, String type, String suff, boolean isBalanceDirSamAsAccount) throws EASBizException, BOSException {
        sql.append(", sum(CASE WHEN ");
        if (isBalanceDirSamAsAccount) {
            sql.append(" av.fdc = ").append(1);
        } else {
            sql.append(" TB.FEnd" + suff + ">0");
        }
        sql.append(" THEN TB.FEnd" + suff);
        sql.append(" ELSE 0.0 END) FEndDebit" + suff + " ");
    }

    private boolean isNeedQty(String companyId) {
        return CompanyDisplayModeEnum.merger != this.cond.getCompanyDisplayMode() || !companyId.equals("00000000-0000-0000-0000-000000000000CCE7AED4");
    }

    private void setBalance(IRowSet rs, IGLRptRowData rowData) throws SQLException, EASBizException, BOSException {
        boolean isEndDebit = this.isEndDebit(rs);
        boolean isBeginDebit = this.isBeginDebit(rs);
        if (this.isShowFor()) {
            BigDecimal endBalFor = rs.getBigDecimal("FEndBalanceFor");
            if (endBalFor == null) {
                endBalFor = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitBalanceFor", endBalFor);
            } else {
                rowData.updateBigDecimal("FEndCreditBalanceFor", endBalFor.negate());
            }
            BigDecimal beginBalFor = null;
            if (this.isYearQuery) {
                BigDecimal yearDebitBalFor = rs.getBigDecimal("FYearDebitFor");
                BigDecimal yearCreditBalFor = rs.getBigDecimal("FYearCreditFor");
                if (yearDebitBalFor == null) {
                    yearDebitBalFor = GlUtils.zero;
                }
                if (yearCreditBalFor == null) {
                    yearCreditBalFor = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitFor", yearDebitBalFor);
                rowData.updateBigDecimal("FCreditFor", yearCreditBalFor);
                beginBalFor = endBalFor.add(yearCreditBalFor).subtract(yearDebitBalFor);
            } else {
                beginBalFor = rs.getBigDecimal("FBeginBalanceFor");
            }
            if (beginBalFor == null) {
                beginBalFor = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitBalanceFor", beginBalFor);
            } else {
                rowData.updateBigDecimal("FBeginCreditBalanceFor", beginBalFor.negate());
            }
            this.repairAmountDirection(rowData, "FBeginDebitBalanceFor", "FBeginCreditBalanceFor");
        }
        if (this.isShowLocal()) {
            BigDecimal endBalLocal = rs.getBigDecimal("FEndBalanceLocal");
            if (endBalLocal == null) {
                endBalLocal = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitBalanceLocal", endBalLocal);
            } else {
                rowData.updateBigDecimal("FEndCreditBalanceLocal", endBalLocal.negate());
            }
            BigDecimal beginBalLocal = null;
            if (this.isYearQuery) {
                BigDecimal yearDebitBalLocal = rs.getBigDecimal("FYearDebitLocal");
                BigDecimal yearCreditBalLocal = rs.getBigDecimal("FYearCreditLocal");
                if (yearDebitBalLocal == null) {
                    yearDebitBalLocal = GlUtils.zero;
                }
                if (yearCreditBalLocal == null) {
                    yearCreditBalLocal = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitLocal", yearDebitBalLocal);
                rowData.updateBigDecimal("FCreditLocal", yearCreditBalLocal);
                beginBalLocal = endBalLocal.add(yearCreditBalLocal).subtract(yearDebitBalLocal);
            } else {
                beginBalLocal = rs.getBigDecimal("FBeginBalanceLocal");
            }
            if (beginBalLocal == null) {
                beginBalLocal = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitBalanceLocal", beginBalLocal);
            } else {
                rowData.updateBigDecimal("FBeginCreditBalanceLocal", beginBalLocal.negate());
            }
            this.repairAmountDirection(rowData, "FBeginDebitBalanceLocal", "FBeginCreditBalanceLocal");
        }
        if (this.isShowRpt()) {
            BigDecimal endBalRpt = rs.getBigDecimal("FEndBalanceRpt");
            if (endBalRpt == null) {
                endBalRpt = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitBalanceRpt", endBalRpt);
            } else {
                rowData.updateBigDecimal("FEndCreditBalanceRpt", endBalRpt.negate());
            }
            BigDecimal beginBalRpt = null;
            if (this.isYearQuery) {
                BigDecimal yearDebitBalRpt = rs.getBigDecimal("FYearDebitRpt");
                BigDecimal yearCreditBalRpt = rs.getBigDecimal("FYearCreditRpt");
                if (yearDebitBalRpt == null) {
                    yearDebitBalRpt = GlUtils.zero;
                }
                if (yearCreditBalRpt == null) {
                    yearCreditBalRpt = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitRpt", yearDebitBalRpt);
                rowData.updateBigDecimal("FCreditRpt", yearCreditBalRpt);
                beginBalRpt = endBalRpt.add(yearCreditBalRpt).subtract(yearDebitBalRpt);
            } else {
                beginBalRpt = rs.getBigDecimal("FBeginBalanceRpt");
            }
            if (beginBalRpt == null) {
                beginBalRpt = GlUtils.zero;
            }
            if (isBeginDebit) {
                rowData.updateBigDecimal("FBeginDebitBalanceRpt", beginBalRpt);
            } else {
                rowData.updateBigDecimal("FBeginCreditBalanceRpt", beginBalRpt.negate());
            }
            this.repairAmountDirection(rowData, "FBeginDebitBalanceRpt", "FBeginCreditBalanceRpt");
        }
        if (this.isShowQty()) {
            boolean isBeginQtyDebit = isBeginDebit;
            if (this.isShowFor()) {
                isBeginQtyDebit = this.confirmBeginQtyDirectionIsDebit(rowData.getBigDecimal("FBeginDebitBalanceFor"), rowData.getBigDecimal("FBeginCreditBalanceFor"), isBeginDebit);
            } else if (this.isShowLocal()) {
                isBeginQtyDebit = this.confirmBeginQtyDirectionIsDebit(rowData.getBigDecimal("FBeginDebitBalanceLocal"), rowData.getBigDecimal("FBeginCreditBalanceLocal"), isBeginDebit);
            } else if (this.isShowRpt()) {
                isBeginQtyDebit = this.confirmBeginQtyDirectionIsDebit(rowData.getBigDecimal("FBeginDebitBalanceRpt"), rowData.getBigDecimal("FBeginCreditBalanceRpt"), isBeginDebit);
            }
            BigDecimal endQty = rs.getBigDecimal("FEndQty");
            if (endQty == null) {
                endQty = GlUtils.zero;
            }
            if (isEndDebit) {
                rowData.updateBigDecimal("FEndDebitQty", endQty);
            } else {
                rowData.updateBigDecimal("FEndCreditQty", endQty.negate());
            }
            BigDecimal beginQty = null;
            if (this.isYearQuery) {
                BigDecimal yearDebitQty = rs.getBigDecimal("FYearDebitQty");
                BigDecimal yearCreditQty = rs.getBigDecimal("FYearCreditQty");
                if (yearDebitQty == null) {
                    yearDebitQty = GlUtils.zero;
                }
                if (yearCreditQty == null) {
                    yearCreditQty = GlUtils.zero;
                }
                rowData.updateBigDecimal("FDebitQty", yearDebitQty);
                rowData.updateBigDecimal("FCreditQty", yearCreditQty);
                beginQty = endQty.add(yearCreditQty).subtract(yearDebitQty);
            } else {
                beginQty = rs.getBigDecimal("FBeginQty");
            }
            if (beginQty == null) {
                beginQty = GlUtils.zero;
            }
            if (isBeginQtyDebit) {
                rowData.updateBigDecimal("FBeginDebitQty", beginQty);
            } else {
                rowData.updateBigDecimal("FBeginCreditQty", beginQty.negate());
            }
        }
    }

    private boolean confirmBeginQtyDirectionIsDebit(BigDecimal debitAmount, BigDecimal creditAmount, boolean isBeginDebit) {
        boolean isBeginQtyDebit = debitAmount == null && creditAmount == null ? isBeginDebit : (debitAmount == null ? false : (creditAmount == null ? true : (debitAmount.signum() == 0 && creditAmount.signum() == 0 ? isBeginDebit : (debitAmount.signum() == 0 ? false : (creditAmount.signum() == 0 ? true : isBeginDebit)))));
        return isBeginQtyDebit;
    }

    private void repairAmountDirection(IGLRptRowData rowData, String beginDebit, String beginCredit) throws EASBizException, BOSException {
        if (!this.getQueryCondition().getRptParams().isBalanceDirSamAsAccount()) {
            BigDecimal beginDebitBalance = rowData.getBigDecimal(beginDebit);
            BigDecimal beginCreditBalance = rowData.getBigDecimal(beginCredit);
            if (beginDebitBalance != null && beginDebitBalance.compareTo(GlUtils.zero) < 0 && (beginCreditBalance == null || beginCreditBalance.compareTo(GlUtils.zero) == 0)) {
                rowData.updateBigDecimal(beginDebit, GlUtils.zero);
                rowData.updateBigDecimal(beginCredit, beginDebitBalance.negate());
            } else if ((beginDebitBalance == null || beginDebitBalance.compareTo(GlUtils.zero) == 0) && beginCreditBalance != null && beginCreditBalance.compareTo(GlUtils.zero) < 0) {
                rowData.updateBigDecimal(beginCredit, GlUtils.zero);
                rowData.updateBigDecimal(beginDebit, beginCreditBalance.negate());
            } else if (beginDebitBalance != null && beginDebitBalance.compareTo(GlUtils.zero) < 0 && beginCreditBalance != null && beginCreditBalance.compareTo(GlUtils.zero) < 0) {
                rowData.updateBigDecimal(beginDebit, beginCreditBalance.negate());
                rowData.updateBigDecimal(beginCredit, beginDebitBalance.negate());
            } else if (beginDebitBalance != null && beginDebitBalance.compareTo(GlUtils.zero) < 0 && beginCreditBalance != null && beginCreditBalance.compareTo(GlUtils.zero) >= 0) {
                rowData.updateBigDecimal(beginDebit, GlUtils.zero);
                rowData.updateBigDecimal(beginCredit, beginCreditBalance.add(beginDebitBalance.negate()));
            } else if (beginDebitBalance != null && beginDebitBalance.compareTo(GlUtils.zero) >= 0 && beginCreditBalance != null && beginCreditBalance.compareTo(GlUtils.zero) < 0) {
                rowData.updateBigDecimal(beginCredit, GlUtils.zero);
                rowData.updateBigDecimal(beginDebit, beginDebitBalance.add(beginCreditBalance.negate()));
            }
        }
    }

    private boolean isEndDebit(IRowSet rs) throws SQLException, EASBizException, BOSException {
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        boolean isSameDC = dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount();
        boolean isDebit = true;
        if (isSameDC) {
            isDebit = new BigDecimal(dc.toString()).intValue() == 1;
        } else {
            BigDecimal amount = GlUtils.zero;
            if (this.isShowFor()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceFor.getName());
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceLocal.getName());
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceRpt.getName());
            }
            isDebit = amount == null || amount.doubleValue() >= 0.0;
        }
        return isDebit;
    }

    private boolean isBeginDebit(IRowSet rs) throws SQLException, EASBizException, BOSException {
        Object dc = rs.getObject(GLRptField.accountDC.getName());
        boolean isSameDC = dc != null && this.cond.getRptParams().isBalanceDirSamAsAccount();
        boolean isDebit = true;
        if (isSameDC) {
            isDebit = new BigDecimal(dc.toString()).intValue() == 1;
        } else {
            BigDecimal amount = GlUtils.zero;
            if (this.isShowFor()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceFor.getName()).add(rs.getBigDecimal(GLRptField.yearCreditFor.getName())).subtract(rs.getBigDecimal(GLRptField.yearDebitFor.getName()));
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceLocal.getName()).add(rs.getBigDecimal(GLRptField.yearCreditLocal.getName())).subtract(rs.getBigDecimal(GLRptField.yearDebitLocal.getName()));
            }
            if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
                amount = rs.getBigDecimal(GLRptField.endBalanceRpt.getName()).add(rs.getBigDecimal(GLRptField.yearCreditRpt.getName())).subtract(rs.getBigDecimal(GLRptField.yearDebitRpt.getName()));
            }
            if (amount != null && amount.doubleValue() != 0.0) {
                isDebit = amount.doubleValue() > 0.0;
            } else {
                if (this.isShowFor()) {
                    amount = rs.getBigDecimal(GLRptField.beginBalanceFor.getName());
                }
                if ((amount == null || amount.doubleValue() == 0.0) && this.isShowLocal()) {
                    amount = rs.getBigDecimal(GLRptField.beginBalanceLocal.getName());
                }
                if ((amount == null || amount.doubleValue() == 0.0) && this.isShowRpt()) {
                    amount = rs.getBigDecimal(GLRptField.beginBalanceRpt.getName());
                }
                isDebit = amount == null || amount.doubleValue() >= 0.0;
            }
        }
        return isDebit;
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        if (this.cond.isBizCode()) {
            selector.add(GLRptField.bacId);
            selector.add(GLRptField.bacNumber);
            selector.add(GLRptField.bacName);
        }
        selector.add(this.getAsstItemSelector());
        selector.add(GLRptField.accountID);
        selector.add(GLRptField.accountNumber);
        selector.add(GLRptField.accountName);
        selector.add(GLRptField.accountDC);
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.currencyPre);
            selector.add(GLRptField.currencyName);
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            selector.add(GLRptField.orgUnitID);
            selector.add(GLRptField.orgUnitName);
        }
        if (this.isShowQty()) {
            if (this.cond.isShowByStandardMU()) {
                selector.add(GLRptField.measureUnitID);
                selector.add(new GLRptField("standMeasureUnit", null, "NVARCHAR(500)", "MeasureUnit", 60, true));
            } else {
                selector.add(GLRptField.measureUnitName);
                if (this.cond.getRptParams().isQtyAsst()) {
                    selector.add(GLRptField.measureUnitID);
                } else {
                    selector.add(GLRptField.accountQtyMeasureUnitID);
                }
            }
        }
        this.addPriceSelector(selector);
        return selector;
    }

    protected GLRptSelector getAsstItemSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            selector.add(GLRptField.genAsstDataBaseID(at));
            boolean isShowNumber = this.cond.getRptParams().isAssitemShowNumber();
            boolean isShowLongName = this.cond.getRptParams().isShowLongNameForGeneral();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            selector.add(GLRptField.genAsstDataBaseNumber2(at, isShowLongNumber));
            selector.add(GLRptField.genAsstDataBaseName(at, this.getContex(), this.getContex().getLocale(), isShowLongNumber, isShowLongName));
            if (at.isShowAsstGroup()) {
                selector.add(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
            }
            if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
            String assItemLevel = null;
            assItemLevel = at.isShowAsstGroup() ? "case when " + at.getHgAttribute() + ".fid is null then " + at.getHgAttribute() + "Group.FLevel else " + at.getHgAttribute() + "Group.FLevel + 1 end" : at.getHgAttribute() + ".FLevel";
            selector.add(new GLRptField(at.getHgAttribute() + "Level", assItemLevel, "INT", null, -1, false));
            if (at.isUseGroup()) continue;
            selector.add(new GLRptField(at.getHgAttribute() + "IsLeaf", at.getHgAttribute() + ".FIsLeaf", "INT", null, -1, false));
        }
        return selector;
    }

    private void addPriceSelector(GLRptSelector selector) throws EASBizException, BOSException {
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
            selector.add(GLRptField.beginPrice);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.debitQty);
            selector.add(GLRptField.debitPrice);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.creditQty);
            selector.add(GLRptField.creditPrice);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
            selector.add(GLRptField.yearDebitPrice);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
            selector.add(GLRptField.yearCreditPrice);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.endQty);
            selector.add(GLRptField.endPrice);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.endBalanceRpt);
        }
    }

    @Override
    public GLRptField getTreeColmun() {
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            return GLRptField.orgUnitName;
        }
        if (this.getIsOrgISBizUnit()) {
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                if (at.isMultilevel() && at.isUseGroup()) {
                    return GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at);
                }
                return GLRptField.genAsstDataBaseID(at);
            }
        }
        return null;
    }

    private boolean isOrgBizUnitAndISHGTree() {
        if (this.getIsOrgISBizUnit()) {
            if (this.cond.getCompanys() != null && this.cond.getCompanys().length > 1) {
                return false;
            }
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isUseRptID() {
        if (this.isOrgBizUnitAndISHGTree()) {
            return true;
        }
        return super.isUseRptID();
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAsstActTypeBalPageQuery(this.getContex(), this.cond){

            protected boolean isInnerJoinAccount() {
                return true;
            }
        };
    }

    @Override
    public IGLRptIDCreator getGLRptIDCreator(String mainTableAlias, GLRptField field) {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            return new GLRptAsstActTypeBalanceIDCreator(mainTableAlias, this.getQueryCondition());
        }
        if (this.getIsOrgISBizUnit()) {
            for (AsstactTypeEntity at : this.cond.getAsstActList()) {
                if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                return new GLRptAsstItemTreeNodeIDCreator(mainTableAlias, at);
            }
        }
        return new DefaultGLRptIDCreator(mainTableAlias, this.cond);
    }

    @Override
    protected int getExpandLevel() {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            if (this.cond.isDisplayLeafCompany()) {
                return 1;
            }
            return 0;
        }
        int level = -1;
        if (this.getTreeColmun() != null && !this.isOrgBizUnitAndISHGTree()) {
            if (this.cond.getCompany().isIsBizUnit()) {
                level = 1;
            } else {
                int rootLevel = ((SimpleCompanyUserObject)((DefaultMutableTreeNode)this.cond.getTreeModelOfCompany()).getUserObject()).getLevel();
                level = this.cond.getExpandCompanyLevel() + rootLevel - 1;
            }
        } else if (this.getIsOrgISBizUnit()) {
            Iterator it = this.cond.getAsstActList().iterator();
            int maxLevel = level;
            while (it.hasNext()) {
                AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                if (at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP || at.getCollect() != CollectEnum.LEVEL && at.getCollect() != CollectEnum.UP) continue;
                try {
                    if (at.isMultilevel() && at.isUseGroup()) {
                        maxLevel = this.getMaxLevel(at.getGroupTable(), GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
                        continue;
                    }
                    maxLevel = this.getMaxLevel(at.getTableName(), GLRptField.genAsstDataBaseID(at));
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (maxLevel > level) {
                level = maxLevel;
            }
        }
        return level;
    }

    private void insertAssistBalance(GLRptAsstActTypeBalanceCondition cond, int startYear, int startMonth) throws EASBizException, BOSException {
        GLRptAsstactBalQuery balQuery = new GLRptAsstactBalQuery(this.getContex(), (OrgUnitInfo)this.getCompany(), cond, cond.getRptParams().isQtyAsst() && this.isShowQty(), this.isCreateDataTempTable()){

            @Override
            protected String getPeriodJoinSQL() throws BOSException, EASBizException {
                return "";
            }

            @Override
            protected void getJoinOrgUnitSql(StringBuffer sql) {
                if (!this.getCompany().isIsBizUnit()) {
                    sql.append(" and pav.fcompanyid = '").append(this.getCompany().getId().toString()).append("'");
                    sql.append(" and av.fisLeaf = 1 ");
                    if (this.getCond().isShowLeafAccount()) {
                        sql.append(" and pav.fisLeaf = 1 ");
                    }
                } else {
                    sql.append(" and pav.fcompanyid = av.fcompanyid ");
                }
            }
        };
        if (cond.isBizCode()) {
            balQuery.setIsBizCode(cond.isBizCode());
            balQuery.setBizCodeFromNumber(cond.getBizCodeNumFrom());
            balQuery.setBizCodeToNumber(cond.getBizCodeNumTo());
        }
        balQuery.setBeginPeriod(startYear, startMonth);
        balQuery.setSelector(this.getGLRptSelector());
        balQuery.setSysStatusTmpTable(this.sysStatusTmpTable);
        StringBuffer sql = new StringBuffer();
        sql.append("select /*+ leading(TB) */ ");
        String[] fields = null;
        fields = cond.isShowByStandardMU() ? this.getAsstActTypeTempTableFields() : this.getTempTableFields();
        if (fields != null && fields.length > 0) {
            sql.append(fields[0]);
            for (int i = 1; i < fields.length; ++i) {
                sql.append(",").append(fields[i]);
            }
        }
        sql.append(" from (").append(balQuery.getSQL()).append(" ) TB");
        if (cond.isShowByStandardMU()) {
            sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = TB.FMeasureUnitID ");
        }
        sql.append(this.buildAmountFilterSql("TB"));
        if (cond.isShowByStandardMU()) {
            this.buildStandMuSql(sql);
        }
        this.insertData(sql.toString());
    }

    private void buildStandMuSql(StringBuffer sql) {
        GLRptField field;
        String innerSql = sql.toString();
        sql = new StringBuffer("select ");
        Iterator<GLRptField> selectIt = this.getGLRptSelector().iterator();
        int i = 0;
        while (selectIt.hasNext()) {
            field = selectIt.next();
            if (field.getSelect() == null || (!field.isTempTableField() || field.getQueryField() == null) && !"NUMERIC(29,10)".equals(field.getType())) continue;
            if (i++ != 0) {
                sql.append(",");
            }
            if ("NUMERIC(29,10)".equals(field.getType())) {
                sql.append("SUM(standQtyTb.").append(field.getName()).append(") AS ").append(field.getName());
                continue;
            }
            if (GLRptField.measureUnitID == field) {
                sql.append("stMu.FID AS FMeasureUnitID");
                continue;
            }
            sql.append("standQtyTb.").append(field.getName());
        }
        sql.append(" from (").append(innerSql).append(") standQtyTb");
        sql.append(" inner join T_BD_AccountView av on av.FID = standQtyTb.FAccountID ");
        sql.append(" inner join T_BD_AsstAccount asstAct on asstAct.FID = av.FCaa ");
        sql.append(" inner join T_BD_MeasureUnitGroup mp on mp.FID = asstAct.FMeasureUnitGroupID ");
        sql.append(" inner join T_BD_MeasureUnit stMu on stMu.FGroupID = mp.FID ");
        sql.append(" where stMu.FIsBaseUnit = 1 ");
        sql.append(" group by ");
        selectIt = this.getGLRptSelector().iterator();
        i = 0;
        while (selectIt.hasNext()) {
            field = selectIt.next();
            if (field.getSelect() == null || (!field.isTempTableField() || field.getQueryField() == null) && !"NUMERIC(29,10)".equals(field.getType()) || "NUMERIC(29,10)".equals(field.getType())) continue;
            if (i++ != 0) {
                sql.append(",");
            }
            if (GLRptField.measureUnitID == field) {
                sql.append("stMu.FID");
                continue;
            }
            sql.append("standQtyTb.").append(field.getName());
        }
    }

    private CompanyOrgUnitInfo[] getCompanys(CompanyOrgUnitInfo[] companys, Set<String> companyIds) {
        HashSet<CompanyOrgUnitInfo> companySet = new HashSet<CompanyOrgUnitInfo>();
        for (int i = 0; i < companys.length; ++i) {
            if (!companyIds.contains(companys[i].getId().toString())) continue;
            companySet.add(companys[i]);
        }
        return companySet.toArray(new CompanyOrgUnitInfo[companySet.size()]);
    }

    protected String[] getAsstActTypeTempTableFields() throws EASBizException, BOSException {
        ArrayList<String> fieldList = new ArrayList<String>();
        Iterator<GLRptField> fIt = this.getGLRptSelector().iterator();
        String fieldName = null;
        while (fIt.hasNext()) {
            GLRptField field = fIt.next();
            if (field.getSelect() == null || (!field.isTempTableField() || field.getQueryField() == null) && field.getType() != "NUMERIC(29,10)") continue;
            fieldName = "TB." + field.getName();
            if (fieldName.endsWith("Qty")) {
                fieldName = "isnull(" + fieldName + ",0)*1.0000*ISNULL(MU.FCoefficient,1) AS " + field.getName();
            }
            fieldList.add(fieldName);
        }
        String[] fields = new String[fieldList.size()];
        fields = fieldList.toArray(fields);
        return fields;
    }

    protected void insertAssistSum() throws BOSException, EASBizException {
    }

    @Override
    protected boolean isAutoSumData() {
        return false;
    }

    @Override
    protected void setAsynWaitPrompt(GLRptRowSet rowData, GLRptSumItemInfo item) throws BOSException {
    }

    private String buildAmountFilterSql(String t) throws EASBizException, BOSException {
        StringBuffer str;
        String debit = this.isYearQuery ? "FYearDebit" : "FDebit";
        String credit = this.isYearQuery ? "FYearCredit" : "FCredit";
        StringBuffer where = new StringBuffer();
        where.append(" where 1=1 ");
        if (this.cond.isOptionAmountZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".").append(debit).append("For <> 0) OR (").append(t).append(".").append(credit).append("For <>0 ))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Local <> 0) OR (").append(t).append(".").append(credit).append("Local <>0 ))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Rpt <> 0) OR (").append(t).append(".").append(credit).append("Rpt <>0 ))");
            }
            where.append(" and (").append(str).append(" ) ");
        }
        if (this.cond.isOptionBalanceZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".FEndBalanceFor <> 0))");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FEndBalanceLocal <> 0))");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".FEndBalanceRpt <> 0))");
            }
            where.append(" and ").append("(").append(str).append(") ");
        }
        if (this.cond.isOptionAmountAndBalZero()) {
            str = new StringBuffer();
            if (this.isShowFor()) {
                str.append(" ((").append(t).append(".").append(debit).append("For <> 0) OR (").append(t).append(".").append(credit).append("For <>0 )) OR (").append(t).append(".FEndBalanceFor <> 0)");
            }
            if (this.isShowLocal()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Local <> 0) OR (").append(t).append(".").append(credit).append("Local <>0 )) OR (").append(t).append(".FEndBalanceLocal <> 0)");
            }
            if (this.isShowRpt()) {
                if (str.length() > 0) {
                    str.append(" or ");
                }
                str.append(" ((").append(t).append(".").append(debit).append("Rpt <> 0) OR (").append(t).append(".").append(credit).append("Rpt <>0 )) OR (").append(t).append(".FEndBalanceRpt <> 0)");
            }
            where.append(" and ").append("(").append(str).append(") ");
        }
        if (this.cond.getMeasureUnit() != null) {
            str = new StringBuffer();
            str.append(t).append(".FMeasureUnitID = '").append(this.cond.getMeasureUnit().getId()).append("'");
            where.append(" and ").append(str);
        }
        return where.toString();
    }

    protected String createSysStatusTmpTable() throws BOSException {
        return GLRptDaoUtil.createSysStatusTmpTable(this.getContex(), this.cond);
    }

    protected GLRptField getOrgUnitIDField() {
        return GLRptField.orgUnitID;
    }

    protected void setQty(GLRptRowSet rowSet) throws BOSException, EASBizException {
        String accountId = rowSet.getString(GLRptField.accountID.getName());
        if (rowSet.getBigDecimal("FBeginDebitQty") != null) {
            rowSet.updateBigDecimal("FBeginDebitQty", rowSet.getBigDecimal("FBeginDebitQty").divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal("FBeginCreditQty") != null) {
            rowSet.updateBigDecimal("FBeginCreditQty", rowSet.getBigDecimal("FBeginCreditQty").divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal(GLRptField.debitQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptField.debitQty.getName(), rowSet.getBigDecimal(GLRptField.debitQty.getName()).divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal(GLRptField.creditQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptField.creditQty.getName(), rowSet.getBigDecimal(GLRptField.creditQty.getName()).divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptField.yearDebitQty.getName(), rowSet.getBigDecimal(GLRptField.yearDebitQty.getName()).divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptField.yearCreditQty.getName(), rowSet.getBigDecimal(GLRptField.yearCreditQty.getName()).divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal("FEndDebitQty") != null) {
            rowSet.updateBigDecimal("FEndDebitQty", rowSet.getBigDecimal("FEndDebitQty").divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal("FEndCreditQty") != null) {
            rowSet.updateBigDecimal("FEndCreditQty", rowSet.getBigDecimal("FEndCreditQty").divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4));
        }
    }

    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        if (accountId != null) {
            MeasureUnitInfo measureUnitID;
            BigDecimal accountQtyCoefficient = GlUtils.one;
            AccountViewInfo accountViewInfo = null;
            if (this.loadedAccountIDToQtyCoefficient.containsKey(accountId)) {
                accountQtyCoefficient = this.loadedAccountIDToQtyCoefficient.get(accountId);
            } else {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            }
            if (accountViewInfo != null && (measureUnitID = accountViewInfo.getMeasureUnitID()) != null) {
                accountQtyCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID.getId().toString())).getCoefficient();
            }
            this.loadedAccountIDToQtyCoefficient.put(accountId, accountQtyCoefficient);
            return accountQtyCoefficient;
        }
        return GlUtils.one;
    }
}

