/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceParentRowCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.IGLRptAsstActTypeBalanceSQL;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class GLRptAsstActTypeUnionCompBalanceSQL
implements IGLRptAsstActTypeBalanceSQL {
    private static final Logger logger = Logger.getLogger(GLRptAsstActTypeUnionCompBalanceSQL.class);
    private Map<String, Object> systemParam;
    GLRptAsstActTypeBalanceCondition cond;
    private Context ctx;
    private Collection<String> recycleTables;

    public GLRptAsstActTypeUnionCompBalanceSQL(Context ctx, GLRptAsstActTypeBalanceCondition cond) {
        this.cond = cond;
        this.ctx = ctx;
        this.recycleTables = new HashSet<String>(5);
        this.systemParam = cond.systemParam();
    }

    private GLRptAsstActTypeBalanceCondition getRealCond() {
        return this.cond;
    }

    private Context getCtx() {
        return this.ctx;
    }

    private String getGroupLongNumber(String fid, String actTableName, String groupTableName, String groupMappingFieldName, Context ctx) throws BOSException, EASBizException {
        String sql = "select B.FLongNumber from " + actTableName + " A inner join " + groupTableName + " B on A." + groupMappingFieldName + "=B.FID where A.FID=?";
        IRowSet rst = DbUtil.executeQuery(ctx, sql, new String[]{fid});
        try {
            if (rst.next()) {
                return rst.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLDataException(e);
        }
        return "";
    }

    protected String[] getCellObjectNumberID(Object actObject, boolean isMultiLevel, boolean useGroup) {
        String[] re = new String[2];
        if (actObject instanceof DataBaseInfo) {
            re[0] = isMultiLevel && !useGroup ? (((DataBaseInfo)actObject).get("longnumber") != null ? ((DataBaseInfo)actObject).get("longnumber").toString() : null) : (((DataBaseInfo)actObject).get("number") != null ? ((DataBaseInfo)actObject).get("number").toString() : null);
            re[1] = ((DataBaseInfo)actObject).getId().toString();
        } else {
            re[0] = isMultiLevel && !useGroup ? (String)((Object[])((LabelValueBean)actObject).getProperty())[5] : ((LabelValueBean)actObject).getValue();
            re[1] = (String)((Object[])((LabelValueBean)actObject).getProperty())[4];
        }
        return re;
    }

    private void coreBuildAsstActTypeDataTable(List<AsstactTypeEntity> rs, String[] tempTreeTable, String tempTable, boolean isList, Context ctx) throws BOSException, EASBizException {
        String strShowLongNameFromGeneral;
        HashMap paramHashMap;
        boolean isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(ctx);
        String loc = this.getLoc(ctx);
        int i = 0;
        boolean isAsstActShowLongNumber = false;
        boolean isShowLongNameFromGeneral = false;
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        paramKeyMap.put("GL_064", null);
        paramKeyMap.put("GL_066", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        try {
            paramHashMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(paramKeyMap);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        String strAsstActShowLongNumber = (String)paramHashMap.get("GL_064");
        if (strAsstActShowLongNumber != null && strAsstActShowLongNumber.trim().length() > 0) {
            isAsstActShowLongNumber = Boolean.valueOf(strAsstActShowLongNumber.trim());
        }
        if ((strShowLongNameFromGeneral = (String)paramHashMap.get("GL_066")) != null && strShowLongNameFromGeneral.trim().length() > 0) {
            isShowLongNameFromGeneral = Boolean.valueOf(strShowLongNameFromGeneral.trim());
        }
        TempTablePool pool = RptServerUtil.getTempTablePoolForRead(ctx, this.getBOSType());
        LinkedList<String> selectFields = new LinkedList<String>();
        selectFields.add("FID VARCHAR(44)");
        selectFields.add("FDisplayID VARCHAR(44)");
        selectFields.add("FNumber NVARCHAR(80)");
        selectFields.add("FLongNumber NVARCHAR(500)");
        selectFields.add("FParentID VARCHAR(44)");
        selectFields.add("FLevel INT");
        selectFields.add("FISLeaf INT");
        selectFields.add("FName NVARCHAR(500)");
        for (int j = 0; j < rs.size(); ++j) {
            StringBuffer sql;
            StringBuffer sqlFrom;
            StringBuffer sqlSelect;
            AsstactTypeEntity asstactType = rs.get(j);
            boolean isGeneralActType = asstactType.getHgAttribute() != null && asstactType.getHgAttribute().startsWith("generalAssActType");
            String nameField = null;
            nameField = isShowLongNameFromGeneral && isGeneralActType ? ".FDISPLAYName_" + loc : ".FName_" + loc;
            String relationTable = asstactType.getTableName();
            SqlParams parameters = new SqlParams();
            tempTreeTable[i] = GLResUtil.getRes("act_item_temp_tree", ctx);
            boolean isMultiLevel = asstactType.isMultilevel();
            String groupTable = asstactType.getGroupTable();
            selectFields.clear();
            selectFields.add("FID VARCHAR(44)");
            selectFields.add("FDisplayID VARCHAR(44)");
            selectFields.add("FNumber NVARCHAR(80)");
            selectFields.add("FLongNumber NVARCHAR(500)");
            selectFields.add("FParentID VARCHAR(44)");
            selectFields.add("FLevel INT");
            selectFields.add("FISLeaf INT");
            selectFields.add("FName NVARCHAR(500)");
            if (isMultiLevel && groupTable == null) {
                sqlSelect = new StringBuffer();
                sqlFrom = new StringBuffer();
                sql = new StringBuffer();
                String fieldLongNumber = "FLongNumber";
                if (asstactType.getHgAttribute() != null && asstactType.getHgAttribute().startsWith("generalAssActType") && !isAsstActShowLongNumber) {
                    fieldLongNumber = "FNumber";
                }
                sqlSelect.append("SELECT DISTINCT TItem.FID as FID,TItem1.FID as FDisplayID,TItem1.FNumber,TItem1.").append(fieldLongNumber).append(" FLongNumber,TItem1.FParentID,TItem1.FLevel,TItem1.FISLeaf,TItem1");
                sqlSelect.append(nameField);
                sqlSelect.append(" FName \n");
                sqlSelect.append(" FROM ");
                sqlSelect.append(relationTable);
                sqlSelect.append(" TItem1 \n inner join ");
                sqlSelect.append(relationTable);
                sqlSelect.append(" TItem \n");
                if (isSupportCharIndexToLike) {
                    sqlSelect.append(" on TItem.FLongNumber like concat(TItem1.FLongNumber, '!%') ");
                } else {
                    sqlSelect.append(" on CHARINDEX(TItem1.FLongNumber||'!',TItem.FLongNumber)=1");
                }
                sqlSelect.append("\n inner join ");
                sqlSelect.append(tempTable);
                sqlSelect.append(" tmp1 on tmp1.fid").append(i).append("=TItem.fid \r\n");
                String general = asstactType.getGeneralAsstactGroupId();
                if (general != null) {
                    sqlSelect.append(" where TItem1.fgroupID ='");
                    sqlSelect.append(general);
                    sqlSelect.append("'");
                }
                sqlSelect.append("union ");
                StringBuffer uSqlSelect = new StringBuffer();
                uSqlSelect.append("SELECT DISTINCT TItem1.FID as FID,TItem1.FID as FDisplayID,TItem1.FNumber,TItem1.").append(fieldLongNumber).append(" FLongNumber,TItem1.FParentID,TItem1.FLevel,1 FISLeaf,TItem1");
                uSqlSelect.append(nameField);
                uSqlSelect.append(" FName \n");
                uSqlSelect.append(" FROM ");
                uSqlSelect.append(relationTable);
                uSqlSelect.append(" TItem1 ");
                uSqlSelect.append("\n inner join ");
                uSqlSelect.append(tempTable);
                uSqlSelect.append(" tmp2 on tmp2.fid").append(i).append("=TItem1.fid \r\n");
                sql.append("select * ");
                sql.append(" from (");
                sql.append(sqlSelect).append(uSqlSelect);
                sql.append(") t");
                tempTreeTable[i] = this.executeCreateTableAsSelectInto("AsstActTypeBalTable", sql.toString(), parameters.getParams(), ctx, selectFields);
            } else if (groupTable != null) {
                sqlSelect = new StringBuffer();
                sqlFrom = new StringBuffer();
                sql = new StringBuffer();
                String groupTableField = asstactType.getGroupField();
                String asstHGAttribute = asstactType.getHgAttribute();
                sqlSelect.append("SELECT DISTINCT TItem.FID as FID,B.FID as FDisplayID,B.FNumber,B.FLongNumber,B.FParentID,B.FLevel,0 as FISLeaf,B");
                sqlSelect.append(nameField);
                sqlSelect.append(" FName \r\n");
                sqlFrom.append(" FROM ");
                sqlFrom.append(groupTable);
                if (asstHGAttribute.equals("customer")) {
                    sqlFrom.append(" B join t_bd_csspgroupstandard e on e.fid=B.fcsspgroupstandardid and (e.ftype=1 or e.ftype=0), ");
                } else if (asstHGAttribute.equals("provider")) {
                    sqlFrom.append(" B join t_bd_csspgroupstandard e on e.fid=B.fcsspgroupstandardid and (e.ftype=2 or e.ftype=0), ");
                } else {
                    sqlFrom.append(" B, ");
                }
                sqlFrom.append(groupTable);
                sqlFrom.append(" A Join ");
                if (asstHGAttribute.equals("customer")) {
                    sqlFrom.append("t_bd_csspgroupstandard s on s.fid=A.fcsspgroupstandardid and (s.ftype=1 or s.ftype=0) Join ");
                } else if (asstHGAttribute.equals("provider")) {
                    sqlFrom.append("t_bd_csspgroupstandard s on s.fid=A.fcsspgroupstandardid and (s.ftype=2 or s.ftype=0) Join ");
                }
                sqlFrom.append(relationTable);
                sqlFrom.append(" TItem on TItem.");
                sqlFrom.append(groupTableField);
                sqlFrom.append(" = A.FID \r\n");
                sqlFrom.append(" inner join ");
                sqlFrom.append(tempTable);
                sqlFrom.append(" on fid").append(i).append("=TItem.fid \r\n");
                if (isSupportCharIndexToLike) {
                    sqlFrom.append("  where (A.FLongNumber like concat(B.FLongNumber, '!%') or B.FLongNumber=A.FLongNumber)");
                } else {
                    sqlFrom.append("  where (CHARINDEX(B.FLongNumber||'!',A.FLongNumber)=1 or B.FLongNumber=A.FLongNumber)");
                }
                if (asstHGAttribute.equals("customer") || asstHGAttribute.equals("provider")) {
                    sqlFrom.append("  and s.fisbasic =1 and e.fisbasic=1 ");
                }
                if (asstHGAttribute.equals("costObject")) {
                    sqlFrom.append("  and A.Fcompanyid=b.fcompanyid ");
                }
                sql.append(sqlSelect);
                sql.append(sqlFrom);
                tempTreeTable[i] = this.executeCreateTableAsSelectInto(tempTreeTable[i], sql.toString(), parameters.getParams(), ctx, selectFields);
                sqlSelect = new StringBuffer();
                sqlFrom = new StringBuffer();
                sql = new StringBuffer();
                sqlSelect.append("SELECT DISTINCT TItem.FID as FID,TItem.FID as FDisplayID,TItem.FNumber,isnull(C.FlongNumber||'!','')||Titem.Fnumber as FlongNumber,C.FID as FparentID,isnull(C.FLevel,0)+1 as Flevel,1 as FISLeaf,TItem");
                sqlSelect.append(nameField);
                sqlSelect.append(" FName \r\n");
                sqlFrom.append(" FROM ");
                sqlFrom.append(relationTable);
                sqlFrom.append(" TItem \r\n");
                sqlFrom.append(" left join  ");
                sqlFrom.append(groupTable);
                sqlFrom.append(" C on TItem.");
                sqlFrom.append(groupTableField);
                sqlFrom.append(" = C.FID \r\n");
                sqlFrom.append(" inner join ");
                sqlFrom.append(tempTable);
                sqlFrom.append(" on fid").append(i).append("=TItem.fid \r\n");
                sql.append("insert into ");
                sql.append(tempTreeTable[i]);
                sql.append(" ");
                sql.append(sqlSelect);
                sql.append(sqlFrom);
                DbUtil.execute(ctx, sql.toString(), parameters.getParams());
            } else {
                sqlSelect = new StringBuffer();
                sqlFrom = new StringBuffer();
                sql = new StringBuffer();
                sqlSelect.append("SELECT distinct TItem.FID as FID,TItem.FID as FDisplayID,TItem.FNumber,Titem.Fnumber as FlongNumber,'1' as FparentID,1 as Flevel,1 as FISLeaf,TItem");
                sqlSelect.append(nameField);
                sqlSelect.append(" FName \r\n");
                sqlFrom.append(" FROM ");
                sqlFrom.append(relationTable);
                sqlFrom.append(" TItem \r\n");
                sqlFrom.append(" inner join ");
                sqlFrom.append(tempTable);
                sqlFrom.append(" on fid").append(i).append("=TItem.fid \r\n");
                sql.append(sqlSelect);
                sql.append(sqlFrom);
                tempTreeTable[i] = this.executeCreateTableAsSelectInto(tempTreeTable[i], sql.toString(), parameters.getParams(), ctx, selectFields);
            }
            try {
                pool.createIndex(tempTreeTable[i], "FID", false, false);
                Connection con = RptServerUtil.getConnectionForRead(ctx, this.getBOSType());
                pool.analyzeTable(con, tempTreeTable[i]);
            }
            catch (Exception e) {
                logger.error((Object)"create index or analyzeTable error!", (Throwable)e);
            }
            ++i;
        }
    }

    private String executeCreateTableAsSelectInto(String tableKey, String sql, Object[] sqlParams, Context ctx, List<String> selectFields) throws BOSException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("create table ").append(tableKey).append(" (");
        for (int i = 0; i < selectFields.size(); ++i) {
            createTableSql.append(selectFields.get(i));
            createTableSql.append(',');
        }
        createTableSql.deleteCharAt(createTableSql.length() - 1);
        createTableSql.append(")");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("temp table's struct is " + createTableSql));
            }
            String tableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
            if (sqlParams == null) {
                sqlParams = new Object[]{};
            }
            DbUtil.execute(ctx, "insert into " + tableName + " " + sql + "", sqlParams);
            return tableName;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("create tempTable error! for " + createTableSql, (Throwable)e);
        }
    }

    private StringBuffer queryBizCodeHgid(Context ctx, String bizCodeFromNumber, String bizCodeToNumber) throws BOSException {
        StringBuffer queryBizCodeHgid = new StringBuffer();
        String loc = this.getLoc(ctx);
        queryBizCodeHgid.append("(select distinct * from (select hg.fid fid,bac.fid bacid ,bac.fnumber bacnumber ,bac.fname_").append(loc).append(" bacname from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("z' ");
        }
        queryBizCodeHgid.append("\r\n union all ");
        queryBizCodeHgid.append("select hg1.fid fid,bac.fid bacid,bac.fnumber bacnumber ,bac.fname_").append(loc).append(" bacname  from t_bd_assistanthg hg1 inner join T_BD_Supplier sup on hg1.FProviderID = sup.fid  inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
        if (!StringUtil.isEmpty((String)bizCodeFromNumber)) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (!StringUtil.isEmpty((String)bizCodeToNumber)) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("~' ");
        }
        queryBizCodeHgid.append("\r\n) t_hgin ) T_Hgid ");
        return queryBizCodeHgid;
    }

    private String getLeafCompany(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = null;
        StringBuffer bf = new StringBuffer("''");
        for (node = root.getFirstLeaf(); node != null; node = node.getNextLeaf()) {
            if (node.getUserObject() != null && node.getUserObject() instanceof SimpleCompanyUserObject) {
                SimpleCompanyUserObject info = (SimpleCompanyUserObject)node.getUserObject();
                bf.append(",'");
                bf.append(info.getCompanyId());
                bf.append("'");
                continue;
            }
            logger.debug((Object)("filted company:" + node.getUserObject()));
        }
        return bf.toString();
    }

    @Override
    public String buildInsertBalanceSQL() throws EASBizException, BOSException {
        Object[] asstactType;
        boolean isBaseCurrencyQuery;
        String groupTable;
        String alis;
        String strAssistShowLongNumber;
        String strBalDcSameAsAccount;
        LinkedList<Object> sp = new LinkedList<Object>();
        boolean isAccountShowLongName = this.getRealCond().isAccountShowLongName();
        boolean includeNoTransPLVoucher = this.getRealCond().isNotIncluePLVoucher();
        String companyID = this.getRealCond().getCompanyId();
        boolean includeUnPost = this.getRealCond().getOptionPosting();
        boolean isBizCode = this.getRealCond().isBizCode();
        String currencyID = this.getRealCond().getCurrencyID();
        String bizCodeFromNumber = this.getRealCond().getBizCodeNumFrom();
        String bizCodeToNumber = this.getRealCond().getBizCodeNumTo();
        boolean noDisplayZero = this.getRealCond().isOptionAmountZero();
        boolean noDisplayBalanceZero = this.getRealCond().isOptionBalanceZero();
        boolean displayAmount = this.getRealCond().isShowQty();
        boolean isBalDcSameAsAccount = this.getRealCond().isBalanceDirSamAsAccount();
        List rs = this.getRealCond().getAsstActList();
        Context ctx = this.getCtx();
        boolean isQtyAsst = Boolean.valueOf(this.systemParam.get("G010") + "");
        String loc = this.getLoc(ctx);
        Object currAccountFrom = this.getRealCond().getAccountViewStart();
        Object currAccountTo = this.getRealCond().getAccountViewEnd();
        Object[] accountView = currAccountFrom instanceof AccountViewInfo ? new Object[]{currAccountFrom} : (Object[])currAccountFrom;
        Object[] accountViewTo = null;
        accountViewTo = currAccountTo instanceof AccountViewInfo ? new Object[]{currAccountTo} : (Object[])currAccountTo;
        String dataTable = GLResUtil.getRes("act_item_balance_table", ctx);
        String companyIDs = "'" + companyID + "'";
        Object tCompany = this.getRealCond().getTreeModelOfCompany();
        DefaultMutableTreeNode treeCompany = null;
        if (tCompany != null) {
            treeCompany = (DefaultMutableTreeNode)this.getRealCond().getTreeModelOfCompany();
            companyIDs = this.getLeafCompany(treeCompany);
        } else {
            StringBuffer ids = new StringBuffer();
            Iterator it = this.getRealCond().getAllCompanyIds().iterator();
            ids.append("'").append(it.next()).append("'");
            while (it.hasNext()) {
                ids.append(",'").append(it.next()).append("'");
            }
            ids.append("");
            companyIDs = ids.toString();
        }
        boolean isForeignCurr = false;
        String paramSql = "select fvalue_" + this.getLoc(ctx) + "  from t_bas_paramitem item ,t_bas_param para where item.fkeyid = para.fid and para.fnumber = '" + "GL_008" + "' and item.FORGUNITID in (" + companyIDs + ")";
        IRowSet paramRowSet = DbUtil.executeQuery(ctx, paramSql);
        HashSet<String> paramSet = new HashSet<String>();
        try {
            while (paramRowSet.next()) {
                paramSet.add(paramRowSet.getString("fvalue_" + this.getLoc(ctx)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (paramSet.size() > 1) {
            throw new ReportBizException(ReportBizException.COMPANYFORCURRENCY);
        }
        if (paramSet.size() == 1) {
            ArrayList paramList = new ArrayList(paramSet);
            isForeignCurr = Boolean.valueOf(paramList.get(0).toString());
        }
        String accountNumber = this.getRealCond().getAccountCodeStart();
        String accountEndNumber = this.getRealCond().getAccountCodeEnd();
        String accountTableId = this.getRealCond().getAccountTableId();
        boolean displayPrice = false;
        String strShowPrice = "true";
        if (strShowPrice != null && strShowPrice.trim().length() > 0) {
            displayPrice = Boolean.valueOf(strShowPrice.trim());
        }
        boolean isList = this.getRealCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.details;
        int[] periodRange = new int[]{this.getRealCond().getPeriodYearStart() * 100 + this.getRealCond().getPeriodNumberStart(), this.getRealCond().getPeriodYearEnd() * 100 + this.getRealCond().getPeriodNumberEnd()};
        int[] periodRange1 = new int[]{this.getRealCond().getPeriodYearStart(), this.getRealCond().getPeriodNumberStart(), this.getRealCond().getPeriodYearEnd(), this.getRealCond().getPeriodNumberEnd()};
        boolean isAssistShowLongNumber = false;
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        paramKeyMap.put("GL_012", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        paramKeyMap.put("GL_005", companyID);
        paramKeyMap.put("GL_064", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        String strAccountShowLongName = (String)this.systemParam.get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        if ((strBalDcSameAsAccount = (String)this.systemParam.get("GL_005")) != null && strBalDcSameAsAccount.trim().length() > 0) {
            isBalDcSameAsAccount = Boolean.valueOf(strBalDcSameAsAccount.trim());
        }
        if ((strAssistShowLongNumber = (String)this.systemParam.get("GL_064")) != null && strAssistShowLongNumber.trim().length() > 0) {
            isAssistShowLongNumber = Boolean.valueOf(strAssistShowLongNumber.trim());
        }
        boolean isMultiLevel = false;
        boolean useGroup = false;
        StringBuilder fromWhere = new StringBuilder();
        StringBuilder outWhere = new StringBuilder();
        StringBuffer mainSelect = new StringBuffer();
        StringBuilder asstTypeSelect = new StringBuilder();
        StringBuilder innerKey = new StringBuilder();
        mainSelect.append("select ");
        LinkedList<String> allSelectFields = new LinkedList<String>();
        LinkedList<String> mainSelectFields = new LinkedList<String>();
        LinkedList<String> asstTypeSelectFields = new LinkedList<String>();
        LinkedList<String> innerKeySelectFields = new LinkedList<String>();
        if (includeNoTransPLVoucher) {
            String[] tempNoTransPL;
            try {
                tempNoTransPL = RptServerUtil.getQueryNOTransPnLBalanceTable(ctx, this.getRealCond().getPeriodYearEnd(), periodRange[0], periodRange[1], companyIDs, false, includeUnPost, 2, currencyID, this.getBOSType());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.recycleTables.add(tempNoTransPL[1]);
            fromWhere.append("\n from " + tempNoTransPL[0] + " A ");
        } else {
            String mainTable = this.getMainTable(includeUnPost, this.cond.isShowFor(), this.cond.isShowRpt(), this.cond.isShowLocal());
            this.logDebug("mainTable is " + mainTable);
            fromWhere.append("\n from ").append(mainTable).append(" A ");
        }
        fromWhere.append("\n inner join T_BD_AssistantHG B on A.FAssistGrpID=B.FID ");
        fromWhere.append("\n inner join t_bd_accountview D on D.fid=A.Faccountid AND D.fcompanyid = A.forgunitid and d.fcaa = b.fasstaccountid");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        fromWhere.append("\n").append(RptServerUtil.innerJoinAccountPermissionSql("D", userID, companyID, ctx));
        if (isBizCode) {
            fromWhere.append("\n inner join ").append(this.queryBizCodeHgid(ctx, bizCodeFromNumber, bizCodeToNumber)).append(" on T_Hgid.fid = B.fid ");
        }
        fromWhere.append("\n    inner join t_bd_SystemStatusCtrol ssc                       on ssc.fcompanyid = A.forgunitid                    inner join t_bd_systemstatus ss                       on ss.fid = ssc.fsystemstatusid                      and ss.fname = 6 \n                   inner join t_bd_period startPeriod                       on startPeriod.fid = ssc.fstartperiodid                    inner join t_bd_period currPeriod                       on currPeriod.fid = ssc.fcurrentperiodid ");
        if (this.cond.isAllCurrency()) {
            fromWhere.append("\n inner join T_BD_CURRENCY CUR ");
            fromWhere.append("\n on CUR.FID = A.FCurrencyID ");
        }
        StringBuffer indexColumns = new StringBuffer();
        if (isBizCode) {
            mainSelect.append(" T_Hgid.bacid fid0,T_Hgid.bacnumber fnumber0,T_Hgid.bacname fname0, ");
            mainSelectFields.add("FID0 VARCHAR(44)");
            mainSelectFields.add("FNumber0 NVARCHAR(80)");
            mainSelectFields.add("FName0 NVARCHAR(500)");
            indexColumns.append("fid0");
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                AsstactTypeEntity asstactType2 = (AsstactTypeEntity)rs.get(n);
                alis = "T_" + n;
                outWhere.append("\n inner join ").append(asstactType2.getTableName()).append(' ').append(alis).append(" on ").append(alis).append(".FID=B.").append(asstactType2.getHgField());
                isMultiLevel = asstactType2.isMultilevel();
                String groupTableName = asstactType2.getGroupTable();
                boolean bl = useGroup = groupTableName != null;
                if (isMultiLevel && !useGroup) {
                    asstTypeSelect.append(" replace(").append(alis).append(".FLongNumber,'!','.') FNumber").append(n).append(",");
                } else if (useGroup) {
                    groupTable = groupTableName;
                    asstTypeSelect.append(alis).append(".FNumber FNumber").append(n).append(",");
                    outWhere.append("\n left join ").append(groupTable).append(" ").append(groupTable).append(n).append(" on ").append(alis).append(".").append(asstactType2.getGroupField()).append("=").append(groupTable).append(n).append(".FID");
                } else {
                    asstTypeSelect.append(alis).append(".FNumber FNumber").append(n).append(",");
                }
                asstTypeSelectFields.add("FNumber" + n + " " + "NVARCHAR(80)");
                innerKey.append("B.").append(asstactType2.getHgField()).append(",");
                innerKeySelectFields.add(asstactType2.getHgField() + " " + "VARCHAR(44)");
                asstTypeSelect.append(alis).append(".FID FID").append(n).append(",").append(alis).append(".FName_").append(loc).append(" FName").append(n).append(",");
                asstTypeSelectFields.add("Fid" + n + " " + "VARCHAR(44)");
                asstTypeSelectFields.add("FName" + n + " " + "NVARCHAR(500)");
                if (indexColumns.length() > 0) {
                    indexColumns.append(",");
                }
                indexColumns.append("FID").append(n);
            }
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean bl = isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        if (isForeignCurr) {
            isBaseCurrencyQuery = true;
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
            } else {
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[0]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange1[2] + "00");
                sp.add(periodRange1[2] + "99");
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
                sp.add(periodRange[1]);
            }
        } else if (isBaseCurrencyQuery) {
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[1]);
            sp.add(periodRange[0]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
        } else {
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[0]);
            sp.add(periodRange[1]);
            sp.add(periodRange[0]);
            sp.add(periodRange[1]);
            sp.add(periodRange[0]);
            sp.add(periodRange[1]);
            sp.add(periodRange[0]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange1[2] + "00");
            sp.add(periodRange1[2] + "99");
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
            sp.add(periodRange[1]);
        }
        StringBuilder asstActFilter = new StringBuilder();
        SqlParams spAsstAct = new SqlParams();
        for (int n = 0; n < rs.size() && !isBizCode; ++n) {
            String groupLongNumber;
            String[] numberID;
            asstactType = (Object[])rs.get(n);
            alis = "T_" + n;
            isMultiLevel = asstactType.isMultilevel();
            useGroup = asstactType.getGroupTable() != null;
            Object from = asstactType.getFrom();
            Object to = asstactType.getTo();
            if (from != null) {
                numberID = this.getCellObjectNumberID(from, isMultiLevel, useGroup);
                String actItemFrom = numberID[0];
                String actItemFIDFrom = numberID[1];
                asstActFilter.append("\n and ");
                if (isMultiLevel && !useGroup) {
                    asstActFilter.append(alis).append(".FLongNumber>=?");
                    spAsstAct.addString(actItemFrom);
                } else if (useGroup) {
                    groupTable = asstactType.getGroupTable() + n;
                    groupLongNumber = this.getGroupLongNumber(actItemFIDFrom, asstactType.getTableName(), asstactType.getGroupTable(), asstactType.getGroupField(), ctx);
                    asstActFilter.append("isNull(").append(groupTable).append(".FLongNumber,'')||").append(alis).append(".FNumber >= ?");
                    spAsstAct.addString(groupLongNumber + actItemFrom);
                } else {
                    asstActFilter.append(alis).append(".FNumber>=?");
                    spAsstAct.addString(actItemFrom);
                }
            }
            if (to == null) continue;
            numberID = this.getCellObjectNumberID(to, isMultiLevel, useGroup);
            String actItemTo = numberID[0];
            String actItemFIDTo = numberID[1];
            asstActFilter.append("\n and ");
            if (isMultiLevel && !useGroup) {
                asstActFilter.append(alis).append(".FLongNumber<=?");
                spAsstAct.addString(actItemTo);
                continue;
            }
            if (useGroup) {
                groupTable = asstactType.getGroupTable() + n;
                groupLongNumber = this.getGroupLongNumber(actItemFIDTo, asstactType.getTableName(), asstactType.getGroupTable(), asstactType.getGroupField(), ctx);
                asstActFilter.append("isNull(").append(groupTable).append(".FLongNumber,'')||").append(alis).append(".FNumber <= ?");
                spAsstAct.addString(groupLongNumber + actItemTo);
                continue;
            }
            asstActFilter.append(alis).append(".FNumber<=?");
            spAsstAct.addString(actItemTo);
        }
        if (asstActFilter.length() > 0 && !isBizCode) {
            fromWhere.append((CharSequence)outWhere);
        }
        fromWhere.append("\n where A.FOrgunitID in (").append(companyIDs).append(") ");
        if (this.coreUseCurrency(this.cond.isShowFor(), this.cond.isShowRpt(), this.cond.isShowLocal(), this.cond.isAllCurrency())) {
            fromWhere.append("\n and A.FCurrencyID=? ");
            sp.add(currencyID);
        }
        fromWhere.append("\n and d.faccounttableid = ?");
        sp.add(accountTableId);
        if (accountNumber != null && accountEndNumber != null) {
            if (accountNumber.equals(accountEndNumber)) {
                fromWhere.append("\n and D.FNumber like'" + accountNumber + "%' ");
            } else {
                fromWhere.append("\n and (D.FNumber >='" + accountNumber + "' AND D.FNumber <= '" + accountEndNumber + "~')");
            }
        }
        fromWhere.append("\n and a.fperiod <= ? \n                   and (a.fperiod >= ? or\n                       a.fperiod >= currPeriod.fnumber\n                   )\n                   and a.fperiod >= startPeriod.fnumber \n");
        sp.add(periodRange[1]);
        sp.add(periodRange[0]);
        String fieldSuffix = RptServerUtil.getCurrencyFieldSuffix(currencyID);
        if (isForeignCurr) {
            fieldSuffix = "For";
        }
        this.coreBalSQLPart(displayAmount, isBalDcSameAsAccount, mainSelect, mainSelectFields, isBaseCurrencyQuery, fieldSuffix);
        mainSelect.append("\n 0 as FLEVEL,1 as FIsLeaf, ");
        mainSelectFields.add("FLEVEL INT");
        mainSelectFields.add("FIsLeaf INT");
        if (!isBizCode) {
            if (!rs.isEmpty()) {
                asstactType = (AsstactTypeEntity)rs.get(0);
                isMultiLevel = asstactType.isMultilevel();
                useGroup = asstactType.getGroupTable() != null;
            } else {
                logger.error((Object)"asst type is null", (Throwable)new Exception());
            }
        }
        if (isBizCode) {
            mainSelect.append("T_Hgid.bacnumber as FOrderNumber,");
            mainSelectFields.add("FOrderNumber NVARCHAR(500)");
        } else if (isMultiLevel && !useGroup) {
            asstTypeSelect.append("T_0.FLongNumber as FOrderNumber");
            asstTypeSelectFields.add("FOrderNumber NVARCHAR(500)");
        } else if (useGroup) {
            if (!rs.isEmpty()) {
                asstactType = (AsstactTypeEntity)rs.get(0);
                isMultiLevel = asstactType.isMultilevel();
                useGroup = asstactType.getGroupTable() != null;
                groupTable = asstactType.getGroupTable() + 0;
                asstTypeSelect.append("isNull(").append(groupTable).append(".FLongNumber,'')||").append("T_0.FNumber as FOrderNumber");
                asstTypeSelectFields.add("FOrderNumber NVARCHAR(500)");
            } else {
                logger.error((Object)"asst type is null", (Throwable)new Exception());
            }
        } else {
            asstTypeSelect.append("T_0.FNumber  as FOrderNumber");
            asstTypeSelectFields.add("FOrderNumber NVARCHAR(500)");
        }
        mainSelect.append(" A.FOrgunitID FOrgUnitID ");
        mainSelect.append(", D.FID FaccountID ");
        mainSelect.append(", D.FNumber").append(" FaccountNumber ");
        mainSelect.append(", ").append(isAccountShowLongName ? "d.fdisplayName_" : "d.fname_").append(loc).append(" FaccountName ");
        mainSelectFields.add("FOrgUnitID VARCHAR(44)");
        mainSelectFields.add("FaccountID VARCHAR(44)");
        mainSelectFields.add("FaccountNumber NVARCHAR(80)");
        mainSelectFields.add("FaccountName NVARCHAR(500)");
        if (this.cond.isAllCurrency()) {
            mainSelect.append(" ,A.FCurrencyID FCurrencyID ");
            mainSelect.append(" ,CUR.FName_" + loc + " FCurrencyName ");
            mainSelect.append(" ,CUR.FPrecision ");
            mainSelectFields.add("FCurrencyID VARCHAR(44)");
            mainSelectFields.add("FCurrencyName NVARCHAR(500)");
            mainSelectFields.add("FCurrencyPre INT");
        }
        if (asstActFilter.length() > 0 && !isBizCode) {
            fromWhere.append((CharSequence)asstActFilter);
            for (Object param : spAsstAct.getParams()) {
                sp.add(param);
            }
        }
        StringBuilder group = new StringBuilder();
        group.append("\n group by ");
        boolean[] isUserLongNumbers = new boolean[rs.size()];
        int count = 0;
        if (isBizCode) {
            group.append(" T_Hgid.bacnumber ,T_Hgid.bacid ,T_Hgid.bacname , ");
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                AsstactTypeEntity asstactType3 = (AsstactTypeEntity)rs.get(n);
                if (asstActFilter.length() > 0) {
                    alis = "T_" + n;
                    isMultiLevel = asstactType3.isMultilevel();
                    boolean bl2 = useGroup = asstactType3.getGroupTable() != null;
                    if (isMultiLevel && !useGroup) {
                        group.append(alis).append(".FLongNumber,");
                    } else if (useGroup) {
                        if (n == 0) {
                            groupTable = asstactType3.getGroupTable() + n;
                            group.append(groupTable).append(".FLongNumber,");
                            group.append(alis).append(".FNumber,");
                        } else {
                            group.append(alis).append(".FNumber,");
                        }
                    } else {
                        group.append(alis).append(".FNumber,");
                    }
                    group.append(alis).append(".FID,").append(alis).append(".FName_").append(loc).append(",");
                } else {
                    group.append("B.").append(asstactType3.getHgField()).append(",");
                }
                isUserLongNumbers[count++] = asstactType3.isUseLongNumber();
            }
        }
        group.append(" D.FNumber,");
        group.append(isAccountShowLongName ? "d.fdisplayName_" : "d.fname_").append(loc);
        group.append(", A.FOrgunitID");
        group.append(", D.FID");
        if (this.cond.isAllCurrency()) {
            group.append(" ,A.FCurrencyID");
            group.append(" ,CUR.FName_" + loc + " ");
            group.append(" ,CUR.FPrecision");
        }
        fromWhere.append((CharSequence)group);
        if (!isBizCode) {
            if (asstActFilter.length() == 0) {
                if (innerKey.length() > 0) {
                    innerKey.deleteCharAt(innerKey.length() - 1);
                }
                asstTypeSelect.append(" ,b.* from ( ");
                fromWhere.insert(0, " select " + asstTypeSelect + mainSelect + "," + innerKey);
                fromWhere.append(") B \n");
                fromWhere.append((CharSequence)outWhere);
                allSelectFields.addAll(asstTypeSelectFields);
                allSelectFields.addAll(mainSelectFields);
                allSelectFields.addAll(innerKeySelectFields);
            } else {
                fromWhere.insert(0, mainSelect + "," + asstTypeSelect);
                allSelectFields.addAll(mainSelectFields);
                allSelectFields.addAll(asstTypeSelectFields);
            }
        } else {
            fromWhere.insert(0, mainSelect);
            allSelectFields.addAll(mainSelectFields);
        }
        String dataSql = "select * from (" + fromWhere.toString() + ") t  \r\n";
        StringBuffer where = new StringBuffer();
        if (isBaseCurrencyQuery) {
            if (noDisplayZero) {
                if (where.length() == 0) {
                    where.append(" where ");
                } else {
                    where.append(" and ");
                }
                where.append(" (FDebitFor<>0 or FCreditFor<>0)");
            }
            if (noDisplayBalanceZero) {
                if (where.length() == 0) {
                    where.append(" where ");
                } else {
                    where.append(" and ");
                }
                where.append(" (FEndBalanceDebitFor<>0 or FEndBalanceCreditFor<>0) ");
            }
        } else {
            if (noDisplayZero) {
                if (where.length() == 0) {
                    where.append(" where ");
                } else {
                    where.append(" and ");
                }
                where.append(" (FDebitLocal<>0 or FCreditLocal<>0 or FDebitFor<>0 or FCreditFor<>0)");
            }
            if (noDisplayBalanceZero) {
                if (where.length() == 0) {
                    where.append(" where ");
                } else {
                    where.append(" and ");
                }
                where.append(" (FEndBalanceDebitLocal<>0 or FEndBalanceCreditLocal<>0) ");
            }
        }
        dataSql = dataSql + where.toString();
        dataTable = this.executeCreateTableAsSelectInto(dataTable, dataSql, sp.toArray(), ctx, allSelectFields);
        allSelectFields.clear();
        try {
            TempTablePool pool = RptServerUtil.getTempTablePoolForRead(ctx, this.getBOSType());
            pool.createIndex(dataTable, indexColumns.toString(), false, false);
            Connection con = RptServerUtil.getConnectionForRead(ctx, this.getBOSType());
            pool.analyzeTable(con, dataTable);
        }
        catch (Exception e) {
            logger.error((Object)"create index or analyzeTable error!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        int rowCount = rs.size();
        if (isBizCode) {
            rowCount = 0;
        }
        String[] tempTreeTable = new String[rowCount];
        if (!isBizCode) {
            this.coreBuildAsstActTypeDataTable(rs, tempTreeTable, dataTable, isList, ctx);
        }
        String cuLevelTable = this.coreBuildOrgDataTable(treeCompany, loc, companyIDs);
        String acctDataTable = this.coreBuildAcctDataTable(isAccountShowLongName, loc, dataTable, companyID, accountTableId);
        String sql = this.queryData(rowCount, dataTable, tempTreeTable, acctDataTable, cuLevelTable, rs, treeCompany, isBaseCurrencyQuery, isBizCode, isAssistShowLongNumber, isUserLongNumbers);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("insert balance sql:\n" + sql));
        }
        return sql;
    }

    private String coreBalFieldSQLPart(int fieldKey, String fieldSuffix, boolean isBalDcSameAsAccount) {
        switch (fieldKey) {
            case 1: {
                String fieldSQL = isBalDcSameAsAccount ? "\n sum(                case when D.FDC = 1 then \n                   case when ? < startPeriod.fnumber and                        a.fperiod =                        startPeriod.fnumber then                     A.FBeginQty                    when ? >= startPeriod.fnumber and                         ? <= currPeriod.fnumber and                         a.fperiod = ? then                     A.FBeginQty                    when ? > currPeriod.fnumber and                         a.fperiod = currPeriod.fnumber then                     A.FEndQty                    when ? > currPeriod.fnumber and                         a.fperiod > currPeriod.fnumber and                         a.fperiod < ? then                     a.fdebitQty - a.fcreditQty                    else                     0                  end                else                   0              end " : "\n sum(                    case when ? < startPeriod.fnumber and                        a.fperiod =                        startPeriod.fnumber then                        case when A.FBeginQty > 0 then                            A.FBeginQty                         else 0 end                    when ? >= startPeriod.fnumber and                         ? <= currPeriod.fnumber and                         a.fperiod = ? then                        case when A.FBeginQty > 0 then                            A.FBeginQty                         else 0 end                    when ? > currPeriod.fnumber and                         a.fperiod = currPeriod.fnumber then                        case when A.FEndQty > 0 then                            A.FEndQty                         else 0 end                    when ? > currPeriod.fnumber and                         a.fperiod > currPeriod.fnumber and                         a.fperiod < ? then                        case when a.fdebitQty - a.fcreditQty > 0 then                            a.fdebitQty - a.fcreditQty                         else 0 end                    else                     0                  end ";
                fieldSQL = fieldSQL + " ) FBeginDebitQty, ";
                return fieldSQL;
            }
            case 3: {
                if (isBalDcSameAsAccount) {
                    return "\n sum(case              when D.FDC = 1 then                                  case when ? < startPeriod.fnumber and                        a.fperiod =                        startPeriod.fnumber then                     A.FBeginBalance" + fieldSuffix + "                    when ? >= startPeriod.fnumber and                         ? <= currPeriod.fnumber and                         a.fperiod = ? then                     A.FBeginBalance" + fieldSuffix + "                    when ? > currPeriod.fnumber and                         a.fperiod = currPeriod.fnumber then                     A.fendbalance" + fieldSuffix + "                    when ? > currPeriod.fnumber and                         a.fperiod > currPeriod.fnumber and                         a.fperiod < ? then                     a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "                    else                     0                  end              else               0            end) FBeginBalanceDebit" + fieldSuffix + ",";
                }
                return "\n sum(                                                                     case when ? < startPeriod.fnumber and                                 a.fperiod =                                 startPeriod.fnumber then                               case                                when A.FBeginBalance" + fieldSuffix + " > 0 then                                 A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? >= startPeriod.fnumber and                                 ? <= currPeriod.fnumber and                                 a.fperiod = ? then                             case                                when A.FBeginBalance" + fieldSuffix + " > 0 then                                 A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? > currPeriod.fnumber and                                 a.fperiod = currPeriod.fnumber then                                 case                                  when A.fendbalance" + fieldSuffix + " > 0 then                                   A.fendbalance" + fieldSuffix + "                                  else                                   0                                end                            when ? > currPeriod.fnumber and                                 a.fperiod > currPeriod.fnumber and                                 a.fperiod < ? then                                                            case                                    when a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + " > 0 then                                        a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "                                   else                                        0                                 end                                 else                             0                          end                            ) FBeginBalanceDebit" + fieldSuffix + ",";
            }
            case 2: {
                String fieldSQL = isBalDcSameAsAccount ? "\n sum(                case when D.FDC = -1 then \n                   case when ? < startPeriod.fnumber and                        a.fperiod =                        startPeriod.fnumber then                     -1 * A.FBeginQty                    when ? >= startPeriod.fnumber and                         ? <= currPeriod.fnumber and                         a.fperiod = ? then                     -1 * A.FBeginQty                    when ? > currPeriod.fnumber and                         a.fperiod = currPeriod.fnumber then                     -1 * A.FEndQty                    when ? > currPeriod.fnumber and                         a.fperiod > currPeriod.fnumber and                         a.fperiod < ? then                      a.fcreditQty - a.fdebitQty                   else                     0                  end                else                   0              end " : "\n sum(                    case when ? < startPeriod.fnumber and                        a.fperiod =                        startPeriod.fnumber then                        case when A.FBeginQty < 0 then                            A.FBeginQty                         else 0 end                    when ? >= startPeriod.fnumber and                         ? <= currPeriod.fnumber and                         a.fperiod = ? then                        case when A.FBeginQty < 0 then                            A.FBeginQty                         else 0 end                    when ? > currPeriod.fnumber and                         a.fperiod = currPeriod.fnumber then                        case when A.FEndQty < 0 then                            A.FEndQty                         else 0 end                    when ? > currPeriod.fnumber and                         a.fperiod > currPeriod.fnumber and                         a.fperiod < ? then                        case when  a.fcreditQty - a.fdebitQty > 0 then                            a.fcreditQty - a.fdebitQty                         else 0 end                    else                     0                  end ";
                fieldSQL = fieldSQL + " ) FBeginCreditQty, ";
                return fieldSQL;
            }
            case 4: {
                if (isBalDcSameAsAccount) {
                    return "\n sum(case              when D.FDC = -1 then                  case when ? < startPeriod.fnumber and                       a.fperiod =                       startPeriod.fnumber then                   A.FBeginBalance" + fieldSuffix + " * D.FDC                  when ? >= startPeriod.fnumber and                       ? <= currPeriod.fnumber and                       a.fperiod = ? then                   A.FBeginBalance" + fieldSuffix + " * D.FDC                  when ? > currPeriod.fnumber and                       a.fperiod = currPeriod.fnumber then                   A.fendbalance" + fieldSuffix + " * D.FDC                  when ? > currPeriod.fnumber and                       a.fperiod > currPeriod.fnumber and                       a.fperiod < ? then                    a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "                  else                   0                end              else               0            end) FBeginBalanceCredit" + fieldSuffix + ",";
                }
                return "\n sum(                                                                     case when ? < startPeriod.fnumber and                                 a.fperiod =                                 startPeriod.fnumber then                               case                                when A.FBeginBalance" + fieldSuffix + " < 0 then                                 -1 * A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? >= startPeriod.fnumber and                                 ? <= currPeriod.fnumber and                                 a.fperiod = ? then                             case                                when A.FBeginBalance" + fieldSuffix + " < 0 then                                 -1 * A.FBeginBalance" + fieldSuffix + "                                else                                 0                              end                            when ? > currPeriod.fnumber and                                 a.fperiod = currPeriod.fnumber then                                 case                                  when A.fendbalance" + fieldSuffix + " < 0 then                                   -1 * A.fendbalance" + fieldSuffix + "                                  else                                   0                                end                            when ? > currPeriod.fnumber and                                 a.fperiod > currPeriod.fnumber and                                 a.fperiod < ? then                                                            case                                   when a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + " < 0 then                                        a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "                                   else                                        0                                 end                                 else                             0                          end                            ) FBeginBalanceCredit" + fieldSuffix + ",";
            }
            case 5: {
                return "\n sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  startPeriod.fnumber then\n                              a.FDebitQty\n                             else\n                              0\n                           end  ) FDebitQty, ";
            }
            case 6: {
                return "\n sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  startPeriod.fnumber then\n                              a.FDebit" + fieldSuffix + "\n                             else\n                              0\n                           end  ) FDebit" + fieldSuffix + ", ";
            }
            case 7: {
                return "\n  sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  startPeriod.fnumber then\n                              A.FCreditQty\n                             else\n                              0\n                           end  ) FCreditQty, ";
            }
            case 8: {
                return "\n  sum(\n                           case\n                             when a.fperiod >= ? and\n                                  a.fperiod <= ? and\n                                  a.fperiod >=\n                                  startPeriod.fnumber then\n                              A.FCredit" + fieldSuffix + "\n                             else\n                              0\n                           end  ) FCredit" + fieldSuffix + ", ";
            }
            case 9: {
                return "\n sum(  \n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                a.FYearDebitQty \n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.FYearDebitQty \n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.fdebitQty \n                               else\n                                0\n                             end ) FYearDebitQty, ";
            }
            case 10: {
                return "\n sum(  \n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                a.fyeardebit" + fieldSuffix + "\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.fyeardebit" + fieldSuffix + "\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber and\n                                    a.fperiod > ? and a.fperiod <= ? then\n                                a.fdebit" + fieldSuffix + "\n                               else\n                                0\n                             end ) FYearDebit" + fieldSuffix + ", ";
            }
            case 11: {
                return "\n sum(\n                         case\n                           when ? >= startPeriod.fnumber and\n                                ? <= currPeriod.fnumber and\n                                a.fperiod = ? then\n                            a.FYearCreditQty \n                           when ? > currPeriod.fnumber and\n                                a.fperiod = currPeriod.fnumber and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.FYearCreditQty \n                           when ? > currPeriod.fnumber and\n                                a.fperiod > currPeriod.fnumber and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.FCreditQty \n                           else\n                            0\n                         end\n                       ) FYearCreditQty,";
            }
            case 12: {
                return "\n sum(\n                         case\n                           when ? >= startPeriod.fnumber and\n                                ? <= currPeriod.fnumber and\n                                a.fperiod = ? then\n                            a.fyearcredit" + fieldSuffix + "\n                           when ? > currPeriod.fnumber and\n                                a.fperiod = currPeriod.fnumber and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.fyearcredit" + fieldSuffix + "\n                           when ? > currPeriod.fnumber and\n                                a.fperiod > currPeriod.fnumber and\n                                a.fperiod > ? and a.fperiod <= ? then\n                            a.FCredit" + fieldSuffix + "\n                           else\n                            0\n                         end\n                       ) FYearCredit" + fieldSuffix + ",";
            }
            case 13: {
                String fieldSQL = isBalDcSameAsAccount ? "\n sum(\n                    case when D.FDC = 1 then \n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                  A.FEndQty\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber then\n                                  A.FEndQty\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber then \n                                   a.fdebitQty - a.fcreditQty \n                               else\n                                0\n                             end                         else                             0                          end " : "\n sum(\n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                   case when A.FEndQty > 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber then\n                                   case when A.FEndQty > 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber then \n                                   case when a.fdebitQty - a.fcreditQty > 0 then \n                                       a.fdebitQty - a.fcreditQty\n                                   else 0 end\n                               else\n                                0\n                             end ";
                fieldSQL = fieldSQL + " ) FEndDebitQty, ";
                return fieldSQL;
            }
            case 14: {
                if (isBalDcSameAsAccount) {
                    return "\n sum(\n                    case when D.FDC = 1 then \n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                  A.FEndBalance" + fieldSuffix + "\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber then\n                                  A.FEndBalance" + fieldSuffix + "\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber then \n                                   a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "\n                               else\n                                0\n                             end\n            else\n               0\n            end\n                       ) FEndBalanceDebit" + fieldSuffix + ",";
                }
                return "\n sum(\n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                case\n                                 when A.FEndBalance" + fieldSuffix + " > 0 then\n                                  A.FEndBalance" + fieldSuffix + "\n                                 else\n                                  0\n                               end\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber then\n                                case\n                                 when A.FEndBalance" + fieldSuffix + " > 0 then\n                                  A.FEndBalance" + fieldSuffix + "\n                                 else\n                                  0\n                               end\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber then                                \n                                case \n                                  when a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + " > 0 then\n                                       a.fdebit" + fieldSuffix + " - a.fcredit" + fieldSuffix + "\n                                  else\n                                       0\n                                end\n                               else\n                                0\n                             end\n                       ) FEndBalanceDebit" + fieldSuffix + ",";
            }
            case 15: {
                String fieldSQL = isBalDcSameAsAccount ? "\n sum(\n                    case when D.FDC = -1 then \n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                  -1 * A.FEndQty\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber then\n                                  -1 * A.FEndQty\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber then \n                                   a.fcreditQty - a.fdebitQty \n                               else\n                                0\n                             end                         else                             0                          end " : "\n sum(\n                             case\n                               when ? >= startPeriod.fnumber and\n                                    ? <= currPeriod.fnumber and\n                                    a.fperiod = ? then\n                                   case when A.FEndQty < 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod = currPeriod.fnumber then\n                                   case when A.FEndQty < 0 then \n                                       A.FEndQty\n                                   else 0 end\n                               when ? > currPeriod.fnumber and\n                                    a.fperiod > currPeriod.fnumber then \n                                   case when a.fcreditQty - a.fdebitQty > 0 then \n                                       a.fcreditQty - a.fdebitQty \n                                   else 0 end\n                               else\n                                0\n                             end ";
                fieldSQL = fieldSQL + " ) FEndCreditQty, ";
                return fieldSQL;
            }
            case 16: {
                if (isBalDcSameAsAccount) {
                    return "\n sum(\n                    case when D.FDC = -1 then \n                         case\n                           when ? >= startPeriod.fnumber and\n                                ? <= currPeriod.fnumber and\n                                a.fperiod = ? then\n                                -1 * A.FEndBalance" + fieldSuffix + "\n                           when ? > currPeriod.fnumber and\n                                a.fperiod = currPeriod.fnumber then\n                              -1 * A.FEndBalance" + fieldSuffix + "\n                           when ? > currPeriod.fnumber and\n                                a.fperiod > currPeriod.fnumber then\n                              a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "\n                           else\n                            0\n                         end\n            else\n               0\n            end\n                       ) FEndBalanceCredit" + fieldSuffix + ",";
                }
                return "\n sum(\n                         case\n                           when ? >= startPeriod.fnumber and\n                                ? <= currPeriod.fnumber and\n                                a.fperiod = ? then\n                              case\n                               when A.FEndBalance" + fieldSuffix + " < 0 then\n                                -1 * A.FEndBalance" + fieldSuffix + "\n                               else\n                                0\n                             end\n                           when ? > currPeriod.fnumber and\n                                a.fperiod = currPeriod.fnumber then\n                            case\n                             when A.FEndBalance" + fieldSuffix + " < 0 then\n                              -1 * A.FEndBalance" + fieldSuffix + "\n                             else\n                              0\n                           end\n                           when ? > currPeriod.fnumber and\n                                a.fperiod > currPeriod.fnumber then\n                              case \n                                  when a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + " > 0 then\n                                       a.fcredit" + fieldSuffix + " - a.fdebit" + fieldSuffix + "\n                                  else\n                                       0\n                                end\n                           else\n                            0\n                         end\n                       \n                       ) FEndBalanceCredit" + fieldSuffix + ",";
            }
        }
        return "";
    }

    private void coreBalSQLPart(boolean displayAmount, boolean isBalDcSameAsAccount, StringBuffer select, List<String> selectFields, boolean isBaseCurrencyQuery, String fieldSuffix) {
        if (isBaseCurrencyQuery) {
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(1, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FBeginDebitQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(3, fieldSuffix, isBalDcSameAsAccount));
            selectFields.add("FBeginBalanceDebitFor NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(2, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FBeginCreditQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(4, fieldSuffix, isBalDcSameAsAccount));
            selectFields.add("FBeginBalanceCreditFor NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(5, fieldSuffix, isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(6, fieldSuffix, isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(7, fieldSuffix, isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(8, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FDebitQty NUMERIC(29,10)");
                selectFields.add("FDebitFor NUMERIC(27,10)");
                selectFields.add("FCreditQty NUMERIC(29,10)");
                selectFields.add("FCreditFor NUMERIC(27,10)");
            } else {
                select.append(this.coreBalFieldSQLPart(6, fieldSuffix, isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(8, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FDebitFor NUMERIC(27,10)");
                selectFields.add("FCreditFor NUMERIC(27,10)");
            }
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(9, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FYearDebitQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(10, fieldSuffix, isBalDcSameAsAccount));
            selectFields.add("FYearDebitFor NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(11, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FYearCreditQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(12, fieldSuffix, isBalDcSameAsAccount));
            selectFields.add("FYearCreditFor NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(13, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FEndDebitQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(14, fieldSuffix, isBalDcSameAsAccount));
            selectFields.add("FEndBalanceDebitFor NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(15, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FEndCreditQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(16, fieldSuffix, isBalDcSameAsAccount));
            selectFields.add("FEndBalanceCreditFor NUMERIC(27,10)");
        } else {
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(1, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FBeginDebitQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(3, "For", isBalDcSameAsAccount));
            select.append(this.coreBalFieldSQLPart(3, "Local", isBalDcSameAsAccount));
            selectFields.add("FBeginBalanceDebitFor NUMERIC(27,10)");
            selectFields.add("FBeginBalanceDebitLocal NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(2, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FBeginCreditQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(4, "For", isBalDcSameAsAccount));
            select.append(this.coreBalFieldSQLPart(4, "Local", isBalDcSameAsAccount));
            selectFields.add("FBeginBalanceCreditFor NUMERIC(27,10)");
            selectFields.add("FBeginBalanceCreditLocal NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(5, fieldSuffix, isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(6, "For", isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(6, "Local", isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(7, fieldSuffix, isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(8, "For", isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(8, "Local", isBalDcSameAsAccount));
                selectFields.add("FDebitQty NUMERIC(29,10)");
                selectFields.add("FDebitFor NUMERIC(27,10)");
                selectFields.add("FDebitLocal NUMERIC(27,10)");
                selectFields.add("FCreditQty NUMERIC(29,10)");
                selectFields.add("FCreditFor NUMERIC(27,10)");
                selectFields.add("FCreditLocal NUMERIC(27,10)");
            } else {
                select.append(this.coreBalFieldSQLPart(6, "For", isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(6, "Local", isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(8, "For", isBalDcSameAsAccount));
                select.append(this.coreBalFieldSQLPart(8, "Local", isBalDcSameAsAccount));
                selectFields.add("FDebitFor NUMERIC(27,10)");
                selectFields.add("FDebitLocal NUMERIC(27,10)");
                selectFields.add("FCreditFor NUMERIC(27,10)");
                selectFields.add("FCreditLocal NUMERIC(27,10)");
            }
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(9, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FYearDebitQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(10, "For", isBalDcSameAsAccount));
            select.append(this.coreBalFieldSQLPart(10, "Local", isBalDcSameAsAccount));
            selectFields.add("FYearDebitFor NUMERIC(27,10)");
            selectFields.add("FYearDebitLocal NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(11, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FYearCreditQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(12, "For", isBalDcSameAsAccount));
            select.append(this.coreBalFieldSQLPart(12, "Local", isBalDcSameAsAccount));
            selectFields.add("FYearCreditFor NUMERIC(27,10)");
            selectFields.add("FYearCreditLocal NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(13, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FEndDebitQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(14, "For", isBalDcSameAsAccount));
            select.append(this.coreBalFieldSQLPart(14, "Local", isBalDcSameAsAccount));
            selectFields.add("FEndBalanceDebitFor NUMERIC(27,10)");
            selectFields.add("FEndBalanceDebitLocal NUMERIC(27,10)");
            if (displayAmount) {
                select.append(this.coreBalFieldSQLPart(15, fieldSuffix, isBalDcSameAsAccount));
                selectFields.add("FEndCreditQty NUMERIC(29,10)");
            }
            select.append(this.coreBalFieldSQLPart(16, "For", isBalDcSameAsAccount));
            select.append(this.coreBalFieldSQLPart(16, "Local", isBalDcSameAsAccount));
            selectFields.add("FEndBalanceCreditFor NUMERIC(27,10)");
            selectFields.add("FEndBalanceCreditLocal NUMERIC(27,10)");
        }
    }

    private int queryTableRowCount(String table) throws BOSException {
        IRowSet rs = DbUtil.executeQuery(this.ctx, "select count(1) from " + table);
        return rs.size();
    }

    private BOSObjectType getBOSType() {
        return new BOSObjectType("AB535D84");
    }

    @Override
    public void execInsertAsstItemSumSQL(String dataTable) throws BOSException, EASBizException {
    }

    @Override
    public void buildInsertCurrencySumSQL(String dataTable) throws EASBizException, BOSException {
        StringBuffer ff;
        boolean isBizCode = this.cond.isBizCode();
        if (isBizCode) {
            return;
        }
        List rs = this.cond.getAsstActList();
        if (rs.isEmpty()) {
            return;
        }
        String currencyID = this.cond.getCurrencyID();
        boolean displayAmount = this.cond.isShowQty();
        boolean showOnlySubAccountview = this.cond.isShowLeafAccount();
        Context ctx = this.getCtx();
        CompanyOrgUnitInfo company = this.cond.getCompany();
        boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        StringBuffer qqSumAss = new StringBuffer();
        StringBuilder group = new StringBuilder("\n group by ");
        StringBuilder selectFields = new StringBuilder();
        qqSumAss.append(" select ").append(2).append(",");
        selectFields.append("KSQL_SEQ").append(", ");
        selectFields.append(" SQL_BATCH, ");
        if (isBizCode) {
            ff = new StringBuffer().append("FNumber0").append(',').append("FID0").append(',').append("FName0").append(',');
            selectFields.append("FID0").append(',').append("FNumber0").append(',').append("FName0").append(',');
            qqSumAss.append(ff);
            group.append(ff);
        } else {
            for (int n = 0; n < rs.size(); ++n) {
                ff = new StringBuffer();
                ff.append("FID").append(n).append(',').append("FNumber").append(n).append(',');
                ff.append("FName").append(n).append(',');
                selectFields.append(ff);
                qqSumAss.append(ff);
                group.append(ff);
            }
        }
        group.append(" t.FAccountID,t.FAccountNumber,t.FAccountName,FAccountDC, ").append(" FCUName,FOrgUnitId,FIsLeafCU, FCULevel,FCUPrecision,").append(" FOrderNumber");
        qqSumAss.append(" t.FAccountID,t.FAccountNumber,t.FAccountName,t.FAccountDC,");
        selectFields.append(" FAccountID,FAccountNumber,FAccountName,FAccountDC,");
        if (this.cond.isAllCurrency()) {
            qqSumAss.append(" '' FCurrencyId,").append("'").append(GLResUtil.getRes("subtotal", ctx)).append("' FCurrencyName,").append(this.cond.getCompany().getBaseCurrency().getPrecision()).append(" FCurrencyPre,").append("1 FIsCurrencyTotal,");
            selectFields.append(" FCurrencyId,FCurrencyName,FCurrencyPre,FIsCurrencyTotal,");
        }
        StringBuilder amount = new StringBuilder();
        if (displayAmount) {
            qqSumAss.append(" sum(FBeginDebitQty) FBeginDebitQty, \t\t\t\t\t\t\t\n");
            qqSumAss.append(" 0.0 FBeginBalanceDebitFor, \t\t\t                \n");
            qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \n");
            qqSumAss.append(" sum(FBeginCreditQty) FBeginCreditQty, \t\t\t\t\t\t\t\n");
            qqSumAss.append(" 0.0 FBeginBalanceCreditFor, \t\t                    \n");
            qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\n");
            amount.append(" sum(FDebitQty) FDebitQty, \t\t\t\t\t\t\t\t\n");
            amount.append(" sum(FDebitFor) FDebitFor, \t\t\t\t\t\t\t\t\n");
            amount.append(" 0.0 FDebitLocal, \t\t\t\t\t\t\t            \n");
            amount.append(" sum(FCreditQty) FCreditQty, \t\t\t\t\t\t\t\n");
            amount.append(" 0.0 FCreditFor,\t\t\t\t\t\t\t\t            \n");
            amount.append(" sum(FCreditLocal) FCreditLocal,\t\t\t\t\t\t\t\n");
            amount.append(" sum(FYearDebitQty) FYearDebitQty, \t\t\t\t\t\t\n");
            amount.append(" 0.0 FYearDebitFor,\t\t\t\t\t\t                \n");
            amount.append(" sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
            amount.append(" sum(FYearCreditQty) FYearCreditQty, \t\t\t\t\t\n");
            amount.append(" 0.0 FYearCreditFor, \t\t\t\t\t                \n");
            amount.append(" sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\n");
            amount.append(" sum(FEndDebitQty) FEndDebitQty, \t\t\t\t\t\t\t\t\t\n");
            selectFields.append("FBeginDebitQty,FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginCreditQty,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitQty,FDebitFor,FDebitLocal,FCreditQty,FCreditFor,FCreditLocal,FYearDebitQty,FYearDebitFor,FYearDebitLocal,FYearCreditQty,FYearCreditFor,FYearCreditLocal,FEndDebitQty,");
        } else {
            qqSumAss.append(" 0.0 FBeginBalanceDebitFor, \t\t\t                \n");
            qqSumAss.append(" sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal, \n");
            qqSumAss.append(" 0.0 FBeginBalanceCreditFor, \t\t                    \n");
            qqSumAss.append(" sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,\n");
            amount.append("0.0 FDebitFor, \t\t\t\t\t\t\t\t            \n");
            amount.append("sum(FDebitLocal) FDebitLocal, \t\t\t\t\t\t\t\n");
            amount.append("0.0 FCreditFor, \t\t\t\t\t\t\t\t            \n");
            amount.append("sum(FCreditLocal) FCreditLocal, \t\t\t\t\t\t\t\n");
            amount.append("0.0 FYearDebitFor,\t\t\t\t\t\t                \n");
            amount.append("sum(FYearDebitLocal) FYearDebitLocal,\t\t\t\t\t\n");
            amount.append("0.0 FYearCreditFor, \t\t\t\t\t\t                \n");
            amount.append("sum(FYearCreditLocal) FYearCreditLocal, \t\t\t\t\t\n");
            selectFields.append("FBeginBalanceDebitFor,FBeginBalanceDebitLocal,FBeginBalanceCreditFor,FBeginBalanceCreditLocal,FDebitFor,FDebitLocal,FCreditFor,FCreditLocal,FYearDebitFor,FYearDebitLocal,FYearCreditFor,FYearCreditLocal,");
        }
        qqSumAss.append((CharSequence)amount);
        qqSumAss.append(" 0.0 FEndBalanceDebitFor, \t\t\t\n");
        qqSumAss.append(" sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal, \t\t\n");
        if (displayAmount) {
            qqSumAss.append(" sum(FEndCreditQty) FEndCreditQty,");
        }
        qqSumAss.append(" 0.0 FEndBalanceCreditFor, \t\t\t\n");
        qqSumAss.append(" sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal, \t\t\n");
        selectFields.append("FEndBalanceDebitFor,FEndBalanceDebitLocal,");
        if (displayAmount) {
            selectFields.append(" FEndCreditQty,");
        }
        selectFields.append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
        qqSumAss.append(" FCUName,FOrgUnitId,FIsLeafCU FISLeafCU, FCULevel FCULevel,FCUPrecision FCUPrecision, 1 FIsLeafaccount,100 FaccountLevel ,");
        selectFields.append(" FCUName,FOrgUnitId,FISLeafCU,FCULevel,FCUPrecision,FIsLeafaccount,FaccountLevel ,");
        if (isBizCode) {
            qqSumAss.append("1 FLevel0").append(',').append("1 FISLeaf0");
            selectFields.append(" FLevel0,FISLeaf0 ");
        } else {
            for (int r = 0; r < rs.size(); ++r) {
                qqSumAss.append("100 FLevel").append(r).append(',');
                qqSumAss.append("1 FISLeaf").append(r).append(',');
                selectFields.append("FLevel").append(r).append(',');
                selectFields.append("FISLeaf").append(r).append(',');
            }
            qqSumAss.deleteCharAt(qqSumAss.length() - 1);
            selectFields.deleteCharAt(selectFields.length() - 1);
        }
        qqSumAss.append(",FOrderNumber");
        selectFields.append(",FOrderNumber");
        qqSumAss.append("  from ").append(dataTable).append(" t ");
        if (!showOnlySubAccountview) {
            qqSumAss.append(" inner join t_bd_accountview av on av.fid = t.faccountid ");
        }
        qqSumAss.append("\r\n where t.isTotal = 0 ");
        if (this.cond.isShowAsstItemTotal()) {
            qqSumAss.append(" and t.actTypeIsTotal = 0 ");
        }
        qqSumAss.append((CharSequence)group);
        qqSumAss = new StringBuffer().append("insert into " + dataTable + "(" + selectFields + ") ").append(qqSumAss);
        if (this.cond.isAllCurrency()) {
            DbUtil.execute(ctx, qqSumAss.toString());
        }
    }

    @Override
    public void execInsertSumSQL(String tempTable) throws BOSException, EASBizException {
        int r;
        boolean isBaseCurrencyQuery;
        String companyIDs;
        Context ctx = this.getCtx();
        List rs = this.getRealCond().getAsstActList();
        boolean isBizCode = this.getRealCond().isBizCode();
        String currencyID = this.getRealCond().getCurrencyID();
        int rowCount = rs.size();
        if (isBizCode) {
            rowCount = 0;
        }
        Object tCompany = this.getRealCond().getTreeModelOfCompany();
        DefaultMutableTreeNode treeCompany = null;
        if (tCompany != null) {
            treeCompany = (DefaultMutableTreeNode)this.getRealCond().getTreeModelOfCompany();
            companyIDs = this.getLeafCompany(treeCompany);
        } else {
            StringBuffer ids = new StringBuffer();
            Iterator it = this.getRealCond().getAllCompanyIds().iterator();
            ids.append("'").append(it.next()).append("'");
            while (it.hasNext()) {
                ids.append(",'").append(it.next()).append("'");
            }
            ids.append("");
            companyIDs = ids.toString();
        }
        boolean isForeignCurr = false;
        String paramSql = "select fvalue_" + this.getLoc(ctx) + "  from t_bas_paramitem item ,t_bas_param para where item.fkeyid = para.fid and para.fnumber = '" + "GL_008" + "' and item.FORGUNITID in (" + companyIDs + ")";
        IRowSet paramRowSet = DbUtil.executeQuery(ctx, paramSql);
        HashSet<String> paramSet = new HashSet<String>();
        try {
            while (paramRowSet.next()) {
                paramSet.add(paramRowSet.getString("fvalue_" + this.getLoc(ctx)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (paramSet.size() > 1) {
            throw new ReportBizException(ReportBizException.COMPANYFORCURRENCY);
        }
        if (paramSet.size() == 1) {
            ArrayList paramList = new ArrayList(paramSet);
            isForeignCurr = Boolean.valueOf(paramList.get(0).toString());
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean bl = isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || company.getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        if (isForeignCurr) {
            isBaseCurrencyQuery = true;
        }
        String CUId = treeCompany == null ? this.getRealCond().getCompanyId() : ((SimpleCompanyUserObject)treeCompany.getUserObject()).getCompanyId();
        boolean displayAmount = this.getRealCond().isShowQty();
        boolean isDCSeparate = this.getRealCond().isOptionDCDispatchAsst();
        StringBuffer qq = new StringBuffer();
        StringBuffer fields = new StringBuffer();
        fields.append("KSQL_SEQ").append(", ");
        fields.append(" SQL_BATCH, ");
        fields.append(" fname0,FaccountDC, ");
        qq.append(" select ");
        qq.append(" 1, ");
        String strTotal = GLResUtil.getRes("total", ctx);
        if (isBizCode) {
            qq.append("'").append(strTotal).append("' fname0,");
        } else if (rowCount > 0) {
            qq.append("'" + strTotal + "' FName0,");
        }
        qq.append("(case when sum(FAccountDC) > 0 then 1 else -1 end) FaccountDC,");
        StringBuilder sqlBeginBalTotal = new StringBuilder();
        StringBuilder sqlBeginBalFields = new StringBuilder();
        StringBuilder sqlEndBalTotal = new StringBuilder();
        StringBuilder sqlEndBalFields = new StringBuilder();
        String fieldSuffix = RptServerUtil.getCurrencyFieldSuffix(currencyID);
        if (isForeignCurr) {
            fieldSuffix = "For";
        }
        if (isDCSeparate) {
            if (isBaseCurrencyQuery) {
                sqlBeginBalTotal.append("sum(FBeginBalanceDebit" + fieldSuffix + ") FBeginBalanceDebitFor,");
                sqlBeginBalFields.append("FBeginBalanceDebit" + fieldSuffix + ",");
                if (displayAmount) {
                    sqlBeginBalTotal.append(" sum(FBeginCreditQty) FBeginCreditQty,");
                    sqlBeginBalFields.append(" FBeginCreditQty,");
                }
                sqlBeginBalTotal.append(" sum(FBeginBalanceCredit" + fieldSuffix + ") FBeginBalanceCreditFor,");
                sqlBeginBalFields.append(" FBeginBalanceCredit" + fieldSuffix + ",");
                sqlEndBalTotal.append("sum(FEndBalanceDebit" + fieldSuffix + ") FEndBalanceDebitFor,");
                sqlEndBalFields.append(" FEndBalanceDebit" + fieldSuffix + ",");
                if (displayAmount) {
                    sqlEndBalTotal.append(" sum(FEndCreditQty) FEndCreditQty,");
                    sqlEndBalFields.append(" FEndCreditQty,");
                }
                sqlBeginBalTotal.append(" sum(FEndBalanceCredit" + fieldSuffix + ") FEndBalanceCreditFor,");
                sqlBeginBalFields.append(" FEndBalanceCredit" + fieldSuffix + ",");
            } else {
                sqlBeginBalTotal.append("sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor,sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal,");
                sqlBeginBalFields.append(" FBeginBalanceDebitFor,FBeginBalanceDebitLocal,");
                if (displayAmount) {
                    sqlBeginBalTotal.append(" sum(FBeginCreditQty) FBeginCreditQty,");
                    sqlBeginBalFields.append(" FBeginCreditQty,");
                }
                sqlBeginBalTotal.append("sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor,  sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,");
                sqlBeginBalFields.append(" FBeginBalanceCreditFor,  FBeginBalanceCreditLocal,");
                sqlEndBalTotal.append("sum(FEndBalanceDebitFor) FEndBalanceDebitFor, sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal,");
                sqlEndBalFields.append(" FEndBalanceDebitFor, FEndBalanceDebitLocal,");
                if (displayAmount) {
                    sqlEndBalTotal.append(" sum(FEndCreditQty) FEndCreditQty,");
                    sqlEndBalFields.append(" FEndCreditQty,");
                }
                sqlEndBalTotal.append("sum(FEndBalanceCreditFor) FEndBalanceCreditFor, sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal,");
                sqlEndBalFields.append("FEndBalanceCreditFor,FEndBalanceCreditLocal,");
            }
        } else if (isBaseCurrencyQuery) {
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebit" + fieldSuffix + ") >= sum(FBeginBalanceCredit" + fieldSuffix + ") then  sum(FBeginBalanceDebit" + fieldSuffix + ")-sum(FBeginBalanceCredit" + fieldSuffix + ") else 0  end FBeginBalanceDebitFor,");
            sqlBeginBalFields.append(" FBeginBalanceDebit" + fieldSuffix + ",");
            if (displayAmount) {
                sqlBeginBalTotal.append(" sum(FBeginCreditQty) FBeginCreditQty,");
                sqlBeginBalFields.append(" FBeginCreditQty,");
            }
            sqlBeginBalTotal.append(" case when sum(FBeginBalanceDebit" + fieldSuffix + ") < sum(FBeginBalanceCredit" + fieldSuffix + ") then  sum(FBeginBalanceCredit" + fieldSuffix + ")-sum(FBeginBalanceDebit" + fieldSuffix + ") else 0  end FBeginBalanceCreditFor,");
            sqlBeginBalFields.append(" FBeginBalanceCredit" + fieldSuffix + ",");
            sqlEndBalTotal.append(" case when sum(FEndBalanceDebit" + fieldSuffix + ") >= sum(FEndBalanceCredit" + fieldSuffix + ") then  sum(FEndBalanceDebit" + fieldSuffix + ")-sum(FEndBalanceCredit" + fieldSuffix + ") else 0  end FEndBalanceDebitFor,");
            sqlEndBalFields.append(" FEndBalanceDebit" + fieldSuffix + ",");
            if (displayAmount) {
                sqlEndBalTotal.append(" sum(FEndCreditQty) FEndCreditQty,");
                sqlEndBalFields.append(" FEndCreditQty,");
            }
            sqlEndBalTotal.append("case when sum(FEndBalanceDebit" + fieldSuffix + ") < sum(FEndBalanceCredit" + fieldSuffix + ") then  sum(FEndBalanceCredit" + fieldSuffix + ")-sum(FEndBalanceDebit" + fieldSuffix + ") else 0  end FEndBalanceCreditFor,");
            sqlEndBalFields.append(" FEndBalanceCredit" + fieldSuffix + ",");
        } else {
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then  sum(FBeginBalanceDebitFor)-sum(FBeginBalanceCreditFor) else 0  end FBeginBalanceDebitFor,");
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitLocal) >= sum(FBeginBalanceCreditLocal) then  sum(FBeginBalanceDebitLocal)-sum(FBeginBalanceCreditLocal) else 0  end FBeginBalanceDebitLocal,");
            sqlBeginBalFields.append(" FBeginBalanceDebitFor,");
            sqlBeginBalFields.append(" FBeginBalanceDebitLocal,");
            if (displayAmount) {
                sqlBeginBalTotal.append(" sum(FBeginCreditQty) FBeginCreditQty,");
                sqlBeginBalFields.append(" FBeginCreditQty,");
            }
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitFor) < sum(FBeginBalanceCreditFor) then  sum(FBeginBalanceCreditFor)-sum(FBeginBalanceDebitFor) else 0  end FBeginBalanceCreditFor,");
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitLocal) < sum(FBeginBalanceCreditLocal) then  sum(FBeginBalanceCreditLocal)-sum(FBeginBalanceDebitLocal) else 0  end FBeginBalanceCreditLocal,");
            sqlBeginBalFields.append(" FBeginBalanceCreditFor,");
            sqlBeginBalFields.append(" FBeginBalanceCreditLocal,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitFor) >= sum(FEndBalanceCreditFor) then  sum(FEndBalanceDebitFor)-sum(FEndBalanceCreditFor) else 0  end FEndBalanceDebitFor,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitLocal) >= sum(FEndBalanceCreditLocal) then  sum(FEndBalanceDebitLocal)-sum(FEndBalanceCreditLocal) else 0  end FEndBalanceDebitLocal,");
            sqlEndBalFields.append(" FEndBalanceDebitFor,");
            sqlEndBalFields.append(" FEndBalanceDebitLocal,");
            if (displayAmount) {
                sqlEndBalTotal.append(" sum(FEndCreditQty) FEndCreditQty,");
                sqlEndBalFields.append(" FEndCreditQty,");
            }
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitFor) < sum(FEndBalanceCreditFor) then  sum(FEndBalanceCreditFor)-sum(FEndBalanceDebitFor) else 0  end FEndBalanceCreditFor,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitLocal) < sum(FEndBalanceCreditLocal) then  sum(FEndBalanceCreditLocal)-sum(FEndBalanceDebitLocal) else 0  end FEndBalanceCreditLocal,");
            sqlEndBalFields.append(" FEndBalanceCreditFor,");
            sqlEndBalFields.append(" FEndBalanceCreditLocal,");
        }
        if (isBaseCurrencyQuery) {
            if (displayAmount) {
                qq.append(" sum(FBeginDebitQty) FBeginDebitQty,");
                fields.append("FBeginDebitQty,");
                qq.append((CharSequence)sqlBeginBalTotal);
                fields.append((CharSequence)sqlBeginBalFields);
                qq.append(" sum(FDebitQty) FDebitQty,sum(FDebit" + fieldSuffix + ")FDebitFor, sum(FCreditQty) FCreditQty,sum(FCredit" + fieldSuffix + ") FCreditFor,");
                qq.append(" sum(FYearDebitQty) FYearDebitQty,sum(FYearDebit" + fieldSuffix + ") FYearDebitFor,");
                qq.append(" sum(FYearCreditQTy) FYearCreditQty,sum(FYearCredit" + fieldSuffix + ") FYearCreditFor, sum(FEndDebitQty) FEndDebitQty,");
                fields.append(" FDebitQty,FDebit" + fieldSuffix + ", FCreditQty, FCredit" + fieldSuffix + ",");
                fields.append(" FYearDebitQty, FYearDebit" + fieldSuffix + ",");
                fields.append(" FYearCreditQty,FYearCredit" + fieldSuffix + ", FEndDebitQty,");
                qq.append((CharSequence)sqlEndBalTotal);
                fields.append((CharSequence)sqlEndBalFields);
            } else {
                qq.append((CharSequence)sqlBeginBalTotal);
                fields.append((CharSequence)sqlBeginBalFields);
                qq.append(" sum(FDebit" + fieldSuffix + ")FDebitFor, sum(FCredit" + fieldSuffix + ") FCreditFor, sum(FYearDebit" + fieldSuffix + ") FYearDebitFor,sum(FYearCredit" + fieldSuffix + ") FYearCreditFor,");
                fields.append(" FDebit" + fieldSuffix + ", FCredit" + fieldSuffix + ", FYearDebit" + fieldSuffix + ",FYearCredit" + fieldSuffix + ",");
                qq.append((CharSequence)sqlEndBalTotal);
                fields.append((CharSequence)sqlEndBalFields);
            }
        } else if (displayAmount) {
            qq.append(" sum(FBeginDebitQty) FBeginDebitQty,");
            fields.append(" FBeginDebitQty,");
            qq.append((CharSequence)sqlBeginBalTotal);
            fields.append((CharSequence)sqlBeginBalFields);
            qq.append("sum(FDebitQty) FDebitQty,").append("sum(FDebitFor) FDebitFor, ").append("sum(FDebitLocal) FDebitLocal, ").append("sum(FCreditQty) FCreditQty,").append("sum(FCreditFor) FCreditFor,").append("sum(FCreditLocal) FCreditLocal,").append("sum(FYearDebitQty) FYearDebitQty,").append("sum(FYearDebitFor) FYearDebitFor,").append("sum(FYearDebitLocal) FYearDebitLocal,").append("sum(FYearCreditQTy) FYearCreditQty,").append("sum(FYearCreditFor) FYearCreditFor, ").append("sum(FYearCreditLocal) FYearCreditLocal, ").append("sum(FEndDebitQty) FEndDebitQty,");
            fields.append(" FDebitQty,").append("FDebitFor, ").append("FDebitLocal, ").append("FCreditQty,").append("FCreditFor,").append("FCreditLocal,").append("FYearDebitQty,").append("FYearDebitFor,").append("FYearDebitLocal,").append("FYearCreditQty,").append("FYearCreditFor, ").append("FYearCreditLocal, ").append("FEndDebitQty,");
            qq.append((CharSequence)sqlEndBalTotal);
            fields.append((CharSequence)sqlEndBalFields);
        } else {
            qq.append((CharSequence)sqlBeginBalTotal);
            fields.append((CharSequence)sqlBeginBalFields);
            qq.append("sum(FDebitFor) FDebitFor, ").append("sum(FDebitLocal) FDebitLocal, ").append("sum(FCreditFor) FCreditFor,").append("sum(FCreditLocal) FCreditLocal,").append("sum(FYearDebitFor) FYearDebitFor,").append("sum(FYearDebitLocal) FYearDebitLocal,").append("sum(FYearCreditFor) FYearCreditFor, ").append("sum(FYearCreditLocal) FYearCreditLocal, ");
            fields.append("FDebitFor, ").append("FDebitLocal, ").append("FCreditFor,").append("FCreditLocal,").append("FYearDebitFor,").append("FYearDebitLocal,").append("FYearCreditFor, ").append("FYearCreditLocal, ");
            qq.append((CharSequence)sqlEndBalTotal);
            fields.append((CharSequence)sqlEndBalFields);
        }
        qq.append(" main.FCUName,main.FOrgUnitId,main.FIsLeafCU FISLeafCU, main.FCULevel FCULevel,main.FCUPrecision FCUPrecision, 1 FIsLeafaccount,100 FaccountLevel ,");
        fields.append(" FCUName,FOrgUnitId,FISLeafCU,FCULevel,FCUPrecision,FIsLeafaccount,FaccountLevel ,");
        if (isBizCode) {
            qq.append("1 FLevel0").append(',').append("1 FISLeaf0");
            fields.append(" FLevel0,FISLeaf0 ");
        } else {
            for (r = 0; r < rowCount; ++r) {
                qq.append("100 FLevel").append(r).append(',');
                qq.append("1 FISLeaf").append(r).append(',');
                fields.append("FLevel").append(r).append(',');
                fields.append("FISLeaf").append(r).append(',');
            }
            qq.deleteCharAt(qq.length() - 1);
            fields.deleteCharAt(fields.length() - 1);
        }
        qq.append(",1 isTotal ");
        qq.append(",'" + GlUtils.getMaxChar() + "' FOrderNumber ");
        fields.append(",isTotal,FOrderNumber ");
        qq.append(" ");
        qq.append("  \n from ").append(tempTable).append(" main ");
        qq.append(" where ");
        qq.append(" main.FAccountLevel = 1 ");
        for (r = 0; r < rs.size(); ++r) {
            qq.append(" and main").append(".FISLeaf").append(r).append("=1  ");
        }
        qq.append(" group by main.FCUName,main.FOrgUnitId,main.FIsLeafCU,main.FCULevel ,main.FCUPrecision ");
        qq.insert(0, "insert into " + tempTable + "(" + fields + ") ");
        DbUtil.execute(ctx, qq.toString());
    }

    @Override
    public void recycleTable() throws BOSException {
    }

    private String getLoc(Context ctx) {
        return ctx.getLocale().toString();
    }

    private String queryData(int rowCount, String tempTable, String[] tempTreeTable, String accountTempTable, String CUTempTable, List<AsstactTypeEntity> rs, DefaultMutableTreeNode treeCompany, boolean isBaseCurrencyQuery, boolean isBizCode, boolean isAssistShowLongNumber, boolean[] isUserLongNumber) {
        String tag;
        int r;
        String CUId = treeCompany == null ? this.getRealCond().getCompanyId() : ((SimpleCompanyUserObject)treeCompany.getUserObject()).getCompanyId();
        boolean isList = this.getRealCond().getCompanyDisplayMode() == CompanyDisplayModeEnum.details;
        boolean displayAmount = this.getRealCond().isShowQty();
        boolean isDCSeparate = this.getRealCond().isOptionDCDispatchAsst();
        GLRptAsstActTypeBalanceParentRowCondition parentRowCondition = this.getRealCond().getParentRowCondition();
        boolean click = false;
        if (parentRowCondition.getClick() != null) {
            click = parentRowCondition.getClick();
        }
        StringBuilder select = new StringBuilder("select ");
        StringBuilder group = new StringBuilder("\n group by ");
        StringBuilder order = new StringBuilder("\n order by ");
        if (isBizCode) {
            group.append("main.fnumber0,main.fid0,main.fname0,");
            order.append(" Fnumber0,");
        } else {
            for (r = 0; r < rowCount; ++r) {
                tag = "tmp" + r;
                if (isAssistShowLongNumber && isUserLongNumber[r]) {
                    group.append(tag).append(".FLongNumber");
                } else {
                    group.append(tag).append(".FNumber");
                }
                group.append(',').append(tag).append(".FdisplayID").append(",").append(tag).append(".FName").append(",").append(tag).append(".FLevel").append(',').append(tag).append(".FISLeaf").append(',');
                order.append(" fnumber").append(r).append(",").append("FLevel").append(r).append(",").append("FdisplayID").append(r).append(",");
            }
        }
        order.append(" fculevel,FCUID,FaccountNumber,faccountLevel,FaccountID");
        if (isBizCode) {
            select.append("main.fid0,main.fnumber0,main.fname0,");
        } else {
            for (r = 0; r < rowCount; ++r) {
                tag = "tmp" + r;
                String sr = String.valueOf(r);
                select.append(tag).append(".FdisplayID FID").append(sr).append(',');
                if (isAssistShowLongNumber && isUserLongNumber[r]) {
                    select.append("replace(").append(tag).append(".FLongNumber,'!','.') FNumber");
                } else {
                    select.append(tag).append(".FNumber FNumber");
                }
                select.append(sr).append(',').append(tag).append(".FName FName").append(sr).append(',');
            }
        }
        select.append("acctable.FID FaccountID,acctable.FNumber FaccountNumber,");
        select.append("acctable.FName FaccountName,acctable.FDC FAccountDC,");
        if (this.cond.isAllCurrency()) {
            select.append("main.FCurrencyID,main.FCurrencyName,main.FCurrencyPre,");
        }
        select.append("cutable.FName FCUName,");
        StringBuilder sqlBeginBalTotal = new StringBuilder();
        StringBuilder sqlEndBalTotal = new StringBuilder();
        if (isDCSeparate) {
            if (isBaseCurrencyQuery) {
                sqlBeginBalTotal.append("sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor,");
                if (displayAmount) {
                    sqlBeginBalTotal.append(" 0 FBeginCreditQty,");
                }
                sqlBeginBalTotal.append(" sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor,");
                sqlEndBalTotal.append("sum(FEndBalanceDebitFor) FEndBalanceDebitFor,");
                if (displayAmount) {
                    sqlEndBalTotal.append(" 0 FEndCreditQty,");
                }
                sqlBeginBalTotal.append(" sum(FEndBalanceCreditFor) FEndBalanceCreditFor,");
            } else {
                sqlBeginBalTotal.append("sum(FBeginBalanceDebitFor) FBeginBalanceDebitFor,sum(FBeginBalanceDebitLocal) FBeginBalanceDebitLocal,");
                if (displayAmount) {
                    sqlBeginBalTotal.append(" 0 FBeginCreditQty,");
                }
                sqlBeginBalTotal.append("sum(FBeginBalanceCreditFor) FBeginBalanceCreditFor, sum(FBeginBalanceCreditLocal) FBeginBalanceCreditLocal,");
                sqlEndBalTotal.append("sum(FEndBalanceDebitFor) FEndBalanceDebitFor,sum(FEndBalanceDebitLocal) FEndBalanceDebitLocal,");
                if (displayAmount) {
                    sqlEndBalTotal.append(" 0 FEndCreditQty,");
                }
                sqlEndBalTotal.append("sum(FEndBalanceCreditFor) FEndBalanceCreditFor,sum(FEndBalanceCreditLocal) FEndBalanceCreditLocal,");
            }
        } else if (isBaseCurrencyQuery) {
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then sum(FBeginBalanceDebitFor)-sum(FBeginBalanceCreditFor) else 0 end FBeginBalanceDebitFor,");
            if (displayAmount) {
                sqlBeginBalTotal.append(" 0 FBeginCreditQty,");
            }
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitFor) < sum(FBeginBalanceCreditFor) then sum(FBeginBalanceCreditFor)-sum(FBeginBalanceDebitFor) else 0 end FBeginBalanceCreditFor,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitFor) >= sum(FEndBalanceCreditFor) then sum(FEndBalanceDebitFor)-sum(FEndBalanceCreditFor) else 0 end FEndBalanceDebitFor,");
            if (displayAmount) {
                sqlEndBalTotal.append(" 0 FEndCreditQty,");
            }
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitFor) < sum(FEndBalanceCreditFor) then sum(FEndBalanceCreditFor)-sum(FEndBalanceDebitFor) else 0 end FEndBalanceCreditFor,");
        } else {
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitFor) >= sum(FBeginBalanceCreditFor) then sum(FBeginBalanceDebitFor)-sum(FBeginBalanceCreditFor) else 0 end FBeginBalanceDebitFor,");
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitLocal) >= sum(FBeginBalanceCreditLocal) then sum(FBeginBalanceDebitLocal)-sum(FBeginBalanceCreditLocal) else 0 end FBeginBalanceDebitLocal,");
            if (displayAmount) {
                sqlBeginBalTotal.append(" 0 FBeginCreditQty,");
            }
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitFor) < sum(FBeginBalanceCreditFor) then sum(FBeginBalanceCreditFor)-sum(FBeginBalanceDebitFor) else 0 end FBeginBalanceCreditFor,");
            sqlBeginBalTotal.append("case when sum(FBeginBalanceDebitLocal) < sum(FBeginBalanceCreditLocal) then sum(FBeginBalanceCreditLocal)-sum(FBeginBalanceDebitLocal) else 0 end FBeginBalanceCreditLocal,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitFor) >= sum(FEndBalanceCreditFor) then sum(FEndBalanceDebitFor)-sum(FEndBalanceCreditFor) else 0 end FEndBalanceDebitFor,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitLocal) >= sum(FEndBalanceCreditLocal) then sum(FEndBalanceDebitLocal)-sum(FEndBalanceCreditLocal) else 0 end FEndBalanceDebitLocal,");
            if (displayAmount) {
                sqlEndBalTotal.append(" 0 FEndCreditQty,");
            }
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitFor) < sum(FEndBalanceCreditFor) then sum(FEndBalanceCreditFor)-sum(FEndBalanceDebitFor) else 0 end FEndBalanceCreditFor,");
            sqlEndBalTotal.append("case when sum(FEndBalanceDebitLocal) < sum(FEndBalanceCreditLocal) then sum(FEndBalanceCreditLocal)-sum(FEndBalanceDebitLocal) else 0 end FEndBalanceCreditLocal,");
        }
        if (displayAmount) {
            if (isBaseCurrencyQuery) {
                select.append("\n sum(FBeginDebitQty) FBeginDebitQty,");
                select.append((CharSequence)sqlBeginBalTotal);
                select.append(" sum(FDebitQty) FDebitQty, sum(FDebitFor) FDebitFor, sum(FCreditQty) FCreditQty, sum(FCreditFor) FCreditFor,");
                select.append(" sum(FYearDebitQty) FYearDebitQty, sum(FYearDebitFor) FYearDebitFor, sum(FYearCreditQty) FYearCreditQty,");
                select.append(" sum(FYearCreditFor) FYearCreditFor, sum(FEndDebitQty) FEndDebitQty,");
                select.append((CharSequence)sqlEndBalTotal);
            } else {
                select.append("\n sum(FBeginDebitQty) FBeginDebitQty,");
                select.append((CharSequence)sqlBeginBalTotal);
                select.append("sum(FDebitQty) FDebitQty,").append("sum(FDebitFor) FDebitFor, sum(FDebitLocal) FDebitLocal,").append("sum(FCreditQty) FCreditQty,").append("sum(FCreditFor) FCreditFor,sum(FCreditLocal) FCreditLocal, ").append("sum(FYearDebitQty) FYearDebitQty,").append("sum(FYearDebitFor) FYearDebitFor,sum(FYearDebitLocal) FYearDebitLocal,").append("sum(FYearCreditQty) FYearCreditQty,").append("sum(FYearCreditFor) FYearCreditFor,sum(FYearCreditLocal) FYearCreditLocal,").append("sum(FEndDebitQty) FEndDebitQty,");
                select.append((CharSequence)sqlEndBalTotal);
            }
        } else if (isBaseCurrencyQuery) {
            select.append((CharSequence)sqlBeginBalTotal);
            select.append("sum(FDebitFor) FDebitFor, sum(FCreditFor) FCreditFor, sum(FYearDebitFor) FYearDebitFor,");
            select.append("sum(FYearCreditFor) FYearCreditFor, ");
            select.append((CharSequence)sqlEndBalTotal);
        } else {
            select.append((CharSequence)sqlBeginBalTotal);
            select.append("sum(FDebitFor) FDebitFor, sum(FDebitLocal) FDebitLocal,").append("sum(FCreditFor) FCreditFor,sum(FCreditLocal) FCreditLocal,").append("sum(FYearDebitFor) FYearDebitFor,sum(FYearDebitLocal) FYearDebitLocal,").append("sum(FYearCreditFor) FYearCreditFor,sum(FYearCreditLocal) FYearCreditLocal,");
            select.append((CharSequence)sqlEndBalTotal);
        }
        select.append("cutable.FISLeaf FISLeafCU,").append("cutable.FID FCUID,");
        if (isList) {
            select.append(" (case when cutable.FID = '").append(CUId).append("' then 1 else 2 end)  FCULevel,");
        } else {
            select.append(" cutable.FLevel FCULevel,");
        }
        select.append("cutable.FPrecision FCUPrecision,").append("acctable.FISLeaf FIsLeafAccount,").append("acctable.FLevel FAccountLevel ");
        if (isBizCode) {
            select.append(",").append("1 FLevel0").append(',').append("1 FISLeaf0 ");
        } else {
            for (int r2 = 0; r2 < rowCount; ++r2) {
                String tag2 = "tmp" + r2;
                select.append(",").append(tag2).append(".FLevel FLevel").append(r2).append(',').append(tag2).append(".FISLeaf FISLeaf").append(r2);
            }
        }
        select.append(",main.FOrderNumber ");
        select.append("\n from ").append(tempTable).append(" main");
        if (!isBizCode) {
            for (int r3 = 0; r3 < rowCount; ++r3) {
                String tag3 = "tmp" + r3;
                AsstactTypeEntity asstactType = rs.get(r3);
                select.append("\n join ");
                select.append(tempTreeTable[r3]).append(" ").append(tag3).append(" on ").append(tag3).append(".Fid = main.fid").append(r3);
                CollectEnum collect = asstactType.getCollect();
                if (collect.equals((Object)CollectEnum.LEVEL)) continue;
                if (collect.equals((Object)CollectEnum.LEAF)) {
                    select.append(" and ");
                    select.append(tag3).append(".FISLeaf=1 ");
                    continue;
                }
                if (!collect.equals((Object)CollectEnum.UP)) continue;
                select.append(" and (");
                select.append(tag3).append(".Flevel = ");
                select.append(asstactType.getSelectedLevel());
                select.append(") ");
            }
        }
        select.append("\n join ");
        select.append(CUTempTable);
        select.append(" cutable on ");
        select.append("cutable.fidhave = main.FOrgUnitID ");
        select.append("\n join ").append(accountTempTable).append(" acctable ").append(" on acctable.fidhave = main.FaccountID ");
        group.append("cutable.FName,");
        group.append("cutable.FISLeaf,");
        group.append("cutable.FLevel,");
        group.append("cutable.FID, ");
        group.append("cutable.FPrecision, ");
        group.append("acctable.FNumber,");
        group.append("acctable.FName,");
        group.append("acctable.FISLeaf,");
        group.append("acctable.FLevel,");
        group.append("acctable.FID,");
        group.append("acctable.FDC ");
        if (this.cond.isAllCurrency()) {
            group.append(",main.FCurrencyID,main.FCurrencyName,main.FCurrencyPre ");
        }
        group.append(",main.FOrderNumber ");
        select.append((CharSequence)group);
        return select.toString();
    }

    private String getMainTable(boolean includeUnPost, boolean showFor, boolean showRpt, boolean showLocal) {
        String tableSuffix;
        String string = tableSuffix = includeUnPost ? "1" : "5";
        tableSuffix = showFor ? tableSuffix + "F" : (showLocal && !showRpt ? tableSuffix + "L" : (showRpt && !showLocal ? tableSuffix + "R" : tableSuffix + "F"));
        return "T_GL_AssistBalance_" + tableSuffix;
    }

    private void logDebug(Object s1, Object s2) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("" + s1 + s2));
        }
    }

    private void logDebug(Object s) {
        if (logger.isDebugEnabled()) {
            logger.debug(s);
        }
    }

    private boolean coreUseCurrency(boolean showFor, boolean showRpt, boolean showLocal, boolean allCurrency) {
        if (!showFor) {
            if (showRpt && showLocal) {
                return !this.cond.isAllCurrency();
            }
            return false;
        }
        return !allCurrency;
    }

    private String coreBuildOrgDataTable(DefaultMutableTreeNode treeCompany, String loc, String companyIDs) throws BOSException {
        boolean isSupportCharIndexToLike = SQLUtil.isSupportCharIndexToLike(this.getCtx());
        String CUTableName = "t_org_company";
        SqlParams parameters = new SqlParams();
        String cuLevelTable = GLResUtil.getRes("act_item_temp_tree", this.ctx);
        StringBuffer cuLevelSql = new StringBuffer();
        cuLevelSql.append("SELECT TItem.FID FIDHave,currency.FPrecision,  TItem1.FID,TItem1.FNumber,TItem1.FLongNumber,TItem1.FParentID, TItem1.FLevel-" + this.getRealCond().getCompany().getLevel() + " FLevel, TItem1.FisLeaf,TItem1.FName_");
        cuLevelSql.append(loc);
        cuLevelSql.append(" FName ");
        cuLevelSql.append(" \n FROM ");
        cuLevelSql.append(CUTableName);
        cuLevelSql.append(" TItem1 inner join ");
        cuLevelSql.append(CUTableName);
        cuLevelSql.append(" TItem");
        if (isSupportCharIndexToLike) {
            cuLevelSql.append(" on TItem.FLongNumber like concat(TItem1.FLongNumber, '!%') ");
        } else {
            cuLevelSql.append(" on CHARINDEX(TItem1.FLongNumber||'!',TItem.FLongNumber)=1 ");
        }
        if (treeCompany != null) {
            cuLevelSql.append(" and TItem1.FLongNumber like '" + ((SimpleCompanyUserObject)treeCompany.getUserObject()).getLongNumber() + "%'");
        }
        cuLevelSql.append(" left outer join t_bd_currency currency on currency.fid = TItem1.FBaseCurrencyID ");
        cuLevelSql.append("\n where TItem.Fid in (");
        cuLevelSql.append(companyIDs);
        cuLevelSql.append(")");
        cuLevelSql.append("union SELECT TItem1.FID FIDHave,currency.FPrecision,TItem1.FID,TItem1.FNumber,TItem1.FLongNumber,TItem1.FParentID,TItem1.FLevel-" + this.getRealCond().getCompany().getLevel() + " FLevel,1 FisLeaf,TItem1.FName_");
        cuLevelSql.append(loc);
        cuLevelSql.append(" FName ");
        cuLevelSql.append(" \n FROM ");
        cuLevelSql.append(CUTableName);
        cuLevelSql.append(" TItem1  ");
        cuLevelSql.append(" left outer join t_bd_currency currency on currency.fid = TItem1.FBaseCurrencyID ");
        cuLevelSql.append("\n where TItem1.Fid in (");
        cuLevelSql.append(companyIDs);
        cuLevelSql.append(")");
        LinkedList<String> allSelectFields = new LinkedList<String>();
        allSelectFields.add("FIDHave VARCHAR(44)");
        allSelectFields.add("FPrecision INT");
        allSelectFields.add("FID VARCHAR(44)");
        allSelectFields.add("FNumber NVARCHAR(80)");
        allSelectFields.add("FLongNumber NVARCHAR(500)");
        allSelectFields.add("FParentID VARCHAR(44)");
        allSelectFields.add("FLevel INT");
        allSelectFields.add("FisLeaf INT");
        allSelectFields.add("FName NVARCHAR(500)");
        StringBuffer sql = new StringBuffer();
        sql.append("select * ");
        sql.append(" from (");
        sql.append(cuLevelSql);
        sql.append(") t");
        cuLevelTable = this.executeCreateTableAsSelectInto(cuLevelTable, sql.toString(), parameters.getParams(), this.ctx, allSelectFields);
        try {
            TempTablePool pool = RptServerUtil.getTempTablePoolForRead(this.ctx, this.getBOSType());
            pool.createIndex(cuLevelTable, "FIDHave", false, false);
            Connection con = RptServerUtil.getConnectionForRead(this.ctx, this.getBOSType());
            pool.analyzeTable(con, cuLevelTable);
        }
        catch (Exception e) {
            logger.error((Object)"create index or analyzeTable error!", (Throwable)e);
        }
        return cuLevelTable;
    }

    private String coreBuildAcctDataTable(boolean isAccountShowLongName, String loc, String dataTable, String companyID, String accountTableId) throws BOSException {
        String accountTableName = "T_bd_accountview";
        StringBuffer sql = new StringBuffer();
        String accountTempTable = GLResUtil.getRes("act_item_temp_tree", this.ctx);
        sql.append("SELECT DISTINCT TItem.FID FIDHave,TItem1.FID,TItem1.FNumber,TItem1.FLongNumber,TItem1.FParentID,TItem1.FLevel,TItem1.FisLeaf,TItem1.");
        sql.append(isAccountShowLongName ? "fdisplayName_" : "fname_").append(loc);
        sql.append(" FName,TItem1.FDC ");
        sql.append("\n FROM ");
        sql.append(accountTableName);
        sql.append(" TItem1 \n inner join ");
        sql.append(accountTableName);
        sql.append(" TItem");
        if (SQLUtil.isSupportCharIndexToLike(this.getCtx())) {
            sql.append(" on TItem.FLongNumber like concat(TItem1.FLongNumber, '!%')");
        } else {
            sql.append(" on (CHARINDEX(TItem1.FLongNumber||'!',TItem.FLongNumber)=1");
        }
        sql.append(" or TItem1.FLongNumber=TItem.FLongNumber) and TItem.faccountTableID = TItem1.faccountTableID");
        sql.append("\n inner join ");
        sql.append(dataTable);
        sql.append(" on ");
        sql.append(dataTable);
        sql.append(" .FaccountID=titem.fid ");
        sql.append("\n where TItem1.Fcompanyid = '");
        sql.append(companyID);
        sql.append("'");
        sql.append(" and TItem.faccountTableID ='");
        sql.append(accountTableId);
        sql.append("'");
        sql.append(" and TItem1.faccountTableID ='");
        sql.append(accountTableId);
        sql.append("'");
        LinkedList<String> allSelectFields = new LinkedList<String>();
        allSelectFields.add("FIDHave VARCHAR(44)");
        allSelectFields.add("FID VARCHAR(44)");
        allSelectFields.add("FNumber NVARCHAR(80)");
        allSelectFields.add("FLongNumber NVARCHAR(500)");
        allSelectFields.add("FParentID VARCHAR(44)");
        allSelectFields.add("FLevel INT");
        allSelectFields.add("FisLeaf INT");
        allSelectFields.add("FName NVARCHAR(500)");
        allSelectFields.add("FDC INT");
        return this.executeCreateTableAsSelectInto(accountTempTable, sql.toString(), null, this.ctx, allSelectFields);
    }

    private static class DbUtil {
        private DbUtil() {
        }

        public static void execute(Context ctx, String sql) throws BOSException {
            try {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }

        public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
            try {
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }

        public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
            try {
                return com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }

        public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
            try {
                return com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
    }
}

