/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptAssistBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.TOTAL;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstItemBalPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactItemBalanceQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalanceBaseDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class GLRptAsstItemBalanceDao
extends GLRptBalanceBaseDao {
    private static final long serialVersionUID = -1768296934878213776L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLRptAsstItemBalanceDao");
    protected GLRptAssistBalanceCondition cond;
    private boolean balanceDirSame;

    public GLRptAsstItemBalanceDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptAssistBalanceCondition)this.getQueryCondition();
        GlParam glParam = GlParam.getGlParams((Context)this.getContex(), (String)"GL_005", (String)this.cond.getCompanyId());
        this.balanceDirSame = glParam.getBoolean("GL_005");
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        ArrayList asstActListBak = new ArrayList();
        asstActListBak.addAll(this.cond.getAsstActList());
        GLRptAsstactItemBalanceQuery query = this.getRptAsstactItemBalanceQuery(this.getContex(), this.getCompany(), this.cond, false);
        query.setSelector(this.getGLRptSelector());
        for (AsstactTypeEntity at : asstActListBak) {
            ArrayList<AsstactTypeEntity> asstActListNew = new ArrayList<AsstactTypeEntity>();
            asstActListNew.add(at);
            this.cond.setAsstAccountIdSet(null);
            this.cond.setAsstActList(asstActListNew);
            query.setAsstactType(at);
            this.insertData(query.getSQL());
        }
        this.cond.setAsstActList(asstActListBak);
    }

    @Override
    protected boolean isInsertAfterCurrPeriodBalance() {
        boolean result = true;
        return result;
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptField.asstItemID);
        selector.add(GLRptField.asstItemNumber);
        selector.add(GLRptField.asstItemName);
        selector.add(GLRptField.actTypeID);
        selector.add(GLRptField.actTypeName);
        selector.add(GLRptField.period);
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
            selector.add(GLRptField.currencyName);
            selector.add(GLRptField.currencyPre);
        }
        selector.add(GLRptField.accountID);
        selector.add(GLRptField.accountNumber);
        selector.add(GLRptField.accountName);
        selector.add(GLRptField.yearBeginBalanceDC);
        if (this.isShowQty()) {
            selector.add(GLRptField.yearBeginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearBeginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearBeginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearBeginBalanceRpt);
        }
        selector.add(GLRptField.beginBalanceDC);
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        selector.add(GLRptField.endBalanceDC);
        if (this.isShowQty()) {
            selector.add(GLRptField.endQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.endBalanceRpt);
        }
        return selector;
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = null;
        if (field == GLRptField.period) {
            colInfo = headInfo.addColumnInfo();
            colInfo.setColName("FPeriodYear");
            colInfo.setWidth(80);
            colInfo = headInfo.addColumnInfo();
            colInfo.setColName("FPeriodNumber");
            colInfo.setWidth(80);
            if (colInfo != null && this.getFreezeField() == field) {
                colInfo.setFreeze(true);
            }
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    @Override
    protected void setRow1Title(List colTitles, GLRptField field) {
        if (field == GLRptField.yearBeginBalanceDC) {
            colTitles.add(GLRptField.yearBeginBalanceFor.getTitle());
        } else if (field == GLRptField.beginBalanceDC) {
            colTitles.add(GLRptField.beginBalanceFor.getTitle());
        } else if (field == GLRptField.endBalanceDC) {
            colTitles.add(GLRptField.endBalanceFor.getTitle());
        } else {
            super.setRow1Title(colTitles, field);
        }
    }

    @Override
    protected GLRptField getFreezeField() {
        return GLRptField.actTypeName;
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        GLRptSumItems sumItem = new GLRptSumItems();
        sumItem.setSumGroup("isTotal", this.isAsynSumData());
        if (this.isAllCurrency()) {
            sumItem.add(GLRptField.currencyID);
            sumItem.add(GLRptField.currencyName);
            sumItem.add(GLRptField.currencyPre);
            sumItem.setSumGroup("currencyIsTotal", this.isAsynSumData());
        }
        if (this.cond.isShowAsstItemTotal()) {
            sumItem.add(GLRptField.actTypeID);
            sumItem.add(GLRptField.actTypeNumber);
            sumItem.add(GLRptField.actTypeName);
            sumItem.setSumGroup("actTypeIsTotal", this.isAsynSumData());
            sumItem.add(GLRptField.asstItemID);
            sumItem.add(GLRptField.asstItemNumber);
            sumItem.add(GLRptField.asstItemName);
            sumItem.setSumGroup("actItemIsTotal");
        }
        return sumItem;
    }

    @Override
    protected void updateField(IRowSet rs, GLRptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        super.updateField(rs, rowData, colName, value);
        if (GLRptField.period.getName().equalsIgnoreCase(colName) && value != null) {
            int pd = rs.getInt(GLRptField.period.getName());
            int year = pd / 100;
            int number = pd % 100;
            rowData.updateObject("FPeriodYear", new Integer(year));
            rowData.updateObject("FPeriodNumber", new Integer(number));
        }
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        this.updateGLRptData(rowSet);
        this.setTotalText(rowSet);
    }

    protected void updateGLRptData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        Object accountDC;
        boolean negate;
        BigDecimal zeroDecimal = GlUtils.zero;
        String DC_EQUAL = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"cell_equal", (Locale)ContextUtils.getLocaleFromEnv());
        if (rowSet.getInt("isTotal") == 1 || rowSet.getInt("actTypeIsTotal") == 1 || rowSet.getInt("actItemIsTotal") == 1 || rowSet.getInt("currencyIsTotal") == 1) {
            BigDecimal yearBeginBalance = null;
            BigDecimal beginBalance = null;
            BigDecimal endBalance = null;
            if (this.isShowFor()) {
                yearBeginBalance = rowSet.getBigDecimal(GLRptField.yearBeginBalanceFor.getName());
                if (yearBeginBalance != null) {
                    rowSet.updateBigDecimal(GLRptField.yearBeginBalanceFor.getName(), yearBeginBalance.abs());
                }
                if ((beginBalance = rowSet.getBigDecimal(GLRptField.beginBalanceFor.getName())) != null) {
                    rowSet.updateBigDecimal(GLRptField.beginBalanceFor.getName(), beginBalance.abs());
                }
                if ((endBalance = rowSet.getBigDecimal(GLRptField.endBalanceFor.getName())) != null) {
                    rowSet.updateBigDecimal(GLRptField.endBalanceFor.getName(), endBalance.abs());
                }
            }
            if (this.isShowLocal()) {
                BigDecimal endBalanceLocal;
                BigDecimal beginBalanceLocal;
                BigDecimal yearBeginBalanceLocal = rowSet.getBigDecimal(GLRptField.yearBeginBalanceLocal.getName());
                if (yearBeginBalanceLocal != null) {
                    rowSet.updateBigDecimal(GLRptField.yearBeginBalanceLocal.getName(), yearBeginBalanceLocal.abs());
                    if (yearBeginBalance == null || yearBeginBalance.compareTo(zeroDecimal) == 0) {
                        yearBeginBalance = yearBeginBalanceLocal;
                    }
                }
                if ((beginBalanceLocal = rowSet.getBigDecimal(GLRptField.beginBalanceLocal.getName())) != null) {
                    rowSet.updateBigDecimal(GLRptField.beginBalanceLocal.getName(), beginBalanceLocal.abs());
                    if (beginBalance == null || beginBalance.compareTo(zeroDecimal) == 0) {
                        beginBalance = beginBalanceLocal;
                    }
                }
                if ((endBalanceLocal = rowSet.getBigDecimal(GLRptField.endBalanceLocal.getName())) != null) {
                    rowSet.updateBigDecimal(GLRptField.endBalanceLocal.getName(), endBalanceLocal.abs());
                    if (endBalance == null || endBalance.compareTo(zeroDecimal) == 0) {
                        endBalance = endBalanceLocal;
                    }
                }
            }
            if (this.isShowRpt()) {
                BigDecimal endBalanceRpt;
                BigDecimal beginBalanceRpt;
                BigDecimal yearBeginBalanceRpt = rowSet.getBigDecimal(GLRptField.yearBeginBalanceRpt.getName());
                if (yearBeginBalanceRpt != null) {
                    rowSet.updateBigDecimal(GLRptField.yearBeginBalanceRpt.getName(), yearBeginBalanceRpt.abs());
                    if (yearBeginBalance == null || yearBeginBalance.compareTo(zeroDecimal) == 0) {
                        yearBeginBalance = yearBeginBalanceRpt;
                    }
                }
                if ((beginBalanceRpt = rowSet.getBigDecimal(GLRptField.beginBalanceRpt.getName())) != null) {
                    rowSet.updateBigDecimal(GLRptField.beginBalanceRpt.getName(), beginBalanceRpt.abs());
                    if (beginBalance == null || beginBalance.compareTo(zeroDecimal) == 0) {
                        beginBalance = beginBalanceRpt;
                    }
                }
                if ((endBalanceRpt = rowSet.getBigDecimal(GLRptField.endBalanceRpt.getName())) != null) {
                    rowSet.updateBigDecimal(GLRptField.endBalanceRpt.getName(), endBalanceRpt.abs());
                    if (endBalance == null || endBalance.compareTo(zeroDecimal) == 0) {
                        endBalance = endBalanceRpt;
                    }
                }
            }
            if (yearBeginBalance == null || yearBeginBalance.compareTo(zeroDecimal) == 0) {
                rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), DC_EQUAL);
            } else if (yearBeginBalance.compareTo(zeroDecimal) == 1) {
                rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
            } else {
                rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
            }
            if (beginBalance == null || beginBalance.compareTo(zeroDecimal) == 0) {
                rowSet.updateObject(GLRptField.beginBalanceDC.getName(), DC_EQUAL);
            } else if (beginBalance.compareTo(zeroDecimal) == 1) {
                rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
            } else {
                rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
            }
            if (endBalance == null || endBalance.compareTo(zeroDecimal) == 0) {
                rowSet.updateObject(GLRptField.endBalanceDC.getName(), DC_EQUAL);
            } else if (endBalance.compareTo(zeroDecimal) == 1) {
                rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
            } else {
                rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
            }
            return;
        }
        if (rowSet.getObject(GLRptField.beginBalanceDC.getName()) != null) {
            BigDecimal beginBalance = null;
            BigDecimal beginBalanceFor = null;
            BigDecimal beginBalanceLocal = null;
            BigDecimal beginBalanceRpt = null;
            int beginBalanceDC = rowSet.getInt(GLRptField.beginBalanceDC.getName());
            rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.getEnum((int)beginBalanceDC));
            if (this.isShowFor()) {
                beginBalance = beginBalanceFor = rowSet.getBigDecimal(GLRptField.beginBalanceFor.getName());
            }
            if (this.isShowLocal()) {
                beginBalanceLocal = rowSet.getBigDecimal(GLRptField.beginBalanceLocal.getName());
                if (beginBalance == null || beginBalance.compareTo(zeroDecimal) == 0) {
                    beginBalance = beginBalanceLocal;
                }
            }
            if (this.isShowRpt()) {
                beginBalanceRpt = rowSet.getBigDecimal(GLRptField.beginBalanceRpt.getName());
                if (beginBalance == null || beginBalance.compareTo(zeroDecimal) == 0) {
                    beginBalance = beginBalanceRpt;
                }
            }
            if (beginBalance == null || beginBalance.compareTo(zeroDecimal) == 0) {
                rowSet.updateObject(GLRptField.beginBalanceDC.getName(), DC_EQUAL);
            } else if (this.balanceDirSame) {
                BigDecimal amount;
                negate = false;
                accountDC = rowSet.getObject(GLRptField.beginBalanceDC.getName());
                if (accountDC instanceof BalanceDirectionEnum && accountDC == BalanceDirectionEnum.CREDIT) {
                    negate = true;
                }
                if (this.isShowFor()) {
                    amount = rowSet.getBigDecimal(GLRptField.beginBalanceFor.getName());
                    rowSet.updateBigDecimal(GLRptField.beginBalanceFor.getName(), negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
                }
                if (this.isShowLocal()) {
                    amount = rowSet.getBigDecimal(GLRptField.beginBalanceLocal.getName());
                    rowSet.updateBigDecimal(GLRptField.beginBalanceLocal.getName(), negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
                }
                if (this.isShowRpt()) {
                    amount = rowSet.getBigDecimal(GLRptField.beginBalanceRpt.getName());
                    rowSet.updateBigDecimal(GLRptField.beginBalanceRpt.getName(), negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
                }
                if (this.isShowQty()) {
                    amount = rowSet.getBigDecimal(GLRptField.beginQty.getName());
                    rowSet.updateBigDecimal(GLRptField.beginQty.getName(), negate ? (amount == null ? GlUtils.zero : amount.negate()) : amount);
                }
            } else if (!this.balanceDirSame) {
                if (beginBalanceFor != null) {
                    if (beginBalanceFor.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.beginBalanceFor.getName(), beginBalanceFor.abs());
                }
                if (beginBalanceLocal != null) {
                    if (beginBalanceLocal.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.beginBalanceLocal.getName(), beginBalanceLocal.abs());
                }
                if (beginBalanceRpt != null) {
                    if (beginBalanceRpt.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.beginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.beginBalanceRpt.getName(), beginBalanceRpt.abs());
                }
            }
        }
        if (rowSet.getObject(GLRptField.endBalanceDC.getName()) != null) {
            BigDecimal endBalance = null;
            BigDecimal endBalanceFor = null;
            BigDecimal endBalanceLocal = null;
            BigDecimal endBalanceRpt = null;
            int endBalanceDC = rowSet.getInt(GLRptField.endBalanceDC.getName());
            rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.getEnum((int)endBalanceDC));
            if (this.isShowFor()) {
                endBalance = endBalanceFor = rowSet.getBigDecimal(GLRptField.endBalanceFor.getName());
            }
            if (this.isShowLocal()) {
                endBalanceLocal = rowSet.getBigDecimal(GLRptField.endBalanceLocal.getName());
                if (endBalance == null || endBalance.compareTo(zeroDecimal) == 0) {
                    endBalance = endBalanceLocal;
                }
            }
            if (this.isShowRpt()) {
                endBalanceRpt = rowSet.getBigDecimal(GLRptField.endBalanceRpt.getName());
                if (endBalance == null || endBalance.compareTo(zeroDecimal) == 0) {
                    endBalance = endBalanceRpt;
                }
            }
            if (endBalance == null || endBalance.compareTo(zeroDecimal) == 0) {
                rowSet.updateObject(GLRptField.endBalanceDC.getName(), DC_EQUAL);
            } else if (this.balanceDirSame) {
                negate = false;
                accountDC = rowSet.getObject(GLRptField.endBalanceDC.getName());
                if (accountDC instanceof BalanceDirectionEnum && accountDC == BalanceDirectionEnum.CREDIT) {
                    negate = true;
                }
                if (endBalanceFor != null) {
                    rowSet.updateBigDecimal(GLRptField.endBalanceFor.getName(), negate ? (endBalanceFor == null ? GlUtils.zero : endBalanceFor.negate()) : endBalanceFor);
                }
                if (endBalanceLocal != null) {
                    rowSet.updateBigDecimal(GLRptField.endBalanceLocal.getName(), negate ? (endBalanceLocal == null ? GlUtils.zero : endBalanceLocal.negate()) : endBalanceLocal);
                }
                if (endBalanceRpt != null) {
                    rowSet.updateBigDecimal(GLRptField.endBalanceRpt.getName(), negate ? (endBalanceRpt == null ? GlUtils.zero : endBalanceRpt.negate()) : endBalanceRpt);
                }
            } else if (!this.balanceDirSame) {
                if (endBalanceFor != null) {
                    if (endBalanceFor.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.endBalanceFor.getName(), endBalanceFor.abs());
                }
                if (endBalanceLocal != null) {
                    if (endBalanceLocal.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.endBalanceLocal.getName(), endBalanceLocal.abs());
                }
                if (endBalanceRpt != null) {
                    if (endBalanceRpt.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.getEnum((int)-1));
                    } else {
                        rowSet.updateObject(GLRptField.endBalanceDC.getName(), BalanceDirectionEnum.getEnum((int)1));
                    }
                    rowSet.updateBigDecimal(GLRptField.endBalanceRpt.getName(), endBalanceRpt.abs());
                }
            }
        }
        if (rowSet.getObject(GLRptField.yearBeginBalanceDC.getName()) != null) {
            BigDecimal yearBeginBalance = null;
            BigDecimal yearBeginBalanceFor = null;
            BigDecimal yearBeginBalanceLocal = null;
            BigDecimal yearBeginBalanceRpt = null;
            int yearBeginBalanceDC = rowSet.getInt(GLRptField.yearBeginBalanceDC.getName());
            rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.getEnum((int)yearBeginBalanceDC));
            if (this.isShowFor()) {
                yearBeginBalance = yearBeginBalanceFor = rowSet.getBigDecimal(GLRptField.yearBeginBalanceFor.getName());
            }
            if (this.isShowLocal()) {
                yearBeginBalanceLocal = rowSet.getBigDecimal(GLRptField.yearBeginBalanceLocal.getName());
                if (yearBeginBalance == null || yearBeginBalance.compareTo(zeroDecimal) == 0) {
                    yearBeginBalance = yearBeginBalanceLocal;
                }
            }
            if (this.isShowRpt()) {
                yearBeginBalanceRpt = rowSet.getBigDecimal(GLRptField.yearBeginBalanceRpt.getName());
                if (yearBeginBalance == null || yearBeginBalance.compareTo(zeroDecimal) == 0) {
                    yearBeginBalance = yearBeginBalanceRpt;
                }
            }
            if (yearBeginBalance == null || yearBeginBalance.compareTo(zeroDecimal) == 0) {
                rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), DC_EQUAL);
            } else if (this.balanceDirSame) {
                this.updateYearBeginNew(rowSet);
            } else if (!this.balanceDirSame) {
                if (yearBeginBalanceFor != null) {
                    if (yearBeginBalanceFor.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.yearBeginBalanceFor.getName(), yearBeginBalanceFor.abs());
                }
                if (yearBeginBalanceLocal != null) {
                    if (yearBeginBalanceLocal.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.yearBeginBalanceLocal.getName(), yearBeginBalanceLocal.abs());
                }
                if (yearBeginBalanceRpt != null) {
                    if (yearBeginBalanceRpt.compareTo(zeroDecimal) == -1) {
                        rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.CREDIT);
                    } else {
                        rowSet.updateObject(GLRptField.yearBeginBalanceDC.getName(), BalanceDirectionEnum.DEBIT);
                    }
                    rowSet.updateBigDecimal(GLRptField.yearBeginBalanceRpt.getName(), yearBeginBalanceRpt.abs());
                }
            }
        }
    }

    private void setTotalText(GLRptRowSet rowSet) throws BOSException {
        if (rowSet.getInt("isTotal") == 1) {
            if (this.isAllCurrency()) {
                rowSet.updateObject(GLRptField.currencyName.getName(), TOTAL.getTotal(this.getContex()));
            } else {
                rowSet.updateObject(GLRptField.actTypeName.getName(), TOTAL.getTotal(this.getContex()));
            }
        } else if (this.isAllCurrency() && rowSet.getInt("currencyIsTotal") == 1) {
            rowSet.updateObject(GLRptField.actTypeName.getName(), TOTAL.getTotal(this.getContex()));
        } else if (this.cond.isShowAsstItemTotal() && rowSet.getInt("actTypeIsTotal") == 1) {
            rowSet.updateObject(GLRptField.asstItemNumber.getName(), TOTAL.getSubTotal(this.getContex()));
        } else if (this.cond.isShowAsstItemTotal() && rowSet.getInt("actItemIsTotal") == 1) {
            rowSet.updateObject(GLRptField.accountNumber.getName(), TOTAL.getSubTotal(this.getContex()));
        }
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAsstItemBalPageQuery(this.getContex(), this.cond, this.getCompany(), this.isCreateDataTempTable());
    }

    protected GLRptAsstactItemBalanceQuery getRptAsstactItemBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit) throws EASBizException, BOSException {
        return new GLRptAsstactItemBalanceQuery(ctx, company, cond, isMeasureUnit);
    }

    protected void updateYearBeginNew(IGLRptRowData rowData) throws BOSException, EASBizException {
        boolean negate;
        boolean bl = negate = rowData.getObject(GLRptField.yearBeginBalanceDC.getName()) == BalanceDirectionEnum.CREDIT;
        if (this.getGLRptSelector().containsBalField("FYearBegin")) {
            BigDecimal amount;
            BigDecimal yearCredit;
            BigDecimal yearDebit;
            BigDecimal endBalance;
            if (this.isShowFor()) {
                endBalance = rowData.getBigDecimal(GLRptField.endBalanceFor.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitFor.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditFor.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginBalanceFor.getName(), amount);
            }
            if (this.isShowLocal()) {
                endBalance = rowData.getBigDecimal(GLRptField.endBalanceLocal.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitLocal.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditLocal.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginBalanceLocal.getName(), amount);
            }
            if (this.isShowRpt()) {
                endBalance = rowData.getBigDecimal(GLRptField.endBalanceRpt.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitRpt.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditRpt.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginBalanceRpt.getName(), amount);
            }
            if (this.isShowQty()) {
                endBalance = rowData.getBigDecimal(GLRptField.endQty.getName());
                if (endBalance == null) {
                    endBalance = GlUtils.zero;
                }
                if ((yearDebit = rowData.getBigDecimal(GLRptField.yearDebitQty.getName())) == null) {
                    yearDebit = GlUtils.zero;
                }
                if ((yearCredit = rowData.getBigDecimal(GLRptField.yearCreditQty.getName())) == null) {
                    yearCredit = GlUtils.zero;
                }
                amount = negate ? endBalance.add(yearDebit).subtract(yearCredit) : endBalance.subtract(yearDebit).add(yearCredit);
                rowData.updateBigDecimal(GLRptField.yearBeginQty.getName(), amount);
            }
        }
    }
}

