/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptCache;
import com.kingdee.eas.fi.gl.rpt.GLRptException;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBeginPeriodBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactGDPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherDetailDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAsstactBalGDDao
extends GLRptVoucherDetailDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalGDDao");
    protected GLRptAsstactGDCondition cond;
    protected boolean isShowAsstItem = false;
    private AsstActTypeInfo accountingAsstActType = null;
    private Map<String, BigDecimal> loadedAsstActIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> loadedAccountIDToQtyCoefficient = new HashMap<String, BigDecimal>();
    private Context ctx;
    private boolean isFromElRec = false;

    public GLRptAsstactBalGDDao(Context ctx) throws EASBizException, BOSException {
        super(ctx, true);
        this.ctx = ctx;
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        Object isPrintTotalObj;
        GLRptCache cache;
        super.init(ev);
        this.cond = (GLRptAsstactGDCondition)this.getQueryCondition();
        if (ev.get("isFromElRec") != null) {
            this.isFromElRec = Boolean.valueOf(ev.get("isFromElRec").toString());
        }
        if (this.cond.getDataSourceTable() != null && (cache = GLRptCache.getGLRptCache(this.getContex(), this.cond.getDataSourceTable())) == null && !this.isFromElRec) {
            throw new GLRptException(GLRptException.SESSION_INVALID);
        }
        Object isisShowAsstItemObj = ev.get("isShowAsstItem");
        if (isisShowAsstItemObj != null && isisShowAsstItemObj instanceof Boolean) {
            this.isShowAsstItem = (Boolean)isisShowAsstItemObj;
        }
        if ((isPrintTotalObj = ev.get("isPrintTotal")) instanceof Boolean && ((Boolean)isPrintTotalObj).booleanValue()) {
            this.isShowAsstItem = false;
        }
        if (this.isFromElRec) {
            this.isShowAsstItem = true;
        }
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        this.insertVoucher();
        this.insertBalance();
        if (this.cond.isShowDailyTotal()) {
            this.insertDailySum();
        }
    }

    protected boolean isQueryMeasureUnitBalance() {
        return this.isShowQty() && (this.cond.isGroupByMU() || this.cond.getMeasureUnitId() != null);
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        if (field == GLRptVoucherField.creatorName) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field.getName());
            colInfo.setWidth(70);
        } else {
            super.addTableHeadColumn(headInfo, field);
        }
    }

    protected void insertVoucher() throws BOSException, EASBizException {
        GLRptVoucherAssistQuery query = this.getRptVoucherAssistQuery(this.getContex(), this.cond, this.isQueryMeasureUnitBalance());
        GLRptSelector insertSelector = new GLRptSelector();
        Iterator<GLRptField> it = this.getVoucherSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!field.isTempTableField()) continue;
            insertSelector.add(field);
        }
        query.setSelector(insertSelector);
        query.setOrder(this.getVoucherSorter());
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("KSQL_SEQ");
        it = this.getVoucherSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (!field.isTempTableField() || field.getSelect() == null) continue;
            fields.add(field.getName());
        }
        String insertSql = query.getSQL();
        int lsorder = insertSql.lastIndexOf("ORDER BY");
        if (lsorder != -1) {
            insertSql = insertSql.substring(0, lsorder);
        }
        this.insertData(fields.toArray(new String[fields.size()]), insertSql);
    }

    private GLRptSQLOrder getVoucherSorter() {
        GLRptSQLOrder order = new GLRptSQLOrder();
        if (!this.cond.isGroupByAsst()) {
            order.add(GLRptVoucherField.accountID.getSelect());
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.addOrgUnitSorter(order);
        }
        if (this.cond.isAllCurrency()) {
            order.add(GLRptVoucherField.currencyID.getSelect());
        }
        if (this.cond.isShowQty() && this.cond.isGroupByMU()) {
            order.add(GLRptVoucherField.asstMeasureUnitID.getSelect());
        }
        order.add(GLRptVoucherField.period.getSelect());
        boolean numberOrdered = this.addSelfOrder(order);
        order.add("voucher.FCreateTime");
        if (!numberOrdered) {
            order.add("voucher.FNumber");
        }
        order.add("entries.FSeq");
        order.add("assistRecords.FSeq");
        return order;
    }

    private boolean addSelfOrder(GLRptSQLOrder order) {
        boolean numberOrdered = false;
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                if ("number".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.voucherNumber.getSelect(), sorter.getSortType());
                    numberOrdered = true;
                    continue;
                }
                if ("bookedDate".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.bookDate.getSelect(), sorter.getSortType());
                    continue;
                }
                if ("voucherType.number".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.voucherTypeNumber.getSelect(), sorter.getSortType());
                    continue;
                }
                if (!"assistRecords.bizDate".equalsIgnoreCase(sorter.getPropertyName())) continue;
                order.add(GLRptVoucherField.asstRecordBizdate.getSelect(), sorter.getSortType());
            }
        }
        return numberOrdered;
    }

    protected void insertBalance() throws EASBizException, BOSException {
        this.insertPeriodBeginBalance();
        this.insertPeriodAndYearBalance();
    }

    protected void insertPeriodBeginBalance() throws BOSException, EASBizException {
        int startPeriodYear = this.cond.getPeriodYearStart();
        int startPeriodNumber = this.cond.getPeriodNumberStart();
        PeriodInfo currPeriod = this.cond.getCurrPeriod();
        if (currPeriod != null && currPeriod.getNumber() < startPeriodYear * 100 + startPeriodNumber) {
            this.cond.clearPeriodIdCache();
        }
        GLRptAsstactBeginPeriodBalQuery query = this.getRptAsstactBeginPeriodBalQuery(this.getContex(), this.getCompany(), this.cond, this.isQueryMeasureUnitBalance(), true);
        query.setSelector(this.getBeginBalQuerySelector());
        query.addGLRptFilter(new AmountFilter());
        List fields = this.getInsertBalField();
        String[] fs = new String[fields.size()];
        fs = fields.toArray(fs);
        this.insertData(fs, query.getSQL());
    }

    protected void insertPeriodAndYearBalance() throws BOSException, EASBizException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("FBalSeq");
        Iterator<GLRptField> keyIt = this.getAsstItemSelector().getTempTableFields().iterator();
        while (keyIt.hasNext()) {
            fields.add(keyIt.next().getName());
        }
        if (!this.cond.isGroupByAsst()) {
            fields.add(GLRptField.accountID.getName());
        }
        if (!this.cond.isSumPeriod()) {
            fields.add(GLRptField.period.getName());
        }
        if (!this.cond.isSumPeriod()) {
            fields.add(GLRptVoucherField.bookDate.getName());
            fields.add(GLRptVoucherField.asstRecordBizdate.getName());
        }
        if (this.isAllCurrency()) {
            fields.add(GLRptField.currencyID.getName());
        }
        if (this.isQueryMeasureUnitBalance()) {
            fields.add(GLRptField.measureUnitID.getName());
        }
        String[] fs = new String[fields.size()];
        fs = fields.toArray(fs);
        this.insertData(fs, this.getPeriodAndYearBalSql());
    }

    private String getPeriodAndYearBalSql() throws EASBizException, BOSException {
        boolean isNoDisplayZeroTotal = this.cond.isNoDisplayZeroTotal();
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (isNoDisplayZeroTotal) {
            sql.append(" distinct ");
        }
        sql.append(" t1.").append("FBalSeq");
        Iterator<GLRptField> keyIt = this.getAsstItemSelector().getTempTableFields().iterator();
        while (keyIt.hasNext()) {
            sql.append(", t.").append(keyIt.next().getName());
        }
        if (!this.cond.isGroupByAsst()) {
            sql.append(", t.").append(GLRptField.accountID.getName());
        }
        if (!this.cond.isSumPeriod()) {
            sql.append(", ").append(isNoDisplayZeroTotal ? "t." : "pd.fnumber ").append(GLRptField.period.getName());
        }
        if (!this.cond.isSumPeriod()) {
            sql.append(", pd.fenddate ").append(GLRptVoucherField.bookDate.getName());
            sql.append(", pd.fenddate ").append(GLRptVoucherField.asstRecordBizdate.getName());
        }
        if (this.isAllCurrency()) {
            sql.append(", t.").append(GLRptField.currencyID.getName());
        }
        if (this.isQueryMeasureUnitBalance()) {
            sql.append(", t.").append(GLRptField.measureUnitID.getName());
        }
        sql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
        int endPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd();
        if (!this.cond.isSumPeriod()) {
            if (isNoDisplayZeroTotal) {
                sql.append(" inner join t_bd_period pd on pd.fnumber = t.fperiod");
            } else {
                sql.append(" inner join t_bd_period pd on pd.fnumber >= t.fperiod").append(" and pd.fnumber <= ").append(endPeriod);
            }
            sql.append(" and pd.ftypeid = '").append(this.cond.getPeriodTypeId()).append("'");
        }
        sql.append(" inner join (");
        sql.append(" select ").append(4).append(" ").append("FBalSeq");
        sql.append(" union all ");
        sql.append(" select ").append(5).append(" ").append("FBalSeq");
        sql.append(") t1 on 1=1");
        sql.append(" where t.").append("FBalSeq").append(" = ").append(isNoDisplayZeroTotal ? 2 : 1);
        return sql.toString();
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = this.getVoucherSelector();
        boolean isShowPrice = this.isShowQty();
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.endQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.endPrice);
            }
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.endBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.debitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.debitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.debitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.debitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.creditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.creditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.creditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.creditRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptVoucherField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.yearCreditRpt);
        }
        if (this.cond.isDisplayAttribute()) {
            selector.add(GLRptVoucherField.bizNumber);
            selector.add(GLRptVoucherField.invoiceNumber);
            selector.add(GLRptVoucherField.settlementCode);
            selector.add(GLRptVoucherField.settleTypeName);
            selector.add(GLRptVoucherField.ticketNumber);
        }
        return selector;
    }

    private GLRptSelector getVoucherSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(this.getAsstItemSelector());
        selector.add(GLRptVoucherField.accountID);
        selector.add(GLRptVoucherField.HGID);
        if (!this.cond.isGroupByAsst()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                selector.add(GLRptVoucherField.accountNumberMerger);
                if (this.cond.getRptParams().isAccountShowLongName()) {
                    selector.add(GLRptVoucherField.accountDisplayNameMerger);
                } else {
                    selector.add(GLRptVoucherField.accountNameMerger);
                }
            } else {
                selector.add(GLRptVoucherField.accountNumber);
                if (this.cond.getRptParams().isAccountShowLongName()) {
                    selector.add(GLRptVoucherField.accountDisplayName);
                } else {
                    selector.add(GLRptVoucherField.accountName);
                }
            }
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            this.initSelectorOrgUnit(selector);
            selector.add(this.getOrgUnitNameField());
        }
        selector.add(GLRptVoucherField.bookDate);
        selector.add(GLRptVoucherField.asstRecordBizdate);
        selector.add(GLRptVoucherField.period);
        selector.add(GLRptVoucherField.voucherTypeName);
        selector.add(GLRptVoucherField.voucherID);
        selector.add(GLRptVoucherField.voucherNumber);
        selector.add(GLRptVoucherField.entryID);
        selector.add(GLRptVoucherField.entrySeq);
        selector.add(GLRptVoucherField.asstRecordID);
        selector.add(GLRptVoucherField.asstRecordSeq);
        if (this.cond.isGroupByAsst()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                selector.add(GLRptVoucherField.accountNumberMerger);
                if (this.cond.getRptParams().isAccountShowLongName()) {
                    selector.add(GLRptVoucherField.accountDisplayNameMerger);
                } else {
                    selector.add(GLRptVoucherField.accountNameMerger);
                }
            } else {
                selector.add(GLRptVoucherField.accountNumber);
                if (this.cond.getRptParams().isAccountShowLongName()) {
                    selector.add(GLRptVoucherField.accountDisplayName);
                } else {
                    selector.add(GLRptVoucherField.accountName);
                }
            }
        }
        selector.add(GLRptVoucherField.entryAsstRecordDesc);
        selector.add(GLRptVoucherField.creatorName);
        if (this.isAllCurrency()) {
            selector.add(GLRptVoucherField.currencyID);
            selector.add(GLRptVoucherField.currencyName);
            selector.add(GLRptVoucherField.currencyPre);
        }
        if (this.isShowFor() && this.isShowLocal()) {
            selector.add(GLRptVoucherField.localExRate);
            if (this.isAllCurrency()) {
                selector.add(GLRptVoucherField.localExRatePre);
            }
        }
        if (this.isShowFor() && this.isShowRpt()) {
            selector.add(GLRptVoucherField.rptExRate);
            if (this.isAllCurrency()) {
                selector.add(GLRptVoucherField.rptExRatePre);
            }
        }
        if (this.isShowQty()) {
            if (this.isQueryMeasureUnitBalance()) {
                selector.add(GLRptVoucherField.asstMeasureUnitID);
            }
            selector.add(GLRptVoucherField.measureUnitName);
        }
        boolean isShowPrice = this.isShowQty();
        if (this.isShowQty()) {
            if (!this.cond.isGroupByMU()) {
                selector.add(GLRptVoucherField.asstRecordStandDebitQty);
            }
            selector.add(GLRptVoucherField.asstRecordDebitQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.asstRecordDebitPrice);
            }
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.asstRecordDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.asstRecordDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.asstRecordDebitRpt);
        }
        if (this.isShowQty()) {
            if (!this.cond.isGroupByMU()) {
                selector.add(GLRptVoucherField.asstRecordStandCreditQty);
            }
            selector.add(GLRptVoucherField.asstRecordCreditQty);
            if (isShowPrice) {
                selector.add(GLRptVoucherField.asstRecordCreditPrice);
            }
        }
        if (this.isShowFor()) {
            selector.add(GLRptVoucherField.asstRecordCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptVoucherField.asstRecordCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptVoucherField.asstRecordCreditRpt);
        }
        if (this.cond.isShowDailyTotal()) {
            if (this.isShowQty()) {
                selector.add(GLRptVoucherField.dayDebitQty);
            }
            if (this.isShowFor()) {
                selector.add(GLRptVoucherField.dayDebitFor);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptVoucherField.dayDebitLocal);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptVoucherField.dayDebitRpt);
            }
            if (this.isShowQty()) {
                selector.add(GLRptVoucherField.dayCreditQty);
            }
            if (this.isShowFor()) {
                selector.add(GLRptVoucherField.dayCreditFor);
            }
            if (this.isShowLocal()) {
                selector.add(GLRptVoucherField.dayCreditLocal);
            }
            if (this.isShowRpt()) {
                selector.add(GLRptVoucherField.dayCreditRpt);
            }
        }
        selector.add(GLRptVoucherField.voucherType);
        selector.add(GLRptVoucherField.accountDC);
        return selector;
    }

    protected GLRptSelector getBeginBalQuerySelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(GLRptVoucherField.beginBalType);
        Iterator<GLRptField> keyIt = this.getAsstItemSelector().getTempTableFields().iterator();
        while (keyIt.hasNext()) {
            selector.add(keyIt.next());
        }
        if (!this.cond.isGroupByAsst()) {
            selector.add(GLRptField.accountID);
        }
        if (this.isAllCurrency()) {
            selector.add(GLRptField.currencyID);
        }
        selector.add(GLRptField.period);
        selector.add(GLRptField.periodBeginDate);
        if (this.isQueryMeasureUnitBalance()) {
            selector.add(GLRptField.measureUnitID);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.beginQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.beginBalanceFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.beginBalanceLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.beginBalanceRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearDebitQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            selector.add(GLRptField.yearCreditQty);
        }
        if (this.isShowFor()) {
            selector.add(GLRptField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            selector.add(GLRptField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            selector.add(GLRptField.yearCreditRpt);
        }
        return selector;
    }

    protected List getInsertBalField() throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(GLRptVoucherField.beginBalType.getName());
        Iterator<GLRptField> keyIt = this.getAsstItemSelector().getTempTableFields().iterator();
        while (keyIt.hasNext()) {
            fields.add(keyIt.next().getName());
        }
        if (!this.cond.isGroupByAsst()) {
            fields.add(GLRptVoucherField.accountID.getName());
        }
        if (this.isAllCurrency()) {
            fields.add(GLRptVoucherField.currencyID.getName());
        }
        fields.add(GLRptVoucherField.period.getName());
        fields.add(GLRptVoucherField.bookDate.getName());
        if (this.isQueryMeasureUnitBalance()) {
            fields.add(GLRptVoucherField.asstMeasureUnitID.getName());
        }
        Iterator it = this.getBalAmountFields().iterator();
        while (it.hasNext()) {
            fields.add(((GLRptField)it.next()).getName());
        }
        return fields;
    }

    private List getBalAmountFields() throws EASBizException, BOSException {
        ArrayList<GLRptField> fields = new ArrayList<GLRptField>();
        if (this.isShowQty()) {
            fields.add(GLRptVoucherField.endQty);
        }
        if (this.isShowFor()) {
            fields.add(GLRptVoucherField.endBalanceFor);
        }
        if (this.isShowLocal()) {
            fields.add(GLRptVoucherField.endBalanceLocal);
        }
        if (this.isShowRpt()) {
            fields.add(GLRptVoucherField.endBalanceRpt);
        }
        if (this.isShowQty()) {
            fields.add(GLRptVoucherField.yearDebitQty);
        }
        if (this.isShowFor()) {
            fields.add(GLRptVoucherField.yearDebitFor);
        }
        if (this.isShowLocal()) {
            fields.add(GLRptVoucherField.yearDebitLocal);
        }
        if (this.isShowRpt()) {
            fields.add(GLRptVoucherField.yearDebitRpt);
        }
        if (this.isShowQty()) {
            fields.add(GLRptVoucherField.yearCreditQty);
        }
        if (this.isShowFor()) {
            fields.add(GLRptVoucherField.yearCreditFor);
        }
        if (this.isShowLocal()) {
            fields.add(GLRptVoucherField.yearCreditLocal);
        }
        if (this.isShowRpt()) {
            fields.add(GLRptVoucherField.yearCreditRpt);
        }
        return fields;
    }

    @Override
    protected BigDecimal getDebit(GLRptRowSet rs, String sufifx) throws BOSException {
        BigDecimal debit = rs.getBigDecimal("FSubDebit" + sufifx);
        if (sufifx.equals("Qty") && !this.cond.isGroupByMU() && rs.getInt("FBalSeq") == 2) {
            debit = rs.getBigDecimal(GLRptVoucherField.asstRecordStandDebitQty.getName());
        }
        return debit;
    }

    @Override
    protected BigDecimal getCredit(GLRptRowSet rs, String sufifx) throws BOSException {
        BigDecimal credit = rs.getBigDecimal("FSubCredit" + sufifx);
        if (sufifx.equals("Qty") && !this.cond.isGroupByMU() && rs.getInt("FBalSeq") == 2) {
            credit = rs.getBigDecimal(GLRptVoucherField.asstRecordStandCreditQty.getName());
        }
        return credit;
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        GLRptSumItems sumItem = new GLRptSumItems();
        Iterator<GLRptField> it = this.getAsstItemSelector().iterator();
        while (it.hasNext()) {
            sumItem.add(it.next());
        }
        sumItem.setSumGroup("isTotal", this.isAsynSumData());
        if (this.isAllCurrency()) {
            sumItem.add(GLRptVoucherField.currencyID);
            sumItem.add(GLRptVoucherField.currencyName);
            sumItem.add(GLRptVoucherField.currencyPre);
            sumItem.setSumGroup("currencyIsTotal", this.isAsynSumData());
        }
        return sumItem;
    }

    private GLRptSelector getAsstItemSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        if (!this.isShowAsstItem && !this.isFromElRec) {
            return selector;
        }
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            selector.add(GLRptField.genAsstDataBaseID(at));
            boolean isShowNumber = this.cond.getRptParams().isAssitemShowNumber();
            boolean isShowLongName = this.cond.getRptParams().isShowLongNameForGeneral();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            selector.add(GLRptField.genAsstDataBaseNumber(at, isShowLongNumber));
            selector.add(GLRptField.genAsstDataBaseName(at, this.getContex().getLocale(), isShowNumber, isShowLongNumber, isShowLongName));
            if (!at.isShowAsstGroup()) continue;
            selector.add(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
        }
        return selector;
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        if (this.cond.isShowQty() && rowSet.getInt("FBalSeq") == -1) {
            this.setQty(rowSet);
        }
        super.doGLRptRowData(rowSet);
        if (rowSet.getInt("FBalSeq") == 1) {
            rowSet.updateObject(GLRptField.period.getName(), null);
            rowSet.updateObject(GLRptVoucherField.bookDate.getName(), null);
        }
        if (rowSet.getInt("FBalSeq") == 3) {
            rowSet.updateObject(GLRptVoucherField.accountName.getName(), null);
            rowSet.updateObject(GLRptVoucherField.accountNumber.getName(), null);
        }
    }

    protected void setQty(GLRptRowSet rowSet) throws BOSException, EASBizException {
        if (rowSet.getBigDecimal(GLRptVoucherField.asstRecordDebitQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptVoucherField.asstRecordDebitQty.getName(), rowSet.getBigDecimal(GLRptVoucherField.asstRecordDebitQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal(GLRptVoucherField.asstRecordCreditQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptVoucherField.asstRecordCreditQty.getName(), rowSet.getBigDecimal(GLRptVoucherField.asstRecordCreditQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
        }
        if (rowSet.getBigDecimal(GLRptField.endQty.getName()) != null) {
            rowSet.updateBigDecimal(GLRptField.endQty.getName(), rowSet.getBigDecimal(GLRptField.endQty.getName()).divide(this.getAsstQtyCoefficient(rowSet), this.cond.getQtyScale(), 4));
        }
    }

    @Override
    protected boolean isCreateDataTempTable() {
        return false;
    }

    @Override
    protected boolean isCreateFiled(GLRptField field, boolean isCreateDataTempTable) {
        return field.isTempTableField();
    }

    @Override
    protected GLRptTempTableInfo createDataTempTable() throws BOSException, EASBizException {
        if (this.isCreateSeqTable()) {
            return new GLRptTempTableInfo(GLTempTableUtil.createDBSysTempTable(this.getContex(), "KSQL_SEQ INT IDENTITY (1, 1)," + this.getTempTableStruct().getDataTableDesc()));
        }
        return new GLRptTempTableInfo(GLTempTableUtil.createTempTable(this.getContex(), "KSQL_SEQ INT IDENTITY (1, 1), SQL_BATCH INT," + this.getTempTableStruct().getDataTableDesc()));
    }

    @Override
    protected boolean isBalanceDirSamAsAccount(GLRptRowSet rs) throws EASBizException, BOSException {
        if (this.cond.isGroupByAsst()) {
            return false;
        }
        return super.isBalanceDirSamAsAccount(rs);
    }

    protected GLRptVoucherAssistQuery getRptVoucherAssistQuery(Context ctx, GLRptAsstactBaseCondition cond, boolean isOnlyQty) {
        return new GLRptVoucherAssistQuery(ctx, cond, isOnlyQty){

            @Override
            protected String composeSQL(String select, String fromSql, String whereSql, String gropyBySql, String orderSql) throws BOSException, EASBizException {
                String hint = this.getHint();
                if (SQLUtil.isOracle(this.getCtx()) && whereSql != null) {
                    if (whereSql.contains("assistRecords.FAssGrpId IN ('")) {
                        fromSql = fromSql.replace("LEFT OUTER JOIN T_GL_VoucherAssistRecord", "INNER JOIN T_GL_VoucherAssistRecord");
                    }
                    fromSql = fromSql.replace("LEFT OUTER JOIN T_BD_Period", "INNER JOIN T_BD_Period");
                }
                StringBuffer sql = new StringBuffer("SELECT ");
                if (this.isDistinct()) {
                    sql.append(" distinct ");
                }
                sql.append(select.trim().substring(6));
                sql.append(" ").append(fromSql);
                sql.append(" ").append(whereSql);
                if (gropyBySql != null) {
                    sql.append(" ").append(gropyBySql);
                }
                if (orderSql != null) {
                    sql.append(" ").append(orderSql);
                }
                try {
                    if (this.isOptimize()) {
                        String rsSql = KSqlUtil.optimize((String)sql.toString());
                        if (this.isUseHint()) {
                            return "SELECT " + hint + " " + rsSql.substring(6);
                        }
                        return rsSql;
                    }
                    return sql.toString();
                }
                catch (SqlTranslateException e) {
                    throw new BOSException("Sql optimize error!", (Throwable)e);
                }
            }

            @Override
            protected void setPeriodFilter(StringBuffer filter, boolean isFromBeginPeriod) throws BOSException, EASBizException {
                super.setPeriodFilter(filter, isFromBeginPeriod);
                if (this.getCtx().get((Object)"isPca") == null) {
                    this.addFilterItem(filter, "assistRecords." + GLRptVoucherField.periodID + " in " + this.getCond().getPeriodIdStr(isFromBeginPeriod));
                }
            }

            @Override
            protected void setCompanyFilter(StringBuffer filter) throws BOSException {
                super.setCompanyFilter(filter);
                if (this.getCtx().get((Object)"isPca") == null) {
                    this.addFilterItem(filter, "assistRecords." + this.getOrgUnitField() + " in " + this.getCond().getCompanyIdsStr());
                }
            }
        };
    }

    protected GLRptAsstactBeginPeriodBalQuery getRptAsstactBeginPeriodBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMu, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAsstactBeginPeriodBalQuery(ctx, company, cond, isMu, isCreateDataTempTable);
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAsstactGDPageQuery(this.getContex(), this.cond, this.isShowAsstItem);
    }

    protected void addOrgUnitSorter(GLRptSQLOrder order) {
        order.add(GLRptVoucherField.companyID.getSelect());
    }

    protected void initSelectorOrgUnit(GLRptSelector selector) {
        selector.add(GLRptVoucherField.companyID);
    }

    protected GLRptField getOrgUnitIDField() {
        return GLRptVoucherField.companyID;
    }

    protected GLRptField getOrgUnitNameField() {
        return GLRptVoucherField.companyName;
    }

    protected void insertDailySum() throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuffer select = new StringBuffer();
        StringBuffer group = new StringBuffer();
        fields.add(GLRptVoucherField.bookDate.getName());
        fields.add(GLRptVoucherField.period.getName());
        fields.add("FBalSeq");
        select.append(" select ").append(GLRptVoucherField.bookDate.getName()).append(",").append(GLRptVoucherField.period.getName());
        select.append(", ").append(3).append(" ").append("FBalSeq");
        group.append(" group by ").append(GLRptVoucherField.bookDate.getName()).append(",").append(GLRptVoucherField.period.getName());
        if (!this.cond.isGroupByAsst()) {
            fields.add(GLRptVoucherField.accountID.getName());
            select.append(",").append(GLRptVoucherField.accountID.getName());
            group.append(",").append(GLRptVoucherField.accountID.getName());
        }
        if (this.cond.isShowQty() && this.cond.isGroupByMU()) {
            fields.add(GLRptVoucherField.asstMeasureUnitID.getName());
            select.append(",").append(GLRptVoucherField.entryMeasureUnitID.getName());
            group.append(",").append(GLRptVoucherField.asstMeasureUnitID.getName());
        }
        if (this.cond.isAllCurrency()) {
            fields.add(GLRptVoucherField.currencyID.getName());
            select.append(",").append(GLRptVoucherField.currencyID.getName());
            group.append(",").append(GLRptVoucherField.currencyID.getName());
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null || "NUMERIC(29,10)" != field.getType()) continue;
            select.append(",sum(").append(field.getName()).append(") ").append(field.getName());
            fields.add(field.getName());
        }
        Iterator<GLRptField> keyIt = this.getAsstItemSelector().getTempTableFields().iterator();
        while (keyIt.hasNext()) {
            String asstField = keyIt.next().getName();
            select.append(",").append(asstField);
            fields.add(asstField);
            group.append(",").append(asstField);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(select);
        sql.append(" FROM ").append(this.getDataSourceTableName());
        sql.append(" WHERE ").append("FBalSeq").append(" = ").append(2);
        sql.append(group);
        this.insertData(fields.toArray(new String[fields.size()]), sql.toString());
    }

    @Override
    protected void doRowSet(GLRptRowSet rs, GLRptRowSet preRs, String endSuf, String sufifx) throws BOSException, EASBizException {
        super.doRowSet(rs, preRs, endSuf, sufifx);
        if (this.cond.isShowDailyTotal()) {
            this.setDayTotal(rs, preRs, sufifx);
        }
    }

    private void setDayTotal(GLRptRowSet rs, GLRptRowSet preRs, String sufifx) throws BOSException, EASBizException {
        int rowType = rs.getInt("FBalSeq");
        if (rowType == 1 || rowType == 4 || rowType == 5) {
            return;
        }
        BigDecimal debit = GlUtils.zero;
        BigDecimal credit = GlUtils.zero;
        if (rs.getInt("FBalSeq") == 2) {
            debit = this.getDebit(rs, sufifx);
            credit = this.getCredit(rs, sufifx);
        }
        if ("Qty".equals(sufifx)) {
            debit = debit.divide(this.getAsstQtyCoefficient(rs), this.cond.getQtyScale(), 4);
            credit = credit.divide(this.getAsstQtyCoefficient(rs), this.cond.getQtyScale(), 4);
            String accountId = rs.getString(GLRptField.accountID.getName());
            debit = debit.divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4);
            credit = credit.divide(this.getAccountQtyCoefficient(accountId), this.cond.getQtyScale(), 4);
        }
        BigDecimal lastDayDebit = preRs.getBigDecimal("FDayDebit" + sufifx);
        BigDecimal lastDayCredit = preRs.getBigDecimal("FDayCredit" + sufifx);
        rs.updateBigDecimal("FDayDebit" + sufifx, this.add(lastDayDebit, debit));
        rs.updateBigDecimal("FDayCredit" + sufifx, this.add(lastDayCredit, credit));
        if (3 == rowType) {
            rs.updateBigDecimal("FSubDebit" + sufifx, rs.getBigDecimal("FDayDebit" + sufifx));
            rs.updateBigDecimal("FSubCredit" + sufifx, rs.getBigDecimal("FDayCredit" + sufifx));
            rs.updateBigDecimal("FDayDebit" + sufifx, null);
            rs.updateBigDecimal("FDayCredit" + sufifx, null);
        }
    }

    @Override
    protected String getTempTableDefineFunction() {
        return "GLRptAsstactBalGDDao";
    }

    @Override
    protected BigDecimal getAsstQtyCoefficient(GLRptRowSet rs) throws BOSException, EASBizException {
        if (this.cond.getRptParams().isQtyAsst() && !this.cond.isGroupByMU() && this.cond.getMeasureUnitId() == null) {
            BigDecimal accountingCoefficient = null;
            if (this.accountingAsstActType == null) {
                for (int i = 0; i < this.cond.getAsstActList().size(); ++i) {
                    AsstactTypeEntity asstactTypeEntity = (AsstactTypeEntity)this.cond.getAsstActList().get(i);
                    if (!asstactTypeEntity.isQtyAsst()) continue;
                    IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
                    this.accountingAsstActType = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstactTypeEntity.getId()));
                    break;
                }
            }
            if (this.accountingAsstActType == null) {
                accountingCoefficient = super.getAsstQtyCoefficient(rs);
            } else {
                String asstActId = null;
                if (this.cond.getSelectedItem() != null && this.cond.getSelectedItem().size() == 1) {
                    GLRptRowSet selectedItem = this.cond.getSelectedItem();
                    asstActId = selectedItem.getString(0, this.accountingAsstActType.getMappingFieldName());
                } else {
                    asstActId = rs.indexOf(this.accountingAsstActType.getMappingFieldName()) < 0 ? null : rs.getString(this.accountingAsstActType.getMappingFieldName());
                }
                accountingCoefficient = this.loadedAsstActIDToQtyCoefficient.get(asstActId);
                if (accountingCoefficient != null) {
                    return accountingCoefficient;
                }
                if (asstActId == null) {
                    accountingCoefficient = super.getAsstQtyCoefficient(rs);
                } else if (this.accountingAsstActType.getGlAsstActTypeGrp() != null) {
                    GeneralAsstActTypeInfo accountingAsstAct = GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getGeneralAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActId));
                    accountingCoefficient = accountingAsstAct != null ? (accountingAsstAct.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(accountingAsstAct.getMeasureUnit().getId().toString())).getCoefficient() : (accountingAsstAct.getMeasureUnitGroup() != null ? super.getAsstQtyCoefficient(rs) : (this.accountingAsstActType.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountingAsstActType.getMeasureUnit().getId().toString())).getCoefficient() : (this.accountingAsstActType.getMeasureUnitGroup() != null ? super.getAsstQtyCoefficient(rs) : super.getAsstQtyCoefficient(rs))))) : super.getAsstQtyCoefficient(rs);
                } else if ("material".equals(this.accountingAsstActType.getAsstHGAttribute())) {
                    MaterialInfo mateial = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(asstActId));
                    if (mateial != null) {
                        if (mateial.getBaseUnit() != null) {
                            String measureunitId = mateial.getBaseUnit().getId().toString();
                            EntityViewInfo view = new EntityViewInfo();
                            view.getSelector().add(new SelectorItemInfo("id"));
                            view.getSelector().add(new SelectorItemInfo("name"));
                            view.getSelector().add(new SelectorItemInfo("number"));
                            view.getSelector().add(new SelectorItemInfo("coefficient"));
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("id", (Object)measureunitId));
                            view.setFilter(filter);
                            accountingCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitCollection(view).get(0).getCoefficient();
                        } else {
                            accountingCoefficient = this.accountingAsstActType.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountingAsstActType.getMeasureUnit().getId().toString())).getCoefficient() : (this.accountingAsstActType.getMeasureUnitGroup() != null ? super.getAsstQtyCoefficient(rs) : super.getAsstQtyCoefficient(rs));
                        }
                    } else {
                        accountingCoefficient = super.getAsstQtyCoefficient(rs);
                    }
                } else {
                    accountingCoefficient = this.accountingAsstActType.getMeasureUnit() != null ? MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.accountingAsstActType.getMeasureUnit().getId().toString())).getCoefficient() : (this.accountingAsstActType.getMeasureUnitGroup() != null ? super.getAsstQtyCoefficient(rs) : super.getAsstQtyCoefficient(rs));
                }
                this.loadedAsstActIDToQtyCoefficient.put(asstActId, accountingCoefficient);
            }
            return accountingCoefficient;
        }
        return super.getAsstQtyCoefficient(rs);
    }

    @Override
    protected BigDecimal getAccountQtyCoefficient(String accountId) throws BOSException, EASBizException {
        if (accountId != null && !this.cond.getRptParams().isQtyAsst() && !this.cond.isGroupByMU() && this.cond.getMeasureUnitId() == null) {
            MeasureUnitInfo measureUnitID;
            BigDecimal accountQtyCoefficient = super.getAccountQtyCoefficient(accountId);
            AccountViewInfo accountViewInfo = null;
            if (this.loadedAccountIDToQtyCoefficient.containsKey(accountId)) {
                accountQtyCoefficient = this.loadedAccountIDToQtyCoefficient.get(accountId);
            } else {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            }
            if (accountViewInfo != null && (measureUnitID = accountViewInfo.getMeasureUnitID()) != null) {
                accountQtyCoefficient = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID.getId().toString())).getCoefficient();
            }
            this.loadedAccountIDToQtyCoefficient.put(accountId, accountQtyCoefficient);
            return accountQtyCoefficient;
        }
        return super.getAccountQtyCoefficient(accountId);
    }

    private class AmountFilter
    implements GLRptFilter {
        private AmountFilter() {
        }

        @Override
        public String getSQL() throws EASBizException, BOSException {
            if (GLRptAsstactBalGDDao.this.cond.isGroupByAsst() && !GLRptAsstactBalGDDao.this.isAllCurrency() && !GLRptAsstactBalGDDao.this.cond.isGroupByMU()) {
                return null;
            }
            if (GLRptAsstactBalGDDao.this.cond.isOptionAmountZero()) {
                return this.getVoucherFilter();
            }
            if (GLRptAsstactBalGDDao.this.cond.isOptionAmountAndBalZero()) {
                StringBuffer sql = new StringBuffer();
                if (this.getVoucherFilter() != null) {
                    sql.append("(").append(this.getVoucherFilter()).append(" or ").append(this.getBalFilter()).append(")");
                } else {
                    sql.append("(").append(this.getBalFilter()).append(")");
                }
                return sql.toString();
            }
            return null;
        }

        private String getVoucherFilter() {
            StringBuffer sql = new StringBuffer();
            sql.append(" exists (select 1 from ").append(GLRptAsstactBalGDDao.this.getDataSourceTableName()).append(" t where ");
            boolean exist = false;
            if (!GLRptAsstactBalGDDao.this.cond.isGroupByAsst()) {
                sql.append(" t.FAccountId = t1.FAccountID ");
                exist = true;
            }
            if (GLRptAsstactBalGDDao.this.isShowAsstItem) {
                if (exist) {
                    sql.append(" and ");
                } else {
                    exist = true;
                }
                Iterator it = GLRptAsstactBalGDDao.this.cond.getAsstActList().iterator();
                int index = 0;
                while (it.hasNext()) {
                    AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                    if (index++ > 0) {
                        sql.append(" and ");
                    }
                    sql.append(" t.").append(at.getHgField()).append(" = t1.").append(at.getHgField());
                }
            }
            if (GLRptAsstactBalGDDao.this.cond.isGroupByMU()) {
                if (exist) {
                    sql.append(" and ");
                } else {
                    exist = true;
                }
                sql.append(" t.FMeasureUnitID = t1.FMeasureUnitID ");
            }
            if (GLRptAsstactBalGDDao.this.isAllCurrency()) {
                if (exist) {
                    sql.append(" and ");
                }
                sql.append(" t.FCurrencyId = t1.FCurrencyId ");
            }
            sql.append(")");
            return sql.toString();
        }

        private String getBalFilter() throws EASBizException, BOSException {
            StringBuffer sql = new StringBuffer();
            sql.append(" (");
            if (GLRptAsstactBalGDDao.this.isShowFor()) {
                sql.append(" t1.").append(GLRptField.beginBalanceFor).append("<>0");
            }
            if (GLRptAsstactBalGDDao.this.isShowLocal()) {
                if (GLRptAsstactBalGDDao.this.isShowFor()) {
                    sql.append(" or ");
                }
                sql.append(" t1.").append(GLRptField.beginBalanceLocal).append("<>0");
            }
            if (GLRptAsstactBalGDDao.this.isShowRpt()) {
                if (GLRptAsstactBalGDDao.this.isShowFor() || GLRptAsstactBalGDDao.this.isShowLocal()) {
                    sql.append(" or ");
                }
                sql.append(" t1.").append(GLRptField.beginBalanceRpt).append("<>0");
            }
            sql.append(")");
            return sql.toString();
        }
    }
}

