/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAssistBalanceTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAssistMeasureBalanceTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTableJoin;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptAsstactBalQuery
extends GLRptAccountBalQuery {
    private static final Logger logger = Logger.getLogger(GLRptAsstactBalQuery.class);
    private GLRptAsstAccountFilter asstAccFilter;
    private List asstActList;
    private boolean isGroupByPAccount = false;
    private boolean isBizCode = false;
    private String bizCodeFromNumber = null;
    private String bizCodeToNumber = null;

    public GLRptAsstactBalQuery(Context ctx, OrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws BOSException, EASBizException {
        super(ctx, company, cond, isMeasureUnit, isCreateDataTempTable);
        this.asstActList = cond.getAsstActList();
        this.setMainTable(isMeasureUnit ? new GLRptAssistMeasureBalanceTable(this.getCond()) : new GLRptAssistBalanceTable(this.getCond()));
        if (cond.isOptionAmountAndBalZero() && cond.getCtx().get((Object)"isFromBeginPeriod") != null) {
            this.setFromBeginPeriod(Boolean.valueOf(cond.getCtx().get((Object)"isFromBeginPeriod").toString()));
        }
    }

    @Override
    protected GLRptField getDebitQtyField() {
        return this.isMeasureUnit() ? GLRptVoucherField.asstRecordDebitQty : GLRptVoucherField.asstRecordStandDebitQty;
    }

    @Override
    protected GLRptField getCreditQtyField() {
        return this.isMeasureUnit() ? GLRptVoucherField.asstRecordCreditQty : GLRptVoucherField.asstRecordStandCreditQty;
    }

    @Override
    protected void addVoucherAmountField(GLRptSelector sel) throws EASBizException, BOSException {
        GLRptAsstactBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            sel.add(GLRptVoucherField.asstRecordDebitFor);
            sel.add(GLRptVoucherField.asstRecordCreditFor);
        }
        if (cond.isShowLocal()) {
            sel.add(GLRptVoucherField.asstRecordDebitLocal);
            sel.add(GLRptVoucherField.asstRecordCreditLocal);
        }
        if (cond.isShowRpt()) {
            sel.add(GLRptVoucherField.asstRecordDebitRpt);
            sel.add(GLRptVoucherField.asstRecordCreditRpt);
        }
    }

    public boolean isFullHGFromTo() {
        for (AsstactTypeEntity at : this.asstActList) {
            if (at.getFrom() != null && at.getTo() != null) continue;
            return false;
        }
        return true;
    }

    public GLRptAsstAccountFilter getGLRptAsstAccountFilter() throws EASBizException, BOSException {
        if (this.asstAccFilter == null) {
            this.asstAccFilter = new GLRptAsstAccountFilter(this.getCtx(), this.getCond(), this.getSelector(), this.getMainTable().getAlias() + "." + GLRptField.HG.getName(), this.getMainTable().getAlias() + "." + GLRptField.orgUnitID.getName());
        }
        return this.asstAccFilter;
    }

    @Override
    public GLRptAsstactBaseCondition getCond() {
        return (GLRptAsstactBaseCondition)super.getCond();
    }

    public void setGLRptAsstAccountFilter(GLRptAsstAccountFilter asstAccFilter) {
        this.asstAccFilter = asstAccFilter;
    }

    @Override
    protected GLRptTableJoin initJoinTable() throws EASBizException, BOSException {
        GLRptTableJoin join = super.initJoinTable();
        if (!this.isBizCode) {
            join.add(GLRptDataTable.HG, this.getMainTable().getAlias() + "." + GLRptField.HG);
            Iterator it = this.asstActList.iterator();
            boolean isShowMeasure = false;
            while (it.hasNext()) {
                AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                if ("material".equals(at.getHgAttribute()) || at.isGeneralActType()) {
                    isShowMeasure = true;
                }
                if (this.getCond().isFilterByCat() && !at.isBasicCat()) {
                    String groupDetTable = GLRptDaoUtil.getGroupDetailTable(at);
                    String field = GLRptDaoUtil.getField(at);
                    join.add(new GLRptDataTable(groupDetTable, at.getHgAttribute() + "GDet"), field, GLRptDataTable.HG.getAlias() + "." + at.getHgField(), false);
                    continue;
                }
                join.add(new GLRptDataTable(at.getTableName(), at.getHgAttribute()), GLRptDataTable.HG.getAlias() + "." + at.getHgField(), false);
            }
        }
        return join;
    }

    protected boolean isJoinAccount() throws BOSException {
        return true;
    }

    @Override
    protected GLRptSelector getGLRptBalSelector() throws EASBizException, BOSException {
        GLRptSelector sel = new GLRptSelector();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (f.getSelect() == null) continue;
            sel.add(f);
        }
        if (this.getAmountFilter() != null && (this.getCond().isOptionAmountZero() || this.getCond().isOptionBalanceZero() || this.getCond().isOptionAmountAndBalZero())) {
            this.addBalAmountField(sel);
        }
        return sel;
    }

    private void addBalAmountField(GLRptSelector sel) throws EASBizException, BOSException {
        GLRptAsstactBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            if (cond.isOptionAmountZero() || cond.isOptionAmountAndBalZero()) {
                sel.add(GLRptField.debitFor);
                sel.add(GLRptField.creditFor);
            }
            if (cond.isOptionAmountAndBalZero() || cond.isOptionBalanceZero()) {
                sel.add(GLRptField.endBalanceFor);
            }
        }
        if (cond.isShowLocal()) {
            if (cond.isOptionAmountZero() || cond.isOptionAmountAndBalZero()) {
                sel.add(GLRptField.debitLocal);
                sel.add(GLRptField.creditLocal);
            }
            if (cond.isOptionAmountAndBalZero() || cond.isOptionBalanceZero()) {
                sel.add(GLRptField.endBalanceLocal);
            }
        }
        if (cond.isShowRpt()) {
            if (cond.isOptionAmountZero() || cond.isOptionAmountAndBalZero()) {
                sel.add(GLRptField.debitRpt);
                sel.add(GLRptField.creditRpt);
            }
            if (cond.isOptionAmountAndBalZero() || cond.isOptionBalanceZero()) {
                sel.add(GLRptField.endBalanceRpt);
            }
        }
        if (cond.isOptionAmountAndBalZero() && cond.isAmountZeroByVoucher()) {
            sel.add(new GLRptField("fdetailcount", "b.fdetailcount", "detailcount", "INT"));
        }
    }

    @Override
    protected GLRptSelector getGLRptVoucherSelector() throws EASBizException, BOSException {
        GLRptSelector sel = new GLRptSelector();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (f.isQty()) {
                GLRptField field;
                if (f.isDebit()) {
                    field = this.getDebitQtyField();
                    sel.add(new GLRptField("FSubDebitQty", field.getSelect(), field.getQueryField(), field.getType()));
                    continue;
                }
                if (!f.isCredit()) continue;
                field = this.getCreditQtyField();
                sel.add(new GLRptField("FSubCreditQty", field.getSelect(), field.getQueryField(), field.getType()));
                continue;
            }
            if (fm.get(f) != null) {
                sel.add((GLRptField)fm.get(f));
                continue;
            }
            if (!f.isTempTableField() || !f.getSelect().startsWith("hg.F") && !f.getSelect().startsWith("hg.CF") && !f.getName().endsWith("GroupID")) continue;
            String select = f.getSelect().startsWith("hg.F") || f.getSelect().startsWith("hg.CF") ? f.getSelect().replaceFirst("hg", "assGrp") : f.getSelect();
            f = new GLRptField(f.getName(), select, f.getQueryField(), f.getType());
            sel.add(f);
        }
        if (this.getAmountFilter() != null && (this.getCond().isOptionAmountZero() || this.getCond().isOptionBalanceZero() || this.getCond().isOptionAmountAndBalZero())) {
            this.addVoucherAmountField(sel);
        }
        return sel;
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        GLRptAsstactBaseCondition condition = this.getCond();
        String joinSql = super.getJoinSQL();
        if (this.isBizCode) {
            joinSql = joinSql + " \r\n inner join " + this.queryBizCodeHgid(this.getCtx(), this.bizCodeFromNumber, this.bizCodeToNumber) + " on hg.fid =" + this.getMainTable().getAlias() + "." + GLRptField.HG;
        }
        if ((condition.getAsstActList() == null || condition.getAsstActList().isEmpty()) && condition.getRptParams().useAccountPermission() && condition instanceof GLRptSubLedgerCondition && ((GLRptSubLedgerCondition)condition).isShowDisplayAsstDetail()) {
            joinSql = joinSql + "\n inner join t_bd_assistantHg permHg on permHg.fid = " + this.getMainTable().getAlias() + "." + GLRptField.HG;
        }
        return joinSql;
    }

    private StringBuffer queryBizCodeHgid(Context ctx, String bizCodeFromNumber, String bizCodeToNumber) throws BOSException {
        StringBuffer queryBizCodeHgid = new StringBuffer();
        String loc = this.getCtx().getLocale().toString();
        queryBizCodeHgid.append("(select distinct * from (select hg.fid fid,bac.fid fbacid ,bac.fnumber fbacnumber ,bac.fname_").append(loc).append(" fbacname from t_bd_assistanthg hg inner join t_bd_customer cst on hg.fcustomerid = cst.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = cst.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("' ");
        }
        queryBizCodeHgid.append("\r\n union all ");
        queryBizCodeHgid.append("select hg1.fid fid,bac.fid fbacid,bac.fnumber fbacnumber ,bac.fname_").append(loc).append(" fbacname  from t_bd_assistanthg hg1 inner join T_BD_Supplier sup on hg1.FProviderID = sup.fid inner join T_BD_BizAnaylysisCode bac on bac.fid = sup.FBizAnalysisCodeID ");
        if (bizCodeFromNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber >='").append(bizCodeFromNumber).append("' ");
        }
        if (bizCodeToNumber != null) {
            queryBizCodeHgid.append("and bac.fnumber <='").append(bizCodeToNumber).append("' ");
        }
        queryBizCodeHgid.append("\r\n) T_Hgid0) hg ");
        return queryBizCodeHgid;
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        GLRptAsstactBaseCondition cond;
        StringBuffer sql = new StringBuffer();
        sql.append(super.getWhereSQL());
        this.setMeasureUnitFilter(sql);
        GLRptAsstAccountFilter filter = this.getGLRptAsstAccountFilter();
        String asstfilter = filter.getSQL();
        if (asstfilter != null && asstfilter.length() > 0) {
            sql.append(" and ").append(asstfilter);
        }
        if ((cond = this.getCond()).isNotIncluePLVoucher() && cond.isShowQty() && cond instanceof GLRptAsstActTypeBalanceCondition) {
            String allFieldZeroSql = "";
            if (cond.isShowFor()) {
                allFieldZeroSql = " and (b.FBEGINBALANCEFOR <> 0 or b.FBEGINQTY  <> 0 or b.FCREDITQTY <> 0 or b.FCREDITFOR <> 0 or b.FDEBITQTY <> 0 or b.FDEBITFOR <> 0 or b.FENDQTY <> 0 or b.FENDBALANCEFOR <> 0) ";
            }
            if (cond.isShowLocal()) {
                allFieldZeroSql = " and (b.FBEGINBALANCELocal <> 0 or b.FBEGINQTY  <> 0 or b.FCREDITQTY <> 0 or b.FCREDITLocal <> 0 or b.FDEBITQTY <> 0 or b.FDEBITLocal <> 0 or b.FENDQTY <> 0 or b.FENDBALANCELocal <> 0) ";
            }
            if (cond.isShowRpt()) {
                allFieldZeroSql = " and (b.FBEGINBALANCERpt <> 0 or b.FBEGINQTY  <> 0 or b.FCREDITQTY <> 0 or b.FCREDITRpt <> 0 or b.FDEBITQTY <> 0 or b.FDEBITRpt <> 0 or b.FENDQTY <> 0 or b.FENDBALANCERpt <> 0) ";
            }
            sql.append(allFieldZeroSql);
        }
        if ((cond.getAsstActList() == null || cond.getAsstActList().isEmpty()) && cond.getRptParams().useAccountPermission() && cond instanceof GLRptSubLedgerCondition && ((GLRptSubLedgerCondition)cond).isShowDisplayAsstDetail()) {
            this.setAsstDataPermissionFilter(sql);
        }
        return sql.toString();
    }

    @Override
    protected String getAccountFilterSQL() throws EASBizException, BOSException {
        String sql = super.getAccountFilterSQL();
        GLRptAsstactBaseCondition cond = this.getCond();
        if (!cond.isShowLeafAccount()) {
            if (!StringUtils.isEmpty((String)sql)) {
                sql = sql + " and ";
            }
            sql = sql + "(" + GLRptDataTable.ACCOUNT.getAlias() + ".flevel >= " + cond.getAccountLevelStart() + " or " + GLRptDataTable.ACCOUNT.getAlias() + ".fid is null)";
        }
        return sql;
    }

    protected Set getAsstAccountIdSet() throws BOSException {
        return this.getCond().getAsstAccountIdSet();
    }

    protected void setMeasureUnitFilter(StringBuffer sql) {
        GLRptAsstactBaseCondition cond = this.getCond();
        if (cond.getMeasureUnitId() != null) {
            sql.append(" and ").append(this.getMainTable().getAlias()).append(".").append(GLRptField.measureUnitID).append(" = '").append(cond.getMeasureUnitId()).append("'");
        }
    }

    @Override
    protected boolean isGroupBy() throws BOSException, EASBizException {
        if (super.isGroupBy() || this.getCond().isAfterCurrPeriod()) {
            return true;
        }
        if (!this.getGLRptAsstAccountFilter().isMulHG()) {
            return false;
        }
        return this.getCond().isMulAsstAccount();
    }

    protected void distinctKeys(Set keySet) throws EASBizException, BOSException {
        super.distinctKeys(keySet);
        this.getGLRptAsstAccountFilter().setBizCode(this.isBizCode);
        if (!this.getGLRptAsstAccountFilter().isMulHG()) {
            keySet.remove(GLRptField.HG);
        }
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)" || "fdetailcount".equalsIgnoreCase(field.getName())) {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            this.appendSelectField(sql, field);
        }
        return sql.toString();
    }

    @Override
    protected boolean isGroupByPAccount() {
        return super.isGroupByPAccount() || this.isGroupByPAccount;
    }

    public void setGroupByPAccount(boolean isGroupByPAccount) {
        this.isGroupByPAccount = isGroupByPAccount;
    }

    public List getAsstActList() {
        return this.asstActList;
    }

    public void setAsstActList(List asstActList) {
        this.asstActList = asstActList;
    }

    public void setIsBizCode(boolean isBizCode) {
        this.isBizCode = isBizCode;
    }

    public void setBizCodeFromNumber(String bizCodeFromNumber) {
        this.bizCodeFromNumber = bizCodeFromNumber;
    }

    public void setBizCodeToNumber(String bizCodeToNumber) {
        this.bizCodeToNumber = bizCodeToNumber;
    }

    @Override
    protected String getAmountSelectSQL(GLRptField field) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String ta = this.getMainTable().getAlias();
        if (this.isGroupBy()) {
            if (this.isGroupByPeriod()) {
                sql.append("sum(").append(ta).append(".").append(field).append(") ").append(field);
            } else if (this.getCond().getCompanyDisplayMode() != CompanyDisplayModeEnum.enumerate) {
                sql.append(this.getAmountSelectSQLForMultiCompany(field));
            } else {
                sql.append(this.getAmountSelectSQLForEnumerate(field));
            }
        } else {
            sql.append(ta).append(".").append(field).append(" ").append(field);
        }
        return sql.toString();
    }

    private String getAmountSelectSQLForEnumerate(GLRptField field) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String ta = this.getMainTable().getAlias();
        int beginPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
        int endPeriod = this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd();
        int currPeriod = this.getCond().getCurrPeriod().getNumber();
        int endPeriodYear = this.getCond().getPeriodYearEnd();
        boolean isAfterPeriodIncluded = beginPeriod > currPeriod;
        boolean isAfterPeriodIncluded2 = this.getCond().isAfterCurrPeriod();
        String periodField = " b.FPeriod ";
        if (field.isBegin() || this.isPeriodBeginBalance()) {
            if (isAfterPeriodIncluded) {
                sql.append("sum(case when ");
                sql.append(periodField).append(" = ").append(currPeriod).append(" then b.").append("FEnd").append(field.getBalSuffix());
                sql.append(" when ").append(periodField).append(" > ").append(currPeriod).append(" and ").append(periodField).append(" < ").append(beginPeriod).append(" then (").append(ta).append(".").append("FDebit").append(field.getSuffix());
                sql.append(" - ").append(ta).append(".").append("FCredit").append(field.getSuffix());
                sql.append(") else 0 end) ").append("FBegin").append(field.getBalSuffix()).append(" \r\n");
            } else {
                sql.append("sum(case when ");
                sql.append(periodField).append(" = ").append(beginPeriod).append(" then ").append(ta).append(".").append(field).append(" else 0 end) ").append(field);
            }
        } else if (field.isEnd()) {
            if (this.getCond().getCurrPeriod().getNumber() < endPeriod) {
                sql.append("sum(case when ").append(periodField).append(" = ").append(currPeriod).append(" then ").append(ta).append(".").append(field);
                sql.append(" when ").append(periodField).append(">").append(currPeriod).append(" and ").append(periodField).append(" <=").append(endPeriod).append(" then (").append(ta).append(".fdebit").append(field.getSuffix()).append("-").append(ta).append(".fcredit").append(field.getSuffix()).append(") else 0 end) ").append(field);
            } else {
                sql.append("sum(case when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" else 0 end) ").append(field);
            }
        } else if (field.isYearDebit()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded2) {
                sql.append(" when ").append(endPeriod).append(" > ").append(currPeriod).append(" and ").append(periodField).append(" = ").append(currPeriod).append(" and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ").append(currPeriod).append(" and ").append(periodField).append(" > ").append(currPeriod).append(" and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append("  then ").append(ta).append(".").append("FDebit").append(field.getSuffix()).append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else if (field.isYearCredit()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded2) {
                sql.append(" when ").append(endPeriod).append(" > ").append(currPeriod).append(" and ").append(periodField).append(" = ").append(currPeriod).append(" and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ").append(currPeriod).append(" and ").append(periodField).append(" > ").append(currPeriod).append(" and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append("  then ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(" \r\n").append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else {
            sql.append("sum(").append(" CASE WHEN ").append(periodField).append(" >= ").append(beginPeriod).append(" THEN ").append(ta).append(".").append(field).append(" ELSE 0 END) ").append(field);
        }
        return sql.toString();
    }

    private String getAmountSelectSQLForMultiCompany(GLRptField field) throws EASBizException, BOSException {
        Integer startPeriod = new Integer(this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart());
        Integer endPeriod = new Integer(this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd());
        Integer endPeriodYear = new Integer(this.getCond().getPeriodYearEnd());
        boolean isAfterPeriodIncluded = this.getCond().isAfterCurrPeriod();
        String ta = this.getMainTable().getAlias();
        String periodField = " b.FPeriod ";
        StringBuffer sql = new StringBuffer();
        if (field.isBegin()) {
            sql.append(" sum(case ");
            sql.append(" when ").append(startPeriod).append(" < ssc.fstartperiod and ").append(periodField).append(" = ssc.fstartperiod then ").append(ta).append(".").append(field).append(" \r\n");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(startPeriod).append(" >= ssc.fstartperiod and ").append(startPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(startPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(startPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod then ").append(ta).append(".").append("FEnd").append(field.getBalSuffix()).append(" \r\n");
                sql.append(" when ").append(startPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" > ssc.fcurrperiod and ").append(periodField).append(" < ").append(startPeriod).append(" then (").append(ta).append(".").append("FDebit").append(field.getSuffix());
                sql.append(" - ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(") \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(startPeriod).append(" and ").append(periodField).append(" >= ssc.fstartperiod then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append("FBegin").append(field.getBalSuffix());
        } else if (field.isYearDebit()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartperiod and ").append(endPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append("> ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append("  then ").append(ta).append(".").append("FDebit").append(field.getSuffix()).append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else if (field.isYearCredit()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartperiod and ").append(endPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" > ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append("  then ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(" \r\n").append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else if (field.isEnd()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartperiod and ").append(endPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod  then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" > ssc.fcurrperiod then ").append(ta).append(".").append("FDebit").append(field.getSuffix()).append(" - ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else {
            sql.append(" sum(case when ").append(periodField).append(" >=").append(startPeriod).append(" and ").append(periodField).append(" <= ").append(endPeriod).append(" and ").append(periodField).append(" >= ssc.fstartperiod then ").append(ta).append(".").append(field).append(" else 0 end").append(") ").append(field);
        }
        return sql.toString();
    }

    private void setAsstDataPermissionFilter(StringBuffer filter) throws EASBizException, BOSException {
        GLRptAsstactBaseCondition cond = this.getCond();
        if (!(cond != null && cond.getRptParams().useAccountPermission() && cond instanceof GLRptSubLedgerCondition && ((GLRptSubLedgerCondition)cond).isShowDisplayAsstDetail())) {
            return;
        }
        AsstAccountCollection asstAccountColl = this.getAsstAccountCollection();
        StringBuffer sql = new StringBuffer();
        boolean existPermSql = false;
        for (int m = 0; m < asstAccountColl.size(); ++m) {
            AsstAccountInfo caa = asstAccountColl.get(m);
            if (m > 0) {
                sql.append(" OR ");
            }
            sql.append("(");
            StringBuffer assgrpSql = new StringBuffer();
            this.addFilterItem(assgrpSql, "permHg.FAsstAccountID = '" + caa.getId().toString() + "'");
            sql.append(assgrpSql);
            AsstActGroupDetailCollection detailColl = caa.getAsstActGpDt();
            for (int n = 0; n < detailColl.size(); ++n) {
                AsstActTypeInfo at = detailColl.get(n).getAsstActType();
                if (at.getPermissionItem() == null) continue;
                try {
                    String permSql;
                    String strPermItem = at.getPermissionItem();
                    boolean isPermissionByCU = GLRptDaoUtil.checkIfPermissionByCU(this.getCtx(), strPermItem);
                    String companyId = cond.getCompany().getId().toString();
                    if (isPermissionByCU) {
                        companyId = cond.getCompany().getCU().getId().toString();
                    }
                    if ((permSql = GLRptDaoUtil.getDataPermissionSQL(this.getCtx(), companyId, at.getPermissionItem())) == null) continue;
                    this.addFilterItem(sql, "permHg." + at.getMappingFieldName() + " in (" + permSql + ")");
                    existPermSql = true;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Get permission sql error!", (Throwable)e);
                }
            }
            sql.append(")");
        }
        if (existPermSql) {
            if (filter.length() > 0) {
                filter.append(" AND ");
            }
            filter.append("(").append(sql).append(")");
        }
    }

    private AsstAccountCollection getAsstAccountCollection() throws BOSException, EASBizException {
        GLRptAccountFilter accountFilter;
        String accFilter;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("CAA.id"));
        view.getSelector().add(new SelectorItemInfo("CAA.name"));
        view.getSelector().add(new SelectorItemInfo("CAA.asstActGpDt.asstActType.*"));
        FilterInfo filter = new FilterInfo();
        StringBuffer accountIdSql = new StringBuffer();
        accountIdSql.append(" select av.fid from t_bd_accountview av ");
        accountIdSql.append(" inner join t_bd_accountview pav ");
        accountIdSql.append(" on av.faccounttableid = av.faccounttableid ");
        if (SQLUtil.isSupportCharIndexToLike(this.getCtx())) {
            accountIdSql.append(" and (av.flongnumber like concat(pav.flongnumber, '!%') or pav.fnumber = av.fnumber) ");
        } else {
            accountIdSql.append(" and (charindex(pav.flongnumber||'!', av.flongnumber) = 1 or pav.fnumber = av.fnumber) ");
        }
        this.getJoinOrgUnitSql(accountIdSql);
        accountIdSql.append(" where pav.fid in (").append(this.getCond().getAccountIdFilter()).append(")");
        GLRptAsstactBaseCondition cond = this.getCond();
        StringBuilder accountFilterSql = new StringBuilder();
        if (cond.getCtx().get((Object)"isPca") == null) {
            accountFilterSql.append(GLRptDataTable.ACCOUNT.getAlias()).append(".fcompanyid in ").append(cond.getCompanyIdsStr());
            accountFilterSql.append(" and ");
        }
        accountFilterSql.append(GLRptDataTable.ACCOUNT.getAlias()).append(".faccounttableid = '").append(cond.getAccountTableId()).append("'");
        if (cond.getCtx().get((Object)"isPca") == null) {
            accountFilterSql.append(" and ").append(GLRptDataTable.ACCOUNT.getAlias()).append(".fisProfitCenter <>  '1' ");
        }
        if (!StringUtils.isEmpty((String)(accFilter = (accountFilter = this.isGroupByPAccount() ? new GLRptAccountFilter(this.getCtx(), cond, "pav", "pav.fid", "pav.FCompanyId", false) : new GLRptAccountFilter(this.getCtx(), this.getCond(), "av", "av.fid", "av.FCompanyId", false, true, this.getCond().getCompanyIdsStr())).getSQL()))) {
            accountFilterSql.append(" and ").append(accFilter);
        }
        if (!cond.isShowLeafAccount()) {
            if (!StringUtils.isEmpty((String)accountFilterSql.toString())) {
                accountFilterSql.append(" and ");
            }
            accountFilterSql.append("(").append("av.flevel >= ").append(cond.getAccountLevelStart()).append(" or ").append("av.fid is null)");
        }
        accountIdSql.append(" and ").append(accountFilterSql.toString());
        accountIdSql.append(" and av.fcaa is not null ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountIdSql.toString(), CompareType.INNER));
        view.setFilter(filter);
        AccountViewCollection accountColl = AccountViewFactory.getLocalInstance((Context)this.getCtx()).getAccountViewCollection(view);
        AsstAccountCollection asstAccountColl = new AsstAccountCollection();
        for (int i = 0; i < accountColl.size(); ++i) {
            AsstAccountInfo caa = accountColl.get(i).getCAA();
            if (asstAccountColl.contains((Object)caa.getId())) continue;
            asstAccountColl.add(caa);
        }
        return asstAccountColl;
    }

    private void addFilterItem(StringBuffer filters, String filterItem) {
        if (StringUtils.isEmpty((String)filterItem)) {
            return;
        }
        if (filters.length() > 0) {
            filters.append(" AND ");
        }
        filters.append(filterItem);
    }
}

