/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherDetailPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import java.util.HashMap;
import java.util.Iterator;

public class GLRptAsstactGDPageQuery
extends GLRptVoucherDetailPageQuery {
    private GLRptAsstactGDCondition cond;
    private boolean isShowAsstItem;
    private String measureUnitId;

    public GLRptAsstactGDPageQuery(Context ctx, GLRptAsstactGDCondition cond, boolean isShowAsstItem) {
        super(ctx, cond);
        this.cond = cond;
        this.isShowAsstItem = isShowAsstItem;
    }

    @Override
    public void setCurrRow(GLRptRowSet currRowSet) throws BOSException {
        super.setCurrRow(currRowSet);
        if (this.cond.isShowQty() && (this.cond.isGroupByMU() || this.cond.getMeasureUnitId() != null)) {
            this.measureUnitId = currRowSet.getString(GLRptVoucherField.asstMeasureUnitID.getName());
        }
    }

    @Override
    protected GLRptField getSubSelect(GLRptField field) {
        GLRptField select = field;
        if (field.isQty() && !this.cond.isGroupByMU() && this.cond.getMeasureUnitId() == null) {
            if (GLRptVoucherField.asstRecordDebitQty == field) {
                select = GLRptVoucherField.asstRecordStandDebitQty;
            } else if (GLRptVoucherField.asstRecordCreditQty == field) {
                select = GLRptVoucherField.asstRecordStandCreditQty;
            }
        }
        return select;
    }

    @Override
    protected GLRptField getDebitSelect(GLRptField field) {
        GLRptField select = null;
        select = field.isQty() ? (this.cond.isGroupByMU() || this.cond.getMeasureUnitId() != null ? GLRptVoucherField.asstRecordDebitQty : GLRptVoucherField.asstRecordStandDebitQty) : ("For".equals(field.getSuffix()) ? GLRptVoucherField.asstRecordDebitFor : ("Local".equals(field.getSuffix()) ? GLRptVoucherField.asstRecordDebitLocal : GLRptVoucherField.asstRecordDebitRpt));
        return select;
    }

    @Override
    protected GLRptField getCreditSelect(GLRptField field) {
        GLRptField select = null;
        select = field.isQty() ? (this.cond.isGroupByMU() || this.cond.getMeasureUnitId() != null ? GLRptVoucherField.asstRecordCreditQty : GLRptVoucherField.asstRecordStandCreditQty) : ("For".equals(field.getSuffix()) ? GLRptVoucherField.asstRecordCreditFor : ("Local".equals(field.getSuffix()) ? GLRptVoucherField.asstRecordCreditLocal : GLRptVoucherField.asstRecordCreditRpt));
        return select;
    }

    @Override
    protected String getAmountSumSelect(GLRptField field) {
        if (field.isQty() && this.cond.isGroupByMU()) {
            return " 0.0 " + field.getName();
        }
        return super.getAmountSumSelect(field);
    }

    @Override
    protected String getDebitCreditSumSelect(GLRptField field) {
        GLRptField f = field;
        if (field == GLRptVoucherField.asstRecordDebitQty) {
            f = new GLRptField(f.getName(), GLRptVoucherField.asstRecordStandDebitQty.getSelect(), f.getType(), f.getTitle(), f.getLength(), false);
        } else if (field == GLRptVoucherField.asstRecordCreditQty) {
            f = new GLRptField(f.getName(), GLRptVoucherField.asstRecordStandCreditQty.getSelect(), f.getType(), f.getTitle(), f.getLength(), false);
        }
        return super.getDebitCreditSumSelect(f);
    }

    @Override
    protected String getJoinDataBaseSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(super.getJoinDataBaseSQL());
        sql.append(" left outer join ").append(this.getVoucherAssistRecordTable()).append(" assistRecords on assistRecords.fid = t.assistRecordID ");
        if (this.cond.isShowQty()) {
            sql.append(" left outer join t_bd_measureunit measureUnit on measureUnit.fid = ").append(this.cond.isGroupByMU() || this.cond.getMeasureUnitId() != null ? "t" : "assistRecords").append(".FMeasureUnitID");
        }
        if (this.cond.isDisplayAttribute()) {
            sql.append(" left outer join T_BD_SettlementType settlementType on assistRecords.FSettlementTypeID= settlementType.fid");
        }
        if (this.isShowAsstItem) {
            sql.append(this.getJoinAsstactSQL());
        }
        return sql.toString();
    }

    @Override
    protected String getJoinAccountSQL() {
        return " left outer join t_bd_accountview account on account.fid = " + (this.cond.isGroupByAsst() ? "entries" : "t") + ".faccountid ";
    }

    private String getJoinAsstactSQL() {
        StringBuffer sql = new StringBuffer();
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            sql.append(" left outer join ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on ").append(at.getHgAttribute()).append(".fid = t.").append(at.getHgField());
            if (!at.isUseGroup()) continue;
            String groupAlias = at.getHgAttribute() + "Group";
            if (this.cond.isFilterByCat() && !at.isBasicCat()) {
                sql.append(" inner join ").append(GLRptDaoUtil.getGroupDetailTable(at)).append(" ").append(at.getHgAttribute()).append("GDet on ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getField(at)).append(" = t.").append(at.getHgField());
                sql.append(" inner join ").append(at.getGroupTable()).append(" ").append(groupAlias).append(" on ").append(groupAlias).append(".fid = ").append(at.getHgAttribute()).append("GDet.").append(GLRptDaoUtil.getGroupField(at));
                String asstGp = "('" + at.getAsstGroup().replaceAll(",", "','") + "')";
                sql.append(" and ").append(groupAlias).append(".fid in").append(asstGp);
                continue;
            }
            sql.append(" left outer join ").append(at.getGroupTable()).append(" ").append(groupAlias).append(" on ").append(groupAlias).append(".fid = ").append(at.getHgAttribute()).append(".").append(at.getGroupField());
        }
        return sql.toString();
    }

    @Override
    protected void setInterruptQueryFilter(StringBuffer sql) {
        super.setInterruptQueryFilter(sql);
        if (this.measureUnitId != null) {
            this.addWhere(sql, " t.FMeasureUnitID = ? ");
            this.sp.add(this.measureUnitId);
        }
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getCtx().get((Object)OrgType.Company);
        HashMap<String, BOSUuid> hmParamIn = new HashMap<String, BOSUuid>();
        hmParamIn.put("GL_113", company.getId());
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.getCtx());
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean isTimeOrder = Integer.valueOf(hmAllParam.get("GL_113") == null ? "1" : hmAllParam.get("GL_113").toString()) == 0;
        GLRptSQLOrder order = new GLRptSQLOrder();
        if (this.isShowAsstItem) {
            Iterator it = this.cond.getAsstActList().iterator();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            while (it.hasNext()) {
                AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                if (at.isShowAsstGroup()) {
                    order.add(at.getHgAttribute() + "Group.flongnumber");
                }
                order.add(at.getHgAttribute() + "." + (at.isUseLongNumber() && (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP) ? "flongnumber" : "fnumber"));
                order.add(at.getHgAttribute() + ".fid");
            }
        }
        order.add("t.isTotal");
        if (this.cond.isAllCurrency()) {
            order.add("t.currencyIsTotal");
        }
        if (!this.cond.isGroupByAsst()) {
            if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
                order.add("t." + GLRptVoucherField.accountNumberMerger.getName());
                order.add("t." + GLRptVoucherField.accountNameMerger.getName());
            } else {
                order.add(GLRptVoucherField.accountNumber.getSelect());
            }
        }
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            order.add("company.flongnumber");
        }
        if (this.cond.isAllCurrency()) {
            order.add("currency.FNumber");
        }
        if (this.cond.isShowQty() && this.cond.isGroupByMU()) {
            order.add("measureUnit.fnumber");
        }
        if (this.cond.isSumPeriod() && !this.cond.isShowDailyTotal()) {
            order.add("t.FBalSeq");
            order.add("t." + GLRptVoucherField.period.getName());
        } else {
            if (this.cond.isSumPeriod() && this.cond.isShowDailyTotal()) {
                int prePeriod = this.cond.getPeriodYearStart() * 100 + this.cond.getPeriodNumberStart() - 1;
                int lastPeriod = this.cond.getPeriodYearEnd() * 100 + this.cond.getPeriodNumberEnd() + 1;
                order.add(" (case when t.FBalSeq in (4, 5) then " + lastPeriod + " when t." + "FBalSeq" + " = " + 1 + " then " + prePeriod + " else t." + GLRptVoucherField.period.getName() + " end)");
            } else {
                order.add("t." + GLRptVoucherField.period.getName());
            }
            if (this.cond.isShowDailyTotal()) {
                order.add("t." + GLRptVoucherField.bookDate.getName());
            }
            order.add("t.FBalSeq");
        }
        this.addSelfOrder(order);
        if (!this.cond.isShowDailyTotal() && !this.isIncludeOrderItem("bookedDate")) {
            order.add(GLRptVoucherField.bookDate.getSelect());
        }
        if (isTimeOrder) {
            order.add("voucher." + GLRptVoucherField.createTime.getName());
        }
        if (!this.isIncludeOrderItem("number")) {
            order.add(GLRptVoucherField.voucherNumber.getSelect());
        }
        if (!this.isIncludeOrderItem("voucherType.number")) {
            order.add(GLRptVoucherField.voucherTypeNumber.getSelect());
        }
        if (!isTimeOrder) {
            order.add("voucher." + GLRptVoucherField.createTime.getName());
        }
        order.add(GLRptVoucherField.entrySeq.getSelect());
        order.add(GLRptVoucherField.asstRecordSeq.getSelect());
        return order;
    }

    private void addSelfOrder(GLRptSQLOrder order) {
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                if ("number".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.voucherNumber.getSelect(), sorter.getSortType());
                    continue;
                }
                if ("bookedDate".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.bookDate.getSelect(), sorter.getSortType());
                    continue;
                }
                if ("voucherType.number".equalsIgnoreCase(sorter.getPropertyName())) {
                    order.add(GLRptVoucherField.voucherTypeNumber.getSelect(), sorter.getSortType());
                    continue;
                }
                if (!"assistRecords.bizDate".equalsIgnoreCase(sorter.getPropertyName()) || this.cond.isShowDailyTotal()) continue;
                order.add(GLRptVoucherField.asstRecordBizdate.getSelect(), sorter.getSortType());
            }
        }
    }

    private boolean isIncludeOrderItem(String propName) {
        EntityViewInfo view = this.cond.getSelfCond();
        if (view != null && view.getSorter() != null && !view.getSorter().isEmpty()) {
            for (SorterItemInfo sorter : view.getSorter()) {
                if (!propName.equalsIgnoreCase(sorter.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getCurrRowHGID(GLRptRowSet rs) throws BOSException {
        return this.isShowAsstItem ? rs.getString(GLRptVoucherField.HGID.getName()) : null;
    }

    @Override
    protected String getHint() {
        return super.getHint();
    }
}

