/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSysParam;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAmountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstAccountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTableJoin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class GLRptAsstactItemBalanceQuery
extends GLRptAsstactBalQuery {
    private AsstactTypeEntity at;
    private GLRptSysParam rptParam = this.getCond().getRptParams();

    public GLRptAsstactItemBalanceQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit) throws BOSException, EASBizException {
        super(ctx, (OrgUnitInfo)company, cond, isMeasureUnit, true);
    }

    @Override
    public GLRptAsstactBaseCondition getCond() {
        return super.getCond();
    }

    public void setAsstactType(AsstactTypeEntity at) throws EASBizException, BOSException {
        this.at = at;
        ArrayList<AsstactTypeEntity> asstActList = new ArrayList<AsstactTypeEntity>();
        asstActList.add(at);
        super.setAsstActList(asstActList);
        GLRptAsstactBaseCondition cond = this.getCond();
        GLRptAsstAccountFilter asstAccFilter = new GLRptAsstAccountFilter(this.getCtx(), cond, this.getSelector(), this.getMainTable().getAlias() + "." + GLRptField.HG.getName(), this.getMainTable().getAlias() + "." + GLRptField.orgUnitID.getName());
        asstAccFilter.setAsstactType(at);
        this.setGLRptAsstAccountFilter(asstAccFilter);
    }

    @Override
    protected void appendSelectField(StringBuffer sql, GLRptField field) {
        if (field == GLRptField.actTypeID) {
            sql.append("'").append(this.at.getId()).append("' ").append(field.getName());
        } else if (field == GLRptField.asstItemID) {
            sql.append("hg.").append(this.at.getHgField()).append(" ").append(field.getName());
        } else if (field == GLRptField.asstItemNumber) {
            if (this.at.isUseLongNumber() && this.rptParam.isShowLongNumberForGeneral()) {
                sql.append("replace(").append(this.at.getHgAttribute()).append(".FLongNumber, '!', '.') ");
            } else {
                sql.append(this.at.getHgAttribute()).append(".FNumber ");
            }
            sql.append(field.getName());
        } else if (field == GLRptField.asstItemName) {
            if (this.rptParam.isShowLongNameForGeneral()) {
                if (GLRptField.hasDisplaynameField(this.at, this.getCtx())) {
                    sql.append("case when ").append(this.at.getHgAttribute()).append(".FDisplayName_").append(this.getCtx().getLocale().toString()).append(" is not null then ");
                    sql.append(this.at.getHgAttribute()).append(".FDisplayName_").append(this.getCtx().getLocale().toString()).append(" ");
                    sql.append("else ").append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" end ");
                } else if ((this.at.getHgAttribute().equals("customer") || this.at.getHgAttribute().equals("material") || this.at.getHgAttribute().equals("provider")) && this.at.getGroupTable() != null && this.at.getGroupField() != null) {
                    GLRptTableJoin join = null;
                    try {
                        join = this.initJoinTable();
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    GLRptDataTable group = new GLRptDataTable(this.at.getGroupTable(), this.at.getGroupTable());
                    join.add(group, this.at.getHgAttribute() + "." + this.at.getGroupField(), false);
                    this.setJoin(join);
                    sql.append("case when ");
                    sql.append(this.at.getGroupTable()).append(".").append("FDisplayName_");
                    sql.append(this.getCtx().getLocale().toString()).append(" is not null ");
                    sql.append(" then ").append(this.at.getGroupTable()).append(".").append("FDisplayName_");
                    sql.append(this.getCtx().getLocale().toString()).append(" || '_' || ");
                    sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
                    sql.append("else ");
                    sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
                    sql.append("end ");
                } else {
                    sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
                }
            } else {
                sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
            }
            sql.append(field.getName());
        } else {
            sql.append(field.getSelect());
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale());
            }
            sql.append(" ").append(field.getName());
        }
    }

    protected boolean isInnerJoinAsstDataBaseTable(AsstactTypeEntity at) {
        return true;
    }

    @Override
    protected void appendGroupField(StringBuffer sql, GLRptField field) {
        if (field == GLRptField.asstItemID) {
            sql.append("hg.").append(this.at.getHgField());
        } else if (field == GLRptField.asstItemNumber) {
            if (this.at.isUseLongNumber() && this.rptParam.isShowLongNumberForGeneral()) {
                sql.append(this.at.getHgAttribute()).append(".FLongNumber");
            } else {
                sql.append(this.at.getHgAttribute()).append(".FNumber");
            }
        } else if (field == GLRptField.asstItemName) {
            if (this.rptParam.isShowLongNameForGeneral()) {
                if (GLRptField.hasDisplaynameField(this.at, this.getCtx())) {
                    sql.append("case when ").append(this.at.getHgAttribute()).append(".FDisplayName_").append(this.getCtx().getLocale().toString()).append(" is not null then ");
                    sql.append(this.at.getHgAttribute()).append(".FDisplayName_").append(this.getCtx().getLocale().toString()).append(" ");
                    sql.append("else ").append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" end ");
                } else if ((this.at.getHgAttribute().equals("customer") || this.at.getHgAttribute().equals("material") || this.at.getHgAttribute().equals("provider")) && this.at.getGroupTable() != null && this.at.getGroupField() != null) {
                    sql.append("case when ");
                    sql.append(this.at.getGroupTable()).append(".").append("FDisplayName_");
                    sql.append(this.getCtx().getLocale().toString()).append(" is not null ");
                    sql.append(" then ").append(this.at.getGroupTable()).append(".").append("FDisplayName_");
                    sql.append(this.getCtx().getLocale().toString()).append(" || '_' || ");
                    sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
                    sql.append("else ");
                    sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
                    sql.append("end ");
                } else {
                    sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString()).append(" ");
                }
            } else {
                sql.append(this.at.getHgAttribute()).append(".FName_").append(this.getCtx().getLocale().toString());
            }
        } else if (!"FIsAfterCurrPeriod".equals(field.getName()) && field != GLRptField.actTypeID) {
            sql.append(field.getSelect());
        }
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        GLRptAsstactBaseCondition cond = this.getCond();
        if (!cond.isAfterCurrPeriod() && cond.getPeriodYearStart() == cond.getPeriodYearEnd() && cond.getPeriodNumberStart() == cond.getPeriodNumberEnd()) {
            sql.append(" select ").append(this.getSelect());
            sql.append(" from (");
            sql.append(super.getSQL());
            String ta = this.getMainTable().getAlias();
            GLRptAmountFilter amountFilter = new GLRptAmountFilter(cond, ta);
            sql.append(") " + ta);
            String filterSql = amountFilter.getSQL();
            if (filterSql != null && filterSql.trim().length() > 0) {
                sql.append(" where ");
                sql.append(filterSql);
            }
        } else {
            sql.append(super.getSQL());
        }
        return sql.toString();
    }

    private String getSelect() {
        String ta = this.getMainTable().getAlias();
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            sql.append(ta).append(".").append(field).append(" ").append(field);
        }
        return sql.toString();
    }

    @Override
    protected Set getAsstAccountIdSet() throws BOSException {
        ArrayList<AsstactTypeEntity> asstActList = new ArrayList<AsstactTypeEntity>();
        asstActList.add(this.at);
        return this.getCond().getAsstAccountIdSet(asstActList);
    }
}

