/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.TOTAL;
import com.kingdee.eas.fi.gl.rpt.app.GLRptAsstItemTreeNodeIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAmountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactItemPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactSingleBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSumItems;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherAssistQuery;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GLRptAsstactTreeListDao
extends AbstractGLRptDao {
    protected GLRptAsstactBaseCondition cond;
    private Boolean isFromWeb = Boolean.FALSE;

    public GLRptAsstactTreeListDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptAsstactBaseCondition)this.getQueryCondition();
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        if (this.cond.isOptionAmountAndBalZero()) {
            this.cond.getCtx().put((Object)"isFromBeginPeriod", (Object)false);
        }
        GLRptQuery query = this.getQuery();
        GLRptSelector selector = this.getGLRptSelector();
        Iterator<GLRptField> it = selector.iterator();
        GLRptSelector insertSel = new GLRptSelector();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (!f.isTempTableField() || f.getSelect() == null) continue;
            insertSel.add(f);
        }
        query.setSelector(insertSel);
        List<GLRptField> keyFields = selector.getTempTableFields();
        String[] fields = new String[keyFields.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = keyFields.get(i).getName();
        }
        this.insertData(fields, query.getSQL());
        if (this.cond.isOptionAmountAndBalZero()) {
            this.cond.getCtx().put((Object)"isFromBeginPeriod", null);
        }
        this.insertParentData();
    }

    protected void insertParentData() throws BOSException, EASBizException {
        AsstactTypeEntity at = this.getLevelAsstactType();
        if (at == null) {
            return;
        }
        String[] fields = this.getInsertParentFields();
        int maxLevel = this.getMaxLevel(at);
        boolean first = at.isUseGroup();
        for (int i = maxLevel; i > 1; --i) {
            ArrayList sp = new ArrayList();
            String sql = this.getInsertParentDataSQL(at, first && i == maxLevel, i, sp);
            this.insertData(fields, sql, sp);
        }
    }

    private String getInsertParentDataSQL(AsstactTypeEntity at, boolean first, int i, List sp) {
        StringBuffer sql = new StringBuffer();
        for (AsstactTypeEntity ent : this.cond.getAsstActList()) {
            sql.append(sql.length() == 0 ? " select distinct " : ",");
            sql.append(at == ent ? (first ? "t." + at.getHgAttribute() + "GroupID" : "p.fparentid") : "t." + ent.getHgField());
        }
        sql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
        if (!first) {
            if (at.isUseGroup()) {
                sql.append(" inner join ").append(at.getGroupTable()).append(" p on p.fid = t.").append(at.getHgAttribute()).append("GroupID and t.").append(at.getHgField()).append(" is null ");
            } else {
                sql.append(" inner join ").append(at.getTableName()).append(" p on p.fid = t.").append(at.getHgField());
            }
            sql.append(" where p.flevel = ? and not exists (select 1 from ").append(this.getDataSourceTableName()).append(" t2 ");
            sql.append(" where t2.").append(at.isUseGroup() ? at.getHgAttribute() + "GroupID" : at.getHgField()).append(" = p.FParentID)");
            sp.add(new Integer(i));
        } else {
            first = false;
        }
        return sql.toString();
    }

    private String[] getInsertParentFields() {
        Iterator it = this.cond.getAsstActList().iterator();
        ArrayList<String> fields = new ArrayList<String>();
        while (it.hasNext()) {
            AsstactTypeEntity at = (AsstactTypeEntity)it.next();
            if (at.isShowAsstGroup()) {
                fields.add(at.getHgAttribute() + "GroupID");
                continue;
            }
            fields.add(at.getHgField());
        }
        String[] fs = new String[fields.size()];
        return fields.toArray(fs);
    }

    @Override
    protected void setIsFromWeb(Boolean isFromWeb) {
        this.isFromWeb = isFromWeb;
    }

    @Override
    protected int getExpandLevel() {
        int level = 0;
        AsstactTypeEntity at = this.getLevelAsstactType();
        if (at != null && (at.getCollect() == CollectEnum.UP || this.isFromWeb.booleanValue())) {
            level = at.getSelectedLevel() - 1;
        }
        return level;
    }

    private AsstactTypeEntity getLevelAsstactType() {
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            if (!at.isMultilevel() || at.getCollect() != CollectEnum.UP && at.getCollect() != CollectEnum.LEVEL) continue;
            return at;
        }
        return null;
    }

    private int getMaxLevel(AsstactTypeEntity at) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select max(p.flevel) maxLevel from ").append(this.getDataSourceTableName()).append(" t ");
        if (at.isUseGroup()) {
            sql.append(" inner join ").append(at.getGroupTable()).append(" p on p.fid = t.").append(at.getHgAttribute()).append("GroupID");
        } else {
            sql.append(" inner join ").append(at.getTableName()).append(" p on p.fid = t.").append(at.getHgField());
        }
        IRowSet rs = this.executeQuery(sql.toString());
        try {
            if (rs.next()) {
                return at.isUseGroup() ? rs.getInt("maxLevel") + 1 : rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error!", (Throwable)e);
        }
        return 1;
    }

    protected GLRptQuery getQuery() throws BOSException, EASBizException {
        if (this.cond.isOptionAmountZero() && this.cond.isAmountZeroByVoucher()) {
            GLRptVoucherAssistQuery query = this.getRptVoucherAssistQuery(this.getContex(), this.getCompany(), this.cond, this.isQueryMeasureUnitBalance());
            query.setSelector(this.getAsstactSelector());
            query.setDistinct(true);
            return query;
        }
        GLRptBalQuery balQuery = this.getRptAsstactBalQuery(this.getContex(), (OrgUnitInfo)this.getCompany(), this.cond, this.isQueryMeasureUnitBalance(), this.isCreateDataTempTable());
        balQuery.setFromBeginPeriod(!this.cond.isOptionAmountZero());
        this.cond.getCtx().put((Object)"isFromBeginPeriod", (Object)(!this.cond.isOptionAmountZero() ? 1 : 0));
        GLRptAmountFilter amountFilter = new GLRptAmountFilter(this.cond, balQuery.getMainTable().getAlias());
        amountFilter.setFilterByPeriod(true);
        balQuery.setAmountFilter(amountFilter);
        return balQuery;
    }

    protected GLRptBalQuery getRptAsstactBalQuery(Context ctx, OrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAsstactBalQuery(ctx, company, cond, isMeasureUnit, isCreateDataTempTable){

            @Override
            protected String getHavingSQL() throws BOSException, EASBizException {
                String hsql = super.getHavingSQL();
                StringBuffer sql = new StringBuffer();
                if (!this.getCond().isNotIncluePLVoucher() && this.getCond().isOptionAmountAndBalZero()) {
                    Iterator<GLRptField> it = this.getGLRptBalSelector().iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        GLRptField field = it.next();
                        if (field.getQueryField() == null || field.getType() != "NUMERIC(29,10)" && !"fdetailcount".equalsIgnoreCase(field.getName())) continue;
                        if (first) {
                            first = false;
                        } else {
                            sql.append(" or ");
                        }
                        String item = this.getAmountSelectSQL(field);
                        item = item.trim();
                        String ff = field.toString();
                        if (item.endsWith(ff)) {
                            item = item.substring(0, item.length() - ff.length());
                        }
                        sql.append(item + " <> 0 ");
                    }
                }
                if (sql.length() == 0) {
                    return hsql;
                }
                if (hsql == null) {
                    return sql.toString();
                }
                return hsql + " and ( " + sql + " ) ";
            }
        };
    }

    protected GLRptBalQuery getRptAsstactSingleBalQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws EASBizException, BOSException {
        return new GLRptAsstactSingleBalQuery(ctx, company, cond, isMeasureUnit, isCreateDataTempTable);
    }

    protected GLRptVoucherAssistQuery getRptVoucherAssistQuery(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactBaseCondition cond, boolean isOnlyQty) {
        return new GLRptVoucherAssistQuery(ctx, cond, isOnlyQty);
    }

    protected GLRptSelector getAsstactSelector() {
        GLRptSelector sic = new GLRptSelector();
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            sic.add(GLRptField.genAsstDataBaseID(at));
            if (!at.isMultilevel() || !at.isUseGroup() || at.getCollect() != CollectEnum.UP && at.getCollect() != CollectEnum.LEVEL) continue;
            sic.add(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
        }
        return sic;
    }

    protected boolean isQueryMeasureUnitBalance() {
        if (this.cond instanceof GLRptAsstactGGCondition) {
            return this.isShowQty() && this.cond.getMeasureUnitId() != null;
        }
        return this.isShowQty() && (this.cond.getMeasureUnitId() != null || this.cond.isGroupByMU());
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAsstactItemPageQuery(this.getContex(), this.cond);
    }

    protected void addAsstGroupSelector(GLRptSelector selector) {
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            if (!this.isShowAsstGroup(at)) continue;
            if (at.isBasicCat()) {
                selector.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "." + at.getGroupField(), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                continue;
            }
            selector.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "GDet." + GLRptDaoUtil.getGroupField(at), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
        }
    }

    protected String getAsstItemNumber(AsstactTypeEntity at) throws EASBizException, BOSException {
        if (this.isShowAsstGroup(at)) {
            return "case when " + at.getHgAttribute() + ".fid is null then " + at.getHgAttribute() + "Group.FNumber else " + at.getHgAttribute() + ".FNumber end";
        }
        boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
        return at.isUseLongNumber() && isShowLongNumber ? at.getHgAttribute() + ".flongnumber" : at.getHgAttribute() + ".fnumber";
    }

    protected String getAsstItemName(AsstactTypeEntity at) throws EASBizException, BOSException {
        boolean isShowNumber = this.cond.getRptParams().isAssitemShowNumber();
        boolean isShowLongName = this.cond.getRptParams().isShowLongNameForGeneral();
        boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
        String assItemName = this.isShowAsstGroup(at) ? "case when " + at.getHgAttribute() + ".fid is null then " + at.getHgAttribute() + "Group.fname_" + this.getContex().getLocale().toString() + " else " + at.getHgAttribute() + ".fname_" + this.getContex().getLocale().toString() + " end" : at.getHgAttribute() + (at.isGeneralActType() && isShowLongName ? ".fdisplayname_" : ".fname_") + this.getContex().getLocale().toString();
        if (isShowNumber) {
            if (this.isShowAsstGroup(at)) {
                String assItemNumber = "case when " + at.getHgAttribute() + ".fid is null then " + at.getHgAttribute() + "Group.FNumber else " + at.getHgAttribute() + ".FNumber end";
                assItemName = "case when " + at.getHgAttribute() + ".fid is null and " + at.getHgAttribute() + "GroupID is null then null else (" + assItemNumber + "||' '||" + assItemName + ") end";
            } else {
                String assItemNumber = at.isUseLongNumber() && isShowLongNumber ? "replace(" + at.getHgAttribute() + ".flongnumber,'!','.')" : at.getHgAttribute() + ".fnumber";
                assItemName = "case when " + at.getHgAttribute() + ".fid is null then null else (" + assItemNumber + "||' '||" + assItemName + ") end";
            }
        }
        return assItemName;
    }

    private boolean isShowAsstGroup(AsstactTypeEntity at) {
        return at.isMultilevel() && at.isUseGroup() && (at.getCollect() == CollectEnum.LEVEL || at.getCollect() == CollectEnum.UP);
    }

    @Override
    protected GLRptSumItems getTempTableSumItem() throws BOSException, EASBizException {
        if (!this.cond.isShowAsstItemTotal()) {
            return null;
        }
        GLRptSumItems sumItem = new GLRptSumItems();
        sumItem.setSumGroup("isTotal");
        Iterator it = this.cond.getAsstActList().iterator();
        AsstactTypeEntity at = (AsstactTypeEntity)it.next();
        while (it.hasNext()) {
            if (this.isShowAsstGroup(at)) {
                if (at.isBasicCat()) {
                    sumItem.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "." + at.getGroupField(), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                } else {
                    sumItem.add(new GLRptField(at.getHgAttribute() + "GroupID", at.getHgAttribute() + "GDet." + GLRptDaoUtil.getGroupField(at), "assGrp." + at.getHgAttribute() + ".group.id", "VARCHAR(44)"));
                }
            } else {
                sumItem.add(new GLRptField(at.getHgField(), GLRptDataTable.HG.getAlias() + "." + at.getHgField(), "assGrp." + at.getHgAttribute() + ".id", "VARCHAR(44)"));
            }
            at = (AsstactTypeEntity)it.next();
            sumItem.setSumGroup(at.getHgField() + "IsTotal");
        }
        return sumItem;
    }

    @Override
    protected void doGLRptRowData(GLRptRowSet rowSet) throws EASBizException, BOSException {
        super.doGLRptRowData(rowSet);
        if (!this.cond.isShowAsstItemTotal()) {
            return;
        }
        AsstactTypeEntity at = (AsstactTypeEntity)this.cond.getAsstActList().get(0);
        if (rowSet.getInt("isTotal") == 1) {
            rowSet.updateObject(at.getHgAttribute() + "Name", TOTAL.getTotal(this.getContex()));
        } else {
            for (int i = 1; i < this.cond.getAsstActList().size(); ++i) {
                at = (AsstactTypeEntity)this.cond.getAsstActList().get(1);
                if (rowSet.getInt(at.getHgField() + "IsTotal") != 1) continue;
                rowSet.updateObject(at.getHgAttribute() + "Name", TOTAL.getSubTotal(this.getContex()));
                break;
            }
        }
    }

    @Override
    protected void insertSumItem() throws EASBizException, BOSException {
        if (!this.cond.isShowAsstItemTotal()) {
            return;
        }
        try {
            String tmpSql = "select top 1 * from " + this.getDataSourceTable().getTableName();
            IRowSet rs = DbUtil.executeQuery((Context)this.getContex(), (String)tmpSql);
            if (!rs.next()) {
                return;
            }
        }
        catch (SQLException tmpSql) {
            // empty catch block
        }
        ArrayList<AsstactTypeEntity> groupTypes = new ArrayList<AsstactTypeEntity>();
        ArrayList groupFields = new ArrayList();
        String sql = this.getSumItemSQL("isTotal", groupTypes, groupFields);
        this.insertData(groupFields.toArray(new String[groupFields.size()]), sql);
        Iterator it = this.cond.getAsstActList().iterator();
        AsstactTypeEntity at = (AsstactTypeEntity)it.next();
        while (it.hasNext()) {
            groupFields = new ArrayList();
            groupTypes.add(at);
            at = (AsstactTypeEntity)it.next();
            sql = this.getSumItemSQL(at.getHgField() + "IsTotal", groupTypes, groupFields);
            this.insertData(groupFields.toArray(new String[groupFields.size()]), sql);
        }
    }

    protected String getSumItemSQL(String sumItemName, List groupTypes, List groupFields) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct ");
        sql.append(" 1 ").append(sumItemName);
        groupFields.add(sumItemName);
        if (groupTypes == null || groupTypes.isEmpty()) {
            return sql.toString();
        }
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < groupTypes.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)groupTypes.get(i);
            sql.append(",");
            if (i == 0) {
                where.append(" where ");
            } else {
                where.append(" and ");
            }
            sql.append(" t.").append(at.getHgField());
            where.append(" (t.").append(at.getHgField()).append(" is not null");
            groupFields.add(at.getHgField());
            if (this.isShowAsstGroup(at)) {
                sql.append(", t.").append(at.getHgAttribute()).append("GroupId");
                where.append(" or t.").append(at.getHgAttribute()).append("GroupId is not null");
                groupFields.add(at.getHgAttribute() + "GroupId");
            }
            where.append(" ) ");
        }
        sql.append(" from ").append(this.getDataSourceTableName()).append(" t ").append(where);
        return sql.toString();
    }

    @Override
    protected boolean isAutoSumData() {
        return false;
    }

    @Override
    public IGLRptIDCreator getGLRptIDCreator(String mainTableAlias, GLRptField field) {
        return new GLRptAsstItemTreeNodeIDCreator(mainTableAlias, this.getLevelAsstactType());
    }

    @Override
    protected void setTreeNode(GLRptRowSet rowSet, IRowSet rs, GLRptTreeNode node) throws BOSException {
        SimpleCompanyUserObject obj = (SimpleCompanyUserObject)node.getUserObject();
        try {
            AsstactTypeEntity at = this.getLevelAsstactType();
            if (at != null) {
                obj.setName(rs.getString(at.getHgAttribute() + "Name"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        rowSet.updateObject(this.getTreeColmun().getName(), node);
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            selector.add(GLRptField.genAsstDataBaseID(at));
            boolean isShowNumber = this.cond.getRptParams().isAssitemShowNumber();
            boolean isShowLongName = this.cond.getRptParams().isShowLongNameForGeneral();
            boolean isShowLongNumber = this.cond.getRptParams().isShowLongNumberForGeneral();
            selector.add(GLRptField.genAsstDataBaseNumber(at, isShowLongNumber));
            selector.add(GLRptField.genAsstDataBaseName(at, this.getContex(), isShowNumber, isShowLongNumber, isShowLongName));
            if (!at.isShowAsstGroup()) continue;
            selector.add(GLRptField.genAsstDataBaseGroupID(this.cond.isFilterByCat(), at));
        }
        return selector;
    }

    @Override
    public GLRptField getTreeColmun() {
        for (AsstactTypeEntity at : this.cond.getAsstActList()) {
            if (at.getCollect() != CollectEnum.UP && at.getCollect() != CollectEnum.LEVEL) continue;
            return new GLRptField(at.getHgAttribute() + "Name", "NVARCHAR(500)");
        }
        return null;
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = new String[][]{this.getTitleRow1()};
        return titles;
    }
}

