/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptGeneralLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptBalQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDataTable;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class GLRptBalNextPeriodQuery
extends GLRptQuery {
    private int period;
    private int nextPeriod;
    private Date nextPeriodBeginDate;
    private String periodField;
    private GLRptBalQuery query;
    private String sysStatusTable;

    protected int getPeriod() {
        return this.period;
    }

    protected int getNextPeriod() {
        return this.nextPeriod;
    }

    protected String getPeriodField() {
        return this.periodField;
    }

    public GLRptBalNextPeriodQuery(Context ctx, GLRptBaseCondition cond) throws BOSException, EASBizException {
        super(ctx, cond);
    }

    public void setPeriod(int beginPeriod, int endPeriod) throws EASBizException, BOSException {
        PeriodCollection pColl;
        this.period = beginPeriod;
        this.nextPeriod = endPeriod;
        if (this.getSelector().contains(GLRptField.periodBeginDate) && !(pColl = GLRptDaoUtil.getPeriodCollection(this.getCtx(), this.getCond().getPeriodTypeId(), this.nextPeriod, this.nextPeriod)).isEmpty()) {
            this.nextPeriodBeginDate = pColl.get(0).getBeginDate();
        }
    }

    public void setDataSourceTableName(String dataSourceTableName) {
        this.periodField = "b.fperiod";
        this.setMainTable(new GLRptDataTable(dataSourceTableName, "b"));
    }

    public void setGLRptQuery(GLRptBalQuery query) {
        this.periodField = GLRptField.period.getSelect();
        this.query = query;
        this.setMainTable(query.getMainTable());
    }

    public void setSysStatusTable(String sysStatusTable) {
        this.sysStatusTable = sysStatusTable;
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            return "1";
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (field.getType() == "NUMERIC(29,10)") {
                if (sql.length() > 0) {
                    sql.append(",");
                }
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            if (sql.length() > 0) {
                sql.append(",");
            }
            this.appendSelectField(sql, field);
        }
        return sql.toString();
    }

    protected void appendSelectField(StringBuffer sql, GLRptField field) {
        if (field == GLRptField.period) {
            sql.append(this.nextPeriod).append(" ").append(GLRptField.period);
        } else if (field == GLRptField.periodBeginDate && this.nextPeriodBeginDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String beginDate = format.format(this.nextPeriodBeginDate);
            sql.append(" to_date('").append(beginDate).append("') ").append(GLRptField.periodBeginDate);
        } else if ("FIsAfterCurrPeriod".equals(field.getName())) {
            sql.append(0).append(" ").append("FIsAfterCurrPeriod");
        } else if (this.query != null) {
            this.query.appendSelectField(sql, field);
        } else {
            sql.append(this.getMainTable().getAlias()).append(".").append(field.getName());
        }
    }

    @Override
    protected String getJoinSQL() throws EASBizException, BOSException {
        if (this.query != null) {
            this.query.setJoin(this.query.initJoinTable());
            return this.query.getJoinSQL();
        }
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            return " LEFT OUTER JOIN " + this.sysStatusTable + " ssc ON b.FOrgUnitID = ssc.fcompanyid ";
        }
        return null;
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (this.query != null) {
            sql.append(this.query.getWhereSQL());
            List<GLRptFilter> filters = this.query.getFilters();
            if (!filters.isEmpty()) {
                for (GLRptFilter glRptFilter : filters) {
                    String filter = glRptFilter.getSQL();
                    if (filter == null || filter.trim().length() <= 0) continue;
                    sql.append(" and ").append(filter);
                }
            }
        } else {
            String periodVal;
            int startPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
            String string = periodVal = CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode() && this.nextPeriod == startPeriod ? "ssc.FCURRPERIOD" : String.valueOf(this.period);
            if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
                sql.append("(").append(this.periodField).append(" >= ").append(periodVal);
                sql.append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod);
                sql.append(" and ssc.FCURRPERIOD < ").append(this.nextPeriod);
                sql.append(")  \r\n");
            }
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(" (").append(this.periodField).append(" = ").append(periodVal);
            sql.append(" and b.").append("FIsAfterCurrPeriod").append(" = 0");
            sql.append(" or ").append(this.periodField).append(" > ").append(periodVal);
            sql.append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod);
            sql.append(" and b.").append("FIsAfterCurrPeriod").append(" = 1");
            sql.append(")  \r\n");
        }
        return sql.toString();
    }

    @Override
    protected String getGroupSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if ("FIsAfterCurrPeriod".equals(field.getName()) || field == GLRptField.period || field == GLRptField.periodBeginDate || "FBalSeq".equals(field.getName()) || field.getType() == "NUMERIC(29,10)" || field.getQueryField() == null) continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            int len = sql.length();
            this.appendGroupField(sql, field);
            if (len <= 0 || sql.length() != len) continue;
            sql.setLength(len - 1);
        }
        return sql.toString();
    }

    protected void appendGroupField(StringBuffer sql, GLRptField field) {
        if (this.query != null) {
            this.query.appendGroupField(sql, field);
        } else {
            sql.append(this.getMainTable().getAlias()).append(".").append(field.getName());
        }
    }

    protected String getAmountSelectSQL(GLRptField field) {
        int startPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode() && this.nextPeriod == startPeriod) {
            return this.query == null ? this.getAmountSelectSQLNextPeriod2(field) : this.getAmountSelectSQLNextPeriod3(field);
        }
        return this.getAmountSelectSQLNextPeriod1(field);
    }

    protected String getAmountSelectSQLNextPeriod2(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        if (field.isBegin()) {
            sql.append("sum(case when ").append(this.periodField).append(" = ssc.FCURRPERIOD");
            sql.append(" then b.").append("FEnd").append(field.getBalSuffix());
            sql.append(" when ").append(this.periodField).append(" > ssc.FCURRPERIOD and ").append(this.periodField).append(" < ").append(this.nextPeriod);
            sql.append(" then (b.").append("FDebit").append(field.getSuffix()).append(" - b.").append("FCredit").append(field.getSuffix()).append(") else 0 end) ");
            sql.append("FBegin").append(field.getBalSuffix()).append(" \r\n");
        } else if (field.isDebit() || field.isCredit()) {
            sql.append("sum(case when ").append(this.periodField).append(" = ").append(this.nextPeriod);
            sql.append(" then b.").append(field).append(" else 0 end) ").append(field).append(" \r\n");
        } else if (field.isYearDebit()) {
            sql.append("sum(CASE WHEN FLOOR(ssc.FCURRPERIOD/100) = FLOOR(").append(this.nextPeriod).append("/100) THEN         ");
            sql.append("   CASE WHEN (").append(this.periodField).append(" = ssc.FCURRPERIOD)  THEN                          ");
            sql.append("      b.").append(field).append("                                         ");
            sql.append("   WHEN ((").append(this.periodField).append(" >= ssc.FCURRPERIOD) AND (").append(this.periodField).append(" <= ").append(this.nextPeriod).append(")) THEN   ");
            sql.append("      b.").append("FDebit").append(field.getSuffix()).append("                           ");
            sql.append("   ELSE                                                                   ");
            sql.append("      0                                                                   ");
            sql.append("   END                                                                    ");
            sql.append("  ELSE                                                                    ");
            sql.append("   CASE WHEN ( (").append(this.periodField).append(" > FLOOR(").append(this.nextPeriod).append("/100)*100) AND                    ");
            sql.append("         (").append(this.periodField).append(" <= ").append(this.nextPeriod).append(")) THEN                                      ");
            sql.append("      b.").append("FDebit").append(field.getSuffix()).append("                           ");
            sql.append("   ELSE                                                                   ");
            sql.append("      0                                                                   ");
            sql.append("   END                                                                    ");
            sql.append("  END                                                                     ");
            sql.append("  ) ").append(field).append("                                             \r\n");
        } else if (field.isYearCredit()) {
            sql.append("sum(CASE WHEN FLOOR(ssc.FCURRPERIOD/100) = FLOOR(").append(this.nextPeriod).append("/100) THEN         ");
            sql.append("   CASE WHEN (").append(this.periodField).append(" = ssc.FCURRPERIOD)  THEN                          ");
            sql.append("      b.").append(field).append("                                         ");
            sql.append("   WHEN ((").append(this.periodField).append(" >= ssc.FCURRPERIOD) AND (").append(this.periodField).append(" <= ").append(this.nextPeriod).append(")) THEN   ");
            sql.append("      b.").append("FCredit").append(field.getSuffix()).append("                           ");
            sql.append("   ELSE                                                                   ");
            sql.append("      0                                                                   ");
            sql.append("   END                                                                    ");
            sql.append("  ELSE                                                                    ");
            sql.append("   CASE WHEN ( (").append(this.periodField).append(" > FLOOR(").append(this.nextPeriod).append("/100)*100) AND                    ");
            sql.append("         (").append(this.periodField).append(" <= ").append(this.nextPeriod).append(")) THEN                                      ");
            sql.append("      b.").append("FCredit").append(field.getSuffix()).append("                           ");
            sql.append("   ELSE                                                                   ");
            sql.append("      0                                                                   ");
            sql.append("   END                                                                    ");
            sql.append("  END                                                                     ");
            sql.append("  ) ").append(field).append("                                             \r\n");
        } else if (field.isEnd()) {
            sql.append("sum(case when ").append(this.periodField).append(" = ssc.FCURRPERIOD");
            sql.append(" then b.").append(field);
            sql.append(" when ").append(this.periodField).append(" > ssc.FCURRPERIOD and ").append(this.periodField).append(" <= ").append(this.nextPeriod);
            sql.append(" then (b.").append("FDebit").append(field.getSuffix()).append(" - b.").append("FCredit").append(field.getSuffix()).append(") else 0 end) ");
            sql.append(field).append(" \r\n");
        }
        return sql.toString();
    }

    protected String getAmountSelectSQLNextPeriod3(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        if (field.isBegin()) {
            sql.append(" sum(case when ").append(this.nextPeriod).append(" <= ssc.fstartperiod and ").append(this.periodField).append(" = ssc.fstartperiod then b.").append(field);
            sql.append(" when ").append(this.nextPeriod).append(" > ssc.fstartperiod and ").append(this.nextPeriod).append(" <= ssc.fcurrperiod and ").append(this.periodField).append(" = ").append(this.nextPeriod).append(" then b.").append(field);
            sql.append(" when ").append(this.nextPeriod).append(" > ssc.fcurrperiod and ").append(this.periodField).append(" = ssc.fcurrperiod then  b.").append("FEnd").append(field.getBalSuffix());
            sql.append(" when ").append(this.nextPeriod).append(" > ssc.fcurrperiod and ").append(this.periodField).append(" > ssc.fcurrperiod AND ").append(this.periodField).append(" < ").append(this.nextPeriod).append(" then (b.").append("FDebit").append(field.getSuffix()).append(" - b.").append("FCredit").append(field.getSuffix()).append(") ");
            sql.append(" else 0 end) ").append(field);
        } else if (field.isDebit() || field.isCredit()) {
            sql.append(" sum(case when ").append(this.nextPeriod).append(" <= ssc.fstartperiod and ").append(this.periodField).append(" = ssc.fstartperiod then b.").append(field);
            sql.append(" when ").append(this.periodField).append(" = ").append(this.nextPeriod).append(" then b.").append(field);
            sql.append(" else 0 end) ").append(field);
        } else if (field.isYearDebit()) {
            sql.append(" sum(case when (").append(this.nextPeriod).append(" <= ssc.fstartperiod) AND ").append(this.periodField).append(" = ssc.fstartperiod then b.").append(field);
            sql.append(" when ").append(this.nextPeriod).append(" > ssc.fstartperiod AND ").append(this.nextPeriod).append(" <= ssc.fcurrperiod ").append(" then (case when ").append(this.periodField).append(" = ").append(this.nextPeriod).append(" then b.").append(field).append(" else 0 end)");
            sql.append(" when FLOOR(ssc.fcurrperiod/100) = FLOOR(").append(this.nextPeriod).append("/100) and ").append(this.nextPeriod).append(" > ssc.fcurrperiod and ").append(this.periodField).append(" = ssc.fcurrperiod then b.").append(field);
            sql.append(" when FLOOR(ssc.fcurrperiod/100) = FLOOR(").append(this.nextPeriod).append("/100) and ").append(this.periodField).append(" >= ssc.fcurrperiod AND ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" THEN b.").append("FDebit").append(field.getSuffix());
            sql.append(" when ").append(this.periodField).append(" > FLOOR(").append(this.nextPeriod).append("/100)*100 and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" THEN b.").append("FDebit").append(field.getSuffix());
            sql.append(" else 0 end ) ").append(field);
        } else if (field.isYearCredit()) {
            sql.append(" sum(case when (").append(this.nextPeriod).append(" <= ssc.fstartperiod) AND ").append(this.periodField).append(" = ssc.fstartperiod then b.").append(field);
            sql.append(" when ").append(this.nextPeriod).append(" > ssc.fstartperiod AND ").append(this.nextPeriod).append(" <= ssc.fcurrperiod ").append(" then (case when ").append(this.periodField).append(" = ").append(this.nextPeriod).append(" then b.").append(field).append(" else 0 end)");
            sql.append(" when FLOOR(ssc.fcurrperiod/100) = FLOOR(").append(this.nextPeriod).append("/100) and ").append(this.nextPeriod).append(" > ssc.fcurrperiod and ").append(this.periodField).append(" = ssc.fcurrperiod then b.").append(field);
            sql.append(" when FLOOR(ssc.fcurrperiod/100) = FLOOR(").append(this.nextPeriod).append("/100) and ").append(this.periodField).append(" >= ssc.fcurrperiod AND ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" THEN b.").append("FCredit").append(field.getSuffix());
            sql.append(" when ").append(this.periodField).append(" > FLOOR(").append(this.nextPeriod).append("/100)*100 and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" THEN b.").append("FCredit").append(field.getSuffix());
            sql.append(" else 0 end ) ").append(field);
        } else if (field.isEnd()) {
            sql.append("sum(case when ").append(this.periodField).append(" = ssc.FCURRPERIOD");
            sql.append(" then b.").append(field);
            sql.append(" when ").append(this.periodField).append(" > ssc.FCURRPERIOD and ").append(this.periodField).append(" <= ").append(this.nextPeriod);
            sql.append(" then (b.").append("FDebit").append(field.getSuffix()).append(" - b.").append("FCredit").append(field.getSuffix()).append(") else 0 end) ");
            sql.append(field);
        }
        return sql.toString();
    }

    protected String getAmountSelectSQLNextPeriod1(GLRptField field) {
        StringBuffer sql = new StringBuffer();
        if (field.isBegin()) {
            sql.append("sum(case when ").append(this.periodField).append(" = ").append(this.period);
            sql.append(" then b.").append("FEnd").append(field.getBalSuffix()).append(" when ").append(this.periodField).append(" > ").append(this.period);
            sql.append(" and ").append(this.periodField).append(" < ").append(this.nextPeriod).append(" then (b.").append("FDebit").append(field.getSuffix());
            sql.append(" - b.").append("FCredit").append(field.getSuffix()).append(") else 0 end) ").append("FBegin").append(field.getBalSuffix()).append(" \r\n");
        } else if (field.isDebit() || field.isCredit()) {
            if (this.getCond() instanceof GLRptGeneralLedgerCondition) {
                sql.append(" 0.0 ").append(field).append(" \r\n");
            } else {
                sql.append("sum(case when ").append(this.periodField).append(" = ").append(this.nextPeriod).append(" then b.").append(field).append(" else 0 end) ").append(field).append(" \r\n");
            }
        } else if (field.isYearDebit()) {
            if (this.period / 100 == this.nextPeriod / 100) {
                sql.append("sum(case when ").append(this.periodField).append(" = ").append(this.period);
                sql.append(" then b.").append(field).append(" when ").append(this.periodField).append(" > ").append(this.period).append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" then b.").append("FDebit").append(field.getSuffix()).append(" else 0 end) ").append(field).append(" \r\n");
            } else {
                int p = this.nextPeriod / 100 * 100;
                sql.append("sum(case when ").append(this.periodField).append(" > ").append(p).append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" then b.").append("FDebit").append(field.getSuffix()).append(" else 0 end) ").append(field).append(" \r\n");
            }
        } else if (field.isYearCredit()) {
            if (this.period / 100 == this.nextPeriod / 100) {
                sql.append("sum(case when ").append(this.periodField).append(" = ").append(this.period);
                sql.append(" then b.").append(field).append(" when ").append(this.periodField).append(" > ").append(this.period).append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" then b.").append("FCredit").append(field.getSuffix()).append(" else 0 end) ").append(field).append(" \r\n");
            } else {
                int p = this.nextPeriod / 100 * 100;
                sql.append("sum(case when ").append(this.periodField).append(" > ").append(p).append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" then b.").append("FCredit").append(field.getSuffix()).append(" else 0 end) ").append(field).append(" \r\n");
            }
        } else if (field.isEnd()) {
            sql.append("sum(case when ").append(this.periodField).append(" = ").append(this.period);
            sql.append(" then b.").append(field).append(" when ").append(this.periodField).append(" > ").append(this.period).append(" and ").append(this.periodField).append(" <= ").append(this.nextPeriod).append(" then (b.").append("FDebit").append(field.getSuffix()).append(" - b.").append("FCredit").append(field.getSuffix()).append(") else 0 end) ").append(field).append(" \r\n");
        }
        return sql.toString();
    }
}

