/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAmountFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptCompanyFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptCurrencyFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptNotPLBalanceQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTableJoin;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptVoucherField;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class GLRptBalQuery
extends GLRptQuery {
    private CompanyOrgUnitInfo company;
    private boolean isCreateDataTempTable = false;
    private String sysStatusTmpTable;
    private boolean isMeasureUnit = false;
    private boolean isIncluePLVoucher = false;
    private boolean isNotGroup = false;
    private boolean isFromBeginPeriod = true;
    private boolean isPeriodBeginBalance = false;
    private GLRptAmountFilter amountFilter;
    private int startYear = -1;
    private int startMonth = -1;
    protected static Map<GLRptField, GLRptField> fm = new HashMap<GLRptField, GLRptField>();

    public GLRptBalQuery(Context ctx, OrgUnitInfo org, GLRptBaseCondition cond, boolean isMeasureUnit, boolean isCreateDataTempTable) throws BOSException, EASBizException {
        super(ctx, cond);
        this.isMeasureUnit = isMeasureUnit;
        this.isCreateDataTempTable = isCreateDataTempTable;
        this.initOrg(ctx, org, cond, isCreateDataTempTable);
    }

    public void setSysStatusTmpTable(String sysStatusTmpTable) {
        this.sysStatusTmpTable = sysStatusTmpTable;
    }

    public void setBeginPeriod(int startYear, int startMonth) {
        this.startYear = startYear;
        this.startMonth = startMonth;
    }

    @Override
    protected String getSelectSQL() throws EASBizException, BOSException {
        if (this.getSelector() == null || this.getSelector().isEmpty()) {
            throw new BOSException("The query selector is temp!");
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        boolean first = true;
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getQueryField() == null) continue;
            if (first) {
                first = false;
            } else {
                sql.append(",");
            }
            if (field.getType() == "NUMERIC(29,10)" || "fdetailcount".equalsIgnoreCase(field.getName())) {
                sql.append(this.getAmountSelectSQL(field));
                continue;
            }
            this.appendSelectField(sql, field);
        }
        return sql.toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(super.getJoinSQL());
        sql.append(this.getPeriodJoinSQL());
        if (CompanyDisplayModeEnum.enumerate != this.getCond().getCompanyDisplayMode()) {
            sql.append(this.getJoinSQLSystemStatusControl());
        }
        return sql.toString();
    }

    protected String getPeriodJoinSQL() throws BOSException, EASBizException {
        return " LEFT OUTER JOIN T_BD_PERIOD pd ON pd.FNumber = b.FPeriod AND pd.FTypeID = '" + this.getCond().getPeriodTypeId() + "'";
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        String amountFilter;
        GLRptBaseCondition cond = this.getCond();
        StringBuffer sql = new StringBuffer();
        GLRptFilter orgFilter = this.getOrgFilter();
        sql.append(orgFilter.getSQL());
        if (sql.length() > 0) {
            sql.append(" and ");
        }
        if (this.startYear == -1 || this.startMonth == -1) {
            sql.append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(" in ").append(cond.getPeriodNumbersInSql(this.isFromBeginPeriod));
            if (CompanyDisplayModeEnum.enumerate != cond.getCompanyDisplayMode()) {
                int startPeriod = cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart();
                sql.append(" and (").append(GLRptField.period.getSelect());
                sql.append(" >= ssc.fstartperiod");
                sql.append(" and (").append(GLRptField.period.getSelect());
                sql.append(" >= ssc.fcurrperiod");
                sql.append("  or ").append(GLRptField.period.getSelect());
                sql.append(" >= ").append(startPeriod);
                sql.append(" )) ");
            }
        } else {
            sql.append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(" in ");
            sql.append(SQLUtil.buildPeriodNumbersInSql(this.startYear, this.startMonth, cond.getPeriodYearEnd(), cond.getPeriodNumberEnd()));
        }
        GLRptCurrencyFilter cyFilter = new GLRptCurrencyFilter(cond, this.getMainTable().getAlias() + "." + GLRptField.currencyID);
        sql.append(cyFilter.getSQL());
        if (this.getAmountFilter() != null && !StringUtils.isEmpty((String)(amountFilter = this.getAmountFilter().getSQL()))) {
            if (sql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(amountFilter);
        }
        return sql.toString();
    }

    protected void appendSelectField(StringBuffer sql, GLRptField field) {
        sql.append(field.getSelect());
        if (field.isMultiLang()) {
            sql.append("_").append(this.getCtx().getLocale().toString());
        }
        sql.append(" ").append(field.getName());
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        GLRptTableJoin join = this.initJoinTable();
        if (join != null) {
            this.setJoin(join);
        }
        if (!this.isIncluePLVoucher && this.getCond().isNotIncluePLVoucher()) {
            GLRptSelector selector = this.getSelector();
            this.setSelector(this.getGLRptBalSelector());
            GLRptSelector voucherSeletor = this.getGLRptVoucherSelector();
            GLRptQuery voucherQuery = this.getPLVoucherQuery();
            voucherQuery.setSelector(voucherSeletor);
            GLRptNotPLBalanceQuery notPLQuery = new GLRptNotPLBalanceQuery(this.getCtx(), this.getCond(), this, voucherQuery);
            notPLQuery.setSelector(selector);
            return notPLQuery.getSQL();
        }
        return GLRptSQLUtil.addBalTableHint(super.getSQL());
    }

    protected GLRptTableJoin initJoinTable() throws EASBizException, BOSException {
        return null;
    }

    public void setIncluePLVoucher(boolean isIncluePLVoucher) {
        this.isIncluePLVoucher = isIncluePLVoucher;
    }

    protected abstract GLRptQuery getPLVoucherQuery() throws EASBizException, BOSException;

    protected GLRptSelector getGLRptVoucherSelector() throws EASBizException, BOSException {
        GLRptSelector sel = new GLRptSelector();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (f.isQty()) {
                GLRptField field;
                if (f.isDebit()) {
                    field = this.getDebitQtyField();
                    sel.add(new GLRptField("FSubDebitQty", field.getSelect(), field.getQueryField(), field.getType()));
                    continue;
                }
                if (!f.isCredit()) continue;
                field = this.getCreditQtyField();
                sel.add(new GLRptField("FSubCreditQty", field.getSelect(), field.getQueryField(), field.getType()));
                continue;
            }
            if (fm.get(f) != null) {
                sel.add(fm.get(f));
                continue;
            }
            if (!f.isTempTableField() || !f.getSelect().startsWith("hg.F") && !f.getName().endsWith("GroupID")) continue;
            String select = f.getSelect().startsWith("hg.F") ? f.getSelect().replaceFirst("hg", "assGrp") : f.getSelect();
            f = new GLRptField(f.getName(), select, f.getQueryField(), f.getType());
            sel.add(f);
        }
        if (this.getAmountFilter() != null && (this.getCond().isOptionAmountZero() || this.getCond().isOptionBalanceZero() || this.getCond().isOptionAmountAndBalZero())) {
            this.addVoucherAmountField(sel);
        }
        return sel;
    }

    protected GLRptField getDebitQtyField() {
        return this.isMeasureUnit ? GLRptVoucherField.entryDebitQty : GLRptVoucherField.entryStandDebitQty;
    }

    protected GLRptField getCreditQtyField() {
        return this.isMeasureUnit ? GLRptVoucherField.entryCreditQty : GLRptVoucherField.entryStandCreditQty;
    }

    protected void addVoucherAmountField(GLRptSelector sel) throws EASBizException, BOSException {
        GLRptBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            sel.add(GLRptVoucherField.entryDebitFor);
            sel.add(GLRptVoucherField.entryCreditFor);
        }
        if (cond.isShowLocal()) {
            sel.add(GLRptVoucherField.entryDebitLocal);
            sel.add(GLRptVoucherField.entryCreditLocal);
        }
        if (cond.isShowRpt()) {
            sel.add(GLRptVoucherField.entryDebitRpt);
            sel.add(GLRptVoucherField.entryCreditRpt);
        }
    }

    protected GLRptSelector getGLRptBalSelector() throws EASBizException, BOSException {
        GLRptSelector sel = new GLRptSelector();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField f = it.next();
            if (f.getSelect() == null) continue;
            sel.add(f);
        }
        if (this.getAmountFilter() != null && (this.getCond().isOptionAmountZero() || this.getCond().isOptionBalanceZero() || this.getCond().isOptionAmountAndBalZero())) {
            this.addBalAmountField(sel);
        }
        return sel;
    }

    private void addBalAmountField(GLRptSelector sel) throws EASBizException, BOSException {
        GLRptBaseCondition cond = this.getCond();
        if (cond.isShowFor()) {
            if (cond.isOptionAmountZero() || cond.isOptionAmountAndBalZero()) {
                sel.add(GLRptField.debitFor);
                sel.add(GLRptField.creditFor);
            }
            if (cond.isOptionAmountAndBalZero() || cond.isOptionBalanceZero()) {
                sel.add(GLRptField.endBalanceFor);
            }
        }
        if (cond.isShowLocal()) {
            if (cond.isOptionAmountZero() || cond.isOptionAmountAndBalZero()) {
                sel.add(GLRptField.debitLocal);
                sel.add(GLRptField.creditLocal);
            }
            if (cond.isOptionAmountAndBalZero() || cond.isOptionBalanceZero()) {
                sel.add(GLRptField.endBalanceLocal);
            }
        }
        if (cond.isShowRpt()) {
            if (cond.isOptionAmountZero() || cond.isOptionAmountAndBalZero()) {
                sel.add(GLRptField.debitRpt);
                sel.add(GLRptField.creditRpt);
            }
            if (cond.isOptionAmountAndBalZero() || cond.isOptionBalanceZero()) {
                sel.add(GLRptField.endBalanceRpt);
            }
        }
        if (cond.isOptionAmountAndBalZero() && cond.isAmountZeroByVoucher()) {
            sel.add(new GLRptField("fdetailcount", "b.fdetailcount", "detailcount", "INT"));
        }
    }

    protected boolean isGroupBy() throws BOSException, EASBizException {
        return !this.getSelectorNotExistKeys().isEmpty();
    }

    private boolean isGroup() throws BOSException, EASBizException {
        if (this.isNotGroup()) {
            return false;
        }
        return this.isGroupBy();
    }

    protected void setNotGroup(boolean isNotGroup) {
        this.isNotGroup = isNotGroup;
    }

    protected boolean isNotGroup() {
        return this.isNotGroup;
    }

    protected Set<GLRptField> getSelectorNotExistKeys() throws EASBizException, BOSException {
        HashSet<GLRptField> notExistKeys = new HashSet<GLRptField>();
        if (this.getMainTable() == null) {
            return notExistKeys;
        }
        for (GLRptField field : this.getMainTable().getKeySet()) {
            Iterator<GLRptField> keyIt = this.getSelector().getTempTableFields().iterator();
            boolean exist = false;
            while (keyIt.hasNext()) {
                if (field != keyIt.next()) continue;
                exist = true;
            }
            if (exist) continue;
            notExistKeys.add(field);
        }
        this.distinctKeys(notExistKeys);
        return notExistKeys;
    }

    protected void distinctKeys(Set<GLRptField> keySet) throws EASBizException, BOSException {
        if (this.getCond().getPeriodYearStart() == this.getCond().getPeriodYearEnd() && this.getCond().getPeriodNumberStart() == this.getCond().getPeriodNumberEnd()) {
            keySet.remove(GLRptField.period);
        }
        if (!this.getCond().isAllCurrency()) {
            keySet.remove(GLRptField.currencyID);
        }
        this.distinctOrgKey(keySet);
    }

    @Override
    protected String getGroupSQL() throws BOSException, EASBizException {
        if (!this.isGroup() || this.getSelector() == null || this.getSelector().isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        Iterator<GLRptField> it = this.getSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if ("FIsAfterCurrPeriod".equals(field.getName())) {
                if (CompanyDisplayModeEnum.enumerate == this.getCond().getCompanyDisplayMode()) continue;
                if (sql.length() > 0) {
                    sql.append(",");
                }
                sql.append("ssc.fcurrperiod");
                continue;
            }
            if (field.getType() == "NUMERIC(29,10)" || "fdetailcount".equalsIgnoreCase(field.getName()) || field.getQueryField() == null) continue;
            if (sql.length() > 0) {
                sql.append(",");
            }
            int len = sql.length();
            this.appendGroupField(sql, field);
            if (len <= 0 || sql.length() != len) continue;
            sql.setLength(len - 1);
        }
        return sql.toString();
    }

    protected void appendGroupField(StringBuffer sql, GLRptField field) {
        if (!"FBalSeq".equals(field.getName()) && !this.isFunction(field.getSelect())) {
            sql.append(field.getSelect());
            if (field.isMultiLang()) {
                sql.append("_").append(this.getCtx().getLocale().toString());
            }
        }
    }

    public boolean isFunction(String field) {
        if (field == null) {
            return false;
        }
        return field.toLowerCase().matches("min[ \r\t\n]*\\({1,}.*|max[ \r\t\n]*\\({1,}.*|sum[ \r\t\n]*\\({1,}.*");
    }

    protected String getAmountSelectSQL(GLRptField field) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String ta = this.getMainTable().getAlias();
        if (this.isGroup()) {
            if (this.isGroupByPeriod()) {
                sql.append("sum(").append(ta).append(".").append(field).append(") ").append(field);
            } else if (this.getCond().getCompanyDisplayMode() != CompanyDisplayModeEnum.enumerate) {
                sql.append(this.getAmountSelectSQLForMultiCompany(field));
            } else {
                sql.append(this.getAmountSelectSQLForEnumerate(field));
            }
        } else {
            sql.append(ta).append(".").append(field).append(" ").append(field);
        }
        return sql.toString();
    }

    private String getAmountSelectSQLForEnumerate(GLRptField field) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String ta = this.getMainTable().getAlias();
        int beginPeriod = this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart();
        int endPeriod = this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd();
        int currPeriod = this.getCond().getCurrPeriod().getNumber();
        boolean isAfterPeriodIncluded = beginPeriod > currPeriod;
        String periodField = this.getMainTable().getAlias() + "." + "FPeriod";
        if (field.isBegin() || this.isPeriodBeginBalance) {
            if (isAfterPeriodIncluded) {
                sql.append("sum(case when ");
                sql.append(periodField).append(" = ").append(currPeriod).append(" then b.").append("FEnd").append(field.getBalSuffix());
                sql.append(" when ").append(periodField).append(" > ").append(currPeriod).append(" and ").append(periodField).append(" < ").append(beginPeriod).append(" then (").append(ta).append(".").append("FDebit").append(field.getSuffix());
                sql.append(" - ").append(ta).append(".").append("FCredit").append(field.getSuffix());
                sql.append(") else 0 end) ").append("FBegin").append(field.getBalSuffix()).append(" \r\n");
            } else {
                sql.append("sum(case when ");
                sql.append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(" = ").append(beginPeriod).append(" then ").append(ta).append(".").append(field).append(" else 0 end) ").append(field);
            }
        } else if (field.isEnd()) {
            if (this.getCond().getCurrPeriod().getNumber() < endPeriod) {
                sql.append("sum(case when ").append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(" = ").append(currPeriod).append(" then ").append(ta).append(".").append(field);
                sql.append(" when ").append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(">").append(currPeriod).append(" and ").append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(" <=").append(endPeriod).append(" then (").append(ta).append(".fdebit").append(field.getSuffix()).append("-").append(ta).append(".fcredit").append(field.getSuffix()).append(") else 0 end) ").append(field);
            } else {
                sql.append("sum(case when ").append(this.getMainTable().getAlias()).append(".").append("FPeriod").append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" else 0 end) ").append(field);
            }
        } else if (field.isYearDebit() || field.isYearCredit()) {
            String fieldtemp = null;
            fieldtemp = field.isYearDebit() ? "fdebit" : "fcredit";
            if (beginPeriod / 100 == endPeriod / 100) {
                sql.append("sum(case when ").append(periodField).append(" = ").append(beginPeriod);
                sql.append(" then b.").append(field).append(" when ").append(periodField).append(" > ").append(beginPeriod).append(" and ").append(periodField).append(" <= ").append(endPeriod).append(" then b.").append(fieldtemp).append(field.getSuffix()).append(" else 0 end) ").append(field).append(" \r\n");
            } else {
                int p = endPeriod / 100 * 100;
                sql.append("sum(case when ").append(periodField).append(" > ").append(p).append(" and ").append(periodField).append(" <= ").append(endPeriod).append(" then b.").append(fieldtemp).append(field.getSuffix()).append(" else 0 end) ").append(field).append(" \r\n");
            }
        } else {
            sql.append("sum(").append(" CASE WHEN ").append(ta).append(".").append("FPeriod").append(" >= ").append(beginPeriod).append(" THEN ").append(ta).append(".").append(field).append(" ELSE 0 END) ").append(field);
        }
        return sql.toString();
    }

    private String getAmountSelectSQLForMultiCompany(GLRptField field) throws EASBizException, BOSException {
        Integer startPeriod = new Integer(this.getCond().getPeriodYearStart() * 100 + this.getCond().getPeriodNumberStart());
        Integer endPeriod = new Integer(this.getCond().getPeriodYearEnd() * 100 + this.getCond().getPeriodNumberEnd());
        Integer endPeriodYear = new Integer(this.getCond().getPeriodYearEnd());
        boolean isAfterPeriodIncluded = this.getCond().isAfterCurrPeriod();
        String ta = this.getMainTable().getAlias();
        String periodField = this.getMainTable().getAlias() + "." + "FPeriod";
        StringBuffer sql = new StringBuffer();
        if (field.isBegin()) {
            sql.append(" sum(case ");
            sql.append(" when ").append(startPeriod).append(" < ssc.fstartperiod and ").append(periodField).append(" = ssc.fstartperiod then ").append(ta).append(".").append(field).append(" \r\n");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(startPeriod).append(" >= ssc.fstartperiod and ").append(startPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(startPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(startPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod then ").append(ta).append(".").append("FEnd").append(field.getBalSuffix()).append(" \r\n");
                sql.append(" when ").append(startPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" > ssc.fcurrperiod and ").append(periodField).append(" < ").append(startPeriod).append(" then (").append(ta).append(".").append("FDebit").append(field.getSuffix());
                sql.append(" - ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(") \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(startPeriod).append(" and ").append(periodField).append(" >= ssc.fstartperiod then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append("FBegin").append(field.getBalSuffix());
        } else if (field.isYearDebit()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartperiod and ").append(endPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append("> ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append("  then ").append(ta).append(".").append("FDebit").append(field.getSuffix()).append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else if (field.isYearCredit()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartperiod and ").append(endPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" > ssc.fcurrperiod and TO_INT(").append(periodField).append("/100) = ").append(endPeriodYear).append("  then ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(" \r\n").append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else if (field.isEnd()) {
            sql.append(" sum(case ");
            if (isAfterPeriodIncluded) {
                sql.append(" when ").append(endPeriod).append(" >= ssc.fstartperiod and ").append(endPeriod).append(" <= ssc.fcurrperiod and ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" = ssc.fcurrperiod  then ").append(ta).append(".").append(field).append(" \r\n");
                sql.append(" when ").append(endPeriod).append(" > ssc.fcurrperiod and ").append(periodField).append(" > ssc.fcurrperiod then ").append(ta).append(".").append("FDebit").append(field.getSuffix()).append(" - ").append(ta).append(".").append("FCredit").append(field.getSuffix()).append(" \r\n");
            } else {
                sql.append(" when ").append(periodField).append(" = ").append(endPeriod).append(" then ").append(ta).append(".").append(field).append(" \r\n");
            }
            sql.append(" else 0 end) ").append(field).append(" \r\n");
        } else {
            sql.append(" sum(case when ").append(periodField).append(" >=").append(startPeriod).append(" and ").append(periodField).append(" <= ").append(endPeriod).append(" and ").append(periodField).append(" >= ssc.fstartperiod then ").append(ta).append(".").append(field).append(" else 0 end").append(") ").append(field);
        }
        return sql.toString();
    }

    protected boolean isGroupByPeriod() {
        return this.getSelector().contains(GLRptField.period);
    }

    protected boolean isAccountPermission() throws EASBizException, BOSException {
        return this.getCond().getRptParams().useAccountPermission();
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public boolean isCreateDataTempTable() {
        return this.isCreateDataTempTable;
    }

    public void setFromBeginPeriod(boolean isFromBeginPeriod) {
        this.isFromBeginPeriod = isFromBeginPeriod;
    }

    public void setPeriodBeginBalance(boolean isPeriodBeginBalance) {
        this.isPeriodBeginBalance = isPeriodBeginBalance;
    }

    public boolean isPeriodBeginBalance() {
        return this.isPeriodBeginBalance;
    }

    public void setAmountFilter(GLRptAmountFilter amountFilter) {
        this.amountFilter = amountFilter;
    }

    public GLRptAmountFilter getAmountFilter() {
        return this.amountFilter;
    }

    public boolean isMeasureUnit() {
        return this.isMeasureUnit;
    }

    protected GLRptField getBizOrgField() {
        return GLRptField.orgUnitID;
    }

    protected GLRptFilter getOrgFilter() throws BOSException, EASBizException {
        GLRptCompanyFilter cpFilter = new GLRptCompanyFilter(this.getCond(), this.getMainTable().getAlias() + "." + GLRptField.orgUnitID);
        return cpFilter;
    }

    protected void initOrg(Context ctx, OrgUnitInfo org, GLRptBaseCondition cond, boolean isCreateDataTempTable) {
        this.company = (CompanyOrgUnitInfo)org;
    }

    protected void distinctOrgKey(Set<GLRptField> keySet) {
        if (this.getCond().getCompany().isIsBizUnit()) {
            keySet.remove(GLRptField.orgUnitID);
        }
    }

    protected String getJoinSQLSystemStatusControl() throws BOSException, EASBizException {
        String table = this.sysStatusTmpTable == null ? "(" + GLRptDaoUtil.getSystemStatusControlSQL(true) + ")" : this.sysStatusTmpTable;
        return " LEFT OUTER JOIN " + table + " ssc on b.FOrgUnitID = ssc.fcompanyid ";
    }

    static {
        fm.put(GLRptField.orgUnitID, GLRptVoucherField.companyID);
        fm.put(GLRptField.accountID, GLRptVoucherField.accountID);
        fm.put(GLRptField.accountNumberMerger, GLRptVoucherField.accountNumberMerger);
        fm.put(GLRptField.accountNameMerger, GLRptVoucherField.accountNameMerger);
        fm.put(GLRptField.accountDisplayNameMerger, GLRptVoucherField.accountDisplayNameMerger);
        fm.put(GLRptField.currencyID, GLRptVoucherField.currencyID);
        fm.put(GLRptField.period, GLRptVoucherField.period);
        fm.put(GLRptField.debitFor, GLRptVoucherField.asstRecordDebitFor);
        fm.put(GLRptField.creditFor, GLRptVoucherField.asstRecordCreditFor);
        fm.put(GLRptField.debitLocal, GLRptVoucherField.asstRecordDebitLocal);
        fm.put(GLRptField.creditLocal, GLRptVoucherField.asstRecordCreditLocal);
        fm.put(GLRptField.debitRpt, GLRptVoucherField.asstRecordDebitRpt);
        fm.put(GLRptField.creditRpt, GLRptVoucherField.asstRecordCreditRpt);
    }
}

