/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ORMappingDAOUtils;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class GLRptDaoUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil");
    public static final String custGroupDetail = "T_BD_CUSTOMERGROUPDETAIL";
    public static final String suppGroupDetail = "T_BD_SUPPLIERGROUPDETAIL";
    public static final String mateGroupDetail = "T_BD_MATERIALGROUPDETIAL";
    public static final String customerId = "fcustomerid";
    public static final String supplierId = "fsupplierid";
    public static final String materialId = "fmaterialid";
    public static final String customerGroupId = "Fcustomergroupid";
    public static final String supplierGroupId = "fsuppliergroupid";
    public static final String materialGroupId = "fmaterialgroupid";
    public static final String REPORT_RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLResource";
    public static final String AND = " and ";
    public static final String OR = " or ";

    public static String getDataPermissionSQL(Context ctx, String companyId, String permItem) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyId), permItem);
        if (StringUtils.isEmpty((String)rule)) {
            return null;
        }
        return PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyId), permItem);
    }

    public static String getEqualString(Context ctx) {
        return ResourceBase.getString((String)REPORT_RESOURCE_PATH, (String)"cell_equal", (Locale)ctx.getOriginLocale());
    }

    public static boolean isIncludeAdjustPeriod(Context ctx, GLRptBaseCondition cond, CompanyOrgUnitInfo company) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(cond.getPeriodYearEnd() * 100 + cond.getPeriodNumberEnd()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.TRUE));
        view.setFilter(filter);
        PeriodCollection pdColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        return !pdColl.isEmpty();
    }

    public static PeriodCollection getPeriodCollection(Context ctx, String periodTypeId, int beginPeriod, int endPeriod) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("periodYear"));
        view.getSelector().add(new SelectorItemInfo("periodNumber"));
        view.getSelector().add(new SelectorItemInfo("beginDate"));
        view.getSelector().add(new SelectorItemInfo("endDate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(beginPeriod), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
    }

    public static String[] set2StringArray(Set idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        String[] ids = new String[idSet.size()];
        Iterator it = idSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            ids[i++] = it.next().toString();
        }
        return ids;
    }

    public static String StringArray2String(String[] idArray) {
        if (idArray == null || idArray.length == 0) {
            return "('')";
        }
        StringBuffer idStr = new StringBuffer();
        idStr.append("('").append(idArray[0]).append("'");
        for (int i = 1; i < idArray.length; ++i) {
            idStr.append(",'").append(idArray[i]).append("'");
        }
        return idStr.append(")").toString();
    }

    public static String set2String(Set<String> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return "('')";
        }
        StringBuffer idStr = new StringBuffer();
        Iterator<String> it = idSet.iterator();
        idStr.append("('").append((Object)it.next()).append("'");
        while (it.hasNext()) {
            idStr.append(",'").append((Object)it.next()).append("'");
        }
        return idStr.append(")").toString();
    }

    public static String getField(AsstactTypeEntity at) {
        String fieldName = null;
        if ("customer".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = customerId;
        } else if ("provider".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = supplierId;
        } else if ("material".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = materialId;
        }
        return fieldName;
    }

    public static String getGroupField(AsstactTypeEntity at) {
        String fieldName = null;
        if ("customer".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = customerGroupId;
        } else if ("provider".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = supplierGroupId;
        } else if ("material".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = materialGroupId;
        }
        return fieldName;
    }

    public static String getGroupDetailTable(AsstactTypeEntity at) {
        String fieldName = null;
        if ("customer".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = custGroupDetail;
        } else if ("provider".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = suppGroupDetail;
        } else if ("material".equalsIgnoreCase(at.getHgAttribute())) {
            fieldName = mateGroupDetail;
        }
        return fieldName;
    }

    public static Set getCompanyIds(DefaultMutableTreeNode node) {
        HashSet<String> idSet = new HashSet<String>();
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            idSet.add(userObject.getCompanyId());
        }
        return idSet;
    }

    public static DefaultKingdeeTreeNode getTreeModeOfCompany(Context ctx, CompanyOrgUnitInfo unionCompany, Set companyIdSet) throws BOSException {
        String companyIdStr = GLRptDaoUtil.set2String(companyIdSet);
        return GLRptDaoUtil.getTreeModeOfCompany(ctx, unionCompany, companyIdStr);
    }

    public static DefaultKingdeeTreeNode getTreeModeOfCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        String companyIdStr = "(" + company.getDescription() + ")";
        return GLRptDaoUtil.getTreeModeOfCompany(ctx, company, companyIdStr);
    }

    private static DefaultKingdeeTreeNode getTreeModeOfCompany(Context ctx, CompanyOrgUnitInfo unionCompany, String companyIdStr) throws BOSException {
        CompanyOrgUnitInfo currCompany = unionCompany;
        DefaultKingdeeTreeNode rotNode = null;
        StringBuffer sql = new StringBuffer();
        String loc = ctx.getLocale().toString();
        sql.append("select distinct pcp.fid, pcp.fparentid, pcp.fnumber, pcp.fname_").append(loc).append(" fname, pcp.flongNumber,pcp.flevel,pcp.fisbizunit \r\n");
        sql.append(" from t_org_company cp  \r\n");
        if (SQLUtil.isSupportCharIndexToLike(ctx)) {
            sql.append(" inner join t_org_company pcp on (cp.flongnumber like concat(pcp.flongnumber, '!%') or pcp.fid = cp.fid) ");
        } else {
            sql.append(" inner join t_org_company pcp on (charindex(pcp.flongnumber || '!', cp.flongnumber)=1 or pcp.fid = cp.fid) ");
        }
        sql.append(" where cp.fid in ").append(companyIdStr).append(" and pcp.flevel >=").append(currCompany.getLevel());
        sql.append(" order by pcp.flongnumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        DefaultKingdeeTreeNode lastNode = null;
        try {
            while (rs.next()) {
                SimpleCompanyUserObject obj = new SimpleCompanyUserObject();
                obj.setCompanyId(rs.getString("fid"));
                obj.setName(rs.getString("fname"));
                obj.setNumber(rs.getString("fnumber"));
                obj.setLongNumber(rs.getString("flongnumber"));
                obj.setLevel(rs.getInt("flevel") - currCompany.getLevel());
                obj.setLeaf(rs.getBoolean("fisbizunit"));
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
                node.setUserObject((Object)obj);
                if (lastNode != null) {
                    if (((SimpleCompanyUserObject)lastNode.getUserObject()).getCompanyId().equalsIgnoreCase(rs.getString("fparentid"))) {
                        lastNode.add((MutableTreeNode)node);
                    } else {
                        while (lastNode.getParent() != null) {
                            SimpleCompanyUserObject lastObj = (SimpleCompanyUserObject)(lastNode = (DefaultKingdeeTreeNode)lastNode.getParent()).getUserObject();
                            if (!lastObj.getCompanyId().equals(rs.getString("fparentid"))) continue;
                            lastNode.add((MutableTreeNode)node);
                            break;
                        }
                    }
                } else {
                    rotNode = node;
                }
                lastNode = node;
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR", (Throwable)e);
        }
        return rotNode;
    }

    public static String getDataPermSqlFilter(Context ctx, CompanyDisplayModeEnum companyDisplayMode, CompanyOrgUnitInfo company, String companyIds, String strPermItem, boolean isPermissionByCU, String field, String fieldCompany) throws EASBizException, BOSException {
        String permSql = null;
        if (CompanyDisplayModeEnum.merger == companyDisplayMode) {
            permSql = GLRptDaoUtil.getDataPermSql4Merger(ctx, companyIds, strPermItem, isPermissionByCU, field, fieldCompany);
            if (permSql != null) {
                return "(" + permSql + ")";
            }
        } else {
            String permOrgId = "";
            permOrgId = isPermissionByCU ? company.getCU().getId().toString() : company.getId().toString();
            permSql = GLRptDaoUtil.getDataPermissionSQL(ctx, permOrgId, strPermItem);
            if (permSql != null) {
                return field + " in (" + permSql + ")";
            }
        }
        return null;
    }

    public static Map getDataPermSqlCompanyIdMap(Context ctx, String companyIds, String strPermItem, boolean isPermissionByCU) throws EASBizException, BOSException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, strPermItem);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        HashMap<String, HashSet<String>> mapPerm = new HashMap<String, HashSet<String>>();
        String orgField = isPermissionByCU ? "CP.FID" : "UserOrgPerm.FOrgID";
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT PM.FRuleExpr, CP.FID FOrgID FROM T_ORG_COMPANY CP LEFT OUTER JOIN (");
        sql.append(" SELECT UserOrgPerm.FRuleExpr,").append(orgField).append(" FOrgID");
        sql.append(" FROM T_PM_UserOrgPerm USERORGPERM ");
        if (isPermissionByCU) {
            sql.append(" INNER JOIN T_ORG_COMPANY CP ON CP.fcontrolunitid = UserOrgPerm.FOrgID ");
        }
        sql.append(" WHERE UserOrgPerm.FOwner = ? AND ").append(orgField).append(" IN ").append(companyIds).append(" AND ");
        sql.append(" USERORGPERM.FPermItemID = ? ");
        sql.append(" AND UserOrgPerm.FPermType = 10 ");
        sql.append(" UNION ALL ");
        orgField = isPermissionByCU ? "CP.FID" : "UserRoleOrg.FOrgID";
        sql.append(" SELECT RolePerm.FRuleExpr,").append(orgField).append(" FOrgID");
        sql.append(" FROM T_PM_RolePerm ROLEPERM ");
        sql.append(" INNER JOIN T_PM_UserRoleOrg USERROLEORG ON UserRoleOrg.FRoleID = RolePerm.FRoleID ");
        if (isPermissionByCU) {
            sql.append(" INNER JOIN T_ORG_COMPANY CP ON CP.fcontrolunitid = UserRoleOrg.FOrgID ");
        }
        sql.append(" WHERE UserRoleOrg.FUserID = ? AND ").append(orgField).append(" IN ").append(companyIds).append(" AND ");
        sql.append(" RolePerm.FPermItemID = ? AND RolePerm.FPermType = 10");
        sql.append(") PM on PM.FOrgID = CP.FID WHERE CP.FID IN ").append(companyIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, permItemInfo.getId().toString(), userId, permItemInfo.getId().toString()});
        try {
            while (rs.next()) {
                String ruleExpr = rs.getString("FRuleExpr");
                HashSet<String> companyIdSet = (HashSet<String>)mapPerm.get(ruleExpr);
                if (companyIdSet == null) {
                    companyIdSet = new HashSet<String>();
                    mapPerm.put(ruleExpr, companyIdSet);
                }
                companyIdSet.add(rs.getString("FOrgID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> mapPermSql = new HashMap<String, String>();
        for (String rule : mapPerm.keySet()) {
            Set cpIdSet = (Set)mapPerm.get(rule);
            if (StringUtils.isEmpty((String)rule)) {
                mapPermSql.put(null, GLRptDaoUtil.set2String(cpIdSet));
                continue;
            }
            String ruleSql = ORMappingDAOUtils.getSQLByOQL((BOSObjectType)BOSObjectType.create((String)permItemInfo.getObjectType()), (String)("select id " + rule), (Context)ctx);
            mapPermSql.put(ruleSql, GLRptDaoUtil.set2String(cpIdSet));
        }
        return mapPermSql;
    }

    public static String getDataPermSql4Merger(Context ctx, String companyIds, String strPermItem, boolean isPermissionByCU, String field, String fieldCompany) throws EASBizException, BOSException {
        String permSql = null;
        boolean hasOneDataPermRule = false;
        StringBuffer sqlWhereAllCompany = new StringBuffer();
        Map mapPermSql = GLRptDaoUtil.getDataPermSqlCompanyIdMap(ctx, companyIds, strPermItem, isPermissionByCU);
        for (Map.Entry entry : mapPermSql.entrySet()) {
            String onePermSql = entry.getKey() == null ? null : (String)entry.getKey();
            String cpIds = (String)entry.getValue();
            if (sqlWhereAllCompany.length() > 0) {
                sqlWhereAllCompany.append(OR);
            }
            sqlWhereAllCompany.append(fieldCompany).append(" in ").append(cpIds);
            if (StringUtils.isEmpty((String)onePermSql)) continue;
            hasOneDataPermRule = true;
            sqlWhereAllCompany.append(AND).append(field).append(" in (").append(onePermSql).append(")");
        }
        if (hasOneDataPermRule) {
            permSql = sqlWhereAllCompany.toString();
        }
        return permSql;
    }

    public static String getDataPermFilter(Context ctx, CompanyDisplayModeEnum companyDisplayMode, CompanyOrgUnitInfo company, String companyIds, String strPermItem, boolean isPermissionByCU, String field, String fieldCompany) throws EASBizException, BOSException {
        String permSql = null;
        if (CompanyDisplayModeEnum.merger == companyDisplayMode) {
            permSql = GLRptDaoUtil.getDataPermFilter4Merger(ctx, companyIds, strPermItem, isPermissionByCU, field, fieldCompany);
        } else {
            String permOrgId = "";
            permOrgId = isPermissionByCU ? company.getCU().getId().toString() : company.getId().toString();
            permSql = GLRptDaoUtil.getDataPermissionSQL(ctx, permOrgId, strPermItem);
            if (permSql != null) {
                permSql = field + " in (" + permSql + ")";
            }
        }
        return permSql;
    }

    public static String getDataPermFilter4Merger(Context ctx, String companyIds, String strPermItem, boolean isPermissionByCU, String field, String fieldCompany) throws EASBizException, BOSException {
        boolean hasOneDataPermRule = false;
        StringBuffer sql = new StringBuffer();
        Map mapPermSql = GLRptDaoUtil.getDataPermSqlCompanyIdMap(ctx, companyIds, strPermItem, isPermissionByCU);
        for (Map.Entry entry : mapPermSql.entrySet()) {
            String onePermSql = entry.getKey() == null ? null : (String)entry.getKey();
            String cpIds = (String)entry.getValue();
            if (sql.length() > 0) {
                sql.append(OR);
            }
            sql.append("(");
            sql.append(fieldCompany).append(" in ").append(cpIds);
            if (!StringUtils.isEmpty((String)onePermSql)) {
                hasOneDataPermRule = true;
                sql.append(AND).append(field).append(" in (").append(onePermSql).append(")");
            }
            sql.append(")");
        }
        if (hasOneDataPermRule) {
            return "(" + sql.toString() + ")";
        }
        return null;
    }

    public static boolean checkIfPermissionByCU(Context ctx, String strPermItem) throws BOSException, EASBizException {
        boolean isPermissionByCU = false;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgRelation"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)strPermItem));
        evi.setFilter(filter);
        evi.setSelector(sic);
        IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
        PermItemCollection permItemCollection = iPermItem.getPermItemCollection(evi);
        PermItemInfo permItemInfo = permItemCollection.get(0);
        if (permItemInfo.getOrgRelation() == OrgType.ControlUnit) {
            isPermissionByCU = true;
        }
        return isPermissionByCU;
    }

    public static String createIdTempTable(Context ctx, String idFiledName, Set idSet) throws BOSException {
        String tempTable = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table tempTable (");
        createSql.append(idFiledName).append(" varchar(44))");
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql.toString());
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tempTable).append(" values (?)");
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            Iterator it = idSet.iterator();
            while (it.hasNext()) {
                stmt.setString(1, it.next().toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                if (tempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
                throw new BOSException("SQL error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return tempTable;
    }

    public static String createIdTempTable(Context ctx, Set idSet) throws BOSException {
        String tempTable = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            tempTable = GLTempTableUtil.createDBSysTempTable(ctx, "FID varchar(44)");
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tempTable).append(" values (?)");
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            Iterator it = idSet.iterator();
            while (it.hasNext()) {
                stmt.setString(1, it.next().toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                if (tempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
                throw new BOSException("SQL error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return tempTable;
    }

    public static Set<String> getMoreBeginPeriodCompanyIds(Context ctx, String companyId, int startPeriodYear, int startPeriodNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ssc.fcompanyid ");
        sql.append(" from t_bd_SystemStatusCtrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        sql.append(" inner join t_bd_period cpd on cpd.fid = ssc.fcurrentperiodid ");
        sql.append(" where ssc.fcompanyid in ").append(companyId);
        sql.append(" and cpd.fnumber >= ?");
        HashSet<String> companyIds = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{startPeriodYear * 100 + startPeriodNumber});
        try {
            while (rs.next()) {
                companyIds.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyIds;
    }

    public static Map<Integer, Set<String>> getLessBeginPeriodCompanyIds(Context ctx, String companyId, int startPeriodYear, int startPeriodNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select cpd.fnumber period, ssc.fcompanyid ");
        sql.append(" from t_bd_SystemStatusCtrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        sql.append(" inner join t_bd_period cpd on cpd.fid = ssc.fcurrentperiodid ");
        sql.append(" where ssc.fcompanyid in ").append(companyId);
        sql.append(" and cpd.fnumber < ? order by cpd.fnumber");
        HashMap<Integer, HashSet<String>> cpPdMap = new HashMap<Integer, HashSet<String>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{startPeriodYear * 100 + startPeriodNumber});
        try {
            while (rs.next()) {
                int period = rs.getInt("period");
                HashSet<String> companyIds = (HashSet<String>)cpPdMap.get(period);
                if (companyIds == null) {
                    companyIds = new HashSet<String>();
                    cpPdMap.put(period, companyIds);
                }
                companyIds.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<Integer, Set<String>> pdCpIds = new HashMap<Integer, Set<String>>();
        Iterator it = cpPdMap.keySet().iterator();
        while (it.hasNext()) {
            int period = (Integer)it.next();
            Set companyIds = (Set)cpPdMap.get(period);
            pdCpIds.put(period, companyIds);
        }
        return pdCpIds;
    }

    public static String getSystemStatusControlSQL(boolean isIncludeStartPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ssc.fcompanyid, ");
        if (isIncludeStartPeriod) {
            sql.append(" startPeriod.fnumber fstartperiod, ");
        }
        sql.append(" currPeriod.fnumber fcurrperiod ");
        sql.append(" from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        if (isIncludeStartPeriod) {
            sql.append(" inner join t_bd_period startPeriod ON startPeriod.fid = ssc.fstartperiodid ");
        }
        sql.append(" inner join t_bd_period currPeriod ON currPeriod.fid = ssc.fcurrentperiodid ");
        return sql.toString();
    }

    public static String createSysStatusTmpTable(Context ctx, GLRptBaseCondition cond) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ssc.fcompanyid, spd.fnumber fstartPeriod, cpd.fnumber fcurrPeriod");
        sql.append(" from t_bd_SystemStatusCtrol ssc");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        sql.append(" inner join t_bd_period spd on spd.fid = ssc.fstartperiodid ");
        sql.append(" inner join t_bd_period cpd on cpd.fid = ssc.fcurrentperiodid ");
        sql.append(" where ssc.fcompanyid in ").append(cond.getCompanyIdsStr());
        String sysStatusTmpTable = GLTempTableUtil.createDBSysTempTable(ctx, "fcompanyid varchar(44), fstartPeriod INT, fcurrPeriod INT");
        DbUtil.execute((Context)ctx, (String)("INSERT INTO " + sysStatusTmpTable + sql.toString()));
        return sysStatusTmpTable;
    }

    public static String getIdFilter(Context ctx, Set<String> idSet) throws BOSException {
        if (idSet.size() > 500) {
            String companyIDTempTable = GLRptDaoUtil.createIdTempTable(ctx, idSet);
            return "(select fid from " + companyIDTempTable + ")";
        }
        if (idSet.isEmpty()) {
            return null;
        }
        return GLRptDaoUtil.set2String(idSet);
    }

    public static boolean getBoolean(String value) {
        return GLRptDaoUtil.getBoolean(value, true);
    }

    public static boolean getBoolean(String value, boolean def) {
        if (value == null || value.trim().length() == 0) {
            return def;
        }
        value = value.trim();
        return "true".equalsIgnoreCase(value);
    }

    public static String getAsstLimitCondition(Context ctx, List asstActList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (asstActList.isEmpty()) {
            return sql.toString();
        }
        AsstactTypeEntity at = null;
        Iterator it = asstActList.iterator();
        StringBuffer hgFilter = new StringBuffer();
        while (it.hasNext()) {
            at = (AsstactTypeEntity)it.next();
            if (at.getFrom() == null && at.getTo() == null && at.getDist() == null) continue;
            if (hgFilter.length() > 0) {
                hgFilter.append(AND);
            }
            hgFilter.append("assGrp." + at.getHgField()).append(" in (");
            hgFilter.append(GLRptDaoUtil.getAssistItemFilterSQL(ctx, at)).append(") ");
        }
        if (!hgFilter.toString().isEmpty()) {
            sql.append(" select assGrp.fid from t_bd_assistanthg assGrp where ");
            sql.append(hgFilter);
        }
        return sql.toString();
    }

    public static String getActLongNumber(boolean useLongNumber, Object value) throws BOSException, EASBizException {
        if (value instanceof DataBaseInfo) {
            DataBaseInfo obj = (DataBaseInfo)value;
            if (useLongNumber) {
                return obj.get("longnumber").toString();
            }
            return obj.get("number").toString();
        }
        return value.toString();
    }

    public static String getAssistItemFilterSQL(Context ctx, AsstactTypeEntity at) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(at.getHgAttribute()).append(".fid from ").append(at.getTableName()).append(" ").append(at.getHgAttribute());
        boolean f = false;
        if (at.isGeneralActType()) {
            sql.append(" where ");
            f = true;
            sql.append(at.getHgAttribute()).append(".FGroupID= '").append(at.getGeneralAsstactGroupId()).append("'");
        }
        Object[] assists = null;
        Object dist = at.getDist();
        if (dist instanceof List) {
            assists = ((List)dist).toArray();
        } else if (dist instanceof Set) {
            assists = ((Set)dist).toArray();
        }
        if (assists != null && assists.length > 0) {
            boolean isGeneralActType;
            sql.append(f ? AND : " where ");
            boolean bl = isGeneralActType = at.getHgAttribute() != null && at.getHgAttribute().startsWith("generalAssActType");
            if (isGeneralActType) {
                sql.append(at.getHgAttribute()).append(".").append("flongnumber").append(" in (");
            } else {
                sql.append(at.getHgAttribute()).append(".").append("fnumber").append(" in (");
            }
            Object obj = null;
            String number = null;
            for (int i = 0; i < assists.length; ++i) {
                obj = assists[i];
                number = obj instanceof AssistViewFilterInfo ? ((AssistViewFilterInfo)obj).getNumber() : (obj instanceof Map ? (String)((Map)obj).get("number") : (String)obj);
                if (isGeneralActType && number != null) {
                    number = number.replace(".", "!");
                }
                sql.append("'").append(number).append("', ");
            }
            sql.deleteCharAt(sql.lastIndexOf(",")).append(")");
        } else {
            DataBaseInfo toValue;
            DataBaseInfo fromValue = (DataBaseInfo)at.getFrom();
            if (fromValue != null) {
                DataBaseInfo data;
                boolean useLongNumber;
                if (at.isGeneralActType()) {
                    ObjectUuidPK pk = new ObjectUuidPK(fromValue.getId());
                    fromValue = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)pk);
                }
                sql.append(f ? AND : " where ");
                if (!f) {
                    f = true;
                }
                if ((useLongNumber = GLRptDaoUtil.isUseLongNumber(at, fromValue)) && fromValue.get("longnumber") == null && (data = GlUtils.findAsstActObject(ctx, at.getHgAttribute(), fromValue.getString("id"))) != null) {
                    fromValue = data;
                }
                if (!useLongNumber && fromValue.get("number") == null && (data = GlUtils.findAsstActObject(ctx, at.getHgAttribute(), fromValue.getString("id"))) != null) {
                    fromValue = data;
                }
                String fromNumber = GLRptDaoUtil.getActLongNumber(useLongNumber, fromValue);
                sql.append(at.getHgAttribute()).append(".").append(useLongNumber ? "flongnumber" : "fnumber").append(" >= '").append(fromNumber).append("'");
            }
            if ((toValue = (DataBaseInfo)at.getTo()) != null) {
                DataBaseInfo data;
                if (at.isGeneralActType()) {
                    ObjectUuidPK pk = new ObjectUuidPK(toValue.getId());
                    toValue = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)pk);
                }
                sql.append(f ? AND : " where ");
                boolean useLongNumber = GLRptDaoUtil.isUseLongNumber(at, toValue);
                if (useLongNumber && toValue.get("longnumber") == null && (data = GlUtils.findAsstActObject(ctx, at.getHgAttribute(), toValue.getString("id"))) != null) {
                    toValue = data;
                }
                if (!useLongNumber && toValue.get("number") == null && (data = GlUtils.findAsstActObject(ctx, at.getHgAttribute(), toValue.getString("id"))) != null) {
                    toValue = data;
                }
                String toNumber = GLRptDaoUtil.getActLongNumber(useLongNumber, toValue);
                if (at.isUseLevel() && toValue.getString("isLeaf") != null && !"true".equals(toValue.getString("isLeaf"))) {
                    toNumber = toNumber + "Z";
                }
                sql.append(at.getHgAttribute()).append(".").append(useLongNumber ? "flongnumber" : "fnumber").append(" <= '").append(toNumber).append("'");
            }
        }
        return sql.toString();
    }

    public static boolean isUseLongNumber(AsstactTypeEntity at, DataBaseInfo value) throws EASBizException, BOSException {
        return at.isUseLongNumber() || at.isUseLevel() && !value.getBoolean("isLeaf");
    }
}

